// Code generated by gen_tests.py and process_polyglot.py.
// Do not edit this file directly.
// The template for this file is located at:
// ../template.go.tpl
package reql_tests

import (
	"testing"
	"time"

	"github.com/stretchr/testify/suite"
	r "gopkg.in/rethinkdb/rethinkdb-go.v6"
	"gopkg.in/rethinkdb/rethinkdb-go.v6/internal/compare"
)

// Tests of converstion to and from the RQL string type
func TestDatumStringSuite(t *testing.T) {
	suite.Run(t, new(DatumStringSuite))
}

type DatumStringSuite struct {
	suite.Suite

	session *r.Session
}

func (suite *DatumStringSuite) SetupTest() {
	suite.T().Log("Setting up DatumStringSuite")
	// Use imports to prevent errors
	_ = time.Time{}
	_ = compare.AnythingIsFine

	session, err := r.Connect(r.ConnectOpts{
		Address: url,
	})
	suite.Require().NoError(err, "Error returned when connecting to server")
	suite.session = session

	r.DBDrop("db_dstr").Exec(suite.session)
	err = r.DBCreate("db_dstr").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("db_dstr").Wait().Exec(suite.session)
	suite.Require().NoError(err)

}

func (suite *DatumStringSuite) TearDownSuite() {
	suite.T().Log("Tearing down DatumStringSuite")

	if suite.session != nil {
		r.DB("rethinkdb").Table("_debug_scratch").Delete().Exec(suite.session)
		r.DBDrop("db_dstr").Exec(suite.session)

		suite.session.Close()
	}
}

func (suite *DatumStringSuite) TestCases() {
	suite.T().Log("Running DatumStringSuite: Tests of converstion to and from the RQL string type")

	// datum/string.yaml line #7
	// japanese_hello = u'こんにちは'
	suite.T().Log("Possibly executing: var japanese_hello string = 'こんにちは'")

	japanese_hello := "こんにちは"
	_ = japanese_hello // Prevent any noused variable errors

	{
		// datum/string.yaml line #16
		/* "str" */
		var expected_ string = "str"
		/* r.expr('str') */

		suite.T().Log("About to run line #16: r.Expr('str')")

		runAndAssert(suite.Suite, expected_, r.Expr("str"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #16")
	}

	{
		// datum/string.yaml line #21
		/* "str" */
		var expected_ string = "str"
		/* r.expr("str") */

		suite.T().Log("About to run line #21: r.Expr('str')")

		runAndAssert(suite.Suite, expected_, r.Expr("str"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #21")
	}

	{
		// datum/string.yaml line #28
		/* 'str' */
		var expected_ string = "str"
		/* r.expr(u'str') */

		suite.T().Log("About to run line #28: r.Expr('str')")

		runAndAssert(suite.Suite, expected_, r.Expr("str"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #28")
	}

	{
		// datum/string.yaml line #35
		/* u'こんにちは' */
		var expected_ string = "こんにちは"
		/* r.expr(japanese_hello) */

		suite.T().Log("About to run line #35: r.Expr(japanese_hello)")

		runAndAssert(suite.Suite, expected_, r.Expr(japanese_hello), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #35")
	}

	{
		// datum/string.yaml line #43
		/* 'STRING' */
		var expected_ string = "STRING"
		/* r.expr('foo').type_of() */

		suite.T().Log("About to run line #43: r.Expr('foo').TypeOf()")

		runAndAssert(suite.Suite, expected_, r.Expr("foo").TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #43")
	}

	{
		// datum/string.yaml line #47
		/* 'foo' */
		var expected_ string = "foo"
		/* r.expr('foo').coerce_to('string') */

		suite.T().Log("About to run line #47: r.Expr('foo').CoerceTo('string')")

		runAndAssert(suite.Suite, expected_, r.Expr("foo").CoerceTo("string"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #47")
	}

	{
		// datum/string.yaml line #49
		/* -1.2 */
		var expected_ float64 = -1.2
		/* r.expr('-1.2').coerce_to('NUMBER') */

		suite.T().Log("About to run line #49: r.Expr('-1.2').CoerceTo('NUMBER')")

		runAndAssert(suite.Suite, expected_, r.Expr("-1.2").CoerceTo("NUMBER"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #49")
	}

	{
		// datum/string.yaml line #51
		/* err("ReqlQueryLogicError", "Could not coerce `--1.2` to NUMBER.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Could not coerce `--1.2` to NUMBER.")
		/* r.expr('--1.2').coerce_to('NUMBER') */

		suite.T().Log("About to run line #51: r.Expr('--1.2').CoerceTo('NUMBER')")

		runAndAssert(suite.Suite, expected_, r.Expr("--1.2").CoerceTo("NUMBER"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #51")
	}

	{
		// datum/string.yaml line #53
		/* err("ReqlQueryLogicError", "Could not coerce `-1.2-` to NUMBER.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Could not coerce `-1.2-` to NUMBER.")
		/* r.expr('-1.2-').coerce_to('NUMBER') */

		suite.T().Log("About to run line #53: r.Expr('-1.2-').CoerceTo('NUMBER')")

		runAndAssert(suite.Suite, expected_, r.Expr("-1.2-").CoerceTo("NUMBER"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #53")
	}

	{
		// datum/string.yaml line #55
		/* 10 */
		var expected_ int = 10
		/* r.expr('0xa').coerce_to('NUMBER') */

		suite.T().Log("About to run line #55: r.Expr('0xa').CoerceTo('NUMBER')")

		runAndAssert(suite.Suite, expected_, r.Expr("0xa").CoerceTo("NUMBER"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #55")
	}

	{
		// datum/string.yaml line #57
		/* err("ReqlQueryLogicError", "Non-finite number: inf", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Non-finite number: inf")
		/* r.expr('inf').coerce_to('NUMBER') */

		suite.T().Log("About to run line #57: r.Expr('inf').CoerceTo('NUMBER')")

		runAndAssert(suite.Suite, expected_, r.Expr("inf").CoerceTo("NUMBER"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #57")
	}

	{
		// datum/string.yaml line #61
		/* 13 */
		var expected_ int = 13
		/* r.expr('hello, world!').count() */

		suite.T().Log("About to run line #61: r.Expr('hello, world!').Count()")

		runAndAssert(suite.Suite, expected_, r.Expr("hello, world!").Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #61")
	}

	{
		// datum/string.yaml line #63
		/* 5 */
		var expected_ int = 5
		/* r.expr(japanese_hello).count() */

		suite.T().Log("About to run line #63: r.Expr(japanese_hello).Count()")

		runAndAssert(suite.Suite, expected_, r.Expr(japanese_hello).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #63")
	}

	{
		// datum/string.yaml line #67
		/* 'ello' */
		var expected_ string = "ello"
		/* r.expr('hello').slice(1) */

		suite.T().Log("About to run line #67: r.Expr('hello').Slice(1)")

		runAndAssert(suite.Suite, expected_, r.Expr("hello").Slice(1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #67")
	}

	{
		// datum/string.yaml line #69
		/* 'o' */
		var expected_ string = "o"
		/* r.expr('hello').slice(-1) */

		suite.T().Log("About to run line #69: r.Expr('hello').Slice(-1)")

		runAndAssert(suite.Suite, expected_, r.Expr("hello").Slice(-1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #69")
	}

	{
		// datum/string.yaml line #71
		/* 'el' */
		var expected_ string = "el"
		/* r.expr('hello').slice(-4,3) */

		suite.T().Log("About to run line #71: r.Expr('hello').Slice(-4, 3)")

		runAndAssert(suite.Suite, expected_, r.Expr("hello").Slice(-4, 3), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #71")
	}

	{
		// datum/string.yaml line #73
		/* 'hello' */
		var expected_ string = "hello"
		/* r.expr('hello').slice(-99) */

		suite.T().Log("About to run line #73: r.Expr('hello').Slice(-99)")

		runAndAssert(suite.Suite, expected_, r.Expr("hello").Slice(-99), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #73")
	}

	{
		// datum/string.yaml line #75
		/* 'hello' */
		var expected_ string = "hello"
		/* r.expr('hello').slice(0) */

		suite.T().Log("About to run line #75: r.Expr('hello').Slice(0)")

		runAndAssert(suite.Suite, expected_, r.Expr("hello").Slice(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #75")
	}

	{
		// datum/string.yaml line #77
		/* u'んにちは' */
		var expected_ string = "んにちは"
		/* r.expr(japanese_hello).slice(1) */

		suite.T().Log("About to run line #77: r.Expr(japanese_hello).Slice(1)")

		runAndAssert(suite.Suite, expected_, r.Expr(japanese_hello).Slice(1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #77")
	}

	{
		// datum/string.yaml line #84
		/* u'ん' */
		var expected_ string = "ん"
		/* r.expr(japanese_hello).slice(1,2) */

		suite.T().Log("About to run line #84: r.Expr(japanese_hello).Slice(1, 2)")

		runAndAssert(suite.Suite, expected_, r.Expr(japanese_hello).Slice(1, 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #84")
	}

	{
		// datum/string.yaml line #91
		/* u'にちは' */
		var expected_ string = "にちは"
		/* r.expr(japanese_hello).slice(-3) */

		suite.T().Log("About to run line #91: r.Expr(japanese_hello).Slice(-3)")

		runAndAssert(suite.Suite, expected_, r.Expr(japanese_hello).Slice(-3), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #91")
	}

	{
		// datum/string.yaml line #100
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* r.expr('').split() */

		suite.T().Log("About to run line #100: r.Expr('').Split()")

		runAndAssert(suite.Suite, expected_, r.Expr("").Split(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #100")
	}

	{
		// datum/string.yaml line #102
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* r.expr('').split(null) */

		suite.T().Log("About to run line #102: r.Expr('').Split(nil)")

		runAndAssert(suite.Suite, expected_, r.Expr("").Split(nil), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #102")
	}

	{
		// datum/string.yaml line #104
		/* [''] */
		var expected_ []interface{} = []interface{}{""}
		/* r.expr('').split(' ') */

		suite.T().Log("About to run line #104: r.Expr('').Split(' ')")

		runAndAssert(suite.Suite, expected_, r.Expr("").Split(" "), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #104")
	}

	{
		// datum/string.yaml line #106
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* r.expr('').split('') */

		suite.T().Log("About to run line #106: r.Expr('').Split('')")

		runAndAssert(suite.Suite, expected_, r.Expr("").Split(""), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #106")
	}

	{
		// datum/string.yaml line #108
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* r.expr('').split(null, 5) */

		suite.T().Log("About to run line #108: r.Expr('').Split(nil, 5)")

		runAndAssert(suite.Suite, expected_, r.Expr("").Split(nil, 5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #108")
	}

	{
		// datum/string.yaml line #110
		/* [''] */
		var expected_ []interface{} = []interface{}{""}
		/* r.expr('').split(' ', 5) */

		suite.T().Log("About to run line #110: r.Expr('').Split(' ', 5)")

		runAndAssert(suite.Suite, expected_, r.Expr("").Split(" ", 5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #110")
	}

	{
		// datum/string.yaml line #112
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* r.expr('').split('', 5) */

		suite.T().Log("About to run line #112: r.Expr('').Split('', 5)")

		runAndAssert(suite.Suite, expected_, r.Expr("").Split("", 5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #112")
	}

	{
		// datum/string.yaml line #115
		/* ['aaaa', 'bbbb', 'cccc'] */
		var expected_ []interface{} = []interface{}{"aaaa", "bbbb", "cccc"}
		/* r.expr('aaaa bbbb  cccc ').split() */

		suite.T().Log("About to run line #115: r.Expr('aaaa bbbb  cccc ').Split()")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #115")
	}

	{
		// datum/string.yaml line #117
		/* ['aaaa', 'bbbb', 'cccc'] */
		var expected_ []interface{} = []interface{}{"aaaa", "bbbb", "cccc"}
		/* r.expr('aaaa bbbb  cccc ').split(null) */

		suite.T().Log("About to run line #117: r.Expr('aaaa bbbb  cccc ').Split(nil)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split(nil), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #117")
	}

	{
		// datum/string.yaml line #119
		/* ['aaaa', 'bbbb', '', 'cccc', ''] */
		var expected_ []interface{} = []interface{}{"aaaa", "bbbb", "", "cccc", ""}
		/* r.expr('aaaa bbbb  cccc ').split(' ') */

		suite.T().Log("About to run line #119: r.Expr('aaaa bbbb  cccc ').Split(' ')")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split(" "), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #119")
	}

	{
		// datum/string.yaml line #121
		/* ['a', 'a', 'a', 'a', ' ', 'b', 'b', 'b', 'b', ' ', ' ', 'c', 'c', 'c', 'c', ' '] */
		var expected_ []interface{} = []interface{}{"a", "a", "a", "a", " ", "b", "b", "b", "b", " ", " ", "c", "c", "c", "c", " "}
		/* r.expr('aaaa bbbb  cccc ').split('') */

		suite.T().Log("About to run line #121: r.Expr('aaaa bbbb  cccc ').Split('')")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split(""), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #121")
	}

	{
		// datum/string.yaml line #123
		/* ['aaaa ', '', '', '', '  cccc '] */
		var expected_ []interface{} = []interface{}{"aaaa ", "", "", "", "  cccc "}
		/* r.expr('aaaa bbbb  cccc ').split('b') */

		suite.T().Log("About to run line #123: r.Expr('aaaa bbbb  cccc ').Split('b')")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split("b"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #123")
	}

	{
		// datum/string.yaml line #125
		/* ['aaaa ', '', '  cccc '] */
		var expected_ []interface{} = []interface{}{"aaaa ", "", "  cccc "}
		/* r.expr('aaaa bbbb  cccc ').split('bb') */

		suite.T().Log("About to run line #125: r.Expr('aaaa bbbb  cccc ').Split('bb')")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split("bb"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #125")
	}

	{
		// datum/string.yaml line #127
		/* ['aaaa', 'cccc '] */
		var expected_ []interface{} = []interface{}{"aaaa", "cccc "}
		/* r.expr('aaaa bbbb  cccc ').split(' bbbb  ') */

		suite.T().Log("About to run line #127: r.Expr('aaaa bbbb  cccc ').Split(' bbbb  ')")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split(" bbbb  "), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #127")
	}

	{
		// datum/string.yaml line #129
		/* ['aaaa ', '', '  cccc b d ', ' e ', '', ' f'] */
		var expected_ []interface{} = []interface{}{"aaaa ", "", "  cccc b d ", " e ", "", " f"}
		/* r.expr('aaaa bbbb  cccc b d bb e bbbb f').split('bb') */

		suite.T().Log("About to run line #129: r.Expr('aaaa bbbb  cccc b d bb e bbbb f').Split('bb')")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc b d bb e bbbb f").Split("bb"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #129")
	}

	{
		// datum/string.yaml line #131
		/* ['aaaa', 'cccc b d bb e bbbb f'] */
		var expected_ []interface{} = []interface{}{"aaaa", "cccc b d bb e bbbb f"}
		/* r.expr('aaaa bbbb  cccc b d bb e bbbb f').split(' bbbb  ') */

		suite.T().Log("About to run line #131: r.Expr('aaaa bbbb  cccc b d bb e bbbb f').Split(' bbbb  ')")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc b d bb e bbbb f").Split(" bbbb  "), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #131")
	}

	{
		// datum/string.yaml line #133
		/* ['aaaa', 'cccc b d bb e', 'f'] */
		var expected_ []interface{} = []interface{}{"aaaa", "cccc b d bb e", "f"}
		/* r.expr('aaaa bbbb  cccc b d bb e bbbb  f').split(' bbbb  ') */

		suite.T().Log("About to run line #133: r.Expr('aaaa bbbb  cccc b d bb e bbbb  f').Split(' bbbb  ')")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc b d bb e bbbb  f").Split(" bbbb  "), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #133")
	}

	{
		// datum/string.yaml line #136
		/* ['aaaa', 'bbbb', 'cccc'] */
		var expected_ []interface{} = []interface{}{"aaaa", "bbbb", "cccc"}
		/* r.expr('aaaa bbbb  cccc ').split(null, 3) */

		suite.T().Log("About to run line #136: r.Expr('aaaa bbbb  cccc ').Split(nil, 3)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split(nil, 3), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #136")
	}

	{
		// datum/string.yaml line #138
		/* ['aaaa', 'bbbb', '', 'cccc', ''] */
		var expected_ []interface{} = []interface{}{"aaaa", "bbbb", "", "cccc", ""}
		/* r.expr('aaaa bbbb  cccc ').split(' ', 5) */

		suite.T().Log("About to run line #138: r.Expr('aaaa bbbb  cccc ').Split(' ', 5)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split(" ", 5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #138")
	}

	{
		// datum/string.yaml line #140
		/* ['a', 'a', 'a', 'a', ' ', 'bbbb  cccc '] */
		var expected_ []interface{} = []interface{}{"a", "a", "a", "a", " ", "bbbb  cccc "}
		/* r.expr('aaaa bbbb  cccc ').split('', 5) */

		suite.T().Log("About to run line #140: r.Expr('aaaa bbbb  cccc ').Split('', 5)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split("", 5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #140")
	}

	{
		// datum/string.yaml line #142
		/* ['aaaa ', '', '', '', '  cccc '] */
		var expected_ []interface{} = []interface{}{"aaaa ", "", "", "", "  cccc "}
		/* r.expr('aaaa bbbb  cccc ').split('b', 5) */

		suite.T().Log("About to run line #142: r.Expr('aaaa bbbb  cccc ').Split('b', 5)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split("b", 5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #142")
	}

	{
		// datum/string.yaml line #144
		/* ['aaaa ', '', '  cccc '] */
		var expected_ []interface{} = []interface{}{"aaaa ", "", "  cccc "}
		/* r.expr('aaaa bbbb  cccc ').split('bb', 3) */

		suite.T().Log("About to run line #144: r.Expr('aaaa bbbb  cccc ').Split('bb', 3)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split("bb", 3), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #144")
	}

	{
		// datum/string.yaml line #146
		/* ['aaaa', 'cccc '] */
		var expected_ []interface{} = []interface{}{"aaaa", "cccc "}
		/* r.expr('aaaa bbbb  cccc ').split(' bbbb  ', 2) */

		suite.T().Log("About to run line #146: r.Expr('aaaa bbbb  cccc ').Split(' bbbb  ', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split(" bbbb  ", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #146")
	}

	{
		// datum/string.yaml line #148
		/* ['aaaa ', '', '  cccc b d ', ' e ', '', ' f'] */
		var expected_ []interface{} = []interface{}{"aaaa ", "", "  cccc b d ", " e ", "", " f"}
		/* r.expr('aaaa bbbb  cccc b d bb e bbbb f').split('bb', 6) */

		suite.T().Log("About to run line #148: r.Expr('aaaa bbbb  cccc b d bb e bbbb f').Split('bb', 6)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc b d bb e bbbb f").Split("bb", 6), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #148")
	}

	{
		// datum/string.yaml line #150
		/* ['aaaa', 'cccc b d bb e bbbb f'] */
		var expected_ []interface{} = []interface{}{"aaaa", "cccc b d bb e bbbb f"}
		/* r.expr('aaaa bbbb  cccc b d bb e bbbb f').split(' bbbb  ', 2) */

		suite.T().Log("About to run line #150: r.Expr('aaaa bbbb  cccc b d bb e bbbb f').Split(' bbbb  ', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc b d bb e bbbb f").Split(" bbbb  ", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #150")
	}

	{
		// datum/string.yaml line #152
		/* ['aaaa', 'cccc b d bb e', 'f'] */
		var expected_ []interface{} = []interface{}{"aaaa", "cccc b d bb e", "f"}
		/* r.expr('aaaa bbbb  cccc b d bb e bbbb  f').split(' bbbb  ', 3) */

		suite.T().Log("About to run line #152: r.Expr('aaaa bbbb  cccc b d bb e bbbb  f').Split(' bbbb  ', 3)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc b d bb e bbbb  f").Split(" bbbb  ", 3), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #152")
	}

	{
		// datum/string.yaml line #155
		/* ['aaaa', 'bbbb', 'cccc '] */
		var expected_ []interface{} = []interface{}{"aaaa", "bbbb", "cccc "}
		/* r.expr('aaaa bbbb  cccc ').split(null, 2) */

		suite.T().Log("About to run line #155: r.Expr('aaaa bbbb  cccc ').Split(nil, 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split(nil, 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #155")
	}

	{
		// datum/string.yaml line #157
		/* ["a", "b"] */
		var expected_ []interface{} = []interface{}{"a", "b"}
		/* r.expr("a  b  ").split(null, 2) */

		suite.T().Log("About to run line #157: r.Expr('a  b  ').Split(nil, 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("a  b  ").Split(nil, 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #157")
	}

	{
		// datum/string.yaml line #159
		/* ['aaaa', 'bbbb', '', 'cccc', ''] */
		var expected_ []interface{} = []interface{}{"aaaa", "bbbb", "", "cccc", ""}
		/* r.expr('aaaa bbbb  cccc ').split(' ', 4) */

		suite.T().Log("About to run line #159: r.Expr('aaaa bbbb  cccc ').Split(' ', 4)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split(" ", 4), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #159")
	}

	{
		// datum/string.yaml line #161
		/* ['a', 'a', 'a', 'a', ' bbbb  cccc '] */
		var expected_ []interface{} = []interface{}{"a", "a", "a", "a", " bbbb  cccc "}
		/* r.expr('aaaa bbbb  cccc ').split('', 4) */

		suite.T().Log("About to run line #161: r.Expr('aaaa bbbb  cccc ').Split('', 4)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split("", 4), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #161")
	}

	{
		// datum/string.yaml line #163
		/* ['aaaa ', '', '', '', '  cccc '] */
		var expected_ []interface{} = []interface{}{"aaaa ", "", "", "", "  cccc "}
		/* r.expr('aaaa bbbb  cccc ').split('b', 4) */

		suite.T().Log("About to run line #163: r.Expr('aaaa bbbb  cccc ').Split('b', 4)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split("b", 4), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #163")
	}

	{
		// datum/string.yaml line #165
		/* ['aaaa ', '', '  cccc '] */
		var expected_ []interface{} = []interface{}{"aaaa ", "", "  cccc "}
		/* r.expr('aaaa bbbb  cccc ').split('bb', 2) */

		suite.T().Log("About to run line #165: r.Expr('aaaa bbbb  cccc ').Split('bb', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split("bb", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #165")
	}

	{
		// datum/string.yaml line #167
		/* ['aaaa', 'cccc '] */
		var expected_ []interface{} = []interface{}{"aaaa", "cccc "}
		/* r.expr('aaaa bbbb  cccc ').split(' bbbb  ', 1) */

		suite.T().Log("About to run line #167: r.Expr('aaaa bbbb  cccc ').Split(' bbbb  ', 1)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split(" bbbb  ", 1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #167")
	}

	{
		// datum/string.yaml line #169
		/* ['aaaa ', '', '  cccc b d ', ' e ', '', ' f'] */
		var expected_ []interface{} = []interface{}{"aaaa ", "", "  cccc b d ", " e ", "", " f"}
		/* r.expr('aaaa bbbb  cccc b d bb e bbbb f').split('bb', 5) */

		suite.T().Log("About to run line #169: r.Expr('aaaa bbbb  cccc b d bb e bbbb f').Split('bb', 5)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc b d bb e bbbb f").Split("bb", 5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #169")
	}

	{
		// datum/string.yaml line #171
		/* ['aaaa', 'cccc b d bb e bbbb f'] */
		var expected_ []interface{} = []interface{}{"aaaa", "cccc b d bb e bbbb f"}
		/* r.expr('aaaa bbbb  cccc b d bb e bbbb f').split(' bbbb  ', 1) */

		suite.T().Log("About to run line #171: r.Expr('aaaa bbbb  cccc b d bb e bbbb f').Split(' bbbb  ', 1)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc b d bb e bbbb f").Split(" bbbb  ", 1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #171")
	}

	{
		// datum/string.yaml line #173
		/* ['aaaa', 'cccc b d bb e', 'f'] */
		var expected_ []interface{} = []interface{}{"aaaa", "cccc b d bb e", "f"}
		/* r.expr('aaaa bbbb  cccc b d bb e bbbb  f').split(' bbbb  ', 2) */

		suite.T().Log("About to run line #173: r.Expr('aaaa bbbb  cccc b d bb e bbbb  f').Split(' bbbb  ', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc b d bb e bbbb  f").Split(" bbbb  ", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #173")
	}

	{
		// datum/string.yaml line #176
		/* ['aaaa', 'bbbb  cccc '] */
		var expected_ []interface{} = []interface{}{"aaaa", "bbbb  cccc "}
		/* r.expr('aaaa bbbb  cccc ').split(null, 1) */

		suite.T().Log("About to run line #176: r.Expr('aaaa bbbb  cccc ').Split(nil, 1)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split(nil, 1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #176")
	}

	{
		// datum/string.yaml line #178
		/* ['aaaa', 'bbbb', ' cccc '] */
		var expected_ []interface{} = []interface{}{"aaaa", "bbbb", " cccc "}
		/* r.expr('aaaa bbbb  cccc ').split(' ', 2) */

		suite.T().Log("About to run line #178: r.Expr('aaaa bbbb  cccc ').Split(' ', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split(" ", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #178")
	}

	{
		// datum/string.yaml line #180
		/* ['a', 'a', 'aa bbbb  cccc '] */
		var expected_ []interface{} = []interface{}{"a", "a", "aa bbbb  cccc "}
		/* r.expr('aaaa bbbb  cccc ').split('', 2) */

		suite.T().Log("About to run line #180: r.Expr('aaaa bbbb  cccc ').Split('', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split("", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #180")
	}

	{
		// datum/string.yaml line #182
		/* ['aaaa ', '', 'bb  cccc '] */
		var expected_ []interface{} = []interface{}{"aaaa ", "", "bb  cccc "}
		/* r.expr('aaaa bbbb  cccc ').split('b', 2) */

		suite.T().Log("About to run line #182: r.Expr('aaaa bbbb  cccc ').Split('b', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split("b", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #182")
	}

	{
		// datum/string.yaml line #184
		/* ['aaaa ', '', '  cccc '] */
		var expected_ []interface{} = []interface{}{"aaaa ", "", "  cccc "}
		/* r.expr('aaaa bbbb  cccc ').split('bb', 2) */

		suite.T().Log("About to run line #184: r.Expr('aaaa bbbb  cccc ').Split('bb', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split("bb", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #184")
	}

	{
		// datum/string.yaml line #186
		/* ['aaaa', 'cccc '] */
		var expected_ []interface{} = []interface{}{"aaaa", "cccc "}
		/* r.expr('aaaa bbbb  cccc ').split(' bbbb  ', 2) */

		suite.T().Log("About to run line #186: r.Expr('aaaa bbbb  cccc ').Split(' bbbb  ', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc ").Split(" bbbb  ", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #186")
	}

	{
		// datum/string.yaml line #188
		/* ['aaaa ', '', '  cccc b d bb e bbbb f'] */
		var expected_ []interface{} = []interface{}{"aaaa ", "", "  cccc b d bb e bbbb f"}
		/* r.expr('aaaa bbbb  cccc b d bb e bbbb f').split('bb', 2) */

		suite.T().Log("About to run line #188: r.Expr('aaaa bbbb  cccc b d bb e bbbb f').Split('bb', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc b d bb e bbbb f").Split("bb", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #188")
	}

	{
		// datum/string.yaml line #190
		/* ['aaaa', 'cccc b d bb e bbbb f'] */
		var expected_ []interface{} = []interface{}{"aaaa", "cccc b d bb e bbbb f"}
		/* r.expr('aaaa bbbb  cccc b d bb e bbbb f').split(' bbbb  ', 2) */

		suite.T().Log("About to run line #190: r.Expr('aaaa bbbb  cccc b d bb e bbbb f').Split(' bbbb  ', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc b d bb e bbbb f").Split(" bbbb  ", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #190")
	}

	{
		// datum/string.yaml line #192
		/* ['aaaa', 'cccc b d bb e', 'f'] */
		var expected_ []interface{} = []interface{}{"aaaa", "cccc b d bb e", "f"}
		/* r.expr('aaaa bbbb  cccc b d bb e bbbb  f').split(' bbbb  ', 2) */

		suite.T().Log("About to run line #192: r.Expr('aaaa bbbb  cccc b d bb e bbbb  f').Split(' bbbb  ', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("aaaa bbbb  cccc b d bb e bbbb  f").Split(" bbbb  ", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #192")
	}

	{
		// datum/string.yaml line #195
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* r.expr('  ').split() */

		suite.T().Log("About to run line #195: r.Expr('  ').Split()")

		runAndAssert(suite.Suite, expected_, r.Expr("  ").Split(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #195")
	}

	{
		// datum/string.yaml line #197
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* r.expr('  ').split(null) */

		suite.T().Log("About to run line #197: r.Expr('  ').Split(nil)")

		runAndAssert(suite.Suite, expected_, r.Expr("  ").Split(nil), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #197")
	}

	{
		// datum/string.yaml line #199
		/* ['', '', ''] */
		var expected_ []interface{} = []interface{}{"", "", ""}
		/* r.expr('  ').split(' ') */

		suite.T().Log("About to run line #199: r.Expr('  ').Split(' ')")

		runAndAssert(suite.Suite, expected_, r.Expr("  ").Split(" "), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #199")
	}

	{
		// datum/string.yaml line #201
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* r.expr('  ').split(null, 5) */

		suite.T().Log("About to run line #201: r.Expr('  ').Split(nil, 5)")

		runAndAssert(suite.Suite, expected_, r.Expr("  ").Split(nil, 5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #201")
	}

	{
		// datum/string.yaml line #203
		/* ['', '', ''] */
		var expected_ []interface{} = []interface{}{"", "", ""}
		/* r.expr('  ').split(' ', 5) */

		suite.T().Log("About to run line #203: r.Expr('  ').Split(' ', 5)")

		runAndAssert(suite.Suite, expected_, r.Expr("  ").Split(" ", 5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #203")
	}

	{
		// datum/string.yaml line #206
		/* ['aaaa', 'bbbb', 'cccc'] */
		var expected_ []interface{} = []interface{}{"aaaa", "bbbb", "cccc"}
		/* r.expr('  aaaa bbbb  cccc ').split() */

		suite.T().Log("About to run line #206: r.Expr('  aaaa bbbb  cccc ').Split()")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #206")
	}

	{
		// datum/string.yaml line #208
		/* ['aaaa', 'bbbb', 'cccc'] */
		var expected_ []interface{} = []interface{}{"aaaa", "bbbb", "cccc"}
		/* r.expr('  aaaa bbbb  cccc ').split(null) */

		suite.T().Log("About to run line #208: r.Expr('  aaaa bbbb  cccc ').Split(nil)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split(nil), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #208")
	}

	{
		// datum/string.yaml line #210
		/* ['', '', 'aaaa', 'bbbb', '', 'cccc', ''] */
		var expected_ []interface{} = []interface{}{"", "", "aaaa", "bbbb", "", "cccc", ""}
		/* r.expr('  aaaa bbbb  cccc ').split(' ') */

		suite.T().Log("About to run line #210: r.Expr('  aaaa bbbb  cccc ').Split(' ')")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split(" "), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #210")
	}

	{
		// datum/string.yaml line #212
		/* ['  aaaa ', '', '', '', '  cccc '] */
		var expected_ []interface{} = []interface{}{"  aaaa ", "", "", "", "  cccc "}
		/* r.expr('  aaaa bbbb  cccc ').split('b') */

		suite.T().Log("About to run line #212: r.Expr('  aaaa bbbb  cccc ').Split('b')")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split("b"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #212")
	}

	{
		// datum/string.yaml line #214
		/* ['  aaaa ', '', '  cccc '] */
		var expected_ []interface{} = []interface{}{"  aaaa ", "", "  cccc "}
		/* r.expr('  aaaa bbbb  cccc ').split('bb') */

		suite.T().Log("About to run line #214: r.Expr('  aaaa bbbb  cccc ').Split('bb')")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split("bb"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #214")
	}

	{
		// datum/string.yaml line #216
		/* ['  aaaa', 'cccc '] */
		var expected_ []interface{} = []interface{}{"  aaaa", "cccc "}
		/* r.expr('  aaaa bbbb  cccc ').split(' bbbb  ') */

		suite.T().Log("About to run line #216: r.Expr('  aaaa bbbb  cccc ').Split(' bbbb  ')")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split(" bbbb  "), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #216")
	}

	{
		// datum/string.yaml line #218
		/* ['  aaaa ', '', '  cccc b d ', ' e ', '', ' f'] */
		var expected_ []interface{} = []interface{}{"  aaaa ", "", "  cccc b d ", " e ", "", " f"}
		/* r.expr('  aaaa bbbb  cccc b d bb e bbbb f').split('bb') */

		suite.T().Log("About to run line #218: r.Expr('  aaaa bbbb  cccc b d bb e bbbb f').Split('bb')")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc b d bb e bbbb f").Split("bb"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #218")
	}

	{
		// datum/string.yaml line #220
		/* ['  aaaa', 'cccc b d bb e bbbb f'] */
		var expected_ []interface{} = []interface{}{"  aaaa", "cccc b d bb e bbbb f"}
		/* r.expr('  aaaa bbbb  cccc b d bb e bbbb f').split(' bbbb  ') */

		suite.T().Log("About to run line #220: r.Expr('  aaaa bbbb  cccc b d bb e bbbb f').Split(' bbbb  ')")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc b d bb e bbbb f").Split(" bbbb  "), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #220")
	}

	{
		// datum/string.yaml line #222
		/* ['  aaaa', 'cccc b d bb e', 'f'] */
		var expected_ []interface{} = []interface{}{"  aaaa", "cccc b d bb e", "f"}
		/* r.expr('  aaaa bbbb  cccc b d bb e bbbb  f').split(' bbbb  ') */

		suite.T().Log("About to run line #222: r.Expr('  aaaa bbbb  cccc b d bb e bbbb  f').Split(' bbbb  ')")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc b d bb e bbbb  f").Split(" bbbb  "), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #222")
	}

	{
		// datum/string.yaml line #225
		/* ['aaaa', 'bbbb', 'cccc'] */
		var expected_ []interface{} = []interface{}{"aaaa", "bbbb", "cccc"}
		/* r.expr('  aaaa bbbb  cccc ').split(null, 3) */

		suite.T().Log("About to run line #225: r.Expr('  aaaa bbbb  cccc ').Split(nil, 3)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split(nil, 3), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #225")
	}

	{
		// datum/string.yaml line #227
		/* ['', '', 'aaaa', 'bbbb', '', 'cccc '] */
		var expected_ []interface{} = []interface{}{"", "", "aaaa", "bbbb", "", "cccc "}
		/* r.expr('  aaaa bbbb  cccc ').split(' ', 5) */

		suite.T().Log("About to run line #227: r.Expr('  aaaa bbbb  cccc ').Split(' ', 5)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split(" ", 5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #227")
	}

	{
		// datum/string.yaml line #229
		/* ['  aaaa ', '', '', '', '  cccc '] */
		var expected_ []interface{} = []interface{}{"  aaaa ", "", "", "", "  cccc "}
		/* r.expr('  aaaa bbbb  cccc ').split('b', 5) */

		suite.T().Log("About to run line #229: r.Expr('  aaaa bbbb  cccc ').Split('b', 5)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split("b", 5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #229")
	}

	{
		// datum/string.yaml line #231
		/* ['  aaaa ', '', '  cccc '] */
		var expected_ []interface{} = []interface{}{"  aaaa ", "", "  cccc "}
		/* r.expr('  aaaa bbbb  cccc ').split('bb', 3) */

		suite.T().Log("About to run line #231: r.Expr('  aaaa bbbb  cccc ').Split('bb', 3)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split("bb", 3), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #231")
	}

	{
		// datum/string.yaml line #233
		/* ['  aaaa', 'cccc '] */
		var expected_ []interface{} = []interface{}{"  aaaa", "cccc "}
		/* r.expr('  aaaa bbbb  cccc ').split(' bbbb  ', 2) */

		suite.T().Log("About to run line #233: r.Expr('  aaaa bbbb  cccc ').Split(' bbbb  ', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split(" bbbb  ", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #233")
	}

	{
		// datum/string.yaml line #235
		/* ['  aaaa ', '', '  cccc b d ', ' e ', '', ' f'] */
		var expected_ []interface{} = []interface{}{"  aaaa ", "", "  cccc b d ", " e ", "", " f"}
		/* r.expr('  aaaa bbbb  cccc b d bb e bbbb f').split('bb', 6) */

		suite.T().Log("About to run line #235: r.Expr('  aaaa bbbb  cccc b d bb e bbbb f').Split('bb', 6)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc b d bb e bbbb f").Split("bb", 6), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #235")
	}

	{
		// datum/string.yaml line #237
		/* ['  aaaa', 'cccc b d bb e bbbb f'] */
		var expected_ []interface{} = []interface{}{"  aaaa", "cccc b d bb e bbbb f"}
		/* r.expr('  aaaa bbbb  cccc b d bb e bbbb f').split(' bbbb  ', 2) */

		suite.T().Log("About to run line #237: r.Expr('  aaaa bbbb  cccc b d bb e bbbb f').Split(' bbbb  ', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc b d bb e bbbb f").Split(" bbbb  ", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #237")
	}

	{
		// datum/string.yaml line #239
		/* ['  aaaa', 'cccc b d bb e', 'f'] */
		var expected_ []interface{} = []interface{}{"  aaaa", "cccc b d bb e", "f"}
		/* r.expr('  aaaa bbbb  cccc b d bb e bbbb  f').split(' bbbb  ', 3) */

		suite.T().Log("About to run line #239: r.Expr('  aaaa bbbb  cccc b d bb e bbbb  f').Split(' bbbb  ', 3)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc b d bb e bbbb  f").Split(" bbbb  ", 3), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #239")
	}

	{
		// datum/string.yaml line #242
		/* ['aaaa', 'bbbb', 'cccc '] */
		var expected_ []interface{} = []interface{}{"aaaa", "bbbb", "cccc "}
		/* r.expr('  aaaa bbbb  cccc ').split(null, 2) */

		suite.T().Log("About to run line #242: r.Expr('  aaaa bbbb  cccc ').Split(nil, 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split(nil, 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #242")
	}

	{
		// datum/string.yaml line #244
		/* ["a", "b"] */
		var expected_ []interface{} = []interface{}{"a", "b"}
		/* r.expr("a  b  ").split(null, 2) */

		suite.T().Log("About to run line #244: r.Expr('a  b  ').Split(nil, 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("a  b  ").Split(nil, 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #244")
	}

	{
		// datum/string.yaml line #246
		/* ['', '', 'aaaa', 'bbbb', ' cccc '] */
		var expected_ []interface{} = []interface{}{"", "", "aaaa", "bbbb", " cccc "}
		/* r.expr('  aaaa bbbb  cccc ').split(' ', 4) */

		suite.T().Log("About to run line #246: r.Expr('  aaaa bbbb  cccc ').Split(' ', 4)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split(" ", 4), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #246")
	}

	{
		// datum/string.yaml line #248
		/* ['  aaaa ', '', '', '', '  cccc '] */
		var expected_ []interface{} = []interface{}{"  aaaa ", "", "", "", "  cccc "}
		/* r.expr('  aaaa bbbb  cccc ').split('b', 4) */

		suite.T().Log("About to run line #248: r.Expr('  aaaa bbbb  cccc ').Split('b', 4)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split("b", 4), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #248")
	}

	{
		// datum/string.yaml line #250
		/* ['  aaaa ', '', '  cccc '] */
		var expected_ []interface{} = []interface{}{"  aaaa ", "", "  cccc "}
		/* r.expr('  aaaa bbbb  cccc ').split('bb', 2) */

		suite.T().Log("About to run line #250: r.Expr('  aaaa bbbb  cccc ').Split('bb', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split("bb", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #250")
	}

	{
		// datum/string.yaml line #252
		/* ['  aaaa', 'cccc '] */
		var expected_ []interface{} = []interface{}{"  aaaa", "cccc "}
		/* r.expr('  aaaa bbbb  cccc ').split(' bbbb  ', 1) */

		suite.T().Log("About to run line #252: r.Expr('  aaaa bbbb  cccc ').Split(' bbbb  ', 1)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split(" bbbb  ", 1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #252")
	}

	{
		// datum/string.yaml line #254
		/* ['  aaaa ', '', '  cccc b d ', ' e ', '', ' f'] */
		var expected_ []interface{} = []interface{}{"  aaaa ", "", "  cccc b d ", " e ", "", " f"}
		/* r.expr('  aaaa bbbb  cccc b d bb e bbbb f').split('bb', 5) */

		suite.T().Log("About to run line #254: r.Expr('  aaaa bbbb  cccc b d bb e bbbb f').Split('bb', 5)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc b d bb e bbbb f").Split("bb", 5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #254")
	}

	{
		// datum/string.yaml line #256
		/* ['  aaaa', 'cccc b d bb e bbbb f'] */
		var expected_ []interface{} = []interface{}{"  aaaa", "cccc b d bb e bbbb f"}
		/* r.expr('  aaaa bbbb  cccc b d bb e bbbb f').split(' bbbb  ', 1) */

		suite.T().Log("About to run line #256: r.Expr('  aaaa bbbb  cccc b d bb e bbbb f').Split(' bbbb  ', 1)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc b d bb e bbbb f").Split(" bbbb  ", 1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #256")
	}

	{
		// datum/string.yaml line #258
		/* ['  aaaa', 'cccc b d bb e', 'f'] */
		var expected_ []interface{} = []interface{}{"  aaaa", "cccc b d bb e", "f"}
		/* r.expr('  aaaa bbbb  cccc b d bb e bbbb  f').split(' bbbb  ', 2) */

		suite.T().Log("About to run line #258: r.Expr('  aaaa bbbb  cccc b d bb e bbbb  f').Split(' bbbb  ', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc b d bb e bbbb  f").Split(" bbbb  ", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #258")
	}

	{
		// datum/string.yaml line #261
		/* ['aaaa', 'bbbb  cccc '] */
		var expected_ []interface{} = []interface{}{"aaaa", "bbbb  cccc "}
		/* r.expr('  aaaa bbbb  cccc ').split(null, 1) */

		suite.T().Log("About to run line #261: r.Expr('  aaaa bbbb  cccc ').Split(nil, 1)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split(nil, 1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #261")
	}

	{
		// datum/string.yaml line #263
		/* ['', '', 'aaaa bbbb  cccc '] */
		var expected_ []interface{} = []interface{}{"", "", "aaaa bbbb  cccc "}
		/* r.expr('  aaaa bbbb  cccc ').split(' ', 2) */

		suite.T().Log("About to run line #263: r.Expr('  aaaa bbbb  cccc ').Split(' ', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split(" ", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #263")
	}

	{
		// datum/string.yaml line #265
		/* ['  aaaa ', '', 'bb  cccc '] */
		var expected_ []interface{} = []interface{}{"  aaaa ", "", "bb  cccc "}
		/* r.expr('  aaaa bbbb  cccc ').split('b', 2) */

		suite.T().Log("About to run line #265: r.Expr('  aaaa bbbb  cccc ').Split('b', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split("b", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #265")
	}

	{
		// datum/string.yaml line #267
		/* ['  aaaa ', '', '  cccc '] */
		var expected_ []interface{} = []interface{}{"  aaaa ", "", "  cccc "}
		/* r.expr('  aaaa bbbb  cccc ').split('bb', 2) */

		suite.T().Log("About to run line #267: r.Expr('  aaaa bbbb  cccc ').Split('bb', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split("bb", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #267")
	}

	{
		// datum/string.yaml line #269
		/* ['  aaaa', 'cccc '] */
		var expected_ []interface{} = []interface{}{"  aaaa", "cccc "}
		/* r.expr('  aaaa bbbb  cccc ').split(' bbbb  ', 2) */

		suite.T().Log("About to run line #269: r.Expr('  aaaa bbbb  cccc ').Split(' bbbb  ', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc ").Split(" bbbb  ", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #269")
	}

	{
		// datum/string.yaml line #271
		/* ['  aaaa ', '', '  cccc b d bb e bbbb f'] */
		var expected_ []interface{} = []interface{}{"  aaaa ", "", "  cccc b d bb e bbbb f"}
		/* r.expr('  aaaa bbbb  cccc b d bb e bbbb f').split('bb', 2) */

		suite.T().Log("About to run line #271: r.Expr('  aaaa bbbb  cccc b d bb e bbbb f').Split('bb', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc b d bb e bbbb f").Split("bb", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #271")
	}

	{
		// datum/string.yaml line #273
		/* ['  aaaa', 'cccc b d bb e bbbb f'] */
		var expected_ []interface{} = []interface{}{"  aaaa", "cccc b d bb e bbbb f"}
		/* r.expr('  aaaa bbbb  cccc b d bb e bbbb f').split(' bbbb  ', 2) */

		suite.T().Log("About to run line #273: r.Expr('  aaaa bbbb  cccc b d bb e bbbb f').Split(' bbbb  ', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc b d bb e bbbb f").Split(" bbbb  ", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #273")
	}

	{
		// datum/string.yaml line #275
		/* ['  aaaa', 'cccc b d bb e', 'f'] */
		var expected_ []interface{} = []interface{}{"  aaaa", "cccc b d bb e", "f"}
		/* r.expr('  aaaa bbbb  cccc b d bb e bbbb  f').split(' bbbb  ', 2) */

		suite.T().Log("About to run line #275: r.Expr('  aaaa bbbb  cccc b d bb e bbbb  f').Split(' bbbb  ', 2)")

		runAndAssert(suite.Suite, expected_, r.Expr("  aaaa bbbb  cccc b d bb e bbbb  f").Split(" bbbb  ", 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #275")
	}

	{
		// datum/string.yaml line #278
		/* "ABC-DEF-GHJ" */
		var expected_ string = "ABC-DEF-GHJ"
		/* r.expr("abc-dEf-GHJ").upcase() */

		suite.T().Log("About to run line #278: r.Expr('abc-dEf-GHJ').Upcase()")

		runAndAssert(suite.Suite, expected_, r.Expr("abc-dEf-GHJ").Upcase(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #278")
	}

	{
		// datum/string.yaml line #280
		/* "abc-def-ghj" */
		var expected_ string = "abc-def-ghj"
		/* r.expr("abc-dEf-GHJ").downcase() */

		suite.T().Log("About to run line #280: r.Expr('abc-dEf-GHJ').Downcase()")

		runAndAssert(suite.Suite, expected_, r.Expr("abc-dEf-GHJ").Downcase(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #280")
	}

	{
		// datum/string.yaml line #285
		/* ["f", "\u00e9", "o", "o"] */
		var expected_ []interface{} = []interface{}{"f", "é", "o", "o"}
		/* r.expr(u"f\u00e9oo").split("") */

		suite.T().Log("About to run line #285: r.Expr('féoo').Split('')")

		runAndAssert(suite.Suite, expected_, r.Expr("féoo").Split(""), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #285")
	}

	{
		// datum/string.yaml line #294
		/* ["f", "e\u0301", "o", "o"] */
		var expected_ []interface{} = []interface{}{"f", "é", "o", "o"}
		/* r.expr(u"fe\u0301oo").split("") */

		suite.T().Log("About to run line #294: r.Expr('féoo').Split('')")

		runAndAssert(suite.Suite, expected_, r.Expr("féoo").Split(""), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #294")
	}

	{
		// datum/string.yaml line #307
		/* ["foo", "bar", "baz", "quux", "fred", "barney", "wilma"] */
		var expected_ []interface{} = []interface{}{"foo", "bar", "baz", "quux", "fred", "barney", "wilma"}
		/* r.expr(u"foo bar\tbaz\nquux\rfred\u000bbarney\u000cwilma").split() */

		suite.T().Log("About to run line #307: r.Expr('foo bar\\tbaz\\nquux\\rfred\\u000bbarney\\u000cwilma').Split()")

		runAndAssert(suite.Suite, expected_, r.Expr("foo bar\tbaz\nquux\rfred\u000bbarney\u000cwilma").Split(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #307")
	}

	{
		// datum/string.yaml line #323
		/* ["foo", "bar", "baz\u2060quux", "fred", "barney", "wilma", "betty\u200b"] */
		var expected_ []interface{} = []interface{}{"foo", "bar", "baz\u2060quux", "fred", "barney", "wilma", "betty\u200b"}
		/* r.expr(u"foo\u00a0bar\u2001baz\u2060quux\u2028fred\u2028barney\u2029wilma\u0085betty\u200b").split() */

		suite.T().Log("About to run line #323: r.Expr('foo\\u00a0bar\\u2001baz\\u2060quux\\u2028fred\\u2028barney\\u2029wilma\\u0085betty\\u200b').Split()")

		runAndAssert(suite.Suite, expected_, r.Expr("foo\u00a0bar\u2001baz\u2060quux\u2028fred\u2028barney\u2029wilma\u0085betty\u200b").Split(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #323")
	}
}
