/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	networkingv1 "k8s.io/api/networking/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// IPAddressLister helps list IPAddresses.
// All objects returned here must be treated as read-only.
type IPAddressLister interface {
	// List lists all IPAddresses in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*networkingv1.IPAddress, err error)
	// Get retrieves the IPAddress from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*networkingv1.IPAddress, error)
	IPAddressListerExpansion
}

// iPAddressLister implements the IPAddressLister interface.
type iPAddressLister struct {
	listers.ResourceIndexer[*networkingv1.IPAddress]
}

// NewIPAddressLister returns a new IPAddressLister.
func NewIPAddressLister(indexer cache.Indexer) IPAddressLister {
	return &iPAddressLister{listers.New[*networkingv1.IPAddress](indexer, networkingv1.Resource("ipaddress"))}
}
