/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc.controls;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.AudioDeviceCapabilities;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.AudioDeviceState;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.AudioRepeatState;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.AudioShuffleState;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.AudioVideoCommandNumber;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.CommandStatus;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.ControlsMode;
import com.dsi.ant.plugins.antplus.pcc.controls.pccbase.AntPlusBaseControllableDevicePcc;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPlusAudioControllableDevicePcc
extends AntPlusBaseControllableDevicePcc {
    private static final String TAG = AntPlusAudioControllableDevicePcc.class.getSimpleName();
    IAudioCommandReceiver mAudioCommandReceiver;

    public static PccReleaseHandle<AntPlusAudioControllableDevicePcc> requestAccess(Context bindToContext, AntPluginPcc.IPluginAccessResultReceiver<AntPlusAudioControllableDevicePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver, final IAudioCommandReceiver audioCommandReceiver, final AudioDeviceCapabilities capabilities, int channelDeviceNumber) {
        if (AntPlusAudioControllableDevicePcc.getInstalledPluginsVersionNumber(bindToContext) == 10000) {
            AntPlusBaseControllableDevicePcc.IpcDefines.PATH_ANTPLUS_CONTROLLABLEDEVICEPLUGIN_SERVICE = "com.dsi.ant.plugins.antplus.controls.ControlsService";
        }
        Bundle b = new Bundle();
        b.putInt("int_RequestAccessMode", ControlsMode.AUDIO_MODE.getRequestAccessModeValue());
        b.putInt("int_ChannelDeviceId", channelDeviceNumber);
        final AntPlusAudioControllableDevicePcc potentialRetObj = new AntPlusAudioControllableDevicePcc();
        return AntPlusAudioControllableDevicePcc.requestAccess_Helper_Main(bindToContext, b, potentialRetObj, new AntPluginPcc.RequestAccessResultHandler<AntPlusAudioControllableDevicePcc>(){

            @Override
            public boolean handleRequestAccessResult(Message msg) {
                boolean result = super.handleRequestAccessResult(msg);
                int resultCode = msg.what;
                if (resultCode == 0) {
                    potentialRetObj.subscribeAudioCommandEvent(audioCommandReceiver);
                    Thread t = new Thread(new Runnable(){

                        public void run() {
                            potentialRetObj.setAudioCapabilities(capabilities);
                        }
                    });
                    t.start();
                }
                return result;
            }
        }, resultReceiver, stateReceiver);
    }

    private AntPlusAudioControllableDevicePcc() {
    }

    @Override
    protected String getPluginPrintableName() {
        return "ANT+ Plugin:  Audio Controls";
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 202: {
                if (this.mAudioCommandReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                int serialNumber = b.getInt("int_serialNumber");
                int commandData = b.getInt("int_commandData");
                final int sequenceNumber = b.getInt("int_sequenceNumber");
                final AudioVideoCommandNumber commandNumber = AudioVideoCommandNumber.getValueFromInt(b.getInt("int_commandNumber"));
                final CommandStatus status = this.mAudioCommandReceiver.onNewAudioCommand(estTimestamp, eventFlags, serialNumber, sequenceNumber, commandNumber, commandData);
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        AntPlusAudioControllableDevicePcc.this.updateAudioCommandStatus(sequenceNumber, status, commandNumber);
                    }
                });
                t.start();
                break;
            }
            default: {
                super.handlePluginEvent(eventMsg);
            }
        }
    }

    public void updateAudioStatus(int volume, int totalTrackTime, int currentTrackTime, AudioDeviceState audioState, AudioRepeatState repeatState, AudioShuffleState shuffleState) {
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20005;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putInt("int_volume", volume);
        params.putInt("int_totalTrackTime", totalTrackTime);
        params.putInt("int_currentTrackTime", currentTrackTime);
        params.putInt("int_audioState", audioState.getIntValue());
        params.putInt("int_repeatState", repeatState.getIntValue());
        params.putInt("int_shuffleState", shuffleState.getIntValue());
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd updateAudioStatus died in sendPluginCommand()");
            return;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd updateAudioStatus failed with code " + ret.arg1);
            throw new RuntimeException("updateAudioStatus cmd failed internally");
        }
        ret.recycle();
    }

    private void subscribeAudioCommandEvent(IAudioCommandReceiver AudioCommandReceiver) {
        this.mAudioCommandReceiver = AudioCommandReceiver;
        if (AudioCommandReceiver != null) {
            this.subscribeToEvent(202);
        } else {
            this.unsubscribeFromEvent(202);
        }
    }

    private void setAudioCapabilities(AudioDeviceCapabilities audioDeviceCapabilities) {
        if (audioDeviceCapabilities == null) {
            return;
        }
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20004;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        audioDeviceCapabilities.writeToBundle(params);
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd setAudioCapabilities died in sendPluginCommand()");
            return;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd setAudioCapabilities failed with code " + ret.arg1);
            throw new RuntimeException("setAudioCapabilities cmd failed internally");
        }
        ret.recycle();
    }

    private void updateAudioCommandStatus(int sequenceNumber, CommandStatus commandStatus, AudioVideoCommandNumber commandNumber) {
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20002;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putInt("int_sequenceNumber", sequenceNumber);
        params.putInt("int_commandStatus", commandStatus.getIntValue());
        params.putInt("int_commandNumber", commandNumber.getIntValue());
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd updateAudioCommandStatus died in sendPluginCommand()");
            return;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd updateAudioCommandStatus failed with code " + ret.arg1);
            throw new RuntimeException("updateAudioCommandStatus cmd failed internally");
        }
        ret.recycle();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IAudioCommandReceiver {
        public CommandStatus onNewAudioCommand(long var1, EnumSet<EventFlag> var3, int var4, int var5, AudioVideoCommandNumber var6, int var7);
    }

    public static class IpcDefines {
        public static final int MSG_CMD_CONTROLS_whatUPDATEAUDIOCOMMANDSTATUS = 20002;
        public static final String MSG_CMD_CONTROLS_UPDATEAUDIOCOMMANDSTATUS_PARAM_intSEQUENCENUMBER = "int_sequenceNumber";
        public static final String MSG_CMD_CONTROLS_UPDATEAUDIOCOMMANDSTATUS_PARAM_intCOMMANDSTATUS = "int_commandStatus";
        public static final String MSG_CMD_CONTROLS_UPDATEAUDIOCOMMANDSTATUS_PARAM_intCOMMANDNUMBER = "int_commandNumber";
        public static final int MSG_EVENT_CONTROLS_whatAUDIOCOMMAND = 202;
        public static final String MSG_EVENT_CONTROLS_AUDIOCOMMAND_PARAM_intSERIALNUMBER = "int_serialNumber";
        public static final String MSG_EVENT_CONTROLS_AUDIOCOMMAND_PARAM_intSEQUENCENUMBER = "int_sequenceNumber";
        public static final int MSG_CMD_CONTROLS_whatSETAUDIOCAPABILITIES = 20004;
        public static final String MSG_CMD_CONTROLS_SETAUDIOCAPABILITIES_PARAM_boolCUSTOMREPEATMODESUPPORT = "bool_customRepeatModeSupport";
        public static final String MSG_CMD_CONTROLS_SETAUDIOCAPABILITIES_PARAM_boolCUSTOMSHUFFLEMODESUPPORT = "bool_customShuffleModeSupport";
        public static final int MSG_CMD_CONTROLS_whatUPDATEAUDIOSTATUS = 20005;
    }
}

