/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.utility.log;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;

public final class LogAnt {
    public static final int DEBUG_LEVEL = 0;
    public static final int DEBUG_LEVEL_DEFAULT;
    private static int sDebugLevel;
    protected static final String PREFS_FILE = "ant_plugins_logging";
    protected static final String PREFS_DEBUG_LEVEL = "debug_level";
    private static String sVersion;

    public static void setDebugLevel(int level, Context context) {
        sDebugLevel = level;
        SharedPreferences prefs = context.getSharedPreferences(PREFS_FILE, 1);
        prefs.edit().putInt(PREFS_DEBUG_LEVEL, sDebugLevel).commit();
    }

    public static void setDebugLevel(DebugLevel level, Context context) {
        int levelInt = level.ordinal();
        LogAnt.setDebugLevel(levelInt, context);
    }

    public static int getDebugLevel(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(PREFS_FILE, 1);
        int debugLevel = prefs.getInt(PREFS_DEBUG_LEVEL, -1);
        if (debugLevel == -1) {
            prefs.edit().putInt(PREFS_DEBUG_LEVEL, DEBUG_LEVEL_DEFAULT).commit();
        } else {
            sDebugLevel = debugLevel;
        }
        return sDebugLevel;
    }

    public static int getDebugLevel() {
        return sDebugLevel;
    }

    public static void setVersion(String version) {
        sVersion = version + ": ";
    }

    public static final void e(String tag, String msg) {
        if (sDebugLevel >= DebugLevel.ERROR.ordinal()) {
            Log.e((String)tag, (String)(sVersion + msg));
        }
    }

    public static final void e(String tag, String msg, Throwable th) {
        if (sDebugLevel >= DebugLevel.ERROR.ordinal()) {
            Log.e((String)tag, (String)(sVersion + msg), (Throwable)th);
        }
    }

    public static final void w(String tag, String msg) {
        if (sDebugLevel >= DebugLevel.WARNING.ordinal()) {
            Log.w((String)tag, (String)(sVersion + msg));
        }
    }

    public static final void w(String tag, String msg, Throwable th) {
        if (sDebugLevel >= DebugLevel.WARNING.ordinal()) {
            Log.w((String)tag, (String)(sVersion + msg), (Throwable)th);
        }
    }

    public static final void i(String tag, String msg) {
        if (sDebugLevel >= DebugLevel.INFO.ordinal()) {
            Log.i((String)tag, (String)(sVersion + msg));
        }
    }

    public static final void d(String tag, String msg) {
        if (sDebugLevel >= DebugLevel.DEBUG.ordinal()) {
            Log.d((String)tag, (String)(sVersion + msg));
        }
    }

    public static final void v(String tag, String msg) {
        if (sDebugLevel >= DebugLevel.VERBOSE.ordinal()) {
            Log.v((String)tag, (String)(sVersion + msg));
        }
    }

    static {
        sDebugLevel = DEBUG_LEVEL_DEFAULT = DebugLevel.WARNING.ordinal();
        sVersion = "v.NTST: ";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DebugLevel {
        NONE,
        ERROR,
        WARNING,
        INFO,
        DEBUG,
        VERBOSE;

    }
}

