#ifdef WIN32
#pragma warning (disable : 4305)
#endif /* WIN32 */
#include "common.h"
#include "abstra.h"
#include "atmosmodel.h"
#include "altitude.h"

void
wava6 (double a[8], const long int inu)
{


    static const float acr[2048] = { .011482f, .13183f,
				     -.0038755f, 3.4491e-6f, -.0069899f, 9.3146e-6f, 15300.f, 15310.f,
				     .0015124f, .19547f, .0028474f, -4.7616e-6f, .0017802f, -1.079e-5f,
				     15310.f, 15320.f, .0092482f, .16207f, -.0025675f, 1.271e-5f, -.0027267f,
				     6.2076e-6f, 15320.f, 15330.f, .0104f, .25148f, .0028271f, -1.6657e-5f,
				     .0013667f, -1.7862e-5f, 15330.f, 15340.f, .036425f, .35831f, -.0010013f,
				     -1.0673e-6f, -.0025219f, -1.7475e-6f, 15340.f, 15350.f, .0050755f,
				     .12303f, -.0018115f, 9.8037e-7f, -.0034793f, 8.572e-7f, 15350.f,
				     15360.f, .0040405f, .079669f, -.0035356f, 4.2888e-6f, -.0049964f,
				     5.6042e-6f, 15360.f, 15370.f, .0012748f, .10104f, .0012869f,
				     -4.1165e-6f, -2.5366e-4f, -8.5685e-6f, 15370.f, 15380.f, .004332f,
				     .087049f, -.0037819f, 4.8177e-6f, -.0066616f, 9.4206e-6f, 15380.f,
				     15390.f, .018759f, .14839f, -.0050183f, 8.8733e-6f, -.0069647f,
				     1.2888e-5f, 15390.f, 15400.f, .013161f, .13948f, -.0039758f, 3.962e-6f,
				     -.006383f, 8.2226e-6f, 15400.f, 15410.f, .014766f, .30841f, -.0025568f,
				     -1.0002e-6f, -.0049777f, 2.925e-6f, 15410.f, 15420.f, .021082f, .15162f,
				     -.0015321f, -5.6826e-6f, -.0038546f, -1.6492e-6f, 15420.f, 15430.f,
				     .020195f, .19485f, -2.7645e-4f, -9.8888e-6f, -.0024022f, -6.5352e-6f,
				     15430.f, 15440.f, .011166f, .18799f, .0030297f, -2.1309e-5f, 4.9231e-4f,
				     -1.6445e-5f, 15440.f, 15450.f, .011405f, .30263f, .0033723f,
				     -1.9312e-5f, .0012213f, -1.8339e-5f, 15450.f, 15460.f, .0081879f,
				     .2948f, .0056918f, -2.2518e-5f, .0049723f, -2.6308e-5f, 15460.f,
				     15470.f, .0086587f, .31194f, .0049388f, -2.4988e-5f, .0025729f,
				     -2.3785e-5f, 15470.f, 15480.f, .0029624f, .25004f, .0021191f,
				     1.2889e-5f, .0021547f, -5.0741e-6f, 15480.f, 15490.f, .0010355f, .1518f,
				     .010772f, -5.3973e-5f, .0081789f, -4.9803e-5f, 15490.f, 15500.f,
				     .0019209f, .15869f, .0035388f, -1.5675e-6f, .0030429f, -1.3275e-5f,
				     15500.f, 15510.f, .0021168f, .22695f, .0033055f, -7.1274e-7f, .0018066f,
				     -1.051e-5f, 15510.f, 15520.f, 3.63e-4f, .041337f, .004643f, -3.0966e-5f,
				     .0016831f, -2.5006e-5f, 15520.f, 15530.f, 6.422e-4f, .040141f,
				     .0011384f, -1.6948e-5f, -.0017809f, -1.1069e-5f, 15530.f, 15540.f,
				     .0017361f, .12935f, 7.0897e-6f, -1.1804e-5f, -.0029721f, -5.606e-6f,
				     15540.f, 15550.f, 3.6772e-4f, .069843f, .0015876f, -1.7017e-5f,
				     -.0014188f, -1.1298e-5f, 15550.f, 15560.f, 8.1562e-4f, .085732f,
				     .0028597f, -2.3409e-5f, -8.1651e-5f, -1.7172e-5f, 15560.f, 15570.f,
				     4.1832e-5f, .037286f, .0071945f, -4.1172e-5f, .0048022f, -3.6355e-5f,
				     15570.f, 15580.f, 2.89e-4f, .059772f, .00431f, -2.7519e-5f, .0025363f,
				     -2.6086e-5f, 15580.f, 15590.f, 3.4153e-4f, .068927f, .0058634f,
				     -2.8708e-5f, .002971f, -2.6151e-5f, 15590.f, 15600.f, 6.3462e-4f,
				     .10803f, .0062584f, -1.912e-5f, .0049128f, -2.4384e-5f, 15600.f,
				     15610.f, 3.9706e-4f, .12303f, .0073825f, -2.4245e-5f, .0050938f,
				     -2.795e-5f, 15610.f, 15620.f, 1.1711e-4f, .063154f, .0049218f,
				     -2.6583e-5f, .0021634f, -2.368e-5f, 15620.f, 15630.f, 2.8022e-4f,
				     .091171f, .011895f, -5.9964e-5f, .0091244f, -5.4363e-5f, 15630.f,
				     15640.f, 4.8561e-4f, .17953f, .0048672f, -2.2506e-5f, .0012405f,
				     -1.7834e-5f, 15640.f, 15650.f, 3.295e-4f, .13103f, .0079212f,
				     -3.1361e-5f, .0048579f, -3.0501e-5f, 15650.f, 15660.f, 6.2254e-4f,
				     .13066f, .0068683f, -3.4929e-5f, .0042198f, -3.0853e-5f, 15660.f,
				     15670.f, 3.4175e-4f, .0686f, .0071102f, -4.0828e-5f, .0041954f,
				     -3.4941e-5f, 15670.f, 15680.f, 6.7893e-4f, .25103f, .002638f,
				     -1.0784e-5f, -1.9402e-4f, -1.0493e-5f, 15680.f, 15690.f, .0022454f,
				     .2126f, .0045521f, -3.0054e-5f, .0018943f, -2.5356e-5f, 15690.f,
				     15700.f, 2.2324e-4f, .16386f, 9.9924e-5f, -4.6542e-6f, -.0032498f,
				     -4.4042e-7f, 15700.f, 15710.f, .0011732f, .071121f, .0017438f,
				     -1.9369e-5f, -.0010378f, -1.3774e-5f, 15710.f, 15720.f, .0011939f,
				     .22194f, .0022505f, -2.0274e-5f, -3.0389e-4f, -1.5915e-5f, 15720.f,
				     15730.f, .0011335f, .1131f, 6.5038e-4f, -1.4226e-5f, -.0023716f,
				     -8.4484e-6f, 15730.f, 15740.f, .0013693f, .066759f, -4.9503e-4f,
				     -1.0274e-5f, -.0033442f, -4.9491e-6f, 15740.f, 15750.f, .0022675f,
				     .11019f, -.0015659f, -6.0385e-6f, -.0042073f, -9.9453e-7f, 15750.f,
				     15760.f, .0021492f, .11169f, -.0025591f, -1.868e-6f, -.0052151f,
				     2.9531e-6f, 15760.f, 15770.f, 5.2724e-4f, .079449f, -.0015077f,
				     3.7703e-7f, -.0037765f, 1.0136e-6f, 15770.f, 15780.f, .0017852f,
				     .092282f, -.0042337f, 4.5463e-6f, -.0075615f, 1.1296e-5f, 15780.f,
				     15790.f, 5.7289e-4f, .18138f, .001042f, 1.1358e-7f, -.0010771f,
				     -3.8585e-6f, 15790.f, 15800.f, .0024903f, .21722f, 6.1161e-4f,
				     2.0815e-6f, -6.5545e-4f, -6.5063e-6f, 15800.f, 15810.f, .0033934f,
				     .23501f, 3.4083e-4f, -1.2029e-5f, -.0027676f, -5.6508e-6f, 15810.f,
				     15820.f, .0043759f, .14995f, -.003628f, 2.8054e-6f, -.0061589f,
				     7.1308e-6f, 15820.f, 15830.f, 9.6328e-4f, .12298f, -.0027284f,
				     2.0822e-6f, -.0051044f, 4.1652e-6f, 15830.f, 15840.f, 6.1564e-4f,
				     .047547f, -.0041578f, 4.2375e-6f, -.007361f, 1.0687e-5f, 15840.f,
				     15850.f, 1.445e-4f, .047164f, -.0026523f, -1.7845e-6f, -.0054095f,
				     3.7673e-6f, 15850.f, 15860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15860.f,
				     15870.f, .0027617f, .080618f, -.0054341f, 9.35e-6f, -.0086841f,
				     1.5797e-5f, 15870.f, 15880.f, .0038448f, .0889f, -.0045065f, 5.7229e-6f,
				     -.0074065f, 1.161e-5f, 15880.f, 15890.f, .002669f, .12359f, -.003403f,
				     1.5184e-6f, -.0062551f, 6.94e-6f, 15890.f, 15900.f, .0035205f, .15929f,
				     -.0029195f, -6.0033e-7f, -.0055137f, 4.5063e-6f, 15900.f, 15910.f,
				     .0033857f, .15288f, -5.5305e-4f, -1.0049e-5f, -.0030402f, -5.3251e-6f,
				     15910.f, 15920.f, .0055123f, .20681f, 6.3027e-5f, -1.1203e-5f,
				     -.0021942f, -7.6854e-6f, 15920.f, 15930.f, .0025555f, .15612f,
				     .0036149f, -2.367e-5f, 8.1154e-4f, -1.8842e-5f, 15930.f, 15940.f,
				     6.0708e-4f, .15267f, .0069583f, -2.3922e-5f, .0059157f, -3.3379e-5f,
				     15940.f, 15950.f, .0013307f, .12652f, .005072f, -3.1273e-5f, .0029461f,
				     -2.8552e-5f, 15950.f, 15960.f, 1.9184e-4f, .031816f, .010823f,
				     -5.5684e-5f, .0080654f, -5.0132e-5f, 15960.f, 15970.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 0.f, 15970.f, 15980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15980.f,
				     15990.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15990.f, 1.6e4f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     1.6e4f, 16010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16010.f, 16020.f, 0.f, 0.f,
				     0.f, 0.f, 0.f, 0.f, 16020.f, 16030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16030.f,
				     16040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16040.f, 16050.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16050.f, 16060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16060.f,
				     16070.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16070.f, 16080.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16080.f, 16090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16090.f, 16100.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16100.f, 16110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16110.f,
				     16120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16120.f, 16130.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16130.f, 16140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16140.f,
				     16150.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16150.f, 16160.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16160.f, 16170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16170.f, 16180.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16180.f, 16190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16190.f,
				     16200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16200.f, 16210.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16210.f, 16220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16220.f,
				     16230.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16230.f, 16240.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16240.f, 16250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16250.f, 16260.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16260.f, 16270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16270.f,
				     16280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16280.f, 16290.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16290.f, 16300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16300.f,
				     16310.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16310.f, 16320.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16320.f, 16330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16330.f, 16340.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16340.f, 16350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16350.f,
				     16360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16360.f, 16370.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16370.f, 16380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16380.f,
				     16390.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16390.f, 16400.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16400.f, 16410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16410.f, 16420.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16420.f, 16430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16430.f,
				     16440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16440.f, 16450.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16450.f, 16460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16460.f,
				     16470.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16470.f, 16480.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16480.f, 16490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16490.f, 16500.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16500.f, 16510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16510.f,
				     16520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16520.f, 16530.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16530.f, 16540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16540.f,
				     16550.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16550.f, 16560.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16560.f, 16570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16570.f, 16580.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16580.f, 16590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16590.f,
				     16600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16600.f, 16610.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16610.f, 16620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16620.f,
				     16630.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16630.f, 16640.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16640.f, 16650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16650.f, 16660.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16660.f, 16670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16670.f,
				     16680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16680.f, 16690.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16690.f, 16700.f, 9.3657e-4f, .16814f, .0071611f, -3.2337e-5f,
				     .0051118f, -3.429e-5f, 16700.f, 16710.f, .002716f, .13632f, .0024507f,
				     -1.7614e-5f, 6.4545e-4f, -1.7104e-5f, 16710.f, 16720.f, .01021f,
				     .33525f, .0035136f, -2.0013e-5f, .0012395f, -1.7557e-5f, 16720.f,
				     16730.f, .0056241f, .14518f, .0025514f, -6.0743e-6f, 4.0412e-4f,
				     -9.6804e-6f, 16730.f, 16740.f, .0090151f, .16435f, 5.9525e-4f,
				     -7.4453e-6f, -7.7433e-4f, -8.1348e-6f, 16740.f, 16750.f, .017084f,
				     .37569f, .0017092f, -1.0104e-5f, 5.4764e-5f, -1.1565e-5f, 16750.f,
				     16760.f, .004068f, .16946f, .0051318f, -1.2576e-5f, .0021847f,
				     -1.7187e-5f, 16760.f, 16770.f, .014025f, .25075f, -4.9903e-4f,
				     -3.9474e-6f, -.0024356f, -2.4014e-6f, 16770.f, 16780.f, .0084391f,
				     .29482f, .00143f, -1.4909e-5f, -5.8149e-4f, -1.2205e-5f, 16780.f,
				     16790.f, .0042603f, .15728f, -.0017076f, 1.1819e-5f, -.0025115f,
				     1.7886e-6f, 16790.f, 16800.f, .016111f, .35565f, 9.8453e-4f,
				     -1.0561e-5f, -.0015547f, -8.0917e-6f, 16800.f, 16810.f, .032806f,
				     .40538f, 3.2361e-4f, -7.1099e-6f, -.0017591f, -6.4585e-6f, 16810.f,
				     16820.f, .039593f, .37366f, -.0017738f, -3.6504e-6f, -.0044894f,
				     1.5591e-6f, 16820.f, 16830.f, .0041709f, .15463f, -.001046f,
				     -1.7983e-6f, -.0027043f, -2.9685e-6f, 16830.f, 16840.f, .0035117f,
				     .15272f, -.0028931f, 3.0829e-6f, -.0046348f, 4.9372e-6f, 16840.f,
				     16850.f, .014133f, .12212f, -.0040965f, 4.1489e-6f, -.0071928f,
				     1.0033e-5f, 16850.f, 16860.f, .0077536f, .19684f, -.0044631f,
				     8.2821e-6f, -.0062227f, 1.0476e-5f, 16860.f, 16870.f, .025192f, .3428f,
				     -.003503f, 5.8569e-6f, -.0052023f, 7.3334e-6f, 16870.f, 16880.f,
				     .030248f, .27295f, -.0026774f, 1.2042e-6f, -.0042996f, 2.2385e-6f,
				     16880.f, 16890.f, .012936f, .30454f, -.0022564f, -1.1282e-6f,
				     -.0042435f, 1.4398e-6f, 16890.f, 16900.f, .011031f, .24979f, -.0032635f,
				     5.324e-6f, -.0041759f, 4.4122e-6f, 16900.f, 16910.f, .014293f, .29998f,
				     -3.4569e-4f, -9.0328e-6f, -.0021933f, -6.7146e-6f, 16910.f, 16920.f,
				     .0091809f, .29615f, .0023482f, -1.7235e-5f, -5.9956e-4f, -1.1968e-5f,
				     16920.f, 16930.f, .008126f, .323f, 1.1339e-4f, -9.8017e-7f, -.0013639f,
				     -4.0912e-6f, 16930.f, 16940.f, .040319f, .36952f, -.0034585f,
				     7.4285e-6f, -.0043038f, 5.2677e-6f, 16940.f, 16950.f, .013921f, .36738f,
				     -7.7085e-4f, 4.5894e-7f, -.0026272f, -1.4583e-6f, 16950.f, 16960.f,
				     .014345f, .25675f, -.0022235f, 1.8237e-6f, -.0031796f, 3.5185e-6f,
				     16960.f, 16970.f, .016501f, .22846f, -7.3791e-4f, -8.1276e-6f,
				     -.0030972f, -3.4017e-6f, 16970.f, 16980.f, .019984f, .24072f,
				     4.6284e-4f, -1.157e-5f, -.0016535f, -8.0246e-6f, 16980.f, 16990.f,
				     .014605f, .42551f, .0042003f, -2.4403e-5f, .0012313f, -1.961e-5f,
				     16990.f, 1.7e4f, .0056604f, .31925f, .0037029f, -1.1447e-5f, .0028937f,
				     -1.9869e-5f, 1.7e4f, 17010.f, .0063352f, .35092f, .0026893f,
				     -1.5677e-5f, 5.5216e-4f, -1.3231e-5f, 17010.f, 17020.f, .003844f,
				     .22874f, -1.2718e-4f, -9.3893e-8f, -.0018171f, -1.6527e-7f, 17020.f,
				     17030.f, .0013581f, .13591f, .0068077f, -3.5228e-5f, .0039267f,
				     -3.0049e-5f, 17030.f, 17040.f, .0018736f, .25317f, .004094f, -1.115e-5f,
				     .0020737f, -1.6908e-5f, 17040.f, 17050.f, .0012084f, .1688f, -.0010058f,
				     -7.8902e-7f, -.0025863f, -1.1192e-6f, 17050.f, 17060.f, .0010487f,
				     .069135f, .006375f, -3.3619e-5f, .0036725f, -3.0416e-5f, 17060.f,
				     17070.f, 5.0984e-4f, .11462f, .0031391f, -2.153e-5f, 4.5939e-4f,
				     -1.7989e-5f, 17070.f, 17080.f, 8.4428e-4f, .14457f, -5.8124e-4f,
				     -7.7648e-6f, -.0029191f, -4.3661e-6f, 17080.f, 17090.f, 3.0536e-4f,
				     .074835f, 1.5726e-4f, -1.2441e-5f, -.0024876f, -7.6201e-6f, 17090.f,
				     17100.f, 5.526e-4f, .12225f, .0040329f, -2.6244e-5f, .0012152f,
				     -2.1176e-5f, 17100.f, 17110.f, 3.7571e-4f, .06606f, .004893f,
				     -1.7932e-5f, .0027254f, -2.1243e-5f, 17110.f, 17120.f, 3.8817e-4f,
				     .096834f, .0050965f, -2.8072e-5f, .0025414f, -2.5439e-5f, 17120.f,
				     17130.f, 4.3455e-4f, .10332f, .0037899f, -2.5805e-5f, .0011068f,
				     -2.147e-5f, 17130.f, 17140.f, 2.797e-4f, .13222f, .0049706f,
				     -1.1993e-5f, .0022042f, -1.6597e-5f, 17140.f, 17150.f, 3.5542e-4f,
				     .094199f, .0069032f, -3.8399e-5f, .0042436f, -3.3972e-5f, 17150.f,
				     17160.f, 1.4332e-4f, .10096f, .0080342f, -4.4157e-5f, .0052994f,
				     -3.893e-5f, 17160.f, 17170.f, 1.131e-4f, .07032f, .0094132f,
				     -1.9979e-5f, .0084399f, -3.3269e-5f, 17170.f, 17180.f, 1.097e-4f,
				     .073653f, .0070015f, -3.1921e-5f, .0041785f, -3.033e-5f, 17180.f,
				     17190.f, 1.9539e-4f, .11002f, .0025848f, -2.1294e-5f, 1.5132e-4f,
				     -1.7461e-5f, 17190.f, 17200.f, 2.2464e-5f, .040498f, .0015081f,
				     -1.8426e-5f, -8.0302e-4f, -1.3773e-5f, 17200.f, 17210.f, 1.1068e-4f,
				     .041949f, .0011384f, -1.6948e-5f, -.001862f, -1.0906e-5f, 17210.f,
				     17220.f, 2.6372e-4f, .1423f, .0074076f, -9.6003e-7f, .004947f,
				     -1.6056e-5f, 17220.f, 17230.f, 1.6225e-4f, .064754f, 9.1255e-4f,
				     4.5791e-6f, 2.8912e-5f, -2.743e-6f, 17230.f, 17240.f, 3.4492e-4f,
				     .13306f, -.0022341f, -3.1568e-6f, -.0051367f, 2.5216e-6f, 17240.f,
				     17250.f, 2.9083e-4f, .1273f, .014643f, -7.0324e-5f, .011799f,
				     -6.4717e-5f, 17250.f, 17260.f, 7.9159e-5f, .084959f, .0033618f,
				     1.0957e-5f, -1.9083e-6f, 1.5045e-6f, 17260.f, 17270.f, 3.991e-4f,
				     .1611f, .0052228f, -6.6224e-6f, .003315f, -1.7428e-5f, 17270.f, 17280.f,
				     3.6117e-4f, .14552f, .0053239f, -2.7921e-6f, .0027764f, -1.3072e-5f,
				     17280.f, 17290.f, 5.6601e-4f, .2023f, .0081509f, -3.975e-5f, .0051039f,
				     -3.5401e-5f, 17290.f, 17300.f, 5.522e-4f, .27444f, .0022665f,
				     -4.1297e-6f, 6.9271e-4f, -1.2175e-5f, 17300.f, 17310.f, .0012177f,
				     .31594f, .0026446f, -1.1117e-5f, -.0010442f, -7.3851e-6f, 17310.f,
				     17320.f, .0012068f, .36919f, .0046393f, -2.5102e-5f, .001937f,
				     -2.1181e-5f, 17320.f, 17330.f, 8.1484e-4f, .12504f, .0033991f,
				     -2.4509e-5f, -1.7719e-4f, -1.657e-5f, 17330.f, 17340.f, .0010075f,
				     .10415f, .0045176f, -3.0424e-5f, .0016795f, -2.4622e-5f, 17340.f,
				     17350.f, .0014383f, .23566f, .0013476f, -1.0965e-5f, -.0023371f,
				     -4.3633e-6f, 17350.f, 17360.f, 7.8276e-4f, .2229f, -.0015478f,
				     -1.8316e-6f, -.0039408f, 4.9016e-7f, 17360.f, 17370.f, .0023195f,
				     .1644f, .0012573f, -1.668e-5f, -.0019183f, -9.5692e-6f, 17370.f,
				     17380.f, 7.0669e-4f, .18348f, -.001353f, -5.5696e-6f, -.0046409f,
				     1.1901e-6f, 17380.f, 17390.f, .0026577f, .24613f, -3.4475e-4f,
				     -9.149e-6f, -.0027647f, -4.4906e-6f, 17390.f, 17400.f, .0014266f,
				     .18058f, -1.7564e-4f, -3.1091e-6f, -.0023868f, -2.4568e-6f, 17400.f,
				     17410.f, .0013368f, .089183f, -7.5731e-4f, -3.0495e-6f, -.0013138f,
				     -5.5029e-6f, 17410.f, 17420.f, .0031555f, .29805f, -.0014978f,
				     -6.4349e-7f, -.0036817f, 1.3405e-6f, 17420.f, 17430.f, .0015803f,
				     .20706f, .0027308f, -1.4728e-5f, 2.1412e-4f, -1.4434e-5f, 17430.f,
				     17440.f, .0025444f, .19283f, -.0026123f, 3.7928e-6f, -.0040723f,
				     3.3236e-6f, 17440.f, 17450.f, .0028951f, .14488f, 8.2222e-4f,
				     -1.4617e-5f, -.0020986f, -8.6758e-6f, 17450.f, 17460.f, 9.9222e-4f,
				     .058296f, -6.973e-4f, -8.8805e-6f, -.0030012f, -5.1319e-6f, 17460.f,
				     17470.f, .0049761f, .23841f, -.0034073f, 2.1975e-6f, -.00609f,
				     6.7461e-6f, 17470.f, 17480.f, .0024737f, .16103f, -.0033546f,
				     5.2399e-6f, -.0050448f, 4.9288e-6f, 17480.f, 17490.f, 6.5774e-4f,
				     .076908f, -.0048253f, 7.2725e-6f, -.0072344f, 1.1372e-5f, 17490.f,
				     17500.f, 8.5946e-4f, .1372f, -.0034619f, 3.8209e-6f, -.0055141f,
				     6.4456e-6f, 17500.f, 17510.f, 1.3088e-4f, .077214f, 1.0378e-4f,
				     -6.7806e-6f, -.0024574f, -4.3444e-6f, 17510.f, 17520.f, 7.2177e-4f,
				     .12037f, -.0032371f, 3.8429e-6f, -.005706f, 6.3102e-6f, 17520.f,
				     17530.f, .0025932f, .057507f, -.0053841f, 9.3892e-6f, -.0080102f,
				     1.4171e-5f, 17530.f, 17540.f, .0064329f, .34361f, -.0033999f,
				     4.1519e-6f, -.0047285f, 4.1554e-6f, 17540.f, 17550.f, .0020356f,
				     .18182f, -.0031524f, 9.2073e-7f, -.0056549f, 4.9733e-6f, 17550.f,
				     17560.f, .0065331f, .22623f, -.0015636f, -4.1008e-6f, -.0032357f,
				     -2.3034e-6f, 17560.f, 17570.f, .0059972f, .29545f, -6.0272e-4f,
				     -7.9159e-6f, -.0032228f, -3.1603e-6f, 17570.f, 17580.f, .0040039f,
				     .3136f, .0032065f, -2.0617e-5f, 6.7568e-4f, -1.7932e-5f, 17580.f,
				     17590.f, .0016959f, .28903f, .005156f, -1.9347e-5f, .0033983f,
				     -2.1801e-5f, 17590.f, 17600.f, 7.0732e-4f, .16014f, .0010501f,
				     -1.4628e-5f, -.0015478f, -9.7179e-6f, 17600.f, 17610.f, .0012558f,
				     .1798f, .0044641f, -2.5933e-5f, .0019766f, -2.2898e-5f, 17610.f,
				     17620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17620.f, 17630.f, 5.944e-5f,
				     .033158f, .0060208f, -3.6477e-5f, .0032636f, -3.0925e-5f, 17630.f,
				     17640.f, 1.6627e-4f, .041123f, -.0027846f, -1.2553e-6f, -.0055418f,
				     4.2965e-6f, 17640.f, 17650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17650.f,
				     17660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17660.f, 17670.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17670.f, 17680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17680.f,
				     17690.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17690.f, 17700.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17700.f, 17710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17710.f, 17720.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17720.f, 17730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17730.f,
				     17740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17740.f, 17750.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17750.f, 17760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17760.f,
				     17770.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17770.f, 17780.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17780.f, 17790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17790.f, 17800.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17800.f, 17810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17810.f,
				     17820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17820.f, 17830.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17830.f, 17840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17840.f,
				     17850.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17850.f, 17860.f
    };

    /* WATER VAPOR (15300 - 17860 CM-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* wava6 */

void
wava5 (double a[8], const long int inu)
{


    static const float acr[2048] = { 4.6416e-4f, .04653f,
				     .011484f, -5.0228e-5f, .0057564f, -2.8823e-5f, 12740.f, 12750.f,
				     2.6026e-5f, .069686f, .0050381f, -3.0969e-5f, .0023565f, -2.6498e-5f,
				     12750.f, 12760.f, 2.1016e-4f, .078469f, -.0024738f, -2.0423e-6f,
				     -.0056905f, 4.9529e-6f, 12760.f, 12770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12770.f, 12780.f, 6.0427e-5f, .037767f, 5.4219e-4f, -1.4563e-5f,
				     -.002215f, -9.0107e-6f, 12780.f, 12790.f, 2.496e-5f, .041123f,
				     -.0026523f, -1.7845e-6f, -.0054095f, 3.7673e-6f, 12790.f, 12800.f, 0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 12800.f, 12810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12810.f, 12820.f, 6.3228e-5f, .037767f, -6.7259e-4f, -9.7034e-6f,
				     -.0034298f, -4.1516e-6f, 12820.f, 12830.f, 7.0635e-5f, .034814f,
				     .0017376f, -1.9344e-5f, -.0010196f, -1.3792e-5f, 12830.f, 12840.f,
				     3.5776e-5f, .068419f, .0046121f, -2.7372e-5f, .0015491f, -2.2291e-5f,
				     12840.f, 12850.f, 8.2613e-5f, .072444f, .0029409f, -2.2687e-5f,
				     1.2304e-4f, -1.7626e-5f, 12850.f, 12860.f, 1.3149e-5f, .034814f,
				     .0017682f, -1.9467e-5f, -9.8895e-4f, -1.3915e-5f, 12860.f, 12870.f, 0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 12870.f, 12880.f, 1.0952e-5f, .034814f,
				     .0039164f,
				     -2.8059e-5f, .0011592f, -2.2508e-5f, 12880.f, 12890.f, 1.1287e-5f,
				     .037767f, .0031085f, -2.4828e-5f, 3.5131e-4f, -1.9276e-5f, 12890.f,
				     12900.f, 1.2534e-5f, .034814f, .006137f, -3.6942e-5f, .0033798f,
				     -3.139e-5f, 12900.f, 12910.f, 1.9577e-5f, .031771f, .0046608f,
				     -3.1037e-5f, .0019036f, -2.5485e-5f, 12910.f, 12920.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 0.f, 12920.f, 12930.f, 9.153e-6f, .028818f, .0079937f, -4.4369e-5f,
				     .0052366f, -3.8817e-5f, 12930.f, 12940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12940.f, 12950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12950.f, 12960.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12960.f, 12970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,



				     12970.f,
				     12980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12980.f, 12990.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12990.f, 1.3e4f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.3e4f, 13010.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 13010.f, 13020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13020.f, 13030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13030.f, 13040.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13040.f, 13050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13050.f,
				     13060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13060.f, 13070.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13070.f, 13080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13080.f,
				     13090.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13090.f, 13100.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13100.f, 13110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13110.f, 13120.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13120.f, 13130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13130.f,
				     13140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13140.f, 13150.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13150.f, 13160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13160.f,
				     13170.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13170.f, 13180.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13180.f, 13190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13190.f, 13200.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13200.f, 13210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13210.f,
				     13220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13220.f, 13230.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13230.f, 13240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13240.f,
				     13250.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13250.f, 13260.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13260.f, 13270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13270.f, 13280.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13280.f, 13290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13290.f,
				     13300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13300.f, 13310.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13310.f, 13320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13320.f,
				     13330.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13330.f, 13340.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13340.f, 13350.f, 3.4847e-5f, .04882f, .025041f, -1.1142e-4f, .022291f,
				     -1.0647e-4f, 13350.f, 13360.f, 6.4041e-5f, .10448f, .01454f,
				     -4.7733e-5f, .013707f, -6.0524e-5f, 13360.f, 13370.f, 4.8972e-5f,
				     .061588f, .015816f, -3.1234e-5f, .012279f, -4.4662e-5f, 13370.f,
				     13380.f, 3.4101e-4f, .20633f, .0080284f, -9.6908e-6f, .0076822f,
				     -2.8886e-5f, 13380.f, 13390.f, 1.6731e-5f, .03468f, .029361f,
				     -1.2984e-4f, .026604f, -1.2428e-4f, 13390.f, 13400.f, 3.9582e-4f,
				     .10507f, .018729f, -6.1046e-5f, .015312f, -6.0499e-5f, 13400.f, 13410.f,
				     5.7395e-4f, .20422f, .012292f, -3.0378e-5f, .010954f, -4.4352e-5f,
				     13410.f, 13420.f, 1.6304e-4f, .075327f, .024345f, -1.0453e-4f, .022312f,
				     -1.0356e-4f, 13420.f, 13430.f, .0014276f, .27047f, .017891f,
				     -7.3505e-5f, .016458f, -7.1692e-5f, 13430.f, 13440.f, 3.2739e-4f,
				     .19765f, .021521f, -5.2027e-5f, .020205f, -6.8454e-5f, 13440.f, 13450.f,
				     8.4176e-4f, .22651f, .014704f, -5.7138e-5f, .012449f, -5.5586e-5f,
				     13450.f, 13460.f, .003321f, .26989f, .014889f, -6.1022e-5f, .014319f,
				     -6.4594e-5f, 13460.f, 13470.f, .0020184f, .15068f, .014242f,
				     -5.0382e-5f, .014352f, -5.2958e-5f, 13470.f, 13480.f, .0034847f,
				     .23656f, .01296f, -5.4713e-5f, .011654f, -5.3532e-5f, 13480.f, 13490.f,
				     .0051848f, .22152f, .01005f, -4.214e-5f, .010802f, -4.9706e-5f, 13490.f,
				     13500.f, .002246f, .20257f, .011509f, -1.145e-6f, .012567f, -2.9901e-5f,
				     13500.f, 13510.f, .01207f, .22916f, .0070442f, -3.1499e-5f, .0063368f,
				     -3.3814e-5f, 13510.f, 13520.f, .011903f, .21411f, .006383f, -2.2698e-5f,
				     .0062241f, -2.6759e-5f, 13520.f, 13530.f, .009548f, .21575f, .0044827f,
				     -1.1921e-5f, .0055699f, -2.5927e-5f, 13530.f, 13540.f, .011523f,
				     .40682f, .0091253f, -1.9397e-5f, .0079449f, -3.2998e-5f, 13540.f,
				     13550.f, .0084497f, .29293f, .0047841f, -1.1629e-5f, .0057988f,
				     -2.5164e-5f, 13550.f, 13560.f, .026919f, .27673f, .0019766f,
				     -3.7751e-6f, .0016743f, -8.638e-6f, 13560.f, 13570.f, .021945f, .3387f,
				     .005114f, 3.7089e-6f, .0063004f, -2.3091e-5f, 13570.f, 13580.f,
				     .021982f, .18246f, 3.6494e-4f, 1.1207e-6f, -3.7751e-4f, -1.4267e-6f,
				     13580.f, 13590.f, .010404f, .21217f, .0039463f, 5.5125e-6f, .0030886f,
				     -1.2313e-5f, 13590.f, 13600.f, .022785f, .35675f, .0080322f, -4.828e-6f,
				     .0057084f, -1.9313e-5f, 13600.f, 13610.f, .021944f, .17661f, .0028308f,
				     8.2581e-6f, .0014574f, -4.9721e-6f, 13610.f, 13620.f, .015009f, .16917f,
				     .001106f, 1.4866e-5f, .001036f, -3.5775e-6f, 13620.f, 13630.f, .028056f,
				     .27826f, .010985f, -5.284e-5f, .0083121f, -4.5055e-5f, 13630.f, 13640.f,
				     .017905f, .21652f, .0091202f, -4.3033e-5f, .0064523f, -3.6725e-5f,
				     13640.f, 13650.f, .040842f, .16141f, .002459f, -4.3246e-6f, 2.4001e-4f,
				     -1.8088e-6f, 13650.f, 13660.f, .064344f, .36355f, .002624f, -5.0938e-6f,
				     8.4629e-4f, -7.2912e-6f, 13660.f, 13670.f, .098009f, .46873f, .003736f,
				     -2.2472e-5f, .0012376f, -1.8409e-5f, 13670.f, 13680.f, .10223f, .26441f,
				     .0043146f, -2.6517e-5f, .003082f, -2.1843e-5f, 13680.f, 13690.f,
				     .051383f, .36953f, .0029461f, -4.1201e-6f, .001609f, -1.0556e-5f,
				     13690.f, 13700.f, .079035f, .41629f, .0039863f, -1.0096e-5f, .0020593f,
				     -1.5846e-5f, 13700.f, 13710.f, .17862f, .23727f, 7.0664e-4f,
				     -1.3429e-5f, -.0024735f, -6.33e-6f, 13710.f, 13720.f, .023457f, .12905f,
				     -.0022038f, -1.2856e-6f, -.0036094f, 1.0306e-6f, 13720.f, 13730.f,
				     .1498f, .27847f, -7.0337e-4f, -8.8658e-6f, -.0037774f, -2.5192e-6f,
				     13730.f, 13740.f, .15951f, .19705f, -.0012269f, -5.7441e-6f, -.0026138f,
				     -3.9795e-6f, 13740.f, 13750.f, .030444f, .2508f, .001339f, -3.667e-6f,
				     .0013056f, -7.9865e-6f, 13750.f, 13760.f, .091463f, .42355f, .0015252f,
				     -5.082e-6f, 1.0296e-4f, -1.0731e-5f, 13760.f, 13770.f, .055724f,
				     .23315f, 5.0264e-4f, -5.1006e-7f, -.0018097f, -3.8866e-6f, 13770.f,
				     13780.f, .20577f, .30719f, -.0013969f, 1.9333e-6f, -.0029895f,
				     -5.1114e-7f, 13780.f, 13790.f, .076501f, .36547f, .0034715f,
				     -2.4093e-5f, .0010916f, -1.9569e-5f, 13790.f, 13800.f, .26798f, .22416f,
				     -.0016316f, -1.9581e-6f, -.0041508f, 1.1385e-6f, 13800.f, 13810.f,
				     .20338f, .16881f, -.0022177f, -1.1382e-6f, -.0032452f, -1.5814e-7f,
				     13810.f, 13820.f, .12951f, .12548f, -.0038707f, 6.337e-6f, -.0045229f,
				     6.1639e-6f, 13820.f, 13830.f, .088731f, .17991f, -.0038169f, 7.3459e-6f,
				     -.0042642f, 6.6757e-6f, 13830.f, 13840.f, .0067788f, .12625f, .0098132f,
				     -4.8875e-5f, .007723f, -4.7347e-5f, 13840.f, 13850.f, .010502f, .21694f,
				     8.6711e-4f, 4.6135e-6f, .0011488f, -8.9674e-6f, 13850.f, 13860.f,
				     .04906f, .16058f, -.0030216f, 1.0044e-5f, -.0024328f, 6.7471e-6f,
				     13860.f, 13870.f, .24278f, .15261f, -.0051224f, 8.9719e-6f, -.0065887f,
				     1.2603e-5f, 13870.f, 13880.f, .27304f, .29617f, -.003541f, 3.4588e-6f,
				     -.0050128f, 8.099e-6f, 13880.f, 13890.f, .13252f, .25864f, -.0015695f,
				     -2.898e-6f, -.002959f, -3.2727e-6f, 13890.f, 13900.f, .27275f, .14969f,
				     -.0015578f, -4.3912e-6f, -.0023477f, -2.7675e-6f, 13900.f, 13910.f,
				     .28731f, .24848f, -2.6722e-4f, -9.0595e-6f, -.002097f, -6.6308e-6f,
				     13910.f, 13920.f, .20952f, .31628f, .0028828f, -2.1023e-5f, 9.3184e-4f,
				     -1.7842e-5f, 13920.f, 13930.f, .12621f, .34509f, .0047187f, -2.6132e-5f,
				     .0021269f, -2.2662e-5f, 13930.f, 13940.f, .082581f, .35712f, .0065235f,
				     -2.9651e-5f, .0046608f, -2.9306e-5f, 13940.f, 13950.f, .02215f, .56251f,
				     .011273f, -2.023e-5f, .0098905f, -3.5866e-5f, 13950.f, 13960.f,
				     .013395f, .23595f, .0075697f, -1.1677e-5f, .0047404f, -1.3519e-5f,
				     13960.f, 13970.f, .0097251f, .389f, .0045853f, -4.4223e-6f, .0013332f,
				     -8.8812e-6f, 13970.f, 13980.f, .01416f, .3192f, .0014413f, 7.7474e-7f,
				     .0010611f, -6.6038e-6f, 13980.f, 13990.f, .0064431f, .38168f, .0021106f,
				     -5.5268e-6f, 6.2478e-4f, -4.2781e-6f, 13990.f, 1.4e4f, .0074763f,
				     .21449f, 8.6863e-6f, -4.7583e-6f, -.0024648f, -3.1646e-6f, 1.4e4f,
				     14010.f, .0044339f, .31044f, .0062951f, -8.282e-6f, .00239f,
				     -1.0886e-5f, 14010.f, 14020.f, .0063698f, .37192f, .0035714f,
				     -7.0127e-6f, .0022531f, -1.3753e-5f, 14020.f, 14030.f, .0030618f,
				     .32199f, .0067837f, -4.6145e-6f, .0056415f, -1.9199e-5f, 14030.f,
				     14040.f, .0045836f, .19592f, .0034269f, -6.7013e-6f, .0015603f,
				     -2.0576e-6f, 14040.f, 14050.f, .0028921f, .26752f, .0054727f,
				     -8.232e-6f, .0034172f, -1.6235e-5f, 14050.f, 14060.f, .0083604f, .491f,
				     .0036871f, -2.6932e-6f, .0022258f, -1.2432e-5f, 14060.f, 14070.f,
				     .0048958f, .40049f, .0028518f, -8.9707e-6f, 7.3805e-4f, -1.0552e-5f,
				     14070.f, 14080.f, .0060175f, .66182f, .0036922f, -1.2082e-5f, .002131f,
				     -1.7251e-5f, 14080.f, 14090.f, .0051267f, .30376f, .012373f,
				     -5.2388e-5f, .0092416f, -4.9701e-5f, 14090.f, 14100.f, .0051874f,
				     .37923f, .0085604f, -3.2476e-5f, .0048279f, -2.831e-5f, 14100.f,
				     14110.f, .0037549f, .24752f, .0026234f, 1.353e-6f, 1.7089e-4f,
				     -5.9579e-6f, 14110.f, 14120.f, .008547f, .48393f, .0055118f,
				     -1.2616e-5f, .0021682f, -1.5595e-5f, 14120.f, 14130.f, .007167f,
				     .42356f, .0073835f, -3.8638e-5f, .0043338f, -3.2395e-5f, 14130.f,
				     14140.f, .0084611f, .31558f, .0047305f, -1.7484e-5f, .0013223f,
				     -1.1411e-5f, 14140.f, 14150.f, .0086532f, .27748f, .005894f, -3.133e-5f,
				     .0032608f, -2.6952e-5f, 14150.f, 14160.f, .012236f, .32519f, .0020656f,
				     -1.1881e-5f, -4.5247e-4f, -1.1093e-5f, 14160.f, 14170.f, .019531f,
				     .25874f, .0039764f, -2.6715e-5f, .0012538f, -1.9528e-5f, 14170.f,
				     14180.f, .0057931f, .18836f, .0039509f, -2.0877e-5f, .001896f,
				     -1.8677e-5f, 14180.f, 14190.f, .0065709f, .31403f, .0030661f,
				     -6.3795e-6f, .0013225f, -1.1966e-5f, 14190.f, 14200.f, .026818f,
				     .21236f, .0016226f, -1.6759e-5f, -4.3884e-4f, -1.1258e-5f, 14200.f,
				     14210.f, .0015917f, .17083f, .0098825f, -2.9767e-5f, .0059285f,
				     -2.8608e-5f, 14210.f, 14220.f, .036373f, .30478f, 9.7187e-4f,
				     -8.1756e-6f, 8.1092e-5f, -1.0434e-5f, 14220.f, 14230.f, .018351f,
				     .085618f, -.0015427f, -3.9022e-6f, -.0026215f, 7.5823e-7f, 14230.f,
				     14240.f, .027421f, .1672f, -.0016048f, 1.04e-6f, -.0021918f,
				     -7.3937e-7f, 14240.f, 14250.f, .019137f, .34394f, .0054701f,
				     -3.1082e-5f, .0021305f, -2.3894e-5f, 14250.f, 14260.f, .011742f,
				     .24754f, -.0015398f, 1.4005e-6f, -.0032941f, 1.7021e-7f, 14260.f,
				     14270.f, .030406f, .25107f, -.0021777f, 1.1738e-6f, -.0042308f,
				     1.983e-6f, 14270.f, 14280.f, .02572f, .17272f, .0014929f, -1.7124e-5f,
				     -2.0245e-4f, -1.5475e-5f, 14280.f, 14290.f, .023411f, .14155f,
				     -.0036159f, 5.4534e-6f, -.0056547f, 8.3323e-6f, 14290.f, 14300.f,
				     .050436f, .17597f, -.0035358f, 2.7001e-6f, -.005998f, 7.9894e-6f,
				     14300.f, 14310.f, .010835f, .16074f, -.0023328f, 3.6258e-6f, -.0036191f,
				     6.6611e-7f, 14310.f, 14320.f, .0097229f, .1372f, -.0026043f, 3.3682e-6f,
				     -.0039301f, 2.3934e-6f, 14320.f, 14330.f, .0041727f, .26898f,
				     8.9506e-4f, -3.3799e-6f, -8.0987e-4f, -7.4366e-6f, 14330.f, 14340.f,
				     .0028313f, .11399f, -.0023514f, 1.9057e-8f, -.0043191f, 3.2086e-6f,
				     14340.f, 14350.f, .0094087f, .13847f, -.0033995f, 5.3082e-6f,
				     -.0048841f, 7.2565e-6f, 14350.f, 14360.f, .045453f, .1618f, -.0049821f,
				     9.5517e-6f, -.0062627f, 1.3183e-5f, 14360.f, 14370.f, .05478f, .246f,
				     -.003323f, 3.3083e-6f, -.0044595f, 4.3249e-6f, 14370.f, 14380.f,
				     .057794f, .29926f, -.0018524f, -2.6891e-6f, -.0034713f, -1.4711e-6f,
				     14380.f, 14390.f, .017789f, .040974f, -5.5041e-4f, -9.0402e-6f,
				     -.0019035f, -4.1538e-6f, 14390.f, 14400.f, .066509f, .31802f,
				     1.7874e-4f, -1.0469e-5f, -.0014428f, -9.3839e-6f, 14400.f, 14410.f,
				     .033243f, .21287f, .0023294f, -1.8667e-5f, -4.0745e-4f, -1.2383e-5f,
				     14410.f, 14420.f, .030315f, .32935f, .005459f, -3.1244e-5f, .0033095f,
				     -2.8644e-5f, 14420.f, 14430.f, .011921f, .16637f, .0064852f,
				     -3.2883e-5f, .0040894f, -2.982e-5f, 14430.f, 14440.f, .0035817f,
				     .24062f, .010713f, -2.2991e-5f, .0076719f, -3.0879e-5f, 14440.f,
				     14450.f, .0020434f, .09533f, .0074555f, -4.0758e-5f, .003952f,
				     -3.2281e-5f, 14450.f, 14460.f, .0019531f, .057626f, .013393f,
				     -6.572e-5f, .010648f, -6.0338e-5f, 14460.f, 14470.f, .0015972f,

				     .063531f, -.0028566f, -9.3552e-7f, -.0057668f, 5.2381e-6f, 14470.f,
				     14480.f, 6.208e-4f, .14581f, -.0038143f, 3.5516e-6f, -.006417f,
				     7.6586e-6f, 14480.f, 14490.f, 2.573e-4f, .034903f, .0017376f,
				     -1.9344e-5f, -.0010196f, -1.3792e-5f, 14490.f, 14500.f, 5.8326e-4f,
				     .07101f, .0037987f, -2.7471e-5f, .0011761f, -2.2502e-5f, 14500.f,
				     14510.f, 1.981e-4f, .037767f, 5.4219e-4f, -1.4563e-5f, -.002215f,
				     -9.0107e-6f, 14510.f, 14520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14520.f,
				     14530.f, 6.1723e-4f, .05996f, .0029608f, -2.3205e-5f, -5.41e-4f,
				     -1.4715e-5f, 14530.f, 14540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14540.f,
				     14550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14550.f, 14560.f, 8.7384e-4f,
				     .20577f, .001467f, -1.2035e-5f, -.0013037f, -8.5219e-6f, 14560.f,
				     14570.f, 3.6981e-4f, .15319f, .0026086f, 5.1176e-7f, -9.4964e-4f,
				     -4.1621e-6f, 14570.f, 14580.f, 5.3062e-4f, .2039f, -9.2668e-4f,
				     -1.7265e-6f, -.0025209f, -3.9176e-6f, 14580.f, 14590.f, 2.3625e-4f,
				     .10952f, 3.608e-5f, -6.6963e-7f, -.0029777f, -5.5782e-7f, 14590.f,
				     14600.f, 2.5529e-4f, .085175f, .0086357f, -4.5158e-5f, .0055824f,
				     -3.9246e-5f, 14600.f, 14610.f, 3.5469e-4f, .17005f, 5.5905e-4f,
				     3.4517e-6f, -.0012201f, -2.0532e-6f, 14610.f, 14620.f, 1.4962e-4f,
				     .070668f, 3.6006e-4f, -1.3091e-5f, -.002318f, -8.0334e-6f, 14620.f,
				     14630.f, 1.6283e-4f, .043851f, -.0019069f, -4.7662e-6f, -.0047857f,
				     1.0305e-6f, 14630.f, 14640.f, 3.4849e-4f, .091227f, 1.957e-4f,
				     -6.7027e-6f, -.0019067f, -6.8831e-6f, 14640.f, 14650.f, 2.4098e-4f,
				     .073915f, 5.8149e-4f, 2.017e-6f, -.0021878f, -6.9336e-7f, 14650.f,
				     14660.f, 1.8929e-4f, .040095f, -9.767e-4f, -8.487e-6f, -.003815f,
				     -2.7719e-6f, 14660.f, 14670.f, 2.8551e-4f, .089939f, 9.0134e-4f,
				     -1.5963e-5f, -.0017529f, -1.0799e-5f, 14670.f, 14680.f, 1.3624e-4f,
				     .063104f, .0051307f, -3.2797e-5f, .002189f, -2.6775e-5f, 14680.f,
				     14690.f, 9.1275e-5f, .031681f, .0031085f, -2.4828e-5f, 3.5131e-4f,
				     -1.9276e-5f, 14690.f, 14700.f, 8.8122e-5f, .040141f, .0011384f,
				     -1.6948e-5f, -.0017809f, -1.1069e-5f, 14700.f, 14710.f, 0.f, 0.f, 0.f,
				     0.f, 0.f, 0.f, 14710.f, 14720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14720.f,
				     14730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14730.f, 14740.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14740.f, 14750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14750.f,
				     14760.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14760.f, 14770.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14770.f, 14780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14780.f, 14790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14790.f, 14800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14800.f,
				     14810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14810.f, 14820.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14820.f, 14830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14830.f,
				     14840.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14840.f, 14850.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14850.f, 14860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14860.f, 14870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14870.f, 14880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14880.f,
				     14890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14890.f, 14900.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14900.f, 14910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14910.f,
				     14920.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14920.f, 14930.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14930.f, 14940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14940.f, 14950.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14950.f, 14960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14960.f,
				     14970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14970.f, 14980.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14980.f, 14990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14990.f, 1.5e4f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.5e4f, 15010.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15010.f, 15020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15020.f, 15030.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15030.f, 15040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15040.f,
				     15050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15050.f, 15060.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15060.f, 15070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15070.f,
				     15080.f,
				     7.1934e-4f, .12682f, .0061012f, 1.5559e-5f, .0027848f, -4.5145e-6f,
				     15080.f, 15090.f, 4.9571e-4f, .13321f, .0050157f, 1.7658e-5f, .0024032f,
				     -4.0605e-6f, 15090.f, 15100.f, 2.2621e-4f, .12674f, .016133f,
				     -6.1229e-5f, .013281f, -6.2746e-5f, 15100.f, 15110.f, 8.5668e-4f,
				     .12425f, .016195f, -7.6668e-5f, .013811f, -7.25e-5f, 15110.f, 15120.f,
				     5.5721e-4f, .11061f, .0048501f, 3.2762e-5f, .0041846f, 4.2515e-7f,
				     15120.f, 15130.f, .0010214f, .16075f, .0077437f, -9.7938e-6f, .0033244f,
				     -1.335e-5f, 15130.f, 15140.f, .0037351f, .23141f, .0075468f,
				     -1.8073e-5f, .0038208f, -1.7101e-5f, 15140.f, 15150.f, 6.9279e-4f,
				     .16527f, .0092564f, -2.4217e-5f, .0059447f, -2.8136e-5f, 15150.f,
				     15160.f, .0020924f, .19937f, .0067646f, -1.9228e-5f, .0021429f,
				     -1.4011e-5f, 15160.f, 15170.f, .0029213f, .11019f, .0078105f,
				     -4.068e-5f, .0061601f, -3.7164e-5f, 15170.f, 15180.f, .0040031f, .2888f,
				     .0050758f, -1.9158e-5f, .0019869f, -1.728e-5f, 15180.f, 15190.f,
				     .0024252f, .15747f, .0044234f, -2.0027e-5f, 3.4479e-4f, -1.2338e-5f,
				     15190.f, 15200.f, .0087795f, .14543f, .0042621f, -2.7308e-5f,
				     7.3031e-4f, -1.681e-5f, 15200.f, 15210.f, .0095997f, .374f, .0046013f,
				     -2.8568e-5f, .002061f, -2.4098e-5f, 15210.f, 15220.f, 9.5938e-4f,
				     .22877f, .0032518f, -1.2364e-5f, .00118f, -1.6396e-5f, 15220.f, 15230.f,
				     .0089911f, .27602f, .0015486f, -1.7622e-5f, -7.0027e-4f, -1.3639e-5f,
				     15230.f, 15240.f, .0070384f, .19525f, .0017332f, -1.8418e-5f,
				     -.0010753f, -1.2514e-5f, 15240.f, 15250.f, .012889f, .20893f,
				     5.2643e-4f, -8.5726e-6f, -8.0955e-4f, -8.4315e-6f, 15250.f, 15260.f,
				     .01071f, .10552f, -.0015016f, -6.0962e-6f, -.0038322f, -1.9428e-6f,
				     15260.f, 15270.f, .011725f, .11142f, -.0024386f, -2.089e-6f, -.0045783f,
				     1.5311e-6f, 15270.f, 15280.f, .0036695f, .13405f, -.0019794f,
				     1.4362e-7f, -.0035859f, 2.0003e-6f, 15280.f, 15290.f, .0038912f,
				     .14992f, -3.0601e-5f, 8.2096e-6f, -1.4088e-4f, -1.393e-6f, 15290.f,
				     15300.f
    };

    /*  WATER VAPOR (12740 - 15280 CM-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* wava5 */

void
wava4 (double a[8], const long int inu)
{


    static const float acr[2048] = { .037011f, .34865f,
				     .0071795f, -2.429e-5f, .0061217f, -2.5788e-5f, 10180.f, 10190.f,
				     .096531f, .1963f, .0044353f, -2.7769e-5f, .0020496f, -1.902e-5f,
				     10190.f, 10200.f, .11553f, .22356f, .0057418f, -2.861e-5f, .005252f,
				     -3.0274e-5f, 10200.f, 10210.f, .17877f, .25357f, .0036991f, -1.9865e-5f,
				     .0035644f, -1.5681e-5f, 10210.f, 10220.f, .094449f, .35387f, .0021016f,
				     -1.5037e-5f, 5.8316e-4f, -1.1084e-5f, 10220.f, 10230.f, .079869f,
				     .2603f, .0051322f, -2.0923e-5f, .0039204f, -2.2157e-5f, 10230.f,
				     10240.f, .30687f, .32758f, 6.3705e-4f, -9.1396e-6f, 2.5647e-4f,
				     -3.6374e-6f, 10240.f, 10250.f, .15358f, .13982f, -8.3666e-4f,
				     3.3048e-6f, .0027185f, 1.2493e-5f, 10250.f, 10260.f, .38232f, .35543f,
				     -.0010313f, -1.8768e-6f, -.0016001f, 3.8356e-7f, 10260.f, 10270.f,
				     .0562f, .34487f, .0036934f, 7.3751e-6f, .0070064f, -1.2975e-5f, 10270.f,
				     10280.f, .11137f, .21188f, -.0024327f, 1.6553e-5f, -3.0535e-4f,
				     1.9603e-5f, 10280.f, 10290.f, .16704f, .162f, -.0028871f, 9.8108e-6f,
				     -4.298e-4f, 1.7309e-5f, 10290.f, 10300.f, .15496f, .19365f, -.0025906f,
				     1.7434e-5f, -3.5463e-4f, 8.1537e-6f, 10300.f, 10310.f, .050239f,
				     .44504f, .0082014f, 4.7362e-5f, .0097304f, -1.0209e-5f, 10310.f,
				     10320.f, .21509f, .29651f, -.0021764f, 2.0847e-5f, -2.3124e-4f,
				     1.0958e-5f, 10320.f, 10330.f, .15838f, .17695f, -.0019477f, 2.8641e-6f,
				     -.0031011f, 6.2742e-6f, 10330.f, 10340.f, .45807f, .42831f, -4.7039e-5f,
				     1.6616e-5f, .001452f, 6.4036e-6f, 10340.f, 10350.f, .14196f, .4315f,
				     .0032845f, 1.8573e-5f, .0044632f, -3.8921e-6f, 10350.f, 10360.f,
				     .46768f, .4897f, .0030587f, -9.9296e-6f, .0017377f, -1.2227e-5f,
				     10360.f, 10370.f, .49107f, .45881f, .0017676f, 2.3059e-5f, .0037946f,
				     -7.9699e-6f, 10370.f, 10380.f, .40709f, .39513f, .0024501f, 3.4328e-6f,
				     .0033911f, -1.6475e-5f, 10380.f, 10390.f, .53368f, .30449f, .002764f,
				     1.6491e-5f, .0031852f, -7.9335e-6f, 10390.f, 10400.f, .50598f, .38596f,
				     .0011335f, 7.9179e-6f, .0016436f, -4.2442e-6f, 10400.f, 10410.f,
				     .36712f, .58535f, .0035486f, -2.5563e-6f, .0025513f, -1.2028e-5f,
				     10410.f, 10420.f, .98775f, .50104f, .0056199f, -1.6902e-5f, .0043563f,
				     -2.6045e-5f, 10420.f, 10430.f, .76493f, .41145f, .0027287f, -1.2684e-5f,
				     9.6642e-4f, -1.2013e-5f, 10430.f, 10440.f, .4518f, .45681f, .0055394f,
				     -1.8929e-5f, .0049043f, -2.5553e-5f, 10440.f, 10450.f, .93845f, .25977f,
				     .0063165f, -3.3633e-5f, .0030572f, -2.3591e-5f, 10450.f, 10460.f,
				     1.0799f, .52983f, .0049753f, -2.2413e-5f, .0037285f, -1.9018e-5f,
				     10460.f, 10470.f, 1.9954f, .24666f, .0043881f, -2.9035e-5f, .0020409f,
				     -2.1664e-5f, 10470.f, 10480.f, .53954f, .3608f, .0038367f, -2.492e-5f,
				     .0016345f, -2.0659e-5f, 10480.f, 10490.f, 1.9042f, .28357f, .0020331f,
				     -1.9809e-5f, 1.178e-4f, -1.5063e-5f, 10490.f, 10500.f, 1.3639f, .41799f,
				     .0017903f, -1.4939e-5f, 7.7921e-4f, -1.3895e-5f, 10500.f, 10510.f,
				     .27245f, .53566f, .0028306f, -2.1067e-6f, .0041171f, -1.2108e-5f,
				     10510.f, 10520.f, 4.225f, .34405f, -9.2601e-4f, -5.8016e-6f, -.0020236f,
				     -9.379e-7f, 10520.f, 10530.f, .41591f, .38497f, .004158f, 5.6585e-6f,
				     .0031671f, -1.1552e-5f, 10530.f, 10540.f, 2.4868f, .21796f, -.0020342f,
				     2.1116e-6f, -.0020977f, 3.2759e-6f, 10540.f, 10550.f, .9442f, .51349f,
				     .0018825f, 2.2079e-6f, .0015856f, -8.8233e-6f, 10550.f, 10560.f, 2.139f,
				     .25647f, -.0019634f, 7.9808e-6f, -.0024854f, 4.6652e-6f, 10560.f,
				     10570.f, 1.3917f, .33676f, .0035449f, -2.0344e-5f, 3.2271e-4f,
				     -1.2565e-5f, 10570.f, 10580.f, 5.9303f, .30084f, 1.3471e-4f,
				     -5.1658e-6f, -.0018823f, -4.8751e-6f, 10580.f, 10590.f, 1.0087f,
				     .13259f, -.0014095f, -4.7735e-6f, -.0024541f, 2.6832e-6f, 10590.f,
				     10600.f, 4.3983f, .19046f, -.0034725f, 2.4224e-6f, -.0053127f,
				     7.1676e-6f, 10600.f, 10610.f, .96572f, .30982f, -.0027372f, 6.8946e-6f,
				     -.0023672f, 8.3925e-6f, 10610.f, 10620.f, .91323f, .32206f, -.0024872f,
				     3.2962e-6f, -.0026005f, 2.0821e-6f, 10620.f, 10630.f, .64383f, .32142f,
				     -.0040036f, 1.1751e-5f, -.0046913f, 1.096e-5f, 10630.f, 10640.f,
				     .20419f, .32226f, -.0010057f, 3.7593e-7f, -.0012761f, -1.9796e-6f,
				     10640.f, 10650.f, 3.2582f, .41089f, -.0042525f, 1.1056e-5f, -.003553f,
				     1.043e-5f, 10650.f, 10660.f, 4.0011f, .26987f, -.0041265f, 6.8604e-6f,
				     -.0047731f, 8.9525e-6f, 10660.f, 10670.f, 2.3087f, .2861f, -.0029291f,
				     1.5494e-6f, -.0036647f, 3.1219e-6f, 10670.f, 10680.f, 5.0379f, .43636f,
				     -4.8143e-4f, 6.8393e-6f, -.0011602f, 8.769e-7f, 10680.f, 10690.f,
				     3.4572f, .24029f, -3.8723e-4f, -8.7391e-6f, -4.4231e-4f, -7.617e-6f,
				     10690.f, 10700.f, 3.4164f, .31894f, 5.1822e-4f, -9.7127e-6f,
				     -8.7127e-5f, -1.1526e-5f, 10700.f, 10710.f, 1.9975f, .24091f, .0020391f,
				     -1.8108e-5f, 8.1249e-4f, -1.3281e-5f, 10710.f, 10720.f, 1.8993f,
				     .38637f, .0046303f, -2.5016e-5f, .0035053f, -2.2372e-5f, 10720.f,
				     10730.f, 1.958f, .33984f, .0057686f, -3.2398e-5f, .0041169f, -2.863e-5f,
				     10730.f, 10740.f, .56316f, .41883f, .011363f, -4.522e-5f, .0082366f,
				     -3.7842e-5f, 10740.f, 10750.f, .35401f, .69851f, .010496f, -2.1851e-5f,
				     .0066866f, -2.4626e-5f, 10750.f, 10760.f, .19707f, .69982f, .010773f,
				     -9.278e-6f, .0083529f, -1.8664e-5f, 10760.f, 10770.f, .2189f, .61722f,
				     .0026481f, 1.4368e-5f, .0037728f, -1.6702e-7f, 10770.f, 10780.f,

				     .055267f, .6593f, .007075f, 3.4583e-6f, .0056327f, -1.8713e-5f, 10780.f,
				     10790.f, .082626f, .56771f, .0014488f, 9.0784e-6f, .0015016f,
				     -4.5502e-6f, 10790.f, 10800.f, .070929f, .31037f, 3.4662e-6f,
				     4.3968e-6f, -6.1123e-4f, -1.1496e-7f, 10800.f, 10810.f, .097418f,
				     .44409f, -3.1642e-4f, 5.1491e-6f, -.0010289f, -1.8238e-6f, 10810.f,
				     10820.f, .084947f, .43514f, .0039381f, -1.2895e-6f, .0026186f,
				     -1.3069e-5f, 10820.f, 10830.f, .05826f, .18252f, .0019735f, -6.3696e-6f,
				     -5.8857e-4f, -5.1048e-6f, 10830.f, 10840.f, .11036f, .40791f, .0027504f,
				     5.4669e-6f, .0010814f, -7.3999e-6f, 10840.f, 10850.f, .063822f, .3839f,
				     .0050367f, -2.0231e-5f, .0028937f, -1.8685e-5f, 10850.f, 10860.f,
				     .010028f, .29145f, .0059963f, -2.3315e-5f, .0034252f, -2.032e-5f,
				     10860.f, 10870.f, .12414f, .24481f, .0065529f, -3.7402e-5f, .0035139f,
				     -3.0249e-5f, 10870.f, 10880.f, .14508f, .36269f, -3.4622e-4f,
				     7.2138e-6f, -3.3853e-4f, 7.4773e-7f, 10880.f, 10890.f, .32952f, .51235f,
				     .001156f, -9.9464e-6f, -.0017097f, -6.9684e-6f, 10890.f, 10900.f,
				     .081689f, .43746f, .002472f, -8.5593e-6f, 8.107e-4f, -1.0007e-5f,
				     10900.f, 10910.f, .36297f, .47635f, -7.551e-4f, 3.2155e-6f, -.001416f,
				     1.3385e-6f, 10910.f, 10920.f, .21833f, .56037f, .0015815f, -1.3282e-5f,
				     2.7446e-4f, -1.2751e-5f, 10920.f, 10930.f, .062283f, .46899f, .003716f,
				     9.7049e-7f, .0030288f, -1.3634e-5f, 10930.f, 10940.f, .49012f, .36842f,
				     -8.7423e-4f, -6.7163e-6f, -.0022164f, -2.6838e-6f, 10940.f, 10950.f,
				     .14742f, .42276f, .0021422f, 5.937e-6f, 8.8387e-4f, -6.8671e-6f,
				     10950.f, 10960.f, .281f, .22881f, -.0022496f, -9.4548e-7f, -.0031883f,
				     4.4808e-7f, 10960.f, 10970.f, .22513f, .41493f, .0036269f, -1.6185e-5f,
				     .0017037f, -1.7793e-5f, 10970.f, 10980.f, .21994f, .21688f, -.0036261f,
				     5.7974e-6f, -.0041527f, 8.0739e-6f, 10980.f, 10990.f, .14084f, .33322f,
				     1.3752e-4f, -6.2038e-6f, -.0011146f, -6.0724e-6f, 10990.f, 1.1e4f,
				     .323f, .17636f, -.0013536f, -5.8665e-7f, -.0024854f, -3.0662e-7f,
				     1.1e4f, 11010.f, .4018f, .22575f, -.0022932f, -2.3319e-6f, -.0044015f,
				     2.451e-6f, 11010.f, 11020.f, .40187f, .17827f, -.0028707f, 1.5665e-6f,
				     -.0044357f, 3.1485e-6f, 11020.f, 11030.f, .096411f, .21466f, -.0022778f,
				     4.124e-6f, -.0027585f, 2.0224e-6f, 11030.f, 11040.f, .096343f, .15703f,
				     -.0022356f, 1.5369e-6f, -.0030654f, -3.2505e-7f, 11040.f, 11050.f,
				     .079848f, .17965f, -.0020125f, 9.6504e-6f, -.00326f, 5.3659e-6f,
				     11050.f, 11060.f, .062139f, .10557f, -.0040683f, 9.3909e-6f, -.0047053f,
				     1.0347e-5f, 11060.f, 11070.f, .25071f, .1119f, -.0048932f, 9.8071e-6f,
				     -.0052555f, 9.7232e-6f, 11070.f, 11080.f, .50363f, .18561f, -.0040852f,
				     4.7194e-6f, -.0061085f, 9.9471e-6f, 11080.f, 11090.f, .23621f, .35575f,
				     -6.9998e-4f, -3.8983e-7f, -7.4838e-4f, -6.3021e-6f, 11090.f, 11100.f,
				     .41715f, .20786f, -.0026671f, -8.5957e-7f, -.0044855f, 3.6346e-6f,
				     11100.f, 11110.f, .35497f, .15568f, -2.0655e-4f, -1.0414e-5f,
				     -.0019241f, -7.491e-6f, 11110.f, 11120.f, .36391f, .22115f, 8.0888e-5f,
				     -8.0079e-6f, -7.2043e-4f, -8.8371e-6f, 11120.f, 11130.f, .239f, .19893f,
				     .0017314f, -1.745e-5f, -7.2547e-4f, -1.0781e-5f, 11130.f, 11140.f,
				     .18535f, .23329f, .0044356f, -2.4159e-5f, .002562f, -2.1329e-5f,
				     11140.f, 11150.f, .18058f, .20287f, .0053731f, -2.948e-5f, .0026609f,
				     -2.2876e-5f, 11150.f, 11160.f, .086563f, .18472f, .0071342f,
				     -3.4497e-5f, .0062094f, -3.7103e-5f, 11160.f, 11170.f, .040545f,
				     .27173f, .012595f, -5.3501e-5f, .0098569f, -5.1164e-5f, 11170.f,
				     11180.f, .015934f, .21414f, .021094f, -9.1779e-5f, .018771f,
				     -8.8619e-5f, 11180.f, 11190.f, .032149f, .20819f, .0053736f, 4.7418e-6f,
				     .0028308f, -3.9739e-6f, 11190.f, 11200.f, .0033026f, .1125f, -.0049337f,
				     8.3861e-6f, -.0074414f, 1.2308e-5f, 11200.f, 11210.f, .0069621f,
				     .11936f, .002482f, 1.4188e-5f, .0041457f, -7.6324e-6f, 11210.f, 11220.f,
				     .0018624f, .073437f, .0037334f, 6.4996e-5f, .0021277f, 2.507e-5f,
				     11220.f, 11230.f, .0056133f, .14671f, 5.7744e-4f, -1.0633e-5f,
				     -.0020996f, -6.969e-6f, 11230.f, 11240.f, 5.9301e-4f, .13188f,
				     .0043109f, -2.7217e-5f, .0014102f, -2.1872e-5f, 11240.f, 11250.f,
				     .0062071f, .08021f, .0031276f, -2.2059e-5f, 6.1977e-4f, -1.6464e-5f,
				     11250.f, 11260.f, 7.0445e-4f, .090176f, .006354f, -1.7728e-5f,
				     .0035488f, -2.1566e-5f, 11260.f, 11270.f, .0024343f, .082442f,
				     -1.2318e-4f, -1.1355e-5f, -.0023203f, -8.0507e-6f, 11270.f, 11280.f,
				     .0053124f, .10493f, .002512f, -2.1412e-5f, -2.5472e-4f, -1.6312e-5f,
				     11280.f, 11290.f, .0010156f, .075674f, .0067257f, -3.904e-5f, .0037539f,
				     -3.2659e-5f, 11290.f, 11300.f, 4.5845e-4f, .031771f, .0083901f,
				     -4.5954e-5f, .005633f, -4.0402e-5f, 11300.f, 11310.f, .0013128f, .1362f,
				     .0032287f, -2.4445e-5f, 6.7354e-4f, -2.006e-5f, 11310.f, 11320.f,
				     9.1527e-4f, .043387f, .013028f, -6.4031e-5f, .010684f, -6.015e-5f,
				     11320.f, 11330.f, .0016381f, .11364f, .0082323f, -4.1843e-5f, .0046964f,
				     -3.5054e-5f, 11330.f, 11340.f, 8.2138e-4f, .051673f, .0074756f,
				     -4.1981e-5f, .0051092f, -3.7995e-5f, 11340.f, 11350.f, 8.2766e-4f,
				     .072646f, .0053277f, -3.266e-5f, .0034473f, -3.0783e-5f, 11350.f,
				     11360.f, 2.9086e-4f, .031771f, .0094981f, -5.0386e-5f, .0067409f,
				     -4.4834e-5f, 11360.f, 11370.f, 2.1807e-4f, .058942f, .015709f,
				     -5.9258e-5f, .013592f, -6.3956e-5f, 11370.f, 11380.f, 6.2704e-4f,
				     .12257f, .010699f, -4.9284e-5f, .0095849f, -5.3234e-5f, 11380.f,
				     11390.f, 1.0702e-4f, .028818f, .0079994f, -4.4391e-5f, .0052422f,
				     -3.8839e-5f, 11390.f, 11400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11400.f,
				     11410.f, 2.2042e-4f, .065689f, .016094f, -7.5895e-5f, .013589f,
				     -7.1741e-5f, 11410.f, 11420.f, 8.1809e-5f, .030563f, .019812f,
				     -9.1641e-5f, .017055f, -8.6089e-5f, 11420.f, 11430.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 0.f, 11430.f, 11440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11440.f,
				     11450.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11450.f, 11460.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11460.f, 11470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11470.f, 11480.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11480.f, 11490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11490.f,
				     11500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11500.f, 11510.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11510.f, 11520.f, 6.8748e-6f, .028818f, .014135f, -6.8935e-5f,
				     .011378f, -6.3383e-5f, 11520.f, 11530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11530.f, 11540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11540.f, 11550.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11550.f, 11560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11560.f,
				     11570.f, 1.1592e-5f, .037767f, .0031085f, -2.4828e-5f, 3.5131e-4f,
				     -1.9276e-5f, 11570.f, 11580.f, 1.2377e-4f, .091349f, .012838f,
				     -3.6325e-5f, .0084626f, -3.8447e-5f, 11580.f, 11590.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 0.f, 11590.f, 11600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11600.f,
				     11610.f,
				     2.7776e-4f, .099768f, .016197f, -7.1636e-5f, .012877f, -6.2598e-5f,
				     11610.f, 11620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11620.f, 11630.f,
				     6.0387e-4f, .079303f, .011427f, -5.6399e-5f, .0076314f, -4.5247e-5f,
				     11630.f, 11640.f, 8.3575e-5f, .082334f, .015996f, -7.3351e-5f, .013978f,
				     -7.131e-5f, 11640.f, 11650.f, 2.7734e-4f, .028818f, .012698f,
				     -6.3185e-5f, .0099405f, -5.7633e-5f, 11650.f, 11660.f, .0013776f,
				     .1275f, .0089606f, -4.0931e-5f, .006208f, -3.6077e-5f, 11660.f, 11670.f,
				     4.5458e-4f, .05909f, .0073062f, -4.1015e-5f, .0053622f, -3.8549e-5f,
				     11670.f, 11680.f, .0019815f, .15477f, .006225f, -3.2087e-5f, .0049876f,
				     -3.2313e-5f, 11680.f, 11690.f, 9.9572e-4f, .08831f, .0056347f,
				     -2.7093e-5f, .0037058f, -2.8108e-5f, 11690.f, 11700.f, .0025341f,
				     .10399f, .0032192f, -2.1942e-5f, .0010784f, -1.8674e-5f, 11700.f,
				     11710.f, .001691f, .18929f, .0042421f, -2.4597e-5f, .0031654f,
				     -2.3807e-5f, 11710.f, 11720.f, .001706f, .12598f, 6.5013e-4f,
				     -1.3447e-5f, -.0021977f, -8.4803e-6f, 11720.f, 11730.f, .0032703f,
				     .1478f, .0014549f, -1.0754e-5f, 3.5403e-4f, -1.3234e-5f, 11730.f,
				     11740.f, .0055601f, .15726f, -.0020459f, -2.8933e-6f, -.0040613f,
				     2.3816e-6f, 11740.f, 11750.f, .0023988f, .10521f, -8.9604e-5f,
				     -8.9256e-6f, -.0019341f, -4.1252e-6f, 11750.f, 11760.f, .0021014f,
				     .20346f, .001557f, -3.876e-7f, 4.2674e-4f, -7.4882e-6f, 11760.f,
				     11770.f, .0044559f, .17649f, -.0026665f, 2.6782e-6f, -.0043678f,
				     1.1412e-5f, 11770.f, 11780.f, .0024355f, .1438f, -.0030347f, 1.3498e-5f,
				     -.0029099f, 8.3348e-6f, 11780.f, 11790.f, .0012088f, .14652f, .0043364f,
				     -2.3499e-5f, .004136f, -2.5136e-5f, 11790.f, 11800.f, 3.5615e-4f,
				     .076935f, -4.1654e-4f, 1.6868e-5f, -3.6975e-4f, 6.6392e-6f, 11800.f,
				     11810.f, .0033205f, .14642f, -.0022883f, 1.5563e-5f, -.0011424f,
				     6.601e-6f, 11810.f, 11820.f, 9.6482e-4f, .11674f, -.0020293f,
				     3.3475e-5f, .0018153f, 1.8034e-5f, 11820.f, 11830.f, .0025468f, .23891f,
				     -3.7386e-4f, 2.5112e-5f, -7.037e-4f, 1.2657e-5f, 11830.f, 11840.f,
				     .003978f, .19525f, .0017761f, 1.7009e-5f, .0028654f, 9.7695e-7f,
				     11840.f, 11850.f, .009308f, .22287f, -.0028141f, 6.1915e-6f, -.0035846f,
				     9.0001e-6f, 11850.f, 11860.f, .0011913f, .14817f, .0011043f, 4.7279e-5f,
				     .0021704f, 1.6632e-5f, 11860.f, 11870.f, .010095f, .3319f, -3.025e-4f,
				     2.7919e-5f, 4.6706e-4f, 1.3481e-5f, 11870.f, 11880.f, .0094837f,
				     .29542f, .0041573f, -4.5489e-6f, .0046629f, -1.3608e-5f, 11880.f,
				     11890.f, .0057807f, .16128f, .0022948f, 3.093e-5f, .0032856f,
				     7.3247e-6f, 11890.f, 11900.f, .0090317f, .33992f, .0064901f, 1.3104e-5f,
				     .0058385f, -1.237e-5f, 11900.f, 11910.f, .0034946f, .17472f, 9.0274e-4f,
				     9.569e-6f, 7.5517e-4f, 7.6716e-7f, 11910.f, 11920.f, .010712f, .34337f,
				     .0057845f, 3.273e-6f, .0051567f, -1.5291e-5f, 11920.f, 11930.f,
				     .018599f, .48317f, .010589f, -3.4336e-5f, .0073964f, -3.6504e-5f,
				     11930.f, 11940.f, .011137f, .31418f, .0088066f, -1.9115e-5f, .0066643f,
				     -2.5755e-5f, 11940.f, 11950.f, .014277f, .15769f, .010665f, -4.2217e-5f,
				     .0066305f, -3.2258e-5f, 11950.f, 11960.f, .027875f, .26865f, .010692f,
				     -4.8825e-5f, .007738f, -4.3664e-5f, 11960.f, 11970.f, .012682f, .20777f,
				     .010603f, -4.8734e-5f, .0081358f, -4.1884e-5f, 11970.f, 11980.f,
				     .036127f, .20496f, .0077739f, -4.0475e-5f, .0055098f, -3.2025e-5f,
				     11980.f, 11990.f, .026197f, .26047f, .0093353f, -4.7349e-5f, .0069758f,
				     -4.2653e-5f, 11990.f, 1.2e4f, .031642f, .28308f, .0072441f, -3.3775e-5f,
				     .0041744f, -2.7701e-5f, 1.2e4f, 12010.f, .13538f, .163f, .0042895f,
				     -2.9341e-5f, .001443f, -2.3228e-5f, 12010.f, 12020.f, .04616f, .26257f,
				     .0059122f, -3.4545e-5f, .0033253f, -2.959e-5f, 12020.f, 12030.f,
				     .098778f, .16239f, .0019096f, -1.947e-5f, 1.9375e-4f, -1.6507e-5f,
				     12030.f, 12040.f, .04218f, .15687f, .0011607f, -1.5189e-5f, 3.26e-4f,
				     -1.0808e-5f, 12040.f, 12050.f, .081749f, .1447f, .0019087f, -1.8894e-5f,
				     4.6347e-5f, -1.5861e-5f, 12050.f, 12060.f, .14244f, .15544f,
				     -4.8204e-4f, -1.0055e-5f, -.0030791f, -4.5136e-6f, 12060.f, 12070.f,
				     .15967f, .14014f, -.0015241f, -6.1008e-6f, -.0038422f, -1.2202e-6f,
				     12070.f, 12080.f, .14263f, .16924f, -.0025815f, -1.3799e-6f, -.0046065f,
				     2.7252e-6f, 12080.f, 12090.f, .028755f, .09297f, -.0034559f, 3.6475e-6f,
				     -.0038455f, 8.6258e-6f, 12090.f, 12100.f, .13867f, .13244f, -.0035649f,
				     5.23e-6f, -.0053551f, 8.6133e-6f, 12100.f, 12110.f, .022667f, .083805f,
				     -.00172f, -3.4708e-6f, -.0030806f, 3.0367e-6f, 12110.f, 12120.f,
				     .092398f, .11619f, -.0042643f, 1.2112e-5f, -.0033307f, 1.1625e-5f,
				     12120.f, 12130.f, .036116f, .2779f, .0029762f, 1.3854e-6f, .0042021f,
				     -1.2139e-5f, 12130.f, 12140.f, .44373f, .46666f, 3.1523e-4f,
				     -3.0509e-6f, -2.0293e-4f, -7.5095e-6f, 12140.f, 12150.f, .27187f,
				     .27772f, -.0011411f, 1.4254e-6f, -.001681f, -8.1908e-7f, 12150.f,
				     12160.f, .051449f, .10126f, -.0037317f, 6.5728e-6f, -.0032342f,
				     1.2751e-5f, 12160.f, 12170.f, .038984f, .17694f, -.0039312f, 1.3072e-5f,
				     -.0033739f, 1.401e-5f, 12170.f, 12180.f, .0044227f, .11724f, .0062039f,
				     -3.2339e-5f, .0022912f, -2.0596e-5f, 12180.f, 12190.f, .18992f, .14819f,
				     -.0050473f, 8.811e-6f, -.0068829f, 1.2852e-5f, 12190.f, 12200.f,
				     .25583f, .13027f, -.0044286f, 5.7917e-6f, -.0063447f, 9.414e-6f,
				     12200.f, 12210.f, .13625f, .18565f, -.0034046f, 2.2857e-6f, -.0050965f,
				     6.4148e-6f, 12210.f, 12220.f, .29053f, .22511f, -.0027471f, -8.8244e-7f,
				     -.0045852f, 2.3044e-6f, 12220.f, 12230.f, .19038f, .14946f, -6.8588e-4f,
				     -9.3784e-6f, -.0027488f, -5.0351e-6f, 12230.f, 12240.f, .33873f,
				     .28292f, -1.0104e-4f, -1.0239e-5f, -.0013958f, -9.0346e-6f, 12240.f,
				     12250.f, .1325f, .17121f, .0024653f, -1.9723e-5f, 1.8597e-4f,
				     -1.4634e-5f, 12250.f, 12260.f, .12157f, .37106f, .0037908f, -2.2351e-5f,
				     .0010325f, -1.6657e-5f, 12260.f, 12270.f, .07651f, .16258f, .0034104f,
				     -2.3774e-5f, .0018529f, -2.1863e-5f, 12270.f, 12280.f, .07529f, .33562f,
				     .0076059f, -3.4182e-5f, .0052641f, -3.0402e-5f, 12280.f, 12290.f,
				     .060409f, .25407f, .0068386f, -2.9386e-5f, .0061709f, -2.8132e-5f,
				     12290.f, 12300.f, .027161f, .42647f, .0097512f, -3.3363e-5f, .0063871f,
				     -3.1407e-5f, 12300.f, 12310.f, .009111f, .28999f, .010916f, -3.5531e-5f,
				     .0085325f, -3.6715e-5f, 12310.f, 12320.f, .019913f, .33483f, .0088198f,
				     -1.1414e-5f, .0072926f, -2.8077e-5f, 12320.f, 12330.f, .0081899f,
				     .31312f, .014481f, -5.2817e-5f, .010281f, -4.4189e-5f, 12330.f, 12340.f,
				     .0047198f, .32687f, .0079614f, 6.2153e-6f, .0072159f, -1.9264e-5f,
				     12340.f, 12350.f, .011347f, .34063f, .002382f, 2.8934e-5f, .0025122f,
				     2.6528e-6f, 12350.f, 12360.f, .0035162f, .2474f, .0064215f, -4.522e-6f,
				     .0068198f, -2.2326e-5f, 12360.f, 12370.f, .0045582f, .33334f, .0040843f,
				     -6.8827e-6f, .0026935f, -1.6936e-5f, 12370.f, 12380.f, .0025789f,
				     .33203f, .004947f, -1.6065e-5f, .003438f, -2.2968e-5f, 12380.f, 12390.f,
				     .0045336f, .2043f, .0047629f, -2.7839e-5f, .0025633f, -2.4703e-5f,
				     12390.f, 12400.f, .0030244f, .20516f, .0081732f, -4.1804e-5f, .0046359f,
				     -2.9989e-5f, 12400.f, 12410.f, .0041242f, .23106f, .0057501f,
				     -3.1437e-5f, .0034257f, -2.8835e-5f, 12410.f, 12420.f, .010287f,
				     .33673f, .0041222f, -2.574e-5f, .0014121f, -2.0905e-5f, 12420.f,
				     12430.f, .0052103f, .19644f, .0037193f, -2.6341e-5f, 9.394e-4f,
				     -2.0581e-5f, 12430.f, 12440.f, 2.2877e-4f, .12174f, .0092724f,
				     -4.5126e-5f, .0056853f, -3.7747e-5f, 12440.f, 12450.f, .015209f,
				     .45993f, .0011296f, -1.4042e-5f, -.0011241f, -1.1493e-5f, 12450.f,
				     12460.f, .005545f, .1911f, .0015443f, -1.3043e-5f, -3.2861e-4f,
				     -1.1764e-5f, 12460.f, 12470.f, .011275f, .1922f, 7.547e-5f, -1.0276e-5f,
				     -.0020095f, -7.6051e-6f, 12470.f, 12480.f, .014331f, .19322f,
				     -.0010929f, -7.1557e-6f, -.0030976f, -4.5871e-6f, 12480.f, 12490.f,
				     .013106f, .20676f, -.0021472f, -1.689e-6f, -.00333f, -4.7675e-7f,
				     12490.f, 12500.f, .0031859f, .26518f, .0018883f, -3.7481e-6f,
				     4.5064e-5f, -1.1501e-5f, 12500.f, 12510.f, .0066833f, .21228f,
				     -.0021409f, 4.8505e-6f, -.0028895f, 4.0738e-6f, 12510.f, 12520.f,
				     .011966f, .28263f, -.0013922f, 6.3802e-6f, -7.3809e-4f, -1.1743e-6f,
				     12520.f, 12530.f, .0040664f, .24183f, .0035636f, -2.8875e-6f, .0022372f,
				     -1.6411e-5f, 12530.f, 12540.f, .014346f, .3851f, 2.0035e-4f, 3.7739e-6f,
				     -6.1012e-5f, -7.988e-6f, 12540.f, 12550.f, .031841f, .37389f,
				     -.0014467f, -2.5515e-6f, -.0036219f, -9.456e-7f, 12550.f, 12560.f,
				     .014117f, .15375f, -.0027582f, 1.5847e-6f, -.0042341f, 5.2506e-6f,
				     12560.f, 12570.f, .0069458f, .17261f, -.0018858f, -1.3771e-6f,
				     -.0038705f, 1.8317e-6f, 12570.f, 12580.f, .0034163f, .16476f,
				     -.0038874f, 8.9594e-6f, -.004751f, 6.5193e-6f, 12580.f, 12590.f,
				     .0010085f, .13402f, 8.9094e-4f, -6.018e-6f, -6.4581e-6f, -9.4409e-6f,
				     12590.f, 12600.f, .017942f, .20327f, -.0039862f, 7.5053e-6f, -.0052785f,
				     7.3576e-6f, 12600.f, 12610.f, .0080749f, .061138f, -.0049341f,
				     7.5781e-6f, -.0072374f, 1.1499e-5f, 12610.f, 12620.f, .022511f, .21226f,
				     -.0034799f, 3.196e-6f, -.0050773f, 6.2716e-6f, 12620.f, 12630.f,
				     .0091364f, .16111f, -.0029375f, 2.6306e-7f, -.0049473f, 4.3965e-6f,
				     12630.f, 12640.f, .014688f, .1553f, -.0020029f, -2.3192e-6f, -.0029945f,
				     -2.1575e-6f, 12640.f, 12650.f, .016309f, .20204f, 1.6988e-6f,
				     -1.109e-5f, -.0014702f, -9.9629e-6f, 12650.f, 12660.f, .028046f,
				     .24162f, 2.1643e-4f, -1.1209e-5f, -.0017491f, -8.904e-6f, 12660.f,
				     12670.f, .011289f, .29319f, .0034128f, -2.3021e-5f, .0010846f,
				     -1.8419e-5f, 12670.f, 12680.f, .0049531f, .14498f, .0053073f,
				     -2.8791e-5f, .0032927f, -2.5157e-5f, 12680.f, 12690.f, .0072485f,
				     .17855f, .0056992f, -3.2465e-5f, .0041153f, -3.2129e-5f, 12690.f,
				     12700.f, .0061604f, .2478f, .0073217f, -3.1129e-5f, .0058029f,
				     -3.2007e-5f, 12700.f, 12710.f, .0013393f, .12405f, .012672f,
				     -4.8102e-5f, .0088276f, -3.9342e-5f, 12710.f, 12720.f, .0010615f,
				     .14687f, .012203f, -5.0558e-5f, .01058f, -5.4423e-5f, 12720.f, 12730.f,
				     4.7236e-4f, .080989f, .0036212f, 3.4855e-5f, .0023529f, 7.9526e-6f,
				     12730.f, 12740.f
    };

    /* WATER VAPOR (10180 - 12720 CM-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* wava4 */

void
wava3 (double a[8], const long int inu)
{


    static const float acr[2048] = { .092641f, .26739f,
				     .0074828f, -3.6295e-5f, .0065918f, -3.6255e-5f, 7620.f, 7630.f, .24311f,
				     .19859f, .0029686f, -1.983e-5f, .0023399f, -1.6807e-5f, 7630.f, 7640.f,
				     .12025f, .11463f, .005982f, -3.2695e-5f, .00555f, -2.817e-5f, 7640.f,
				     7650.f, .13658f, .26836f, .0072502f, -2.1381e-5f, .0073061f,
				     -3.0405e-5f, 7650.f, 7660.f, .10472f, .25523f, .0079597f, -3.2676e-5f,
				     .0058214f, -3.1308e-5f, 7660.f, 7670.f, .099714f, .25003f, .012338f,
				     -5.6896e-5f, .010569f, -5.1734e-5f, 7670.f, 7680.f, .058366f, .22207f,
				     .011694f, -5.1427e-5f, .011909f, -4.905e-5f, 7680.f, 7690.f, .035387f,
				     .17329f, .016862f, -7.5246e-5f, .013502f, -6.3311e-5f, 7690.f, 7700.f,
				     .036568f, .21034f, .0081374f, -2.4226e-5f, .0063861f, -2.5253e-5f,
				     7700.f, 7710.f, .027597f, .33962f, .017925f, -6.8929e-5f, .015283f,
				     -6.6807e-5f, 7710.f, 7720.f, .010316f, .41286f, .019917f, -4.8503e-5f,
				     .017007f, -5.8717e-5f, 7720.f, 7730.f, .0081553f, .2556f, .021997f,
				     -8.8437e-5f, .020546f, -8.5162e-5f, 7730.f, 7740.f, .015975f, .21315f,
				     .0071481f, 3.1142e-6f, .010474f, -1.3461e-5f, 7740.f, 7750.f, .013868f,
				     .24329f, .0094502f, -1.8614e-5f, .010702f, -3.4118e-5f, 7750.f, 7760.f,
				     .0077141f, .22964f, .011399f, -1.0108e-5f, .012776f, -3.7304e-5f,
				     7760.f, 7770.f, .0021739f, .34321f, .019734f, -5.1909e-5f, .019414f,
				     -7.3442e-5f, 7770.f, 7780.f, .004572f, .18176f, .010354f, -1.7399e-5f,
				     .010948f, -3.5358e-5f, 7780.f, 7790.f, .0011295f, .18695f, .014646f,
				     4.036e-5f, .015891f, -2.0174e-5f, 7790.f, 7800.f, .0033023f, .15293f,
				     .013409f, -5.3371e-5f, .011569f, -4.7548e-5f, 7800.f, 7810.f, .0052016f,
				     .24404f, .012628f, -3.6541e-5f, .01295f, -3.8949e-5f, 7810.f, 7820.f,
				     1.133e-4f, .081552f, .01837f, -7.7312e-5f, .014695f, -7.0503e-5f,
				     7820.f, 7830.f, .0054995f, .14297f, .0065566f, -2.675e-5f, .0045262f,
				     -2.0113e-5f, 7830.f, 7840.f, 3.1204e-4f, .10156f, .0088239f,
				     -3.8012e-5f, .0082963f, -3.4068e-5f, 7840.f, 7850.f, .0019523f, .20697f,
				     .02048f, -6.0781e-5f, .018775f, -6.9708e-5f, 7850.f, 7860.f, .0024757f,
				     .09698f, .011294f, -4.651e-5f, .0098378f, -4.2459e-5f, 7860.f, 7870.f,
				     2.7171e-4f, .14226f, .017805f, -6.9496e-5f, .015097f, -7.0161e-5f,
				     7870.f, 7880.f, .0012276f, .10591f, .014194f, -5.4065e-5f, .010612f,
				     -5.2507e-5f, 7880.f, 7890.f, 4.1923e-4f, .13358f, .01696f, -4.4025e-5f,
				     .015096f, -5.8421e-5f, 7890.f, 7900.f, 3.3444e-4f, .13345f, .011391f,
				     -1.184e-6f, .012153f, -2.3277e-5f, 7900.f, 7910.f, .0013058f, .21624f,
				     .016927f, -6.9213e-5f, .013941f, -6.3876e-5f, 7910.f, 7920.f,
				     1.1995e-4f, .075585f, .013632f, -4.0157e-5f, .013768f, -5.0661e-5f,
				     7920.f, 7930.f, .0011716f, .18257f, .013971f, -5.1254e-5f, .012846f,
				     -5.6651e-5f, 7930.f, 7940.f, 5.052e-4f, .076356f, .012922f, -2.0119e-5f,
				     .013988f, -4.2851e-5f, 7940.f, 7950.f, 2.4426e-4f, .1253f, .010339f,
				     -4.3784e-6f, .010719f, -3.665e-5f, 7950.f, 7960.f, 5.414e-4f, .072313f,
				     .019259f, -8.565e-5f, .01592f, -7.9109e-5f, 7960.f, 7970.f, 7.6374e-4f,
				     .068718f, .018517f, -6.7616e-5f, .016394f, -7.3663e-5f, 7970.f, 7980.f,
				     2.5606e-4f, .077067f, .016494f, -7.5101e-5f, .01272f, -6.6656e-5f,
				     7980.f, 7990.f, 1.5654e-4f, .11158f, .010695f, -4.0866e-5f, .0081416f,
				     -4.363e-5f, 7990.f, 8e3f, 4.1929e-5f, .090036f, .024363f, -1.0641e-4f,
				     .021621f, -1.0231e-4f, 8e3f, 8010.f, 7.3175e-4f, .10587f, .016949f,
				     -6.039e-5f, .015862f, -7.1742e-5f, 8010.f, 8020.f, 8.008e-5f, .030563f,
				     .019843f, -9.1766e-5f, .017086f, -8.6214e-5f, 8020.f, 8030.f,
				     2.4279e-5f, .056812f, .022624f, -9.9621e-5f, .020301f, -9.7332e-5f,
				     8030.f, 8040.f, 1.8866e-5f, .052834f, .012394f, -4.4016e-5f, .0093994f,
				     -4.6495e-5f, 8040.f, 8050.f, 9.7669e-4f, .089736f, .0062407f,
				     -2.5133e-5f, .005852f, -2.556e-5f, 8050.f, 8060.f, .0011471f, .029409f,
				     .02069f, -9.511e-5f, .018237f, -9.0575e-5f, 8060.f, 8070.f, 7.7566e-4f,
				     .12509f, .012079f, -5.088e-5f, .010725f, -5.2092e-5f, 8070.f, 8080.f,
				     .003103f, .073291f, .016462f, -7.3991e-5f, .015208f, -6.8516e-5f,
				     8080.f, 8090.f, .001251f, .11933f, .014229f, -6.2251e-5f, .011779f,
				     -6.099e-5f, 8090.f, 8100.f, .001499f, .13662f, .0065894f, -8.557e-6f,
				     .0083512f, -1.9086e-5f, 8100.f, 8110.f, .0020532f, .10298f, .015994f,
				     -6.5137e-5f, .014131f, -6.2564e-5f, 8110.f, 8120.f, .0017448f, .067598f,
				     .014749f, -6.293e-5f, .013541f, -5.9773e-5f, 8120.f, 8130.f, .0015039f,
				     .12946f, .018816f, -5.0022e-5f, .017492f, -5.9638e-5f, 8130.f, 8140.f,
				     .0046638f, .1035f, .0062829f, -3.4218e-5f, .0036814f, -2.5761e-5f,
				     8140.f, 8150.f, .0010319f, .066367f, .0071775f, -2.8782e-5f, .010631f,
				     -2.023e-5f, 8150.f, 8160.f, .0046436f, .096269f, .015527f, -6.1225e-5f,
				     .015071f, -6.3728e-5f, 8160.f, 8170.f, .0057048f, .15352f, .0032127f,
				     -1.6432e-5f, .0035091f, -1.2277e-5f, 8170.f, 8180.f, .011525f, .15916f,
				     .0083892f, -1.0637e-5f, .0067801f, -2.5386e-5f, 8180.f, 8190.f,
				     .0074791f, .18295f, .0048041f, -2.0748e-5f, .0044988f, -1.7162e-5f,
				     8190.f, 8200.f, .011502f, .15897f, .0099626f, -1.7036e-5f, .010154f,
				     -3.5251e-5f, 8200.f, 8210.f, .032694f, .12981f, .0016557f, 1.4661e-5f,
				     .0035153f, 1.0696e-6f, 8210.f, 8220.f, .007492f, .12913f, .0071536f,
				     -2.9018e-5f, .0069835f, -3.3541e-5f, 8220.f, 8230.f, .047072f, .21294f,
				     .0094858f, -4.2608e-5f, .0075764f, -3.9014e-5f, 8230.f, 8240.f,
				     .017525f, .16065f, .0024969f, -1.0727e-6f, .0020059f, -5.349e-6f,
				     8240.f, 8250.f, .057547f, .16256f, .0053651f, -3.1796e-5f, .0032968f,
				     -2.8841e-5f, 8250.f, 8260.f, .043086f, .11299f, .0044958f, -2.4017e-5f,
				     .0036046f, -2.0674e-5f, 8260.f, 8270.f, .10051f, .15621f, .0034824f,
				     -2.1289e-5f, .0019497f, -2.0952e-5f, 8270.f, 8280.f, .073404f, .16218f,
				     .0017977f, -1.3976e-5f, 1.5476e-4f, -6.5472e-6f, 8280.f, 8290.f,
				     .08523f, .11256f, 2.9553e-4f, -9.9833e-6f, -1.2813e-4f, -4.6912e-6f,
				     8290.f, 8300.f, .1818f, .19506f, -.0018708f, -2.1763e-6f, -.0027279f,
				     2.3065e-6f, 8300.f, 8310.f, .030278f, .1674f, .0055443f, -2.3707e-5f,
				     .0051615f, -2.3428e-5f, 8310.f, 8320.f, .11462f, .20492f, -.0010659f,
				     -9.4245e-7f, -.0022118f, 4.2668e-6f, 8320.f, 8330.f, .099231f, .19833f,
				     -3.5775e-4f, -3.838e-6f, -.0025607f, -3.6304e-7f, 8330.f, 8340.f,
				     .099199f, .18538f, -.0023017f, 6.6528e-6f, -.0023339f, 6.1821e-6f,
				     8340.f, 8350.f, .059379f, .077001f, -.004912f, 1.4256e-5f, -.0025954f,
				     3.0037e-5f, 8350.f, 8360.f, .044008f, .20401f, .0014099f, -5.1535e-6f,
				     .0019118f, -1.6011e-6f, 8360.f, 8370.f, .090539f, .08076f, -.0035383f,
				     1.3223e-5f, -.0028138f, 1.3001e-5f, 8370.f, 8380.f, .014326f, .1809f,
				     .0059988f, 7.331e-7f, .0076689f, -1.7035e-5f, 8380.f, 8390.f, .046664f,
				     .1734f, -8.7294e-4f, 1.0561e-5f, 3.1024e-4f, 2.7678e-6f, 8390.f, 8400.f,
				     .10171f, .16186f, -.0017894f, -2.8284e-6f, -.0040067f, -1.4559e-7f,
				     8400.f, 8410.f, .30821f, .25107f, -.0032854f, 5.8502e-6f, -.0036961f,
				     9.3802e-6f, 8410.f, 8420.f, .063199f, .24205f, -.0011158f, 3.7207e-6f,
				     -.0013624f, 5.0058e-6f, 8420.f, 8430.f, .099053f, .16171f, -.0031354f,
				     1.4107e-5f, -4.1612e-4f, 9.0938e-6f, 8430.f, 8440.f, .18961f, .16575f,
				     -.0036207f, 4.9966e-6f, -.0041916f, 8.2034e-6f, 8440.f, 8450.f, .17725f,
				     .21239f, -7.7569e-4f, -2.0023e-6f, -4.9558e-4f, -5.1555e-6f, 8450.f,
				     8460.f, .27753f, .33354f, 9.0668e-4f, -7.5987e-6f, 1.7804e-4f,
				     -6.4173e-6f, 8460.f, 8470.f, .14123f, .13127f, -1.2234e-4f, -8.3078e-6f,
				     -4.417e-4f, -4.4651e-6f, 8470.f, 8480.f, .093615f, .12378f, -.0022473f,
				     6.446e-6f, -.0023144f, 2.1685e-5f, 8480.f, 8490.f, .20449f, .23918f,
				     .0011176f, -3.6761e-6f, .0018f, -5.0232e-6f, 8490.f, 8500.f, .089489f,
				     .16701f, .0039531f, -6.6471e-6f, .0051864f, 4.9471e-6f, 8500.f, 8510.f,
				     .23406f, .40842f, .0043192f, -1.5846e-5f, .0044314f, -2.3087e-5f,
				     8510.f, 8520.f, .14482f, .32325f, .0041937f, 5.6608e-6f, .0044945f,
				     3.2348e-7f, 8520.f, 8530.f, .064432f, .26897f, .0065578f, -1.2568e-5f,
				     .007607f, -2.0405e-5f, 8530.f, 8540.f, .057924f, .33321f, .0091543f,
				     9.8398e-6f, .0086335f, -1.8156e-5f, 8540.f, 8550.f, .10794f, .40047f,
				     .010231f, 1.2947e-5f, .010777f, -2.3286e-5f, 8550.f, 8560.f, .081479f,
				     .27006f, .010378f, -1.4458e-5f, .0096133f, -3.1676e-5f, 8560.f, 8570.f,
				     .21551f, .37486f, .015271f, -4.3087e-5f, .011958f, -4.878e-5f, 8570.f,
				     8580.f, .1197f, .42176f, .011436f, -2.7559e-5f, .012343f, -4.8358e-5f,
				     8580.f, 8590.f, .1194f, .26383f, .017025f, -6.3908e-5f, .012895f,
				     -5.3752e-5f, 8590.f, 8600.f, .35022f, .24839f, .015312f, -6.7204e-5f,
				     .011349f, -5.723e-5f, 8600.f, 8610.f, .43429f, .32749f, .014111f,
				     -6.1858e-5f, .0111f, -5.2145e-5f, 8610.f, 8620.f, .649f, .17775f,
				     .012005f, -5.7105e-5f, .0091759f, -4.5878e-5f, 8620.f, 8630.f, .62583f,
				     .2559f, .011761f, -5.603e-5f, .0090211f, -4.8934e-5f, 8630.f, 8640.f,
				     .3575f, .36475f, .010308f, -4.3411e-5f, .0088328f, -3.9083e-5f, 8640.f,
				     8650.f, 1.1133f, .13506f, .0080358f, -4.3334e-5f, .0068137f,
				     -3.9624e-5f, 8650.f, 8660.f, 1.3387f, .31665f, .0078192f, -3.8805e-5f,
				     .0049558f, -3.3187e-5f, 8660.f, 8670.f, 2.7498f, .16946f, .0049939f,
				     -3.0487e-5f, .0031261f, -2.5786e-5f, 8670.f, 8680.f, 2.4398f, .19531f,
				     .0044402f, -2.9193e-5f, .0022819f, -2.5054e-5f, 8680.f, 8690.f, 3.0993f,
				     .19328f, .0022645f, -1.9507e-5f, 5.743e-4f, -1.6236e-5f, 8690.f, 8700.f,
				     1.2713f, .17117f, .0010656f, -1.5353e-5f, -6.2313e-4f, -8.8734e-6f,
				     8700.f, 8710.f, 3.1649f, .17696f, .0010942f, -1.5108e-5f, -8.8648e-4f,
				     -8.7401e-6f, 8710.f, 8720.f, 3.1075f, .11851f, -9.4639e-5f, -9.2083e-6f,
				     -3.6777e-4f, -6.4753e-6f, 8720.f, 8730.f, 7.0407f, .19201f, -.0021209f,
				     -3.6303e-6f, -.0046941f, 1.0611e-6f, 8730.f, 8740.f, 1.2454f, .17319f,
				     -.0019955f, -1.4314e-6f, -.0021532f, -5.8242e-7f, 8740.f, 8750.f,
				     .83443f, .1489f, -.0031702f, 3.926e-6f, -.0022958f, 3.8306e-6f, 8750.f,
				     8760.f, 3.6918f, .11215f, -.0041869f, 4.6517e-6f, -.0065413f,
				     1.1815e-5f, 8760.f, 8770.f, .93114f, .16247f, 8.6756e-4f, -4.9431e-6f,
				     6.7174e-4f, -4.722e-6f, 8770.f, 8780.f, 2.5247f, .085808f, -.004835f,
				     9.227e-6f, -.0060959f, 1.2095e-5f, 8780.f, 8790.f, .53387f, .20115f,
				     -.0016551f, 7.1592e-6f, -5.3003e-4f, 9.888e-7f, 8790.f, 8800.f, 6.6475f,
				     .28681f, -.0018744f, 3.5629e-6f, -.0015672f, 2.949e-6f, 8800.f, 8810.f,
				     13.449f, .46562f, .0010817f, -8.1158e-6f, 4.4146e-4f, -9.6568e-6f,
				     8810.f, 8820.f, 2.3072f, .29228f, .0018897f, 4.5344e-6f, .0023839f,
				     -8.7201e-6f, 8820.f, 8830.f, .38221f, .2037f, 4.9695e-4f, 6.5162e-6f,
				     .0021768f, 3.2622e-6f, 8830.f, 8840.f, 1.1249f, .14056f, -.0038223f,
				     1.6534e-5f, 2.8673e-4f, 1.9579e-5f, 8840.f, 8850.f, 4.8272f, .098788f,
				     -.005013f, 9.0675e-6f, -.005665f, 1.3142e-5f, 8850.f, 8860.f, 7.562f,
				     .14568f, -.0043638f, 5.3176e-6f, -.0063322f, 1.074e-5f, 8860.f, 8870.f,
				     2.4448f, .13155f, -.002417f, -2.7983e-7f, -.0034547f, 3.4138e-6f,
				     8870.f, 8880.f, 8.0582f, .19292f, -.0028534f, -8.0358e-7f, -.0051566f,
				     3.9531e-6f, 8880.f, 8890.f, 5.7451f, .18168f, -5.0148e-4f, -9.5111e-6f,
				     -.0019306f, -6.0172e-6f, 8890.f, 8900.f, 7.0547f, .19464f, -.0010049f,
				     -7.4656e-6f, -.0025268f, -4.3122e-6f, 8900.f, 8910.f, 5.4039f, .15719f,
				     .0016933f, -1.8412e-5f, 5.6219e-4f, -1.6145e-5f, 8910.f, 8920.f,
				     3.5653f, .19909f, .0033052f, -2.2923e-5f, 5.191e-4f, -1.4385e-5f,
				     8920.f, 8930.f, 2.9405f, .30828f, .0050674f, -2.9116e-5f, .0027789f,
				     -2.3443e-5f, 8930.f, 8940.f, 1.9927f, .15337f, .0040525f, -2.4922e-5f,
				     .0021726f, -1.8937e-5f, 8940.f, 8950.f, 3.1994f, .39446f, .0066249f,
				     -3.4407e-5f, .0041704f, -2.98e-5f, 8950.f, 8960.f, 1.0124f, .3051f,
				     .0095861f, -4.26e-5f, .007142f, -3.9564e-5f, 8960.f, 8970.f, .55494f,
				     .31765f, .012349f, -5.0981e-5f, .0084323f, -3.9712e-5f, 8970.f, 8980.f,
				     .62962f, .34745f, .0068325f, -6.7823e-6f, .006612f, -2.2655e-5f, 8980.f,
				     8990.f, .39155f, .17506f, .014525f, -6.4228e-5f, .012836f, -5.854e-5f,
				     8990.f, 9e3f, .29338f, .19531f, .014921f, -5.7995e-5f, .012214f,
				     -4.6413e-5f, 9e3f, 9010.f, .117f, .34769f, .013815f, -1.4315e-5f,
				     .011336f, -3.2553e-5f, 9010.f, 9020.f, .16223f, .35064f, .0089364f,
				     2.1825e-5f, .010979f, -2.503e-5f, 9020.f, 9030.f, .021742f, .25837f,
				     .021279f, -6.9818e-5f, .017662f, -6.8568e-5f, 9030.f, 9040.f, .056078f,
				     .27822f, .012493f, 1.8431e-5f, .013824f, -2.7676e-5f, 9040.f, 9050.f,
				     .050045f, .24927f, .0025877f, 4.5316e-5f, .0058234f, 9.7906e-6f, 9050.f,
				     9060.f, .074041f, .1688f, .0031016f, -1.2901e-5f, .0031503f,
				     -9.5272e-6f, 9060.f, 9070.f, .035788f, .25671f, .0055742f, -3.3952e-6f,
				     .0067343f, -9.7505e-6f, 9070.f, 9080.f, .057922f, .23584f, .0022587f,
				     -9.2537e-6f, .0015239f, -7.0447e-6f, 9080.f, 9090.f, .033597f, .22977f,
				     .0030824f, -1.1293e-5f, .0033924f, -5.6695e-6f, 9090.f, 9100.f,
				     .070807f, .38398f, .0033167f, -8.2422e-6f, .002352f, -1.7904e-5f,
				     9100.f, 9110.f, .007025f, .18707f, .008814f, -2.739e-5f, .008404f,
				     -2.9932e-5f, 9110.f, 9120.f, .069936f, .25325f, .0019174f, -1.1175e-5f,
				     .001279f, -1.4168e-5f, 9120.f, 9130.f, .052387f, .30346f, 9.3076e-4f,
				     5.2452e-6f, .0021985f, -1.2943e-5f, 9130.f, 9140.f, .015639f, .086845f,
				     .0072697f, -3.4455e-5f, .0051914f, -3.2991e-5f, 9140.f, 9150.f,
				     .091802f, .17031f, -5.4142e-4f, 2.9713e-6f, -.0010743f, -2.3472e-6f,
				     9150.f, 9160.f, .011168f, .099076f, .005622f, -3.0231e-5f, .0047197f,
				     -2.3663e-5f, 9160.f, 9170.f, .048371f, .1417f, -5.9903e-4f, -4.5058e-6f,
				     -.0011328f, 9.448e-7f, 9170.f, 9180.f, .018874f, .15366f, .0042614f,
				     -2.6279e-5f, 8.9656e-4f, -2.0193e-5f, 9180.f, 9190.f, .016112f, .12245f,
				     .0061155f, -3.4764e-5f, .0039418f, -3.163e-5f, 9190.f, 9200.f, .065149f,
				     .14651f, .0013623f, -1.4483e-5f, 1.0964e-5f, -1.1796e-5f, 9200.f,
				     9210.f, .011149f, .21185f, .0041991f, -1.3718e-5f, .0030892f,
				     -2.0781e-5f, 9210.f, 9220.f, .031171f, .12753f, .0045967f, -2.5041e-5f,
				     .0038974f, -2.7102e-5f, 9220.f, 9230.f, 4.0823e-4f, .030563f, .0247f,
				     -1.1119e-4f, .021942f, -1.0564e-4f, 9230.f, 9240.f, .012977f, .16914f,
				     .0055548f, -2.5826e-5f, .0033619f, -2.2004e-5f, 9240.f, 9250.f,
				     .020816f, .10896f, .0066122f, -3.4731e-5f, .0052212f, -3.4187e-5f,
				     9250.f, 9260.f, .0030262f, .11279f, .010901f, -5.2842e-5f, .0086449f,
				     -4.5417e-5f, 9260.f, 9270.f, .0033673f, .11423f, .010899f, -3.4157e-5f,
				     .0080866f, -3.8803e-5f, 9270.f, 9280.f, .017536f, .16659f, .0083759f,
				     -4.46e-5f, .005112f, -3.6571e-5f, 9280.f, 9290.f, 8.1624e-4f, .16081f,
				     .015916f, -6.3848e-5f, .013156f, -6.3084e-5f, 9290.f, 9300.f, .011313f,
				     .13057f, .011852f, -5.8953e-5f, .0088407f, -5.1297e-5f, 9300.f, 9310.f,
				     .0015081f, .069261f, .0041982f, -7.5358e-6f, .0057185f, -1.6686e-5f,
				     9310.f, 9320.f, .0045702f, .1342f, .013143f, -5.4394e-5f, .01017f,
				     -5.2848e-5f, 9320.f, 9330.f, 7.5901e-4f, .16485f, .017789f, -4.1657e-5f,
				     .014232f, -5.1704e-5f, 9330.f, 9340.f, .0023315f, .14437f, .015924f,
				     -7.3095e-5f, .012997f, -6.7546e-5f, 9340.f, 9350.f, .0024761f, .13342f,
				     .017367f, -6.5679e-5f, .014468f, -6.2866e-5f, 9350.f, 9360.f, .0011255f,
				     .11586f, .016217f, -5.9242e-5f, .013009f, -5.7135e-5f, 9360.f, 9370.f,
				     4.6631e-4f, .031553f, .0231f, -1.0479e-4f, .020342f, -9.924e-5f, 9370.f,
				     9380.f, 5.8334e-4f, .14333f, .014779f, -4.7773e-5f, .011406f,
				     -5.2169e-5f, 9380.f, 9390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9390.f, 9400.f,
				     4.6492e-4f, .064777f, .012413f, -2.9282e-5f, .013774f, -4.9601e-5f,
				     9400.f, 9410.f, 4.0085e-4f, .030483f, .010823f, -5.5684e-5f, .0080667f,
				     -5.0135e-5f, 9410.f, 9420.f, 6.5363e-5f, .053752f, .0231f, -1.0479e-4f,
				     .020342f, -9.924e-5f, 9420.f, 9430.f, 2.4119e-5f, .027609f, .03515f,
				     -1.5299e-4f, .032393f, -1.4744e-4f, 9430.f, 9440.f, 1.3718e-4f, .04682f,
				     .01614f, -5.2767e-5f, .016119f, -6.7234e-5f, 9440.f, 9450.f, 5.534e-5f,
				     .046161f, .016226f, -4.5595e-5f, .015446f, -5.9474e-5f, 9450.f, 9460.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9460.f, 9470.f, 5.7428e-5f, .063455f,
				     .017377f, -4.729e-5f, .016614f, -6.2421e-5f, 9470.f, 9480.f, 3.8406e-5f,
				     .031771f, .0046608f, -3.1037e-5f, .0019036f, -2.5485e-5f, 9480.f,
				     9490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9490.f, 9500.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9500.f, 9510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9510.f, 9520.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9520.f, 9530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9530.f,
				     9540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9540.f, 9550.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9550.f, 9560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9560.f, 9570.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9570.f, 9580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9580.f,
				     9590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9590.f, 9600.f, 2.4903e-5f,
				     .024969f,
				     .025759f, -1.1543e-4f, .023002f, -1.0988e-4f, 9600.f, 9610.f,
				     4.8976e-5f, .034814f, .004643f, -3.0966e-5f, .0018858f, -2.5414e-5f,
				     9610.f, 9620.f, 6.6257e-5f, .052528f, .020662f, -9.5042e-5f, .017905f,
				     -8.949e-5f, 9620.f, 9630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9630.f, 9640.f,

				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9640.f, 9650.f, 1.9405e-4f, .0908f,
				     .012893f,
				     -4.7907e-5f, .008999f, -4.3597e-5f, 9650.f, 9660.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 0.f, 9660.f, 9670.f, 3.5455e-4f, .062906f, .01178f, -5.9514e-5f,
				     .0090225f, -5.3961e-5f, 9670.f, 9680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     9680.f, 9690.f, 7.3346e-4f, .095357f, .0080776f, -3.5126e-5f, .0063761f,
				     -3.2075e-5f, 9690.f, 9700.f, 2.6888e-4f, .062321f, .01172f, -5.6759e-5f,
				     .0098726f, -5.5238e-5f, 9700.f, 9710.f, 4.8999e-4f, .10498f, .0062757f,
				     -3.2864e-5f, .0049464f, -3.2626e-5f, 9710.f, 9720.f, .0010507f,
				     .071841f, .0058574f, -3.2015e-5f, .0039666f, -3.1106e-5f, 9720.f,
				     9730.f, .0025494f, .10376f, .0030444f, -2.0413e-5f, .0012384f,
				     -1.8532e-5f, 9730.f, 9740.f, .0013019f, .13387f, .0019451f, -1.3612e-5f,
				     -8.9213e-6f, -1.3158e-5f, 9740.f, 9750.f, 6.2353e-4f, .078233f,
				     7.0756e-4f, -1.519e-5f, -.0020739f, -9.6993e-6f, 9750.f, 9760.f,
				     .0056535f, .1971f, 1.6071e-4f, -5.7489e-6f, -.0014878f, -4.8238e-6f,
				     9760.f, 9770.f, .001909f, .041123f, -.0019069f, -4.7662e-6f, -.004664f,
				     7.8558e-7f, 9770.f, 9780.f, .0017619f, .13162f, -.0022639f, 7.7041e-7f,
				     -.0049756f, 4.3744e-6f, 9780.f, 9790.f, 5.7144e-4f, .099432f, .0040501f,
				     -1.5471e-5f, .0018591f, -1.7658e-5f, 9790.f, 9800.f, .0038209f, .13329f,
				     -.0046298f, 6.3691e-6f, -.0077028f, 1.2343e-5f, 9800.f, 9810.f,
				     .0017147f, .079407f, 4.5502e-4f, -1.3444e-5f, -.0030355f, -5.7728e-6f,
				     9810.f, 9820.f, .0012145f, .072418f, 2.5064e-4f, -5.9535e-6f,
				     3.3766e-6f, -6.2695e-6f, 9820.f, 9830.f, .0011057f, .13614f, .0018444f,
				     -3.817e-6f, -6.6263e-4f, -6.1358e-6f, 9830.f, 9840.f, .0021971f,
				     .053016f, -.0048189f, 9.7527e-6f, -.0060279f, 1.7406e-5f, 9840.f,
				     9850.f, .0019933f, .17956f, -.0010152f, 7.3537e-6f, -.0033437f,
				     4.3246e-6f, 9850.f, 9860.f, 8.7206e-4f, .047547f, -.0041578f,
				     4.2375e-6f, -.007361f, 1.0687e-5f, 9860.f, 9870.f, .0029909f, .069285f,
				     -.0047147f, 1.0991e-5f, -.0056075f, 1.5292e-5f, 9870.f, 9880.f,
				     .001506f, .17429f, .003529f, -1.5241e-5f, 9.8555e-4f, -1.3485e-5f,
				     9880.f, 9890.f, .0024655f, .15187f, -9.6328e-4f, 3.0116e-6f, -.002379f,
				     6.199e-6f, 9890.f, 9900.f, .0081762f, .23349f, -.0033911f, 1.8786e-6f,
				     -.0060119f, 6.563e-6f, 9900.f, 9910.f, .0035952f, .09571f, -.002565f,
				     6.9268e-6f, -.0025302f, 8.7846e-6f, 9910.f, 9920.f, .004102f, .16571f,
				     -8.2348e-4f, 4.4729e-6f, 5.0555e-5f, -1.3431e-6f, 9920.f, 9930.f,
				     .0015616f, .12559f, -.001712f, 9.5737e-7f, -.002329f, 2.8914e-6f,
				     9930.f, 9940.f, .0029147f, .1397f, .0017969f, -5.9773e-6f, .0040034f,
				     -1.6529e-5f, 9940.f, 9950.f, .0021013f, .0985f, .0026194f, -1.629e-5f,
				     .0026829f, -1.8333e-5f, 9950.f, 9960.f, .0025118f, .078548f, -.0011652f,
				     -3.1932e-6f, -.0017647f, -3.6546e-6f, 9960.f, 9970.f, .0054922f,
				     .27847f, .0022288f, -6.2983e-6f, .0011941f, -9.9545e-6f, 9970.f, 9980.f,
				     .0077074f, .24403f, .0023234f, -1.7376e-5f, 9.1247e-4f, -1.6357e-5f,
				     9980.f, 9990.f, .0015919f, .17498f, .004876f, -1.537e-5f, .0030207f,
				     -2.2305e-5f, 9990.f, 1e4f, .0023052f, .12024f, .0026434f, 3.4883e-6f,
				     .0053038f, -7.4735e-6f, 1e4f, 10010.f, 9.9075e-4f, .060379f, .0048519f,
				     -2.4596e-5f, .0039231f, -2.671e-5f, 10010.f, 10020.f, .0026106f,
				     .15994f, .0057076f, -1.5791e-5f, .0063216f, -2.8717e-5f, 10020.f,
				     10030.f, 9.0384e-4f, .21421f, .0073532f, -1.3113e-6f, .009333f,
				     -1.9232e-5f, 10030.f, 10040.f, .0020888f, .22211f, .0093854f,
				     -1.1006e-5f, .0077851f, -1.8919e-5f, 10040.f, 10050.f, .0010096f,
				     .093543f, .0051826f, -2.8108e-5f, .0041051f, -2.3759e-5f, 10050.f,
				     10060.f, .0022561f, .25885f, .013532f, -1.4879e-5f, .011628f,
				     -3.4287e-5f, 10060.f, 10070.f, .0077191f, .28721f, .0097888f,
				     -1.1073e-5f, .008539f, -2.4771e-5f, 10070.f, 10080.f, .0034195f,
				     .20647f, .0074823f, -2.1978e-5f, .007444f, -2.4751e-5f, 10080.f,
				     10090.f, .0063694f, .19871f, .011877f, -3.28e-5f, .009567f, -3.9672e-5f,
				     10090.f, 10100.f, .0063072f, .3731f, .0047744f, 2.8648e-5f, .006887f,
				     -8.4982e-6f, 10100.f, 10110.f, .0010617f, .15783f, .019027f,
				     -3.7386e-5f, .017346f, -6.0605e-5f, 10110.f, 10120.f, .016376f, .34661f,
				     .014148f, -4.8223e-5f, .010187f, -4.3401e-5f, 10120.f, 10130.f,
				     .0077156f, .39174f, .0071212f, 8.3584e-6f, .0074196f, -2.0778e-5f,
				     10130.f, 10140.f, .0081991f, .34376f, .010657f, -2.049e-5f, .009186f,
				     -3.4657e-5f, 10140.f, 10150.f, .045748f, .35631f, .011031f, -4.1938e-5f,
				     .0079877f, -3.3077e-5f, 10150.f, 10160.f, .026803f, .2161f, .011739f,
				     -5.3624e-5f, .010169f, -5.0362e-5f, 10160.f, 10170.f, .061462f, .24685f,
				     .008227f, -3.1656e-5f, .0077778f, -3.1665e-5f, 10170.f, 10180.f
    };

    /* WATER VAPOR (7620 - 10160 CM-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* wava3 */

void
wava2 (double a[8], const long int inu)
{


    static const float acr[2048] = { .32591f, .48473f,
				     .010062f, 1.8245e-5f, .01189f, -1.2621e-5f, 5060.f, 5070.f, .73059f,
				     .13181f, .010626f, 7.3795e-6f, .011376f, -1.7764e-5f, 5070.f, 5080.f,
				     .39211f, .39522f, .01459f, -6.8376e-6f, .016326f, -3.165e-5f, 5080.f,
				     5090.f, 2.3255f, .26901f, .0092468f, 6.3821e-6f, .0083396f, -1.2628e-5f,
				     5090.f, 5100.f, 1.9706f, .34245f, .0056073f, -9.4265e-8f, .0059986f,
				     -1.0398e-5f, 5100.f, 5110.f, 2.8938f, .22738f, .022463f, -9.7912e-5f,
				     .021063f, -8.8497e-5f, 5110.f, 5120.f, 1.1454f, .40811f, .0089642f,
				     -5.1753e-6f, .0089863f, -1.9479e-5f, 5120.f, 5130.f, 2.92f, .33384f,
				     .014298f, -3.2571e-5f, .012431f, -3.5993e-5f, 5130.f, 5140.f, 6.318f,
				     .28323f, .0099085f, -1.94e-5f, .0060737f, -1.671e-5f, 5140.f, 5150.f,
				     14.918f, .41681f, .012935f, -5.2738e-5f, .010041f, -4.0263e-5f, 5150.f,
				     5160.f, 10.19f, .13237f, .011091f, -4.8728e-5f, .0081335f, -2.7045e-5f,
				     5160.f, 5170.f, 14.437f, .36156f, .0094685f, -3.4308e-5f, .0067537f,
				     -2.4477e-5f, 5170.f, 5180.f, 34.792f, .30287f, .0073719f, -3.7632e-5f,
				     .0051901f, -2.8247e-5f, 5180.f, 5190.f, 21.869f, .22075f, .0069763f,
				     -3.1715e-5f, .0041088f, -1.7042e-5f, 5190.f, 5200.f, 94.938f, .25888f,
				     .0046429f, -2.8823e-5f, .0034889f, -2.3494e-5f, 5200.f, 5210.f, 18.298f,
				     .20311f, .0050431f, -2.4681e-5f, .0028469f, -1.707e-5f, 5210.f, 5220.f,
				     69.538f, .19126f, .002196f, -2.0268e-5f, 6.875e-4f, -1.7413e-5f, 5220.f,
				     5230.f, 40.772f, .23521f, .0018896f, -1.692e-5f, 5.9126e-4f,
				     -1.3609e-5f, 5230.f, 5240.f, 131.08f, .17928f, 1.5657e-4f, -1.2114e-5f,
				     -.0017405f, -8.3108e-6f, 5240.f, 5250.f, 69.597f, .10896f, -.0015337f,

				     -4.7461e-6f, -.0027082f, -1.5598e-6f, 5250.f, 5260.f, 153.51f, .20025f,
				     -.0022803f, -2.9253e-6f, -.004398f, 2.8697e-6f, 5260.f, 5270.f, 2.6114f,
				     .24878f, -8.2927e-4f, 4.6226e-6f, -1.1922e-4f, 1.0717e-5f, 5270.f,
				     5280.f, 48.681f, .175f, -.0037857f, 4.6902e-6f, -.0036353f, 1.1426e-5f,
				     5280.f, 5290.f, 77.56f, .13557f, -.0037228f, 3.6212e-6f, -.0041326f,
				     1.5278e-5f, 5290.f, 5300.f, 60.444f, .1151f, -.0047324f, 1.0254e-5f,
				     -.0036821f, 1.4636e-5f, 5300.f, 5310.f, 15.328f, .19998f, -.0012681f,
				     2.9898e-6f, -4.683e-4f, 2.0999e-6f, 5310.f, 5320.f, 87.54f, .16972f,
				     -.0041972f, 7.1961e-6f, -.0037508f, 7.0298e-6f, 5320.f, 5330.f, 195.61f,
				     .26284f, -.0023874f, -2.1407e-7f, -.0037245f, 4.6625e-6f, 5330.f,
				     5340.f, 168.41f, .26546f, 2.4931e-4f, -9.4775e-6f, -.0016338f,
				     -6.291e-6f, 5340.f, 5350.f, 93.921f, .31129f, .0028343f, -7.1173e-6f,
				     .0026325f, -1.1816e-5f, 5350.f, 5360.f, 25.579f, .36877f, .0072262f,
				     -1.5821e-5f, .0060257f, -2.1996e-5f, 5360.f, 5370.f, 137.79f, .17089f,
				     -.004665f, 1.3962e-5f, -.002641f, 1.792e-5f, 5370.f, 5380.f, 84.199f,
				     .12293f, -.0039643f, 9.7938e-6f, -.0017023f, 1.5901e-5f, 5380.f, 5390.f,
				     140.72f, .10478f, -.0041237f, 5.0169e-6f, -.0043789f, 1.7244e-5f,
				     5390.f, 5400.f, 56.622f, .23084f, -.0025409f, -2.9811e-7f, -.0027639f,
				     7.6091e-6f, 5400.f, 5410.f, 185.34f, .21363f, -.0028691f, -4.4392e-7f,
				     -.0042358f, 6.6265e-6f, 5410.f, 5420.f, 96.955f, .12223f, -5.2081e-4f,
				     -9.6057e-6f, -.0016418f, -1.9789e-6f, 5420.f, 5430.f, 117.89f, .13571f,
				     -.0014763f, -5.7081e-6f, -.0024763f, -1.7817e-7f, 5430.f, 5440.f,
				     191.02f, .24199f, 6.976e-4f, -1.4228e-5f, -.001445f, -7.5253e-6f,
				     5440.f, 5450.f, 22.138f, .14268f, .0012465f, -1.3898e-5f, .00202f,
				     -8.418e-6f, 5450.f, 5460.f, 95.115f, .24823f, .0035551f, -2.5604e-5f,
				     .0012041f, -1.8465e-5f, 5460.f, 5470.f, 62.976f, .15811f, .0050592f,
				     -2.9507e-5f, .0029262f, -2.138e-5f, 5470.f, 5480.f, 29.147f, .11805f,
				     .008422f, -4.2987e-5f, .0067418f, -3.6032e-5f, 5480.f, 5490.f, 51.614f,
				     .19818f, .0058436f, -3.46e-5f, .003939f, -2.8598e-5f, 5490.f, 5500.f,
				     23.266f, .1679f, .011075f, -5.348e-5f, .0084735f, -4.6037e-5f, 5500.f,
				     5510.f, 10.989f, .20302f, .0063972f, -1.4524e-5f, .0042223f,
				     -2.0806e-5f, 5510.f, 5520.f, 10.027f, .16542f, .013794f, -6.332e-5f,
				     .011093f, -5.5041e-5f, 5520.f, 5530.f, 9.3954f, .21952f, .013366f,
				     -5.7474e-5f, .0098104f, -4.6605e-5f, 5530.f, 5540.f, 4.2252f, .19874f,
				     .016633f, -7.121e-5f, .01335f, -6.0705e-5f, 5540.f, 5550.f, 6.2656f,
				     .26354f, .0098363f, -9.5486e-6f, .0079542f, -2.4062e-5f, 5550.f, 5560.f,
				     1.6378f, .16463f, .013976f, -8.3427e-6f, .012806f, -3.571e-5f, 5560.f,
				     5570.f, 1.9767f, .27227f, .014721f, -2.6094e-5f, .012774f, -4.5522e-5f,
				     5570.f, 5580.f, .586f, .20958f, .012874f, 3.9258e-5f, .011964f,
				     -1.5397e-5f, 5580.f, 5590.f, .73058f, .24104f, .02517f, -9.8784e-5f,
				     .021222f, -8.5036e-5f, 5590.f, 5600.f, 1.3668f, .20354f, .00746f,
				     -5.4501e-6f, .010036f, -2.7451e-5f, 5600.f, 5610.f, .7017f, .14013f,
				     .0054963f, 1.2171e-5f, .010386f, -5.7235e-6f, 5610.f, 5620.f, .97806f,
				     .19171f, .0021812f, 1.6431e-5f, .0066588f, 9.5186e-6f, 5620.f, 5630.f,
				     .29391f, .23855f, .0090316f, 2.3604e-5f, .012635f, -6.6897e-6f, 5630.f,
				     5640.f, .15354f, .15176f, .0057073f, 2e-5f, .014561f, -4.0698e-6f,
				     5640.f, 5650.f, .08073f, .28405f, .014753f, 3.439e-5f, .018447f,
				     -1.775e-5f, 5650.f, 5660.f, .86381f, .14813f, .0029607f, -2.0586e-5f,
				     .0028212f, -1.2594e-5f, 5660.f, 5670.f, .22599f, .16383f, .0084407f,
				     -3.2709e-5f, .011049f, -1.6279e-5f, 5670.f, 5680.f, .0030594f, .17069f,
				     .034284f, -1.0113e-4f, .035042f, -1.1247e-4f, 5680.f, 5690.f, .38291f,
				     .16459f, .0096772f, -4.3054e-5f, .0087884f, -3.2862e-5f, 5690.f, 5700.f,
				     .17817f, .065371f, .0044945f, -2.6954e-5f, .0044075f, 7.1895e-7f,
				     5700.f, 5710.f, .0073272f, .32673f, .018605f, -3.6631e-5f, .021288f,
				     -5.004e-5f, 5710.f, 5720.f, .33773f, .13375f, .0060665f, -3.0734e-5f,
				     .0046922f, -2.5584e-5f, 5720.f, 5730.f, .083205f, .058895f, .0083229f,
				     -4.2023e-5f, .0099661f, -2.959e-5f, 5730.f, 5740.f, .1796f, .1205f,
				     .0065668f, -3.475e-5f, .004411f, -2.7489e-5f, 5740.f, 5750.f, .074406f,
				     .16592f, .012426f, -4.4049e-5f, .012086f, -4.8157e-5f, 5750.f, 5760.f,
				     .029803f, .065159f, .011506f, -5.4589e-5f, .012823f, -5.1753e-5f,
				     5760.f, 5770.f, .134f, .079723f, .011174f, -5.413e-5f, .010639f,
				     -4.7462e-5f, 5770.f, 5780.f, .027397f, .11303f, .0070869f, -8.5837e-6f,
				     .0087642f, -2.4197e-5f, 5780.f, 5790.f, .04813f, .1528f, .017121f,
				     -6.8541e-5f, .016166f, -7.1739e-5f, 5790.f, 5800.f, .098878f, .11702f,
				     .011647f, -5.4757e-5f, .0095467f, -4.9145e-5f, 5800.f, 5810.f,
				     .0011937f, .11746f, .029514f, -1.178e-4f, .026592f, -1.0438e-4f, 5810.f,
				     5820.f, .021084f, .041603f, .018136f, -8.3736e-5f, .01662f, -7.5802e-5f,
				     5820.f, 5830.f, .041859f, .10038f, .011698f, -5.1084e-5f, .0091292f,
				     -3.8447e-5f, 5830.f, 5840.f, .0042835f, .054158f, .020564f, -7.9064e-5f,
				     .016849f, -6.1318e-5f, 5840.f, 5850.f, .039742f, .14212f, .015543f,
				     -6.5164e-5f, .012937f, -6.0213e-5f, 5850.f, 5860.f, .0044465f, .13575f,
				     .018218f, -6.1185e-5f, .017472f, -6.1811e-5f, 5860.f, 5870.f, .013183f,
				     .084879f, .018786f, -7.5902e-5f, .01503f, -6.7738e-5f, 5870.f, 5880.f,
				     .0036488f, .086695f, .023765f, -7.6455e-5f, .019459f, -6.0338e-5f,
				     5880.f, 5890.f, .018172f, .13595f, .016681f, -5.4016e-5f, .014894f,
				     -6.0543e-5f, 5890.f, 5900.f, .0024118f, .072933f, .025664f, -9.6848e-5f,
				     .026465f, -1.0476e-4f, 5900.f, 5910.f, .01494f, .1207f, .017582f,
				     -6.8945e-5f, .016946f, -6.9945e-5f, 5910.f, 5920.f, .0014531f, .081478f,
				     .02565f, -5.6688e-5f, .020849f, -5.2418e-5f, 5920.f, 5930.f, .004057f,
				     .064725f, .024344f, -1.0574e-4f, .021209f, -9.2148e-5f, 5930.f, 5940.f,
				     5.9362e-4f, .052682f, .023362f, -8.193e-5f, .01857f, -7.6269e-5f,
				     5940.f, 5950.f, .0021418f, .075485f, .023733f, -8.0625e-5f, .021119f,
				     -8.5514e-5f, 5950.f, 5960.f, .0033439f, .12209f, .022556f, -8.973e-5f,
				     .019031f, -8.5459e-5f, 5960.f, 5970.f, .0014641f, .13608f, .015568f,
				     3.7809e-6f, .01603f, -2.9177e-5f, 5970.f, 5980.f, 6.3999e-4f, .094011f,
				     .027455f, -3.9873e-5f, .019599f, -3.6883e-5f, 5980.f, 5990.f, .0013405f,
				     .090254f, .029576f, -1.1767e-4f, .026759f, -1.1158e-4f, 5990.f, 6e3f,
				     .0017604f, .17547f, .017851f, -6.4948e-5f, .016287f, -5.6437e-5f, 6e3f,
				     6010.f, .0011569f, .13348f, .026563f, -8.7926e-5f, .023528f,
				     -9.1174e-5f, 6010.f, 6020.f, 2.8575e-4f, .078833f, .019053f,
				     -1.8306e-5f, .018303f, -5.1186e-5f, 6020.f, 6030.f, 8.7532e-4f, .16112f,
				     .022556f, -3.3852e-5f, .021206f, -6.4336e-5f, 6030.f, 6040.f,
				     4.8531e-4f, .054398f, .022035f, -9.7698e-5f, .019943f, -8.9334e-5f,
				     6040.f, 6050.f, 4.2083e-4f, .13305f, .011783f, 6.0192e-5f, .01191f,
				     7.0965e-6f, 6050.f, 6060.f, 3.1283e-4f, .10974f, .024828f, -3.5695e-5f,
				     .021926f, -6.102e-5f, 6060.f, 6070.f, .0016917f, .14682f, .0023913f,
				     1.937e-5f, .0028143f, 1.0914e-5f, 6070.f, 6080.f, 2.4107e-4f, .056225f,
				     .019103f, -5.8306e-6f, .02305f, -4.6373e-5f, 6080.f, 6090.f, 4.4079e-4f,
				     .073062f, .0078845f, -3.8279e-5f, .0064841f, -2.5252e-5f, 6090.f,
				     6100.f, 1.7156e-4f, .08447f, .010336f, 1.0341e-4f, .0085994f,
				     4.3979e-5f, 6100.f, 6110.f, 1.5736e-4f, .047359f, .020348f, -3.159e-5f,
				     .024132f, -5.6992e-5f, 6110.f, 6120.f, .0010666f, .13835f, .0061165f,
				     -8.7157e-6f, .0071462f, -1.5e-5f, 6120.f, 6130.f, 4.1402e-5f, .071564f,
				     .014541f, -3.0661e-5f, .013703f, -3.2448e-5f, 6130.f, 6140.f,
				     1.6673e-5f, .033602f, .019118f, -8.8866e-5f, .016523f, -8.3641e-5f,
				     6140.f, 6150.f, 4.5173e-4f, .19416f, .0081406f, -4.6697e-6f, .0096975f,
				     -2.7594e-5f, 6150.f, 6160.f, 8.4192e-5f, .0848f, .0068868f, 2.0465e-5f,
				     .0065557f, -3.9158e-6f, 6160.f, 6170.f, 1.9983e-4f, .034955f, .013243f,
				     -4.8483e-5f, .014163f, -4.8663e-5f, 6170.f, 6180.f, 5.654e-4f, .092508f,
				     .0032982f, -2.8242e-7f, .0023537f, -1.1797e-5f, 6180.f, 6190.f,
				     2.6602e-4f, .14864f, -.0035881f, 8.4292e-6f, -.0064288f, 1.1323e-5f,
				     6190.f, 6200.f, 6.6332e-4f, .082351f, 4.0475e-5f, -9.1191e-6f,
				     -.0013832f, -7.433e-7f, 6200.f, 6210.f, 5.089e-4f, .13947f, .003362f,
				     -3.1112e-6f, 4.078e-4f, 8.6176e-7f, 6210.f, 6220.f, 1.2815e-4f,
				     .087906f, .012262f, -4.0572e-5f, .01202f, -4.9984e-5f, 6220.f, 6230.f,
				     1.2854e-4f, .12035f, .0025735f, -1.5152e-5f, -2.5291e-4f, -1.3133e-5f,
				     6230.f, 6240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6240.f, 6250.f, 3.8748e-4f,
				     .088892f, .0070553f, -2.9374e-5f, .0061982f, -3.1937e-5f, 6250.f,
				     6260.f, 1.6711e-4f, .096035f, .013535f, -5.983e-5f, .011956f,
				     -5.7292e-5f, 6260.f, 6270.f, 5.1664e-4f, .11783f, .0086933f,
				     -2.7481e-5f, .0070865f, -2.8728e-5f, 6270.f, 6280.f, .001613f, .21378f,
				     .0034321f, -1.5373e-5f, .0028098f, -8.7169e-6f, 6280.f, 6290.f,
				     1.104e-4f, .05027f, .011461f, -5.2791e-5f, .010667f, -5.0501e-5f,
				     6290.f, 6300.f, .0022339f, .16944f, .0043566f, -1.8834e-5f, .0025925f,
				     -1.7523e-5f, 6300.f, 6310.f, 7.0293e-4f, .10055f, .0086229f,
				     -3.5378e-5f, .0057065f, -3.2557e-5f, 6310.f, 6320.f, 2.805e-4f, .12764f,
				     .0056648f, 7.4065e-5f, .0085368f, 1.7469e-5f, 6320.f, 6330.f,
				     6.2308e-4f, .089292f, .01011f, -2.8113e-5f, .010994f, -3.9797e-5f,
				     6330.f, 6340.f, 4.9924e-4f, .15704f, .014233f, -5.3536e-5f, .011904f,
				     -5.3159e-5f, 6340.f, 6350.f, 4.5485e-4f, .2206f, .0045598f, -2.1706e-6f,
				     .0040803f, -1.9834e-5f, 6350.f, 6360.f, 4.4859e-4f, .31977f, .015688f,
				     -3.0431e-5f, .012918f, -4.8166e-5f, 6360.f, 6370.f, 2.7811e-4f, .13882f,
				     .011781f, -2.0096e-5f, .011797f, -2.376e-5f, 6370.f, 6380.f, 8.6844e-4f,
				     .2569f, .011839f, -6.454e-6f, .0097827f, -2.9934e-5f, 6380.f, 6390.f,
				     8.4205e-4f, .26741f, .010125f, -9.2493e-6f, .009507f, -2.6314e-5f,
				     6390.f, 6400.f, .0016976f, .15422f, .0095094f, 1.9053e-5f, .010682f,
				     -7.9536e-6f, 6400.f, 6410.f, 4.7975e-4f, .09426f, .011121f, -4.7922e-5f,
				     .0093837f, -4.1295e-5f, 6410.f, 6420.f, 5.2022e-4f, .16038f, .017528f,

				     -3.7366e-5f, .019737f, -6.1655e-5f, 6420.f, 6430.f, 8.2574e-4f, .16899f,
				     .016228f, -5.7574e-5f, .014443f, -6.2197e-5f, 6430.f, 6440.f, .0021296f,
				     .24095f, .018574f, -5.7065e-5f, .018731f, -6.6716e-5f, 6440.f, 6450.f,
				     2.6201e-4f, .11418f, .021012f, -6.7706e-5f, .019337f, -6.9411e-5f,
				     6450.f, 6460.f, .0026631f, .29606f, .0094001f, 3.2264e-5f, .0092032f,
				     -9.2228e-6f, 6460.f, 6470.f, .0025496f, .1395f, .02196f, -9.1558e-5f,
				     .019725f, -7.8434e-5f, 6470.f, 6480.f, .0030217f, .24286f, .021221f,
				     -4.9207e-5f, .017707f, -5.6279e-5f, 6480.f, 6490.f, .0025925f, .22189f,
				     .011972f, -3.5111e-5f, .011532f, -3.4767e-5f, 6490.f, 6500.f, .0036908f,
				     .17271f, .017079f, -6.2898e-5f, .018276f, -6.9468e-5f, 6500.f, 6510.f,
				     .0058412f, .27765f, .021239f, -8.2779e-5f, .019328f, -7.9739e-5f,
				     6510.f, 6520.f, .0010097f, .36424f, .014201f, 1.4574e-5f, .014137f,
				     -2.5464e-5f, 6520.f, 6530.f, .015531f, .36032f, .015962f, -5.5747e-5f,
				     .013807f, -5.4878e-5f, 6530.f, 6540.f, .021827f, .16998f, .012887f,
				     -5.3561e-5f, .013686f, -4.8168e-5f, 6540.f, 6550.f, .025524f, .44895f,
				     .014216f, -3.1158e-5f, .013867f, -4.6536e-5f, 6550.f, 6560.f, .0046252f,
				     .14687f, .017426f, -7.1751e-5f, .018048f, -6.5015e-5f, 6560.f, 6570.f,
				     .022064f, .27f, .015309f, -5.8062e-5f, .016735f, -6.1409e-5f, 6570.f,
				     6580.f, .042593f, .28026f, .015131f, -6.0674e-5f, .014017f, -5.2957e-5f,
				     6580.f, 6590.f, .039072f, .14924f, .0094106f, -4.0098e-5f, .0098574f,
				     -2.9732e-5f, 6590.f, 6600.f, .054808f, .37702f, .012248f, -2.1938e-5f,
				     .012749f, -3.4984e-5f, 6600.f, 6610.f, .036908f, .16694f, .011325f,
				     -4.1839e-5f, .012369f, -2.3977e-5f, 6610.f, 6620.f, .0049128f, .31728f,
				     .016178f, -8.7947e-6f, .019507f, -3.6007e-5f, 6620.f, 6630.f, .027419f,
				     .23237f, .022088f, -4.83e-5f, .021397f, -5.8784e-5f, 6630.f, 6640.f,
				     .09883f, .17529f, .0067054f, -2.8981e-5f, .0098183f, -2.1164e-5f,
				     6640.f, 6650.f, .097673f, .26249f, .015514f, -2.0366e-5f, .018041f,
				     -4.7825e-5f, 6650.f, 6660.f, .029234f, .39325f, .011043f, 6.9627e-6f,
				     .014995f, -2.8824e-5f, 6660.f, 6670.f, .073358f, .26517f, .022641f,
				     -9.0861e-5f, .020163f, -8.1954e-5f, 6670.f, 6680.f, .28609f, .27963f,
				     .012746f, -3.1154e-5f, .011122f, -2.9019e-5f, 6680.f, 6690.f, .15415f,
				     .42581f, .0092965f, -1.6598e-5f, .010866f, -3.0004e-5f, 6690.f, 6700.f,
				     .50854f, .25928f, .011806f, -4.9706e-5f, .01195f, -4.4564e-5f, 6700.f,
				     6710.f, .54248f, .29219f, .0086655f, -1.078e-5f, .0096072f, -2.0886e-5f,
				     6710.f, 6720.f, 1.1829f, .23177f, .0084264f, -3.6835e-5f, .0078692f,
				     -3.165e-5f, 6720.f, 6730.f, .66413f, .22652f, .0096388f, -4.5502e-5f,
				     .0094036f, -4.2748e-5f, 6730.f, 6740.f, 2.0327f, .2021f, .0051382f,
				     -2.4524e-5f, .0066314f, -1.6094e-5f, 6740.f, 6750.f, 2.8639f, .19875f,
				     .0048057f, -2.8413e-5f, .0044821f, -2.1857e-5f, 6750.f, 6760.f, 2.3946f,
				     .11681f, .0025701f, -2.0163e-5f, .0026061f, -1.6227e-5f, 6760.f, 6770.f,
				     2.3817f, .35427f, .0039392f, -1.7028e-5f, .004929f, -1.8773e-5f, 6770.f,
				     6780.f, 1.6155f, .23449f, 7.3307e-4f, -7.3637e-6f, .0016677f,
				     -2.5528e-6f, 6780.f, 6790.f, 8.3481f, .29624f, 2.1533e-4f, -8.9091e-6f,
				     -1.954e-4f, -6.9089e-6f, 6790.f, 6800.f, 3.9018f, .13513f, -.002043f,
				     4.7043e-6f, .0019385f, 1.5453e-5f, 6800.f, 6810.f, 3.3911f, .24098f,
				     -2.0667e-4f, -6.3633e-6f, -1.6731e-4f, -2.2699e-6f, 6810.f, 6820.f,
				     2.8798f, .25576f, -.0021074f, 5.4951e-6f, -.0021041f, 8.2116e-6f,
				     6820.f, 6830.f, 2.7426f, .15514f, -.0029057f, 1.2463e-5f, .0017031f,
				     1.9513e-5f, 6830.f, 6840.f, 3.2308f, .18429f, -.0036805f, 1.3879e-5f,
				     3.8114e-4f, 2.111e-5f, 6840.f, 6850.f, .82936f, .18124f, 4.1735e-4f,
				     1.4616e-6f, .0025198f, -1.3464e-6f, 6850.f, 6860.f, .35131f, .41646f,
				     .015485f, -4.647e-5f, .013388f, -3.6422e-5f, 6860.f, 6870.f, 4.6683f,
				     .15324f, -.0042182f, 9.0437e-6f, -.0013329f, 1.8577e-5f, 6870.f, 6880.f,
				     2.8455f, .17389f, -.0022094f, 1.4962e-6f, -.0015658f, 9.7344e-6f,
				     6880.f, 6890.f, 8.8724f, .42657f, -.0018169f, 8.1105e-6f, -6.5751e-4f,
				     1.2321e-5f, 6890.f, 6900.f, .81595f, .32457f, .0028256f, 1.2078e-6f,
				     .0059842f, 1.543e-6f, 6900.f, 6910.f, 12.055f, .40831f, -.0011236f,
				     2.2677e-6f, -8.159e-4f, 1.7078e-6f, 6910.f, 6920.f, 1.4005f, .42874f,
				     .0073135f, -1.6167e-5f, .0082389f, -1.8229e-5f, 6920.f, 6930.f, 9.4914f,
				     .29494f, -.0033677f, 1.1156e-5f, -.0016627f, 1.6279e-5f, 6930.f, 6940.f,
				     3.731f, .44986f, .0084547f, -3.0585e-5f, .010303f, -3.5351e-5f, 6940.f,
				     6950.f, 7.9581f, .26975f, -.0014256f, 4.1782e-6f, 1.3886e-4f,
				     7.5184e-6f, 6950.f, 6960.f, 3.409f, .33223f, -8.355e-4f, 9.9982e-6f,
				     .0032926f, 7.9289e-6f, 6960.f, 6970.f, 6.9934f, .49549f, .0034299f,
				     1.3868e-5f, .0073246f, -1.1357e-5f, 6970.f, 6980.f, 8.4288f, .29235f,
				     .0012515f, -6.6867e-6f, .0022057f, -7.2817e-6f, 6980.f, 6990.f, 3.7771f,
				     .34377f, .0066839f, 1.4877e-5f, .0099074f, -2.4726e-5f, 6990.f, 7e3f,
				     5.9358f, .4452f, .0047532f, -1.1726e-5f, .0057444f, -1.6773e-5f, 7e3f,
				     7010.f, 3.6653f, .46656f, .0075924f, -1.4859e-5f, .0085483f,
				     -2.7681e-5f, 7010.f, 7020.f, 7.623f, .59145f, .010355f, -2.3877e-5f,
				     .0084375f, -3.5191e-5f, 7020.f, 7030.f, 2.9785f, .49616f, .0095318f,
				     -2.8442e-5f, .0094393f, -3.7258e-5f, 7030.f, 7040.f, 11.489f, .4463f,
				     .012118f, -4.7464e-5f, .0089557f, -4.3911e-5f, 7040.f, 7050.f, 5.707f,
				     .30579f, .012792f, -5.848e-5f, .011943f, -4.9567e-5f, 7050.f, 7060.f,
				     4.3341f, .45254f, .0087102f, -3.6977e-5f, .0062554f, -2.9678e-5f,
				     7060.f, 7070.f, 18.415f, .27325f, .011045f, -5.5565e-5f, .0087811f,
				     -4.6635e-5f, 7070.f, 7080.f, 9.2559f, .37006f, .0093565f, -4.6638e-5f,
				     .008623f, -4.1694e-5f, 7080.f, 7090.f, 34.399f, .2696f, .0073722f,
				     -4.0297e-5f, .005669f, -3.4996e-5f, 7090.f, 7100.f, 27.357f, .28185f,
				     .0041186f, -2.4656e-5f, .0015333f, -1.4846e-5f, 7100.f, 7110.f, 59.142f,
				     .21235f, .004202f, -2.8298e-5f, .0026623f, -2.2726e-5f, 7110.f, 7120.f,
				     8.729f, .31743f, .0050667f, -2.9057e-5f, .0050497f, -2.4756e-5f, 7120.f,
				     7130.f, 66.372f, .25989f, .0021171f, -2.001e-5f, 9.8789e-4f,
				     -1.5045e-5f, 7130.f, 7140.f, 40.254f, .15248f, 6.4299e-4f, -1.3315e-5f,
				     -6.7491e-4f, -2.9781e-7f, 7140.f, 7150.f, 1.5991f, .45391f, .0083749f,
				     -1.2893e-5f, .011832f, -2.3466e-5f, 7150.f, 7160.f, 138.4f, .26185f,
				     -9.2005e-4f, -7.5058e-6f, -.0022766f, 1.2031e-6f, 7160.f, 7170.f,
				     13.476f, .27958f, 1.7108e-4f, 2.8602e-6f, .0019003f, 2.2534e-6f, 7170.f,
				     7180.f, 95.96f, .20582f, -.0022657f, 1.3812e-6f, -.0015351f, 8.8048e-6f,
				     7180.f, 7190.f, 14.69f, .24608f, 7.8336e-4f, 1.5252e-5f, .003739f,
				     -6.918e-6f, 7190.f, 7200.f, 55.288f, .25862f, -.0013454f, 9.9116e-6f,
				     -8.8298e-4f, 1.7423e-6f, 7200.f, 7210.f, 48.147f, .25568f, .0049183f,
				     -2.3894e-5f, .0037052f, -2.2724e-5f, 7210.f, 7220.f, 40.415f, .20103f,
				     -.0024259f, 7.5229e-6f, -.0017525f, 2.6464e-6f, 7220.f, 7230.f, 109.84f,
				     .33075f, 7.5622e-4f, -1.2921e-5f, -.0011898f, -5.9125e-6f, 7230.f,
				     7240.f, 130.02f, .18533f, -.0033239f, 1.8173e-6f, -.0046918f,

				     8.1132e-6f, 7240.f, 7250.f, 24.491f, .30951f, -.0026793f, 5.8588e-6f,
				     -.0021237f, 4.8e-6f, 7250.f, 7260.f, 19.609f, .15703f, -.0025743f,
				     2.8622e-6f, -.0016255f, 4.4422e-6f, 7260.f, 7270.f, 17.072f, .26657f,
				     -.0029675f, 1.2335e-5f, -6.9569e-4f, 7.7744e-6f, 7270.f, 7280.f,
				     25.243f, .38981f, -.0023499f, 7.2438e-6f, -.0015088f, 4.0106e-6f,
				     7280.f, 7290.f, 139.62f, .16193f, -.0050479f, 9.269e-6f, -.0053276f,
				     1.5266e-5f, 7290.f, 7300.f, 86.705f, .11761f, -.0037859f, 4.4125e-6f,

				     -.0030774f, 1.0295e-5f, 7300.f, 7310.f, 66.458f, .22506f, -.0031197f,
				     2.1671e-6f, -.003942f, 5.6842e-6f, 7310.f, 7320.f, 147.42f, .24611f,
				     -.0023854f, -1.4496e-6f, -.0034285f, 1.2805e-6f, 7320.f, 7330.f,
				     87.291f, .22526f, -1.1541e-4f, -9.6671e-6f, -9.0479e-4f, -7.8703e-6f,
				     7330.f, 7340.f, 155.36f, .27754f, -2.3889e-4f, -8.8494e-6f, -.001057f,
				     -7.3024e-6f, 7340.f, 7350.f, 60.8f, .21141f, .0022877f, -1.825e-5f,
				     .0021735f, -1.6084e-5f, 7350.f, 7360.f, 65.821f, .31454f, .0035102f,
				     -2.3014e-5f, .0021764f, -1.996e-5f, 7360.f, 7370.f, 39.314f, .19452f,
				     .0045708f, -2.8104e-5f, .0035157f, -2.3151e-5f, 7370.f, 7380.f, 33.606f,
				     .30823f, .0071777f, -3.6203e-5f, .0052193f, -2.5338e-5f, 7380.f, 7390.f,
				     28.667f, .22825f, .0067636f, -3.404e-5f, .0062429f, -3.5213e-5f, 7390.f,
				     7400.f, 9.5852f, .3028f, .012912f, -5.3899e-5f, .010209f, -4.4318e-5f,
				     7400.f, 7410.f, 7.5752f, .36859f, .010673f, -1.5633e-5f, .0094631f,
				     -3.3501e-5f, 7410.f, 7420.f, 3.3599f, .31735f, .015132f, -5.0575e-5f,
				     .013714f, -4.8842e-5f, 7420.f, 7430.f, 1.421f, .51877f, .010564f,
				     2.7798e-5f, .010716f, -1.6576e-5f, 7430.f, 7440.f, 1.3357f, .34135f,
				     .0055009f, 2.9075e-5f, .010731f, -1.4716e-5f, 7440.f, 7450.f, .90292f,
				     .35257f, .0064439f, 4.3621e-6f, .0093295f, -7.9773e-6f, 7450.f, 7460.f,
				     .47321f, .34413f, .0075753f, 3.1118e-5f, .0088184f, 2.3143e-6f, 7460.f,
				     7470.f, .14277f, .63005f, .015765f, -3.876e-5f, .014284f, -4.1344e-5f,
				     7470.f, 7480.f, .84751f, .092347f, .0044433f, -2.3373e-5f, .0065281f,
				     -2.0814e-5f, 7480.f, 7490.f, .34962f, .49346f, 3.9951e-4f, 2.823e-6f,
				     .0021242f, -6.058e-7f, 7490.f, 7500.f, .66686f, .32642f, .0015242f,
				     -8.7602e-6f, .0033093f, -6.2194e-6f, 7500.f, 7510.f, .7038f, .37824f,
				     .0040335f, -1.7144e-5f, .0058765f, -1.8563e-5f, 7510.f, 7520.f, .44176f,
				     .28314f, .0041609f, -2.1428e-5f, .0052238f, -2.1647e-5f, 7520.f, 7530.f,
				     .23859f, .25536f, .0046384f, -3.1469e-6f, .0056672f, -1.3268e-5f,
				     7530.f, 7540.f, .12451f, .19246f, .003173f, -1.645e-5f, .0046905f,
				     -1.9919e-5f, 7540.f, 7550.f, .40142f, .2566f, .0068917f, -2.2016e-5f,
				     .0042921f, -2.2533e-5f, 7550.f, 7560.f, .24593f, .28458f, 3.567e-4f,
				     -9.0627e-7f, 6.7869e-4f, -6.7459e-6f, 7560.f, 7570.f, .41189f, .23957f,
				     -2.7548e-4f, 3.566e-6f, 3.9542e-4f, -3.8485e-6f, 7570.f, 7580.f,
				     .20341f, .14662f, .0060408f, -3.5022e-5f, .0043079f, -3.1225e-5f,
				     7580.f, 7590.f, .18188f, .14279f, .0012602f, -3.0833e-6f, .0033638f,
				     -1.3417e-5f, 7590.f, 7600.f, .17978f, .35062f, .005044f, -3.1112e-6f,
				     .0036165f, -1.3022e-5f, 7600.f, 7610.f, .31504f, .16627f, .003265f,
				     -1.3345e-5f, .0040505f, -2.0124e-5f, 7610.f, 7620.f
    };

    /* WATER VAPOR (5060 - 7600 CM-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* wava2 */

void
wava1 (double a[8], const long int inu)
{


    static const float acr[2048] = { 5.2155e-5f, .1088f,
				     .024708f, 5.6434e-5f, .028126f, -3.6504e-5f, 2500.f, 2510.f, 2.6024e-4f,
				     .21216f, .025876f, 3.0026e-5f, .030504f, -6.2253e-5f, 2510.f, 2520.f,
				     1.2221e-4f, .091374f, .023862f, -7.9891e-5f, .020651f, -8.5449e-5f,
				     2520.f, 2530.f, 6.8892e-5f, .12703f, .030103f, -6.0355e-5f, .031571f,
				     -9.5671e-5f, 2530.f, 2540.f, 9.5684e-5f, .11204f, .033051f, -9.6752e-5f,
				     .030485f, -1.1273e-4f, 2540.f, 2550.f, 1.0008e-4f, .092789f, .016702f,
				     4.1104e-5f, .021654f, -1.2175e-5f, 2550.f, 2560.f, 1.1515e-4f, .072392f,
				     .028437f, -8.9454e-5f, .028734f, -1.022e-4f, 2560.f, 2570.f, 1.098e-4f,
				     .093023f, .023611f, 1.0889e-5f, .02688f, -5.0398e-5f, 2570.f, 2580.f,
				     1.0952e-4f, .07579f, .029206f, -9.8206e-5f, .030307f, -1.1103e-4f,
				     2580.f, 2590.f, 1.1941e-4f, .070428f, .019144f, -2.8423e-5f, .019587f,
				     -5.4379e-5f, 2590.f, 2600.f, 8.0498e-5f, .061889f, .024778f,
				     -5.5252e-5f, .028205f, -1.2627e-4f, 2600.f, 2610.f, 7.2792e-5f,
				     .062776f, .026682f, -5.8101e-5f, .029166f, -1.1148e-4f, 2610.f, 2620.f,
				     1.6616e-4f, .015773f, .023141f, -6.0394e-5f, .024947f, -1.1178e-4f,

				     2620.f, 2630.f, 1.8043e-4f, .087686f, .026248f, -3.0398e-5f, .03174f,
				     -1.367e-4f, 2630.f, 2640.f, 1.3339e-4f, .05328f, .012701f, -4.6874e-5f,
				     .012628f, -6.7487e-5f, 2640.f, 2650.f, 4.115e-5f, .0075778f, .011257f,
				     1.1038e-4f, .036362f, -1.1284e-4f, 2650.f, 2660.f, 6.1395e-5f, .026074f,
				     .016798f, 1.0755e-4f, .035481f, -1.3778e-4f, 2660.f, 2670.f, 3.5062e-4f,
				     .080662f, .021065f, -3.9968e-5f, .021602f, -8.7339e-5f, 2670.f, 2680.f,
				     2.6391e-4f, .11483f, .02727f, -4.0691e-5f, .029928f, -1.1046e-4f,
				     2680.f, 2690.f, 8.741e-4f, .06007f, .021732f, -8.76e-5f, .020645f,
				     -9.6557e-5f, 2690.f, 2700.f, 3.0675e-5f, .02297f, .0094212f, 7.8691e-6f,
				     .015402f, -7.4597e-5f, 2700.f, 2710.f, 2.1928e-4f, .13351f, .022082f,
				     -4.5472e-5f, .02546f, -9.6549e-5f, 2710.f, 2720.f, 3.4904e-4f, .095073f,
				     .013969f, 1.2276e-6f, .016415f, -6.5204e-5f, 2720.f, 2730.f, .002136f,
				     .061072f, .018908f, -7.653e-5f, .019801f, -7.7251e-5f, 2730.f, 2740.f,
				     1.3372e-4f, .10806f, .025683f, -4.923e-5f, .025729f, -8.9387e-5f,
				     2740.f, 2750.f, .0021697f, .062188f, .018593f, -8.0474e-5f, .016349f,
				     -8.1422e-5f, 2750.f, 2760.f, 4.503e-5f, .014902f, .011376f, 2.086e-4f,
				     .04688f, -1.3018e-4f, 2760.f, 2770.f, 3.9413e-4f, .075433f, .019773f,
				     3.0322e-5f, .02086f, -4.5326e-5f, 2770.f, 2780.f, .0048935f, .096746f,
				     .019042f, -7.2945e-5f, .016358f, -7.6368e-5f, 2780.f, 2790.f,
				     5.6197e-5f, .026178f, .017977f, 1.4035e-4f, .032163f, -7.1639e-5f,
				     2790.f, 2800.f, .0017459f, .049818f, .012334f, -5.2052e-5f, .013169f,
				     -4.5266e-5f, 2800.f, 2810.f, .013747f, .048325f, .012754f, -6.181e-5f,
				     .011564f, -4.9886e-5f, 2810.f, 2820.f, 8.2805e-4f, .084185f, .021588f,
				     3.0162e-6f, .021186f, -3.7441e-5f, 2820.f, 2830.f, .011866f, .034247f,
				     .0094911f, -5.0331e-5f, .0068889f, -4.5062e-5f, 2830.f, 2840.f,
				     .0053887f, .10669f, .021019f, -5.3528e-5f, .021717f, -5.4515e-5f,
				     2840.f, 2850.f, 1.0411e-4f, .11175f, .031522f, 3.5658e-5f, .036103f,
				     -8.82e-5f, 2850.f, 2860.f, .0079899f, .07314f, .02926f, -1.0778e-4f,
				     .03194f, -1.11e-4f, 2860.f, 2870.f, .024725f, .10335f, .008848f,
				     -3.2902e-5f, .010195f, -1.929e-5f, 2870.f, 2880.f, 5.7422e-4f, .18372f,
				     .046405f, -1.7178e-4f, .046094f, -1.887e-4f, 2880.f, 2890.f, .067995f,
				     .089991f, .016432f, -5.4992e-5f, .019457f, -5.5113e-5f, 2890.f, 2900.f,
				     .03635f, .17982f, .015309f, 7.9551e-7f, .018904f, -3.6064e-5f, 2900.f,
				     2910.f, .02725f, .14127f, .030783f, -1.2895e-4f, .031036f, -1.2355e-4f,
				     2910.f, 2920.f, .002652f, .19136f, .041919f, -1.6834e-4f, .042452f,
				     -1.753e-4f, 2920.f, 2930.f, .52888f, .269f, .012546f, -3.0896e-5f,
				     .013568f, -4.2996e-5f, 2930.f, 2940.f, .053771f, .17608f, .020209f,
				     -6.024e-5f, .025687f, -8.3758e-5f, 2940.f, 2950.f, .32492f, .1684f,
				     .021364f, -9.2341e-5f, .020449f, -8.8117e-5f, 2950.f, 2960.f, .61749f,
				     .1805f, .013955f, -6.0114e-5f, .014337f, -5.833e-5f, 2960.f, 2970.f,
				     1.5421f, .13158f, .0096584f, -4.1781e-5f, .0089471f, -3.729e-5f, 2970.f,

				     2980.f, 1.6668f, .2273f, .0099338f, -3.7288e-5f, .01043f, -3.702e-5f,
				     2980.f, 2990.f, 1.5158f, .13985f, .011565f, -5.1421e-5f, .011056f,
				     -4.3391e-5f, 2990.f, 3e3f, 1.6503f, .17713f, .0095447f, -3.7275e-5f,
				     .0086134f, -3.6851e-5f, 3e3f, 3010.f, 6.5433f, .21911f, .0060474f,
				     -3.289e-5f, .0053084f, -2.7435e-5f, 3010.f, 3020.f, 2.2497f, .12464f,
				     8.6253e-4f, -6.1061e-6f, .0037153f, 4.0466e-6f, 3020.f, 3030.f, 10.011f,
				     .23151f, .0027571f, -1.9224e-5f, .0021442f, -1.1081e-5f, 3030.f, 3040.f,
				     2.7015f, .12619f, .0016271f, -1.3887e-5f, .001636f, -1.9543e-8f, 3040.f,
				     3050.f, 5.2767f, .13242f, .001288f, -1.3169e-5f, .0012577f, -3.613e-6f,
				     3050.f, 3060.f, 9.1595f, .12205f, -.0012513f, -4.0326e-6f, -.0018414f,
				     2.4599e-6f, 3060.f, 3070.f, 4.6857f, .15647f, -4.3308e-5f, -6.9326e-6f,
				     -8.1377e-4f, -3.1694e-6f, 3070.f, 3080.f, 3.2521f, .14435f, .0035016f,
				     -2.0102e-5f, .0037489f, -1.4446e-5f, 3080.f, 3090.f, 8.6678f, .20679f,
				     -.0014866f, 2.2765e-6f, -.001046f, 1.7536e-6f, 3090.f, 3100.f, 9.0277f,
				     .2295f, -.0010574f, -1.1212e-6f, -6.8088e-4f, -3.9181e-8f, 3100.f,
				     3110.f, 12.148f, .38295f, 4.9769e-4f, -4.4194e-6f, 4.3116e-4f,
				     -4.0708e-6f, 3110.f, 3120.f, 9.4078f, .34012f, -3.175e-5f, 2.1043e-6f,
				     .0022348f, 1.6614e-7f, 3120.f, 3130.f, 6.1004f, .077373f, -.004677f,
				     1.1726e-5f, -5.7011e-4f, 3.3047e-5f, 3130.f, 3140.f, .64298f, .083113f,
				     -9.0344e-4f, 7.4815e-6f, .0068034f, 3.8978e-5f, 3140.f, 3150.f, .31468f,
				     .22047f, .0087793f, -1.3249e-5f, .014974f, -2.9267e-5f, 3150.f, 3160.f,
				     .84773f, .34913f, .0023565f, -7.7347e-7f, .004167f, 2.4148e-6f, 3160.f,
				     3170.f, 6.7043f, .10518f, -.0049662f, 1.3112e-5f, -9.2458e-4f,
				     3.1899e-5f, 3170.f, 3180.f, 3.3487f, .17575f, -.0036206f, 1.2779e-5f,
				     5.0643e-5f, 2.6882e-5f, 3180.f, 3190.f, 7.1051f, .15577f, -.0032039f,
				     5.7362e-6f, -.0027319f, 2.0608e-5f, 3190.f, 3200.f, 4.9187f, .094692f,
				     -.0034658f, 9.9349e-6f, 6.5696e-4f, 2.9105e-5f, 3200.f, 3210.f, 11.08f,
				     .15706f, -.0036162f, 6.4921e-6f, -.002575f, 1.9544e-5f, 3210.f, 3220.f,
				     6.4326f, .26178f, -3.2818e-4f, 3.2261e-6f, 5.6524e-4f, 5.0713e-6f,
				     3220.f, 3230.f, 4.8444f, .21447f, -.0019614f, 1.5381e-5f, .0019305f,
				     2.4092e-5f, 3230.f, 3240.f, 8.8873f, .19618f, -.0011584f, 1.5371e-6f,
				     5.7401e-4f, 5.5356e-6f, 3240.f, 3250.f, 6.7011f, .11596f, 3.1879e-4f,
				     -3.2082e-7f, .0027244f, 9.5927e-6f, 3250.f, 3260.f, 3.2951f, .21537f,
				     .0018132f, -9.3642e-6f, .0034721f, -1.0415e-5f, 3260.f, 3270.f, 11.905f,
				     .31637f, -1.7961e-5f, 7.0218e-6f, .0027392f, 8.7434e-8f, 3270.f, 3280.f,
				     4.8139f, .2732f, .0023884f, 2.6589e-5f, .0043504f, 5.7992e-6f, 3280.f,
				     3290.f, 6.9428f, .3268f, .0028073f, -7.0232e-6f, .0032805f, -8.5722e-6f,
				     3290.f, 3300.f, 5.2753f, .19806f, .0027307f, -1.4565e-6f, .0049125f,
				     -1.2966e-5f, 3300.f, 3310.f, 4.7208f, .23262f, .002983f, 2.6911e-5f,
				     .0064942f, -7.7622e-6f, 3310.f, 3320.f, 3.2466f, .37221f, .0099704f,
				     -2.8634e-5f, .011158f, -3.6092e-5f, 3320.f, 3330.f, 4.2083f, .17584f,
				     .013723f, -3.9504e-5f, .013219f, -4.4922e-5f, 3330.f, 3340.f, .78485f,
				     .29505f, .018153f, -7.6368e-5f, .018172f, -6.9561e-5f, 3340.f, 3350.f,
				     4.0763f, .2731f, .011974f, -3.8706e-5f, .010563f, -3.3592e-5f, 3350.f,
				     3360.f, 12.275f, .42572f, .0045309f, 5.9958e-6f, .0056864f, -1.5831e-5f,
				     3360.f, 3370.f, .94088f, .2913f, .012712f, -2.3725e-5f, .01375f,
				     -2.6806e-5f, 3370.f, 3380.f, 5.802f, .18758f, .0056963f, -9.9475e-6f,
				     .0091903f, -1.2922e-5f, 3380.f, 3390.f, 11.279f, .22153f, .010955f,
				     -4.55e-5f, .010347f, -3.3646e-5f, 3390.f, 3400.f, 3.0915f, .29101f,
				     .0076973f, -3.1164e-6f, .0079615f, -1.2231e-5f, 3400.f, 3410.f, 2.746f,
				     .24709f, .01353f, -3.9278e-5f, .015939f, -3.5039e-5f, 3410.f, 3420.f,
				     14.49f, .18486f, .0089652f, -3.5228e-5f, .009544f, -2.5256e-5f, 3420.f,
				     3430.f, 4.152f, .37165f, .0094576f, -9.1648e-6f, .01319f, -1.9085e-5f,
				     3430.f, 3440.f, 35.28f, .29267f, .0077335f, -3.3655e-5f, .0086235f,
				     -3.439e-5f, 3440.f, 3450.f, 1.6073f, .33722f, .016402f, 1.5852e-5f,
				     .018964f, -3.2271e-5f, 3450.f, 3460.f, 13.605f, .31569f, .0095057f,
				     -1.5485e-5f, .0094813f, -1.6751e-5f, 3460.f, 3470.f, 7.5164f, .27307f,
				     .0075889f, -4.7962e-6f, .012249f, -2.3811e-5f, 3470.f, 3480.f, 33.484f,
				     .31131f, .0077627f, -1.1503e-5f, .0094019f, -2.0136e-5f, 3480.f, 3490.f,
				     13.815f, .23917f, .010592f, -3.1935e-5f, .012433f, -3.6436e-5f, 3490.f,
				     3500.f, 61.974f, .36287f, .0075577f, 2.6848e-6f, .010181f, -2.3323e-5f,
				     3500.f, 3510.f, 14.812f, .37195f, .008261f, -1.8654e-5f, .010113f,
				     -3.1482e-5f, 3510.f, 3520.f, 83.223f, .39932f, .0076795f, 5.0656e-7f,
				     .0082892f, -2.0998e-5f, 3520.f, 3530.f, 21.464f, .29835f, .014148f,
				     -4.3852e-5f, .013193f, -5.1897e-5f, 3530.f, 3540.f, 78.956f, .41357f,
				     .012512f, -2.8052e-5f, .0093167f, -3.188e-5f, 3540.f, 3550.f, 57.829f,
				     .33002f, .0050941f, -8.3644e-6f, .0066338f, -1.927e-5f, 3550.f, 3560.f,
				     264.95f, .48627f, .0094242f, -2.4386e-5f, .0071083f, -3.052e-5f, 3560.f,
				     3570.f, 48.65f, .32647f, .003423f, -1.2164e-5f, .0023536f, -9.56e-6f,
				     3570.f, 3580.f, 278.65f, .3935f, .010521f, -4.8325e-5f, .0076691f,
				     -3.9509e-5f, 3580.f, 3590.f, 160.87f, .35038f, .0056295f, -1.9831e-5f,
				     .0040519f, -1.575e-5f, 3590.f, 3600.f, 337.87f, .23399f, .0064862f,
				     -3.0846e-5f, .0044382f, -2.4648e-5f, 3600.f, 3610.f, 576.3f, .34952f,
				     .0047866f, -2.6607e-5f, .0014788f, -1.5623e-5f, 3610.f, 3620.f, 753.87f,
				     .18159f, .0042931f, -2.8734e-5f, .0024163f, -2.2384e-5f, 3620.f, 3630.f,
				     135.67f, .19692f, .0012097f, -8.0313e-6f, -4.4021e-4f, 5.3739e-7f,
				     3630.f, 3640.f, 776.59f, .21673f, .0021798f, -2.0291e-5f, 5.0596e-4f,
				     -1.5749e-5f, 3640.f, 3650.f, 657.22f, .1435f, .001212f, -1.6829e-5f,
				     -2.0471e-4f, -9.1773e-6f, 3650.f, 3660.f, 229.37f, .088535f, -3.47e-4f,
				     -8.0698e-6f, 7.053e-4f, -5.8648e-7f, 3660.f, 3670.f, 1746.9f, .21306f,
				     -.0011718f, -7.1619e-6f, -.0032694f, -2.8781e-7f, 3670.f, 3680.f,
				     833.45f, .086211f, -.0027517f, -7.8552e-7f, -.0033472f, 1.3487e-5f,
				     3680.f, 3690.f, 324.07f, .27669f, -.0021659f, 4.4909e-7f, -.0016982f,
				     1.0818e-5f, 3690.f, 3700.f, 485.79f, .23163f, -.0033766f, 7.1088e-6f,
				     -.0016229f, 1.3215e-5f, 3700.f, 3710.f, 693.99f, .19031f, -.0023753f,
				     1.1342e-5f, 2.795e-4f, 1.1827e-5f, 3710.f, 3720.f, 309.49f, .32694f,
				     .0051146f, -3.3747e-6f, .0055153f, -1.4764e-5f, 3720.f, 3730.f, 1205.8f,
				     .33098f, 2.6244e-4f, 4.4389e-6f, 4.3858e-4f, -5.8687e-6f, 3730.f,
				     3740.f, 2387.3f, .35395f, -.0013313f, -2.6877e-6f, -.0025997f,
				     -1.5668e-6f, 3740.f, 3750.f, 1331.8f, .24255f, -.0023524f, 5.7434e-7f,
				     -.0030581f, 2.0511e-6f, 3750.f, 3760.f, 462.66f, .18423f, -.002022f,
				     1.4083e-6f, -.0011856f, 1.3407e-6f, 3760.f, 3770.f, 221.29f, .15206f,
				     -.0045078f, 1.2626e-5f, -.0025579f, 1.1787e-5f, 3770.f, 3780.f, 72.994f,
				     .26021f, -9.4598e-4f, 5.8721e-6f, .0020193f, 1.4281e-6f, 3780.f, 3790.f,
				     243.54f, .11623f, -.0039723f, 1.0003e-5f, -.0024749f, 1.1674e-5f,
				     3790.f, 3800.f, 1610.2f, .13844f, -.0050654f, 8.5459e-6f, -.0061217f,
				     1.4867e-5f, 3800.f, 3810.f, 925.09f, .095941f, -.0040019f, 4.2438e-6f,
				     -.0041671f, 1.3408e-5f, 3810.f, 3820.f, 878.65f, .19813f, -.0032809f,
				     1.3909e-6f, -.0048774f, 6.0213e-6f, 3820.f, 3830.f, 1445.5f, .15082f,
				     -.0027746f, -6.1623e-7f, -.004156f, 6.6755e-6f, 3830.f, 3840.f, 368.8f,
				     .2433f, 4.8895e-4f, -1.2565e-5f, -3.1389e-4f, -8.6255e-6f, 3840.f,
				     3850.f, 2068.8f, .2275f, -8.8059e-4f, -7.9102e-6f, -.0024751f,
				     -3.6839e-6f, 3850.f, 3860.f, 634.35f, .19602f, .0017316f, -1.7618e-5f,
				     2.7542e-4f, -9.9025e-6f, 3860.f, 3870.f, 660.01f, .16073f, .0019181f,
				     -1.8141e-5f, 8.7743e-4f, -1.3268e-5f, 3870.f, 3880.f, 596.2f, .22715f,
				     .0044999f, -2.8285e-5f, .0029743f, -2.3179e-5f, 3880.f, 3890.f, 497.07f,
				     .23257f, .0049027f, -2.8299e-5f, .0031352f, -2.2089e-5f, 3890.f, 3900.f,
				     476.01f, .20656f, .0070284f, -3.7624e-5f, .0056038f, -3.3998e-5f,
				     3900.f, 3910.f, 97.812f, .12575f, .012028f, -5.8026e-5f, .010886f,
				     -5.051e-5f, 3910.f, 3920.f, 154.07f, .2759f, .0075519f, -2.7169e-5f,
				     .0059888f, -2.6593e-5f, 3920.f, 3930.f, 75.906f, .19815f, .014672f,
				     -6.2916e-5f, .010813f, -4.7324e-5f, 3930.f, 3940.f, 91.761f, .19338f,
				     .015621f, -6.9646e-5f, .014264f, -6.8568e-5f, 3940.f, 3950.f, 23.976f,
				     .28167f, .0049108f, 1.7525e-5f, .0072419f, -1.0423e-5f, 3950.f, 3960.f,
				     14.037f, .20425f, .017638f, -2.7195e-5f, .013686f, -3.6754e-5f, 3960.f,
				     3970.f, 15.37f, .33316f, .0098866f, 2.0342e-5f, .011243f, -2.1419e-5f,
				     3970.f, 3980.f, 5.4881f, .22417f, .0075532f, 3.9091e-5f, .010416f,
				     -2.6476e-6f, 3980.f, 3990.f, 8.3126f, .20066f, .013204f, -8.1155e-7f,
				     .014493f, -3.2804e-5f, 3990.f, 4e3f, 8.7033f, .12823f, .0053683f,
				     -1.0088e-5f, .0083956f, -9.9974e-6f, 4e3f, 4010.f, 7.1987f, .21615f,
				     .0019288f, 1.9286e-5f, .006975f, 2.1036e-5f, 4010.f, 4020.f, 7.374f,
				     .10603f, .0021924f, -1.68e-5f, .0031402f, 6.6314e-10f, 4020.f, 4030.f,
				     1.2253f, .20951f, .0061999f, 3.6357e-5f, .012788f, -6.0887e-6f, 4030.f,
				     4040.f, 7.9524f, .12691f, .0039534f, -2.3885e-5f, .0036525f,
				     -1.0242e-5f, 4040.f, 4050.f, .51733f, .11847f, .011888f, -3.4371e-5f,
				     .016178f, -2.9656e-5f, 4050.f, 4060.f, 1.8317f, .094248f, .0053224f,
				     -2.5376e-5f, .005784f, -6.4186e-6f, 4060.f, 4070.f, 2.7229f, .12453f,
				     .0093697f, -3.7263e-5f, .0090599f, -2.2481e-5f, 4070.f, 4080.f, 3.4742f,
				     .19542f, .0072771f, -3.4478e-5f, .0043552f, -2.4708e-5f, 4080.f, 4090.f,
				     .08819f, .11131f, .0125f, -3.4253e-5f, .016631f, -2.1563e-5f, 4090.f,
				     4100.f, 4.472f, .16534f, .0066915f, -3.536e-5f, .0054523f, -3.2561e-5f,
				     4100.f, 4110.f, .017698f, .14435f, .0099143f, 3.28e-5f, .020212f,
				     3.5978e-6f, 4110.f, 4120.f, .49468f, .13443f, .0087298f, -3.5276e-5f,
				     .0068006f, -3.1378e-5f, 4120.f, 4130.f, 2.2881f, .15905f, .011097f,
				     -4.923e-5f, .01025f, -4.8021e-5f, 4130.f, 4140.f, .62111f, .16054f,
				     .011288f, -5.0025e-5f, .010196f, -4.7296e-5f, 4140.f, 4150.f, .60454f,
				     .14755f, .014727f, -4.9548e-5f, .014191f, -5.8716e-5f, 4150.f, 4160.f,
				     .093094f, .068954f, .004002f, -3.9015e-6f, .0055718f, -1.3126e-6f,
				     4160.f, 4170.f, .27101f, .093272f, .013113f, -5.6084e-5f, .012707f,
				     -5.2567e-5f, 4170.f, 4180.f, .5398f, .067639f, .016122f, -7.5048e-5f,
				     .013265f, -6.515e-5f, 4180.f, 4190.f, .44133f, .17104f, .016673f,
				     -7.1388e-5f, .014609f, -6.461e-5f, 4190.f, 4200.f, .36918f, .11239f,
				     .013785f, -5.548e-5f, .014404f, -5.8254e-5f, 4200.f, 4210.f, .13276f,
				     .12746f, .017403f, -5.447e-5f, .013863f, -4.8485e-5f, 4210.f, 4220.f,
				     .080464f, .086998f, .022044f, -9.2895e-5f, .019048f, -8.7985e-5f,
				     4220.f, 4230.f, .063692f, .14834f, .022806f, -8.4692e-5f, .023548f,
				     -9.253e-5f, 4230.f, 4240.f, .01811f, .12119f, .018389f, -2.2676e-6f,
				     .013683f, -2.6036e-5f, 4240.f, 4250.f, .209f, .16597f, .019432f,
				     -7.8011e-5f, .019282f, -8.4089e-5f, 4250.f, 4260.f, .049819f, .06211f,
				     .026704f, -1.1099e-4f, .025655f, -1.0067e-4f, 4260.f, 4270.f, .051444f,
				     .1311f, .014568f, -3.4291e-5f, .014016f, -4.9479e-5f, 4270.f, 4280.f,
				     .010759f, .15106f, .027993f, -1.0013e-4f, .023418f, -8.4057e-5f, 4280.f,
				     4290.f, .005931f, .085611f, .036412f, -1.5063e-4f, .034796f,
				     -1.4138e-4f, 4290.f, 4300.f, .060294f, .13145f, .023253f, -8.8313e-5f,
				     .022949f, -9.0705e-5f, 4300.f, 4310.f, .0087499f, .11428f, .024739f,
				     -5.6984e-5f, .024765f, -7.2542e-5f, 4310.f, 4320.f, .0043984f, .17658f,
				     .035844f, -1.1719e-4f, .030706f, -1.0295e-4f, 4320.f, 4330.f, .0031592f,
				     .14762f, .014237f, 6.5312e-6f, .014523f, -1.9336e-5f, 4330.f, 4340.f,

				     .0022605f, .13901f, .023941f, 1.0579e-5f, .023751f, -4.5551e-5f, 4340.f,
				     4350.f, 8.4338e-8f, 1.5285e-4f, .0047057f, -2.5631e-5f, .0022316f,
				     -2.3738e-5f, 4350.f, 4360.f, 9.5411e-8f, 1.1284e-4f, .0051111f,
				     -2.6317e-5f, .0030958f, -2.5483e-5f, 4360.f, 4370.f, 1.5708e-8f,
				     4.7653e-5f, .0099036f, -4.9633e-5f, .0072007f, -4.4307e-5f, 4370.f,
				     4380.f, 7.2646e-5f, .073368f, .017942f, 1.2698e-5f, .012584f,
				     -3.4551e-5f, 4380.f, 4390.f, 5.9152e-5f, .041171f, .00839f, -4.5951e-5f,
				     .0057949f, -4.0723e-5f, 4390.f, 4400.f, 9.0913e-5f, .0094376f, .037251f,
				     -1.6131e-4f, .034629f, -1.5582e-4f, 4400.f, 4410.f, 3.4561e-8f,
				     4.7569e-5f, .0015514f, -1.0274e-5f, 6.5701e-7f, -1.2526e-5f, 4410.f,
				     4420.f, 4.3107e-4f, .054262f, .024045f, -4.9839e-5f, .016547f,
				     -4.4636e-5f, 4420.f, 4430.f, 3.1142e-4f, .038963f, .014134f,
				     -6.8927e-5f, .011537f, -6.369e-5f, 4430.f, 4440.f, 1.4945e-8f,
				     7.8332e-5f, .0089337f, -4.3145e-5f, .0069004f, -4.2442e-5f, 4440.f,
				     4450.f, .0016802f, .051222f, .015502f, -2.3447e-5f, .010002f,
				     -3.2528e-5f, 4450.f, 4460.f, 1.0007e-4f, .066862f, .02459f, -9.8504e-5f,
				     .022882f, -1.0233e-4f, 4460.f, 4470.f, .0030025f, .051153f, .01923f,
				     -8.107e-5f, .015535f, -6.8267e-5f, 4470.f, 4480.f, 8.6831e-5f, .040458f,
				     .036221f, -1.5713e-4f, .03335f, -1.5083e-4f, 4480.f, 4490.f, .0080902f,
				     .1275f, .016863f, -7.6478e-5f, .01678f, -7.7918e-5f, 4490.f, 4500.f,
				     .0022317f, .15229f, .012535f, -1.3795e-5f, .010875f, -3.7123e-5f,
				     4500.f, 4510.f, .019169f, .11664f, .010716f, -5.1479e-5f, .0082124f,
				     -4.6198e-5f, 4510.f, 4520.f, .0065788f, .15986f, .012038f, -5.1957e-5f,
				     .010074f, -5.1345e-5f, 4520.f, 4530.f, .03291f, .11768f, .0084067f,
				     -4.3158e-5f, .0067305f, -4.0106e-5f, 4530.f, 4540.f, .044345f, .15763f,
				     .0035365f, -2.4308e-5f, 7.9048e-4f, -1.7012e-5f, 4540.f, 4550.f,
				     .027331f, .16819f, .0042859f, -2.1639e-5f, .0038192f, -2.5423e-5f,
				     4550.f, 4560.f, .020407f, .09609f, .001546f, -1.6323e-5f, 6.6197e-4f,
				     -9.1244e-6f, 4560.f, 4570.f, .057143f, .18848f, .0030453f, -1.8516e-5f,
				     .0016176f, -1.8614e-5f, 4570.f, 4580.f, .052929f, .13102f, -.0010515f,
				     -4.5621e-6f, -.0023271f, 2.7682e-6f, 4580.f, 4590.f, .028557f, .14681f,
				     -4.8301e-4f, -6.3151e-6f, -.0019647f, -5.3522e-6f, 4590.f, 4600.f,
				     .0046383f, .13391f, .0088609f, -2.6493e-5f, .0082741f, -3.2453e-5f,
				     4600.f, 4610.f, .02773f, .10824f, -.0034789f, 5.4132e-6f, -.0030391f,
				     8.0678e-6f, 4610.f, 4620.f, .051267f, .16778f, -.0015076f, -7.4663e-7f,
				     -.0025263f, 3.707e-6f, 4620.f, 4630.f, .0129f, .13459f, 4.1658e-4f,
				     7.4475e-7f, .0012458f, -7.7586e-6f, 4630.f, 4640.f, .044954f, .38311f,
				     -.0018643f, 4.6026e-6f, -.0027134f, 4.4958e-6f, 4640.f, 4650.f,
				     .0048639f, .10343f, .0025659f, -1.6961e-5f, .0023819f, -1.4778e-5f,
				     4650.f, 4660.f, .0012082f, .18004f, .014733f, -5.2646e-5f, .014275f,
				     -6.0508e-5f, 4660.f, 4670.f, .0013469f, .34467f, .012177f, -2.3395e-5f,
				     .010966f, -3.6299e-5f, 4670.f, 4680.f, .0068991f, .1607f, 6.4738e-4f,
				     3.7071e-6f, .0032901f, -2.0981e-6f, 4680.f, 4690.f, .027452f, .060959f,
				     -.0051851f, 1.2668e-5f, -.0041528f, 2.6305e-5f, 4690.f, 4700.f,
				     .017796f, .15523f, -.0027265f, 3.7407e-6f, -.0033733f, 1.0358e-5f,
				     4700.f, 4710.f, .011446f, .17796f, -6.8324e-4f, 6.8406e-6f, -.0010826f,
				     5.9431e-6f, 4710.f, 4720.f, .029309f, .13652f, -.0017282f, 6.762e-6f,
				     5.6764e-4f, 1.3237e-5f, 4720.f, 4730.f, .021395f, .18395f, -.0015768f,
				     1.4383e-5f, 1.5897e-4f, 8.796e-6f, 4730.f, 4740.f, .0025077f, .18622f,
				     .0042912f, -4.9559e-6f, .0045676f, -2.6247e-6f, 4740.f, 4750.f,
				     .031587f, .13943f, -.0012088f, -8.9815e-8f, -1.571e-4f, 2.0359e-5f,
				     4750.f, 4760.f, .034566f, .28253f, .0016858f, -8.995e-6f, 9.752e-4f,
				     -8.1082e-6f, 4760.f, 4770.f, .020369f, .14591f, -.0014421f, 1.9399e-5f,
				     .0039665f, 1.4338e-5f, 4770.f, 4780.f, .0081447f, .12195f, .0013964f,
				     3.2025e-5f, .0037728f, 2.0537e-5f, 4780.f, 4790.f, .019803f, .14625f,
				     9.6298e-4f, -2.9783e-6f, .0041118f, -9.7923e-7f, 4790.f, 4800.f,
				     .0052146f, .17691f, .014543f, -3.1749e-5f, .0149f, -4.4049e-5f, 4800.f,
				     4810.f, .035065f, .21617f, -.0021492f, 2.3072e-5f, .001178f, 2.4416e-5f,
				     4810.f, 4820.f, .012656f, .15792f, .0083705f, -2.1219e-5f, .0082684f,
				     -2.8775e-5f, 4820.f, 4830.f, .014126f, .4985f, .0096621f, 2.3197e-5f,
				     .011163f, -2.0765e-5f, 4830.f, 4840.f, .023704f, .35541f, .0055808f,
				     -1.0952e-6f, .0068854f, -1.3359e-5f, 4840.f, 4850.f, .032166f, .23632f,
				     -2.3289e-4f, 7.945e-6f, .0017163f, 2.8957e-6f, 4850.f, 4860.f, .026468f,
				     .24812f, .008326f, 8.9107e-6f, .010638f, -2.4848e-5f, 4860.f, 4870.f,
				     .012607f, .28278f, .014341f, -1.7161e-5f, .017744f, -4.3433e-5f, 4870.f,
				     4880.f, .0019484f, .13452f, .014299f, -5.8644e-5f, .012622f,
				     -5.8891e-5f, 4880.f, 4890.f, .019835f, .43138f, .016502f, -3.7834e-5f,
				     .015564f, -5.3844e-5f, 4890.f, 4900.f, .031673f, .23676f, .018724f,
				     -6.2795e-5f, .017963f, -6.7476e-5f, 4900.f, 4910.f, .020383f, .1686f,
				     .02082f, -9.2373e-5f, .018807f, -8.5676e-5f, 4910.f, 4920.f, .034221f,
				     .37729f, .014636f, 9.8132e-6f, .015033f, -3.2546e-5f, 4920.f, 4930.f,
				     .041381f, .17341f, .004227f, 2.6778e-5f, .0073624f, -6.193e-6f, 4930.f,
				     4940.f, .050322f, .24574f, .01506f, -6.0731e-5f, .01171f, -4.9448e-5f,
				     4940.f, 4950.f, .11355f, .43168f, .012506f, -2.3567e-5f, .010508f,
				     -3.2884e-5f, 4950.f, 4960.f, .073646f, .28063f, .01551f, -6.3821e-5f,
				     .012136f, -5.1762e-5f, 4960.f, 4970.f, .0021754f, .2329f, .025115f,
				     1.3402e-6f, .023138f, -4.9298e-5f, 4970.f, 4980.f, .20462f, .37006f,
				     .013871f, -5.7344e-5f, .011137f, -4.9726e-5f, 4980.f, 4990.f, .15479f,
				     .14505f, .012101f, -5.5517e-5f, .011913f, -3.8561e-5f, 4990.f, 5e3f,
				     .1627f, .14157f, .012656f, -4.9554e-5f, .01273f, -4.7918e-5f, 5e3f,
				     5010.f, .20283f, .16538f, .0098358f, -4.1905e-5f, .0091599f,
				     -3.3109e-5f, 5010.f, 5020.f, .32847f, .20501f, .010455f, -3.0987e-5f,
				     .011634f, -2.2216e-5f, 5020.f, 5030.f, .4088f, .1568f, .0097922f,
				     -4.2397e-5f, .0098076f, -3.8651e-5f, 5030.f, 5040.f, .27012f, .21951f,
				     .012867f, -1.8768e-6f, .012462f, -2.155e-5f, 5040.f, 5050.f, .5761f,
				     .16605f, .0061804f, -3.0533e-5f, .0069772f, -1.7735e-5f, 5050.f, 5060.f
    };

    /* WATER VAPOR (2500 - 5040 CM-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* wava1 */


void dica3 (double a[8], const long int inu)
{


    static const float acr[2048] = { 4.1135e-5f, .13491f,
				     .019511f, -8.8592e-5f, .017169f, -8.6383e-5f, 7620.f, 7630.f, 0.f, 0.f,
				     0.f, 0.f, 0.f, 0.f, 7630.f, 7640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7640.f,
				     7650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7650.f, 7660.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7660.f, 7670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7670.f, 7680.f,
				     6.9843e-6f, .05869f, .017996f, -8.495e-5f, .014986f, -7.9255e-5f,
				     7680.f, 7690.f, 4.4856e-5f, .1161f, .012313f, -6.1208e-5f, .0094917f,
				     -5.6817e-5f, 7690.f, 7700.f, 2.1119e-4f, .14823f, .0058288f,

				     -3.5255e-5f, .0029752f, -3.0772e-5f, 7700.f, 7710.f, 6.8368e-4f,
				     .18822f, 2.1812e-4f, -1.3229e-5f, -.0027425f, -8.0771e-6f, 7710.f,
				     7720.f, 8.0401e-4f, .20648f, -.0032887f, 5.0708e-8f, -.0062117f,
				     5.94e-6f, 7720.f, 7730.f, 3.6897e-4f, .20612f, -.0045166f, 4.7173e-6f,
				     -.0074494f, 1.0697e-5f, 7730.f, 7740.f, .0011094f, .31021f, -.0022536f,
				     -1.0224e-6f, -.0033444f, 2.1129e-6f, 7740.f, 7750.f, 6.5848e-4f,
				     .26193f, .0027594f, -2.1278e-5f, 2.5217e-4f, -1.8776e-5f, 7750.f,
				     7760.f, 7.3155e-5f, .30739f, .013041f, -6.319e-5f, .010499f,
				     -6.0136e-5f, 7760.f, 7770.f, 1.9363e-5f, .19417f, .014647f, -7.1772e-5f,
				     .011659f, -6.5892e-5f, 7770.f, 7780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     7780.f,
				     7790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7790.f, 7800.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7800.f, 7810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7810.f, 7820.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7820.f, 7830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7830.f,
				     7840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7840.f, 7850.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7850.f, 7860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7860.f, 7870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7870.f, 7880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7880.f,
				     7890.f, 3.719e-5f, .1891f, 3.2484e-4f, -1.3576e-5f, -.0026862f,
				     -8.2867e-6f, 7890.f, 7900.f, 9.4656e-5f, .363f, -.0020395f, -4.2752e-6f,
				     -.0049939f, 1.2049e-6f, 7900.f, 7910.f, 7.3888e-5f, .33612f, -.0027854f,
				     -1.4358e-6f, -.005628f, 3.7427e-6f, 7910.f, 7920.f, 3.5986e-5f, .14439f,
				     -.0040916f, 3.0556e-6f, -.0070423f, 9.0581e-6f, 7920.f, 7930.f,
				     7.729e-5f, .22754f, -.0015562f, -6.2734e-6f, -.0044592f, -1.0627e-6f,
				     7930.f, 7940.f, 1.8388e-5f, .092491f, .0027526f, -2.4014e-5f,
				     -3.4204e-4f, -1.8092e-5f, 7940.f, 7950.f, 1.9936e-7f, .0010968f,
				     .001703f, -2.0156e-5f, -.0013872f, -1.4222e-5f, 7950.f, 7960.f,
				     4.9455e-7f, .0019615f, -.0015846f, -6.8674e-6f, -.004292f, -1.7132e-6f,
				     7960.f, 7970.f, 2.7828e-7f, .0013177f, -.0036989f, 1.1926e-6f,
				     -.0065515f, 6.9563e-6f, 7970.f, 7980.f, 3.8372e-7f, .0017475f,
				     -.0038411f, 1.7875e-6f, -.0067043f, 7.5942e-6f, 7980.f, 7990.f,
				     7.3276e-7f, .003011f, -6.7794e-4f, -9.4857e-6f, -.0034111f,
				     -5.1641e-6f, 7990.f, 8e3f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8e3f, 8010.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 8010.f, 8020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     8020.f,
				     8030.f, 3.7029e-8f, 3.6096e-4f, .012109f, -6.2089e-5f, .0089059f,
				     -5.5639e-5f, 8030.f, 8040.f, 2.1335e-7f, .0010751f, .0088149f,
				     -4.8284e-5f, .0057133f, -4.2623e-5f, 8040.f, 8050.f, 4.6462e-7f,
				     .001086f, .0049284f, -3.291e-5f, .0017555f, -2.6942e-5f, 8050.f, 8060.f,
				     1.5991e-6f, .0018385f, 6.4633e-4f, -1.5477e-5f, -.0022392f,
				     -1.0372e-5f, 8060.f, 8070.f, 1.7752e-6f, .0016397f, -.0024966f,
				     -3.4666e-6f, -.0051909f, 1.8847e-6f, 8070.f, 8080.f, 2.4423e-5f,
				     .26254f, .02579f, -7.7107e-5f, .025403f, -1.1405e-4f, 8080.f, 8090.f,
				     6.1857e-5f, .23309f, .021977f, -7.7807e-5f, .020482f, -9.5402e-5f,
				     8090.f, 8100.f, 1.3473e-4f, .23293f, .019374f, -8.4779e-5f, .016814f,
				     -8.2971e-5f, 8100.f, 8110.f, 3.3293e-4f, .42794f, .016857f, -7.4779e-5f,
				     .01563f, -7.4735e-5f, 8110.f, 8120.f, 4.5545e-4f, .42084f, .014131f,
				     -6.4833e-5f, .011587f, -6.2246e-5f, 8120.f, 8130.f, 3.9267e-4f, .4459f,
				     .01422f, -6.6328e-5f, .010179f, -5.8346e-5f, 8130.f, 8140.f, .0014095f,
				     .66221f, .012879f, -6.3481e-5f, .010259f, -5.9679e-5f, 8140.f, 8150.f,
				     .0025744f, .34109f, .0081434f, -3.5365e-5f, .010242f, -4.4763e-5f,
				     8150.f, 8160.f, .0053482f, .12345f, .0021618f, -2.1398e-5f, -8.9174e-4f,
				     -1.5761e-5f, 8160.f, 8170.f, .0085974f, .12902f, -.0011939f, -8.269e-6f,
				     -.0041809f, -2.5012e-6f, 8170.f, 8180.f, .011093f, .20887f, -.0036354f,
				     1.357e-6f, -.006594f, 7.4093e-6f, 8180.f, 8190.f, .0090124f, .22951f,
				     -.0041975f, 3.4952e-6f, -.0071581f, 9.6182e-6f, 8190.f, 8200.f,
				     .022977f, .54634f, 5.4679e-4f, -7.4452e-6f, 3.2715e-5f, -7.7515e-6f,
				     8200.f, 8210.f, 4.0967e-5f, .33171f, .029828f, -1.2884e-4f, .027502f,
				     -1.2751e-4f, 8210.f, 8220.f, 1.3117e-4f, .36661f, .024705f, -1.0516e-4f,
				     .023688f, -1.1029e-4f, 8220.f, 8230.f, 4.1427e-4f, .33236f, .018964f,
				     -8.1986e-5f, .018612f, -8.8547e-5f, 8230.f, 8240.f, .0011268f, .30228f,
				     .013786f, -6.0455e-5f, .014251f, -6.6968e-5f, 8240.f, 8250.f, .0038631f,
				     .3115f, .0080823f, -3.8679e-5f, .0084273f, -4.2578e-5f, 8250.f, 8260.f,
				     .0060039f, .26991f, .0040499f, -2.3093e-5f, .0051036f, -2.751e-5f,
				     8260.f, 8270.f, .014968f, .24443f, -6.0624e-4f, -8.9134e-6f, -.0014888f,
				     -7.5779e-6f, 8270.f, 8280.f, .015831f, .42226f, -.0020274f, 6.2203e-6f,
				     -1.636e-4f, -2.1524e-6f, 8280.f, 8290.f, .0086272f, .42161f, -.0028717f,
				     1.6391e-5f, 5.8996e-4f, 1.5552e-5f, 8290.f, 8300.f, .038978f, .60506f,
				     -1.8963e-4f, -4.6658e-6f, -.0011243f, -4.8784e-6f, 8300.f, 8310.f, 0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 8310.f, 8320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     8320.f,
				     8330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8330.f, 8340.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8340.f, 8350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8350.f, 8360.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8360.f, 8370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8370.f,
				     8380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8380.f, 8390.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8390.f, 8400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8400.f, 8410.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8410.f, 8420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8420.f,
				     8430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8430.f, 8440.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8440.f, 8450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8450.f, 8460.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8460.f, 8470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8470.f,
				     8480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8480.f, 8490.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8490.f, 8500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8500.f, 8510.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8510.f, 8520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8520.f,
				     8530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8530.f, 8540.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8540.f, 8550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8550.f, 8560.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8560.f, 8570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8570.f,
				     8580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8580.f, 8590.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8590.f, 8600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8600.f, 8610.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8610.f, 8620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8620.f,
				     8630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8630.f, 8640.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8640.f, 8650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8650.f, 8660.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8660.f, 8670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8670.f,
				     8680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8680.f, 8690.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8690.f, 8700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8700.f, 8710.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8710.f, 8720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8720.f,
				     8730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8730.f, 8740.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8740.f, 8750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8750.f, 8760.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8760.f, 8770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8770.f,
				     8780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8780.f, 8790.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8790.f, 8800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8800.f, 8810.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8810.f, 8820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8820.f,
				     8830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8830.f, 8840.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8840.f, 8850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8850.f, 8860.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8860.f, 8870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8870.f,
				     8880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8880.f, 8890.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8890.f, 8900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8900.f, 8910.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8910.f, 8920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8920.f,
				     8930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8930.f, 8940.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8940.f, 8950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8950.f, 8960.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8960.f, 8970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8970.f,
				     8980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8980.f, 8990.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8990.f, 9e3f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9e3f, 9010.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9010.f, 9020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9020.f,
				     9030.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9030.f, 9040.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9040.f, 9050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9050.f, 9060.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9060.f, 9070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9070.f,
				     9080.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9080.f, 9090.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9090.f, 9100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9100.f, 9110.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9110.f, 9120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9120.f,
				     9130.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9130.f, 9140.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9140.f, 9150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9150.f, 9160.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9160.f, 9170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9170.f,
				     9180.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9180.f, 9190.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9190.f, 9200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9200.f, 9210.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9210.f, 9220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9220.f,
				     9230.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9230.f, 9240.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9240.f, 9250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9250.f, 9260.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9260.f, 9270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9270.f,
				     9280.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9280.f, 9290.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9290.f, 9300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9300.f, 9310.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9310.f, 9320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9320.f,
				     9330.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9330.f, 9340.f, 9.9593e-6f, .060237f,
				     .0097616f, -5.2148e-5f, .0066534f, -4.6124e-5f, 9340.f, 9350.f,
				     4.3567e-5f, .12051f, .0054505f, -3.4277e-5f, .0024633f, -2.9032e-5f,
				     9350.f, 9360.f, 8.8924e-5f, .12477f, .0012273f, -1.774e-5f, -.0018429f,
				     -1.1984e-5f, 9360.f, 9370.f, 1.5573e-4f, .16489f, -.0021342f,
				     -4.4631e-6f, -.005046f, 1.1731e-6f, 9370.f, 9380.f, 9.4382e-5f, .17579f,
				     -.0041243f, 3.1944e-6f, -.0071235f, 9.3601e-6f, 9380.f, 9390.f,
				     2.1829e-4f, .27491f, -.0034678f, 8.2722e-7f, -.0064858f, 7.0242e-6f,
				     9390.f, 9400.f, 2.27e-4f, .36616f, .0019245f, -1.579e-5f, -1.5673e-4f,
				     -1.5436e-5f, 9400.f, 9410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9410.f, 9420.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9420.f, 9430.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9430.f, 9440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9440.f, 9450.f, 4.0618e-5f,
				     .33672f, .016922f, -7.9759e-5f, .013854f, -7.4271e-5f, 9450.f, 9460.f,
				     8.026e-5f, .35567f, .013366f, -6.6285e-5f, .010448f, -6.0815e-5f,
				     9460.f, 9470.f, 1.7445e-4f, .15326f, .0081302f, -4.4538e-5f, .0056112f,
				     -4.1022e-5f, 9470.f, 9480.f, 3.3041e-4f, .26053f, .0049592f, -2.831e-5f,
				     .0049032f, -3.3415e-5f, 9480.f, 9490.f, 8.9723e-4f, .1582f, -1.1481e-4f,
				     -1.225e-5f, -.0031268f, -6.7086e-6f, 9490.f, 9500.f, 8.7248e-4f,
				     .13522f, -.0029599f, -1.3666e-6f, -.005813f, 4.3278e-6f, 9500.f, 9510.f,
				     5.7391e-4f, .20153f, -.0043771f, 4.1806e-6f, -.0073125f, 1.0212e-5f,
				     9510.f, 9520.f, .002106f, .33852f, -.0026269f, -1.9082e-6f, -.0056393f,
				     3.824e-6f, 9520.f, 9530.f, 8.7766e-4f, .35363f, .0044041f, -2.4109e-5f,
				     .0031707f, -2.6057e-5f, 9530.f, 9540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     9540.f, 9550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9550.f, 9560.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9560.f, 9570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9570.f,
				     9580.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9580.f, 9590.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9590.f, 9600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9600.f, 9610.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9610.f, 9620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9620.f,
				     9630.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9630.f, 9640.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9640.f, 9650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9650.f, 9660.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9660.f, 9670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9670.f,
				     9680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9680.f, 9690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9690.f, 9700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9700.f, 9710.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9710.f, 9720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9720.f,
				     9730.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9730.f, 9740.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9740.f, 9750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9750.f, 9760.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9760.f, 9770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9770.f,
				     9780.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9780.f, 9790.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9790.f, 9800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9800.f, 9810.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9810.f, 9820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9820.f,
				     9830.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9830.f, 9840.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9840.f, 9850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9850.f, 9860.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9860.f, 9870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9870.f,
				     9880.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9880.f, 9890.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9890.f, 9900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9900.f, 9910.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9910.f, 9920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9920.f,
				     9930.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9930.f, 9940.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9940.f, 9950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9950.f, 9960.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9960.f, 9970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9970.f,
				     9980.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9980.f, 9990.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9990.f, 1e4f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1e4f, 10010.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10010.f, 10020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10020.f,
				     10030.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10030.f, 10040.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10040.f, 10050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10050.f, 10060.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10060.f, 10070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10070.f,
				     10080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10080.f, 10090.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10090.f, 10100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10100.f,
				     10110.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10110.f, 10120.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10120.f, 10130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10130.f, 10140.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10140.f, 10150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10150.f,
				     10160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10160.f, 10170.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10170.f, 10180.f
    };

    /* carbon dioxide (7620 - 10170 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* dica3 */


void dica2 (double a[8], const long int inu)
{


    static const float acr[2048] = { .37011f, .18132f,
				     .0098385f, -4.992e-5f, .0096965f, -3.9497e-5f, 5060.f, 5070.f, 1.7202f,
				     .2316f, .0029954f, -2.2435e-5f, .0029757f, -9.2488e-6f, 5070.f, 5080.f,
				     3.3606f, .25416f, -.0016977f, -4.0846e-6f, -.0013656f, 1.1658e-5f,
				     5080.f, 5090.f, 1.8282f, .30223f, -.0032772f, 9.4805e-6f, -5.335e-4f,
				     2.1209e-5f, 5090.f, 5100.f, 2.9024f, .38026f, -.0030989f, 7.2616e-6f,
				     -.001377f, 1.615e-5f, 5100.f, 5110.f, 4.2563f, .41711f, -1.4453e-4f,
				     -8.0697e-6f, 4.2978e-4f, -2.7285e-6f, 5110.f, 5120.f, 1.1106f, .56558f,
				     .0071956f, -3.6594e-5f, .0079066f, -3.7847e-5f, 5120.f, 5130.f, .30634f,
				     .97715f, .015099f, -6.7211e-5f, .015152f, -6.5294e-5f, 5130.f, 5140.f,
				     .11213f, .77801f, .019757f, -8.6279e-5f, .020188f, -8.4289e-5f, 5140.f,
				     5150.f, .014584f, 1.0474f, .030585f, -1.2981e-4f, .030136f, -1.2999e-4f,
				     5150.f, 5160.f, .001482f, .96349f, .039762f, -1.6303e-4f, .039329f,
				     -1.6879e-4f, 5160.f, 5170.f, 7.185e-5f, .75521f, .050597f, -1.9183e-4f,
				     .049189f, -2.096e-4f, 5170.f, 5180.f, 2.9909e-5f, .14908f, .03608f,
				     -1.1815e-4f, .034793f, -1.453e-4f, 5180.f, 5190.f, 1.2504e-4f, .18326f,
				     .032726f, -1.4282e-4f, .029813f, -1.3805e-4f, 5190.f, 5200.f,
				     2.1512e-4f, .19978f, .02843f, -1.2662e-4f, .025525f, -1.2103e-4f,
				     5200.f, 5210.f, 9.6169e-5f, .20142f, .026447f, -1.1912e-4f, .023511f,
				     -1.1308e-4f, 5210.f, 5220.f, 1.9738e-4f, .21048f, .02716f, -1.2182e-4f,
				     .024213f, -1.1582e-4f, 5220.f, 5230.f, 2.6384e-4f, .44256f, .028679f,
				     -1.144e-4f, .024161f, -1.056e-4f, 5230.f, 5240.f, 3.6492e-4f, .82665f,
				     .01703f, -5.0383e-5f, .015395f, -5.7885e-5f, 5240.f, 5250.f, 1.5039e-4f,
				     .27488f, .013098f, -6.1988e-5f, .010623f, -5.4594e-5f, 5250.f, 5260.f,
				     2.4449e-4f, .45805f, .01877f, -8.2525e-5f, .016371f, -8.1515e-5f,
				     5260.f, 5270.f, 6.037e-5f, .43685f, .016157f, -6.0387e-5f, .013838f,
				     -6.3959e-5f, 5270.f, 5280.f, 4.5624e-4f, 1.0732f, .012236f, -4.3571e-5f,
				     .011139f, -5.5369e-5f, 5280.f, 5290.f, 9.4288e-4f, .71418f, .0033079f,
				     -9.3343e-6f, .0045345f, -2.5858e-5f, 5290.f, 5300.f, .0024083f, .75842f,
				     .0033829f, 4.6857e-7f, .0043964f, -1.9712e-5f, 5300.f, 5310.f, .011861f,
				     .7448f, -.0016809f, -1.8723e-6f, -.0036883f, 4.435e-6f, 5310.f, 5320.f,
				     .005669f, .26992f, -.0026897f, -1.9753e-6f, -.0056893f, 3.9128e-6f,
				     5320.f, 5330.f, .0043472f, .36618f, .0037666f, -2.1625e-5f, .0021182f,
				     -2.2907e-5f, 5330.f, 5340.f, 6.5931e-5f, .17111f, .021978f, -9.6238e-5f,
				     .020336f, -9.699e-5f, 5340.f, 5350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     5350.f,
				     5360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5360.f, 5370.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5370.f, 5380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5380.f, 5390.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5390.f, 5400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5400.f,
				     5410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5410.f, 5420.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5420.f, 5430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5430.f, 5440.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5440.f, 5450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5450.f,
				     5460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5460.f, 5470.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5470.f, 5480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5480.f, 5490.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5490.f, 5500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5500.f,
				     5510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5510.f, 5520.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5520.f, 5530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5530.f, 5540.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5540.f, 5550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5550.f,
				     5560.f, 6.8899e-6f, .12901f, .032092f, -1.4141e-4f, .029106f,
				     -1.3565e-4f, 5560.f, 5570.f, 5.4438e-6f, .10241f, .030061f, -1.3353e-4f,
				     .027225f, -1.2783e-4f, 5570.f, 5580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     5580.f,
				     5590.f, 1.3218e-5f, .23142f, .031168f, -1.3734e-4f, .028262f,
				     -1.3193e-4f, 5590.f, 5600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5600.f, 5610.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5610.f, 5620.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     5620.f, 5630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5630.f, 5640.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 5640.f, 5650.f, 3.3959e-6f, .061663f, .034194f,
				     -1.4999e-4f, .031058f, -1.438e-4f, 5650.f, 5660.f, 1.0828e-5f, .12604f,
				     .03117f, -1.3759e-4f, .028105f, -1.3178e-4f, 5660.f, 5670.f, 1.7083e-5f,
				     .16767f, .028148f, -1.2567e-4f, .025263f, -1.1999e-4f, 5670.f, 5680.f,
				     4.9699e-6f, .072931f, .026646f, -1.1993e-4f, .02372f, -1.1402e-4f,
				     5680.f, 5690.f, 3.2495e-5f, .33854f, .028198f, -1.2521e-4f, .025185f,
				     -1.1947e-4f, 5690.f, 5700.f, 8.5544e-6f, .12346f, .03299f, -1.4471e-4f,
				     .029937f, -1.3907e-4f, 5700.f, 5710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     5710.f,
				     5720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5720.f, 5730.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5730.f, 5740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5740.f, 5750.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5750.f, 5760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5760.f,
				     5770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5770.f, 5780.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5780.f, 5790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5790.f, 5800.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5800.f, 5810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5810.f,
				     5820.f, 1.0801e-7f, 6.4763e-4f, .00504f, -3.331e-5f, .0018319f,
				     -2.715e-5f, 5820.f, 5830.f, 3.6558e-7f, .0011712f, .0012766f,
				     -1.7918e-5f, -.0017271f, -1.2476e-5f, 5830.f, 5840.f, 6.5048e-7f,
				     .0015865f, -.0022804f, -3.9603e-6f, -.0050092f, 1.3558e-6f, 5840.f,
				     5850.f, 2.8928e-7f, .0011091f, -.0041564f, 3.1815e-6f, -.0071328f,
				     9.2288e-6f, 5850.f, 5860.f, 8.7451e-7f, .0023908f, -.003329f,
				     2.1406e-7f, -.0062303f, 6.1286e-6f, 5860.f, 5870.f, 6.7089e-7f,
				     .0021602f, .0012514f, -1.6242e-5f, -.0014507f, -1.275e-5f, 5870.f,
				     5880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5880.f, 5890.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5890.f, 5900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5900.f, 5910.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5910.f, 5920.f, 1.7501e-8f, 1.3034e-4f, .0051578f,
				     -3.4109e-5f, .0018735f, -2.7495e-5f, 5920.f, 5930.f, 6.9507e-7f,
				     .0034287f, 4.4624e-4f, -1.3702e-5f, -.0024553f, -8.9919e-6f, 5930.f,
				     5940.f, 7.8354e-7f, .0027679f, -.002211f, -4.0762e-6f, -.0050605f,
				     1.5266e-6f, 5940.f, 5950.f, 1.7028e-5f, .28847f, .029444f, -1.0994e-4f,
				     .027638f, -1.257e-4f, 5950.f, 5960.f, 1.43e-5f, .23307f, .025314f,
				     -6.3115e-5f, .025428f, -1.0758e-4f, 5960.f, 5970.f, 2.9931e-5f, .32693f,
				     .031262f, -1.0549e-4f, .030096f, -1.315e-4f, 5970.f, 5980.f, 1.6591e-4f,
				     .85547f, .027749f, -1.2007e-4f, .025471f, -1.1947e-4f, 5980.f, 5990.f,
				     4.2245e-4f, .43143f, .020385f, -9.2124e-5f, .018281f, -8.9908e-5f,
				     5990.f, 6e3f, 9.3274e-4f, .46433f, .015249f, -7.1885e-5f, .01312f,
				     -6.839e-5f, 6e3f, 6010.f, 7.0225e-4f, .54757f, .013086f, -5.8065e-5f,
				     .011855f, -5.6321e-5f, 6010.f, 6020.f, 6.928e-4f, .65125f, .013222f,
				     -5.6472e-5f, .011874f, -5.5027e-5f, 6020.f, 6030.f, .0015664f, .5897f,
				     .015019f, -7.1875e-5f, .012178f, -6.7231e-5f, 6030.f, 6040.f, .0038079f,
				     .38374f, .0089238f, -3.815e-5f, .0095406f, -4.6524e-5f, 6040.f, 6050.f,
				     .011401f, .22142f, .0011962f, -1.4969e-5f, 5.0672e-4f, -5.0173e-6f,
				     6050.f, 6060.f, .015986f, .20314f, -.0028719f, -1.5218e-6f, -.0057785f,
				     4.2132e-6f, 6060.f, 6070.f, .0065575f, .20869f, -.0045237f, 4.7582e-6f,
				     -.0074277f, 1.0726e-5f, 6070.f, 6080.f, .016542f, .20732f, -.0033062f,
				     1.2692e-7f, -.0062117f, 5.9729e-6f, 6080.f, 6090.f, .0148f, .21832f,
				     5.2489e-4f, -1.4021e-5f, -.002348f, -9.405e-6f, 6090.f, 6100.f,
				     .0037777f, .221f, .0079105f, -4.1125e-5f, .0056565f, -3.9694e-5f,
				     6100.f, 6110.f, 2.3785e-4f, .20223f, .019267f, -7.498e-5f, .018479f,
				     -8.4052e-5f, 6110.f, 6120.f, 8.7992e-6f, .013627f, .0023267f,
				     9.2669e-5f, .014502f, 8.1104e-5f, 6120.f, 6130.f, 4.6902e-5f, .41886f,
				     .0248f, 7.0996e-5f, .036122f, -1.3184e-4f, 6130.f, 6140.f, 1.7614e-4f,
				     .70325f, .034157f, -1.2548e-4f, .032692f, -1.4479e-4f, 6140.f, 6150.f,
				     5.1423e-4f, .765f, .030511f, -1.3248e-4f, .028126f, -1.2927e-4f, 6150.f,
				     6160.f, .0016425f, .80783f, .024399f, -1.0406e-4f, .023798f,
				     -1.0618e-4f, 6160.f, 6170.f, .0047297f, .7047f, .018441f, -8.1354e-5f,
				     .017633f, -8.284e-5f, 6170.f, 6180.f, .012112f, .7774f, .014404f,
				     -6.4815e-5f, .014093f, -6.4401e-5f, 6180.f, 6190.f, .029946f, .46202f,
				     .0077033f, -3.8421e-5f, .0091624f, -3.7333e-5f, 6190.f, 6200.f,
				     .084779f, .36412f, .0025097f, -1.7677e-5f, .0033111f, -1.9653e-5f,
				     6200.f, 6210.f, .14928f, .35083f, -.0016626f, 6.5627e-7f, -1.0556e-5f,
				     3.0708e-6f, 6210.f, 6220.f, .055916f, .2564f, -.0037859f, 9.6465e-6f,
				     -4.846e-4f, 2.9685e-5f, 6220.f, 6230.f, .14147f, .24788f, -.0037163f,
				     1.7896e-6f, -.006379f, 1.0289e-5f, 6230.f, 6240.f, .16605f, .27773f,
				     3.1594e-4f, -1.2404e-5f, -.0024142f, -8.6644e-6f, 6240.f, 6250.f,
				     .026015f, .2642f, .0096177f, -4.5715e-5f, .0081902f, -4.718e-5f, 6250.f,
				     6260.f, 3.4429e-4f, .24315f, .027429f, -1.0196e-4f, .028346f,
				     -1.1603e-4f, 6260.f, 6270.f, 4.6627e-5f, .19149f, .036426f, -1.3678e-4f,
				     .034831f, -1.5131e-4f, 6270.f, 6280.f, 2.1373e-4f, .25683f, .031955f,
				     -1.3913e-4f, .029335f, -1.3555e-4f, 6280.f, 6290.f, .0013513f, .24863f,
				     .022352f, -9.6861e-5f, .021515f, -9.9991e-5f, 6290.f, 6300.f, .0054489f,
				     .20135f, .014377f, -6.5562e-5f, .015352f, -6.4813e-5f, 6300.f, 6310.f,
				     .027679f, .22784f, .0074243f, -3.7863e-5f, .0085371f, -3.3611e-5f,
				     6310.f, 6320.f, .078593f, .25925f, .0020493f, -1.5599e-5f, .0043199f,
				     -6.7814e-6f, 6320.f, 6330.f, .14691f, .31965f, -.0018417f, -2.6752e-7f,
				     -4.3593e-4f, 7.2456e-6f, 6330.f, 6340.f, .060904f, .38372f, -.0026072f,
				     1.0806e-5f, 3.4105e-5f, 6.1858e-6f, 6340.f, 6350.f, .16958f, .41812f,
				     -.0032411f, 1.9629e-6f, -.0029726f, 8.5775e-6f, 6350.f, 6360.f, .14604f,
				     .4663f, .0014212f, -1.3457e-5f, .0019636f, -1.361e-5f, 6360.f, 6370.f,
				     .031358f, .68476f, .010997f, -4.6694e-5f, .011746f, -5.4252e-5f, 6370.f,
				     6380.f, .0010642f, .83438f, .027721f, -1.1549e-4f, .027342f,
				     -1.2081e-4f, 6380.f, 6390.f, 1.0993e-5f, .084985f, .011868f, 1.2012e-4f,
				     .014373f, 3.5831e-5f, 6390.f, 6400.f, 6.8548e-5f, .19065f, -1.396e-4f,
				     -1.1926e-5f, -.0033005f, -5.8719e-6f, 6400.f, 6410.f, 5.8606e-5f,
				     .18176f, .0053969f, -3.2912e-5f, .0024598f, -2.8413e-5f, 6410.f, 6420.f,
				     1.3107e-5f, .089518f, .011918f, -6.0253e-5f, .0088864f, -5.4787e-5f,
				     6420.f, 6430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6430.f, 6440.f, 1.17e-5f,
				     .080752f, .030987f, -1.3581e-4f, .028483f, -1.3216e-4f, 6440.f, 6450.f,
				     1.5147e-4f, .133f, .021388f, -9.5943e-5f, .019129f, -9.4039e-5f, 6450.f,
				     6460.f, .0010569f, .14161f, .012722f, -6.2067e-5f, .010104f,
				     -5.8766e-5f, 6460.f, 6470.f, .0062046f, .17678f, .0050148f, -3.1545e-5f,
				     .002256f, -2.7623e-5f, 6470.f, 6480.f, .012909f, .15821f, -1.1368e-4f,
				     -1.2254e-5f, -.0031262f, -6.7108e-6f, 6480.f, 6490.f, .018519f, .26278f,
				     -.0033124f, 1.2436e-6f, -.0049708f, 1.187e-5f, 6490.f, 6500.f,
				     .0094276f, .28543f, -.0037172f, 9.5584e-6f, -.0028297f, 1.7915e-5f,
				     6500.f, 6510.f, .02326f, .34557f, -.0016092f, -1.5397e-6f, -.0015497f,
				     2.6953e-6f, 6510.f, 6520.f, .011602f, .45777f, .0040857f, -2.3186e-5f,
				     .003463f, -2.4006e-5f, 6520.f, 6530.f, .0026251f, 1.0461f, .0096811f,
				     -3.5495e-5f, .0054387f, -2.7418e-5f, 6530.f, 6540.f, .0013999f, .87933f,
				     .011802f, -4.3414e-5f, .0093028f, -3.5381e-5f, 6540.f, 6550.f,
				     .0010684f, .70255f, .015871f, -6.462e-5f, .012638f, -5.6493e-5f, 6550.f,
				     6560.f, 1.6155e-4f, .42392f, .025507f, -1.1133e-4f, .023436f,
				     -1.1063e-4f, 6560.f, 6570.f, 1.8042e-5f, .32854f, .030046f, -1.3213e-4f,
				     .02717f, -1.2714e-4f, 6570.f, 6580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     6580.f,
				     6590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6590.f, 6600.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6600.f, 6610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6610.f, 6620.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6620.f, 6630.f, 1.6128e-5f, .088896f, .01184f,
				     -5.9958e-5f, .0088458f, -5.4627e-5f, 6630.f, 6640.f, 5.7685e-5f, .1197f,
				     .0066894f, -3.9133e-5f, .0037276f, -3.4034e-5f, 6640.f, 6650.f,
				     1.6743e-4f, .15492f, .0016277f, -1.8979e-5f, -.0013919f, -1.3601e-5f,
				     6650.f, 6660.f, 2.3995e-4f, .19763f, -.0015517f, -2.5448e-6f,
				     -.0034273f, 4.3033e-7f, 6660.f, 6670.f, .0011561f, .75988f, -.001204f,
				     -2.7363e-6f, -.0037117f, -3.8924e-7f, 6670.f, 6680.f, 2.3092e-4f,
				     .26967f, -.0038326f, 2.1748e-6f, -.0067421f, 8.1124e-6f, 6680.f, 6690.f,
				     1.8913e-4f, .29419f, 2.3018e-4f, -1.1781e-5f, -.0022434f, -9.0419e-6f,
				     6690.f, 6700.f, 4.262e-6f, .033197f, .008741f, -4.0921e-5f, .0057336f,
				     -3.8266e-5f, 6700.f, 6710.f, 9.8135e-7f, .0038989f, .019411f,
				     -9.0203e-5f, .01638f, -8.4877e-5f, 6710.f, 6720.f, 2.4238e-6f,
				     .0042762f, .015022f, -7.3077e-5f, .01219f, -6.7965e-5f, 6720.f, 6730.f,
				     4.5088e-6f, .0043488f, .010996f, -5.6685e-5f, .0085436f, -5.3188e-5f,
				     6730.f, 6740.f, 1.0584e-5f, .0026967f, .0057298f, -3.4851e-5f,
				     .0039372f, -3.384e-5f, 6740.f, 6750.f, 2.4861e-5f, .0051111f, .0029099f,
				     -1.5549e-5f, .0043761f, -2.6982e-5f, 6750.f, 6760.f, 3.9077e-5f,
				     .0028826f, -.001771f, -1.6701e-6f, -.001197f, 3.3e-6f, 6760.f, 6770.f,
				     2.3656e-5f, .0021453f, -.004179f, 3.1183e-6f, -.0071966f, 9.311e-6f,
				     6770.f, 6780.f, 4.577e-5f, .0032492f, -.003795f, 1.7261e-6f, -.006782f,
				     7.9425e-6f, 6780.f, 6790.f, 6.1088e-5f, .0055679f, .001493f,
				     -1.1871e-5f, 7.2114e-4f, -1.3903e-5f, 6790.f, 6800.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 0.f, 6800.f, 6810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6810.f, 6820.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 6820.f, 6830.f, 9.2277e-7f, .029726f, .049361f,
				     -2.108e-4f, .046239f, -2.0451e-4f, 6830.f, 6840.f, 1.4134e-5f, .25624f,
				     .046651f, -1.979e-4f, .043955f, -1.9411e-4f, 6840.f, 6850.f, 7.2012e-5f,
				     .62577f, .042787f, -1.8123e-4f, .0404f, -1.7929e-4f, 6850.f, 6860.f,
				     1.8633e-4f, .5831f, .038378f, -1.6303e-4f, .035924f, -1.6051e-4f,
				     6860.f, 6870.f, 5.7256e-4f, .7495f, .03396f, -1.4641e-4f, .03134f,
				     -1.4291e-4f, 6870.f, 6880.f, .0014919f, .79461f, .029669f, -1.2898e-4f,
				     .027598f, -1.2671e-4f, 6880.f, 6890.f, .003259f, .69112f, .02466f,
				     -1.0873e-4f, .022993f, -1.093e-4f, 6890.f, 6900.f, .0079821f, .66219f,
				     .020779f, -9.1999e-5f, .020053f, -9.48e-5f, 6900.f, 6910.f, .019955f,
				     .70298f, .016653f, -7.4032e-5f, .017622f, -7.4061e-5f, 6910.f, 6920.f,
				     .047678f, .44625f, .011512f, -5.6613e-5f, .010983f, -5.0893e-5f, 6920.f,
				     6930.f, .072667f, .31454f, .0067346f, -3.8595e-5f, .0058565f,
				     -4.0764e-5f, 6930.f, 6940.f, .21391f, .45263f, .0039143f, -1.9313e-5f,
				     .0056575f, -2.8872e-5f, 6940.f, 6950.f, .3773f, .2493f, -.0011236f,
				     -3.7053e-6f, 4.1967e-4f, 5.3393e-6f, 6950.f, 6960.f, .29585f, .17647f,
				     -.0038687f, 2.2126e-6f, -.0068173f, 8.2438e-6f, 6960.f, 6970.f, .30531f,
				     .23118f, -.004195f, 3.5322e-6f, -.0069672f, 1.113e-5f, 6970.f, 6980.f,
				     .77834f, .54008f, 5.3815e-4f, -7.5276e-6f, -1.0156e-4f, -7.935e-6f,
				     6980.f, 6990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6990.f, 7e3f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 7e3f, 7010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7010.f, 7020.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7020.f, 7030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7030.f,
				     7040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7040.f, 7050.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7050.f, 7060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7060.f, 7070.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7070.f, 7080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7080.f,
				     7090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7090.f, 7100.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7100.f, 7110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7110.f, 7120.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7120.f, 7130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7130.f,
				     7140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7140.f, 7150.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,

				     0.f, 7150.f, 7160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7160.f, 7170.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7170.f, 7180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7180.f,
				     7190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7190.f, 7200.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7200.f, 7210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7210.f, 7220.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7220.f, 7230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7230.f,
				     7240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7240.f, 7250.f, 9.7362e-6f,
				     .061285f,
				     .004498f, -3.1185e-5f, .0013664f, -2.5022e-5f, 7250.f, 7260.f,
				     5.4706e-5f, .18852f, 2.4251e-4f, -1.332e-5f, -.0027302f, -8.1259e-6f,
				     7260.f, 7270.f, 6.1563e-5f, .20629f, -.0032814f, 2.2e-8f, -.0062079f,
				     5.925e-6f, 7270.f, 7280.f, 1.4699e-5f, .075241f, -.0044219f, 4.3348e-6f,
				     -.0074089f, 1.0364e-5f, 7280.f, 7290.f, 7.0542e-5f, .20329f, -.002882f,
				     -1.4802e-6f, -.0057837f, 4.2344e-6f, 7290.f, 7300.f, 5.4492e-5f,
				     .21457f, .0013783f, -1.721e-5f, -.0014841f, -1.2786e-5f, 7300.f, 7310.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7310.f, 7320.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7320.f, 7330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7330.f, 7340.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7340.f, 7350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7350.f,
				     7360.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7360.f, 7370.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7370.f, 7380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7380.f, 7390.f, 4.0391e-5f,
				     .34559f, .016271f, -7.7571e-5f, .013286f, -7.2256e-5f, 7390.f, 7400.f,
				     4.8302e-5f, .37526f, .012898f, -6.4691e-5f, .010001f, -5.8901e-5f,
				     7400.f, 7410.f, 2.6773e-5f, .14702f, .016569f, -7.6331e-5f, .013558f,
				     -7.16e-5f, 7410.f, 7420.f, 2.0816e-4f, .52374f, .010994f, -5.4458e-5f,
				     .0090105f, -5.4076e-5f, 7420.f, 7430.f, 4.8129e-4f, .23329f, .0042161f,
				     -2.5147e-5f, .0034174f, -2.5567e-5f, 7430.f, 7440.f, .0010907f, .19364f,
				     -.0012077f, -7.8171e-6f, -.0041544f, -2.4136e-6f, 7440.f, 7450.f,
				     7.8191e-4f, .2075f, -.0039131f, 2.4015e-6f, -.0069105f, 8.5956e-6f,
				     7450.f, 7460.f, 7.115e-4f, .19688f, -.0041668f, 3.3692e-6f, -.0070951f,
				     9.4003e-6f, 7460.f, 7470.f, .0014863f, .25817f, -.0012495f, -7.1361e-6f,
				     -.0041323f, -2.2309e-6f, 7470.f, 7480.f, 4.7705e-4f, .2487f, .005832f,
				     -3.2625e-5f, .0036125f, -3.1486e-5f, 7480.f, 7490.f, 2.3552e-5f,
				     .11333f, .017332f, -8.0926e-5f, .014655f, -7.7124e-5f, 7490.f, 7500.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7500.f, 7510.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7510.f, 7520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7520.f, 7530.f, 7.1378e-6f,
				     .057272f, .023828f, -1.0818e-4f, .020923f, -1.0279e-4f, 7530.f, 7540.f,
				     5.5634e-5f, .11302f, .017308f, -8.0844e-5f, .014641f, -7.7072e-5f,
				     7540.f, 7550.f, 3.874e-4f, .29038f, .010833f, -4.9887e-5f, .010414f,
				     -5.4606e-5f, 7550.f, 7560.f, 9.6863e-4f, .27281f, .0053932f,
				     -2.8655e-5f, .0052931f, -3.3358e-5f, 7560.f, 7570.f, .0023248f, .26964f,
				     4.149e-4f, -1.1296e-5f, -6.0618e-5f, -1.1765e-5f, 7570.f, 7580.f,
				     .0029909f, .2796f, -.0030237f, 8.4962e-7f, -.0041122f, 3.9569e-6f,
				     7580.f, 7590.f, .001504f, .43911f, -.0026031f, 1.2211e-5f, -.0012549f,
				     4.2399e-6f, 7590.f, 7600.f, .004448f, .35168f, -.0020068f, -1.1923e-6f,
				     -.0024644f, 4.0855e-6f, 7600.f, 7610.f, .0020548f, .3146f, .0041619f,
				     -2.4632e-5f, .0023465f, -2.5042e-5f, 7610.f, 7620.f
    };

    /* carbon dioxide (5060 - 7610 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* dica2 */


void dica1 (double a[8], const long int inu)
{



    static const float acr[2048] = { 1.1446e-5f, .0020117f,
				     -.0041334f, 3.2304e-6f, -.0069982f, 9.0084e-6f, 2500.f, 2510.f,
				     1.9234e-5f, .0019311f, -.0017326f, -5.8646e-6f, -.0045311f,
				     -6.0352e-7f, 2510.f, 2520.f, 9.202e-6f, .0017952f, .0034861f,
				     -2.526e-5f, 5.8777e-4f, -2.0915e-5f, 2520.f, 2530.f, 1.6374e-6f,
				     .0018281f, .010418f, -4.3535e-5f, .0074404f, -4.1207e-5f, 2530.f,
				     2540.f, 1.9079e-7f, .0010034f, .011048f, -9.739e-6f, .010458f,

				     -3.7165e-5f, 2540.f, 2550.f, 3.4315e-9f, 2.4238e-5f, .0054443f,
				     -3.5215e-5f, .00216f, -2.8602e-5f, 2550.f, 2560.f, 8.2488e-9f,
				     1.2211e-4f, .026474f, -1.1937e-4f, .023595f, -1.1358e-4f, 2560.f,
				     2570.f, 6.4587e-7f, .0014539f, .017175f, -7.7312e-5f, .015125f,
				     -7.6621e-5f, 2570.f, 2580.f, 5.4268e-6f, .0015777f, .0078126f,
				     -4.2151e-5f, .0051843f, -3.9096e-5f, 2580.f, 2590.f, 2.0993e-5f,
				     .0024666f, .0015156f, -1.4469e-5f, .0014551f, -1.2874e-5f, 2590.f,
				     2600.f, 3.1892e-5f, .0032261f, -.0024271f, 1.4275e-6f, -.0024514f,
				     2.5977e-6f, 2600.f, 2610.f, 1.1919e-5f, .0029607f, -.0037722f,
				     7.2919e-6f, -.004064f, 7.442e-6f, 2610.f, 2620.f, 3.5396e-5f, .0031915f,
				     -.0024421f, -5.4413e-7f, -.0029857f, 7.7772e-7f, 2620.f, 2630.f,
				     2.2174e-5f, .0031839f, .002243f, -1.6625e-5f, .0017446f, -1.7477e-5f,
				     2630.f, 2640.f, 4.9654e-6f, .0031706f, .0096026f, -4.1529e-5f,
				     .0087311f, -4.451e-5f, 2640.f, 2650.f, 5.9768e-7f, .0013719f, .0076702f,
				     1.3005e-5f, .0090078f, -2.4905e-5f, 2650.f, 2660.f, 1.3394e-7f,
				     3.2465e-4f, .0037114f, -2.6108e-5f, 9.3326e-4f, -2.2404e-5f, 2660.f,
				     2670.f, 9.101e-9f, 7.1741e-5f, .010072f, -5.3553e-5f, .0068917f,
				     -4.7305e-5f, 2670.f, 2680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2680.f, 2690.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2690.f, 2700.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     2700.f, 2710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2710.f, 2720.f, 3.0498e-7f,
				     .0012211f, .011385f, -5.7015e-5f, .008676f, -5.3344e-5f, 2720.f, 2730.f,
				     2.3044e-6f, .0018735f, .0031625f, -2.3857e-5f, 4.2583e-4f, -2.0332e-5f,
				     2730.f, 2740.f, 4.587e-6f, .0020082f, -.0021166f, -4.3444e-6f,
				     -.0048776f, 8.714e-7f, 2740.f, 2750.f, 1.8151e-6f, .001778f, -.0043591f,
				     3.9928e-6f, -.0074161f, 1.0271e-5f, 2750.f, 2760.f, 4.3155e-6f,
				     .0021845f, -.0035667f, 1.0325e-6f, -.0064484f, 6.9079e-6f, 2760.f,
				     2770.f, 3.5601e-6f, .0015853f, -2.4397e-4f, -1.1623e-5f, -.0030932f,
				     -6.6664e-6f, 2770.f, 2780.f, 1.4023e-6f, .0017421f, .0052527f,
				     -3.1584e-5f, .0022672f, -2.6978e-5f, 2780.f, 2790.f, 1.9517e-7f,
				     .0010843f, .011752f, -5.0614e-5f, .0090578f, -5.0929e-5f, 2790.f,
				     2800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2800.f, 2810.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2810.f, 2820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2820.f, 2830.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2830.f, 2840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2840.f,
				     2850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2850.f, 2860.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2860.f, 2870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2870.f, 2880.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2880.f, 2890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2890.f,
				     2900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2900.f, 2910.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2910.f, 2920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2920.f, 2930.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2930.f, 2940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2940.f,
				     2950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2950.f, 2960.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2960.f, 2970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2970.f, 2980.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2980.f, 2990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2990.f,
				     3e3f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3e3f, 3010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     3010.f, 3020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3020.f, 3030.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3030.f, 3040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3040.f,
				     3050.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3050.f, 3060.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3060.f, 3070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3070.f, 3080.f, 3.3052e-6f,
				     .058651f, .034989f, -1.529e-4f, .031987f, -1.4721e-4f, 3080.f, 3090.f,
				     4.1503e-5f, .20207f, .026206f, -1.1436e-4f, .023672f, -1.1213e-4f,
				     3090.f, 3100.f, 8.7906e-5f, .21783f, .018422f, -8.5123e-5f, .015304f,
				     -7.985e-5f, 3100.f, 3110.f, 2.9489e-5f, .12859f, .014066f, -6.9404e-5f,
				     .011044f, -6.3254e-5f, 3110.f, 3120.f, 3.1118e-5f, .2981f, .025033f,
				     -1.1155e-4f, .022143f, -1.0719e-4f, 3120.f, 3130.f, 1.4832e-4f, .7106f,
				     .018309f, -7.0285e-5f, .015857f, -7.3742e-5f, 3130.f, 3140.f,
				     5.0912e-4f, .39631f, .016927f, -7.7076e-5f, .014306f, -7.4481e-5f,
				     3140.f, 3150.f, .0018569f, .28375f, .0076498f, -3.6249e-5f, .0067089f,
				     -3.6791e-5f, 3150.f, 3160.f, .0023217f, .3497f, .0010351f, -1.0688e-5f,
				     9.4905e-4f, -6.7349e-6f, 3160.f, 3170.f, 4.761e-4f, .41947f, .0019347f,
				     1.6317e-5f, .0033594f, -7.9441e-6f, 3170.f, 3180.f, 4.6778e-4f, .77616f,
				     7.9129e-4f, 2.3675e-5f, 9.1006e-4f, 4.8023e-6f, 3180.f, 3190.f,
				     .0030862f, .25667f, -.0014396f, -4.1338e-6f, -.0027351f, 6.4924e-6f,
				     3190.f, 3200.f, .0034062f, .18499f, .003259f, -2.4779e-5f, 2.1425e-4f,
				     -1.9664e-5f, 3200.f, 3210.f, .0014366f, .17452f, .010436f, -5.221e-5f,
				     .0077713f, -4.9107e-5f, 3210.f, 3220.f, 2.6116e-4f, .16068f, .020114f,
				     -8.9663e-5f, .017964f, -8.8666e-5f, 3220.f, 3230.f, 3.408e-5f, .26237f,
				     .031854f, -1.3724e-4f, .029565f, -1.3533e-4f, 3230.f, 3240.f,
				     3.8044e-5f, .18154f, .023462f, -1.0477e-4f, .020484f, -1.0031e-4f,
				     3240.f, 3250.f, 2.3642e-5f, .12587f, .01793f, -8.3993e-5f, .014725f,
				     -7.8063e-5f, 3250.f, 3260.f, 1.3555e-6f, .0021856f, .0043607f,
				     -2.9254e-5f, .0012372f, -2.4119e-5f, 3260.f, 3270.f, 3.5631e-4f,
				     .86373f, .015491f, -6.0741e-5f, .014051f, -6.1126e-5f, 3270.f, 3280.f,
				     3.3068e-4f, .41597f, .01708f, -4.5243e-5f, .018249f, -6.1327e-5f,
				     3280.f, 3290.f, .001398f, .43415f, .020779f, -8.71e-5f, .019046f,
				     -8.4016e-5f, 3290.f, 3300.f, .0054038f, .37316f, .013012f, -5.4513e-5f,
				     .014582f, -6.1135e-5f, 3300.f, 3310.f, .011865f, .37215f, .005333f,
				     -2.4891e-5f, .0077872f, -2.3154e-5f, 3310.f, 3320.f, .0081717f, .45864f,
				     7.0369e-4f, -2.5399e-6f, .0032045f, -2.1463e-6f, 3320.f, 3330.f,
				     .0067313f, .55963f, -.0020245f, 2.6702e-6f, -.0024299f, 1.777e-5f,
				     3330.f, 3340.f, .013254f, .74729f, -.001815f, 5.4501e-6f, .0013181f,
				     -4.3636e-7f, 3340.f, 3350.f, .036823f, .36421f, -2.01e-4f, -5.8593e-6f,
				     .0013324f, -2.3987e-6f, 3350.f, 3360.f, .035439f, .40306f, .0054434f,
				     -2.6546e-5f, .0067677f, -2.8288e-5f, 3360.f, 3370.f, .0090957f, .48115f,
				     .014512f, -6.1088e-5f, .016771f, -6.5673e-5f, 3370.f, 3380.f, .0015199f,
				     .65754f, .023451f, -8.6e-5f, .024073f, -8.9238e-5f, 3380.f, 3390.f,
				     1.3838e-4f, .96599f, .027438f, -3.7378e-5f, .026069f, -7.2896e-5f,
				     3390.f, 3400.f, 3.1321e-4f, .32432f, .014691f, -4.5546e-5f, .01786f,
				     -4.056e-5f, 3400.f, 3410.f, 9.6318e-4f, .34642f, .017708f, -6.6986e-5f,
				     .020408f, -5.3348e-5f, 3410.f, 3420.f, 6.1782e-4f, .30724f, .02599f,
				     -8.9579e-5f, .025999f, -9.8228e-5f, 3420.f, 3430.f, 4.0506e-4f, .30755f,
				     .038698f, -1.6162e-4f, .035406f, -1.5721e-4f, 3430.f, 3440.f, .0011183f,
				     .2365f, .034497f, -1.4952e-4f, .032465f, -1.4642e-4f, 3440.f, 3450.f,
				     .0018653f, .34796f, .029814f, -1.2999e-4f, .026883f, -1.245e-4f, 3450.f,
				     3460.f, .0035542f, .40556f, .017369f, -5.7102e-5f, .019546f,
				     -4.6731e-5f, 3460.f, 3470.f, .0090605f, .50199f, .012281f, 2.333e-7f,
				     .01992f, 2.7162e-5f, 3470.f, 3480.f, .008421f, .7135f, .011986f,
				     7.348e-5f, .024636f, 8.1574e-5f, 3480.f, 3490.f, .0060886f, .9612f,
				     .023574f, 1.0867e-4f, .044783f, -7.2014e-5f, 3490.f, 3500.f, .035622f,
				     1.6535f, .012077f, 1.3532e-4f, .02212f, 8.0854e-5f, 3500.f, 3510.f,
				     .078238f, 1.3688f, .016785f, 1.4511e-4f, .032327f, -1.2296e-5f, 3510.f,
				     3520.f, .17292f, 1.6314f, .028411f, -4.0866e-6f, .033279f, -8.391e-5f,
				     3520.f, 3530.f, .58094f, 1.4177f, .030478f, -9.228e-5f, .032074f,
				     -1.1676e-4f, 3530.f, 3540.f, 1.9973f, 1.0662f, .026332f, -1.0563e-4f,
				     .027668f, -1.086e-4f, 3540.f, 3550.f, 5.8904f, .85364f, .020626f,
				     -8.7922e-5f, .022034f, -8.7919e-5f, 3550.f, 3560.f, 16.608f, .82681f,
				     .016296f, -7.197e-5f, .016508f, -6.8914e-5f, 3560.f, 3570.f, 33.94f,
				     .67293f, .011756f, -5.5546e-5f, .012667f, -5.0727e-5f, 3570.f, 3580.f,
				     105.89f, .40519f, .0053354f, -3.05e-5f, .00642f, -2.7269e-5f, 3580.f,
				     3590.f, 286.58f, .37875f, 3.1591e-4f, -7.6033e-6f, .0017571f,
				     -6.9331e-6f, 3590.f, 3600.f, 258.81f, .31632f, -.0031299f, 5.3577e-6f,
				     -.0014554f, 1.6811e-5f, 3600.f, 3610.f, 153.98f, .23899f, -.0042487f,
				     5.6295e-6f, -.0038259f, 2.864e-5f, 3610.f, 3620.f, 381.54f, .2369f,
				     -.0021079f, -4.2102e-6f, -.0046108f, 4.6494e-6f, 3620.f, 3630.f,
				     189.08f, .24104f, .003487f, -2.4525e-5f, .0012111f, -1.869e-5f, 3630.f,
				     3640.f, 22.631f, .27596f, .013843f, -6.0817e-5f, .013983f, -5.5436e-5f,
				     3640.f, 3650.f, .789f, .45834f, .0288f, -9.2261e-5f, .033526f,
				     -1.1634e-4f, 3650.f, 3660.f, 3.5516f, .24747f, .021606f, -9.1483e-5f,
				     .025091f, -7.7825e-5f, 3660.f, 3670.f, 26.382f, .26344f, .013128f,
				     -5.9351e-5f, .015813f, -4.5315e-5f, 3670.f, 3680.f, 114.51f, .25517f,
				     .0061726f, -3.2903e-5f, .0088361f, -1.856e-5f, 3680.f, 3690.f, 375.87f,
				     .29958f, 6.1303e-4f, -1.0823e-5f, .0025691f, 2.5921e-6f, 3690.f, 3700.f,
				     399.12f, .32406f, -.0024055f, 3.4271e-6f, 8.3356e-4f, 1.4624e-5f,
				     3700.f, 3710.f, 209.7f, .49024f, -.0029825f, 1.1251e-5f, 9.8088e-4f,
				     1.7825e-5f, 3710.f, 3720.f, 651.86f, .43325f, -.0025584f, -7.4576e-7f,
				     -.0013717f, 1.1441e-5f, 3720.f, 3730.f, 360.94f, .49364f, .0033219f,
				     -1.9819e-5f, .0045993f, -1.8704e-5f, 3730.f, 3740.f, 57.048f, .71411f,
				     .013964f, -5.8323e-5f, .015441f, -6.5072e-5f, 3740.f, 3750.f, 1.6419f,
				     .94961f, .031167f, -1.2796e-4f, .03253f, -1.3294e-4f, 3750.f, 3760.f,
				     .0072097f, .71242f, .053044f, -2.1219e-4f, .055695f, -2.2364e-4f,
				     3760.f, 3770.f, 3.2929e-4f, .16488f, .043688f, -1.8453e-4f, .042346f,
				     -1.8165e-4f, 3770.f, 3780.f, .0014501f, .17127f, .036748f, -1.5788e-4f,
				     .035331f, -1.524e-4f, 3780.f, 3790.f, .0047585f, .19488f, .031054f,
				     -1.364e-4f, .028516f, -1.3041e-4f, 3790.f, 3800.f, .0056312f, .2178f,
				     .027563f, -1.2299e-4f, .02536f, -1.1514e-4f, 3800.f, 3810.f, .0025663f,
				     .23975f, .026455f, -1.1697e-4f, .025771f, -1.0379e-4f, 3810.f, 3820.f,
				     .0073473f, .2611f, .028264f, -1.2512e-4f, .026543f, -1.1735e-4f, 3820.f,
				     3830.f, .0041625f, .3064f, .0335f, -1.4328e-4f, .032396f, -1.4197e-4f,
				     3830.f, 3840.f, 6.2707e-4f, .49963f, .042723f, -1.7265e-4f, .041198f,
				     -1.7864e-4f, 3840.f, 3850.f, 5.2281e-5f, .443f, .041789f, -1.3546e-4f,
				     .041381f, -1.6812e-4f, 3850.f, 3860.f, 1.1349e-4f, .48522f, .040194f,
				     -1.3982e-4f, .03909f, -1.6958e-4f, 3860.f, 3870.f, 1.1733e-4f, .49615f,
				     .044541f, -1.6207e-4f, .043254f, -1.8688e-4f, 3870.f, 3880.f,
				     2.1994e-5f, .36694f, .051435f, -1.7841e-4f, .051058f, -2.162e-4f,
				     3880.f, 3890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3890.f, 3900.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3900.f, 3910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3910.f,
				     3920.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3920.f, 3930.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3930.f, 3940.f, 1.0712e-5f, .11242f, .038222f, -1.6405e-4f, .035612f,
				     -1.6058e-4f, 3940.f, 3950.f, 2.226e-5f, .088337f, .032098f, -1.4078e-4f,
				     .029142f, -1.356e-4f, 3950.f, 3960.f, 6.0145e-5f, .1215f, .02614f,
				     -1.1441e-4f, .023109f, -1.101e-4f, 3960.f, 3970.f, 1.1812e-4f, .5338f,
				     .023839f, -9.6178e-5f, .023506f, -1.0676e-4f, 3970.f, 3980.f, 6.12e-5f,
				     .32611f, .020895f, -7.6119e-5f, .020369f, -8.7589e-5f, 3980.f, 3990.f,
				     3.019e-4f, .84191f, .024861f, -9.352e-5f, .024385f, -1.0546e-4f, 3990.f,
				     4e3f, .0013735f, .6758f, .014099f, -6.4565e-5f, .011933f, -5.7363e-5f,
				     4e3f, 4010.f, .0017095f, .28901f, .013726f, -6.7497e-5f, .010543f,
				     -6.096e-5f, 4010.f, 4020.f, .0020687f, .45821f, .021277f, -8.6802e-5f,
				     .020845f, -9.0012e-5f, 4020.f, 4030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     4030.f,

				     4040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4040.f, 4050.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4050.f, 4060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4060.f, 4070.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4070.f, 4080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4080.f,
				     4090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4090.f, 4100.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4100.f, 4110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4110.f, 4120.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4120.f, 4130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4130.f,
				     4140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4140.f, 4150.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4150.f, 4160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4160.f, 4170.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4170.f, 4180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4180.f,
				     4190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4190.f, 4200.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4200.f, 4210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4210.f, 4220.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4220.f, 4230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4230.f,
				     4240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4240.f, 4250.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4250.f, 4260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4260.f, 4270.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4270.f, 4280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4280.f,
				     4290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4290.f, 4300.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4300.f, 4310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4310.f, 4320.f, 0.f,
				     0.f,

				     0.f, 0.f, 0.f, 0.f, 4320.f, 4330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4330.f,
				     4340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4340.f, 4350.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4350.f, 4360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4360.f, 4370.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4370.f, 4380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4380.f,
				     4390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4390.f, 4400.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4400.f, 4410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4410.f, 4420.f,
				     2.629e-5f,
				     .099522f, -.0026652f, -2.6042e-6f, -.0055447f, 3.2186e-6f, 4420.f,
				     4430.f, 8.0883e-5f, .18978f, 5.7466e-4f, -1.4607e-5f, -.0025665f,
				     -8.7838e-6f, 4430.f, 4440.f, 5.526e-5f, .18005f, .0065537f, -3.7323e-5f,
				     .0036814f, -3.3174e-5f, 4440.f, 4450.f, 8.255e-6f, .05991f, .012867f,
				     -6.4515e-5f, .0097575f, -5.8512e-5f, 4450.f, 4460.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 0.f, 4460.f, 4470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4470.f, 4480.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 4480.f, 4490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     4490.f,
				     4500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4500.f, 4510.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4510.f, 4520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4520.f, 4530.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4530.f, 4540.f, 5.6586e-6f, .058006f, .021852f,
				     -1.003e-4f, .018901f, -9.4764e-5f, 4540.f, 4550.f, 6.0995e-5f, .17176f,
				     .013472f, -6.3857e-5f, .010919f, -6.1333e-5f, 4550.f, 4560.f,
				     1.6173e-4f, .1827f, .0055264f, -3.3401e-5f, .0025266f, -2.8677e-5f,
				     4560.f, 4570.f, 1.342e-4f, .18669f, 8.6662e-5f, -1.2871e-5f, -.0031886f,
				     -6.3395e-6f, 4570.f, 4580.f, 7.7677e-6f, .035973f, -.0017804f,
				     3.5792e-6f, -.004378f, 4.7097e-6f, 4580.f, 4590.f, 2.1446e-4f, .52918f,
				     -.0026414f, 1.9171e-8f, -.0051868f, 3.1486e-6f, 4590.f, 4600.f,
				     4.9732e-4f, .19678f, -.0015023f, -6.4944e-6f, -.0045248f, -6.0552e-7f,
				     4600.f, 4610.f, 5.7844e-4f, .21566f, .0036076f, -2.5498e-5f, 6.874e-4f,
				     -2.1166e-5f, 4610.f, 4620.f, 1.836e-4f, .19472f, .010909f, -4.5759e-5f,
				     .0094535f, -5.3705e-5f, 4620.f, 4630.f, 2.1722e-5f, .066168f, .010212f,
				     2.4083e-5f, .016411f, -6.7231e-5f, 4630.f, 4640.f, 1.5836e-5f,
				     .0025231f, -.0037387f, 1.6847e-6f, -.0066855f, 7.7758e-6f, 4640.f,
				     4650.f, 2.8194e-5f, .055835f, .011719f, 7.8341e-5f, .028162f,
				     -6.5915e-5f, 4650.f, 4660.f, 2.9246e-5f, .15846f, .033601f, -1.2318e-4f,
				     .031988f, -1.4227e-4f, 4660.f, 4670.f, 6.866e-5f, .23768f, .030956f,
				     -1.3481e-4f, .028087f, -1.3066e-4f, 4670.f, 4680.f, 2.5776e-5f, .14238f,
				     .026879f, -1.1219e-4f, .025142f, -1.1785e-4f, 4680.f, 4690.f,
				     6.7605e-5f, .28782f, .028103f, -9.7067e-5f, .028478f, -1.1197e-4f,
				     4690.f, 4700.f, 9.4449e-5f, .58934f, .03528f, -9.4266e-5f, .037047f,
				     -1.3314e-4f, 4700.f, 4710.f, 2.1985e-4f, .94207f, .026856f, 1.5457e-5f,
				     .034398f, -7.9603e-5f, 4710.f, 4720.f, 5.9268e-4f, .92654f, .019629f,
				     7.9413e-5f, .02922f, -3.244e-5f, 4720.f, 4730.f, .001207f, .99725f,
				     .019414f, 1.0014e-4f, .026778f, -2.2067e-5f, 4730.f, 4740.f, .0022806f,
				     1.2176f, .028561f, -2.1574e-5f, .030485f, -7.5567e-5f, 4740.f, 4750.f,
				     .0043327f, 1.3486f, .028595f, -6.6405e-5f, .027851f, -7.4726e-5f,
				     4750.f, 4760.f, .0077428f, 1.4486f, .030758f, -1.1612e-4f, .029991f,
				     -1.2747e-4f, 4760.f, 4770.f, .025636f, 1.0146f, .025412f, -1.0692e-4f,
				     .02508f, -1.0479e-4f, 4770.f, 4780.f, .071004f, .80049f, .019034f,
				     -8.2075e-5f, .019591f, -8.1415e-5f, 4780.f, 4790.f, .12168f, .79844f,
				     .014488f, -6.4424e-5f, .0152f, -5.8903e-5f, 4790.f, 4800.f, .076746f,
				     1.2201f, .015267f, -5.7662e-5f, .014334f, -5.5273e-5f, 4800.f, 4810.f,
				     .25656f, .72698f, .012794f, -6.0697e-5f, .011343f, -5.448e-5f, 4810.f,
				     4820.f, .71618f, .47943f, .0075299f, -3.4485e-5f, .0086269f,
				     -4.1288e-5f, 4820.f, 4830.f, 1.9439f, .28552f, 6.0337e-4f, -1.0585e-5f,
				     .0017705f, -3.3465e-6f, 4830.f, 4840.f, 2.2409f, .24124f, -.0032243f,
				     7.7209e-7f, -.0036357f, 1.7134e-5f, 4840.f, 4850.f, 1.023f, .23661f,
				     -.0044285f, 5.6593e-6f, -.0054571f, 1.8603e-5f, 4850.f, 4860.f, 2.9838f,
				     .24972f, -.0026005f, -2.2445e-6f, -.0048507f, 6.708e-6f, 4860.f, 4870.f,
				     1.7331f, .24569f, .002513f, -2.0912e-5f, 9.7879e-5f, -1.4658e-5f,
				     4870.f, 4880.f, .23009f, .24263f, .012134f, -5.5883e-5f, .011873f,
				     -4.6579e-5f, 4880.f, 4890.f, .0073766f, .50576f, .021012f, 1.3113e-5f,
				     .033128f, -7.4753e-5f, 4890.f, 4900.f, .0053301f, 1.1415f, .02315f,
				     8.1743e-5f, .032613f, -4.9011e-5f, 4900.f, 4910.f, .019881f, 1.1163f,
				     .030658f, -8.9121e-5f, .031493f, -1.049e-4f, 4910.f, 4920.f, .13274f,
				     .8018f, .023959f, -9.6864e-5f, .026465f, -1.057e-4f, 4920.f, 4930.f,
				     .54198f, .58029f, .016095f, -6.7361e-5f, .019209f, -7.4544e-5f, 4930.f,
				     4940.f, 2.3931f, .43634f, .0083244f, -3.8869e-5f, .01091f, -4.0486e-5f,
				     4940.f, 4950.f, 6.364f, .38463f, .0024225f, -1.7014e-5f, .0051156f,
				     -1.3677e-5f, 4950.f, 4960.f, 11.174f, .37051f, -.0020924f, -1.8861e-6f,
				     1.9797e-4f, 8.4038e-6f, 4960.f, 4970.f, 4.7425f, .4397f, -.0023967f,
				     1.1771e-5f, .0015888f, 1.1027e-5f, 4970.f, 4980.f, 13.215f, .42301f,

				     -.002886f, 4.5346e-6f, -.0018435f, 1.2941e-5f, 4980.f, 4990.f, 10.682f,
				     .28898f, 9.1279e-4f, -1.3741e-5f, 2.9048e-4f, -3.723e-6f, 4990.f, 5e3f,
				     1.9873f, .27401f, .0096347f, -4.5675e-5f, .0089294f, -4.3606e-5f, 5e3f,
				     5010.f, .025245f, .25842f, .027802f, -1.1266e-4f, .028517f, -1.1312e-4f,
				     5010.f, 5020.f, .0010773f, .39566f, .019467f, -9.0504e-6f, .021521f,
				     -4.662e-5f, 5020.f, 5030.f, .0026445f, .46517f, .022864f, -5.1981e-6f,
				     .021923f, -4.8242e-5f, 5030.f, 5040.f, .0089353f, .34218f, .025304f,
				     -8.7147e-5f, .020721f, -6.3342e-5f, 5040.f, 5050.f, .066176f, .21908f,
				     .017982f, -8.0841e-5f, .017736f, -7.414e-5f, 5050.f, 5060.f
    };

    /* carbon dioxide (2500 - 5050 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* dica1 */


void
ozon1 (double a[8], const long int inu)
{


    static const float acr[2048] = { .062007f, 2.4365f,
				     -5.9503e-4f, -8.1198e-6f, -.0039418f, -2.4624e-6f, 2500.f, 2510.f,
				     .023839f, 2.3534f, .0037377f, -6.15e-6f, .0015592f, -1.2727e-5f, 2510.f,
				     2520.f, .0090127f, 1.2172f, -.0014733f, -4.7053e-6f, -.0042092f,
				     -1.5909e-6f, 2520.f, 2530.f, .0058863f, 1.1f, 3.3397e-4f, -1.3388e-5f,
				     -.0024956f, -9.7955e-6f, 2530.f, 2540.f, .0021326f, .57054f, .0025704f,
				     -2.3597e-5f, -2.6961e-4f, -1.9566e-5f, 2540.f, 2550.f, 2.6378e-4f,
				     .095762f, .0021816f, -2.4506e-5f, -8.9441e-4f, -1.8362e-5f, 2550.f,
				     2560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2560.f, 2570.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2570.f, 2580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2580.f, 2590.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2590.f, 2600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2600.f,
				     2610.f, 1.2538e-4f, .06037f, .017057f, -8.3526e-5f, .013989f,
				     -7.7656e-5f, 2610.f, 2620.f, .0033172f, 1.2606f, .015787f, -6.9353e-5f,
				     .013123f, -6.8937e-5f, 2620.f, 2630.f, .008713f, 2.2667f, .014103f,
				     -5.7967e-5f, .011482f, -5.9919e-5f, 2630.f, 2640.f, .0172f, 3.144f,
				     .011768f, -4.8179e-5f, .0088246f, -4.9702e-5f, 2640.f, 2650.f, .034158f,
				     3.5816f, .0099884f, -4.184e-5f, .0074214f, -4.4219e-5f, 2650.f, 2660.f,
				     .058424f, 3.8732f, .0072077f, -3.3325e-5f, .004529f, -3.3709e-5f,
				     2660.f, 2670.f, .091154f, 4.3262f, .0058558f, -2.8338e-5f, .0036931f,
				     -2.8993e-5f, 2670.f, 2680.f, .14108f, 4.4142f, .0030363f, -1.8897e-5f,
				     8.3735e-4f, -1.8016e-5f, 2680.f, 2690.f, .19337f, 5.4007f, .0022914f,
				     -1.3229e-5f, 5.9045e-4f, -1.4091e-5f, 2690.f, 2700.f, .22397f, 5.654f,
				     4.0913e-4f, -5.5214e-8f, -4.337e-4f, -1.0921e-6f, 2700.f, 2710.f,
				     .25652f, 5.9001f, .0016172f, 5.8755e-6f, .0013629f, -1.6939e-6f, 2710.f,
				     2720.f, .26204f, 6.3198f, .0046886f, 1.25e-5f, .0044002f, -9.3401e-6f,
				     2720.f, 2730.f, 1.1785f, 7.1393f, .0037596f, -7.5943e-6f, .0028497f,
				     -1.6442e-5f, 2730.f, 2740.f, 1.2094f, 5.2539f, .0056671f, -2.7298e-5f,
				     .0028397f, -2.2464e-5f, 2740.f, 2750.f, 2.6976f, 4.6649f, .0025634f,
				     -2.0935e-5f, 3.1356e-4f, -1.7037e-5f, 2750.f, 2760.f, 5.2789f, 4.5914f,
				     -7.3997e-4f, -9.2529e-6f, -.0021265f, -8.3858e-6f, 2760.f, 2770.f,
				     5.611f, 6.1724f, -.0032253f, 2.5797e-6f, -.0028278f, 8.7898e-8f, 2770.f,
				     2780.f, 4.928f, 9.4156f, -.0020334f, 1.9294e-6f, -.0030249f, -1.069e-6f,
				     2780.f, 2790.f, 9.8978f, 7.256f, -.0024986f, -1.5096e-6f, -.0036608f,
				     -5.8064e-7f, 2790.f, 2800.f, 3.3206f, 9.3181f, .0047633f, -2.5074e-5f,
				     .0053638f, -3.2113e-5f, 2800.f, 2810.f, .02474f, 2.6388f, .0070889f,
				     -3.2967e-5f, .0046677f, -3.4491e-5f, 2810.f, 2820.f, .034545f, 2.9892f,
				     .0049198f, -2.638e-5f, .0026057f, -2.5038e-5f, 2820.f, 2830.f, .04698f,
				     4.234f, .0050308f, -1.5985e-5f, .0030829f, -2.1189e-5f, 2830.f, 2840.f,
				     .07243f, 5.0065f, .0059166f, -2.0703e-5f, .0028776f, -2.3414e-5f,
				     2840.f, 2850.f, .11034f, 4.0562f, .0040989f, -2.3368e-5f, 8.42e-4f,
				     -1.8356e-5f, 2850.f, 2860.f, .12579f, 3.6106f, .0011211f, -1.2332e-5f,
				     -8.604e-4f, -1.0593e-5f, 2860.f, 2870.f, .095405f, 4.2611f, .0010479f,
				     -5.3844e-6f, -6.5774e-4f, -8.3477e-6f, 2870.f, 2880.f, .092029f,
				     4.3877f, .0013349f, -8.8914e-6f, -8.978e-4f, -9.601e-6f, 2880.f, 2890.f,
				     .085314f, 2.2957f, -.0010376f, -3.9555e-7f, -.0023459f, -3.1759e-6f,
				     2890.f, 2900.f, .1913f, 2.1329f, 9.3145e-5f, -1.0935e-5f, -.0023306f,
				     -7.0411e-6f, 2900.f, 2910.f, .14327f, 3.0363f, .0049245f, -1.9969e-5f,
				     .0019913f, -1.9177e-5f, 2910.f, 2920.f, .062081f, 2.9232f, .0028349f,
				     4.5083e-6f, .0026887f, -6.9673e-6f, 2920.f, 2930.f, .054536f, 2.5833f,
				     .003389f, 5.9711e-6f, .0039633f, 1.706e-6f, 2930.f, 2940.f, .067558f,
				     4.1622f, .012948f, 1.8636e-5f, .013881f, -2.7246e-5f, 2940.f, 2950.f,
				     .10694f, 4.2481f, .019447f, -4.2948e-5f, .016908f, -6.0648e-5f, 2950.f,
				     2960.f, .23821f, 4.1323f, .020561f, -8.5072e-5f, .016888f, -7.7856e-5f,
				     2960.f, 2970.f, .64222f, 3.762f, .01732f, -8.1718e-5f, .014625f,
				     -7.652e-5f, 2970.f, 2980.f, 1.63f, 3.7899f, .013216f, -6.5623e-5f,
				     .011621f, -6.3803e-5f, 2980.f, 2990.f, 3.8611f, 4.0234f, .0091789f,
				     -4.9247e-5f, .0082148f, -4.8334e-5f, 2990.f, 3e3f, 8.4985f, 4.366f,
				     .0053518f, -3.3739e-5f, .0046322f, -3.3282e-5f, 3e3f, 3010.f, 16.437f,
				     4.6428f, .0018372f, -1.9254e-5f, .0014965f, -1.9554e-5f, 3010.f, 3020.f,
				     26.227f, 5.2685f, -.0010368f, -6.92e-6f, -.0010546f, -7.8474e-6f,
				     3020.f, 3030.f, 29.674f, 6.9683f, -.0027894f, 1.5655e-6f, -.0027673f,
				     3.4286e-7f, 3030.f, 3040.f, 24.306f, 9.5097f, -.002074f, 6.2838e-6f,
				     -.0020776f, 2.179e-6f, 3040.f, 3050.f, 63.521f, 9.8031f, -.0012075f,

				     -2.994e-6f, -.0022793f, -5.3779e-6f, 3050.f, 3060.f, 1.1941f, 5.4609f,
				     .0015524f, -9.5161e-6f, -9.6618e-4f, -7.6711e-6f, 3060.f, 3070.f,
				     .92867f, 5.355f, -6.2368e-4f, -3.643e-6f, -.0029524f, -1.6001e-6f,
				     3070.f, 3080.f, .67841f, 5.2135f, 5.235e-4f, 6.0726e-6f, -3.7339e-4f,
				     -2.3662e-6f, 3080.f, 3090.f, 3.1429f, 5.2297f, .0017001f, -8.0369e-6f,
				     -2.527e-4f, -9.2399e-6f, 3090.f, 3100.f, .55537f, 4.0641f, -8.4176e-4f,
				     3.74e-7f, -.0020788f, -8.3774e-7f, 3100.f, 3110.f, .62683f, 4.1264f,
				     -6.4674e-4f, -8.4882e-7f, -5.9275e-4f, -1.4998e-6f, 3110.f, 3120.f,
				     .75072f, 5.6505f, .0024151f, -8.8833e-6f, .0024005f, -1.4915e-5f,
				     3120.f, 3130.f, .63692f, 5.2929f, .0052702f, -2.0599e-5f, .0049282f,
				     -2.9353e-5f, 3130.f, 3140.f, .6931f, 5.7878f, .0069797f, -3.6776e-5f,
				     .0052917f, -3.67e-5f, 3140.f, 3150.f, 1.0593f, 5.0675f, .0040985f,
				     -2.5996e-5f, .0032401f, -2.8071e-5f, 3150.f, 3160.f, 1.7493f, 4.5943f,
				     -1.8037e-4f, -8.6286e-6f, 2.5807e-4f, -1.0009e-5f, 3160.f, 3170.f,
				     2.0855f, 5.9045f, -.0022784f, 1.4682e-6f, -.0024776f, -2.9964e-6f,
				     3170.f, 3180.f, 1.3759f, 5.4986f, -.0034094f, 2.6712e-6f, -.0053592f,
				     5.6885e-6f, 3180.f, 3190.f, 3.923f, 8.3024f, -.0018506f, -3.5742e-7f,
				     -.0024786f, -1.1732e-6f, 3190.f, 3200.f, 1.1841f, 5.1604f, .0039237f,
				     -2.2108e-5f, .0038274f, -2.7628e-5f, 3200.f, 3210.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 0.f, 3210.f, 3220.f, 5.5594e-4f, .13449f, 1.458e-4f, -1.5828e-5f,
				     -.0029023f, -1.0057e-5f, 3220.f, 3230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     3230.f, 3240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3240.f, 3250.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3250.f, 3260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3260.f,
				     3270.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3270.f, 3280.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3280.f, 3290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3290.f, 3300.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3300.f, 3310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3310.f,
				     3320.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3320.f, 3330.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3330.f, 3340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3340.f, 3350.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3350.f, 3360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3360.f,
				     3370.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3370.f, 3380.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3380.f, 3390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3390.f, 3400.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3400.f, 3410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3410.f,
				     3420.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3420.f, 3430.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3430.f, 3440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3440.f, 3450.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3450.f, 3460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3460.f,
				     3470.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3470.f, 3480.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3480.f, 3490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3490.f, 3500.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3500.f, 3510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3510.f,
				     3520.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3520.f, 3530.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3530.f, 3540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3540.f, 3550.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3550.f, 3560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3560.f,
				     3570.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3570.f, 3580.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3580.f, 3590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3590.f, 3600.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3600.f, 3610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3610.f,
				     3620.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3620.f, 3630.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3630.f, 3640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3640.f, 3650.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3650.f, 3660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3660.f,
				     3670.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3670.f, 3680.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3680.f, 3690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3690.f, 3700.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3700.f, 3710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3710.f,
				     3720.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3720.f, 3730.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3730.f, 3740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3740.f, 3750.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3750.f, 3760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3760.f,
				     3770.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3770.f, 3780.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3780.f, 3790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3790.f, 3800.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3800.f, 3810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3810.f,
				     3820.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3820.f, 3830.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3830.f, 3840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3840.f, 3850.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3850.f, 3860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3860.f,
				     3870.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3870.f, 3880.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3880.f, 3890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3890.f, 3900.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3900.f, 3910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3910.f,
				     3920.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3920.f, 3930.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3930.f, 3940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3940.f, 3950.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3950.f, 3960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3960.f,
				     3970.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3970.f, 3980.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3980.f, 3990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3990.f, 4e3f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 4e3f, 4010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4010.f, 4020.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4020.f, 4030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4030.f,
				     4040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4040.f, 4050.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4050.f, 4060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4060.f, 4070.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4070.f, 4080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4080.f,
				     4090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4090.f, 4100.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4100.f, 4110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4110.f, 4120.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4120.f, 4130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4130.f,
				     4140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4140.f, 4150.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4150.f, 4160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4160.f, 4170.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4170.f, 4180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4180.f,
				     4190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4190.f, 4200.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4200.f, 4210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4210.f, 4220.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4220.f, 4230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4230.f,
				     4240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4240.f, 4250.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4250.f, 4260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4260.f, 4270.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4270.f, 4280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4280.f,
				     4290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4290.f, 4300.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4300.f, 4310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4310.f, 4320.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4320.f, 4330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4330.f,
				     4340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4340.f, 4350.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4350.f, 4360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4360.f, 4370.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4370.f, 4380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4380.f,
				     4390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4390.f, 4400.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4400.f, 4410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4410.f, 4420.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4420.f, 4430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4430.f,
				     4440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4440.f, 4450.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4450.f, 4460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4460.f, 4470.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4470.f, 4480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4480.f,
				     4490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4490.f, 4500.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4500.f, 4510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4510.f, 4520.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4520.f, 4530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4530.f,
				     4540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4540.f, 4550.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4550.f, 4560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4560.f, 4570.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4570.f, 4580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4580.f,
				     4590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4590.f, 4600.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4600.f, 4610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4610.f, 4620.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4620.f, 4630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4630.f,
				     4640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4640.f, 4650.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4650.f, 4660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4660.f, 4670.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4670.f, 4680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4680.f,
				     4690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4690.f, 4700.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4700.f, 4710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4710.f, 4720.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4720.f, 4730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4730.f,
				     4740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4740.f, 4750.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4750.f, 4760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4760.f, 4770.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4770.f, 4780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4780.f,
				     4790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4790.f, 4800.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4800.f, 4810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4810.f, 4820.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4820.f, 4830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4830.f,
				     4840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4840.f, 4850.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4850.f, 4860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4860.f, 4870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4870.f, 4880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4880.f,
				     4890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4890.f, 4900.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4900.f, 4910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4910.f, 4920.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4920.f, 4930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4930.f,
				     4940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4940.f, 4950.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4950.f, 4960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4960.f, 4970.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4970.f, 4980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4980.f,
				     4990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4990.f, 5e3f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5e3f, 5010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5010.f, 5020.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 5020.f, 5030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5030.f,
				     5040.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5040.f, 5050.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     5050.f, 5060.f
    };

  
    /* ozone (2500 - 5040 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* ozon1 */


void
niox6 (double a[8], const long int inu)
{


    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 15300.f, 15310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15310.f, 15320.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 15320.f, 15330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15330.f, 15340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15340.f, 15350.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15350.f, 15360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15360.f,
				     15370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15370.f, 15380.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15380.f, 15390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15390.f,
				     15400.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15400.f, 15410.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15410.f, 15420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15420.f, 15430.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15430.f, 15440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15440.f,
				     15450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15450.f, 15460.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15460.f, 15470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15470.f,

				     15480.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15480.f, 15490.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15490.f, 15500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15500.f, 15510.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15510.f, 15520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15520.f,
				     15530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15530.f, 15540.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15540.f, 15550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15550.f,
				     15560.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15560.f, 15570.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15570.f, 15580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15580.f, 15590.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15590.f, 15600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15600.f,
				     15610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15610.f, 15620.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15620.f, 15630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15630.f,
				     15640.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15640.f, 15650.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15650.f, 15660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15660.f, 15670.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15670.f, 15680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15680.f,
				     15690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15690.f, 15700.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15700.f, 15710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15710.f,
				     15720.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15720.f, 15730.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15730.f, 15740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15740.f, 15750.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15750.f, 15760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15760.f,
				     15770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15770.f, 15780.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15780.f, 15790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15790.f,
				     15800.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15800.f, 15810.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15810.f, 15820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15820.f, 15830.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15830.f, 15840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15840.f,
				     15850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15850.f, 15860.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15860.f, 15870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15870.f,
				     15880.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15880.f, 15890.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15890.f, 15900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15900.f, 15910.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15910.f, 15920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15920.f,
				     15930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15930.f, 15940.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15940.f, 15950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15950.f,
				     15960.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15960.f, 15970.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15970.f, 15980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15980.f, 15990.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15990.f, 1.6e4f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.6e4f,
				     16010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16010.f, 16020.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16020.f, 16030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16030.f,
				     16040.f,

				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16040.f, 16050.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16050.f, 16060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16060.f, 16070.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16070.f, 16080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16080.f,
				     16090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16090.f, 16100.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16100.f, 16110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16110.f,
				     16120.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16120.f, 16130.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16130.f, 16140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16140.f, 16150.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16150.f, 16160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16160.f,
				     16170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16170.f, 16180.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16180.f, 16190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16190.f,
				     16200.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16200.f, 16210.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16210.f, 16220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16220.f, 16230.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16230.f, 16240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16240.f,
				     16250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16250.f, 16260.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16260.f, 16270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16270.f,
				     16280.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16280.f, 16290.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16290.f, 16300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16300.f, 16310.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16310.f, 16320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16320.f,
				     16330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16330.f, 16340.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16340.f, 16350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16350.f,
				     16360.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16360.f, 16370.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16370.f, 16380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16380.f, 16390.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16390.f, 16400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16400.f,
				     16410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16410.f, 16420.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16420.f, 16430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16430.f,
				     16440.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16440.f, 16450.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16450.f, 16460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16460.f, 16470.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16470.f, 16480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16480.f,
				     16490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16490.f, 16500.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16500.f, 16510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16510.f,
				     16520.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16520.f, 16530.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16530.f, 16540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16540.f, 16550.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16550.f, 16560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16560.f,
				     16570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16570.f, 16580.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16580.f, 16590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16590.f,
				     16600.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16600.f, 16610.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16610.f, 16620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16620.f, 16630.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16630.f, 16640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16640.f,
				     16650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16650.f, 16660.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16660.f, 16670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16670.f,
				     16680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16680.f, 16690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16690.f, 16700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16700.f, 16710.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16710.f, 16720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16720.f,
				     16730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16730.f, 16740.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16740.f, 16750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16750.f,
				     16760.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16760.f, 16770.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16770.f, 16780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16780.f, 16790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16790.f, 16800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16800.f,
				     16810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16810.f, 16820.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16820.f, 16830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16830.f,
				     16840.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16840.f, 16850.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16850.f, 16860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16860.f, 16870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16870.f, 16880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16880.f,
				     16890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16890.f, 16900.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16900.f, 16910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16910.f,
				     16920.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16920.f, 16930.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16930.f, 16940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16940.f, 16950.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16950.f, 16960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16960.f,
				     16970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16970.f, 16980.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16980.f, 16990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16990.f, 1.7e4f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.7e4f, 17010.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17010.f, 17020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17020.f, 17030.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17030.f, 17040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17040.f,
				     17050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17050.f, 17060.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17060.f, 17070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17070.f,
				     17080.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17080.f, 17090.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17090.f, 17100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17100.f, 17110.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17110.f, 17120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17120.f,
				     17130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17130.f, 17140.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17140.f, 17150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17150.f,
				     17160.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17160.f, 17170.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17170.f, 17180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17180.f, 17190.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17190.f, 17200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17200.f,
				     17210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17210.f, 17220.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17220.f, 17230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17230.f,
				     17240.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17240.f, 17250.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17250.f, 17260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17260.f, 17270.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17270.f, 17280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17280.f,
				     17290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17290.f, 17300.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17300.f, 17310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17310.f,
				     17320.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17320.f, 17330.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17330.f, 17340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17340.f, 17350.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17350.f, 17360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17360.f,
				     17370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17370.f, 17380.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17380.f, 17390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17390.f,
				     17400.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17400.f, 17410.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17410.f, 17420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17420.f, 17430.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17430.f, 17440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17440.f,
				     17450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17450.f, 17460.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17460.f, 17470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17470.f,
				     17480.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17480.f, 17490.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17490.f, 17500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17500.f, 17510.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17510.f, 17520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17520.f,
				     17530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17530.f, 17540.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17540.f, 17550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17550.f,
				     17560.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17560.f, 17570.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17570.f, 17580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17580.f, 17590.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17590.f, 17600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17600.f,
				     17610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17610.f, 17620.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17620.f, 17630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17630.f,
				     17640.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17640.f, 17650.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17650.f, 17660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17660.f, 17670.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17670.f, 17680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17680.f,
				     17690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17690.f, 17700.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17700.f, 17710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17710.f,
				     17720.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17720.f, 17730.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17730.f, 17740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17740.f, 17750.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17750.f, 17760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17760.f,
				     17770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17770.f, 17780.f, 0.f, 0.f, 0.f,

				     0.f,
				     0.f, 0.f, 17780.f, 17790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17790.f,
				     17800.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17800.f, 17810.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17810.f, 17820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17820.f, 17830.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17830.f, 17840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17840.f,
				     17850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17850.f, 17860.f
    };

    /* nitrous oxide (15300 - 17870 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* niox6 */

void
niox5 (double a[8], const long int inu)
{


    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 12740.f, 12750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12750.f, 12760.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 12760.f, 12770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12770.f, 12780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12780.f, 12790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12790.f, 12800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12800.f,
				     12810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12810.f, 12820.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12820.f, 12830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12830.f,
				     12840.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12840.f, 12850.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12850.f, 12860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12860.f, 12870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12870.f, 12880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12880.f,
				     12890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12890.f, 12900.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12900.f, 12910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12910.f,
				     12920.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12920.f, 12930.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12930.f, 12940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12940.f, 12950.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12950.f, 12960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12960.f,
				     12970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12970.f, 12980.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12980.f, 12990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12990.f, 1.3e4f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.3e4f, 13010.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13010.f, 13020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13020.f, 13030.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13030.f, 13040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13040.f,
				     13050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13050.f, 13060.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13060.f, 13070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13070.f,
				     13080.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13080.f, 13090.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13090.f, 13100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13100.f, 13110.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13110.f, 13120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13120.f,
				     13130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13130.f, 13140.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13140.f, 13150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13150.f,
				     13160.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13160.f, 13170.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13170.f, 13180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13180.f, 13190.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13190.f, 13200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13200.f,
				     13210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13210.f, 13220.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13220.f, 13230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13230.f,
				     13240.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13240.f, 13250.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13250.f, 13260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13260.f, 13270.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13270.f, 13280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,

				     13280.f,
				     13290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13290.f, 13300.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13300.f, 13310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13310.f,
				     13320.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13320.f, 13330.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13330.f, 13340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13340.f, 13350.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13350.f, 13360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13360.f,
				     13370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13370.f, 13380.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13380.f, 13390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13390.f,
				     13400.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13400.f, 13410.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13410.f, 13420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13420.f, 13430.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13430.f, 13440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13440.f,
				     13450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13450.f, 13460.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13460.f, 13470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13470.f,
				     13480.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13480.f, 13490.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13490.f, 13500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13500.f, 13510.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13510.f, 13520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13520.f,
				     13530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13530.f, 13540.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13540.f, 13550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13550.f,
				     13560.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13560.f, 13570.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13570.f, 13580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13580.f, 13590.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13590.f, 13600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13600.f,
				     13610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13610.f, 13620.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13620.f, 13630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13630.f,
				     13640.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13640.f, 13650.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13650.f, 13660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13660.f, 13670.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13670.f, 13680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13680.f,
				     13690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13690.f, 13700.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13700.f, 13710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13710.f,
				     13720.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13720.f, 13730.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13730.f, 13740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13740.f, 13750.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13750.f, 13760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13760.f,
				     13770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13770.f, 13780.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13780.f, 13790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13790.f,
				     13800.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13800.f, 13810.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13810.f, 13820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13820.f, 13830.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13830.f, 13840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13840.f,
				     13850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13850.f, 13860.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13860.f, 13870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13870.f,
				     13880.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13880.f, 13890.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13890.f, 13900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13900.f, 13910.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13910.f, 13920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13920.f,
				     13930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13930.f, 13940.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13940.f, 13950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13950.f,
				     13960.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13960.f, 13970.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13970.f, 13980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13980.f, 13990.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13990.f, 1.4e4f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.4e4f,
				     14010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14010.f, 14020.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14020.f, 14030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14030.f,
				     14040.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14040.f, 14050.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14050.f, 14060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14060.f, 14070.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14070.f, 14080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14080.f,
				     14090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14090.f, 14100.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14100.f, 14110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14110.f,

				     14120.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14120.f, 14130.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14130.f, 14140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14140.f, 14150.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14150.f, 14160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14160.f,
				     14170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14170.f, 14180.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14180.f, 14190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14190.f,
				     14200.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14200.f, 14210.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14210.f, 14220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14220.f, 14230.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14230.f, 14240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14240.f,
				     14250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14250.f, 14260.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14260.f, 14270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14270.f,
				     14280.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14280.f, 14290.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14290.f, 14300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14300.f, 14310.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14310.f, 14320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14320.f,
				     14330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14330.f, 14340.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14340.f, 14350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14350.f,
				     14360.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14360.f, 14370.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14370.f, 14380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14380.f, 14390.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14390.f, 14400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14400.f,
				     14410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14410.f, 14420.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14420.f, 14430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14430.f,
				     14440.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14440.f, 14450.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14450.f, 14460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14460.f, 14470.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14470.f, 14480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14480.f,
				     14490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14490.f, 14500.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14500.f, 14510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14510.f,
				     14520.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14520.f, 14530.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14530.f, 14540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14540.f, 14550.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14550.f, 14560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,

				     14560.f,
				     14570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14570.f, 14580.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14580.f, 14590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14590.f,
				     14600.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14600.f, 14610.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14610.f, 14620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14620.f, 14630.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14630.f, 14640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14640.f,
				     14650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14650.f, 14660.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14660.f, 14670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14670.f,
				     14680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14680.f, 14690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14690.f, 14700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14700.f, 14710.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14710.f, 14720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14720.f,
				     14730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14730.f, 14740.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14740.f, 14750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14750.f,
				     14760.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14760.f, 14770.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14770.f, 14780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14780.f, 14790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14790.f, 14800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14800.f,
				     14810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14810.f, 14820.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14820.f, 14830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14830.f,
				     14840.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14840.f, 14850.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14850.f, 14860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14860.f, 14870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14870.f, 14880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14880.f,
				     14890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14890.f, 14900.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14900.f, 14910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14910.f,
				     14920.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14920.f, 14930.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14930.f, 14940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14940.f, 14950.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14950.f, 14960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14960.f,
				     14970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14970.f, 14980.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14980.f, 14990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14990.f, 1.5e4f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.5e4f, 15010.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15010.f, 15020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15020.f, 15030.f, 0.f,

				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15030.f, 15040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15040.f,
				     15050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15050.f, 15060.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15060.f, 15070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15070.f,
				     15080.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15080.f, 15090.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15090.f, 15100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15100.f, 15110.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15110.f, 15120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15120.f,
				     15130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15130.f, 15140.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15140.f, 15150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15150.f,
				     15160.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15160.f, 15170.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15170.f, 15180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15180.f, 15190.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15190.f, 15200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15200.f,
				     15210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15210.f, 15220.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15220.f, 15230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15230.f,
				     15040.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15240.f, 15250.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15250.f, 15260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15260.f, 15270.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15270.f, 15280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15280.f,
				     15290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15290.f, 15300.f
    };

    /* nitrous oxide (12740 - 15290 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* niox5 */

void
niox4 (double a[8], const long int inu)
{


    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 10180.f, 10190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10190.f, 10200.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 10200.f, 10210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10210.f, 10220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10220.f, 10230.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10230.f, 10240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10240.f,
				     10250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10250.f, 10260.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10260.f, 10270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10270.f,
				     10280.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10280.f, 10290.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10290.f, 10300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10300.f, 10310.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10310.f, 10320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10320.f,
				     10330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10330.f, 10340.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10340.f, 10350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10350.f,
				     10360.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10360.f, 10370.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10370.f, 10380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10380.f, 10390.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10390.f, 10400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10400.f,
				     10410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10410.f, 10420.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10420.f, 10430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10430.f,
				     10440.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10440.f, 10450.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10450.f, 10460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10460.f, 10470.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10470.f, 10480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10480.f,
				     10490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10490.f, 10500.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10500.f, 10510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10510.f,
				     10520.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10520.f, 10530.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10530.f, 10540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10540.f, 10550.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10550.f, 10560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10560.f,
				     10570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10570.f, 10580.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10580.f, 10590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10590.f,
				     10600.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10600.f, 10610.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10610.f, 10620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10620.f, 10630.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10630.f, 10640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10640.f,
				     10650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10650.f, 10660.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10660.f, 10670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10670.f,
				     10680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10680.f, 10690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10690.f, 10700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10700.f, 10710.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10710.f, 10720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10720.f,
				     10730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10730.f, 10740.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10740.f, 10750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10750.f,
				     10760.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10760.f, 10770.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10770.f, 10780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10780.f, 10790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10790.f, 10800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10800.f,
				     10810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10810.f, 10820.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10820.f, 10830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10830.f,
				     10840.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10840.f, 10850.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10850.f, 10860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10860.f, 10870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10870.f, 10880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10880.f,

				     10890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10890.f, 10900.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10900.f, 10910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10910.f,
				     10920.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10920.f, 10930.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10930.f, 10940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10940.f, 10950.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10950.f, 10960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10960.f,
				     10970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10970.f, 10980.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10980.f, 10990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10990.f, 1.1e4f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.1e4f, 11010.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11010.f, 11020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11020.f, 11030.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11030.f, 11040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11040.f,
				     11050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11050.f, 11060.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11060.f, 11070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11070.f,
				     11080.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11080.f, 11090.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11090.f, 11100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11100.f, 11110.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11110.f, 11120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11120.f,
				     11130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11130.f, 11140.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11140.f, 11150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11150.f,
				     11160.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11160.f, 11170.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11170.f, 11180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11180.f, 11190.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11190.f, 11200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11200.f,
				     11210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11210.f, 11220.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11220.f, 11230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11230.f,
				     11240.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11240.f, 11250.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,

				     11250.f, 11260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11260.f, 11270.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11270.f, 11280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11280.f,
				     11290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11290.f, 11300.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11300.f, 11310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11310.f,
				     11320.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11320.f, 11330.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11330.f, 11340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11340.f, 11350.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11350.f, 11360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11360.f,
				     11370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11370.f, 11380.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11380.f, 11390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11390.f,
				     11400.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11400.f, 11410.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11410.f, 11420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11420.f, 11430.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11430.f, 11440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11440.f,
				     11450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11450.f, 11460.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11460.f, 11470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11470.f,
				     11480.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11480.f, 11490.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11490.f, 11500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11500.f, 11510.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11510.f, 11520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11520.f,
				     11530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11530.f, 11540.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11540.f, 11550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11550.f,
				     11560.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11560.f, 11570.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11570.f, 11580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11580.f, 11590.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11590.f, 11600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11600.f,
				     11610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11610.f, 11620.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11620.f, 11630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11630.f,
				     11640.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11640.f, 11650.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11650.f, 11660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11660.f, 11670.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11670.f, 11680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11680.f,
				     11690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11690.f, 11700.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11700.f, 11710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11710.f,
				     11720.f,

				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11720.f, 11730.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11730.f, 11740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11740.f, 11750.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11750.f, 11760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11760.f,
				     11770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11770.f, 11780.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11780.f, 11790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11790.f,
				     11800.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11800.f, 11810.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11810.f, 11820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11820.f, 11830.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11830.f, 11840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11840.f,
				     11850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11850.f, 11860.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11860.f, 11870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11870.f,
				     11880.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11880.f, 11890.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11890.f, 11900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11900.f, 11910.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11910.f, 11920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11920.f,
				     11930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11930.f, 11940.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11940.f, 11950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11950.f,
				     11960.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11960.f, 11970.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11970.f, 11980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11980.f, 11990.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11990.f, 1.2e4f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.2e4f,
				     12010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12010.f, 12020.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12020.f, 12030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12030.f,
				     12040.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12040.f, 12050.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12050.f, 12060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12060.f, 12070.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12070.f, 12080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12080.f,
				     12090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12090.f, 12100.f, 0.f, 0.f, 0.f,

				     0.f,
				     0.f, 0.f, 12100.f, 12110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12110.f,
				     12120.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12120.f, 12130.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12130.f, 12140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12140.f, 12150.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12150.f, 12160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12160.f,
				     12170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12170.f, 12180.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12180.f, 12190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12190.f,
				     12200.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12200.f, 12210.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12210.f, 12220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12220.f, 12230.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12230.f, 12240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12240.f,
				     12250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12250.f, 12260.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12260.f, 12270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12270.f,
				     12280.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12280.f, 12290.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12290.f, 12300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12300.f, 12310.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12310.f, 12320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12320.f,
				     12330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12330.f, 12340.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12340.f, 12350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12350.f,
				     12360.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12360.f, 12370.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12370.f, 12380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12380.f, 12390.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12390.f, 12400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12400.f,
				     12410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12410.f, 12420.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12420.f, 12430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12430.f,
				     12440.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12440.f, 12450.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12450.f, 12460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12460.f, 12470.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12470.f, 12480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12480.f,
				     12490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12490.f, 12500.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12500.f, 12510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12510.f,
				     12520.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12520.f, 12530.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12530.f, 12540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12540.f, 12550.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12550.f, 12560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12560.f,
				     12570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12570.f, 12580.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12580.f, 12590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12590.f,
				     12600.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12600.f, 12610.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12610.f, 12620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12620.f, 12630.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12630.f, 12640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12640.f,
				     12650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12650.f, 12660.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12660.f, 12670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12670.f,
				     12680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12680.f, 12690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12690.f, 12700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12700.f, 12710.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12710.f, 12720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12720.f,
				     12730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12730.f, 12740.f
    };

    /* nitrous oxide (10180 - 12730 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* niox4 */

void
niox3 (double a[8], const long int inu)
{


    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 7620.f, 7630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7630.f, 7640.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7640.f, 7650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7650.f,
				     7660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7660.f, 7670.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7670.f, 7680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7680.f, 7690.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7690.f, 7700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7700.f,
				     7710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7710.f, 7720.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7720.f, 7730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7730.f, 7740.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7740.f, 7750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7750.f,
				     7760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7760.f, 7770.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7770.f, 7780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7780.f, 7790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7790.f, 7800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7800.f,
				     7810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7810.f, 7820.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7820.f, 7830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7830.f, 7840.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7840.f, 7850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7850.f,
				     7860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7860.f, 7870.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7870.f, 7880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7880.f, 7890.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7890.f, 7900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7900.f,
				     7910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7910.f, 7920.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7920.f, 7930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7930.f, 7940.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7940.f, 7950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7950.f,
				     7960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7960.f, 7970.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7970.f, 7980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7980.f, 7990.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7990.f, 8e3f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8e3f,
				     8010.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8010.f, 8020.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8020.f, 8030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8030.f, 8040.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8040.f, 8050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8050.f,
				     8060.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8060.f, 8070.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8070.f, 8080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8080.f, 8090.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8090.f, 8100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8100.f,
				     8110.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8110.f, 8120.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8120.f, 8130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8130.f, 8140.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8140.f, 8150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8150.f,
				     8160.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8160.f, 8170.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8170.f, 8180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8180.f, 8190.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8190.f, 8200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8200.f,
				     8210.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8210.f, 8220.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8220.f, 8230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8230.f, 8240.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8240.f, 8250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8250.f,
				     8260.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8260.f, 8270.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8270.f, 8280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8280.f, 8290.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8290.f, 8300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8300.f,
				     8310.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8310.f, 8320.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8320.f, 8330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8330.f, 8340.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8340.f, 8350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8350.f,
				     8360.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8360.f, 8370.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8370.f, 8380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8380.f, 8390.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8390.f, 8400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8400.f,
				     8410.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8410.f, 8420.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8420.f, 8430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8430.f, 8440.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8440.f, 8450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8450.f,
				     8460.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8460.f, 8470.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8470.f, 8480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8480.f, 8490.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8490.f, 8500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8500.f,
				     8510.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8510.f, 8520.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8520.f, 8530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8530.f, 8540.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8540.f, 8550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8550.f,
				     8560.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8560.f, 8570.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8570.f, 8580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8580.f, 8590.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8590.f, 8600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8600.f,
				     8610.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8610.f, 8620.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8620.f, 8630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8630.f, 8640.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8640.f, 8650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8650.f,
				     8660.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8660.f, 8670.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8670.f, 8680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8680.f, 8690.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8690.f, 8700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8700.f,
				     8710.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8710.f, 8720.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8720.f, 8730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8730.f, 8740.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8740.f, 8750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8750.f,
				     8760.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8760.f, 8770.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8770.f, 8780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8780.f, 8790.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8790.f, 8800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8800.f,
				     8810.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8810.f, 8820.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8820.f, 8830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8830.f, 8840.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8840.f, 8850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8850.f,
				     8860.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8860.f, 8870.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8870.f, 8880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8880.f, 8890.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8890.f, 8900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8900.f,
				     8910.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8910.f, 8920.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8920.f, 8930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8930.f, 8940.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8940.f, 8950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8950.f,
				     8960.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8960.f, 8970.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8970.f, 8980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8980.f, 8990.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8990.f, 9e3f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9e3f, 9010.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 9010.f, 9020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     9020.f,

				     9030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9030.f, 9040.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9040.f, 9050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9050.f, 9060.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9060.f, 9070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9070.f,
				     9080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9080.f, 9090.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9090.f, 9100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9100.f, 9110.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9110.f, 9120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9120.f,
				     9130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9130.f, 9140.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9140.f, 9150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9150.f, 9160.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9160.f, 9170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9170.f,
				     9180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9180.f, 9190.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9190.f, 9200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9200.f, 9210.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9210.f, 9220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9220.f,
				     9230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9230.f, 9240.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9240.f, 9250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9250.f, 9260.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9260.f, 9270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9270.f,
				     9280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9280.f, 9290.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9290.f, 9300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9300.f, 9310.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9310.f, 9320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9320.f,
				     9330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9330.f, 9340.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9340.f, 9350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9350.f, 9360.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9360.f, 9370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9370.f,
				     9380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9380.f, 9390.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9390.f, 9400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9400.f, 9410.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9410.f, 9420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9420.f,
				     9430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9430.f, 9440.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9440.f, 9450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9450.f, 9460.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9460.f, 9470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9470.f,
				     9480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9480.f, 9490.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9490.f, 9500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9500.f, 9510.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9510.f, 9520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9520.f,

				     9530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9530.f, 9540.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9540.f, 9550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9550.f, 9560.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9560.f, 9570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9570.f,
				     9580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9580.f, 9590.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9590.f, 9600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9600.f, 9610.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9610.f, 9620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9620.f,
				     9630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9630.f, 9640.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9640.f, 9650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9650.f, 9660.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9660.f, 9670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9670.f,
				     9680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9680.f, 9690.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9690.f, 9700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9700.f, 9710.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9710.f, 9720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9720.f,
				     9730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9730.f, 9740.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9740.f, 9750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9750.f, 9760.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9760.f, 9770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9770.f,
				     9780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9780.f, 9790.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9790.f, 9800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9800.f, 9810.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9810.f, 9820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9820.f,
				     9830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9830.f, 9840.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9840.f, 9850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9850.f, 9860.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9860.f, 9870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9870.f,
				     9880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9880.f, 9890.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9890.f, 9900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9900.f, 9910.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9910.f, 9920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9920.f,
				     9930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9930.f, 9940.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9940.f, 9950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9950.f, 9960.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9960.f, 9970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9970.f,
				     9980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9980.f, 9990.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9990.f, 1e4f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1e4f, 10010.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 10010.f, 10020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10020.f,
				     10030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10030.f, 10040.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10040.f, 10050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10050.f,
				     10060.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10060.f, 10070.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10070.f, 10080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10080.f, 10090.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10090.f, 10100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10100.f,
				     10110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10110.f, 10120.f, 0.f, 0.f, 0.f,
				     0.f,

				     0.f, 0.f, 10120.f, 10130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10130.f,
				     10140.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10140.f, 10150.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10150.f, 10160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10160.f, 10170.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10170.f, 10180.f
    };

    /* nitrous oxide (7620 - 10170 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* niox3 */

void
niox2 (double a[8], const long int inu)
{


    static const float acr[2048] = { .072211f, .24584f,
				     .0096738f, -5.1958e-5f, .0067533f, -4.7277e-5f, 5060.f, 5070.f, .21388f,
				     .25456f, .0043318f, -3.1058e-5f, .0012217f, -2.5614e-5f, 5070.f, 5080.f,
				     .57556f, .33263f, -2.6597e-4f, -1.2844e-5f, -.0033007f, -7.3238e-6f,
				     5080.f, 5090.f, .67723f, .36014f, -.0034018f, -8.0539e-7f, -.006515f,
				     5.4383e-6f, 5090.f, 5100.f, .30093f, .41799f, -.0047912f, 4.5347e-6f,
				     -.0079672f, 1.0982e-5f, 5100.f, 5110.f, 1.0645f, .53257f, -.003157f,
				     -1.4679e-6f, -.0062971f, 4.7135e-6f, 5110.f, 5120.f, .67643f, .61899f,
				     .0025029f, -2.0398e-5f, 2.0488e-4f, -1.9155e-5f, 5120.f, 5130.f,
				     .018117f, .12425f, .013386f, -6.7752e-5f, .010428f, -6.2211e-5f, 5130.f,
				     5140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5140.f, 5150.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5150.f, 5160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5160.f, 5170.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5170.f, 5180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5180.f,
				     5190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5190.f, 5200.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5200.f, 5210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5210.f, 5220.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5220.f, 5230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5230.f,
				     5240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5240.f, 5250.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5250.f, 5260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5260.f, 5270.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5270.f, 5280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5280.f,
				     5290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5290.f, 5300.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5300.f, 5310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5310.f, 5320.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5320.f, 5330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5330.f,
				     5340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5340.f, 5350.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5350.f, 5360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5360.f, 5370.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5370.f, 5380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5380.f,
				     5390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5390.f, 5400.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5400.f, 5410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5410.f, 5420.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5420.f, 5430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5430.f,
				     5440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5440.f, 5450.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5450.f, 5460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5460.f, 5470.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5470.f, 5480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5480.f,
				     5490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5490.f, 5500.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5500.f, 5510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5510.f, 5520.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5520.f, 5530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5530.f,
				     5540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5540.f, 5550.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5550.f, 5560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5560.f, 5570.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5570.f, 5580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5580.f,
				     5590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5590.f, 5600.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5600.f, 5610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5610.f, 5620.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5620.f, 5630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5630.f,
				     5640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5640.f, 5650.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5650.f, 5660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5660.f, 5670.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5670.f, 5680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5680.f,
				     5690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5690.f, 5700.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5700.f, 5710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5710.f, 5720.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5720.f, 5730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5730.f,
				     5740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5740.f, 5750.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5750.f, 5760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5760.f, 5770.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5770.f, 5780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5780.f,
				     5790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5790.f, 5800.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5800.f, 5810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5810.f, 5820.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5820.f, 5830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5830.f,
				     5840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5840.f, 5850.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5850.f, 5860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5860.f, 5870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5870.f, 5880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5880.f,
				     5890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5890.f, 5900.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5900.f, 5910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5910.f, 5920.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5920.f, 5930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5930.f,
				     5940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5940.f, 5950.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5950.f, 5960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5960.f, 5970.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5970.f, 5980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5980.f,
				     5990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5990.f, 6e3f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6e3f, 6010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6010.f, 6020.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6020.f, 6030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6030.f,
				     6040.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6040.f, 6050.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6050.f, 6060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6060.f, 6070.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6070.f, 6080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6080.f,
				     6090.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6090.f, 6100.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6100.f, 6110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6110.f, 6120.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6120.f, 6130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6130.f,
				     6140.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6140.f, 6150.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6150.f, 6160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6160.f, 6170.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6170.f, 6180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6180.f,
				     6190.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6190.f, 6200.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6200.f, 6210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6210.f, 6220.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6220.f, 6230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6230.f,
				     6240.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6240.f, 6250.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6250.f, 6260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6260.f, 6270.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6270.f, 6280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6280.f,
				     6290.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6290.f, 6300.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6300.f, 6310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6310.f, 6320.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6320.f, 6330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6330.f,
				     6340.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6340.f, 6350.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6350.f, 6360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6360.f, 6370.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6370.f, 6380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6380.f,
				     6390.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6390.f, 6400.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6400.f, 6410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6410.f, 6420.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6420.f, 6430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6430.f,
				     6440.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6440.f, 6450.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6450.f, 6460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6460.f, 6470.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6470.f, 6480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6480.f,
				     6490.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6490.f, 6500.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6500.f, 6510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6510.f, 6520.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6520.f, 6530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6530.f,
				     6540.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6540.f, 6550.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6550.f, 6560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6560.f, 6570.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6570.f, 6580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6580.f,
				     6590.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6590.f, 6600.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6600.f, 6610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6610.f, 6620.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6620.f, 6630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6630.f,
				     6640.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6640.f, 6650.f, 0.f, 0.f, 0.f, 0.f, 0.f,

				     0.f,
				     6650.f, 6660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6660.f, 6670.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6670.f, 6680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6680.f,
				     6690.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6690.f, 6700.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6700.f, 6710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6710.f, 6720.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6720.f, 6730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6730.f,
				     6740.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6740.f, 6750.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6750.f, 6760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6760.f, 6770.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6770.f, 6780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6780.f,
				     6790.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6790.f, 6800.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6800.f, 6810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6810.f, 6820.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6820.f, 6830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6830.f,
				     6840.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6840.f, 6850.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6850.f, 6860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6860.f, 6870.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6870.f, 6880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6880.f,
				     6890.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6890.f, 6900.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6900.f, 6910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6910.f, 6920.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6920.f, 6930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6930.f,
				     6940.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6940.f, 6950.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     6950.f, 6960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6960.f, 6970.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 6970.f, 6980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6980.f,
				     6990.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6990.f, 7e3f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     7e3f,
				     7010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7010.f, 7020.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7020.f, 7030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7030.f, 7040.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7040.f, 7050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7050.f,
				     7060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7060.f, 7070.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7070.f, 7080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7080.f, 7090.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7090.f, 7100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7100.f,
				     7110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7110.f, 7120.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7120.f, 7130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7130.f, 7140.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7140.f, 7150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7150.f,
				     7160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7160.f, 7170.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7170.f, 7180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7180.f, 7190.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7190.f, 7200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7200.f,
				     7210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7210.f, 7220.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7220.f, 7230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7230.f, 7240.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7240.f, 7250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7250.f,
				     7260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7260.f, 7270.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7270.f, 7280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7280.f, 7290.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7290.f, 7300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7300.f,
				     7310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7310.f, 7320.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7320.f, 7330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7330.f, 7340.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7340.f, 7350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7350.f,
				     7360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7360.f, 7370.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7370.f, 7380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7380.f, 7390.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7390.f, 7400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7400.f,
				     7410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7410.f, 7420.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7420.f, 7430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7430.f, 7440.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7440.f, 7450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7450.f,
				     7460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7460.f, 7470.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7470.f, 7480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7480.f, 7490.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7490.f, 7500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7500.f,
				     7510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7510.f, 7520.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7520.f, 7530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7530.f, 7540.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7540.f, 7550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7550.f,
				     7560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7560.f, 7570.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7570.f, 7580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7580.f, 7590.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7590.f, 7600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7600.f,
				     7610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7610.f, 7620.f
    };

    /* nitrous oxide (5060 - 7610 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* niox2 */

void
niox1 (double a[8], const long int inu)
{


    static const float acr[2048] = { 2.0198f, 1.2223f,
				     .021725f, -7.4064e-5f, .021102f, -6.8716e-5f, 2500.f, 2510.f, 5.563f,
				     .51358f, .018526f, -8.1387e-5f, .020173f, -7.5293e-5f, 2510.f, 2520.f,
				     30.587f, .41845f, .010994f, -5.2858e-5f, .012658f, -4.4443e-5f, 2520.f,
				     2530.f, 127.44f, .46867f, .0044706f, -2.7536e-5f, .0057879f,
				     -1.6691e-5f, 2530.f, 2540.f, 288.02f, .51762f, -2.6998e-4f, -8.7651e-6f,
				     .0012264f, 2.1451e-6f, 2540.f, 2550.f, 353.69f, .7476f, -.0029604f,
				     4.5093e-6f, -.0013209f, 1.2765e-5f, 2550.f, 2560.f, 185.24f, 1.0395f,
				     -.0026365f, 1.2028e-5f, 6.176e-4f, 1.0222e-5f, 2560.f, 2570.f, 464.55f,
				     .85773f, -.0024108f, -1.72e-6f, -7.7777e-4f, 5.7019e-6f, 2570.f, 2580.f,
				     293.83f, 1.0741f, .0031043f, -2.1797e-5f, .0037703f, -2.0707e-5f,
				     2580.f, 2590.f, 55.672f, 1.7813f, .013484f, -6.2711e-5f, .013188f,
				     -6.339e-5f, 2590.f, 2600.f, 6.6505f, 2.3452f, .023437f, -9.9109e-5f,
				     .023591f, -1.0503e-4f, 2600.f, 2610.f, .41623f, 2.2528f, .035914f,
				     -1.5047e-4f, .035732f, -1.5387e-4f, 2610.f, 2620.f, .01271f, 1.0271f,
				     .047982f, -1.9811e-4f, .047474f, -2.0344e-4f, 2620.f, 2630.f, 0.f, 0.f,
				     0.f, 0.f, 0.f, 0.f, 2630.f, 2640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2640.f,
				     2650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2650.f, 2660.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2660.f, 2670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2670.f, 2680.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2680.f, 2690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2690.f,
				     2700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2700.f, 2710.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2710.f, 2720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2720.f, 2730.f,
				     .018198f,
				     .18592f, .025778f, -1.1646e-4f, .02282f, -1.1152e-4f, 2730.f, 2740.f,
				     .21623f, .86664f, .021368f, -9.617e-5f, .018994f, -9.4763e-5f, 2740.f,
				     2750.f, .9723f, 1.0815f, .015101f, -7.1229e-5f, .012988f, -7.0769e-5f,
				     2750.f, 2760.f, 3.1871f, 1.6537f, .0095979f, -4.1092e-5f, .0109f,
				     -5.0556e-5f, 2760.f, 2770.f, 9.1207f, 2.0456f, .0045146f, -1.7223e-5f,
				     .0068327f, -3.3329e-5f, 2770.f, 2780.f, 15.769f, 2.4147f, .00151f,
				     2.7306e-6f, .004717f, -2.1798e-5f, 2780.f, 2790.f, 63.944f, 2.2532f,
				     -9.2395e-4f, -1.4987e-6f, -.0017516f, -2.476e-6f, 2790.f, 2800.f,
				     13.465f, .81561f, -.0029579f, 7.8199e-6f, -.0016132f, 7.282e-6f, 2800.f,
				     2810.f, 15.397f, .59138f, -4.591e-4f, -9.3657e-6f, -.0015437f,
				     -2.9788e-6f, 2810.f, 2820.f, 3.8011f, .48019f, .0069255f, -3.8126e-5f,
				     .0047344f, -3.7097e-5f, 2820.f, 2830.f, .17619f, .34619f, .019824f,
				     -8.9371e-5f, .017957f, -8.9565e-5f, 2830.f, 2840.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 0.f, 2840.f, 2850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2850.f, 2860.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 2860.f, 2870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     2870.f,
				     2880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2880.f, 2890.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2890.f, 2900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2900.f, 2910.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2910.f, 2920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2920.f,
				     2930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2930.f, 2940.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2940.f, 2950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2950.f, 2960.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2960.f, 2970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2970.f,
				     2980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2980.f, 2990.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2990.f, 3e3f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3e3f, 3010.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3010.f, 3020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3020.f,
				     3030.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3030.f, 3040.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3040.f, 3050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3050.f, 3060.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3060.f, 3070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3070.f,
				     3080.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3080.f, 3090.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3090.f, 3100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3100.f, 3110.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3110.f, 3120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3120.f,
				     3130.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3130.f, 3140.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3140.f, 3150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3150.f, 3160.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3160.f, 3170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3170.f,
				     3180.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3180.f, 3190.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3190.f, 3200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3200.f, 3210.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3210.f, 3220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3220.f,
				     3230.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3230.f, 3240.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3240.f, 3250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3250.f, 3260.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3260.f, 3270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3270.f,
				     3280.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3280.f, 3290.f, .031935f, .33591f, .031875f,
				     -1.4104e-4f, .028977f, -1.3626e-4f, 3290.f, 3300.f, .29281f, .7467f,
				     .024844f, -1.1101e-4f, .022436f, -1.0879e-4f, 3300.f, 3310.f, 1.3054f,
				     .88331f, .018331f, -8.5898e-5f, .015557f, -8.2041e-5f, 3310.f, 3320.f,
				     4.3559f, .97784f, .012392f, -6.2543e-5f, .0096436f, -5.8644e-5f, 3320.f,
				     3330.f, 10.74f, .87778f, .0059037f, -3.4711e-5f, .0041535f, -3.5594e-5f,
				     3330.f, 3340.f, 23.794f, .67907f, 5.4208e-5f, -1.1592e-5f, -8.2054e-4f,
				     -1.2774e-5f, 3340.f, 3350.f, 27.447f, .86607f, -.0018645f, 4.7336e-6f,
				     -.001502f, -1.8166e-6f, 3350.f, 3360.f, 12.839f, .92051f, -.0018449f,
				     1.8928e-5f, -3.1436e-5f, 6.4319e-6f, 3360.f, 3370.f, 33.503f, .561f,
				     -.0027786f, -1.9224e-7f, -.0032856f, 1.1355e-5f, 3370.f, 3380.f, 20.6f,
				     .44389f, .0016967f, -1.9484e-5f, -.0011701f, -1.5371e-5f, 3380.f,
				     3390.f, 3.8609f, .51395f, .010469f, -4.8303e-5f, .010318f, -4.3382e-5f,
				     3390.f, 3400.f, .29988f, .99187f, .032066f, -1.0701e-4f, .031782f,
				     -1.3149e-4f, 3400.f, 3410.f, 1.1046f, .96114f, .03056f, -1.2026e-4f,
				     .031203f, -1.3653e-4f, 3410.f, 3420.f, 5.3792f, .96792f, .023315f,
				     -9.51e-5f, .024421f, -1.0864e-4f, 3420.f, 3430.f, 25.745f, .89943f,
				     .015618f, -6.5963e-5f, .017309f, -7.84e-5f, 3430.f, 3440.f, 90.538f,
				     .79321f, .009142f, -4.2087e-5f, .010653f, -5.0451e-5f, 3440.f, 3450.f,
				     302.63f, .81416f, .0031369f, -1.9699e-5f, .0046971f, -2.3774e-5f,
				     3450.f, 3460.f, 451.74f, .71592f, -.0010912f, -4.691e-6f, 7.436e-4f,
				     -4.31e-6f, 3460.f, 3470.f, 395.99f, .95008f, -.0034795f, 5.0213e-6f,
				     -.0012061f, 8.3238e-6f, 3470.f, 3480.f, 391.94f, 1.0413f, -.0024518f,
				     9.7005e-6f, 3.1609e-4f, 6.168e-6f, 3480.f, 3490.f, 753.96f, .84036f,
				     -9.1794e-4f, -4.5133e-6f, -2.3983e-4f, -6.0537e-7f, 3490.f, 3500.f,
				     216.44f, .71621f, .00633f, -3.2276e-5f, .0065565f, -3.1312e-5f, 3500.f,
				     3510.f, 1.8617f, .41652f, .026193f, -1.1186e-4f, .025872f, -1.1548e-4f,
				     3510.f, 3520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3520.f, 3530.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3530.f, 3540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3540.f,
				     3550.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3550.f, 3560.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3560.f, 3570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3570.f, 3580.f, .11329f,
				     .32221f, .011785f, -5.9055e-5f, .009293f, -5.6411e-5f, 3580.f, 3590.f,
				     .6324f, .37454f, .0039372f, -2.85e-5f, .0010518f, -2.435e-5f, 3590.f,
				     3600.f, 1.3646f, .37234f, -.0012358f, -8.9975e-6f, -.0042592f,
				     -3.4218e-6f, 3600.f, 3610.f, 1.1991f, .43663f, -.0040429f, 1.6771e-6f,
				     -.007273f, 8.322e-6f, 3610.f, 3620.f, .84759f, .39017f, -.0045304f,
				     3.5248e-6f, -.0077172f, 1.0072e-5f, 3620.f, 3630.f, 1.7247f, .41455f,
				     -.0023639f, -4.6172e-6f, -.0054164f, 1.1967e-6f, 3630.f, 3640.f, .9314f,
				     .40923f, .002508f, -2.2795e-5f, -3.8062e-4f, -1.8608e-5f, 3640.f,
				     3650.f, .17321f, .37301f, .010558f, -5.3495e-5f, .0082291f, -5.1685e-5f,
				     3650.f, 3660.f, .0028992f, .031363f, .018626f, -8.9141e-5f, .015463f,
				     -8.2773e-5f, 3660.f, 3670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3670.f, 3680.f,

				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3680.f, 3690.f, .052016f, .2333f, .023008f,
				     -1.0429e-4f, .020466f, -1.014e-4f, 3690.f, 3700.f, .40077f, .43751f,
				     .015625f, -7.0109e-5f, .014974f, -7.3666e-5f, 3700.f, 3710.f, 2.1822f,
				     .57186f, .0083501f, -3.9798e-5f, .0081924f, -4.424e-5f, 3710.f, 3720.f,
				     6.6262f, .62697f, .0026483f, -1.7431e-5f, .0025461f, -2.1437e-5f,
				     3720.f, 3730.f, 11.503f, .6936f, -.001529f, -2.0568e-6f, -.0018176f,
				     -4.1926e-6f, 3730.f, 3740.f, 5.547f, .70735f, -.0036265f, 5.5723e-6f,
				     -.0039987f, 4.3869e-6f, 3740.f, 3750.f, 10.823f, .8515f, -.0028437f,
				     4.704e-6f, -.0029039f, 1.4795e-6f, 3750.f, 3760.f, 13.145f, .83989f,
				     2.3467e-4f, -7.519e-6f, 3.7066e-4f, -1.0406e-5f, 3760.f, 3770.f,
				     3.9192f, .87428f, .0073134f, -3.2311e-5f, .0084021f, -3.9596e-5f,
				     3770.f, 3780.f, .56238f, .59784f, .018114f, -8.3716e-5f, .016001f,
				     -8.226e-5f, 3780.f, 3790.f, 1.486f, .24352f, .011201f, -5.7941e-5f,
				     .0083855f, -5.3563e-5f, 3790.f, 3800.f, 5.7846f, .28312f, .0051402f,
				     -3.3968e-5f, .0020967f, -2.8941e-5f, 3800.f, 3810.f, 15.534f, .38502f,
				     2.6866e-4f, -1.3504e-5f, -.0010262f, -5.4149e-6f, 3810.f, 3820.f,
				     20.107f, .46654f, -.0028471f, 4.7046e-7f, -.0034091f, 7.0565e-6f,
				     3820.f, 3830.f, 9.6329f, .68399f, -.0033535f, 1.0816e-5f, -.0031945f,
				     9.1488e-6f, 3830.f, 3840.f, 28.782f, .76658f, -.0028915f, 1.4121e-6f,
				     -.0036898f, 2.7782e-6f, 3840.f, 3850.f, 22.068f, .72888f, .0013903f,
				     -1.6991e-5f, -3.5656e-4f, -1.6534e-5f, 3850.f, 3860.f, 4.1416f, 1.4182f,
				     .010989f, -5.3426e-5f, .0089392f, -5.1526e-5f, 3860.f, 3870.f, 1.386f,
				     1.0616f, .014465f, -7.035e-5f, .011642f, -6.6421e-5f, 3870.f, 3880.f,
				     .21981f, .827f, .023073f, -1.0318e-4f, .020793f, -1.0169e-4f, 3880.f,
				     3890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3890.f, 3900.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 3900.f, 3910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3910.f, 3920.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 3920.f, 3930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3930.f,
				     3940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3940.f, 3950.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 3950.f, 3960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3960.f, 3970.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 3970.f, 3980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3980.f,
				     3990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3990.f, 4e3f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4e3f, 4010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4010.f, 4020.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4020.f, 4030.f, .046381f, .22687f, .0024345f, -2.3816e-5f,
				     -7.0852e-4f, -1.7981e-5f, 4030.f, 4040.f, .11207f, .33988f, -.0013925f,
				     -8.515e-6f, -.0044315f, -2.7839e-6f, 4040.f, 4050.f, .26494f, .78086f,
				     7.5352e-4f, -1.0882e-5f, -.00225f, -8.0414e-6f, 4050.f, 4060.f, .52355f,
				     .95211f, -.003229f, -8.4991e-7f, -.0065316f, 5.7606e-6f, 4060.f, 4070.f,
				     .20288f, .51222f, -.0019356f, -5.8786e-6f, -.0049461f, -5.0049e-7f,
				     4070.f, 4080.f, .047528f, .22508f, .002968f, -2.5911e-5f, -1.9533e-4f,
				     -2.0081e-5f, 4080.f, 4090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4090.f, 4100.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4100.f, 4110.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4110.f, 4120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4120.f, 4130.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4130.f, 4140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4140.f,
				     4150.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4150.f, 4160.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4160.f, 4170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4170.f, 4180.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4180.f, 4190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4190.f,
				     4200.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4200.f, 4210.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4210.f, 4220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4220.f, 4230.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4230.f, 4240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4240.f,
				     4250.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4250.f, 4260.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4260.f, 4270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4270.f, 4280.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4280.f, 4290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4290.f,
				     4300.f,
				     .010261f, .065002f, .0034485f, -2.8392e-5f, 1.7191e-4f, -2.183e-5f,
				     4300.f, 4310.f, .084185f, .33064f, 1.571e-4f, -1.4472e-5f, -.0028838f,
				     -8.9966e-6f, 4310.f, 4320.f, .11106f, .39358f, -.0032422f, -1.3748e-6f,
				     -.006363f, 4.8743e-6f, 4320.f, 4330.f, .58854f, 1.3088f, -9.7669e-4f,
				     7.0381e-7f, -.0031832f, 2.6227e-6f, 4330.f, 4340.f, .25725f, 1.0051f,
				     .006086f, 4.6822e-5f, .0059645f, 6.3569e-6f, 4340.f, 4350.f, .46043f,
				     1.0822f, .014451f, -3.4551e-5f, .010783f, -4.3114e-5f, 4350.f, 4360.f,
				     1.0879f, .79314f, .015344f, -7.4899e-5f, .012327f, -6.9661e-5f, 4360.f,
				     4370.f, 2.8336f, .83143f, .010372f, -5.4787e-5f, .0077026f, -5.1069e-5f,
				     4370.f, 4380.f, 5.6315f, .55232f, .0048246f, -3.1963e-5f, .0030343f,
				     -3.1434e-5f, 4380.f, 4390.f, 11.627f, .66242f, .0012226f, -1.4669e-5f,
				     9.6618e-4f, -1.906e-5f, 4390.f, 4400.f, 18.357f, .81274f, -.0015078f,
				     2.8307e-6f, 3.021e-4f, -3.645e-6f, 4400.f, 4410.f, 8.1517f, .53727f,
				     -.0041588f, 8.2656e-6f, -.0039017f, 1.9754e-5f, 4410.f, 4420.f, 21.947f,
				     .50379f, -.0036693f, 3.4765e-7f, -.0068581f, 6.819e-6f, 4420.f, 4430.f,
				     21.321f, .70812f, .0014866f, -1.5888e-5f, -7.1958e-4f, -1.5047e-5f,
				     4430.f, 4440.f, .76039f, .46213f, .015813f, -7.1293e-5f, .014807f,
				     -7.4172e-5f, 4440.f, 4450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4450.f, 4460.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4460.f, 4470.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4470.f, 4480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4480.f, 4490.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4490.f, 4500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4500.f,
				     4510.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4510.f, 4520.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4520.f, 4530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4530.f, 4540.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4540.f, 4550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4550.f,
				     4560.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4560.f, 4570.f, .0027208f, .031363f,
				     .019608f,
				     -9.3071e-5f, .016446f, -8.6703e-5f, 4570.f, 4580.f, .075316f, .2673f,
				     .013852f, -6.7928e-5f, .01126f, -6.4664e-5f, 4580.f, 4590.f, .26478f,
				     .24916f, .0075261f, -4.3549e-5f, .0044923f, -3.8501e-5f, 4590.f, 4600.f,
				     .94057f, .32245f, .0019994f, -2.1568e-5f, -.0010356f, -1.639e-5f,
				     4600.f, 4610.f, 1.6283f, .34503f, -.002067f, -5.9246e-6f, -.0051076f,
				     -7.9763e-8f, 4610.f, 4620.f, 1.1361f, .39643f, -.0042841f, 2.5773e-6f,
				     -.007504f, 9.2053e-6f, 4620.f, 4630.f, 1.3595f, .42824f, -.0043267f,
				     2.7527e-6f, -.0075382f, 9.366e-6f, 4630.f, 4640.f, 2.345f, .5039f,
				     -.0013021f, -8.1896e-6f, -.0042803f, -3.1004e-6f, 4640.f, 4650.f,
				     .73444f, .57859f, .006112f, -3.3071e-5f, .0044533f, -3.3529e-5f, 4650.f,
				     4660.f, .038422f, .23935f, .02365f, -1.0589e-4f, .020573f, -1.0116e-4f,
				     4660.f, 4670.f, .16643f, .21059f, .017844f, -8.4429e-5f, .015076f,
				     -8.0351e-5f, 4670.f, 4680.f, .66361f, .33032f, .012376f, -5.9085e-5f,
				     .01164f, -5.974e-5f, 4680.f, 4690.f, 2.4086f, .4322f, .0069608f,
				     -3.6434e-5f, .0066271f, -3.8146e-5f, 4690.f, 4700.f, 5.7007f, .46363f,
				     .0024374f, -1.85e-5f, .0021804f, -2.0294e-5f, 4700.f, 4710.f, 11.243f,
				     .58097f, -.0013313f, -4.1463e-6f, -.001735f, -4.8882e-6f, 4710.f,
				     4720.f, 7.8568f, .66135f, -.0035465f, 4.3994e-6f, -.0041602f,
				     4.5248e-6f, 4720.f, 4730.f, 9.4234f, .73404f, -.0035684f, 4.612e-6f,
				     -.0040476f, 4.3652e-6f, 4730.f, 4740.f, 18.463f, 1.0659f, 1.1174e-6f,
				     -7.5689e-6f, -1.4938e-4f, -1.035e-5f, 4740.f, 4750.f, 2.9519f, .92577f,
				     .009335f, -4.0974e-5f, .010093f, -5.0109e-5f, 4750.f, 4760.f, 0.f, 0.f,
				     0.f, 0.f, 0.f, 0.f, 4760.f, 4770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4770.f,
				     4780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4780.f, 4790.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4790.f, 4800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4800.f, 4810.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4810.f, 4820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4820.f,
				     4830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4830.f, 4840.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4840.f, 4850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4850.f, 4860.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4860.f, 4870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4870.f,
				     4880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4880.f, 4890.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4890.f, 4900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4900.f, 4910.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4910.f, 4920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4920.f,
				     4930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4930.f, 4940.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4940.f, 4950.f, .057081f, .26504f, 2.1749e-4f, -1.4991e-5f,
				     -.0028657f, -9.2093e-6f, 4950.f, 4960.f, .089281f, .35365f, -.0029091f,
				     -2.6962e-6f, -.0059925f, 3.4121e-6f, 4960.f, 4970.f, .46911f, 1.1088f,
				     -.0015343f, -4.5097e-6f, -.0043859f, -9.5143e-7f, 4970.f, 4980.f,
				     .1858f, .71004f, 2.2264e-4f, 5.4082e-6f, -.0022981f, 3.4446e-7f, 4980.f,
				     4990.f, .30113f, .63162f, .0034248f, -2.4398e-5f, -2.019e-4f,
				     -1.8173e-5f, 4990.f, 5e3f, .54259f, .33048f, 1.4963e-4f, -1.4443e-5f,
				     -.0028875f, -8.9818e-6f, 5e3f, 5010.f, .69468f, .35696f, -.0031719f,
				     -1.6864e-6f, -.0062635f, 4.4718e-6f, 5010.f, 5020.f, .31258f, .41285f,
				     -.0047292f, 4.2957e-6f, -.0079123f, 1.0784e-5f, 5020.f, 5030.f, .9629f,
				     .50181f, -.0034905f, -3.0499e-7f, -.0066561f, 6.056e-6f, 5030.f, 5040.f,
				     .75559f, .535f, .0012181f, -1.6925e-5f, -.0015139f, -1.3577e-5f, 5040.f,
				     5050.f, .089652f, .35481f, .010413f, -5.3691e-5f, .0078717f,
				     -5.0854e-5f, 5050.f, 5060.f
    };

    /* nitrous oxide (2500 - 5050 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* niox1 */


void
meth6 (double a[8], const long int inu)
{


    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 15300.f, 15310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15310.f, 15320.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 15320.f, 15330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15330.f, 15340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15340.f, 15350.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15350.f, 15360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15360.f,
				     15370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15370.f, 15380.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15380.f, 15390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15390.f,
				     15400.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15400.f, 15410.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15410.f, 15420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15420.f, 15430.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15430.f, 15440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15440.f,
				     15450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15450.f, 15460.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15460.f, 15470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15470.f,
				     15480.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15480.f, 15490.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15490.f, 15500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15500.f, 15510.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15510.f, 15520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,

				     15520.f,

				     15530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15530.f, 15540.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15540.f, 15550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15550.f,
				     15560.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15560.f, 15570.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15570.f, 15580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15580.f, 15590.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15590.f, 15600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15600.f,
				     15610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15610.f, 15620.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15620.f, 15630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15630.f,
				     15640.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15640.f, 15650.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15650.f, 15660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15660.f, 15670.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15670.f, 15680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15680.f,
				     15690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15690.f, 15700.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15700.f, 15710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15710.f,
				     15720.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15720.f, 15730.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15730.f, 15740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15740.f, 15750.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15750.f, 15760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15760.f,
				     15770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15770.f, 15780.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15780.f, 15790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15790.f,
				     15800.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15800.f, 15810.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15810.f, 15820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15820.f, 15830.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15830.f, 15840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15840.f,
				     15850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15850.f, 15860.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15860.f, 15870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15870.f,
				     15880.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15880.f, 15890.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15890.f, 15900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15900.f, 15910.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15910.f, 15920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15920.f,
				     15930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15930.f, 15940.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15940.f, 15950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15950.f,
				     15960.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15960.f, 15970.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15970.f, 15980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15980.f, 15990.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15990.f, 1.6e4f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.6e4f,
				     16010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16010.f, 16020.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16020.f, 16030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16030.f,
				     16040.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16040.f, 16050.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16050.f, 16060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16060.f, 16070.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16070.f, 16080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16080.f,
				     16090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16090.f, 16100.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16100.f, 16110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16110.f,
				     16120.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16120.f, 16130.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16130.f, 16140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16140.f, 16150.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16150.f, 16160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16160.f,
				     16170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16170.f, 16180.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16180.f, 16190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16190.f,
				     16200.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16200.f, 16210.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16210.f, 16220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16220.f, 16230.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16230.f, 16240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16240.f,
				     16250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16250.f, 16260.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16260.f, 16270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16270.f,
				     16280.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16280.f, 16290.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16290.f, 16300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16300.f, 16310.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16310.f, 16320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16320.f,
				     16330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16330.f, 16340.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16340.f, 16350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16350.f,
				     16360.f,

				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16360.f, 16370.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16370.f, 16380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16380.f, 16390.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16390.f, 16400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16400.f,
				     16410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16410.f, 16420.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16420.f, 16430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16430.f,
				     16440.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16440.f, 16450.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16450.f, 16460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16460.f, 16470.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16470.f, 16480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16480.f,
				     16490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16490.f, 16500.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16500.f, 16510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16510.f,
				     16520.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16520.f, 16530.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16530.f, 16540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16540.f, 16550.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16550.f, 16560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16560.f,
				     16570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16570.f, 16580.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16580.f, 16590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16590.f,
				     16600.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16600.f, 16610.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16610.f, 16620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16620.f, 16630.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16630.f, 16640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16640.f,
				     16650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16650.f, 16660.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16660.f, 16670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16670.f,
				     16680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16680.f, 16690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16690.f, 16700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16700.f, 16710.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16710.f, 16720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16720.f,
				     16730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16730.f, 16740.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16740.f, 16750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16750.f,
				     16760.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16760.f, 16770.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16770.f, 16780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16780.f, 16790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16790.f, 16800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16800.f,
				     16810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16810.f, 16820.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16820.f, 16830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16830.f,
				     16840.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16840.f, 16850.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16850.f, 16860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16860.f, 16870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16870.f, 16880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16880.f,
				     16890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16890.f, 16900.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16900.f, 16910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16910.f,
				     16920.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16920.f, 16930.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16930.f, 16940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16940.f, 16950.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16950.f, 16960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16960.f,
				     16970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16970.f, 16980.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16980.f, 16990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16990.f, 1.7e4f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.7e4f, 17010.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17010.f, 17020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17020.f, 17030.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17030.f, 17040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17040.f,
				     17050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17050.f, 17060.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17060.f, 17070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17070.f,
				     17080.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17080.f, 17090.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17090.f, 17100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17100.f, 17110.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17110.f, 17120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17120.f,
				     17130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17130.f, 17140.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17140.f, 17150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17150.f,
				     17160.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17160.f, 17170.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17170.f, 17180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17180.f, 17190.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17190.f, 17200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17200.f,
				     17210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17210.f, 17220.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17220.f, 17230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17230.f,
				     17240.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17240.f, 17250.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17250.f, 17260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17260.f, 17270.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17270.f, 17280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17280.f,
				     17290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17290.f, 17300.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17300.f, 17310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17310.f,
				     17320.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17320.f, 17330.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17330.f, 17340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17340.f, 17350.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17350.f, 17360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17360.f,
				     17370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17370.f, 17380.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17380.f, 17390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17390.f,
				     17400.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17400.f, 17410.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17410.f, 17420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17420.f, 17430.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17430.f, 17440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17440.f,
				     17450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17450.f, 17460.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17460.f, 17470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17470.f,
				     17480.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17480.f, 17490.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17490.f, 17500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17500.f, 17510.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17510.f, 17520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17520.f,
				     17530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17530.f, 17540.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17540.f, 17550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17550.f,
				     17560.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17560.f, 17570.f, 0.f, 0.f, 0.f, 0.f, 0.f,

				     0.f,
				     17570.f, 17580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17580.f, 17590.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17590.f, 17600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17600.f,
				     17610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17610.f, 17620.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17620.f, 17630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17630.f,
				     17640.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17640.f, 17650.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17650.f, 17660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17660.f, 17670.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17670.f, 17680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17680.f,
				     17690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17690.f, 17700.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17700.f, 17710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17710.f,
				     17720.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17720.f, 17730.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17730.f, 17740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17740.f, 17750.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17750.f, 17760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17760.f,
				     17770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17770.f, 17780.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17780.f, 17790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17790.f,
				     17800.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17800.f, 17810.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17810.f, 17820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17820.f, 17830.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17830.f, 17840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17840.f,
				     17850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17850.f, 17860.f
    };

    /* methane (15300 - 17870 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* meth6 */

void
meth5 (double a[8], const long int inu)
{


    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 12740.f, 12750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12750.f, 12760.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 12760.f, 12770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12770.f, 12780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12780.f, 12790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12790.f, 12800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12800.f,
				     12810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12810.f, 12820.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12820.f, 12830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12830.f,
				     12840.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12840.f, 12850.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12850.f, 12860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12860.f, 12870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12870.f, 12880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12880.f,
				     12890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12890.f, 12900.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12900.f, 12910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12910.f,
				     12920.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12920.f, 12930.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12930.f, 12940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12940.f, 12950.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12950.f, 12960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12960.f,
				     12970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12970.f, 12980.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12980.f, 12990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12990.f, 1.3e4f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.3e4f, 13010.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13010.f, 13020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13020.f, 13030.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13030.f, 13040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13040.f,
				     13050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13050.f, 13060.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13060.f, 13070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13070.f,
				     13080.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13080.f, 13090.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13090.f, 13100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13100.f, 13110.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13110.f, 13120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13120.f,
				     13130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13130.f, 13140.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13140.f, 13150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13150.f,
				     13160.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13160.f, 13170.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13170.f, 13180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13180.f, 13190.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13190.f, 13200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13200.f,
				     13210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13210.f, 13220.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13220.f, 13230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13230.f,
				     13240.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13240.f, 13250.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13250.f, 13260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13260.f, 13270.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13270.f, 13280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13280.f,
				     13290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13290.f, 13300.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13300.f, 13310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13310.f,
				     13320.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13320.f, 13330.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13330.f, 13340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13340.f, 13350.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13350.f, 13360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13360.f,
				     13370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13370.f, 13380.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13380.f, 13390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13390.f,
				     13400.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13400.f, 13410.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13410.f, 13420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13420.f, 13430.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13430.f, 13440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13440.f,
				     13450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13450.f, 13460.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13460.f, 13470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13470.f,
				     13480.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13480.f, 13490.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13490.f, 13500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13500.f, 13510.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13510.f, 13520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13520.f,
				     13530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13530.f, 13540.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13540.f, 13550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13550.f,
				     13560.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13560.f, 13570.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13570.f, 13580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13580.f, 13590.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13590.f, 13600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13600.f,
				     13610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13610.f, 13620.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13620.f, 13630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13630.f,
				     13640.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13640.f, 13650.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13650.f, 13660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13660.f, 13670.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13670.f, 13680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13680.f,
				     13690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13690.f, 13700.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13700.f, 13710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13710.f,
				     13720.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13720.f, 13730.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13730.f, 13740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13740.f, 13750.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13750.f, 13760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13760.f,
				     13770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13770.f, 13780.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13780.f, 13790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13790.f,
				     13800.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13800.f, 13810.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13810.f, 13820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13820.f, 13830.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13830.f, 13840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13840.f,
				     13850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13850.f, 13860.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13860.f, 13870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13870.f,
				     13880.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13880.f, 13890.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,

				     13890.f, 13900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13900.f, 13910.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13910.f, 13920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13920.f,
				     13930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13930.f, 13940.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13940.f, 13950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13950.f,
				     13960.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13960.f, 13970.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13970.f, 13980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13980.f, 13990.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13990.f, 1.4e4f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.4e4f,
				     14010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14010.f, 14020.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14020.f, 14030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14030.f,
				     14040.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14040.f, 14050.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14050.f, 14060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14060.f, 14070.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14070.f, 14080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14080.f,
				     14090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14090.f, 14100.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14100.f, 14110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14110.f,
				     14120.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14120.f, 14130.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14130.f, 14140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14140.f, 14150.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14150.f, 14160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14160.f,
				     14170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14170.f, 14180.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14180.f, 14190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14190.f,
				     14200.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14200.f, 14210.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14210.f, 14220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14220.f, 14230.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14230.f, 14240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14240.f,
				     14250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14250.f, 14260.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14260.f, 14270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14270.f,
				     14280.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14280.f, 14290.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14290.f, 14300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14300.f, 14310.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14310.f, 14320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14320.f,
				     14330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14330.f, 14340.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14340.f, 14350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14350.f,
				     14360.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14360.f, 14370.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14370.f, 14380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14380.f, 14390.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14390.f, 14400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14400.f,
				     14410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14410.f, 14420.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14420.f, 14430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14430.f,
				     14440.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14440.f, 14450.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14450.f, 14460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14460.f, 14470.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14470.f, 14480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14480.f,
				     14490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14490.f, 14500.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14500.f, 14510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14510.f,
				     14520.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14520.f, 14530.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14530.f, 14540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14540.f, 14550.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14550.f, 14560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14560.f,
				     14570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14570.f, 14580.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14580.f, 14590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14590.f,
				     14600.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14600.f, 14610.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14610.f, 14620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14620.f, 14630.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14630.f, 14640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14640.f,
				     14650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14650.f, 14660.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14660.f, 14670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14670.f,
				     14680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14680.f, 14690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14690.f, 14700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14700.f, 14710.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14710.f, 14720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14720.f,

				     14730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14730.f, 14740.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14740.f, 14750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14750.f,
				     14760.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14760.f, 14770.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14770.f, 14780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14780.f, 14790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14790.f, 14800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14800.f,
				     14810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14810.f, 14820.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14820.f, 14830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14830.f,
				     14840.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14840.f, 14850.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14850.f, 14860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14860.f, 14870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14870.f, 14880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14880.f,
				     14890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14890.f, 14900.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14900.f, 14910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14910.f,
				     14920.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14920.f, 14930.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14930.f, 14940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14940.f, 14950.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14950.f, 14960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14960.f,
				     14970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14970.f, 14980.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14980.f, 14990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14990.f, 1.5e4f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.5e4f, 15010.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15010.f, 15020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15020.f, 15030.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15030.f, 15040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15040.f,
				     15050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15050.f, 15060.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15060.f, 15070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15070.f,
				     15080.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15080.f, 15090.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15090.f, 15100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15100.f, 15110.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15110.f, 15120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15120.f,
				     15130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15130.f, 15140.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15140.f, 15150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15150.f,
				     15160.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15160.f, 15170.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15170.f, 15180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15180.f, 15190.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15190.f, 15200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15200.f,
				     15210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15210.f, 15220.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15220.f, 15230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15230.f,
				     15240.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15240.f, 15250.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15250.f, 15260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15260.f, 15270.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15270.f, 15280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15280.f,
				     15290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15290.f, 15300.f
    };

    /* methane (12740 - 15290 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* meth5 */

void
meth4 (double a[8], const long int inu)
{


    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 10180.f, 10190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10190.f, 10200.f,
				     0.f,

				     0.f, 0.f, 0.f, 0.f, 0.f, 10200.f, 10210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10210.f, 10220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10220.f, 10230.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10230.f, 10240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10240.f,
				     10250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10250.f, 10260.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10260.f, 10270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10270.f,
				     10280.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10280.f, 10290.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10290.f, 10300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10300.f, 10310.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10310.f, 10320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10320.f,
				     10330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10330.f, 10340.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10340.f, 10350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10350.f,
				     10360.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10360.f, 10370.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10370.f, 10380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10380.f, 10390.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10390.f, 10400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10400.f,
				     10410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10410.f, 10420.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10420.f, 10430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10430.f,
				     10440.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10440.f, 10450.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10450.f, 10460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10460.f, 10470.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10470.f, 10480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10480.f,
				     10490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10490.f, 10500.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10500.f, 10510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10510.f,
				     10520.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10520.f, 10530.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10530.f, 10540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10540.f, 10550.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10550.f, 10560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10560.f,
				     10570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10570.f, 10580.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10580.f, 10590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10590.f,
				     10600.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10600.f, 10610.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10610.f, 10620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10620.f, 10630.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10630.f, 10640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10640.f,
				     10650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10650.f, 10660.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10660.f, 10670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10670.f,
				     10680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10680.f, 10690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10690.f, 10700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10700.f, 10710.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10710.f, 10720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10720.f,
				     10730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10730.f, 10740.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10740.f, 10750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10750.f,
				     10760.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10760.f, 10770.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10770.f, 10780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10780.f, 10790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10790.f, 10800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10800.f,
				     10810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10810.f, 10820.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10820.f, 10830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10830.f,
				     10840.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10840.f, 10850.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10850.f, 10860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10860.f, 10870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10870.f, 10880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10880.f,
				     10890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10890.f, 10900.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10900.f, 10910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10910.f,
				     10920.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10920.f, 10930.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10930.f, 10940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10940.f, 10950.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10950.f, 10960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10960.f,
				     10970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10970.f, 10980.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10980.f, 10990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10990.f, 1.1e4f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.1e4f, 11010.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11010.f, 11020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11020.f, 11030.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11030.f, 11040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11040.f,
				     11050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11050.f, 11060.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11060.f, 11070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11070.f,
				     11080.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11080.f, 11090.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11090.f, 11100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11100.f, 11110.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11110.f, 11120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11120.f,
				     11130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11130.f, 11140.f, 0.f, 0.f, 0.f,
				     0.f,

				     0.f, 0.f, 11140.f, 11150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11150.f,
				     11160.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11160.f, 11170.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11170.f, 11180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11180.f, 11190.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11190.f, 11200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11200.f,
				     11210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11210.f, 11220.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11220.f, 11230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11230.f,
				     11240.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11240.f, 11250.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11250.f, 11260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11260.f, 11270.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11270.f, 11280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11280.f,
				     11290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11290.f, 11300.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11300.f, 11310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11310.f,
				     11320.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11320.f, 11330.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11330.f, 11340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11340.f, 11350.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11350.f, 11360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11360.f,
				     11370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11370.f, 11380.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11380.f, 11390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11390.f,
				     11400.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11400.f, 11410.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11410.f, 11420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11420.f, 11430.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11430.f, 11440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11440.f,
				     11450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11450.f, 11460.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11460.f, 11470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11470.f,
				     11480.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11480.f, 11490.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11490.f, 11500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11500.f, 11510.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11510.f, 11520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11520.f,
				     11530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11530.f, 11540.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11540.f, 11550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11550.f,
				     11560.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11560.f, 11570.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11570.f, 11580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11580.f, 11590.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11590.f, 11600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11600.f,
				     11610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11610.f, 11620.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11620.f, 11630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11630.f,
				     11640.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11640.f, 11650.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11650.f, 11660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11660.f, 11670.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11670.f, 11680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11680.f,
				     11690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11690.f, 11700.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11700.f, 11710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11710.f,
				     11720.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11720.f, 11730.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11730.f, 11740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11740.f, 11750.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11750.f, 11760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11760.f,
				     11770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11770.f, 11780.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11780.f, 11790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11790.f,
				     11800.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11800.f, 11810.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11810.f, 11820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11820.f, 11830.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11830.f, 11840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11840.f,
				     11850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11850.f, 11860.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11860.f, 11870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11870.f,
				     11880.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11880.f, 11890.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11890.f, 11900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11900.f, 11910.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11910.f, 11920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11920.f,
				     11930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11930.f, 11940.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11940.f, 11950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11950.f,
				     11960.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11960.f, 11970.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11970.f, 11980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11980.f, 11990.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11990.f, 1.2e4f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.2e4f,
				     12010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12010.f, 12020.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12020.f, 12030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12030.f,
				     12040.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12040.f, 12050.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12050.f, 12060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12060.f, 12070.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12070.f, 12080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12080.f,
				     12090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12090.f, 12100.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12100.f, 12110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12110.f,
				     12120.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12120.f, 12130.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12130.f, 12140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12140.f, 12150.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12150.f, 12160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12160.f,
				     12170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12170.f, 12180.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12180.f, 12190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12190.f,
				     12200.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12200.f, 12210.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12210.f, 12220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12220.f, 12230.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12230.f, 12240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12240.f,
				     12250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12250.f, 12260.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12260.f, 12270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12270.f,
				     12280.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12280.f, 12290.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12290.f, 12300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12300.f, 12310.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12310.f, 12320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12320.f,
				     12330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12330.f, 12340.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12340.f, 12350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12350.f,
				     12360.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12360.f, 12370.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12370.f, 12380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12380.f, 12390.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12390.f, 12400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12400.f,
				     12410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12410.f, 12420.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12420.f, 12430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12430.f,
				     12440.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12440.f, 12450.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12450.f, 12460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12460.f, 12470.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12470.f, 12480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12480.f,
				     12490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12490.f, 12500.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12500.f, 12510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12510.f,
				     12520.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12520.f, 12530.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12530.f, 12540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12540.f, 12550.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12550.f, 12560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12560.f,
				     12570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12570.f, 12580.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12580.f, 12590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12590.f,
				     12600.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12600.f, 12610.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12610.f, 12620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12620.f, 12630.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12630.f, 12640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12640.f,
				     12650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12650.f, 12660.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12660.f, 12670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12670.f,
				     12680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12680.f, 12690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12690.f, 12700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12700.f, 12710.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12710.f, 12720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12720.f,
				     12730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12730.f, 12740.f
    };

    /* methane (10180 - 12730 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* meth4 */

void
meth3 (double a[8], const long int inu)
{


    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 7620.f, 7630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7630.f, 7640.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7640.f, 7650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7650.f,
				     7660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7660.f, 7670.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7670.f, 7680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7680.f, 7690.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7690.f, 7700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7700.f,
				     7710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7710.f, 7720.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7720.f, 7730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7730.f, 7740.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7740.f, 7750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7750.f,
				     7760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7760.f, 7770.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7770.f, 7780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7780.f, 7790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7790.f, 7800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7800.f,
				     7810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7810.f, 7820.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7820.f, 7830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7830.f, 7840.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7840.f, 7850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7850.f,
				     7860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7860.f, 7870.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7870.f, 7880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7880.f, 7890.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7890.f, 7900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7900.f,
				     7910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7910.f, 7920.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7920.f, 7930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7930.f, 7940.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7940.f, 7950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7950.f,
				     7960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7960.f, 7970.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7970.f, 7980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7980.f, 7990.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7990.f, 8e3f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8e3f,
				     8010.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8010.f, 8020.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8020.f, 8030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8030.f, 8040.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8040.f, 8050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8050.f,
				     8060.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8060.f, 8070.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8070.f, 8080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8080.f, 8090.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8090.f, 8100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8100.f,
				     8110.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8110.f, 8120.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8120.f, 8130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8130.f, 8140.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8140.f, 8150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8150.f,
				     8160.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8160.f, 8170.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8170.f, 8180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8180.f, 8190.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8190.f, 8200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8200.f,
				     8210.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8210.f, 8220.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8220.f, 8230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8230.f, 8240.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8240.f, 8250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8250.f,
				     8260.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8260.f, 8270.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8270.f, 8280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8280.f, 8290.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8290.f, 8300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8300.f,
				     8310.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8310.f, 8320.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8320.f, 8330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8330.f, 8340.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8340.f, 8350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8350.f,
				     8360.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8360.f, 8370.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8370.f, 8380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8380.f, 8390.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8390.f, 8400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8400.f,
				     8410.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8410.f, 8420.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8420.f, 8430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8430.f, 8440.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8440.f, 8450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8450.f,
				     8460.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8460.f, 8470.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8470.f, 8480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8480.f, 8490.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8490.f, 8500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8500.f,
				     8510.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8510.f, 8520.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8520.f, 8530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8530.f, 8540.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8540.f, 8550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8550.f,
				     8560.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8560.f, 8570.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8570.f, 8580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8580.f, 8590.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8590.f, 8600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8600.f,
				     8610.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8610.f, 8620.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8620.f, 8630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8630.f, 8640.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8640.f, 8650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8650.f,
				     8660.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8660.f, 8670.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8670.f, 8680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8680.f, 8690.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8690.f, 8700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8700.f,
				     8710.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8710.f, 8720.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8720.f, 8730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8730.f, 8740.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8740.f, 8750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8750.f,
				     8760.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8760.f, 8770.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8770.f, 8780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8780.f, 8790.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8790.f, 8800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8800.f,
				     8810.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8810.f, 8820.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8820.f, 8830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8830.f, 8840.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8840.f, 8850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8850.f,
				     8860.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8860.f, 8870.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8870.f, 8880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8880.f, 8890.f, 0.f, 0.f,
				     0.f,

				     0.f, 0.f, 0.f, 8890.f, 8900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8900.f,
				     8910.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8910.f, 8920.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8920.f, 8930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8930.f, 8940.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8940.f, 8950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8950.f,
				     8960.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8960.f, 8970.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8970.f, 8980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8980.f, 8990.f, 0.f, 0.f,
				     0.f,

				     0.f, 0.f, 0.f, 8990.f, 9e3f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9e3f, 9010.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 9010.f, 9020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     9020.f,
				     9030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9030.f, 9040.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9040.f, 9050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9050.f, 9060.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9060.f, 9070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9070.f,
				     9080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9080.f, 9090.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9090.f, 9100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9100.f, 9110.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9110.f, 9120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9120.f,
				     9130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9130.f, 9140.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9140.f, 9150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9150.f, 9160.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9160.f, 9170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9170.f,
				     9180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9180.f, 9190.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9190.f, 9200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9200.f, 9210.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9210.f, 9220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9220.f,
				     9230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9230.f, 9240.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9240.f, 9250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9250.f, 9260.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9260.f, 9270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9270.f,
				     9280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9280.f, 9290.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9290.f, 9300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9300.f, 9310.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9310.f, 9320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9320.f,
				     9330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9330.f, 9340.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9340.f, 9350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9350.f, 9360.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9360.f, 9370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9370.f,
				     9380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9380.f, 9390.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9390.f, 9400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9400.f, 9410.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9410.f, 9420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9420.f,
				     9430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9430.f, 9440.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9440.f, 9450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9450.f, 9460.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9460.f, 9470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9470.f,
				     9480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9480.f, 9490.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9490.f, 9500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9500.f, 9510.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9510.f, 9520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9520.f,
				     9530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9530.f, 9540.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9540.f, 9550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9550.f, 9560.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9560.f, 9570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9570.f,
				     9580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9580.f, 9590.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9590.f, 9600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9600.f, 9610.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9610.f, 9620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9620.f,
				     9630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9630.f, 9640.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9640.f, 9650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9650.f, 9660.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9660.f, 9670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9670.f,
				     9680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9680.f, 9690.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9690.f, 9700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9700.f, 9710.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9710.f, 9720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9720.f,
				     9730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9730.f, 9740.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9740.f, 9750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9750.f, 9760.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9760.f, 9770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9770.f,
				     9780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9780.f, 9790.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9790.f, 9800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9800.f, 9810.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9810.f, 9820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9820.f,
				     9830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9830.f, 9840.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9840.f, 9850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9850.f, 9860.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9860.f, 9870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9870.f,
				     9880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9880.f, 9890.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9890.f, 9900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9900.f, 9910.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9910.f, 9920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9920.f,
				     9930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9930.f, 9940.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9940.f, 9950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9950.f, 9960.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9960.f, 9970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9970.f,
				     9980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9980.f, 9990.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9990.f, 1e4f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1e4f, 10010.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 10010.f, 10020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10020.f,
				     10030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10030.f, 10040.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10040.f, 10050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10050.f,
				     10060.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10060.f, 10070.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10070.f, 10080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10080.f, 10090.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10090.f, 10100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10100.f,
				     10110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10110.f, 10120.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10120.f, 10130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10130.f,
				     10140.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10140.f, 10150.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10150.f, 10160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10160.f, 10170.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10170.f, 10180.f
    };

    /* methane (7620 - 10170 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* meth3 */

void
meth2 (double a[8], const long int inu)
{


    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 5060.f, 5070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5070.f, 5080.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5080.f, 5090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5090.f,
				     5100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5100.f, 5110.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5110.f, 5120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5120.f, 5130.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5130.f, 5140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5140.f,
				     5150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5150.f, 5160.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5160.f, 5170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5170.f, 5180.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5180.f, 5190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5190.f,
				     5200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5200.f, 5210.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5210.f, 5220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5220.f, 5230.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5230.f, 5240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5240.f,
				     5250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5250.f, 5260.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5260.f, 5270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5270.f, 5280.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5280.f, 5290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5290.f,
				     5300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5300.f, 5310.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5310.f, 5320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5320.f, 5330.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5330.f, 5340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5340.f,
				     5350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5350.f, 5360.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5360.f, 5370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5370.f, 5380.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5380.f, 5390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5390.f,
				     5400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5400.f, 5410.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5410.f, 5420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5420.f, 5430.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5430.f, 5440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5440.f,
				     5450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5450.f, 5460.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5460.f, 5470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5470.f, 5480.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5480.f, 5490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5490.f,
				     5500.f, .50197f, .25265f, .0033519f, -2.4607e-5f, 6.8955e-4f,
				     -2.0482e-5f, 5500.f, 5510.f, 2.3899f, .60596f, 2.7671e-5f, -1.2307e-5f,
				     -.0033058f, -5.2945e-6f, 5510.f, 5520.f, 2.4379f, .30699f, -6.0867e-4f,
				     -9.0704e-6f, -.0032892f, -5.0115e-6f, 5520.f, 5530.f, 2.1592f, .38949f,
				     -.0023556f, -3.3022e-6f, -.0052838f, 2.4513e-6f, 5530.f, 5540.f,
				     2.3029f, .15736f, -.0035795f, 2.1673e-6f, -.005968f, 6.0863e-6f, 5540.f,
				     5550.f, 1.954f, .11711f, -.0044087f, 5.103e-6f, -.0068665f, 9.1701e-6f,
				     5550.f, 5560.f, 1.195f, .29396f, -.0010618f, 3.4067e-6f, -.0024231f,
				     -2.582e-6f, 5560.f, 5570.f, 4.8095f, 1.2465f, .0019344f, -1.5456e-5f,
				     -6.8788e-4f, -1.287e-5f, 5570.f, 5580.f, 11.674f, 1.5114f, -.0025504f,
				     8.25e-7f, -.0045912f, 2.2777e-6f, 5580.f, 5590.f, 2.3702f, .84024f,
				     -8.2688e-4f, 2.9123e-6f, -.0020134f, -5.0547e-6f, 5590.f, 5600.f,
				     3.4064f, 1.1326f, -.0025002f, 8.9997e-7f, -.0048837f, 2.6082e-6f,
				     5600.f, 5610.f, 1.7392f, .31991f, -.0045126f, 8.6603e-6f, -.0061278f,
				     9.3747e-6f, 5610.f, 5620.f, 4.348f, .58786f, -.0043137f, 4.6334e-6f,
				     -.0070133f, 9.529e-6f, 5620.f, 5630.f, 6.6586f, 1.8023f, -.0019866f,
				     -1.5163e-6f, -.0039533f, -8.5993e-7f, 5630.f, 5640.f, 4.3959f, .91267f,
				     -.0018359f, -2.6379e-6f, -.0045115f, 1.3137e-6f, 5640.f, 5650.f,
				     2.9732f, .90097f, -4.5783e-4f, -8.654e-6f, -.0035958f, -2.8318e-6f,
				     5650.f, 5660.f, 2.7758f, .82876f, .0019221f, -1.4165e-5f, -.0010447f,
				     -1.1375e-5f, 5660.f, 5670.f, 1.4345f, .92016f, .0046313f, -1.9911e-5f,
				     .0018272f, -2.0246e-5f, 5670.f, 5680.f, 1.0486f, .4465f, -3.8086e-4f,
				     5.6985e-6f, -.0018929f, -1.1857e-6f, 5680.f, 5690.f, .94797f, .35596f,
				     -2.2904e-4f, 8.4588e-6f, -.0016889f, -3.7956e-7f, 5690.f, 5700.f,
				     .93528f, .41431f, .00128f, -8.7918e-7f, -.0014444f, -4.7052e-6f, 5700.f,
				     5710.f, 1.6454f, .57474f, .0026463f, -1.3124e-5f, -3.7027e-4f,
				     -1.2452e-5f, 5710.f, 5720.f, 2.0351f, .34637f, .0026986f, -1.9613e-5f,
				     -4.6781e-4f, -1.4709e-5f, 5720.f, 5730.f, 2.2445f, .69714f, .0019373f,
				     -1.6752e-5f, -8.5242e-4f, -1.2956e-5f, 5730.f, 5740.f, 3.2153f, .75956f,

				     .0013362f, -1.4189e-5f, -.0010894f, -1.1571e-5f, 5740.f, 5750.f,
				     3.4596f, .73536f, .0012876f, -1.2547e-5f, -4.537e-4f, -1.2912e-5f,
				     5750.f, 5760.f, 4.9414f, 1.0526f, 6.4547e-4f, -1.0024e-5f, -9.6857e-4f,
				     -1.1592e-5f, 5760.f, 5770.f, 7.5119f, 1.41f, 2.8819e-4f, -7.444e-6f,
				     -.0012786f, -1.0307e-5f, 5770.f, 5780.f, 7.5235f, 1.323f, -4.9407e-4f,
				     -6.8773e-6f, -.002629f, -6.638e-6f, 5780.f, 5790.f, 10.241f, 1.6323f,
				     -.0013776f, -5.3214e-6f, -.0037904f, -2.3185e-6f, 5790.f, 5800.f,
				     9.1281f, .93597f, -.0035876f, 2.3809e-6f, -.0059879f, 5.9495e-6f,
				     5800.f, 5810.f, 3.9872f, .6767f, -.0044503f, 6.8501e-6f, -.0067178f,
				     9.7535e-6f, 5810.f, 5820.f, 2.9318f, .24918f, -.0051233f, 7.7265e-6f,
				     -.0076555f, 1.1663e-5f, 5820.f, 5830.f, 3.6596f, .91227f, -.0026988f,
				     2.3063e-6f, -.0047124f, 2.5366e-6f, 5830.f, 5840.f, 6.9904f, .93296f,
				     -.0037966f, 6.1051e-6f, -.0055025f, 7.3047e-6f, 5840.f, 5850.f, 12.815f,
				     1.9354f, -.0021432f, 8.1298e-7f, -.0042246f, 2.2902e-6f, 5850.f, 5860.f,
				     10.246f, 2.1238f, 4.6316e-5f, -6.0726e-6f, -.00223f, -5.3836e-6f,
				     5860.f, 5870.f, 9.5647f, 1.9821f, .0012796f, -7.4626e-6f, -9.2616e-4f,
				     -1.0886e-5f, 5870.f, 5880.f, 4.8776f, 1.7308f, .0012461f, -8.1397e-6f,
				     -5.6127e-5f, -1.3882e-5f, 5880.f, 5890.f, 5.7337f, .87446f, .0038286f,
				     -1.704e-5f, 6.941e-4f, -1.573e-5f, 5890.f, 5900.f, 7.472f, .73641f,
				     .0028865f, -2.0558e-5f, -6.6892e-4f, -1.358e-5f, 5900.f, 5910.f,
				     7.0944f, .66112f, .0024095f, -2.1458e-5f, -9.9935e-4f, -1.3636e-5f,
				     5910.f, 5920.f, 8.1168f, .58477f, .0013314f, -1.7142e-5f, -.0010021f,
				     -1.3588e-5f, 5920.f, 5930.f, 10.972f, .47138f, -3.0541e-4f, -9.6826e-6f,
				     -.0014478f, -9.657e-6f, 5930.f, 5940.f, 7.3055f, .38828f, -.0015833f,
				     -3.9472e-6f, -.0024534f, -5.2105e-6f, 5940.f, 5950.f, .18257f, .15141f,
				     .0032545f, -2.5286e-5f, 3.2305e-4f, -1.9965e-5f, 5950.f, 5960.f, 8.803f,
				     .28605f, -.0031163f, 1.3762e-6f, -.0040606f, 1.0755e-6f, 5960.f, 5970.f,
				     6.8729f, .20493f, -.0040682f, 5.468e-6f, -.004767f, 4.3804e-6f, 5970.f,
				     5980.f, 2.9955f, .47987f, -.002474f, 9.9034e-6f, -8.4087e-4f,
				     -7.5046e-6f, 5980.f, 5990.f, 14.364f, 1.4135f, .0066597f, -3.1277e-5f,
				     .0045742f, -3.1988e-5f, 5990.f, 6e3f, 65.167f, .97529f, -.0019616f,
				     -2.2633e-6f, -.0046527f, 1.0271e-6f, 6e3f, 6010.f, 3.5647f, .20344f,
				     -.0052252f, 1.0688e-5f, -.0057674f, 8.0346e-6f, 6010.f, 6020.f, 3.4141f,
				     .14357f, -.0054304f, 9.5186e-6f, -.0072736f, 1.143e-5f, 6020.f, 6030.f,
				     7.635f, .4332f, -.0031157f, 1.3276e-5f, -.001277f, 1.7678e-7f, 6030.f,
				     6040.f, 16.118f, .28374f, -.0041664f, 4.9599e-6f, -.0056931f,
				     5.7765e-6f, 6040.f, 6050.f, 19.177f, .33833f, -.0035167f, 1.7094e-6f,
				     -.0061198f, 6.6957e-6f, 6050.f, 6060.f, 16.85f, .88879f, -.002146f,
				     -3.2028e-6f, -.0042847f, 2.7277e-7f, 6060.f, 6070.f, 21.077f, .25352f,
				     -9.3983e-4f, -9.0824e-6f, -.0038178f, -2.813e-6f, 6070.f, 6080.f,
				     14.763f, .2437f, 5.8706e-4f, -1.4814e-5f, -.0030455f, -5.893e-6f,
				     6080.f, 6090.f, 12.16f, .31237f, .002521f, -2.1431e-5f, -.0011996f,
				     -1.1964e-5f, 6090.f, 6100.f, 10.601f, .42935f, .0043443f, -2.7697e-5f,
				     3.1712e-4f, -1.7641e-5f, 6100.f, 6110.f, 7.7832f, .54373f, .0057906f,
				     -2.6532e-5f, .001438f, -1.9125e-5f, 6110.f, 6120.f, 5.7902f, 1.1869f,
				     .0054008f, -1.8503e-5f, .0023381f, -2.0741e-5f, 6120.f, 6130.f, 4.0292f,
				     .58128f, .0079694f, -2.4981e-5f, .0032731f, -2.2237e-5f, 6130.f, 6140.f,
				     3.0446f, .82071f, .0077456f, -1.3929e-5f, .0053212f, -2.5965e-5f,
				     6140.f, 6150.f, 1.9431f, .98831f, .006064f, -2.2019e-5f, .0032998f,
				     -2.4905e-5f, 6150.f, 6160.f, .97862f, .77724f, .0073198f, -3.3144e-5f,
				     .0043341f, -3.23e-5f, 6160.f, 6170.f, .41035f, .31003f, .0044331f,
				     -2.7381e-5f, .0019194f, -2.471e-5f, 6170.f, 6180.f, .19122f, .12211f,
				     .0046368f, -3.0314e-5f, .0017315f, -2.5376e-5f, 6180.f, 6190.f, 0.f, 0.f,
				     0.f, 0.f, 0.f, 0.f, 6190.f, 6200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6200.f,
				     6210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6210.f, 6220.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6220.f, 6230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6230.f, 6240.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6240.f, 6250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6250.f,
				     6260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6260.f, 6270.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6270.f, 6280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6280.f, 6290.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6290.f, 6300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6300.f,
				     6310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6310.f, 6320.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6320.f, 6330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6330.f, 6340.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6340.f, 6350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6350.f,
				     6360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6360.f, 6370.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6370.f, 6380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6380.f, 6390.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6390.f, 6400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6400.f,
				     6410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6410.f, 6420.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6420.f, 6430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6430.f, 6440.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6440.f, 6450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6450.f,
				     6460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6460.f, 6470.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6470.f, 6480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6480.f, 6490.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6490.f, 6500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6500.f,
				     6510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6510.f, 6520.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6520.f, 6530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6530.f, 6540.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6540.f, 6550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6550.f,
				     6560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6560.f, 6570.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6570.f, 6580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6580.f, 6590.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6590.f, 6600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6600.f,
				     6610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6610.f, 6620.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6620.f, 6630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6630.f, 6640.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6640.f, 6650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6650.f,
				     6660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6660.f, 6670.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6670.f, 6680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6680.f, 6690.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6690.f, 6700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6700.f,
				     6710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6710.f, 6720.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6720.f, 6730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6730.f, 6740.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6740.f, 6750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6750.f,
				     6760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6760.f, 6770.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6770.f, 6780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6780.f, 6790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6790.f, 6800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6800.f,
				     6810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6810.f, 6820.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6820.f, 6830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6830.f, 6840.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6840.f, 6850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6850.f,
				     6860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6860.f, 6870.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6870.f, 6880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6880.f, 6890.f, 0.f,
				     0.f,

				     0.f, 0.f, 0.f, 0.f, 6890.f, 6900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6900.f,
				     6910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6910.f, 6920.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6920.f, 6930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6930.f, 6940.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6940.f, 6950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6950.f,
				     6960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6960.f, 6970.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6970.f, 6980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6980.f, 6990.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6990.f, 7e3f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7e3f,
				     7010.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7010.f, 7020.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7020.f, 7030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7030.f, 7040.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7040.f, 7050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7050.f,
				     7060.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7060.f, 7070.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7070.f, 7080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7080.f, 7090.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7090.f, 7100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7100.f,
				     7110.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7110.f, 7120.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7120.f, 7130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7130.f, 7140.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7140.f, 7150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7150.f,
				     7160.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7160.f, 7170.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7170.f, 7180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7180.f, 7190.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7190.f, 7200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7200.f,
				     7210.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7210.f, 7220.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7220.f, 7230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7230.f, 7240.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7240.f, 7250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7250.f,
				     7260.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7260.f, 7270.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7270.f, 7280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7280.f, 7290.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7290.f, 7300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7300.f,
				     7310.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7310.f, 7320.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7320.f, 7330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7330.f, 7340.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7340.f, 7350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7350.f,
				     7360.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7360.f, 7370.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7370.f, 7380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7380.f, 7390.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7390.f, 7400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7400.f,
				     7410.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7410.f, 7420.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7420.f, 7430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7430.f, 7440.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7440.f, 7450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7450.f,
				     7460.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7460.f, 7470.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7470.f, 7480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7480.f, 7490.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7490.f, 7500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7500.f,
				     7510.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7510.f, 7520.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7520.f, 7530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7530.f, 7540.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7540.f, 7550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7550.f,
				     7560.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7560.f, 7570.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7570.f, 7580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7580.f, 7590.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7590.f, 7600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7600.f,
				     7610.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7610.f, 7620.f
    };

    /* methane (5060 - 7610 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* meth2 */

void
meth1 (double a[8], const long int inu)
{


    static const float acr[2048] = { 1.4454f, .47807f,
				     .0052823f, -3.0056e-5f, .002903f, -2.686e-5f, 2500.f, 2510.f, 8.7736f,
				     .49348f, 3.8511e-4f, -6.0533e-6f, 1.0891e-4f, -9.3895e-6f, 2510.f,
				     2520.f, 5.7188f, .51082f, 3.239e-4f, -7.2399e-6f, 1.6424e-4f,
				     -1.0608e-5f, 2520.f, 2530.f, 4.5159f, .73333f, 5.5152e-4f, -2.5526e-6f,
				     2.6319e-4f, -1.1149e-5f, 2530.f, 2540.f, 6.2089f, .57459f, -5.1671e-5f,
				     -3.2924e-6f, -.0012056f, -7.7167e-6f, 2540.f, 2550.f, 9.8841f, .5111f,
				     -.0015575f, 1.7182e-6f, -.001203f, -3.8007e-6f, 2550.f, 2560.f, 7.6169f,
				     .80719f, 1.2985e-4f, -5.7517e-6f, -.0011789f, -6.7688e-6f, 2560.f,
				     2570.f, 7.3766f, .91538f, -6.9626e-4f, -9.8403e-8f, -.0010951f,
				     -5.6422e-6f, 2570.f, 2580.f, 7.9669f, 1.0249f, -.0020553f, 6.0631e-6f,
				     -.0025043f, 1.2199e-6f, 2580.f, 2590.f, 12.942f, 1.8227f, .0016813f,
				     -1.019e-5f, 8.4177e-4f, -1.3848e-5f, 2590.f, 2600.f, 11.671f, .93909f,
				     -.0023388f, 7.1737e-6f, -.0030848f, 1.0079e-5f, 2600.f, 2610.f, 7.682f,
				     .22382f, -.0036797f, 1.7419e-5f, -.002062f, 2.0955e-5f, 2610.f, 2620.f,
				     5.628f, .56037f, -.0012398f, 1.026e-5f, -.001454f, 8.1367e-6f, 2620.f,
				     2630.f, 14.127f, 1.2843f, 7.6229e-5f, 5.7331e-6f, -6.8637e-4f,
				     -4.6206e-6f, 2630.f, 2640.f, 9.0425f, 1.3886f, .0042412f, 2.3021e-6f,
				     .0040176f, -2.0017e-5f, 2640.f, 2650.f, 10.155f, .90252f, 9.0385e-6f,
				     1.3215e-5f, -4.9853e-4f, -1.2678e-6f, 2650.f, 2660.f, 10.154f, .79137f,
				     .0031844f, -3.2869e-6f, .0011834f, -1.1313e-5f, 2660.f, 2670.f, 11.725f,
				     .70879f, -.0014287f, 1.8146e-6f, -.0025033f, -1.0406e-7f, 2670.f,
				     2680.f, 14.948f, .92692f, .0062395f, -3.3167e-5f, .0031727f,
				     -2.6064e-5f, 2680.f, 2690.f, 26.279f, .87829f, .0028361f, -1.4791e-5f,
				     .0014018f, -1.4682e-5f, 2690.f, 2700.f, 7.1745f, .92595f, .0030055f,
				     -2.7951e-6f, .0045235f, -2.2596e-5f, 2700.f, 2710.f, 27.757f, .81447f,
				     .0030565f, -1.9569e-5f, .0025866f, -2.0025e-5f, 2710.f, 2720.f, 36.518f,
				     .82512f, .0018262f, -1.5755e-5f, .0012027f, -1.7464e-5f, 2720.f, 2730.f,
				     7.1564f, .77634f, .0051047f, -2.7255e-5f, .003528f, -2.6912e-5f, 2730.f,
				     2740.f, 53.441f, .64417f, -7.6181e-5f, -1.012e-5f, -8.2299e-4f,
				     -9.7201e-6f, 2740.f, 2750.f, 38.926f, .7434f, -6.9195e-4f, -4.3135e-6f,
				     2.1091e-4f, -6.9939e-6f, 2750.f, 2760.f, 15.709f, 1.3287f, .0030102f,
				     -4.8796e-6f, .0052525f, -2.2331e-5f, 2760.f, 2770.f, 54.733f, 1.246f,
				     -.0010987f, 5.2563e-6f, .002214f, -1.2844e-5f, 2770.f, 2780.f, 47.55f,
				     1.5791f, 8.4509e-4f, -2.0192e-6f, .0011472f, -1.6086e-5f, 2780.f,
				     2790.f, 66.52f, 1.2817f, -2.9084e-4f, -6.0279e-6f, -.0013817f,
				     -7.9406e-6f, 2790.f, 2800.f, 54.178f, .80208f, -.0020375f, 1.3886e-6f,
				     -.002404f, 9.4209e-6f, 2800.f, 2810.f, 53.2f, .65974f, -7.1708e-4f,
				     8.8569e-6f, -2.5373e-4f, 1.13e-5f, 2810.f, 2820.f, 148.4f, .84587f,
				     -.0016143f, 2.0628e-6f, -9.7561e-4f, 9.6287e-6f, 2820.f, 2830.f, 45.29f,
				     1.3591f, -2.3074e-4f, 1.8732e-5f, .0020323f, 6.678e-6f, 2830.f, 2840.f,
				     32.141f, 1.1794f, 7.5732e-4f, 5.0043e-5f, .005454f, 1.3952e-6f, 2840.f,
				     2850.f, 52.919f, .85346f, .0010685f, 4.9698e-5f, .0029632f, 1.729e-5f,
				     2850.f, 2860.f, 92.855f, 1.2724f, .0034021f, 3.1892e-5f, .0020937f,
				     7.5591e-6f, 2860.f, 2870.f, 115.15f, 1.6724f, .0068873f, 1.0637e-5f,
				     .0045477f, -1.5654e-5f, 2870.f, 2880.f, 149.81f, 1.2641f, .0081325f,
				     -1.1177e-6f, .0053865f, -1.8572e-5f, 2880.f, 2890.f, 225.46f, .83931f,
				     .011197f, -4.4342e-5f, .0080886f, -3.4016e-5f, 2890.f, 2900.f, 337.19f,
				     .68846f, .0074267f, -2.7002e-5f, .0051288f, -1.7032e-5f, 2900.f, 2910.f,
				     593.38f, .59397f, .0062712f, -3.0983e-5f, .0039217f, -1.5025e-5f,
				     2910.f, 2920.f, 814.37f, .44567f, .0050972f, -3.2548e-5f, .0037255f,
				     -1.8409e-5f, 2920.f, 2930.f, 1008.f, .42373f, .002722f, -2.2438e-5f,
				     .001776f, -8.5011e-6f, 2930.f, 2940.f, 1273.8f, .39048f, 9.1833e-4f,
				     -1.5902e-5f, 3.8752e-4f, -6.11e-6f, 2940.f, 2950.f, 1822.6f, .32354f,
				     -8.3613e-4f, -9.1286e-6f, -.0012748f, 6.4576e-7f, 2950.f, 2960.f,
				     1144.9f, .28404f, -.0022237f, -3.1413e-6f, -.0015533f, 4e-6f, 2960.f,
				     2970.f, 1422.2f, .24694f, -.0034946f, 2.0028e-6f, -.0022609f,
				     9.6681e-6f, 2970.f, 2980.f, 1129.9f, .25225f, -.0043236f, 6.0179e-6f,
				     -.0023072f, 8.9383e-6f, 2980.f, 2990.f, 382.43f, .28365f, -.0047369f,
				     1.1124e-5f, .0018248f, 1.9257e-5f, 2990.f, 3e3f, 231.12f, 2.8616f,
				     .0085402f, 4.3691e-5f, .016112f, -4.2673e-5f, 3e3f, 3010.f, 12795.f,
				     1.9671f, -2.1206e-4f, -1.4984e-6f, -3.9307e-4f, -5.8544e-6f, 3010.f,
				     3020.f, 578.69f, .79629f, -.0043645f, 1.3898e-5f, 7.3408e-4f,
				     -4.5626e-6f, 3020.f, 3030.f, 434.57f, .096576f, -.0055811f, 1.294e-5f,
				     .0011172f, 2.1736e-5f, 3030.f, 3040.f, 899.49f, .11536f, -.0052201f,
				     1.0059e-5f, -.0015874f, 2.2277e-5f, 3040.f, 3050.f, 2131.4f, .12202f,
				     -.0045842f, 6.3207e-6f, -.003267f, 2.194e-5f, 3050.f, 3060.f, 2451.4f,
				     .19437f, -.0035989f, 2.0635e-6f, -.0037611f, 1.5519e-5f, 3060.f, 3070.f,
				     1860.9f, .31324f, -.0022827f, -2.6816e-6f, -.0014644f, 8.4665e-6f,
				     3070.f, 3080.f, 2857.1f, .3194f, -8.3645e-4f, -9.0192e-6f, -7.6302e-4f,
				     2.417e-6f, 3080.f, 3090.f, 1935.6f, .28235f, 9.2008e-4f, -1.5863e-5f,
				     .0010109f, -1.3517e-6f, 3090.f, 3100.f, 1498.4f, .32994f, .0028983f,
				     -2.3966e-5f, .0020895f, -9.8936e-6f, 3100.f, 3110.f, 1250.8f, .36564f,
				     .005137f, -3.2908e-5f, .0037408f, -1.8191e-5f, 3110.f, 3120.f, 818.19f,
				     .45356f, .0075913f, -4.2727e-5f, .0055871f, -2.645e-5f, 3120.f, 3130.f,
				     483.02f, .62289f, .010573f, -5.4032e-5f, .0075195f, -3.888e-5f, 3130.f,
				     3140.f, 405.16f, 1.0372f, .01439f, -6.8744e-5f, .011121f, -5.8648e-5f,
				     3140.f, 3150.f, 80.532f, .8961f, .01798f, -6.9816e-5f, .012298f,
				     -5.1675e-5f, 3150.f, 3160.f, 41.171f, .85486f, .021624f, -8.2706e-5f,
				     .015717f, -6.4082e-5f, 3160.f, 3170.f, 18.087f, .82972f, .024369f,
				     -8.2555e-5f, .018128f, -6.8246e-5f, 3170.f, 3180.f, 7.8303f, .7783f,
				     .024083f, -4.5258e-5f, .018125f, -5.3074e-5f, 3180.f, 3190.f, 5.5218f,
				     1.2503f, .023406f, -1.2671e-6f, .019648f, -4.075e-5f, 3190.f, 3200.f,
				     .69216f, .51644f, .01424f, -8.731e-6f, .01086f, -3.2732e-5f, 3200.f,
				     3210.f, .30939f, .2177f, .0082095f, -4.4565e-5f, .0058697f, -4.1343e-5f,
				     3210.f, 3220.f, .22568f, .37985f, .012091f, -6.0525e-5f, .0090838f,
				     -5.5067e-5f, 3220.f, 3230.f, .18766f, .2799f, .01283f, -6.1005e-5f,
				     .010043f, -5.7718e-5f, 3230.f, 3240.f, .063205f, .18476f, .014107f,
				     -6.7485e-5f, .011333f, -6.3191e-5f, 3240.f, 3250.f, .028821f, .059172f,
				     .014986f, -7.1903e-5f, .012123f, -6.7129e-5f, 3250.f, 3260.f, 0.f, 0.f,
				     0.f, 0.f, 0.f, 0.f, 3260.f, 3270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3270.f,
				     3280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3280.f, 3290.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 3290.f, 3300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3300.f, 3310.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 3310.f, 3320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3320.f,
				     3330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3330.f, 3340.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 3340.f, 3350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3350.f, 3360.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 3360.f, 3370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3370.f,
				     3380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3380.f, 3390.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 3390.f, 3400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3400.f, 3410.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 3410.f, 3420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3420.f,
				     3430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3430.f, 3440.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 3440.f, 3450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3450.f, 3460.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 3460.f, 3470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3470.f,
				     3480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3480.f, 3490.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 3490.f, 3500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3500.f, 3510.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 3510.f, 3520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3520.f,
				     3530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3530.f, 3540.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 3540.f, 3550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3550.f, 3560.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 3560.f, 3570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3570.f,
				     3580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3580.f, 3590.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 3590.f, 3600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3600.f, 3610.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 3610.f, 3620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3620.f,
				     3630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3630.f, 3640.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 3640.f, 3650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3650.f, 3660.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 3660.f, 3670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3670.f,
				     3680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3680.f, 3690.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 3690.f, 3700.f, .014928f, .049339f, .0010215f, -1.7301e-5f,
				     -.0020195f, -1.1177e-5f, 3700.f, 3710.f, .086139f, .13757f, .0010215f,
				     -1.7301e-5f, -.0020195f, -1.1177e-5f, 3710.f, 3720.f, .067083f, .12495f,
				     .0010215f, -1.7301e-5f, -.0020195f, -1.1177e-5f, 3720.f, 3730.f,
				     .020862f, .049275f, .0010215f, -1.7301e-5f, -.0020195f, -1.1177e-5f,
				     3730.f, 3740.f, .067784f, .11899f, .0010215f, -1.7301e-5f, -.0020195f,
				     -1.1177e-5f, 3740.f, 3750.f, .15027f, .18565f, .0010215f, -1.7301e-5f,
				     -.0020195f, -1.1177e-5f, 3750.f, 3760.f, .31581f, .26221f, .0010215f,
				     -1.7301e-5f, -.0020195f, -1.1177e-5f, 3760.f, 3770.f, .48086f, .2992f,
				     .0010215f, -1.7301e-5f, -.0020195f, -1.1177e-5f, 3770.f, 3780.f,
				     .59376f, .29431f, .0010215f, -1.7301e-5f, -.0020195f, -1.1177e-5f,
				     3780.f, 3790.f, 1.8375f, .36994f, .0010215f, -1.7301e-5f, -.0020195f,
				     -1.1177e-5f, 3790.f, 3800.f, 2.5355f, .40322f, .0010215f, -1.7301e-5f,
				     -.0020195f, -1.1177e-5f, 3800.f, 3810.f, 2.7002f, .43597f, .0010215f,
				     -1.7301e-5f, -.0020195f, -1.1177e-5f, 3810.f, 3820.f, 6.1651f, .55369f,
				     .0010215f, -1.7301e-5f, -.0020195f, -1.1177e-5f, 3820.f, 3830.f,
				     4.0461f, .57732f, .0010215f, -1.7301e-5f, -.0020195f, -1.1177e-5f,
				     3830.f, 3840.f, 6.3365f, .67727f, .0010215f, -1.7301e-5f, -.0020195f,
				     -1.1177e-5f, 3840.f, 3850.f, 9.3866f, .95498f, .0010215f, -1.7301e-5f,
				     -.0020195f, -1.1177e-5f, 3850.f, 3860.f, 20.329f, 1.0079f, .0010215f,
				     -1.7301e-5f, -.0020195f, -1.1177e-5f, 3860.f, 3870.f, 3.8488f, .60704f,
				     -.0030055f, 4.6922e-6f, -.0036436f, -2.5739e-6f, 3870.f, 3880.f,
				     11.688f, .69118f, -.0033148f, 3.0917e-6f, -.0045244f, 8.2466e-7f,
				     3880.f, 3890.f, 15.787f, .75496f, -3.761e-4f, -9.5219e-6f, -.0028616f,
				     -7.036e-6f, 3890.f, 3900.f, 12.339f, 1.2573f, .0010215f, -1.7301e-5f,
				     -.0020195f, -1.1177e-5f, 3900.f, 3910.f, 4.4035f, 1.1712f, .0010215f,
				     -1.7301e-5f, -.0020195f, -1.1177e-5f, 3910.f, 3920.f, 1.452f, 1.1029f,
				     .0010215f, -1.7301e-5f, -.0020195f, -1.1177e-5f, 3920.f, 3930.f,
				     .94805f, .51649f, .0010215f, -1.7301e-5f, -.0020195f, -1.1177e-5f,
				     3930.f, 3940.f, 1.3512f, .57924f, .0010215f, -1.7301e-5f, -.0020195f,
				     -1.1177e-5f, 3940.f, 3950.f, 1.2982f, .5633f, .0010215f, -1.7301e-5f,
				     -.0020195f, -1.1177e-5f, 3950.f, 3960.f, 1.1898f, .7034f, .0010215f,
				     -1.7301e-5f, -.0020195f, -1.1177e-5f, 3960.f, 3970.f, 1.2669f, .70992f,
				     .0010215f, -1.7301e-5f, -.0020195f, -1.1177e-5f, 3970.f, 3980.f,

				     1.1486f, .75703f, .0010215f, -1.7301e-5f, -.0020195f, -1.1177e-5f,
				     3980.f, 3990.f, .94294f, .67691f, .0010215f, -1.7301e-5f, -.0020195f,
				     -1.1177e-5f, 3990.f, 4e3f, 1.1722f, .71803f, .0010215f, -1.7301e-5f,
				     -.0020195f, -1.1177e-5f, 4e3f, 4010.f, 1.6614f, 1.1434f, .0010215f,
				     -1.7301e-5f, -.0020195f, -1.1177e-5f, 4010.f, 4020.f, 1.3169f, .99418f,
				     .0010215f, -1.7301e-5f, -.0020195f, -1.1177e-5f, 4020.f, 4030.f,
				     1.6675f, 1.5586f, .0010215f, -1.7301e-5f, -.0020195f, -1.1177e-5f,
				     4030.f, 4040.f, 2.2754f, 1.5263f, .0010215f, -1.7301e-5f, -.0020195f,
				     -1.1177e-5f, 4040.f, 4050.f, 3.3696f, 1.614f, .0010215f, -1.7301e-5f,
				     -.0020195f, -1.1177e-5f, 4050.f, 4060.f, 4.4078f, 1.7299f, .0010215f,
				     -1.7301e-5f, -.0020195f, -1.1177e-5f, 4060.f, 4070.f, 6.4093f, 1.6235f,
				     .0010215f, -1.7301e-5f, -.0020195f, -1.1177e-5f, 4070.f, 4080.f,
				     8.8553f, 1.445f, .0010215f, -1.7301e-5f, -.0020195f, -1.1177e-5f,
				     4080.f, 4090.f, 8.5641f, 1.5633f, .0010215f, -1.7301e-5f, -.0020195f,
				     -1.1177e-5f, 4090.f, 4100.f, 16.356f, 1.9485f, .0010215f, -1.7301e-5f,
				     -.0020195f, -1.1177e-5f, 4100.f, 4110.f, 15.552f, 1.5099f, .0010215f,
				     -1.7301e-5f, -.0020195f, -1.1177e-5f, 4110.f, 4120.f, 23.823f, 2.7996f,
				     .0010215f, -1.7301e-5f, -.0020195f, -1.1177e-5f, 4120.f, 4130.f,
				     18.843f, 1.4075f, .0058105f, -2.6748e-5f, 6.4011e-4f, -1.7934e-5f,
				     4130.f, 4140.f, 7.1651f, .45187f, .0070593f, -2.9644e-5f, .0039603f,
				     -2.9724e-5f, 4140.f, 4150.f, 37.171f, .44157f, .0068418f, -3.8862e-5f,
				     .0036076f, -3.2195e-5f, 4150.f, 4160.f, 38.158f, .32296f, .0043474f,
				     -2.9319e-5f, .00185f, -2.5238e-5f, 4160.f, 4170.f, 65.621f, .45796f,
				     .0022774f, -2.0417e-5f, 8.223e-5f, -1.7919e-5f, 4170.f, 4180.f, 79.347f,
				     .33603f, -8.4769e-4f, -8.4263e-6f, -.0034772f, -3.6512e-6f, 4180.f,
				     4190.f, 65.038f, .4819f, -.0014827f, -1.4444e-6f, -.0022137f,
				     -5.6866e-6f, 4190.f, 4200.f, 86.982f, .77363f, -7.1575e-4f, 2.9104e-7f,
				     -.0017062f, -5.7132e-6f, 4200.f, 4210.f, 309.82f, 1.6801f, -8.9037e-4f,
				     -1.3593e-6f, -.0021551f, -4.6701e-6f, 4210.f, 4220.f, 81.077f, .588f,
				     -.0012356f, -7.661e-7f, -.0026793f, -4.4252e-6f, 4220.f, 4230.f,
				     89.975f, .39899f, -.0039748f, 5.6557e-6f, -.0048805f, 4.5246e-6f,
				     4230.f, 4240.f, 148.96f, .80968f, -.002216f, -1.5823e-6f, -.0039631f,
				     -2.9253e-7f, 4240.f, 4250.f, 155.94f, 1.2514f, 4.5507e-4f, -8.2566e-6f,
				     -.0014417f, -8.5226e-6f, 4250.f, 4260.f, 100.6f, 1.2829f, .0020903f,
				     -1.6069e-5f, -3.6824e-4f, -1.5144e-5f, 4260.f, 4270.f, 117.04f, 1.5739f,
				     5.5952e-4f, -2.1104e-6f, -8.6496e-4f, -9.3941e-6f, 4270.f, 4280.f,
				     72.794f, 1.549f, -6.9688e-4f, -3.1516e-6f, -.0027541f, -2.9267e-6f,
				     4280.f, 4290.f, 55.269f, .72223f, -.0034302f, 5.1174e-6f, -.0052484f,
				     7.0355e-6f, 4290.f, 4300.f, 59.856f, 1.1762f, -5.5565e-4f, 2.0772e-7f,
				     -.0019773f, -5.0966e-6f, 4300.f, 4310.f, 218.17f, 2.2377f, -.0013492f,
				     -1.8427e-6f, -.0029966f, -3.2329e-6f, 4310.f, 4320.f, 10.284f, .071846f,
				     -.0057696f, 9.8901e-6f, -.0087876f, 1.5909e-5f, 4320.f, 4330.f, 96.725f,
				     .88048f, -.0045462f, 6.1508e-6f, -.0069991f, 9.6787e-6f, 4330.f, 4340.f,
				     111.26f, 1.6893f, -.002444f, 5.0136e-7f, -.0044752f, 1.1244e-6f, 4340.f,
				     4350.f, 102.83f, 1.8062f, -3.868e-4f, -5.0005e-6f, -.0021043f,
				     -6.8556e-6f, 4350.f, 4360.f, 89.61f, 1.1851f, -6.654e-4f, 2.3556e-6f,
				     -.001897f, -3.4232e-6f, 4360.f, 4370.f, 66.668f, .73012f, -.0022103f,
				     2.3323e-6f, -.0030787f, -5.6056e-7f, 4370.f, 4380.f, 81.907f, .54144f,
				     -.0025213f, -8.9597e-7f, -.0047474f, 1.5149e-6f, 4380.f, 4390.f,
				     90.229f, .49784f, -.0023921f, -1.0143e-6f, -.0043793f, 4.6547e-7f,
				     4390.f, 4400.f, 82.849f, .85204f, -1.0412e-4f, -8.1641e-6f, -.0020032f,
				     -8.0151e-6f, 4400.f, 4410.f, 44.643f, .57527f, .0023103f, -1.4133e-5f,
				     8.589e-4f, -1.8551e-5f, 4410.f, 4420.f, 69.032f, .78506f, 3.9855e-4f,
				     -1.0098e-5f, -.0010159f, -1.0449e-5f, 4420.f, 4430.f, 58.683f, .96123f,
				     .0024151f, -1.8621e-5f, 9.2225e-4f, -1.9737e-5f, 4430.f, 4440.f,
				     37.181f, 1.0126f, .0046217f, -2.9919e-5f, .0020589f, -2.6447e-5f,
				     4440.f, 4450.f, 42.607f, 1.0332f, .0047981f, -3.088e-5f, .0014909f,
				     -2.4304e-5f, 4450.f, 4460.f, 33.113f, .94984f, .0043677f, -2.6166e-5f,
				     .0012754f, -2.2104e-5f, 4460.f, 4470.f, 32.668f, .8529f, .0023495f,
				     -1.622e-5f, -4.7342e-4f, -1.3768e-5f, 4470.f, 4480.f, 23.216f, .8354f,
				     .0022982f, -7.3604e-6f, 6.8926e-4f, -1.3485e-5f, 4480.f, 4490.f,
				     13.719f, .6592f, .0014982f, -6.2753e-6f, -3.7161e-4f, -1.1492e-5f,
				     4490.f, 4500.f, 16.799f, .41229f, -7.848e-4f, 1.7545e-6f, -.001216f,
				     -7.1041e-6f, 4500.f, 4510.f, 10.085f, .14021f, -.0037976f, 6.6108e-6f,
				     -.0050669f, 6.8711e-6f, 4510.f, 4520.f, 3.1009f, .087599f, -.0043682f,
				     1.0148e-5f, -.0057555f, 1.0223e-5f, 4520.f, 4530.f, 18.983f, 1.5932f,
				     .0014519f, -9.1544e-6f, -9.7256e-4f, -1.0139e-5f, 4530.f, 4540.f,
				     63.83f, 2.0016f, -.0011189f, -2.1104e-6f, -.0028048f, -3.8802e-6f,
				     4540.f, 4550.f, 3.1441f, .067773f, -.0040447f, 1.4471e-5f, -.0037016f,
				     5.8757e-6f, 4550.f, 4560.f, 2.1782f, .029389f, -.005929f, 1.0501e-5f,
				     -.00897f, 1.6625e-5f, 4560.f, 4570.f, 4.0086f, .078646f, -.0053825f,
				     8.3305e-6f, -.0083558f, 1.4185e-5f, 4570.f, 4580.f, 1.3954f, .11032f,
				     -.0040678f, 3.1725e-6f, -.0071674f, 9.4743e-6f, 4580.f, 4590.f, 8.2827f,
				     .13524f, -.0044855f, 4.8983e-6f, -.0072447f, 9.9023e-6f, 4590.f, 4600.f,
				     8.1728f, .18866f, -.0033132f, 4.1656e-7f, -.0059898f, 5.0092e-6f,
				     4600.f, 4610.f, 6.4947f, .31086f, -.0016438f, -5.9966e-6f, -.0043498f,
				     -1.4967e-6f, 4610.f, 4620.f, 6.3479f, .34741f, 1.5663e-4f, -1.2499e-5f,
				     -.0026034f, -7.9833e-6f, 4620.f, 4630.f, 2.4602f, .20366f, .0017162f,
				     -1.8956e-5f, -9.66e-4f, -1.4741e-5f, 4630.f, 4640.f, 2.0994f, .2061f,
				     .004364f, -2.6098e-5f, .0019605f, -2.4954e-5f, 4640.f, 4650.f, 1.6635f,
				     .21606f, .0038987f, -2.7059e-5f, .001059f, -2.2496e-5f, 4650.f, 4660.f,
				     .9148f, .11908f, .0055341f, -3.5022e-5f, .002491f, -2.9056e-5f, 4660.f,
				     4670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4670.f, 4680.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4680.f, 4690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4690.f, 4700.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4700.f, 4710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4710.f,
				     4720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4720.f, 4730.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4730.f, 4740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4740.f, 4750.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4750.f, 4760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4760.f,
				     4770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4770.f, 4780.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4780.f, 4790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4790.f, 4800.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4800.f, 4810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4810.f,
				     4820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4820.f, 4830.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4830.f, 4840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4840.f, 4850.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4850.f, 4860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4860.f,
				     4870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4870.f, 4880.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4880.f, 4890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4890.f, 4900.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4900.f, 4910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4910.f,
				     4920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4920.f, 4930.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4930.f, 4940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4940.f, 4950.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 4950.f, 4960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4960.f,
				     4970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4970.f, 4980.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 4980.f, 4990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4990.f, 5e3f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 5e3f, 5010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5010.f, 5020.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 5020.f, 5030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     5030.f,
				     5040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5040.f, 5050.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5050.f, 5060.f
    };

    /* methane (2500 - 5050 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* meth1 */


void
moca6 (double a[8], const long int inu)
{


    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 15300.f, 15310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15310.f, 15320.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 15320.f, 15330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15330.f, 15340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15340.f, 15350.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15350.f, 15360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15360.f,
				     15370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15370.f, 15380.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15380.f, 15390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15390.f,
				     15400.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15400.f, 15410.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15410.f, 15420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15420.f, 15430.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15430.f, 15440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15440.f,
				     15450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15450.f, 15460.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15460.f, 15470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15470.f,
				     15480.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15480.f, 15490.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15490.f, 15500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15500.f, 15510.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15510.f, 15520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15520.f,
				     15530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15530.f, 15540.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15540.f, 15550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15550.f,
				     15560.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15560.f, 15570.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15570.f, 15580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15580.f, 15590.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15590.f, 15600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15600.f,
				     15610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15610.f, 15620.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15620.f, 15630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15630.f,
				     15640.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15640.f, 15650.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15650.f, 15660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15660.f, 15670.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15670.f, 15680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15680.f,
				     15690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15690.f, 15700.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15700.f, 15710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15710.f,
				     15720.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15720.f, 15730.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15730.f, 15740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15740.f, 15750.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15750.f, 15760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15760.f,
				     15770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15770.f, 15780.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15780.f, 15790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15790.f,
				     15800.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15800.f, 15810.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15810.f, 15820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15820.f, 15830.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15830.f, 15840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15840.f,
				     15850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15850.f, 15860.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15860.f, 15870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15870.f,
				     15880.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15880.f, 15890.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15890.f, 15900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15900.f, 15910.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15910.f, 15920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15920.f,
				     15930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15930.f, 15940.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15940.f, 15950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15950.f,
				     15960.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15960.f, 15970.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15970.f, 15980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15980.f, 15990.f, 0.f,
				     0.f,

				     0.f, 0.f, 0.f, 0.f, 15990.f, 1.6e4f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.6e4f,
				     16010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16010.f, 16020.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16020.f, 16030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16030.f,
				     16040.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16040.f, 16050.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16050.f, 16060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16060.f, 16070.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16070.f, 16080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16080.f,
				     16090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16090.f, 16100.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16100.f, 16110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16110.f,
				     16120.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16120.f, 16130.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16130.f, 16140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16140.f, 16150.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16150.f, 16160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16160.f,
				     16170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16170.f, 16180.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16180.f, 16190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16190.f,
				     16200.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16200.f, 16210.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16210.f, 16220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16220.f, 16230.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16230.f, 16240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16240.f,
				     16250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16250.f, 16260.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16260.f, 16270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16270.f,
				     16280.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16280.f, 16290.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16290.f, 16300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16300.f, 16310.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16310.f, 16320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16320.f,
				     16330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16330.f, 16340.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16340.f, 16350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16350.f,
				     16360.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16360.f, 16370.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16370.f, 16380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16380.f, 16390.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16390.f, 16400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16400.f,
				     16410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16410.f, 16420.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16420.f, 16430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16430.f,
				     16440.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16440.f, 16450.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16450.f, 16460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16460.f, 16470.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16470.f, 16480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16480.f,
				     16490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16490.f, 16500.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16500.f, 16510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16510.f,
				     16520.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16520.f, 16530.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16530.f, 16540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16540.f, 16550.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16550.f, 16560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16560.f,
				     16570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16570.f, 16580.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16580.f, 16590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16590.f,
				     16600.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16600.f, 16610.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16610.f, 16620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16620.f, 16630.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16630.f, 16640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16640.f,
				     16650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16650.f, 16660.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16660.f, 16670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16670.f,
				     16680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16680.f, 16690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16690.f, 16700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16700.f, 16710.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16710.f, 16720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16720.f,
				     16730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16730.f, 16740.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16740.f, 16750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16750.f,
				     16760.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16760.f, 16770.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16770.f, 16780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16780.f, 16790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16790.f, 16800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16800.f,
				     16810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16810.f, 16820.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16820.f, 16830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16830.f,
				     16840.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16840.f, 16850.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16850.f, 16860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16860.f, 16870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16870.f, 16880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16880.f,
				     16890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16890.f, 16900.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16900.f, 16910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16910.f,
				     16920.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16920.f, 16930.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16930.f, 16940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16940.f, 16950.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16950.f, 16960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16960.f,
				     16970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16970.f, 16980.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16980.f, 16990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16990.f, 1.7e4f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.7e4f, 17010.f, 0.f, 0.f, 0.f, 0.f, 0.f,

				     0.f,
				     17010.f, 17020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17020.f, 17030.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17030.f, 17040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17040.f,
				     17050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17050.f, 17060.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17060.f, 17070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17070.f,
				     17080.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17080.f, 17090.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17090.f, 17100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17100.f, 17110.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17110.f, 17120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17120.f,
				     17130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17130.f, 17140.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17140.f, 17150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17150.f,
				     17160.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17160.f, 17170.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17170.f, 17180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17180.f, 17190.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17190.f, 17200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17200.f,
				     17210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17210.f, 17220.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17220.f, 17230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17230.f,
				     17240.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17240.f, 17250.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17250.f, 17260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17260.f, 17270.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17270.f, 17280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17280.f,
				     17290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17290.f, 17300.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17300.f, 17310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17310.f,
				     17320.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17320.f, 17330.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17330.f, 17340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17340.f, 17350.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17350.f, 17360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17360.f,
				     17370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17370.f, 17380.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17380.f, 17390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17390.f,
				     17400.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17400.f, 17410.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17410.f, 17420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17420.f, 17430.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17430.f, 17440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17440.f,
				     17450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17450.f, 17460.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17460.f, 17470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17470.f,
				     17480.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17480.f, 17490.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17490.f, 17500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17500.f, 17510.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17510.f, 17520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17520.f,
				     17530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17530.f, 17540.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17540.f, 17550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17550.f,
				     17560.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17560.f, 17570.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17570.f, 17580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17580.f, 17590.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17590.f, 17600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17600.f,
				     17610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17610.f, 17620.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17620.f, 17630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17630.f,
				     17640.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17640.f, 17650.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17650.f, 17660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17660.f, 17670.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17670.f, 17680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17680.f,
				     17690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17690.f, 17700.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17700.f, 17710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17710.f,
				     17720.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17720.f, 17730.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17730.f, 17740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17740.f, 17750.f, 0.f,
				     0.f,

				     0.f, 0.f, 0.f, 0.f, 17750.f, 17760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17760.f,
				     17770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17770.f, 17780.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17780.f, 17790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17790.f,
				     17800.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17800.f, 17810.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17810.f, 17820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17820.f, 17830.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17830.f, 17840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17840.f,
				     17850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17850.f, 17860.f
    };

    /* carbon monoxide (15300 - 17870 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* moca6 */

void
moca5 (double a[8], const long int inu)
{


    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 12740.f, 12750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12750.f, 12760.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 12760.f, 12770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12770.f, 12780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12780.f, 12790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12790.f, 12800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12800.f,
				     12810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12810.f, 12820.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12820.f, 12830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12830.f,
				     12840.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12840.f, 12850.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12850.f, 12860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12860.f, 12870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12870.f, 12880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12880.f,
				     12890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12890.f, 12900.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12900.f, 12910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12910.f,
				     12920.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12920.f, 12930.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12930.f, 12940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12940.f, 12950.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12950.f, 12960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12960.f,
				     12970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12970.f, 12980.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12980.f, 12990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12990.f, 1.3e4f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.3e4f, 13010.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13010.f, 13020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13020.f, 13030.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13030.f, 13040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13040.f,
				     13050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13050.f, 13060.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13060.f, 13070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13070.f,
				     13080.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13080.f, 13090.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13090.f, 13100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13100.f, 13110.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13110.f, 13120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13120.f,
				     13130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13130.f, 13140.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13140.f, 13150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13150.f,
				     13160.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13160.f, 13170.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13170.f, 13180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13180.f, 13190.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13190.f, 13200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13200.f,
				     13210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13210.f, 13220.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13220.f, 13230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13230.f,
				     13240.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13240.f, 13250.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13250.f, 13260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13260.f, 13270.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13270.f, 13280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13280.f,
				     13290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13290.f, 13300.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13300.f, 13310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13310.f,
				     13320.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13320.f, 13330.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13330.f, 13340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13340.f, 13350.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13350.f, 13360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13360.f,
				     13370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13370.f, 13380.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13380.f, 13390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13390.f,
				     13400.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13400.f, 13410.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13410.f, 13420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13420.f, 13430.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13430.f, 13440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13440.f,
				     13450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13450.f, 13460.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13460.f, 13470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13470.f,
				     13480.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13480.f, 13490.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13490.f, 13500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13500.f, 13510.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13510.f, 13520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13520.f,
				     13530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13530.f, 13540.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13540.f, 13550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13550.f,
				     13560.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13560.f, 13570.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13570.f, 13580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13580.f, 13590.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13590.f, 13600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13600.f,
				     13610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13610.f, 13620.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13620.f, 13630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13630.f,
				     13640.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13640.f, 13650.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13650.f, 13660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13660.f, 13670.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13670.f, 13680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13680.f,
				     13690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13690.f, 13700.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13700.f, 13710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13710.f,
				     13720.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13720.f, 13730.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13730.f, 13740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13740.f, 13750.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13750.f, 13760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13760.f,
				     13770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13770.f, 13780.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13780.f, 13790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13790.f,
				     13800.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13800.f, 13810.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13810.f, 13820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13820.f, 13830.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13830.f, 13840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13840.f,
				     13850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13850.f, 13860.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13860.f, 13870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13870.f,
				     13880.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13880.f, 13890.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13890.f, 13900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13900.f, 13910.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13910.f, 13920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13920.f,
				     13930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13930.f, 13940.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13940.f, 13950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13950.f,
				     13960.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13960.f, 13970.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13970.f, 13980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13980.f, 13990.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13990.f, 1.4e4f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.4e4f,
				     14010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14010.f, 14020.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14020.f, 14030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14030.f,
				     14040.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14040.f, 14050.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14050.f, 14060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14060.f, 14070.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14070.f, 14080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14080.f,
				     14090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14090.f, 14100.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14100.f, 14110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14110.f,
				     14120.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14120.f, 14130.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14130.f, 14140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14140.f, 14150.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14150.f, 14160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14160.f,
				     14170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14170.f, 14180.f, 0.f, 0.f, 0.f,

				     0.f,
				     0.f, 0.f, 14180.f, 14190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14190.f,
				     14200.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14200.f, 14210.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14210.f, 14220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14220.f, 14230.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14230.f, 14240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14240.f,
				     14250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14250.f, 14260.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14260.f, 14270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14270.f,
				     14280.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14280.f, 14290.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14290.f, 14300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14300.f, 14310.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14310.f, 14320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14320.f,
				     14330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14330.f, 14340.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14340.f, 14350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14350.f,
				     14360.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14360.f, 14370.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14370.f, 14380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14380.f, 14390.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14390.f, 14400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14400.f,
				     14410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14410.f, 14420.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14420.f, 14430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14430.f,
				     14440.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14440.f, 14450.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14450.f, 14460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14460.f, 14470.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14470.f, 14480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14480.f,
				     14490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14490.f, 14500.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14500.f, 14510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14510.f,
				     14520.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14520.f, 14530.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14530.f, 14540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14540.f, 14550.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14550.f, 14560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14560.f,
				     14570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14570.f, 14580.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14580.f, 14590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14590.f,
				     14600.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14600.f, 14610.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14610.f, 14620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14620.f, 14630.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14630.f, 14640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14640.f,
				     14650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14650.f, 14660.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14660.f, 14670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14670.f,
				     14680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14680.f, 14690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14690.f, 14700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14700.f, 14710.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14710.f, 14720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14720.f,
				     14730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14730.f, 14740.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14740.f, 14750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14750.f,
				     14760.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14760.f, 14770.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14770.f, 14780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14780.f, 14790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14790.f, 14800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14800.f,
				     14810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14810.f, 14820.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14820.f, 14830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14830.f,
				     14840.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14840.f, 14850.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14850.f, 14860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14860.f, 14870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14870.f, 14880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14880.f,
				     14890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14890.f, 14900.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14900.f, 14910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14910.f,
				     14920.f,

				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14920.f, 14930.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14930.f, 14940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14940.f, 14950.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14950.f, 14960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14960.f,
				     14970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14970.f, 14980.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14980.f, 14990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14990.f, 1.5e4f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.5e4f, 15010.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15010.f, 15020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15020.f, 15030.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15030.f, 15040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15040.f,
				     15050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15050.f, 15060.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15060.f, 15070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15070.f,
				     15080.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15080.f, 15090.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15090.f, 15100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15100.f, 15110.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15110.f, 15120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15120.f,
				     15130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15130.f, 15140.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15140.f, 15150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15150.f,
				     15160.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15160.f, 15170.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15170.f, 15180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15180.f, 15190.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15190.f, 15200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15200.f,
				     15210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15210.f, 15220.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15220.f, 15230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15230.f,
				     15240.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15240.f, 15250.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15250.f, 15260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15260.f, 15270.f, 0.f,

				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15270.f, 15280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15280.f,
				     15290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15290.f, 15300.f
    };

    /* carbon monoxide (12740 - 15290 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* moca5 */


void moca4 (double a[8], const long int inu)
{
    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 10180.f, 10190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10190.f, 10200.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 10200.f, 10210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10210.f, 10220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10220.f, 10230.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10230.f, 10240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10240.f,
				     10250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10250.f, 10260.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10260.f, 10270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10270.f,
				     10280.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10280.f, 10290.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10290.f, 10300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10300.f, 10310.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10310.f, 10320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10320.f,
				     10330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10330.f, 10340.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10340.f, 10350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10350.f,
				     10360.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10360.f, 10370.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10370.f, 10380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10380.f, 10390.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10390.f, 10400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10400.f,
				     10410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10410.f, 10420.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10420.f, 10430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10430.f,
				     10440.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10440.f, 10450.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10450.f, 10460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10460.f, 10470.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10470.f, 10480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10480.f,
				     10490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10490.f, 10500.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10500.f, 10510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10510.f,
				     10520.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10520.f, 10530.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10530.f, 10540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10540.f, 10550.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10550.f, 10560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10560.f,
				     10570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10570.f, 10580.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10580.f, 10590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10590.f,
				     10600.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10600.f, 10610.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10610.f, 10620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10620.f, 10630.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10630.f, 10640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10640.f,
				     10650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10650.f, 10660.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10660.f, 10670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10670.f,
				     10680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10680.f, 10690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10690.f, 10700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10700.f, 10710.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10710.f, 10720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10720.f,
				     10730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10730.f, 10740.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10740.f, 10750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10750.f,
				     10760.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10760.f, 10770.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10770.f, 10780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10780.f, 10790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10790.f, 10800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10800.f,
				     10810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10810.f, 10820.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10820.f, 10830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10830.f,
				     10840.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10840.f, 10850.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,

				     10850.f, 10860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10860.f, 10870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10870.f, 10880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10880.f,
				     10890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10890.f, 10900.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10900.f, 10910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10910.f,
				     10920.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10920.f, 10930.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10930.f, 10940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10940.f, 10950.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10950.f, 10960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10960.f,
				     10970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10970.f, 10980.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10980.f, 10990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10990.f, 1.1e4f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.1e4f, 11010.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11010.f, 11020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11020.f, 11030.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11030.f, 11040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11040.f,
				     11050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11050.f, 11060.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11060.f, 11070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11070.f,
				     11080.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11080.f, 11090.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11090.f, 11100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11100.f, 11110.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11110.f, 11120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11120.f,
				     11130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11130.f, 11140.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11140.f, 11150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11150.f,
				     11160.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11160.f, 11170.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11170.f, 11180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11180.f, 11190.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11190.f, 11200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11200.f,
				     11210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11210.f, 11220.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11220.f, 11230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11230.f,
				     11240.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11240.f, 11250.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11250.f, 11260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11260.f, 11270.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11270.f, 11280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11280.f,
				     11290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11290.f, 11300.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11300.f, 11310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11310.f,
				     11320.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11320.f, 11330.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11330.f, 11340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11340.f, 11350.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11350.f, 11360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11360.f,
				     11370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11370.f, 11380.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11380.f, 11390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11390.f,
				     11400.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11400.f, 11410.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11410.f, 11420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11420.f, 11430.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11430.f, 11440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11440.f,
				     11450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11450.f, 11460.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11460.f, 11470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11470.f,
				     11480.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11480.f, 11490.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11490.f, 11500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11500.f, 11510.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11510.f, 11520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11520.f,
				     11530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11530.f, 11540.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11540.f, 11550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11550.f,
				     11560.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11560.f, 11570.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11570.f, 11580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11580.f, 11590.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11590.f, 11600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11600.f,
				     11610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11610.f, 11620.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11620.f, 11630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11630.f,
				     11640.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11640.f, 11650.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11650.f, 11660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11660.f, 11670.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11670.f, 11680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11680.f,

				     11690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11690.f, 11700.f, 0.f, 0.f, 0.f,
				     0.f,

				     0.f, 0.f, 11700.f, 11710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11710.f,
				     11720.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11720.f, 11730.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11730.f, 11740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11740.f, 11750.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11750.f, 11760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11760.f,
				     11770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11770.f, 11780.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11780.f, 11790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11790.f,
				     11800.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11800.f, 11810.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11810.f, 11820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11820.f, 11830.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11830.f, 11840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11840.f,
				     11850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11850.f, 11860.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11860.f, 11870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11870.f,
				     11880.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11880.f, 11890.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11890.f, 11900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11900.f, 11910.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11910.f, 11920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11920.f,
				     11930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11930.f, 11940.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11940.f, 11950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11950.f,
				     11960.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11960.f, 11970.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11970.f, 11980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11980.f, 11990.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11990.f, 1.2e4f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.2e4f,
				     12010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12010.f, 12020.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12020.f, 12030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12030.f,
				     12040.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12040.f, 12050.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12050.f, 12060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12060.f, 12070.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12070.f, 12080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12080.f,
				     12090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12090.f, 12100.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12100.f, 12110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12110.f,
				     12120.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12120.f, 12130.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12130.f, 12140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12140.f, 12150.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12150.f, 12160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12160.f,
				     12170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12170.f, 12180.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12180.f, 12190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12190.f,
				     12200.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12200.f, 12210.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12210.f, 12220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12220.f, 12230.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12230.f, 12240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12240.f,
				     12250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12250.f, 12260.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12260.f, 12270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12270.f,
				     12280.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12280.f, 12290.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12290.f, 12300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12300.f, 12310.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12310.f, 12320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12320.f,
				     12330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12330.f, 12340.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12340.f, 12350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12350.f,
				     12360.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12360.f, 12370.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12370.f, 12380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12380.f, 12390.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12390.f, 12400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12400.f,
				     12410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12410.f, 12420.f, 0.f, 0.f, 0.f,

				     0.f,
				     0.f, 0.f, 12420.f, 12430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12430.f,
				     12440.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12440.f, 12450.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12450.f, 12460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12460.f, 12470.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12470.f, 12480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12480.f,
				     12490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12490.f, 12500.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12500.f, 12510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12510.f,
				     12520.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12520.f, 12530.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12530.f, 12540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12540.f, 12550.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12550.f, 12560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12560.f,
				     12570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12570.f, 12580.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12580.f, 12590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12590.f,
				     12600.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12600.f, 12610.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12610.f, 12620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12620.f, 12630.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12630.f, 12640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12640.f,
				     12650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12650.f, 12660.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12660.f, 12670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12670.f,
				     12680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12680.f, 12690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12690.f, 12700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12700.f, 12710.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12710.f, 12720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12720.f,
				     12730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12730.f, 12740.f
    };

    /* carbon monoxide (10180 - 12730 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* moca4 */

void
moca3 (double a[8], const long int inu)
{


    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 7620.f, 7630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7630.f, 7640.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7640.f, 7650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7650.f,
				     7660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7660.f, 7670.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7670.f, 7680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7680.f, 7690.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7690.f, 7700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7700.f,
				     7710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7710.f, 7720.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7720.f, 7730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7730.f, 7740.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7740.f, 7750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7750.f,
				     7760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7760.f, 7770.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7770.f, 7780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7780.f, 7790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7790.f, 7800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7800.f,
				     7810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7810.f, 7820.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7820.f, 7830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7830.f, 7840.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7840.f, 7850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7850.f,
				     7860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7860.f, 7870.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7870.f, 7880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7880.f, 7890.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7890.f, 7900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7900.f,
				     7910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7910.f, 7920.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7920.f, 7930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7930.f, 7940.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7940.f, 7950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7950.f,
				     7960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7960.f, 7970.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7970.f, 7980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7980.f, 7990.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7990.f, 8e3f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8e3f,
				     8010.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8010.f, 8020.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8020.f, 8030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8030.f, 8040.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8040.f, 8050.f, 1.354e-16f, .017736f, .11256f, -4.5834e-4f,
				     .10977f, -4.527e-4f, 8050.f, 8060.f, 4.1572e-16f, .017736f, .10803f,
				     -4.4019e-4f, .10523f, -4.3455e-4f, 8060.f, 8070.f, 1.2473e-15f,
				     .017736f, .10358f, -4.2239e-4f, .10078f, -4.1676e-4f, 8070.f, 8080.f,
				     3.6626e-15f, .017736f, .099217f, -4.0495e-4f, .096419f, -3.9931e-4f,
				     8080.f, 8090.f, 1.0521e-14f, .017736f, .094944f, -3.8786e-4f, .092146f,
				     -3.8222e-4f, 8090.f, 8100.f, 2.9549e-14f, .017736f, .09076f,
				     -3.7112e-4f, .087962f, -3.6548e-4f, 8100.f, 8110.f, 8.1193e-14f,
				     .017736f, .086664f, -3.5474e-4f, .083866f, -3.491e-4f, 8110.f, 8120.f,
				     2.1814e-13f, .017736f, .082657f, -3.3871e-4f, .079859f, -3.3307e-4f,
				     8120.f, 8130.f, 5.7319e-13f, .017736f, .078739f, -3.2303e-4f, .075941f,
				     -3.174e-4f, 8130.f, 8140.f, 1.4733e-12f, .017736f, .07491f, -3.0772e-4f,
				     .072112f, -3.0208e-4f, 8140.f, 8150.f, 3.7005e-12f, .017736f, .07117f,
				     -2.9276e-4f, .068372f, -2.8712e-4f, 8150.f, 8160.f, 9.0898e-12f,
				     .017736f, .067519f, -2.7816e-4f, .064721f, -2.7252e-4f, 8160.f, 8170.f,
				     2.1828e-11f, .017736f, .063958f, -2.6391e-4f, .06116f, -2.5828e-4f,
				     8170.f, 8180.f, 1.6892e-10f, .034043f, .058108f, -2.3936e-4f, .055638f,
				     -2.3553e-4f, 8180.f, 8190.f, 2.6399e-10f, .017736f, .053812f,
				     -2.2333e-4f, .051015f, -2.177e-4f, 8190.f, 8200.f, 5.7886e-10f,
				     .017736f, .050611f, -2.1052e-4f, .047813f, -2.0489e-4f, 8200.f, 8210.f,
				     1.2407e-9f, .017957f, .047499f, -1.9807e-4f, .044701f, -1.9244e-4f,
				     8210.f, 8220.f, 2.5994e-9f, .018179f, .044477f, -1.8599e-4f, .041679f,
				     -1.8035e-4f, 8220.f, 8230.f, 1.596e-8f, .036001f, .039635f, -1.6576e-4f,
				     .03707f, -1.6145e-4f, 8230.f, 8240.f, 2.0795e-8f, .018844f, .035955f,
				     -1.519e-4f, .033157f, -1.4627e-4f, 8240.f, 8250.f, 3.9708e-8f, .019066f,
				     .033295f, -1.4126e-4f, .030497f, -1.3563e-4f, 8250.f, 8260.f,
				     2.0895e-7f, .03799f, .029113f, -1.2386e-4f, .026495f, -1.1926e-4f,
				     8260.f, 8270.f, 2.3995e-7f, .019731f, .025861f, -1.1153e-4f, .023064f,
				     -1.0589e-4f, 8270.f, 8280.f, 4.1681e-7f, .019953f, .023566f,
				     -1.0234e-4f, .020768f, -9.6709e-5f, 8280.f, 8290.f, 1.8774e-6f,
				     .040651f, .020033f, -8.771e-5f, .017363f, -8.2825e-5f, 8290.f, 8300.f,
				     1.8914e-6f, .021283f, .017225f, -7.698e-5f, .014427f, -7.1347e-5f,
				     8300.f, 8310.f, 7.568e-6f, .043989f, .014172f, -6.438e-5f, .011463f,
				     -5.9288e-5f, 8310.f, 8320.f, 6.8789e-6f, .023145f, .011707f,
				     -5.4908e-5f, .0089094f, -4.9275e-5f, 8320.f, 8330.f, 2.4399e-5f,
				     .046699f, .0091256f, -4.4298e-5f, .0063969f, -3.9079e-5f, 8330.f,
				     8340.f, 4.6806e-5f, .049425f, .006215f, -3.2716e-5f, .0034666f,
				     -2.739e-5f, 8340.f, 8350.f, 8.0605e-5f, .050945f, .0036678f,
				     -2.2582e-5f, 9.0701e-4f, -1.718e-5f, 8350.f, 8360.f, 1.2377e-4f,
				     .051881f, .0014843f, -1.3895e-5f, -.0012918f, -8.4086e-6f, 8360.f,
				     8370.f, 1.6751e-4f, .053029f, -3.3537e-4f, -6.6561e-6f, -.0031202f,
				     -1.1154e-6f, 8370.f, 8380.f, 1.9593e-4f, .054802f, -.0017908f,
				     -8.6649e-7f, -.0045868f, 4.7351e-6f, 8380.f, 8390.f, 1.8975e-4f,
				     .058538f, -.0028817f, 3.4723e-6f, -.0056846f, 9.1141e-6f, 8390.f,
				     8400.f, 1.3472e-4f, .062039f, -.0036068f, 6.3564e-6f, -.006417f,
				     1.2035e-5f, 8400.f, 8410.f, 6.4957e-5f, .06993f, -.0039984f, 7.9148e-6f,
				     -.006795f, 1.3543e-5f, 8410.f, 8420.f, 3.0309e-4f, .090113f, -.0036875f,
				     6.6869e-6f, -.0065101f, 1.2442e-5f, 8420.f, 8430.f, 5.1352e-4f, .08362f,
				     -.0026038f, 2.4173e-6f, -.0054145f, 8.1551e-6f, 8430.f, 8440.f,
				     8.2971e-4f, .13049f, 5.179e-5f, -7.5797e-6f, -.0026588f, -2.2561e-6f,
				     8440.f, 8450.f, 4.4414e-4f, .14201f, .0055167f, -2.7842e-5f, .0033215f,
				     -2.3351e-5f, 8450.f, 8460.f, 8.4089e-5f, .17964f, .015226f, -6.0171e-5f,
				     .015481f, -6.3601e-5f, 8460.f, 8470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     8470.f,
				     8480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8480.f, 8490.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8490.f, 8500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8500.f, 8510.f, 0.f,
				     0.f,

				     0.f, 0.f, 0.f, 0.f, 8510.f, 8520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8520.f,
				     8530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8530.f, 8540.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8540.f, 8550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8550.f, 8560.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8560.f, 8570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8570.f,
				     8580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8580.f, 8590.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8590.f, 8600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8600.f, 8610.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8610.f, 8620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8620.f,
				     8630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8630.f, 8640.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8640.f, 8650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8650.f, 8660.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8660.f, 8670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8670.f,
				     8680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8680.f, 8690.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8690.f, 8700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8700.f, 8710.f, 0.f,

				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8710.f, 8720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8720.f,
				     8730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8730.f, 8740.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8740.f, 8750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8750.f, 8760.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8760.f, 8770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8770.f,
				     8780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8780.f, 8790.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8790.f, 8800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8800.f, 8810.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8810.f, 8820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8820.f,
				     8830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8830.f, 8840.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8840.f, 8850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8850.f, 8860.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8860.f, 8870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8870.f,
				     8880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8880.f, 8890.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8890.f, 8900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8900.f, 8910.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8910.f, 8920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8920.f,
				     8930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8930.f, 8940.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8940.f, 8950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8950.f, 8960.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 8960.f, 8970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8970.f,
				     8980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8980.f, 8990.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 8990.f, 9e3f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9e3f, 9010.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9010.f, 9020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9020.f,
				     9030.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9030.f, 9040.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9040.f, 9050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9050.f, 9060.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9060.f, 9070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9070.f,
				     9080.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9080.f, 9090.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9090.f, 9100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9100.f, 9110.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9110.f, 9120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9120.f,
				     9130.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9130.f, 9140.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9140.f, 9150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9150.f, 9160.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9160.f, 9170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9170.f,
				     9180.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9180.f, 9190.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9190.f, 9200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9200.f, 9210.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9210.f, 9220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9220.f,
				     9230.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9230.f, 9240.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9240.f, 9250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9250.f, 9260.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9260.f, 9270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9270.f,
				     9280.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9280.f, 9290.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9290.f, 9300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9300.f, 9310.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9310.f, 9320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9320.f,
				     9330.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9330.f, 9340.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9340.f, 9350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9350.f, 9360.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9360.f, 9370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9370.f,
				     9380.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9380.f, 9390.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9390.f, 9400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9400.f, 9410.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9410.f, 9420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9420.f,
				     9430.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9430.f, 9440.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9440.f, 9450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9450.f, 9460.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9460.f, 9470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9470.f,
				     9480.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9480.f, 9490.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9490.f, 9500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9500.f, 9510.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9510.f, 9520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9520.f,
				     9530.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9530.f, 9540.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9540.f, 9550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9550.f, 9560.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9560.f, 9570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9570.f,
				     9580.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9580.f, 9590.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9590.f, 9600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9600.f, 9610.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9610.f, 9620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9620.f,
				     9630.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9630.f, 9640.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9640.f, 9650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9650.f, 9660.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9660.f, 9670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9670.f,
				     9680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9680.f, 9690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9690.f, 9700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9700.f, 9710.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9710.f, 9720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9720.f,
				     9730.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9730.f, 9740.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9740.f, 9750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9750.f, 9760.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9760.f, 9770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9770.f,
				     9780.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9780.f, 9790.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9790.f, 9800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9800.f, 9810.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9810.f, 9820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9820.f,
				     9830.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9830.f, 9840.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9840.f, 9850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9850.f, 9860.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9860.f, 9870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9870.f,
				     9880.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9880.f, 9890.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9890.f, 9900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9900.f, 9910.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9910.f, 9920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9920.f,
				     9930.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9930.f, 9940.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9940.f, 9950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9950.f, 9960.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9960.f, 9970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9970.f,
				     9980.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9980.f, 9990.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9990.f, 1e4f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1e4f, 10010.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10010.f, 10020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10020.f,
				     10030.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10030.f, 10040.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10040.f, 10050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10050.f, 10060.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10060.f, 10070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10070.f,
				     10080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10080.f, 10090.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10090.f, 10100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10100.f,
				     10110.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10110.f, 10120.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10120.f, 10130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10130.f, 10140.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10140.f, 10150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10150.f,
				     10160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10160.f, 10170.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10170.f, 10180.f
    };

    /* carbon monoxide (7600 - 10170 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* moca3 */

void
moca2 (double a[8], const long int inu)
{


    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 5060.f, 5070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5070.f, 5080.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5080.f, 5090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5090.f,
				     5100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5100.f, 5110.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5110.f, 5120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5120.f, 5130.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5130.f, 5140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5140.f,
				     5150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5150.f, 5160.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5160.f, 5170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5170.f, 5180.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5180.f, 5190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5190.f,
				     5200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5200.f, 5210.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5210.f, 5220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5220.f, 5230.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5230.f, 5240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5240.f,
				     5250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5250.f, 5260.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5260.f, 5270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5270.f, 5280.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5280.f, 5290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5290.f,
				     5300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5300.f, 5310.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5310.f, 5320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5320.f, 5330.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5330.f, 5340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5340.f,
				     5350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5350.f, 5360.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5360.f, 5370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5370.f, 5380.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5380.f, 5390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5390.f,
				     5400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5400.f, 5410.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5410.f, 5420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5420.f, 5430.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5430.f, 5440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5440.f,
				     5450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5450.f, 5460.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5460.f, 5470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5470.f, 5480.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5480.f, 5490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5490.f,
				     5500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5500.f, 5510.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5510.f, 5520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5520.f, 5530.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5530.f, 5540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5540.f,
				     5550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5550.f, 5560.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5560.f, 5570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5570.f, 5580.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5580.f, 5590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5590.f,
				     5600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5600.f, 5610.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5610.f, 5620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5620.f, 5630.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5630.f, 5640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5640.f,
				     5650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5650.f, 5660.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 5660.f, 5670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5670.f, 5680.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 5680.f, 5690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5690.f,
				     5700.f, 4.6683e-26f, 3.9946e-7f, .15004f, -6.0825e-4f, .14724f,
				     -6.0261e-4f, 5700.f, 5710.f, 1.2312e-25f, 3.9946e-7f, .14595f,
				     -5.9188e-4f, .14315f, -5.8625e-4f, 5710.f, 5720.f, 1.1266e-24f,
				     7.5927e-7f, .13909f, -5.6295e-4f, .13671f, -5.5959e-4f, 5720.f, 5730.f,
				     2.0103e-24f, 3.9946e-7f, .13415f, -5.447e-4f, .13135f, -5.3906e-4f,
				     5730.f, 5740.f, 4.9063e-24f, 3.9946e-7f, .13038f, -5.2961e-4f, .12758f,
				     -5.2397e-4f, 5740.f, 5750.f, 3.9255e-23f, 7.6518e-7f, .12413f,
				     -5.0331e-4f, .12169f, -4.9966e-4f, 5750.f, 5760.f, 6.3305e-23f,
				     3.9946e-7f, .11954f, -4.8626e-4f, .11675f, -4.8063e-4f, 5760.f, 5770.f,
				     1.5847e-21f, 1.0092e-6f, .10516f, -4.1519e-4f, .10467f, -4.2332e-4f,
				     5770.f, 5780.f, 3.6811e-21f, 7.1016e-7f, .09985f, -3.9815e-4f, .098651f,
				     -4.013e-4f, 5780.f, 5790.f, 3.2319e-20f, 1.2898e-6f, .092607f,
				     -3.6764e-4f, .092132f, -3.7318e-4f, 5790.f, 5800.f, 5.6403e-20f,

				     6.4883e-7f, .087374f, -3.4877e-4f, .086636f, -3.5122e-4f, 5800.f,
				     5810.f, 1.6009e-19f, 9.5335e-7f, .0849f, -3.3381e-4f, .084844f,
				     -3.4257e-4f, 5810.f, 5820.f, 1.0493e-18f, 1.0941e-6f, .076482f,
				     -3.0762e-4f, .080072f, -2.5402e-4f, 5820.f, 5830.f, 1.8849e-18f,
				     2.3089e-6f, .073551f, -2.7995e-4f, .10134f, -1.0464e-4f, 5830.f, 5840.f,
				     1.2274e-17f, 1.8503e-6f, .065955f, -2.6262e-4f, .08719f, -6.1536e-5f,
				     5840.f, 5850.f, 1.9475e-17f, 2.1482e-6f, .062641f, -2.3947e-4f,
				     .092133f, -5.5475e-5f, 5850.f, 5860.f, 4.2834e-17f, 5.2914e-6f,
				     .060443f, -2.1227e-4f, .10022f, -9.1581e-5f, 5860.f, 5870.f,
				     2.5814e-16f, 2.709e-6f, .053613f, -2.0674e-4f, .078473f, -2.4556e-5f,
				     5870.f, 5880.f, 3.4582e-16f, 2.4018e-6f, .049817f, -1.8578e-4f,
				     .083893f, -9.9109e-6f, 5880.f, 5890.f, 1.9766e-15f, 2.6621e-6f,
				     .044522f, -1.7276e-4f, .070531f, 1.7855e-5f, 5890.f, 5900.f,
				     7.0047e-15f, 5.7066e-6f, .039496f, -1.4181e-4f, .075654f, 5.7712e-6f,
				     5900.f, 5910.f, 8.6757e-15f, 3.3052e-5f, .040851f, -4.9822e-5f,
				     .088823f, -2.0654e-4f, 5910.f, 5920.f, 4.0761e-14f, 1.4076e-5f,
				     .033721f, -8.1073e-5f, .073952f, -7.155e-5f, 5920.f, 5930.f,
				     1.1802e-13f, 1.8315e-5f, .029401f, -5.6811e-5f, .072527f, -6.1682e-5f,
				     5930.f, 5940.f, 1.2517e-13f, 3.208e-5f, .029645f, 5.2262e-6f, .075673f,
				     -1.605e-4f, 5940.f, 5950.f, 5.3299e-13f, 8.3885e-5f, .028648f,
				     5.1037e-5f, .076701f, -1.1804e-4f, 5950.f, 5960.f, 1.2176e-12f,
				     4.3932e-5f, .023072f, 3.9649e-5f, .070157f, -2.5205e-5f, 5960.f, 5970.f,
				     2.6812e-12f, 7.4724e-5f, .021392f, 7.8492e-5f, .0689f, -5.7739e-5f,
				     5970.f, 5980.f, 5.2852e-12f, 8.1623e-5f, .018441f, 9.2123e-5f, .072474f,
				     3.8196e-5f, 5980.f, 5990.f, 1.2137e-11f, 2.5414e-4f, .024162f,
				     1.7686e-4f, .065473f, -1.1219e-4f, 5990.f, 6e3f, 2.022e-11f, 1.7439e-4f,
				     .021342f, 1.7061e-4f, .061647f, -4.9481e-5f, 6e3f, 6010.f, 7.0256e-11f,
				     3.9013e-4f, .025354f, 1.739e-4f, .056294f, -1.0119e-4f, 6010.f, 6020.f,
				     9.1715e-11f, 3.8456e-4f, .027846f, 1.3835e-4f, .055857f, -8.5738e-5f,
				     6020.f, 6030.f, 3.5812e-10f, 8.9526e-4f, .036811f, -1.9691e-5f,
				     .060026f, -5.1263e-5f, 6030.f, 6040.f, 5.1951e-10f, 6.5082e-4f,
				     .034472f, -3.8106e-5f, .057771f, -1.7166e-5f, 6040.f, 6050.f,
				     2.3396e-9f, .0012585f, .037673f, -1.3867e-4f, .056388f, -3.7053e-5f,
				     6050.f, 6060.f, 3.1627e-9f, .0012183f, .033941f, -1.1427e-4f, .058265f,
				     -1.4231e-5f, 6060.f, 6070.f, 1.3747e-8f, .0010905f, .030224f,
				     -1.1494e-4f, .045888f, -1.243e-5f, 6070.f, 6080.f, 1.6746e-8f,
				     .0011055f, .0271f, -9.4052e-5f, .048795f, 1.7267e-6f, 6080.f, 6090.f,
				     6.9627e-8f, .0014531f, .023474f, -8.7211e-5f, .042687f, 2.9187e-5f,
				     6090.f, 6100.f, 1.789e-7f, .0023713f, .020122f, -5.984e-5f, .042924f,
				     9.3171e-6f, 6100.f, 6110.f, 1.6918e-7f, .002373f, .018564f, -3.2576e-5f,
				     .047913f, -5.6001e-6f, 6110.f, 6120.f, 6.1497e-7f, .0020751f, .014671f,
				     -3.6986e-5f, .03447f, 3.2655e-5f, 6120.f, 6130.f, 1.3012e-6f, .0059809f,
				     .014081f, 1.2706e-5f, .041059f, -1.4713e-5f, 6130.f, 6140.f, 2.3687e-6f,
				     .0034824f, .010334f, 1.187e-5f, .031822f, 2.134e-5f, 6140.f, 6150.f,
				     4.1168e-6f, .0049295f, .0084797f, 3.3745e-5f, .032297f, 2.8091e-5f,
				     6150.f, 6160.f, 7.275e-6f, .015527f, .012669f, 9.9217e-5f, .036777f,
				     -5.5634e-5f, 6160.f, 6170.f, 9.7222e-6f, .0091547f, .010267f,
				     9.5535e-5f, .030194f, -2.5674e-5f, 6170.f, 6180.f, 1.7703e-5f, .012682f,
				     .0090194f, 1.0461e-4f, .028528f, -8.8439e-6f, 6180.f, 6190.f,
				     3.2557e-5f, .038848f, .022453f, 5.1526e-5f, .032595f, -1.0114e-4f,
				     6190.f, 6200.f, 3.6378e-5f, .026446f, .022869f, 1.5344e-5f, .029472f,
				     -7.8062e-5f, 6200.f, 6210.f, 1.5091e-4f, .045107f, .027472f,
				     -9.5379e-5f, .027231f, -1.0428e-4f, 6210.f, 6220.f, 4.4635e-4f,
				     .044617f, .022992f, -8.3379e-5f, .022135f, -8.6546e-5f, 6220.f, 6230.f,
				     4.645e-4f, .025101f, .020065f, -7.4635e-5f, .019585f, -7.1162e-5f,
				     6230.f, 6240.f, .0018567f, .045449f, .017769f, -7.6382e-5f, .015878f,
				     -6.8709e-5f, 6240.f, 6250.f, .0042909f, .047419f, .01417f, -6.399e-5f,
				     .012295f, -5.5119e-5f, 6250.f, 6260.f, .0037371f, .024446f, .011714f,
				     -5.4834e-5f, .0096092f, -4.6244e-5f, 6260.f, 6270.f, .012658f, .047613f,
				     .0091389f, -4.4311e-5f, .006717f, -3.7584e-5f, 6270.f, 6280.f, .022981f,
				     .050782f, .0062294f, -3.2686e-5f, .0039945f, -2.4418e-5f, 6280.f,
				     6290.f, .03751f, .052128f, .0036805f, -2.2546e-5f, .0014034f,
				     -1.3971e-5f, 6290.f, 6300.f, .054636f, .053047f, .0014952f, -1.3854e-5f,
				     -7.4579e-4f, -4.3465e-6f, 6300.f, 6310.f, .070262f, .053883f,
				     -3.2751e-4f, -6.6345e-6f, -.0026603f, 2.8956e-6f, 6310.f, 6320.f,
				     .078204f, .055207f, -.0017859f, -8.6799e-7f, -.0043181f, 7.5236e-6f,
				     6320.f, 6330.f, .10057f, .088588f, -.0030519f, 4.1846e-6f, -.0057894f,
				     1.0937e-5f, 6330.f, 6340.f, .031333f, .065185f, -.0038296f, 7.2424e-6f,
				     -.006643f, 1.2937e-5f, 6340.f, 6350.f, .033845f, .06492f, -.0039811f,
				     7.8455e-6f, -.0067871f, 1.3512e-5f, 6350.f, 6360.f, .12178f, .088198f,
				     -.0034193f, 5.6304e-6f, -.0062387f, 1.1334e-5f, 6360.f, 6370.f, .15914f,
				     .081345f, -.0020733f, 3.2783e-7f, -.0048764f, 5.9258e-6f, 6370.f,
				     6380.f, .17605f, .10382f, 4.7396e-4f, -9.4825e-6f, -.0022623f,
				     -4.3366e-6f, 6380.f, 6390.f, .10257f, .11943f, .0050797f, -2.6879e-5f,
				     .002564f, -2.3075e-5f, 6390.f, 6400.f, .025341f, .11996f, .012613f,
				     -5.5092e-5f, .010613f, -5.3927e-5f, 6400.f, 6410.f, .0020638f, .13697f,
				     .024524f, -9.7954e-5f, .025258f, -9.9948e-5f, 6410.f, 6420.f, 0.f, 0.f,
				     0.f, 0.f, 0.f, 0.f, 6420.f, 6430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6430.f,
				     6440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6440.f, 6450.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6450.f, 6460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6460.f, 6470.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6470.f, 6480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6480.f,
				     6490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6490.f, 6500.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6500.f, 6510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6510.f, 6520.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6520.f, 6530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6530.f,
				     6540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6540.f, 6550.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6550.f, 6560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6560.f, 6570.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6570.f, 6580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6580.f,
				     6590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6590.f, 6600.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6600.f, 6610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6610.f, 6620.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6620.f, 6630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6630.f,
				     6640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6640.f, 6650.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6650.f, 6660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6660.f, 6670.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6670.f, 6680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6680.f,
				     6690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6690.f, 6700.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6700.f, 6710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6710.f, 6720.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6720.f, 6730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6730.f,
				     6740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6740.f, 6750.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6750.f, 6760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6760.f, 6770.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6770.f, 6780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6780.f,
				     6790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6790.f, 6800.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6800.f, 6810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6810.f, 6820.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6820.f, 6830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6830.f,
				     6840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6840.f, 6850.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6850.f, 6860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6860.f, 6870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6870.f, 6880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6880.f,
				     6890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6890.f, 6900.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6900.f, 6910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6910.f, 6920.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6920.f, 6930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6930.f,
				     6940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6940.f, 6950.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 6950.f, 6960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6960.f, 6970.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 6970.f, 6980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6980.f,
				     6990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 6990.f, 7e3f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 7e3f, 7010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7010.f, 7020.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7020.f, 7030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7030.f,
				     7040.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7040.f, 7050.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7050.f, 7060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7060.f, 7070.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7070.f, 7080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7080.f,
				     7090.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7090.f, 7100.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7100.f, 7110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7110.f, 7120.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7120.f, 7130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7130.f,
				     7140.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7140.f, 7150.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7150.f, 7160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7160.f, 7170.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7170.f, 7180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7180.f,
				     7190.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7190.f, 7200.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7200.f, 7210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7210.f, 7220.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7220.f, 7230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7230.f,
				     7240.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7240.f, 7250.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7250.f, 7260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7260.f, 7270.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7270.f, 7280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7280.f,
				     7290.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7290.f, 7300.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7300.f, 7310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7310.f, 7320.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7320.f, 7330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7330.f,
				     7340.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7340.f, 7350.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7350.f, 7360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7360.f, 7370.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7370.f, 7380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7380.f,
				     7390.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7390.f, 7400.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7400.f, 7410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7410.f, 7420.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7420.f, 7430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7430.f,
				     7440.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7440.f, 7450.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7450.f, 7460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7460.f, 7470.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7470.f, 7480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7480.f,
				     7490.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7490.f, 7500.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7500.f, 7510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7510.f, 7520.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7520.f, 7530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7530.f,
				     7540.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7540.f, 7550.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7550.f, 7560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7560.f, 7570.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 7570.f, 7580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7580.f,
				     7590.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7590.f, 7600.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     7600.f, 7610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7610.f, 7620.f
    };

    /* carbon monoxide (5060 - 7610 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* moca2 */

void
moca1 (double a[8], const long int inu)
{


    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 2500.f, 2510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2510.f, 2520.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2520.f, 2530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2530.f,
				     2540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2540.f, 2550.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2550.f, 2560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2560.f, 2570.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2570.f, 2580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2580.f,
				     2590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2590.f, 2600.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2600.f, 2610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2610.f, 2620.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2620.f, 2630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2630.f,
				     2640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2640.f, 2650.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2650.f, 2660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2660.f, 2670.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2670.f, 2680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2680.f,
				     2690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2690.f, 2700.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2700.f, 2710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2710.f, 2720.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2720.f, 2730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2730.f,
				     2740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2740.f, 2750.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2750.f, 2760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2760.f, 2770.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2770.f, 2780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2780.f,
				     2790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2790.f, 2800.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2800.f, 2810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2810.f, 2820.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2820.f, 2830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2830.f,
				     2840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2840.f, 2850.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2850.f, 2860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2860.f, 2870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2870.f, 2880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2880.f,
				     2890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2890.f, 2900.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2900.f, 2910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2910.f, 2920.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2920.f, 2930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2930.f,
				     2940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2940.f, 2950.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 2950.f, 2960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2960.f, 2970.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 2970.f, 2980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2980.f,
				     2990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 2990.f, 3e3f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 3e3f, 3010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3010.f, 3020.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3020.f, 3030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3030.f,
				     3040.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3040.f, 3050.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3050.f, 3060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3060.f, 3070.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3070.f, 3080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3080.f,
				     3090.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3090.f, 3100.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3100.f, 3110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3110.f, 3120.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3120.f, 3130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3130.f,
				     3140.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3140.f, 3150.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3150.f, 3160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3160.f, 3170.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3170.f, 3180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3180.f,
				     3190.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3190.f, 3200.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3200.f, 3210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3210.f, 3220.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3220.f, 3230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3230.f,
				     3240.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3240.f, 3250.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3250.f, 3260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3260.f, 3270.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3270.f, 3280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3280.f,
				     3290.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3290.f, 3300.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3300.f, 3310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3310.f, 3320.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3320.f, 3330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3330.f,
				     3340.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3340.f, 3350.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3350.f, 3360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3360.f, 3370.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3370.f, 3380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3380.f,
				     3390.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3390.f, 3400.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3400.f, 3410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3410.f, 3420.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3420.f, 3430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3430.f,
				     3440.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3440.f, 3450.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3450.f, 3460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3460.f, 3470.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3470.f, 3480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3480.f,
				     3490.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3490.f, 3500.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3500.f, 3510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3510.f, 3520.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3520.f, 3530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3530.f,
				     3540.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3540.f, 3550.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3550.f, 3560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3560.f, 3570.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3570.f, 3580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3580.f,
				     3590.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3590.f, 3600.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3600.f, 3610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3610.f, 3620.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3620.f, 3630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3630.f,
				     3640.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3640.f, 3650.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3650.f, 3660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3660.f, 3670.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3670.f, 3680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3680.f,
				     3690.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3690.f, 3700.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3700.f, 3710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3710.f, 3720.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 3720.f, 3730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3730.f,
				     3740.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3740.f, 3750.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     3750.f, 3760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 3760.f, 3770.f, 2.6188e-23f,
				     7.5648e-7f, .14705f, -5.9469e-4f, .14469f, -5.9147e-4f, 3770.f, 3780.f,
				     1.7237e-22f, 7.5958e-7f, .13909f, -5.6296e-4f, .13671f, -5.596e-4f,
				     3780.f, 3790.f, 3.0601e-22f, 3.9946e-7f, .13415f, -5.447e-4f, .13135f,
				     -5.3906e-4f, 3790.f, 3800.f, 2.5148e-21f, 7.6406e-7f, .12775f,
				     -5.1775e-4f, .12533f, -5.1417e-4f, 3800.f, 3810.f, 2.5745e-19f,
				     6.6661e-7f, .10289f, -4.1172e-4f, .10359f, -4.1229e-4f, 3810.f, 3820.f,
				     2.3471e-18f, 8.5834e-7f, .095064f, -3.8496e-4f, .093786f, -3.8192e-4f,
				     3820.f, 3830.f, 4.4267e-18f, 6.1131e-7f, .090479f, -3.6372e-4f,
				     .091063f, -3.6128e-4f, 3830.f, 3840.f, 3.7544e-17f, 9.6342e-7f,
				     .083552f, -3.3748e-4f, .083109f, -3.3494e-4f, 3840.f, 3850.f,
				     6.6043e-17f, 4.5762e-6f, .080581f, -2.9237e-4f, .1186f, -1.9899e-4f,
				     3850.f, 3860.f, 5.0104e-16f, 3.0566e-6f, .073204f, -2.8334e-4f, .10085f,
				     -1.1404e-4f, 3860.f, 3870.f, 2.5102e-15f, 5.6505e-6f, .066558f,
				     -2.4745e-4f, .10411f, -1.0858e-4f, 3870.f, 3880.f, 1.179e-14f,
				     7.1883e-6f, .060355f, -2.1477e-4f, .099433f, -1.0798e-4f, 3880.f,
				     3890.f, 1.7518e-14f, 1.0491e-5f, .058888f, -1.6207e-4f, .09819f,
				     -2.0655e-4f, 3890.f, 3900.f, 1.2334e-13f, 8.2478e-5f, .061162f,
				     -4.6855e-5f, .099456f, -3.0433e-4f, 3900.f, 3910.f, 5.9987e-13f,
				     1.9476e-4f, .061687f, 1.0764e-5f, .093436f, -3.2996e-4f, 3910.f, 3920.f,
				     1.7948e-12f, 9.9622e-5f, .052116f, 1.2152e-5f, .087699f, -2.7025e-4f,
				     3920.f, 3930.f, 8.3226e-12f, 3.291e-4f, .054625f, 5.1416e-5f, .089131f,
				     -2.3629e-4f, 3930.f, 3940.f, 2.0276e-11f, 2.1725e-4f, .045681f,
				     6.3672e-5f, .093594f, -1.044e-4f, 3940.f, 3950.f, 9.452e-11f,
				     4.2081e-4f, .049658f, 5.7601e-5f, .079407f, -1.9603e-4f, 3950.f, 3960.f,
				     2.0604e-10f, 4.2113e-4f, .043092f, 7.9797e-5f, .08456f, -1.0065e-4f,
				     3960.f, 3970.f, 9.2559e-10f, 5.2769e-4f, .046842f, 2.13e-5f, .070955f,
				     -1.5981e-4f, 3970.f, 3980.f, 4.0093e-9f, .0016525f, .048905f,
				     -4.3479e-5f, .080584f, -1.3211e-4f, 3980.f, 3990.f, 7.2188e-9f,
				     .0049631f, .047903f, 3.506e-5f, .087341f, -2.2515e-4f, 3990.f, 4e3f,
				     3.5244e-8f, .0026406f, .044217f, -4.3905e-5f, .074799f, -1.3539e-4f,
				     4e3f, 4010.f, 1.4041e-7f, .0058689f, .045795f, -7.4645e-5f, .073346f,
				     -1.7741e-4f, 4010.f, 4020.f, 4.8242e-7f, .0031728f, .03946f,
				     -9.4315e-5f, .063747f, -1.0552e-4f, 4020.f, 4030.f, 1.5614e-6f,
				     .0029789f, .03481f, -9.4517e-5f, .058578f, -7.6764e-5f, 4030.f, 4040.f,
				     2.3212e-6f, .011038f, .038571f, -4.0092e-6f, .064826f, -1.8611e-4f,
				     4040.f, 4050.f, 1.0679e-5f, .014942f, .035924f, 2.0954e-7f, .05826f,
				     -1.6362e-4f, 4050.f, 4060.f, 2.5314e-5f, .0076112f, .028757f,
				     -2.7274e-6f, .050639f, -1.0468e-4f, 4060.f, 4070.f, 8.2488e-5f,
				     .019238f, .031099f, 3.2981e-5f, .049127f, -1.4923e-4f, 4070.f, 4080.f,
				     1.5838e-4f, .010696f, .024633f, 3.8132e-5f, .04326f, -9.7166e-5f,
				     4080.f, 4090.f, 5.3014e-4f, .027912f, .028944f, 3.4086e-5f, .042425f,
				     -1.3608e-4f, 4090.f, 4100.f, .0019236f, .031464f, .026171f, 2.5248e-5f,
				     .036412f, -1.1618e-4f, 4100.f, 4110.f, .002417f, .018774f, .023171f,
				     3.1047e-5f, .032949f, -9.3254e-5f, 4110.f, 4120.f, .0095957f, .039252f,
				     .027808f, -5.0845e-5f, .030866f, -1.1461e-4f, 4120.f, 4130.f, .029222f,
				     .041309f, .025476f, -7.0834e-5f, .025927f, -9.9072e-5f, 4130.f, 4140.f,
				     .080521f, .042144f, .023591f, -9.2915e-5f, .022029f, -9.0905e-5f,
				     4140.f, 4150.f, .21163f, .043454f, .019801f, -8.4058e-5f, .017719f,
				     -7.6225e-5f, 4150.f, 4160.f, .20177f, .023178f, .017214f, -7.6243e-5f,
				     .015553f, -6.4832e-5f, 4160.f, 4170.f, .7632f, .046725f, .01416f,
				     -6.3818e-5f, .012147f, -5.4565e-5f, 4170.f, 4180.f, 1.5947f, .047792f,
				     .010708f, -5.0352e-5f, .0083233f, -4.2778e-5f, 4180.f, 4190.f, 5.2669f,
				     .073957f, .0067643f, -3.4467e-5f, .004319f, -2.8069e-5f, 4190.f, 4200.f,
				     6.4202f, .051382f, .0036772f, -2.2614e-5f, 9.742e-4f, -1.6763e-5f,
				     4200.f, 4210.f, 9.2445f, .052627f, .0014938f, -1.3915e-5f, -.0010491f,
				     -6.9012e-6f, 4210.f, 4220.f, 11.75f, .05381f, -3.2681e-4f, -6.6562e-6f,
				     -.0028054f, 1.0375e-6f, 4220.f, 4230.f, 12.919f, .055506f, -.0017838f,
				     -8.5608e-7f, -.0042665f, 7.1579e-6f, 4230.f, 4240.f, 16.381f, .089081f,
				     -.003049f, 4.1985e-6f, -.0056615f, 1.1648e-5f, 4240.f, 4250.f, 5.0278f,
				     .066105f, -.0038255f, 7.3053e-6f, -.0061865f, 1.7191e-5f, 4250.f,
				     4260.f, 5.3208f, .065464f, -.0039797f, 7.8726e-6f, -.006508f,
				     1.6403e-5f, 4260.f, 4270.f, 18.844f, .088395f, -.0034205f, 5.6382e-6f,
				     -.0061631f, 1.2216e-5f, 4270.f, 4280.f, 24.188f, .081391f, -.0020758f,
				     3.3792e-7f, -.004851f, 6.276e-6f, 4280.f, 4290.f, 20.85f, .078388f,
				     7.1143e-5f, -8.1227e-6f, -.0026924f, -2.6258e-6f, 4290.f, 4300.f,
				     16.326f, .099662f, .003472f, -2.1159e-5f, 8.2032e-4f, -1.6489e-5f,
				     4300.f, 4310.f, 5.9676f, .090468f, .0087017f, -4.1571e-5f, .0061894f,
				     -3.7687e-5f, 4310.f, 4320.f, 1.4674f, .080452f, .015334f, -6.7528e-5f,
				     .012977f, -6.4486e-5f, 4320.f, 4330.f, .26137f, .087098f, .023749f,
				     -9.9448e-5f, .02192f, -9.8971e-5f, 4330.f, 4340.f, .017052f, .094008f,
				     .036064f, -1.4594e-4f, .035363f, -1.4924e-4f, 4340.f, 4350.f,
				     1.3974e-4f, .088019f, .056495f, -2.2628e-4f, .057375f, -2.2878e-4f,
				     4350.f, 4360.f, 2.5708e-10f, .017736f, .10803f, -4.4019e-4f, .10523f,
				     -4.3455e-4f, 4360.f, 4370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4370.f, 4380.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4380.f, 4390.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4390.f, 4400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4400.f, 4410.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4410.f, 4420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4420.f,
				     4430.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4430.f, 4440.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4440.f, 4450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4450.f, 4460.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4460.f, 4470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4470.f,
				     4480.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4480.f, 4490.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4490.f, 4500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4500.f, 4510.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4510.f, 4520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4520.f,
				     4530.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4530.f, 4540.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4540.f, 4550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4550.f, 4560.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4560.f, 4570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4570.f,
				     4580.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4580.f, 4590.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4590.f, 4600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4600.f, 4610.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4610.f, 4620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4620.f,
				     4630.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4630.f, 4640.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4640.f, 4650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4650.f, 4660.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4660.f, 4670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4670.f,
				     4680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4680.f, 4690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4690.f, 4700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4700.f, 4710.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4710.f, 4720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4720.f,
				     4730.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4730.f, 4740.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4740.f, 4750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4750.f, 4760.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4760.f, 4770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4770.f,
				     4780.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4780.f, 4790.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4790.f, 4800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4800.f, 4810.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4810.f, 4820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4820.f,

				     4830.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4830.f, 4840.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4840.f, 4850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4850.f, 4860.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4860.f, 4870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4870.f,
				     4880.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4880.f, 4890.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4890.f, 4900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4900.f, 4910.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4910.f, 4920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4920.f,
				     4930.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4930.f, 4940.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4940.f, 4950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4950.f, 4960.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 4960.f, 4970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4970.f,
				     4980.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 4980.f, 4990.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     4990.f, 5e3f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5e3f, 5010.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 5010.f, 5020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5020.f, 5030.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 5030.f, 5040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     5040.f,
				     5050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 5050.f, 5060.f
    };

    /* carbon monoxide (2500 - 5050 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* moca1 */


void
oxyg6 (double a[8], const long int inu)
{


    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 15300.f, 15310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15310.f, 15320.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 15320.f, 15330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15330.f, 15340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15340.f, 15350.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15350.f, 15360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15360.f,
				     15370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15370.f, 15380.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15380.f, 15390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15390.f,
				     15400.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15400.f, 15410.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15410.f, 15420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15420.f, 15430.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15430.f, 15440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15440.f,
				     15450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15450.f, 15460.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15460.f, 15470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15470.f,
				     15480.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15480.f, 15490.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15490.f, 15500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15500.f, 15510.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15510.f, 15520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15520.f,
				     15530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15530.f, 15540.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15540.f, 15550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15550.f,
				     15560.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15560.f, 15570.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15570.f, 15580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15580.f, 15590.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15590.f, 15600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15600.f,
				     15610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15610.f, 15620.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15620.f, 15630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15630.f,
				     15640.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15640.f, 15650.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15650.f, 15660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15660.f, 15670.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15670.f, 15680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15680.f,
				     15690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15690.f, 15700.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15700.f, 15710.f, 1.596e-8f, .018194f, .038561f, -1.5424e-4f,
				     .036533f, -1.5016e-4f, 15710.f, 15720.f, 1.5504e-8f, .018194f, .03852f,
				     -1.5408e-4f, .036492f, -1.5e-4f, 15720.f, 15730.f, 8.6149e-8f, .036385f,
				     .03409f, -1.3636e-4f, .032063f, -1.3228e-4f, 15730.f, 15740.f, 0.f, 0.f,
				     0.f, 0.f, 0.f, 0.f, 15740.f, 15750.f, 2.2012e-7f, .036385f, .029911f,
				     -1.1964e-4f, .027883f, -1.1556e-4f, 15750.f, 15760.f, 5.2469e-7f,
				     .036384f, .026002f, -1.0401e-4f, .023974f, -9.9924e-5f, 15760.f,
				     15770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15770.f, 15780.f, 1.1652e-6f,
				     .037236f, .022365f, -8.9458e-5f, .020337f, -8.5374e-5f, 15780.f,
				     15790.f, 2.4086e-6f, .038115f, .019f, -7.5998e-5f, .016972f,
				     -7.1915e-5f, 15790.f, 15800.f, 4.63e-6f, .039407f, .015907f,
				     -6.3629e-5f, .01388f, -5.9545e-5f, 15800.f, 15810.f, 4.2478e-6f,
				     .019927f, .01311f, -5.2439e-5f, .011082f, -4.8357e-5f, 15810.f, 15820.f,
				     4.0121e-6f, .019927f, .013066f, -5.2262e-5f, .011038f, -4.818e-5f,
				     15820.f, 15830.f, 1.3653e-5f, .041148f, .010543f, -4.2171e-5f,
				     .0085153f, -3.8088e-5f, 15830.f, 15840.f, 2.0849e-5f, .04334f,
				     .0082714f, -3.3085e-5f, .0062412f, -2.8988e-5f, 15840.f, 15850.f,
				     2.9295e-5f, .044164f, .0062748f, -2.5099e-5f, .004247f, -2.1015e-5f,
				     15850.f, 15860.f, 3.768e-5f, .045464f, .0045528f, -1.8211e-5f, .002525f,
				     -1.4127e-5f, 15860.f, 15870.f, 6.8735e-5f, .070552f, .0026882f,
				     -1.0606e-5f, 6.7182e-4f, -6.6419e-6f, 15870.f, 15880.f, 6.2284e-5f,
				     .071735f, .0013301f, -5.2392e-6f, -7.0196e-4f, -1.1788e-6f, 15880.f,
				     15890.f, 3.9741e-5f, .0779f, 3.5779e-4f, -1.1367e-6f, -.0013542f,
				     4.5537e-6f, 15890.f, 15900.f, 1.6287e-5f, .058682f, 3.1178e-4f,
				     2.4589e-6f, 5.313e-4f, 1.3293e-5f, 15900.f, 15910.f, 9.9855e-5f,
				     .14228f, .0013456f, -1.6726e-6f, .0010356f, 3.4749e-6f, 15910.f,
				     15920.f, 1.9246e-4f, .31716f, .005754f, -1.6318e-5f, .0052332f,
				     -1.9378e-5f, 15920.f, 15930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15930.f,
				     15940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15940.f, 15950.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15950.f, 15960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15960.f,
				     15970.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15970.f, 15980.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15980.f, 15990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15990.f, 1.6e4f, 0.f, 0.f,
				     0.f, 0.f, 0.f, 0.f, 1.6e4f, 16010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16010.f,
				     16020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16020.f, 16030.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16030.f, 16040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16040.f,
				     16050.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16050.f, 16060.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16060.f, 16070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16070.f, 16080.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16080.f, 16090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16090.f,
				     16100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16100.f, 16110.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16110.f, 16120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16120.f,
				     16130.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16130.f, 16140.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16140.f, 16150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16150.f, 16160.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16160.f, 16170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16170.f,
				     16180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16180.f, 16190.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16190.f, 16200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16200.f,
				     16210.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16210.f, 16220.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16220.f, 16230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16230.f, 16240.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16240.f, 16250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16250.f,
				     16260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16260.f, 16270.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16270.f, 16280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16280.f,
				     16290.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16290.f, 16300.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16300.f, 16310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16310.f, 16320.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16320.f, 16330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16330.f,
				     16340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16340.f, 16350.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16350.f, 16360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16360.f,
				     16370.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16370.f, 16380.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16380.f, 16390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16390.f, 16400.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16400.f, 16410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16410.f,
				     16420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16420.f, 16430.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16430.f, 16440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16440.f,
				     16450.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16450.f, 16460.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16460.f, 16470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16470.f, 16480.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16480.f, 16490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16490.f,
				     16500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16500.f, 16510.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16510.f, 16520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16520.f,
				     16530.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16530.f, 16540.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16540.f, 16550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16550.f, 16560.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16560.f, 16570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16570.f,
				     16580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16580.f, 16590.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16590.f, 16600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16600.f,
				     16610.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16610.f, 16620.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16620.f, 16630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16630.f, 16640.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16640.f, 16650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16650.f,
				     16660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16660.f, 16670.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16670.f, 16680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16680.f,
				     16690.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16690.f, 16700.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16700.f, 16710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16710.f, 16720.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16720.f, 16730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16730.f,
				     16740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16740.f, 16750.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16750.f, 16760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16760.f,
				     16770.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16770.f, 16780.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16780.f, 16790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16790.f, 16800.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16800.f, 16810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16810.f,
				     16820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16820.f, 16830.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16830.f, 16840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16840.f,
				     16850.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16850.f, 16860.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16860.f, 16870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16870.f, 16880.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16880.f, 16890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16890.f,
				     16900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16900.f, 16910.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16910.f, 16920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16920.f,
				     16930.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16930.f, 16940.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     16940.f, 16950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16950.f, 16960.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 16960.f, 16970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     16970.f,
				     16980.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 16980.f, 16990.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 16990.f, 1.7e4f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.7e4f, 17010.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 17010.f, 17020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17020.f, 17030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17030.f, 17040.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17040.f, 17050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17050.f,
				     17060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17060.f, 17070.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17070.f, 17080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17080.f,
				     17090.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17090.f, 17100.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17100.f, 17110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17110.f, 17120.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17120.f, 17130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17130.f,
				     17140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17140.f, 17150.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17150.f, 17160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17160.f,
				     17170.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17170.f, 17180.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17180.f, 17190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17190.f, 17200.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17200.f, 17210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17210.f,
				     17220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17220.f, 17230.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17230.f, 17240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17240.f,
				     17250.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17250.f, 17260.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17260.f, 17270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17270.f, 17280.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17280.f, 17290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17290.f,
				     17300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17300.f, 17310.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17310.f, 17320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17320.f,
				     17330.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17330.f, 17340.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17340.f, 17350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17350.f, 17360.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17360.f, 17370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17370.f,
				     17380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17380.f, 17390.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17390.f, 17400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17400.f,
				     17410.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17410.f, 17420.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17420.f, 17430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17430.f, 17440.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17440.f, 17450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17450.f,
				     17460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17460.f, 17470.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17470.f, 17480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17480.f,
				     17490.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17490.f, 17500.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17500.f, 17510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17510.f, 17520.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17520.f, 17530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17530.f,
				     17540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17540.f, 17550.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17550.f, 17560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17560.f,
				     17570.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17570.f, 17580.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17580.f, 17590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17590.f, 17600.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17600.f, 17610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17610.f,
				     17620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17620.f, 17630.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17630.f, 17640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17640.f,
				     17650.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17650.f, 17660.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17660.f, 17670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17670.f, 17680.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17680.f, 17690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17690.f,
				     17700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17700.f, 17710.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17710.f, 17720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17720.f,
				     17730.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17730.f, 17740.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17740.f, 17750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17750.f, 17760.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17760.f, 17770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17770.f,
				     17780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17780.f, 17790.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 17790.f, 17800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17800.f,
				     17810.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17810.f, 17820.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     17820.f, 17830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 17830.f, 17840.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 17840.f, 17850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     17850.f,
				     17860.f
    };

    /* oxygen (15300 - 17870 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* oxyg6 */

void oxyg5 (double a[8], const long int inu)
{
    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 12740.f, 12750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12750.f, 12760.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 12760.f, 12770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12770.f, 12780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12780.f, 12790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12790.f, 12800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12800.f,

				     12810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12810.f, 12820.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12820.f, 12830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12830.f,
				     12840.f,
				     1.4615e-8f, .036385f, .0669f, -2.676e-4f, .064873f, -2.6352e-4f,
				     12840.f, 12850.f, 1.7551e-8f, .018194f, .063056f, -2.5222e-4f, .061029f,
				     -2.4814e-4f, 12850.f, 12860.f, 5.5571e-8f, .034936f, .060516f,
				     -2.4079e-4f, .058832f, -2.3863e-4f, 12860.f, 12870.f, 1.1652e-7f,
				     .036823f, .057157f, -2.2751e-4f, .055426f, -2.2511e-4f, 12870.f,

				     12880.f, 2.2758e-7f, .037524f, .05406f, -2.1528e-4f, .052277f,
				     -2.1261e-4f, 12880.f, 12890.f, 4.1844e-7f, .044301f, .051439f,
				     -2.03e-4f, .050656f, -2.0073e-4f, 12890.f, 12900.f, 1.1196e-6f,
				     .064417f, .048398f, -1.9212e-4f, .047119f, -1.8843e-4f, 12900.f,
				     12910.f, 1.3443e-6f, .056296f, .046024f, -1.7943e-4f, .045942f,
				     -1.7773e-4f, 12910.f, 12920.f, 1.9719e-6f, .064603f, .044605f,
				     -1.7094e-4f, .044515f, -1.7298e-4f, 12920.f, 12930.f, 2.6027e-6f,
				     .060089f, .042943f, -1.6604e-4f, .04177f, -1.6646e-4f, 12930.f, 12940.f,
				     5.7954e-6f, .10762f, .040374f, -1.577e-4f, .038909f, -1.5614e-4f,
				     12940.f, 12950.f, 4.3014e-6f, .084704f, .042188f, -1.5762e-4f, .040357f,
				     -1.5977e-4f, 12950.f, 12960.f, 7.9614e-6f, .097284f, .041471f,
				     -1.6264e-4f, .038436f, -1.5588e-4f, 12960.f, 12970.f, 1.7998e-5f,
				     .071534f, .03844f, -1.5372e-4f, .036186f, -1.4871e-4f, 12970.f, 12980.f,
				     2.7733e-5f, .06553f, .0349f, -1.3823e-4f, .034326f, -1.4018e-4f,
				     12980.f, 12990.f, 8.7111e-5f, .082142f, .031863f, -1.2227e-4f, .033009f,
				     -1.3017e-4f, 12990.f, 1.3e4f, 5.9912e-5f, .064608f, .031064f,
				     -1.1475e-4f, .036751f, -1.2672e-4f, 1.3e4f, 13010.f, 2.6987e-4f,
				     .037736f, .026012f, -1.039e-4f, .024588f, -9.7152e-5f, 13010.f, 13020.f,
				     5.9914e-4f, .037261f, .022365f, -8.9458e-5f, .020337f, -8.5375e-5f,
				     13020.f, 13030.f, .0012384f, .038141f, .019f, -7.5998e-5f, .016972f,
				     -7.1916e-5f, 13030.f, 13040.f, .0023802f, .03944f, .015907f,
				     -6.3629e-5f, .01388f, -5.9546e-5f, 13040.f, 13050.f, .0078692f,
				     .059793f, .01191f, -4.6882e-5f, .010043f, -4.3832e-5f, 13050.f, 13060.f,
				     .014112f, .0632f, .0088039f, -3.4775e-5f, .0068655f, -3.1246e-5f,
				     13060.f, 13070.f, .01506f, .044198f, .0062748f, -2.5099e-5f, .0042475f,
				     -2.1017e-5f, 13070.f, 13080.f, .019365f, .045501f, .0045529f,
				     -1.8211e-5f, .0025253f, -1.4128e-5f, 13080.f, 13090.f, .035332f,
				     .070599f, .0026881f, -1.0606e-5f, 6.7201e-4f, -6.6426e-6f, 13090.f,
				     13100.f, .032021f, .071785f, .0013302f, -5.2395e-6f, -7.0181e-4f,
				     -1.1794e-6f, 13100.f, 13110.f, .020424f, .076507f, 3.4001e-4f,
				     -1.3505e-6f, -.0017047f, 2.7972e-6f, 13110.f, 13120.f, .0083211f,
				     .050488f, 6.3467e-5f, -2.5366e-7f, -.0019594f, 3.8105e-6f, 13120.f,
				     13130.f, .039472f, .095766f, 7.6617e-4f, -3.019e-6f, -.0012832f,
				     1.1287e-6f, 13130.f, 13140.f, .057473f, .11569f, .0028314f, -1.0907e-5f,
				     8.5516e-4f, -7.1029e-6f, 13140.f, 13150.f, .046463f, .16239f, .0072656f,
				     -2.6424e-5f, .0059616f, -2.4138e-5f, 13150.f, 13160.f, .0070486f,
				     .18365f, .016807f, -5.8784e-5f, .017894f, -6.4531e-5f, 13160.f, 13170.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13170.f, 13180.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13180.f, 13190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13190.f, 13200.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13200.f, 13210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13210.f,
				     13220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13220.f, 13230.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13230.f, 13240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13240.f,
				     13250.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13250.f, 13260.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13260.f, 13270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13270.f, 13280.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13280.f, 13290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13290.f,
				     13300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13300.f, 13310.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13310.f, 13320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13320.f,
				     13330.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13330.f, 13340.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13340.f, 13350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13350.f, 13360.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13360.f, 13370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13370.f,
				     13380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13380.f, 13390.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13390.f, 13400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13400.f,
				     13410.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13410.f, 13420.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13420.f, 13430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13430.f, 13440.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13440.f, 13450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13450.f,
				     13460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13460.f, 13470.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13470.f, 13480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13480.f,
				     13490.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13490.f, 13500.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13500.f, 13510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13510.f, 13520.f, 0.f,

				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13520.f, 13530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13530.f,
				     13540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13540.f, 13550.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13550.f, 13560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13560.f,
				     13570.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13570.f, 13580.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13580.f, 13590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13590.f, 13600.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13600.f, 13610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13610.f,
				     13620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13620.f, 13630.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13630.f, 13640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13640.f,
				     13650.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13650.f, 13660.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13660.f, 13670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13670.f, 13680.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13680.f, 13690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13690.f,
				     13700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13700.f, 13710.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13710.f, 13720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13720.f,
				     13730.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13730.f, 13740.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13740.f, 13750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13750.f, 13760.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13760.f, 13770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13770.f,
				     13780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13780.f, 13790.f, 0.f, 0.f, 0.f,

				     0.f,
				     0.f, 0.f, 13790.f, 13800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13800.f,
				     13810.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13810.f, 13820.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13820.f, 13830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13830.f, 13840.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13840.f, 13850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13850.f,
				     13860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13860.f, 13870.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13870.f, 13880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13880.f,
				     13890.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13890.f, 13900.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13900.f, 13910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13910.f, 13920.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 13920.f, 13930.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     13930.f,
				     13940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13940.f, 13950.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 13950.f, 13960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13960.f,
				     13970.f,

				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13970.f, 13980.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     13980.f, 13990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 13990.f, 1.4e4f, 0.f, 0.f,
				     0.f, 0.f, 0.f, 0.f, 1.4e4f, 14010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14010.f,
				     14020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14020.f, 14030.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14030.f, 14040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14040.f,
				     14050.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14050.f, 14060.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14060.f, 14070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14070.f, 14080.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14080.f, 14090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14090.f,
				     14100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14100.f, 14110.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14110.f, 14120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14120.f,
				     14130.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14130.f, 14140.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14140.f, 14150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14150.f, 14160.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14160.f, 14170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14170.f,
				     14180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14180.f, 14190.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14190.f, 14200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14200.f,
				     14210.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14210.f, 14220.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14220.f, 14230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14230.f, 14240.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14240.f, 14250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14250.f,
				     14260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14260.f, 14270.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14270.f, 14280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14280.f,
				     14290.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14290.f, 14300.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14300.f, 14310.f, 3.2848e-8f, .036386f, .053505f, -2.1402e-4f, .051477f,
				     -2.0994e-4f, 14310.f, 14320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14320.f,
				     14330.f, 1.1021e-7f, .036386f, .048248f, -1.9299e-4f, .046221f,
				     -1.8891e-4f, 14330.f, 14340.f, 3.4571e-7f, .036386f, .04326f,
				     -1.7304e-4f, .041233f, -1.6896e-4f, 14340.f, 14350.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 0.f, 14350.f, 14360.f, 1.0131e-6f, .036386f, .03854f, -1.5416e-4f,
				     .036513f, -1.5008e-4f, 14360.f, 14370.f, 2.7746e-6f, .036442f, .034089f,
				     -1.3635e-4f, .032054f, -1.3222e-4f, 14370.f, 14380.f, 3.6059e-6f,
				     .01824f, .02993f, -1.1971e-4f, .027892f, -1.1557e-4f, 14380.f, 14390.f,
				     3.4852e-6f, .018279f, .029884f, -1.1951e-4f, .027832f, -1.1527e-4f,
				     14390.f, 14400.f, 1.6898e-5f, .036461f, .026f, -1.0399e-4f, .023962f,
				     -9.9845e-5f, 14400.f, 14410.f, 3.7525e-5f, .037306f, .022363f,
				     -8.9448e-5f, .020327f, -8.5313e-5f, 14410.f, 14420.f, 7.7568e-5f,
				     .038179f, .018999f, -7.5991e-5f, .016964f, -7.1868e-5f, 14420.f,
				     14430.f, 7.644e-5f, .019568f, .015927f, -6.3702e-5f, .013885f,
				     -5.9534e-5f, 14430.f, 14440.f, 2.0947e-4f, .038957f, .014055f,
				     -5.5384e-5f, .012236f, -5.2506e-5f, 14440.f, 14450.f, 3.5608e-4f,
				     .040125f, .011458f, -4.5137e-5f, .0095851f, -4.1989e-5f, 14450.f,
				     14460.f, 5.6079e-4f, .041622f, .0091259f, -3.5944e-5f, .0072131f,
				     -3.2578e-5f, 14460.f, 14470.f, 8.1523e-4f, .043384f, .0070608f,
				     -2.7807e-5f, .0051286f, -2.4309e-5f, 14470.f, 14480.f, .0016639f,
				     .067344f, .0050076f, -1.9758e-5f, .0030273f, -1.599e-5f, 14480.f,
				     14490.f, .0014146f, .046358f, .003106f, -1.2424e-5f, .0010767f,
				     -8.3329e-6f, 14490.f, 14500.f, .0022165f, .071957f, .0016398f,
				     -6.477e-6f, -3.8835e-4f, -2.4326e-6f, 14500.f, 14510.f, .0015542f,
				     .07478f, 6.4291e-4f, -2.5306e-6f, -.0013922f, 1.5886e-6f, 14510.f,
				     14520.f, 3.1245e-4f, .026878f, 9.5018e-5f, -3.8003e-7f, -.0019316f,
				     3.6996e-6f, 14520.f, 14530.f, .0015805f, .097644f, 3.0344e-4f,
				     -1.0773e-6f, -.0013616f, 5.954e-6f, 14530.f, 14540.f, .0044256f,
				     .14544f, .0020504f, -7.4913e-6f, 6.2397e-4f, -9.5059e-7f, 14540.f,
				     14550.f, .0039335f, .29035f, .0078502f, -2.3749e-5f, .0080984f,
				     -2.7655e-5f, 14550.f, 14560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14560.f,
				     14570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14570.f, 14580.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14580.f, 14590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14590.f,
				     14600.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14600.f, 14610.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14610.f, 14620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14620.f, 14630.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14630.f, 14640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14640.f,
				     14650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14650.f, 14660.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14660.f, 14670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14670.f,
				     14680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14680.f, 14690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14690.f, 14700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14700.f, 14710.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14710.f, 14720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14720.f,
				     14730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14730.f, 14740.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14740.f, 14750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14750.f,
				     14760.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14760.f, 14770.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14770.f, 14780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14780.f, 14790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14790.f, 14800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14800.f,
				     14810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14810.f, 14820.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14820.f, 14830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14830.f,
				     14840.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14840.f, 14850.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14850.f, 14860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14860.f, 14870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14870.f, 14880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14880.f,
				     14890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14890.f, 14900.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14900.f, 14910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14910.f,
				     14920.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14920.f, 14930.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     14930.f, 14940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14940.f, 14950.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 14950.f, 14960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     14960.f,
				     14970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14970.f, 14980.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 14980.f, 14990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 14990.f, 1.5e4f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.5e4f, 15010.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15010.f, 15020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15020.f, 15030.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15030.f, 15040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15040.f,
				     15050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15050.f, 15060.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15060.f, 15070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15070.f,
				     15080.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15080.f, 15090.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15090.f, 15100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15100.f, 15110.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15110.f, 15120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15120.f,
				     15130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15130.f, 15140.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15140.f, 15150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15150.f,
				     15160.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15160.f, 15170.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15170.f, 15180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15180.f, 15190.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15190.f, 15200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,

				     15200.f,
				     15210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15210.f, 15220.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 15220.f, 15230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15230.f,
				     15240.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15240.f, 15250.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     15250.f, 15260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15260.f, 15270.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 15270.f, 15280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     15280.f,
				     15290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 15290.f, 15300.f
    };

    /* oxygen (12740 - 15290 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* oxyg5 */

void
oxyg4 (double a[8], const long int inu)
{


    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 10180.f, 10190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10190.f, 10200.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 10200.f, 10210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10210.f, 10220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10220.f, 10230.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10230.f, 10240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10240.f,
				     10250.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10250.f, 10260.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10260.f, 10270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10270.f,
				     10280.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10280.f, 10290.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10290.f, 10300.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10300.f, 10310.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10310.f, 10320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10320.f,
				     10330.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10330.f, 10340.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10340.f, 10350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10350.f,
				     10360.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10360.f, 10370.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10370.f, 10380.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10380.f, 10390.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10390.f, 10400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10400.f,
				     10410.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10410.f, 10420.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10420.f, 10430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10430.f,
				     10440.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10440.f, 10450.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10450.f, 10460.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10460.f, 10470.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10470.f, 10480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10480.f,
				     10490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10490.f, 10500.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10500.f, 10510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10510.f,
				     10520.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10520.f, 10530.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10530.f, 10540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10540.f, 10550.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10550.f, 10560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10560.f,
				     10570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10570.f, 10580.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10580.f, 10590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10590.f,
				     10600.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10600.f, 10610.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10610.f, 10620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10620.f, 10630.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10630.f, 10640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10640.f,
				     10650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10650.f, 10660.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10660.f, 10670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10670.f,
				     10680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10680.f, 10690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10690.f, 10700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10700.f, 10710.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10710.f, 10720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10720.f,
				     10730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10730.f, 10740.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10740.f, 10750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10750.f,
				     10760.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10760.f, 10770.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10770.f, 10780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10780.f, 10790.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10790.f, 10800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10800.f,
				     10810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10810.f, 10820.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10820.f, 10830.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10830.f,
				     10840.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10840.f, 10850.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10850.f, 10860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10860.f, 10870.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10870.f, 10880.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10880.f,
				     10890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10890.f, 10900.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10900.f, 10910.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10910.f,
				     10920.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10920.f, 10930.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10930.f, 10940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10940.f, 10950.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10950.f, 10960.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10960.f,
				     10970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10970.f, 10980.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10980.f, 10990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10990.f, 1.1e4f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.1e4f, 11010.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11010.f, 11020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11020.f, 11030.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11030.f, 11040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11040.f,
				     11050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11050.f, 11060.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11060.f, 11070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11070.f,
				     11080.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11080.f, 11090.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11090.f, 11100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11100.f, 11110.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11110.f, 11120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11120.f,
				     11130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11130.f, 11140.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11140.f, 11150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11150.f,
				     11160.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11160.f, 11170.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11170.f, 11180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11180.f, 11190.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11190.f, 11200.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11200.f,
				     11210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11210.f, 11220.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11220.f, 11230.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11230.f,
				     11240.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11240.f, 11250.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11250.f, 11260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11260.f, 11270.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11270.f, 11280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11280.f,
				     11290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11290.f, 11300.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11300.f, 11310.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11310.f,
				     11320.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11320.f, 11330.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11330.f, 11340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11340.f, 11350.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11350.f, 11360.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11360.f,
				     11370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11370.f, 11380.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11380.f, 11390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11390.f,
				     11400.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11400.f, 11410.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11410.f, 11420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11420.f, 11430.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11430.f, 11440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11440.f,
				     11450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11450.f, 11460.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11460.f, 11470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11470.f,
				     11480.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11480.f, 11490.f, 2.485e-8f, .039407f,
				     .053053f, -2.1221e-4f, .051025f, -2.0813e-4f, 11490.f, 11500.f,
				     1.1624e-7f, .079933f, .048686f, -1.9403e-4f, .046806f, -1.9088e-4f,
				     11500.f, 11510.f, 1.0964e-7f, .043304f, .045502f, -1.8201e-4f, .043474f,
				     -1.7792e-4f, 11510.f, 11520.f, 2.5643e-7f, .066862f, .042844f,
				     -1.7105e-4f, .040871f, -1.6735e-4f, 11520.f, 11530.f, 3.2105e-7f,
				     .068728f, .040797f, -1.6299e-4f, .038797f, -1.5911e-4f, 11530.f,
				     11540.f, 3.5585e-7f, .071858f, .038944f, -1.557e-4f, .036916f,
				     -1.5165e-4f, 11540.f, 11550.f, 2.4915e-7f, .074592f, .037957f,
				     -1.5179e-4f, .035912f, -1.4766e-4f, 11550.f, 11560.f, 4.9923e-8f,
				     .026857f, .037416f, -1.4966e-4f, .035388f, -1.4558e-4f, 11560.f,
				     11570.f, 2.5239e-7f, .096092f, .037615f, -1.5045e-4f, .035561f,
				     -1.4627e-4f, 11570.f, 11580.f, 5.8358e-7f, .11778f, .039104f,
				     -1.5615e-4f, .03708f, -1.5221e-4f, 11580.f, 11590.f, 4.8767e-7f,
				     .11043f, .041978f, -1.6721e-4f, .04006f, -1.6392e-4f, 11590.f, 11600.f,
				     2.0866e-7f, .10009f, .046771f, -1.859e-4f, .045f, -1.8335e-4f, 11600.f,
				     11610.f, 6.2339e-8f, .091546f, .052598f, -2.0809e-4f, .051104f,
				     -2.0723e-4f, 11610.f, 11620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11620.f,
				     11630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11630.f, 11640.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11640.f, 11650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11650.f,
				     11660.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11660.f, 11670.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11670.f, 11680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11680.f, 11690.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11690.f, 11700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11700.f,
				     11710.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11710.f, 11720.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11720.f, 11730.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11730.f,
				     11740.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11740.f, 11750.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11750.f, 11760.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11760.f, 11770.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11770.f, 11780.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11780.f,
				     11790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11790.f, 11800.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11800.f, 11810.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11810.f,
				     11820.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11820.f, 11830.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11830.f, 11840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11840.f, 11850.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11850.f, 11860.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11860.f,
				     11870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11870.f, 11880.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11880.f, 11890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11890.f,
				     11900.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11900.f, 11910.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11910.f, 11920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11920.f, 11930.f, 0.f,

				     0.f,
				     0.f, 0.f, 0.f, 0.f, 11930.f, 11940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     11940.f,
				     11950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11950.f, 11960.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 11960.f, 11970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11970.f,
				     11980.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 11980.f, 11990.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     11990.f, 1.2e4f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1.2e4f, 12010.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 12010.f, 12020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12020.f,
				     12030.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12030.f, 12040.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12040.f, 12050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12050.f,
				     12060.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12060.f, 12070.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12070.f, 12080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12080.f, 12090.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12090.f, 12100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12100.f,
				     12110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12110.f, 12120.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12120.f, 12130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12130.f,
				     12140.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12140.f, 12150.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12150.f, 12160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12160.f, 12170.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12170.f, 12180.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12180.f,
				     12190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12190.f, 12200.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12200.f, 12210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12210.f,
				     12220.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12220.f, 12230.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12230.f, 12240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12240.f, 12250.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12250.f, 12260.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12260.f,
				     12270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12270.f, 12280.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12280.f, 12290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12290.f,
				     12300.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12300.f, 12310.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12310.f, 12320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12320.f, 12330.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12330.f, 12340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12340.f,
				     12350.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12350.f, 12360.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12360.f, 12370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12370.f,
				     12380.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12380.f, 12390.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12390.f, 12400.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12400.f, 12410.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12410.f, 12420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12420.f,
				     12430.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12430.f, 12440.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12440.f, 12450.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12450.f,
				     12460.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12460.f, 12470.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12470.f, 12480.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12480.f, 12490.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12490.f, 12500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12500.f,
				     12510.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12510.f, 12520.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12520.f, 12530.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12530.f,
				     12540.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12540.f, 12550.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12550.f, 12560.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12560.f, 12570.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12570.f, 12580.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12580.f,
				     12590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12590.f, 12600.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12600.f, 12610.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12610.f,
				     12620.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12620.f, 12630.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12630.f, 12640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12640.f, 12650.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12650.f, 12660.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     12660.f,
				     12670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12670.f, 12680.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 12680.f, 12690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12690.f,
				     12700.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12700.f, 12710.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     12710.f, 12720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 12720.f, 12730.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 12730.f, 12740.f
    };

    /* oxygen (10180 - 12730 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* oxyg4 */

void
oxyg3 (double a[8], const long int inu)
{
    static const float acr[2048] = { 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f, 7620.f, 7630.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7630.f, 7640.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 7640.f, 7650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7650.f,
				     7660.f, 5.4851e-9f, .018194f, .043239f, -1.7296e-4f, .041212f,
				     -1.6888e-4f, 7660.f, 7670.f, 1.5945e-8f, .018194f, .03852f, -1.5408e-4f,
				     .036492f, -1.5e-4f, 7670.f, 7680.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7680.f,
				     7690.f, 4.3251e-8f, .018194f, .034069f, -1.3628e-4f, .032042f,
				     -1.3219e-4f, 7690.f, 7700.f, 1.0929e-7f, .018194f, .029889f,
				     -1.1956e-4f, .027862f, -1.1547e-4f, 7700.f, 7710.f, 2.5722e-7f,
				     .018194f, .02598f, -1.0392e-4f, .023953f, -9.9839e-5f, 7710.f, 7720.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 7720.f, 7730.f, 5.6266e-7f, .018194f,
				     .022343f, -8.9371e-5f, .020315f, -8.5289e-5f, 7730.f, 7740.f,
				     1.1425e-6f, .01906f, .018977f, -7.591e-5f, .01695f, -7.1828e-5f, 7740.f,
				     7750.f, 2.1596e-6f, .022229f, .016034f, -6.2289e-5f, .015554f,
				     -5.5716e-5f, 7750.f, 7760.f, 8.1892e-8f, .052034f, .039222f,
				     -1.5556e-4f, .037572f, -1.5339e-4f, 7760.f, 7770.f, 3.9209e-6f,
				     .032273f, .014036f, -4.6954e-5f, .015654f, -4.8384e-5f, 7770.f, 7780.f,
				     6.4421e-6f, .036427f, .011888f, -3.5835e-5f, .013496f, -4.0675e-5f,
				     7780.f, 7790.f, 1.1047e-5f, .055891f, .011375f, -2.6109e-5f, .013172f,
				     -4.0967e-5f, 7790.f, 7800.f, 1.7987e-5f, .067558f, .010748f,
				     -2.3562e-5f, .01137f, -3.8223e-5f, 7800.f, 7810.f, 9.8092e-6f, .038971f,
				     .015905f, -6.3621e-5f, .013877f, -5.9532e-5f, 7810.f, 7820.f,
				     4.4018e-5f, .082997f, .0095499f, -3.1911e-5f, .0077993f, -3.2091e-5f,
				     7820.f, 7830.f, 7.0926e-5f, .086557f, .0076614f, -2.7697e-5f, .0055197f,
				     -2.4447e-5f, 7830.f, 7840.f, 1.0119e-4f, .087824f, .0052157f,
				     -1.9889e-5f, .00297f, -1.5277e-5f, 7840.f, 7850.f, 1.2386e-4f, .090123f,
				     .0034834f, -1.2896e-5f, .0022642f, -3.5587e-6f, 7850.f, 7860.f,
				     1.3558e-4f, .14355f, .0025455f, 7.5114e-7f, .0043782f, 4.2838e-6f,
				     7860.f, 7870.f, 3.6155e-4f, .30611f, .00774f, -2.3164e-5f, .0072019f,
				     -2.6289e-5f, 7870.f, 7880.f, 7.4132e-4f, .38505f, .0019206f,
				     -6.4925e-6f, 1.9419e-5f, -3.3562e-6f, 7880.f, 7890.f, 2.6142e-4f,
				     .099139f, 5.6355e-4f, -2.1878e-6f, -.0015085f, 2.0396e-6f, 7890.f,
				     7900.f, 3.3585e-4f, .12035f, .0017877f, -6.7625e-6f, -3.0147e-4f,
				     -2.6201e-6f, 7900.f, 7910.f, 2.1797e-4f, .09124f, .0044856f,
				     -1.7351e-5f, .0025121f, -1.3772e-5f, 7910.f, 7920.f, 1.8805e-4f,
				     .12809f, .0061732f, -1.8626e-5f, .0047187f, -2.0003e-5f, 7920.f, 7930.f,
				     8.7414e-5f, .10246f, .0071283f, -9.5048e-6f, .0079366f, -2.5696e-5f,
				     7930.f, 7940.f, 5.0284e-5f, .070001f, .0058651f, -1.5881e-6f, .0099197f,
				     -1.9259e-5f, 7940.f, 7950.f, 3.4484e-5f, .036136f, .0050423f,
				     -1.3556e-5f, .0083314f, -2.9461e-6f, 7950.f, 7960.f, 2.508e-5f,

				     .023597f, .0062798f, -2.4587e-5f, .0054199f, -1.4942e-5f, 7960.f,
				     7970.f, 1.7175e-5f, .021672f, .0082429f, -3.2972e-5f, .0062159f,
				     -2.8891e-5f, 7970.f, 7980.f, 1.0919e-5f, .0208f, .010514f, -4.2054e-5f,
				     .0084864f, -3.7973e-5f, 7980.f, 7990.f, 6.453e-6f, .019927f, .013058f,
				     -5.2234e-5f, .011031f, -4.8151e-5f, 7990.f, 8e3f, 3.5484e-6f, .019493f,
				     .015877f, -6.3508e-5f, .01385f, -5.9425e-5f, 8e3f, 8010.f, 1.8178e-6f,
				     .01906f, .018969f, -7.5874e-5f, .016941f, -7.1792e-5f, 8010.f, 8020.f,
				     8.6808e-7f, .018194f, .022333f, -8.9332e-5f, .020306f, -8.525e-5f,
				     8020.f, 8030.f, 5.4731e-7f, .034766f, .027088f, -1.0685e-4f, .025457f,
				     -1.0498e-4f, 8030.f, 8040.f, 6.2423e-8f, .018194f, .034057f,
				     -1.3623e-4f, .03203f, -1.3215e-4f, 8040.f, 8050.f, 2.2644e-8f, .018194f,
				     .038506f, -1.5403e-4f, .036479f, -1.4994e-4f, 8050.f, 8060.f,
				     7.6809e-9f, .018194f, .043225f, -1.729e-4f, .041198f, -1.6882e-4f,
				     8060.f, 8070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8070.f, 8080.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8080.f, 8090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8090.f,
				     8100.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8100.f, 8110.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8110.f, 8120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8120.f, 8130.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8130.f, 8140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8140.f,
				     8150.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8150.f, 8160.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8160.f, 8170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8170.f, 8180.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8180.f, 8190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8190.f,
				     8200.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8200.f, 8210.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8210.f, 8220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8220.f, 8230.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8230.f, 8240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8240.f,
				     8250.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8250.f, 8260.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8260.f, 8270.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8270.f, 8280.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8280.f, 8290.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8290.f,
				     8300.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8300.f, 8310.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8310.f, 8320.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8320.f, 8330.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8330.f, 8340.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8340.f,
				     8350.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8350.f, 8360.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8360.f, 8370.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8370.f, 8380.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8380.f, 8390.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8390.f,
				     8400.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8400.f, 8410.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8410.f, 8420.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8420.f, 8430.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8430.f, 8440.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8440.f,
				     8450.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8450.f, 8460.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8460.f, 8470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8470.f, 8480.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8480.f, 8490.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8490.f,
				     8500.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8500.f, 8510.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8510.f, 8520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8520.f, 8530.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8530.f, 8540.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8540.f,
				     8550.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8550.f, 8560.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8560.f, 8570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8570.f, 8580.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8580.f, 8590.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8590.f,
				     8600.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8600.f, 8610.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8610.f, 8620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8620.f, 8630.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8630.f, 8640.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8640.f,
				     8650.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8650.f, 8660.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8660.f, 8670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8670.f, 8680.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8680.f, 8690.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8690.f,
				     8700.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8700.f, 8710.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8710.f, 8720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8720.f, 8730.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8730.f, 8740.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8740.f,
				     8750.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8750.f, 8760.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8760.f, 8770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8770.f, 8780.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8780.f, 8790.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8790.f,
				     8800.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8800.f, 8810.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8810.f, 8820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8820.f, 8830.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8830.f, 8840.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8840.f,
				     8850.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8850.f, 8860.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8860.f, 8870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8870.f, 8880.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8880.f, 8890.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8890.f,
				     8900.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8900.f, 8910.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8910.f, 8920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8920.f, 8930.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8930.f, 8940.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8940.f,
				     8950.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8950.f, 8960.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     8960.f, 8970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8970.f, 8980.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 8980.f, 8990.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 8990.f, 9e3f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 9e3f, 9010.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     9010.f,
				     9020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9020.f, 9030.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9030.f, 9040.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9040.f, 9050.f, 0.f,

				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9050.f, 9060.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9060.f,
				     9070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9070.f, 9080.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9080.f, 9090.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9090.f, 9100.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9100.f, 9110.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9110.f,
				     9120.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9120.f, 9130.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9130.f, 9140.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9140.f, 9150.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9150.f, 9160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9160.f,
				     9170.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9170.f, 9180.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9180.f, 9190.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9190.f, 9200.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9200.f, 9210.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9210.f,
				     9220.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9220.f, 9230.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 9230.f, 9240.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9240.f, 9250.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 9250.f, 9260.f, 2.9327e-8f, .020793f, .01052f,
				     -4.2079e-5f, .0084925f, -3.7997e-5f, 9260.f, 9270.f, 4.284e-8f,
				     .021659f, .0082482f, -3.2993e-5f, .0062209f, -2.8911e-5f, 9270.f,
				     9280.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9280.f, 9290.f, 1.4493e-7f,
				     .078959f,
				     .011173f, -3.6086e-5f, .0098558f, -3.9242e-5f, 9290.f, 9300.f,
				     2.5005e-7f, .083955f, .0092831f, -3.2526e-5f, .0073578f, -3.1073e-5f,
				     9300.f, 9310.f, 2.7511e-7f, .065813f, .0069254f, -2.5251e-5f, .0046721f,
				     -2.1357e-5f, 9310.f, 9320.f, 3.3929e-7f, .065167f, .0055165f,
				     -2.0774e-5f, .0031412f, -1.5731e-5f, 9320.f, 9330.f, 7.3603e-7f,
				     .092398f, .0037855f, -1.4891e-5f, .0017763f, -1.1006e-5f, 9330.f,
				     9340.f, 4.4813e-7f, .07935f, .0045127f, -2.4202e-6f, .0042176f,
				     -9.3426e-6f, 9340.f, 9350.f, 1.4773e-6f, .2629f, .0066029f, -1.8761e-5f,
				     .004739f, -1.8284e-5f, 9350.f, 9360.f, 3.6258e-6f, .35403f, .0024719f,
				     -8.6417e-6f, 5.0685e-4f, -5.3198e-6f, 9360.f, 9370.f, 1.0885e-6f,
				     .098959f, 2.798e-4f, -1.1056e-6f, -.0017654f, 3.0416e-6f, 9370.f,
				     9380.f, 1.6901e-6f, .12199f, .0012891f, -4.9557e-6f, -7.9138e-4f,
				     -7.506e-7f, 9380.f, 9390.f, 1.6816e-6f, .13899f, .0035668f, -1.2886e-5f,
				     .0015543f, -9.4945e-6f, 9390.f, 9400.f, 1.0341e-6f, .16279f, .0068719f,
				     -1.996e-5f, .0057191f, -2.3184e-5f, 9400.f, 9410.f, 3.1773e-7f, .06436f,
				     .0052558f, -2.7296e-6f, .0065364f, -1.6975e-5f, 9410.f, 9420.f,
				     2.0773e-7f, .023392f, .0030789f, -1.2316e-5f, .0010516f, -8.2335e-6f,
				     9420.f, 9430.f, 1.6613e-7f, .022959f, .0045253f, -1.8101e-5f, .0024979f,
				     -1.4019e-5f, 9430.f, 9440.f, 1.2289e-7f, .022092f, .0062467f,
				     -2.4987e-5f, .0042194f, -2.0905e-5f, 9440.f, 9450.f, 8.4168e-8f,
				     .021659f, .0082429f, -3.2972e-5f, .0062156f, -2.8889e-5f, 9450.f,
				     9460.f, 8.5119e-8f, .040142f, .011444f, -4.5054e-5f, .0095711f,
				     -4.1931e-5f, 9460.f, 9470.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9470.f, 9480.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9480.f, 9490.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9490.f, 9500.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9500.f, 9510.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9510.f, 9520.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9520.f,
				     9530.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9530.f, 9540.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9540.f, 9550.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9550.f, 9560.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9560.f, 9570.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9570.f,
				     9580.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9580.f, 9590.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9590.f, 9600.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9600.f, 9610.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9610.f, 9620.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9620.f,
				     9630.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9630.f, 9640.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9640.f, 9650.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9650.f, 9660.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9660.f, 9670.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9670.f,
				     9680.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9680.f, 9690.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9690.f, 9700.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9700.f, 9710.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9710.f, 9720.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9720.f,
				     9730.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9730.f, 9740.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9740.f, 9750.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9750.f, 9760.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9760.f, 9770.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9770.f,
				     9780.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9780.f, 9790.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,

				     9790.f, 9800.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9800.f, 9810.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9810.f, 9820.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9820.f,
				     9830.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9830.f, 9840.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9840.f, 9850.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9850.f, 9860.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9860.f, 9870.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9870.f,
				     9880.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9880.f, 9890.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9890.f, 9900.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9900.f, 9910.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9910.f, 9920.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9920.f,
				     9930.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9930.f, 9940.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9940.f, 9950.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9950.f, 9960.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 9960.f, 9970.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9970.f,
				     9980.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 9980.f, 9990.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     9990.f, 1e4f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 1e4f, 10010.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10010.f, 10020.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10020.f,
				     10030.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10030.f, 10040.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10040.f, 10050.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10050.f, 10060.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10060.f, 10070.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10070.f,
				     10080.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10080.f, 10090.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10090.f, 10100.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10100.f,
				     10110.f,
				     0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10110.f, 10120.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     0.f,
				     10120.f, 10130.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10130.f, 10140.f, 0.f,
				     0.f,
				     0.f, 0.f, 0.f, 0.f, 10140.f, 10150.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f,
				     10150.f,
				     10160.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 10160.f, 10170.f, 0.f, 0.f, 0.f,
				     0.f,
				     0.f, 0.f, 10170.f, 10180.f
    };

    /* oxygen (7620 - 10170 cm-1) */
    for(int i = 0; i < 8; i++) a[i] = acr[i + (inu << 3) - 8];
}	/* oxyg3 */


void abstra (const AtmosModel& atms, const Altitude& alt,
	     const double wl, const double xmus, const double xmuv,
	     const double uw, const double uo3, double& uwus, double& uo3us,
	     const double uwpl, const double uo3pl, const double uwusp,
	     const double uo3usp, AbstraStruct& as )
{ 
    // transmittance calculation for ozone, water vapor,
    // carbon dioxyde and oxygen.
	 
    double tnu[10][3],a[8],rm[34],r2[34],r3[34],tp[34],rat[10];
    double rmpl[34],r2pl[34],r3pl[34],ratpl[10];
    double dtcont,utcont,ttcont;
    double v,te2,phi,psi,uu,u,up,uud,uut,uuu;
    double ud,ut,upd,upt,udp,updp,udtp,updtp;
    double ds2,uupl,upl,uppl,ah2o;
    double xh,xi,xd,ako3,test1,test2,test3,udt,atest;
    double updt,tt,y,utt,uptt,tn;
    double ds,te,roair;
    double ptest, ptest1;
    int iv,id,idgaz,inu = 0,n,nh;

    int ivli[6] = { 2500,5060,7620,10180,12740,15300 };
    double co3[102] = {
	4.50e-03, 8.00e-03, 1.07e-02, 1.10e-02, 1.27e-02, 1.71e-02,
	2.00e-02, 2.45e-02, 3.07e-02, 3.84e-02, 4.78e-02, 5.67e-02,
	6.54e-02, 7.62e-02, 9.15e-02, 1.00e-01, 1.09e-01, 1.20e-01,
	1.28e-01, 1.12e-01, 1.11e-01, 1.16e-01, 1.19e-01, 1.13e-01,
	1.03e-01, 9.24e-02, 8.28e-02, 7.57e-02, 7.07e-02, 6.58e-02,
	5.56e-02, 4.77e-02, 4.06e-02, 3.87e-02, 3.82e-02, 2.94e-02,
	2.09e-02, 1.80e-02, 1.91e-02, 1.66e-02, 1.17e-02, 7.70e-03,
	6.10e-03, 8.50e-03, 6.10e-03, 3.70e-03, 3.20e-03, 3.10e-03,
	2.55e-03, 1.98e-03, 1.40e-03, 8.25e-04, 2.50e-04, 0.      ,
	0.      , 0.      , 5.65e-04, 2.04e-03, 7.35e-03, 2.03e-02,
	4.98e-02, 1.18e-01, 2.46e-01, 5.18e-01, 1.02e+00, 1.95e+00,
	3.79e+00, 6.65e+00, 1.24e+01, 2.20e+01, 3.67e+01, 5.95e+01,
	8.50e+01, 1.26e+02, 1.68e+02, 2.06e+02, 2.42e+02, 2.71e+02,
	2.91e+02, 3.02e+02, 3.03e+02, 2.94e+02, 2.77e+02, 2.54e+02,
	2.26e+02, 1.96e+02, 1.68e+02, 1.44e+02, 1.17e+02, 9.75e+01,
	7.65e+01, 6.04e+01, 4.62e+01, 3.46e+01, 2.52e+01, 2.00e+01,
	1.57e+01, 1.20e+01, 1.00e+01, 8.80e+00, 8.30e+00, 8.60e+00
    };

    double cch2o[15] = {
	0.00,0.19,0.15,0.12,0.10,
	0.09,0.10,0.12,0.15,0.17,
	0.20,0.24,0.28,0.33,0.00
    };

    as.dtwava = 1;
    as.utwava = 1;
    as.ttwava = 1;
    dtcont = 1;
    utcont = 1;
    ttcont = 1;
    as.dtozon = 1;
    as.utozon = 1;
    as.ttozon = 1;
    as.dtdica = 1;
    as.utdica = 1;
    as.ttdica = 1;
    as.dtoxyg = 1;

    as.utoxyg = 1;
    as.ttoxyg = 1;
    as.dtniox = 1;
    as.utniox = 1;
    as.ttniox = 1;
    as.dtmeth = 1;
    as.utmeth = 1;
    as.ttmeth = 1;
    as.dtmoca = 1;
    as.utmoca = 1;
    as.ttmoca = 1;

    for(int i = 0 ; i < 10; i++ )
    {
	rat[i] = 1;
	tnu[i][0] = 1;
	tnu[i][1] = 1;
	tnu[i][2] = 1;
    }
 
    if (atms.idatm == 0) return;

    if((xmus == 0.) || (xmuv == 0.)) 
    {
        fprintf(stderr, "Error on zenithal angle ( near 90 deg )\n");
	return;
    }
		
    /* constants determination */
    const double p0 = 1013.25f;
    const double g = 98.1f;

    const double t0 = 250.f;
 
    /* volumic mass in kilogrammes per m3 */
    ds = 0;
    te = 0;
    roair = 0;
    const double air = 0.028964 / 0.0224;
    const double roco2 = 0.044 / 0.0224;
    const double rmo2 = 0.032 / 0.0224;
    const double rmo3 = 0.048 / 0.0224;
    const double rmn2o = 0.044 / 0.0224;
    const double rmch4 = 0.016 / 0.0224;
    const double rmco  = 0.028 / 0.0224;
	
    uwus = 1.424;
    uo3us = .344;
	 
    if(atms.idatm == 8)
    {
	rat[0] = uw / uwus;
	rat[1] = 1;
	rat[2] = 1;
	rat[3] = uo3 / uo3us;
	rat[4] = 1;
	rat[5] = 1;
	rat[6] = 1;
	rat[7] = uw / uwus;
	rat[8] = uw / uwus;
	rat[9] = uw / uwus;
    }
 
    v = (double)(1e+04 / wl);
    iv = (int)(v / 5);
    iv = iv * 5;
    id = ((iv - 2500) / 10) / 256 + 1;

    for(idgaz = 1; idgaz <= 7; idgaz++)
    {
	if (id <= 6) inu = (iv - ivli[id-1]) / 10 + 1;
	
	bool to270 = false;
	switch(id)
	{
	case 1:
	{
	    if(idgaz == 1) wava1(a,inu);
	    if(idgaz == 2) dica1(a,inu);
	    if(idgaz == 3) to270 = true;
	    if(idgaz == 4) ozon1(a,inu);
	    if(idgaz == 5) niox1(a,inu);
	    if(idgaz == 6) meth1(a,inu);
	    if(idgaz == 7) moca1(a,inu);
	    break;
	}
	case 2:
	{
	    if(idgaz == 1) wava2(a,inu);
	    if(idgaz == 2) dica2(a,inu);
	    if(idgaz == 3) to270 = true;
	    if(idgaz == 4) to270 = true;
	    if(idgaz == 5) niox2(a,inu);
	    if(idgaz == 6) meth2(a,inu);
	    if(idgaz == 7) moca2(a,inu);
	    break;
	}
	case 3:
	{
	    if(idgaz == 1) wava3(a,inu);
	    if(idgaz == 2) dica3(a,inu);
	    if(idgaz == 3) oxyg3(a,inu);
	    if(idgaz == 4) to270 = true;
	    if(idgaz == 5) niox3(a,inu);
	    if(idgaz == 6) meth3(a,inu);
	    if(idgaz == 7) moca3(a,inu);
	    break;
	}
	case 4:
	{
	    if(idgaz == 1) wava4(a,inu);
	    if(idgaz == 2) to270 = true;
	    if(idgaz == 3) oxyg4(a,inu);
	    if(idgaz == 4) to270 = true;
	    if(idgaz == 5) niox4(a,inu);
	    if(idgaz == 6) meth4(a,inu);
	    if(idgaz == 7) moca4(a,inu);
	    break;
	}
	case 5:
	{
	    if(idgaz == 1) wava5(a,inu);
	    if(idgaz == 2) to270 = true;
	    if(idgaz == 3) oxyg5(a,inu);
	    if(idgaz == 4) to270 = true;
	    if(idgaz == 5) niox5(a,inu);
	    if(idgaz == 6) meth5(a,inu);
	    if(idgaz == 7) moca5(a,inu);
	    break;
	}
	case 6:
	{
	    if(idgaz == 1) wava6(a,inu);
	    if(idgaz == 2) to270 = true;
	    if(idgaz == 3) oxyg6(a,inu);
	    if(idgaz == 4) to270 = true;
	    if(idgaz == 5) niox6(a,inu);
	    if(idgaz == 6) meth6(a,inu);
	    if(idgaz == 7) moca6(a,inu);
	    break;
	}
	default: to270 = true;
	}

	if(to270) for(int i = 0; i < 8; i++) a[i] = 0;
 
	/* mixing ratio calculation for each gaseous constituents */
	int k;
	for(k = 0; k < 33; k++)
	{
	    roair = air * 273.16f * atms.p[k] / (1013.25f * atms.t[k]);
	    tp[k] = (atms.t[k] + atms.t[k + 1]) / 2.f;
	    te = tp[k] - t0;
	    te2 = te * te;
	    phi = (double)exp(a[2] * te + a[3] * te2);
	    psi = (double)exp(a[4] * te + a[5] * te2);
	    if(idgaz == 1) rm[k] = atms.wh[k] / (roair * 1000);
	    if(idgaz == 2) rm[k] = 3.3e-04f * roco2 / air;
	    if(idgaz == 3) rm[k] = 0.20947f * rmo2 / air;
	    if(idgaz == 4) rm[k] = atms.wo[k] / (roair * 1000);
	    if(idgaz == 5) rm[k] = 310.e-09f * rmn2o / air;
	    if(idgaz == 6) rm[k] = 1.72e-06f * rmch4 / air;
	    if(idgaz == 7) rm[k] = 1.00e-09f * rmco  / air;
	    r2[k] = rm[k] * phi;
	    r3[k] = rm[k] * psi;
	}
	
	uu = 0;
	u = 0;
	up = 0;
	uud = 0;
	uut = 0;
	uuu = 0;
	ud = 0;
	ut = 0;
	upd = 0;
	upt = 0;
	udp = 0;
	updp = 0;
	udtp = 0;
	updtp = 0;
 
	/* pressure scale integration sigma = atms.p / p0 */
	for(k = 1; k < 33; k++)
	{
	    ds = (atms.p[k-1] - atms.p[k]) / atms.p[0];
	    ds2 = (atms.p[k-1] * atms.p[k-1] - atms.p[k] * atms.p[k]) / (2 * atms.p[0] * p0);
	    uu = uu + ((rm[k] + rm[k-1]) / 2) * ds * rat[idgaz-1];
	    u  = u  + ((r2[k] + r2[k-1]) / 2) * ds * rat[idgaz-1];
	    up = up + ((r3[k] + r3[k-1]) / 2) * ds2 * rat[idgaz-1];
	}
	
	uu = uu * atms.p[0] * 100 / g;
	u = u * atms.p[0] * 100 / g;
	up = up * atms.p[0] * 100 / g;
	                                             
	if(idgaz == 4) uu = 1000 * uu / rmo3;   
	if(idgaz == 2) uu = 1000 * uu / roco2; 
	if(idgaz == 5) uu = 1000 * uu / rmn2o;
	if(idgaz == 6) uu = 1000 * uu / rmch4;
	if(idgaz == 7) uu = 1000 * uu / rmco;
 
	/* mixing ratio for plane calculation for each gaseous constituents */
	if ((alt.idatmp == 0) || (alt.idatmp == 4)) 
	{
	    uupl = uu;
	    upl = u;
	    uppl = up;
	}
	else
	{
	    for(k = 0; k < 33; k++)
	    {
		roair = air * 273.16f * alt.plane_sim.ppl[k] / (1013.25f * alt.plane_sim.tpl[k]);
		tp[k]  =  (alt.plane_sim.tpl[k] + alt.plane_sim.tpl[k + 1]) / 2;
		te = tp[k] - t0;
		te2 = te * te;
		phi = (double)exp(a[2] * te + a[3] * te2);
		psi = (double)exp(a[4] * te + a[5] * te2);
		if(idgaz == 1) rmpl[k] = alt.plane_sim.whpl[k] / (roair * 1000);
		if(idgaz == 2) rmpl[k] = 3.3e-04f * roco2 / air;
		if(idgaz == 3) rmpl[k] = 0.20947f * rmo2 / air;
		if(idgaz == 4) rmpl[k] = alt.plane_sim.wopl[k] / (roair * 1000);
		if(idgaz == 5) rmpl[k] = 310.e-09f * rmn2o / air;
		if(idgaz ==	6) rmpl[k] = 1.72e-06f * rmch4 / air;
		if(idgaz == 7) rmpl[k] = 1.00e-09f * rmco  / air;
		r2pl[k] = rmpl[k] * phi;
		r3pl[k] = rmpl[k] * psi;
	    }

	    uupl = 0;
	    upl = 0;
	    uppl = 0;
			
	    /* update ratio plane */
	    for(int i = 0; i < 10; i++)	ratpl[i] = 1;

	    if (alt.idatmp == 8) 
	    {
		ratpl[0] = uwpl / uwusp;
		ratpl[1] = 1;
		ratpl[2] = 1;
		ratpl[3] = uo3pl / uo3usp;
		ratpl[4] = 1;
		ratpl[5] = 1;
		ratpl[6] = 1;
		ratpl[7] = uwpl / uwusp;
		ratpl[8] = uwpl / uwusp;
		ratpl[9] = uwpl / uwusp;
	    }

	    /* pressure scale integration sigma = atms.p / p0 */
	    /* * all gases*/

	    for(k = 1; k < 33; k++)
	    {
		ds = (alt.plane_sim.ppl[k-1] - alt.plane_sim.ppl[k]) / alt.plane_sim.ppl[0];
		ds2 = (alt.plane_sim.ppl[k-1] * alt.plane_sim.ppl[k-1] - 
		       alt.plane_sim.ppl[k] * alt.plane_sim.ppl[k]) / 
		    (2 * alt.plane_sim.ppl[0] * p0);
		uupl = uupl + ((rmpl[k] + rmpl[k-1]) / 2) * ds * ratpl[idgaz-1];
		upl  = upl  + ((r2pl[k] + r2pl[k-1]) / 2) * ds * ratpl[idgaz-1];
		uppl = uppl + ((r3pl[k] + r3pl[k-1]) / 2) * ds2 * ratpl[idgaz-1];
	    }

	    uupl = uupl * alt.plane_sim.ppl[0] * 100 / g;
	    upl = upl * alt.plane_sim.ppl[0] * 100 / g;
	    uppl = uppl * alt.plane_sim.ppl[0] * 100 / g;
	 
	    if(idgaz == 4) uupl = 1000 * uupl / rmo3;
	    if(idgaz == 2) uupl = 1000 * uupl / roco2;
	    if(idgaz == 5) uupl = 1000 * uupl / rmn2o;
	    if(idgaz == 6) uupl = 1000 * uupl / rmch4;
	    if(idgaz == 7) uupl = 1000 * uupl / rmco;
		
	} /* endif test atms.idatm  = 0,4 */
 
	/* downward path */
	uud	= uu / xmus;
	/* upward path */
	uuu = uupl / xmuv;
	/* total(down + up) path */
	uut = uu / xmus + uupl / xmuv;
 
	if((idgaz == 2 && iv > 9620) || (idgaz == 3 && iv > 15920))
	{
	    tnu[idgaz-1][0] = 1;
	    tnu[idgaz-1][1] = 1;
	    tnu[idgaz-1][2] = 1;
	    continue;
	}

	if(idgaz == 1 || idgaz == 4) 
	{
	    xi = 0;
	    n = 0;
	    xd = 0;
	    if(!(iv < 2350 || iv > 3000)) 

	    {
		xi = (v - 2350) / 50 + 1;
		nh = (int)(xi + 1.001f);
		xh = xi - double(nh);
		ah2o = cch2o[nh-1] + xh * (cch2o[nh-1]-cch2o[nh-2]);
		dtcont = (double)exp(-ah2o * uud);
		utcont = (double)exp(-ah2o * uuu);
		ttcont = (double)exp(-ah2o * uut);
	    }

	    if (!((idgaz == 1) || (iv < 13000))) 
	    {
		if(iv <=  23400) xi = (v - 13000) / 200 + 1;
		else if(iv >=  27500) xi = (v - 27500) / 500 + 57;
		else 
		{
		    tnu[3][0] = 1;
		    tnu[3][1] = 1;
		    tnu[3][2] = 1;
		    break;
		}

		n = (int)(xi + 1.001);
		xd = xi-double(n);
		ako3 = co3[n-1] + xd * (co3[n-1] - co3[n-2]);
		test1 = ako3 * uud;
		test2 = ako3 * uuu;
		test3 = ako3 * uut;
 
		/* exponential overflow test */
 
		if(test1 > 86.0) test1 = 86.0;
		if(test2 > 86.0) test2 = 86.0;
		if(test3 > 86.0) test3 = 86.0;
	 
		tnu[3][0] = (double)exp(-test1);
		tnu[3][1] = (double)exp(-test2);
		tnu[3][2] = (double)exp(-test3);

		continue;
	    }
	} 

	if(idgaz == 4 && iv > 3020) {
	    tnu[idgaz-1][0] = 1;
	    tnu[idgaz-1][1] = 1;
	    tnu[idgaz-1][2] = 1;
	    continue;
	}
			
	/* downward path */
	ud = u / xmus;
	upd = up / xmus;
	udt = ud;
	if(ud == 0 && upd == 0) udt = 1;
	tn = a[1] * upd / (2 * udt);
	atest = a[1];
	if (a[1] == 0 && a[0] == 0.) atest = 1;
	updt = upd;
	if(ud == 0 && upd == 0.) updt = 1;
	tt = 1 + 4 * (a[0] / atest) * ((ud * ud) / updt);
	y = (double)(-tn * (sqrt(tt) - 1));
	if(idgaz == 1) y = (double)(-a[0] * ud / sqrt(1 + (a[0] / atest) * (ud * ud / updt)));
	tnu[idgaz-1][0] = (double)exp(y);
		
			
	/* upward path modified to take account for plane content */
	udp = upl / xmuv;
	updp = uppl / xmuv;
	udtp = udp;
	if(udp == 0 && updp == 0.) udtp = 1;
	tn = a[1] * updp / (2 * udtp);
	atest = a[1];
	if (a[1] == 0 && a[0] == 0.) atest = 1;
	updtp = updp;
	if(udp == 0 && updp == 0.) updtp = 1;
	tt = 1 + 4 * (a[0] / atest) * ((udp * udp) / updtp);
	y = (double)(-tn * (sqrt(tt) - 1));
	if(idgaz == 1) y = (double)(-a[0] * udp / sqrt(1 + (a[0] / atest) * (udp * udp / updtp)));
	tnu[idgaz-1][1] = (double)exp(y);

	/* total(down + up) path modified on the way up */
	ut = u / xmus + upl / xmuv;
	upt = up / xmus + uppl / xmuv;
	utt = ut;
	if(ut == 0 && upt == 0.) utt = 1;
	tn = a[1] * upt / (2 * utt);
	uptt = upt;
	if(ut == 0 && upt == 0.) uptt = 1;
	tt = 1 + 4 * (a[0] / atest) * ((ut * ut) / uptt);
	y = (double)(-tn * (sqrt(tt) - 1));
	if(idgaz == 1) y = (double)(-a[0] * ut / sqrt(1 + (a[0] / atest) * (ut * ut / uptt)));
	tnu[idgaz-1][2] = (double)exp(y);
    }   

    ptest1 = tnu[0][0] * dtcont;
    ptest = ptest1;
    if (ptest > 1e-10) as.dtwava = (double)ptest;
    else as.dtwava = 0;
	
    ptest1 = tnu[0][1] * utcont;
    ptest = ptest1;

    if (ptest > 1e-10) as.utwava = (double)ptest;
    else as.utwava = 0;
	
    ptest1 = tnu[0][2] * ttcont;
    ptest = ptest1;

    if (ptest > 1e-10) as.ttwava = (double)ptest;
    else as.ttwava = 0;
	
    as.dtdica = tnu[1][0];
    as.utdica = tnu[1][1];
    as.ttdica = tnu[1][2];
    as.dtoxyg = tnu[2][0];
    as.utoxyg = tnu[2][1];
    as.ttoxyg = tnu[2][2];
    as.dtozon = tnu[3][0];
    as.utozon = tnu[3][1];
    as.ttozon = tnu[3][2];
    as.dtniox = tnu[4][0];
    as.utniox = tnu[4][1];
    as.ttniox = tnu[4][2];
    as.dtmeth = tnu[5][0];
    as.utmeth = tnu[5][1];
    as.ttmeth = tnu[5][2];
    as.dtmoca = tnu[6][0];
    as.utmoca = tnu[6][1];
    as.ttmoca = tnu[6][2];

    if (alt.idatmp == 0) 
    {
	as.ttwava = as.dtwava;
	as.utwava = 1;
	as.ttdica = as.dtdica;
	as.utdica = 1;
	as.ttoxyg = as.dtoxyg;
	as.utoxyg = 1;
	as.ttozon = as.dtozon;
	as.utozon = 1;
	as.ttniox = as.dtniox;
	as.utniox = 1;
	as.ttmeth = as.dtmeth;
	as.utmeth = 1;
	as.ttmoca = as.dtmoca;
	as.utmoca = 1;
    }
}
