/*--------------------------------------------------------------------*//*:Ignore this sentence.
Copyright (C) 1999, 2001 SIL International. All rights reserved.

Distributable under the terms of either the Common Public License or the
GNU Lesser General Public License, as specified in the LICENSING.txt file.

File: GrpTokenStreamFilter.cpp
Responsibility: Sharon Correll
Last reviewed: Not yet.

Description:
    A filter to intercept the line-and-file information generated by the C preprocessor and
	do something with it.
-------------------------------------------------------------------------------*//*:End Ignore*/

#ifndef GRP_TOKSTREAM
#define GRP_TOKSTREAM

class GrpLexer;

class GrpTokenStreamFilter : public TokenStream
{
public:
	virtual RefToken nextToken();

	GrpTokenStreamFilter(GrpLexer & lexer)
		: m_lexer(&lexer)
	{
		m_tokPeek = RefToken(NULL);
	}

	void init(std::string sta)
	{
		m_staFile = sta;
		m_nLineOffset = 0;

		m_nLastLineMarker = 0;
		m_nPrevLineOffset = 0;
	}

	void ReportLexerError(const ScannerException & ex);
	void ReportParserError(const ParserException & ex);

protected:
	GrpLexer * m_lexer;
	/////TokenStream * m_lexer;

	std::string m_staFile;
	int m_nLineOffset;

	//	For error messages. The current approach assumes that a syntax error does not span
	//	more than two files. We pass ParserExceptions back to this class; if the line number
	//	is less than the previous marker, we use the previous line-offset-and-file information;
	//	otherwise we use the current line-offset-and-file.
	int m_nLastLineMarker;
	std::string m_staPrevFile;
	int m_nPrevLineOffset;

	RefToken m_tokPeek;	// to peek for -if- following -else-
};


#endif // !GRP_TOKSTREAM
