;/*######   Copyright (c) 2001-2015 Ufasoft  http://ufasoft.com  mailto:support@ufasoft.com,  Sergey Pavlov  mailto:dev@ufasoft.com ####
;#                                                                                                                                     #
;# 		See LICENSE for licensing information                                                                                         #
;#####################################################################################################################################*/


IFNDEF __JWASM__
	IFNDEF @CPU
		X64	EQU	1
	ELSE
		X64	EQU	0
	ENDIF
ENDIF

IFNDEF X64
  	X64	EQU	0
ENDIF

IF X64
	IFDEF __JWASM__
		OPTION_LANGUAGE_C EQU OPTION LANGUAGE: C
	ELSE
		OPTION_LANGUAGE_C EQU

	ENDIF

  	ZAX	EQU	RAX
  	ZBX	EQU	RBX
  	ZCX	EQU	RCX
  	ZDX	EQU	RDX
  	ZSI	EQU	RSI
  	ZDI	EQU	RDI
  	ZSP	EQU	RSP
  	ZBP	EQU	RBP

  	ZWORD	EQU	QWORD
  	ZWORD_SIZE	EQU	8
  	ZWORD_BITS	EQU	6
  	ZWORD_PTR	EQU	QWORD PTR

	cZY		EQU	cqo

  	lodsZ	EQU lodsq
  	stosZ	EQU stosq
  	movsZ	EQU movsq

	jzcxz	EQU jrcxz

ELSE
	OPTION_LANGUAGE_C EQU OPTION LANGUAGE: C

  	ZAX	EQU	EAX
  	ZBX	EQU	EBX
  	ZCX	EQU	ECX
  	ZDX	EQU	EDX
  	ZSI	EQU	ESI
  	ZDI	EQU	EDI
  	ZSP	EQU	ESP
  	ZBP	EQU	EBP

	cZY		EQU	cdq

  	ZWORD	EQU	DWORD
  	ZWORD_SIZE	EQU	4
  	ZWORD_BITS	EQU	5
	ZWORD_PTR	EQU	DWORD PTR

  	lodsZ	EQU lodsd
  	stosZ	EQU stosd
  	movsZ	EQU movsd

	jzcxz	EQU jecxz

	.686P
    .MODEL FLAT
ENDIF

dotimes_i_8 MACRO cmd
	FOR i, <0, 1, 2, 3, 4, 5, 6, 7>
		xmm_i CATSTR <xmm>, %i
		cmd
	ENDM
ENDM

dotimes_i_12 MACRO cmd
	FOR i, <0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11>
		xmm_i CATSTR <xmm>, %i
		cmd
	ENDM
ENDM

OPTION_LANGUAGE_C

.CODE

