/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2002 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _TUBE_PAIR_H_
#define _TUBE_PAIR_H_

#include <list>

#include <gtk/gtk.h>

class Element;
class Tube;

class TubePair {
private:
   Tube* 		_upper_tube;
   Tube* 		_lower_tube;
   Tube* 		_left_tube;
   Tube*		_right_tube;

   TubePair*		_right_pair;
   TubePair*		_bottom_pair;

   GtkWidget* 		_pixmapwid;
   
   enum {Right, Left}	_direction;

   static void Toggle(GtkWidget *widget, gpointer data);

public:
   TubePair(GtkWidget* table, int row, int col);
   void ConnectLeft(TubePair* pair);
   void ConnectLeft(Element* element);
   void ConnectTop(TubePair* pair);
   void ConnectTop(Element* element);
   void ConnectRight(TubePair* pair);
   void ConnectRight(Element* element);
   void ConnectBottom(TubePair* pair);
   void ConnectBottom(Element* element);
   void ToggleDirection();
   TubePair* GetRightPair() {return _right_pair;}
   TubePair* GetBottomPair() {return _bottom_pair;}
};

class SetOffTubePairs {
   std::list<TubePair*> _set;
public:
   SetOffTubePairs() {}
   void Add(TubePair* tube_pair) {_set.push_back(tube_pair);}
   void MakeEmpty() {_set.erase(_set.begin(), _set.end());}
   void Shuffle();
};

#endif // _TUBE_PAIR_H_
