Highlights:
- Add capability to match services based on the name of the executable
- Add support for reloading in our systemd unit file
- Fix behavior with NFS setup

Alexander Scheel (17):
- Clarify test suite's logging
- Create krb5 config files before setting up LDAP
- Fix error reporting in init\_proc\_nfsd
- Conditionally reload kernel interface on SIGHUP
- Fix most memory leaks
- Fix error handling in gp\_config\_from\_dir
- Enable debugging for testsuites
- Check for TERM in external environment before setting in tests
- Update test and krb5 dependency list in BUILD.txt
- [client] Switch to non-blocking sockets
- [server] Add detailed request logging
- Don't leak mech\_type when CONTINUE\_NEEDED from init\_sec\_context
- Add call to verto\_cleanup()
- Simplify setting NONBLOCK on socket
- Fix handling of non-EPOLLIN/EPOLLOUT events
- Fix error handling in gpm\_send\_buffer/gpm\_recv\_buffer
- Fix silent crash with duplicate config sections

Robbie Harwood (27):
- Add mailing list and IRC links to README
- Turn on -Wextra
- Fix unused variables
- Fix mismatched sign comparisons
- Fix error checking on get\_impersonator\_fallback()
- Remove gpm\_release\_ctx() to fix double unlock
- Update systemd file
- Mark selinux config attributes as deprecated
- Require krb5 >= 1.14 for GSS\_KRB5\_CRED\_NO\_CI\_FLAGS\_X
- Fix segfault when no config files are present
- Include header for writev()
- Make proc file failure loud but nonfatal
- Appease gcc-7's fallthrough detection
- Support matching based on executable name
- Tolerate NULL pointers in gp\_same
- Fix double free of popt context when querying version
- Fix potential free of non-heap address
- Prevent uninitialized read in error path of XDR contexts
- Handle outdated encrypted ccaches
- Update Apache docs to reflect config file split
- Only empty FILE ccaches when storing remote creds
- Fix a krb5 error code being returned as GSS major
- Fix unused variable
- Separate cred and ccache manipulation in gpp\_store\_remote\_creds()
- Properly locate credentials in collection caches in mechglue
- Properly initialize ccaches before storing into them
- Update pagure release process

Simo Sorce (8):
- Properly renew expired credentials
- Change impersonator check code
- Allow connection to self when impersonator set
- Add Client ID to debug messages
- Fix memory leak
- Style fixes
- Emit debug on queue errors
- Do not call gpm\_grab\_sock() twice
