/*************************************************************************
* Copyright (C) 2017 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/

/*
//  Purpose:
//     Cryptography Primitive.
//     SMS4-CCM implementation.
// 
//     Content:
//        ippsSMS4_CCMGetSize()
//
*/

#include "owndefs.h"
#include "owncp.h"
#include "sms4/pcpsms4authccm.h"
#include "pcptool.h"

/*F*
//    Name: ippsSMS4_CCMGetSize
//
// Purpose: Returns size of SMS4-CCM state (bytes).
//
// Returns:                Reason:
//    ippStsNullPtrErr        pSzie == NULL
//    ippStsNoErr             no errors
//
// Parameters:
//    pSize       pointer to the size of CCM (in bytes)
//
*F*/
IPPFUN(IppStatus, ippsSMS4_CCMGetSize, (int* pSize))
{
    /* test size's pointer */
    IPP_BAD_PTR1_RET(pSize);

    *pSize = cpSizeofCtx_SMS4CCM();

    return ippStsNoErr;
}
