; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -O1 -mtriple=powerpc64-unknown-linux-gnu -mcpu=pwr8 < %s | FileCheck %s

; Test that a negative parameter smaller than 64 bits (e.g., int)
; is correctly implemented with sign-extension when passed to
; a floating point libcall.

define double @ldexp_test(ptr %a, ptr %b) nounwind {
; CHECK-LABEL: ldexp_test:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr 0
; CHECK-NEXT:    stdu 1, -112(1)
; CHECK-NEXT:    std 0, 128(1)
; CHECK-NEXT:    lfd 1, 0(3)
; CHECK-NEXT:    lwa 4, 0(4)
; CHECK-NEXT:    bl ldexp
; CHECK-NEXT:    nop
; CHECK-NEXT:    addi 1, 1, 112
; CHECK-NEXT:    ld 0, 16(1)
; CHECK-NEXT:    mtlr 0
; CHECK-NEXT:    blr
  %base = load double, ptr %a
  %exp = load i32, ptr %b
  %call = call double @llvm.ldexp.f64.i32(double %base, i32 signext %exp)
  ret double %call
}
