; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=arm-apple-ios -mattr=+neon | FileCheck %s

define <8 x i8> @v_bsli8(ptr %A, ptr %B, ptr %C) nounwind {
; CHECK-LABEL: v_bsli8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.i8 d16, #0x3
; CHECK-NEXT:    vldr d17, [r2]
; CHECK-NEXT:    vldr d18, [r0]
; CHECK-NEXT:    vbsl d16, d18, d17
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <8 x i8>, ptr %A
	%tmp2 = load <8 x i8>, ptr %B
	%tmp3 = load <8 x i8>, ptr %C
	%tmp4 = and <8 x i8> %tmp1, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
	%tmp6 = and <8 x i8> %tmp3, <i8 -4, i8 -4, i8 -4, i8 -4, i8 -4, i8 -4, i8 -4, i8 -4>
	%tmp7 = or <8 x i8> %tmp4, %tmp6
	ret <8 x i8> %tmp7
}

define <4 x i16> @v_bsli16(ptr %A, ptr %B, ptr %C) nounwind {
; CHECK-LABEL: v_bsli16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.i16 d16, #0x3
; CHECK-NEXT:    vldr d17, [r2]
; CHECK-NEXT:    vldr d18, [r0]
; CHECK-NEXT:    vbsl d16, d18, d17
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <4 x i16>, ptr %A
	%tmp2 = load <4 x i16>, ptr %B
	%tmp3 = load <4 x i16>, ptr %C
	%tmp4 = and <4 x i16> %tmp1, <i16 3, i16 3, i16 3, i16 3>
	%tmp6 = and <4 x i16> %tmp3, <i16 -4, i16 -4, i16 -4, i16 -4>
	%tmp7 = or <4 x i16> %tmp4, %tmp6
	ret <4 x i16> %tmp7
}

define <2 x i32> @v_bsli32(ptr %A, ptr %B, ptr %C) nounwind {
; CHECK-LABEL: v_bsli32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.i32 d16, #0x3
; CHECK-NEXT:    vldr d17, [r2]
; CHECK-NEXT:    vldr d18, [r0]
; CHECK-NEXT:    vbsl d16, d18, d17
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <2 x i32>, ptr %A
	%tmp2 = load <2 x i32>, ptr %B
	%tmp3 = load <2 x i32>, ptr %C
	%tmp4 = and <2 x i32> %tmp1, <i32 3, i32 3>
	%tmp6 = and <2 x i32> %tmp3, <i32 -4, i32 -4>
	%tmp7 = or <2 x i32> %tmp4, %tmp6
	ret <2 x i32> %tmp7
}

define <1 x i64> @v_bsli64(ptr %A, ptr %B, ptr %C) nounwind {
; CHECK-LABEL: v_bsli64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr d17, [r2]
; CHECK-NEXT:    vldr d16, LCPI3_0
; CHECK-NEXT:    vldr d18, [r0]
; CHECK-NEXT:    vbsl d16, d18, d17
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <1 x i64>, ptr %A
	%tmp2 = load <1 x i64>, ptr %B
	%tmp3 = load <1 x i64>, ptr %C
	%tmp4 = and <1 x i64> %tmp1, <i64 3>
	%tmp6 = and <1 x i64> %tmp3, <i64 -4>
	%tmp7 = or <1 x i64> %tmp4, %tmp6
	ret <1 x i64> %tmp7
}

define <16 x i8> @v_bslQi8(ptr %A, ptr %B, ptr %C) nounwind {
; CHECK-LABEL: v_bslQi8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vld1.32 {d16, d17}, [r2]
; CHECK-NEXT:    vmov.i8 q9, #0x3
; CHECK-NEXT:    vld1.32 {d20, d21}, [r0]
; CHECK-NEXT:    vbit q8, q10, q9
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    vmov r2, r3, d17
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <16 x i8>, ptr %A
	%tmp2 = load <16 x i8>, ptr %B
	%tmp3 = load <16 x i8>, ptr %C
	%tmp4 = and <16 x i8> %tmp1, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
	%tmp6 = and <16 x i8> %tmp3, <i8 -4, i8 -4, i8 -4, i8 -4, i8 -4, i8 -4, i8 -4, i8 -4, i8 -4, i8 -4, i8 -4, i8 -4, i8 -4, i8 -4, i8 -4, i8 -4>
	%tmp7 = or <16 x i8> %tmp4, %tmp6
	ret <16 x i8> %tmp7
}

define <8 x i16> @v_bslQi16(ptr %A, ptr %B, ptr %C) nounwind {
; CHECK-LABEL: v_bslQi16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vld1.32 {d16, d17}, [r2]
; CHECK-NEXT:    vmov.i16 q9, #0x3
; CHECK-NEXT:    vld1.32 {d20, d21}, [r0]
; CHECK-NEXT:    vbit q8, q10, q9
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    vmov r2, r3, d17
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <8 x i16>, ptr %A
	%tmp2 = load <8 x i16>, ptr %B
	%tmp3 = load <8 x i16>, ptr %C
	%tmp4 = and <8 x i16> %tmp1, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
	%tmp6 = and <8 x i16> %tmp3, <i16 -4, i16 -4, i16 -4, i16 -4, i16 -4, i16 -4, i16 -4, i16 -4>
	%tmp7 = or <8 x i16> %tmp4, %tmp6
	ret <8 x i16> %tmp7
}

define <4 x i32> @v_bslQi32(ptr %A, ptr %B, ptr %C) nounwind {
; CHECK-LABEL: v_bslQi32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vld1.32 {d16, d17}, [r2]
; CHECK-NEXT:    vmov.i32 q9, #0x3
; CHECK-NEXT:    vld1.32 {d20, d21}, [r0]
; CHECK-NEXT:    vbit q8, q10, q9
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    vmov r2, r3, d17
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <4 x i32>, ptr %A
	%tmp2 = load <4 x i32>, ptr %B
	%tmp3 = load <4 x i32>, ptr %C
	%tmp4 = and <4 x i32> %tmp1, <i32 3, i32 3, i32 3, i32 3>
	%tmp6 = and <4 x i32> %tmp3, <i32 -4, i32 -4, i32 -4, i32 -4>
	%tmp7 = or <4 x i32> %tmp4, %tmp6
	ret <4 x i32> %tmp7
}

define <2 x i64> @v_bslQi64(ptr %A, ptr %B, ptr %C) nounwind {
; CHECK-LABEL: v_bslQi64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vld1.32 {d16, d17}, [r2]
; CHECK-NEXT:    vld1.32 {d18, d19}, [r0]
; CHECK-NEXT:    adr r0, LCPI7_0
; CHECK-NEXT:    vld1.64 {d20, d21}, [r0:128]
; CHECK-NEXT:    vbit q8, q9, q10
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    vmov r2, r3, d17
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <2 x i64>, ptr %A
	%tmp2 = load <2 x i64>, ptr %B
	%tmp3 = load <2 x i64>, ptr %C
	%tmp4 = and <2 x i64> %tmp1, <i64 3, i64 3>
	%tmp6 = and <2 x i64> %tmp3, <i64 -4, i64 -4>
	%tmp7 = or <2 x i64> %tmp4, %tmp6
	ret <2 x i64> %tmp7
}
