; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=m68k-linux | FileCheck %s

define i32 @mul4_32(i32 %A) {
; CHECK-LABEL: mul4_32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    move.l (4,%sp), %d0
; CHECK-NEXT:    lsl.l #2, %d0
; CHECK-NEXT:    rts
    %mul = mul i32 %A, 4
    ret i32 %mul
}

define i64 @mul4_64(i64 %A) {
; CHECK-LABEL: mul4_64:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    suba.l #4, %sp
; CHECK-NEXT:    .cfi_def_cfa_offset -8
; CHECK-NEXT:    movem.l %d2, (0,%sp) ; 8-byte Folded Spill
; CHECK-NEXT:    moveq #30, %d0
; CHECK-NEXT:    move.l (12,%sp), %d1
; CHECK-NEXT:    move.l %d1, %d2
; CHECK-NEXT:    lsr.l %d0, %d2
; CHECK-NEXT:    move.l (8,%sp), %d0
; CHECK-NEXT:    lsl.l #2, %d0
; CHECK-NEXT:    or.l %d2, %d0
; CHECK-NEXT:    lsl.l #2, %d1
; CHECK-NEXT:    movem.l (0,%sp), %d2 ; 8-byte Folded Reload
; CHECK-NEXT:    adda.l #4, %sp
; CHECK-NEXT:    rts
    %mul = mul i64 %A, 4
    ret i64 %mul
}

define i32 @mul4096_32(i32 %A) {
; CHECK-LABEL: mul4096_32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    moveq #12, %d1
; CHECK-NEXT:    move.l (4,%sp), %d0
; CHECK-NEXT:    lsl.l %d1, %d0
; CHECK-NEXT:    rts
    %mul = mul i32 %A, 4096
    ret i32 %mul
}

define i64 @mul4096_64(i64 %A) {
; CHECK-LABEL: mul4096_64:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    suba.l #8, %sp
; CHECK-NEXT:    .cfi_def_cfa_offset -12
; CHECK-NEXT:    movem.l %d2-%d3, (0,%sp) ; 12-byte Folded Spill
; CHECK-NEXT:    moveq #20, %d0
; CHECK-NEXT:    move.l (16,%sp), %d1
; CHECK-NEXT:    move.l %d1, %d2
; CHECK-NEXT:    lsr.l %d0, %d2
; CHECK-NEXT:    moveq #12, %d3
; CHECK-NEXT:    move.l (12,%sp), %d0
; CHECK-NEXT:    lsl.l %d3, %d0
; CHECK-NEXT:    or.l %d2, %d0
; CHECK-NEXT:    lsl.l %d3, %d1
; CHECK-NEXT:    movem.l (0,%sp), %d2-%d3 ; 12-byte Folded Reload
; CHECK-NEXT:    adda.l #8, %sp
; CHECK-NEXT:    rts
    %mul = mul i64 %A, 4096
    ret i64 %mul
}

define i32 @mulmin4096_32(i32 %A) {
; CHECK-LABEL: mulmin4096_32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    moveq #12, %d1
; CHECK-NEXT:    move.l (4,%sp), %d0
; CHECK-NEXT:    lsl.l %d1, %d0
; CHECK-NEXT:    neg.l %d0
; CHECK-NEXT:    rts
    %mul = mul i32 %A, -4096
    ret i32 %mul
}

define i64 @mulmin4096_64(i64 %A) {
; CHECK-LABEL: mulmin4096_64:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    suba.l #8, %sp
; CHECK-NEXT:    .cfi_def_cfa_offset -12
; CHECK-NEXT:    movem.l %d2-%d3, (0,%sp) ; 12-byte Folded Spill
; CHECK-NEXT:    moveq #20, %d0
; CHECK-NEXT:    move.l (16,%sp), %d1
; CHECK-NEXT:    move.l %d1, %d2
; CHECK-NEXT:    lsr.l %d0, %d2
; CHECK-NEXT:    moveq #12, %d3
; CHECK-NEXT:    move.l (12,%sp), %d0
; CHECK-NEXT:    lsl.l %d3, %d0
; CHECK-NEXT:    or.l %d2, %d0
; CHECK-NEXT:    lsl.l %d3, %d1
; CHECK-NEXT:    neg.l %d1
; CHECK-NEXT:    negx.l %d0
; CHECK-NEXT:    movem.l (0,%sp), %d2-%d3 ; 12-byte Folded Reload
; CHECK-NEXT:    adda.l #8, %sp
; CHECK-NEXT:    rts
    %mul = mul i64 %A, -4096
    ret i64 %mul
}

; No i32 multiply for M68000
define i32 @mul_32(i32 %a, i32 %b) {
; CHECK-LABEL: mul_32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    suba.l #12, %sp
; CHECK-NEXT:    .cfi_def_cfa_offset -16
; CHECK-NEXT:    move.l (20,%sp), (4,%sp)
; CHECK-NEXT:    move.l (16,%sp), (%sp)
; CHECK-NEXT:    jsr __mulsi3
; CHECK-NEXT:    adda.l #12, %sp
; CHECK-NEXT:    rts
    %mul = mul i32 %a, %b
    ret i32 %mul
}

; Lower to shift and add if we can
define i32 @mul3_32(i32 %A) {
; CHECK-LABEL: mul3_32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    move.l (4,%sp), %d1
; CHECK-NEXT:    move.l %d1, %d0
; CHECK-NEXT:    lsl.l #1, %d0
; CHECK-NEXT:    add.l %d1, %d0
; CHECK-NEXT:    rts
    %mul = mul i32 %A, 3
    ret i32 %mul
}

define i32 @mul40_32(i32 %A) {
; CHECK-LABEL: mul40_32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    move.l (4,%sp), %d0
; CHECK-NEXT:    move.l %d0, %d1
; CHECK-NEXT:    lsl.l #3, %d1
; CHECK-NEXT:    lsl.l #5, %d0
; CHECK-NEXT:    add.l %d1, %d0
; CHECK-NEXT:    rts
    %mul = mul i32 %A, 40
    ret i32 %mul
}

; No i64 multiply for M68000
define i64 @mul_64(i64 %a, i64 %b) {
; CHECK-LABEL: mul_64:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    suba.l #20, %sp
; CHECK-NEXT:    .cfi_def_cfa_offset -24
; CHECK-NEXT:    move.l (36,%sp), (12,%sp)
; CHECK-NEXT:    move.l (32,%sp), (8,%sp)
; CHECK-NEXT:    move.l (28,%sp), (4,%sp)
; CHECK-NEXT:    move.l (24,%sp), (%sp)
; CHECK-NEXT:    jsr __muldi3
; CHECK-NEXT:    adda.l #20, %sp
; CHECK-NEXT:    rts
    %mul = mul i64 %a, %b
    ret i64 %mul
}

define i64 @mul3_64(i64 %A) {
; CHECK-LABEL: mul3_64:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    suba.l #20, %sp
; CHECK-NEXT:    .cfi_def_cfa_offset -24
; CHECK-NEXT:    move.l #3, (12,%sp)
; CHECK-NEXT:    move.l #0, (8,%sp)
; CHECK-NEXT:    move.l (28,%sp), (4,%sp)
; CHECK-NEXT:    move.l (24,%sp), (%sp)
; CHECK-NEXT:    jsr __muldi3
; CHECK-NEXT:    adda.l #20, %sp
; CHECK-NEXT:    rts
    %mul = mul i64 %A, 3
    ret i64 %mul
}

define i64 @mul40_64(i64 %A) {
; CHECK-LABEL: mul40_64:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    suba.l #20, %sp
; CHECK-NEXT:    .cfi_def_cfa_offset -24
; CHECK-NEXT:    move.l #40, (12,%sp)
; CHECK-NEXT:    move.l #0, (8,%sp)
; CHECK-NEXT:    move.l (28,%sp), (4,%sp)
; CHECK-NEXT:    move.l (24,%sp), (%sp)
; CHECK-NEXT:    jsr __muldi3
; CHECK-NEXT:    adda.l #20, %sp
; CHECK-NEXT:    rts
    %mul = mul i64 %A, 40
    ret i64 %mul
}

define i32 @mul4_32_minsize(i32 %A) minsize {
; CHECK-LABEL: mul4_32_minsize:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    move.l (4,%sp), %d0
; CHECK-NEXT:    lsl.l #2, %d0
; CHECK-NEXT:    rts
    %mul = mul i32 %A, 4
    ret i32 %mul
}

define i32 @mul40_32_minsize(i32 %A) minsize {
; CHECK-LABEL: mul40_32_minsize:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    move.l (4,%sp), %d0
; CHECK-NEXT:    move.l %d0, %d1
; CHECK-NEXT:    lsl.l #3, %d1
; CHECK-NEXT:    lsl.l #5, %d0
; CHECK-NEXT:    add.l %d1, %d0
; CHECK-NEXT:    rts
    %mul = mul i32 %A, 40
    ret i32 %mul
}

define i32 @mul33_32(i32 %A) {
; CHECK-LABEL: mul33_32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    move.l (4,%sp), %d1
; CHECK-NEXT:    move.l %d1, %d0
; CHECK-NEXT:    lsl.l #5, %d0
; CHECK-NEXT:    add.l %d1, %d0
; CHECK-NEXT:    rts
    %mul = mul i32 %A, 33
    ret i32 %mul
}

define i32 @mul31_32(i32 %A) {
; CHECK-LABEL: mul31_32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    move.l (4,%sp), %d1
; CHECK-NEXT:    move.l %d1, %d0
; CHECK-NEXT:    lsl.l #5, %d0
; CHECK-NEXT:    sub.l %d1, %d0
; CHECK-NEXT:    rts
    %mul = mul i32 %A, 31
    ret i32 %mul
}

define i32 @mul0_32(i32 %A) {
; CHECK-LABEL: mul0_32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0:
; CHECK-NEXT:    moveq #0, %d0
; CHECK-NEXT:    rts
    %mul = mul i32 %A, 0
    ret i32 %mul
}
