; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=m68k -verify-machineinstrs | FileCheck %s

define zeroext i8 @umul_i8(i8 signext %a, i8 signext %b) nounwind ssp {
; CHECK-LABEL: umul_i8:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    move.b (11,%sp), %d0
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    move.b (7,%sp), %d1
; CHECK-NEXT:    and.l #255, %d1
; CHECK-NEXT:    muls %d0, %d1
; CHECK-NEXT:    move.l %d1, %d0
; CHECK-NEXT:    and.l #65535, %d0
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    rts
entry:
  %umul = tail call { i8, i1 } @llvm.umul.with.overflow.i8(i8 %a, i8 %b)
  %cmp = extractvalue { i8, i1 } %umul, 1
  %umul.result = extractvalue { i8, i1 } %umul, 0
  %X = select i1 %cmp, i8 42, i8 %umul.result
  ret i8 %X
}

define zeroext i8 @umul_i8_no_ovf(i8 signext %a, i8 signext %b) nounwind ssp {
; CHECK-LABEL: umul_i8_no_ovf:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    moveq #42, %d0
; CHECK-NEXT:    rts
entry:
  %umul = tail call { i8, i1 } @llvm.umul.with.overflow.i8(i8 %a, i8 %b)
  %cmp = extractvalue { i8, i1 } %umul, 1
  %umul.result = extractvalue { i8, i1 } %umul, 0
  %X = select i1 %cmp, i8 %umul.result, i8 42
  ret i8 %X
}

declare { i8, i1 } @llvm.umul.with.overflow.i8(i8, i8) nounwind readnone

define zeroext i16 @umul_i16(i16 signext %a, i16 signext %b) nounwind ssp {
; CHECK-LABEL: umul_i16:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    move.w (6,%sp), %d0
; CHECK-NEXT:    move.w (10,%sp), %d1
; CHECK-NEXT:    muls %d1, %d0
; CHECK-NEXT:    and.l #65535, %d0
; CHECK-NEXT:    rts
entry:
  %umul = tail call { i16, i1 } @llvm.umul.with.overflow.i16(i16 %a, i16 %b)
  %cmp = extractvalue { i16, i1 } %umul, 1
  %umul.result = extractvalue { i16, i1 } %umul, 0
  %X = select i1 %cmp, i16 42, i16 %umul.result
  ret i16 %X
}

declare { i16, i1 } @llvm.umul.with.overflow.i16(i16, i16) nounwind readnone

declare {i32, i1} @llvm.umul.with.overflow.i32(i32 %a, i32 %b)

define i1 @a(i32 %x)  nounwind {
; CHECK-LABEL: a:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    moveq #3, %d0
; CHECK-NEXT:    move.l (4,%sp), %d1
; CHECK-NEXT:    mulu.l %d0, %d1
; CHECK-NEXT:    svs %d0
; CHECK-NEXT:    rts
  %res = call {i32, i1} @llvm.umul.with.overflow.i32(i32 %x, i32 3)
  %obil = extractvalue {i32, i1} %res, 1
  ret i1 %obil
}

define i32 @test2(i32 %a, i32 %b) nounwind readnone {
; CHECK-LABEL: test2:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    move.l (8,%sp), %d0
; CHECK-NEXT:    add.l (4,%sp), %d0
; CHECK-NEXT:    add.l %d0, %d0
; CHECK-NEXT:    rts
entry:
	%tmp0 = add i32 %b, %a
	%tmp1 = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 %tmp0, i32 2)
	%tmp2 = extractvalue { i32, i1 } %tmp1, 0
	ret i32 %tmp2
}

; It shouldn't fallback to builtin in this scenario
; Since we don't need the overflow bit here
define i32 @test3(i32 %a, i32 %b) nounwind readnone {
; CHECK-LABEL: test3:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    move.l (8,%sp), %d0
; CHECK-NEXT:    add.l (4,%sp), %d0
; CHECK-NEXT:    moveq #4, %d1
; CHECK-NEXT:    mulu.l %d1, %d0
; CHECK-NEXT:    rts
entry:
	%tmp0 = add i32 %b, %a
	%tmp1 = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 %tmp0, i32 4)
	%tmp2 = extractvalue { i32, i1 } %tmp1, 0
	ret i32 %tmp2
}
