; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve.fp %s -o - | FileCheck %s

; This loop has a vpt block that should not block tailpredication
define void @convert_vptblock(ptr %pchTarget, i16 signext %iTargetStride, ptr %pwLineMask, ptr %ptCopySize, i8 zeroext %chColour, i8 zeroext %chOpacity) {
; CHECK-LABEL: convert_vptblock:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    ldrsh.w r12, [r3, #2]
; CHECK-NEXT:    cmp.w r12, #1
; CHECK-NEXT:    it lt
; CHECK-NEXT:    bxlt lr
; CHECK-NEXT:  .LBB0_1: @ %for.body.lr.ph
; CHECK-NEXT:    .save {r4, r5, r6, r7, r8, r9, r10, r11, lr}
; CHECK-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, r11, lr}
; CHECK-NEXT:    .pad #4
; CHECK-NEXT:    sub sp, #4
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    ldrsh.w r10, [r3]
; CHECK-NEXT:    mov.w r8, #0
; CHECK-NEXT:    ldrd r4, r5, [sp, #88]
; CHECK-NEXT:    mov r7, r0
; CHECK-NEXT:    mov.w r11, #0
; CHECK-NEXT:    vidup.u16 q0, r8, #4
; CHECK-NEXT:    vmov.i32 q1, #0x0
; CHECK-NEXT:    vmov.i16 q2, #0x100
; CHECK-NEXT:    vmov.i16 q3, #0xff
; CHECK-NEXT:  .LBB0_2: @ %for.body
; CHECK-NEXT:    @ =>This Loop Header: Depth=1
; CHECK-NEXT:    @ Child Loop BB0_3 Depth 2
; CHECK-NEXT:    vmov q4, q0
; CHECK-NEXT:    mov r6, r8
; CHECK-NEXT:    mov r0, r7
; CHECK-NEXT:    dlstp.16 lr, r10
; CHECK-NEXT:  .LBB0_3: @ %do.body
; CHECK-NEXT:    @ Parent Loop BB0_2 Depth=1
; CHECK-NEXT:    @ => This Inner Loop Header: Depth=2
; CHECK-NEXT:    vldrb.u16 q5, [r2, q4]
; CHECK-NEXT:    vmul.i16 q4, q5, r5
; CHECK-NEXT:    vshr.u16 q4, q4, #8
; CHECK-NEXT:    vsub.i16 q5, q2, q4
; CHECK-NEXT:    vpt.i16 eq, q4, q3
; CHECK-NEXT:    vmovt q5, q1
; CHECK-NEXT:    vldrb.u16 q6, [r0]
; CHECK-NEXT:    vsub.i16 q4, q2, q5
; CHECK-NEXT:    vmul.i16 q5, q5, q6
; CHECK-NEXT:    vmla.i16 q5, q4, r4
; CHECK-NEXT:    vshr.u16 q4, q5, #8
; CHECK-NEXT:    vstrb.16 q4, [r0], #8
; CHECK-NEXT:    vidup.u16 q4, r6, #4
; CHECK-NEXT:    letp lr, .LBB0_3
; CHECK-NEXT:  @ %bb.4: @ %do.end
; CHECK-NEXT:    @ in Loop: Header=BB0_2 Depth=1
; CHECK-NEXT:    add.w r0, r11, #1
; CHECK-NEXT:    add r7, r1
; CHECK-NEXT:    sxth.w r11, r0
; CHECK-NEXT:    cmp r11, r12
; CHECK-NEXT:    blt .LBB0_2
; CHECK-NEXT:  @ %bb.5:
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    add sp, #4
; CHECK-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, r11, lr}
; CHECK-NEXT:    bx lr
entry:
  %iHeight1 = getelementptr inbounds i8, ptr %ptCopySize, i32 2
  %0 = load i16, ptr %iHeight1, align 2
  %cmp28 = icmp sgt i16 %0, 0
  br i1 %cmp28, label %for.body.lr.ph, label %for.cond.cleanup

for.body.lr.ph:                                   ; preds = %entry
  %1 = load i16, ptr %ptCopySize, align 2
  %conv5 = sext i16 %1 to i32
  %2 = tail call { <8 x i16>, i32 } @llvm.arm.mve.vidup.v8i16(i32 0, i32 4)
  %conv6 = zext i8 %chOpacity to i16
  %.splatinsert = insertelement <8 x i16> poison, i16 %conv6, i64 0
  %.splat = shufflevector <8 x i16> %.splatinsert, <8 x i16> poison, <8 x i32> zeroinitializer
  %conv7 = zext i8 %chColour to i16
  %.splatinsert.i = insertelement <8 x i16> poison, i16 %conv7, i64 0
  %.splat.i = shufflevector <8 x i16> %.splatinsert.i, <8 x i16> poison, <8 x i32> zeroinitializer
  %conv11 = sext i16 %iTargetStride to i32
  br label %for.body

for.cond.cleanup:                                 ; preds = %do.end, %entry
  ret void

for.body:                                         ; preds = %for.body.lr.ph, %do.end
  %pchTarget.addr.030 = phi ptr [ %pchTarget, %for.body.lr.ph ], [ %add.ptr12, %do.end ]
  %y.029 = phi i16 [ 0, %for.body.lr.ph ], [ %inc, %do.end ]
  br label %do.body

do.body:                                          ; preds = %do.body, %for.body
  %blkCnt.0 = phi i32 [ %conv5, %for.body ], [ %sub8, %do.body ]
  %.pn = phi { <8 x i16>, i32 } [ %2, %for.body ], [ %13, %do.body ]
  %pchTargetLine.0 = phi ptr [ %pchTarget.addr.030, %for.body ], [ %add.ptr, %do.body ]
  %vStride4Offs.0 = extractvalue { <8 x i16>, i32 } %.pn, 0
  %incr.0 = extractvalue { <8 x i16>, i32 } %.pn, 1
  %3 = tail call <8 x i1> @llvm.arm.mve.vctp16(i32 %blkCnt.0)
  %4 = tail call <8 x i16> @llvm.arm.mve.vldr.gather.offset.predicated.v8i16.p0.v8i16.v8i1(ptr %pwLineMask, <8 x i16> %vStride4Offs.0, i32 8, i32 0, i32 1, <8 x i1> %3)
  %5 = mul <8 x i16> %4, %.splat
  %shr = lshr <8 x i16> %5, <i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8>
  %6 = icmp eq <8 x i16> %shr, <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %7 = sub nuw nsw <8 x i16> <i16 256, i16 256, i16 256, i16 256, i16 256, i16 256, i16 256, i16 256>, %shr
  %sub = select <8 x i1> %6, <8 x i16> zeroinitializer, <8 x i16> %7
  %8 = tail call <8 x i8> @llvm.masked.load.v8i8.p0(ptr %pchTargetLine.0, i32 1, <8 x i1> %3, <8 x i8> zeroinitializer)
  %9 = zext <8 x i8> %8 to <8 x i16>
  %sub.i = sub nsw <8 x i16> <i16 256, i16 256, i16 256, i16 256, i16 256, i16 256, i16 256, i16 256>, %sub
  %10 = mul <8 x i16> %sub.i, %.splat.i
  %11 = mul <8 x i16> %sub, %9
  %add.i = add <8 x i16> %10, %11
  %shr.i = lshr <8 x i16> %add.i, <i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8>
  %12 = trunc nuw <8 x i16> %shr.i to <8 x i8>
  tail call void @llvm.masked.store.v8i8.p0(<8 x i8> %12, ptr %pchTargetLine.0, i32 1, <8 x i1> %3)
  %13 = tail call { <8 x i16>, i32 } @llvm.arm.mve.vidup.v8i16(i32 %incr.0, i32 4)
  %add.ptr = getelementptr inbounds i8, ptr %pchTargetLine.0, i32 8
  %sub8 = add nsw i32 %blkCnt.0, -8
  %cmp9 = icmp sgt i32 %blkCnt.0, 8
  br i1 %cmp9, label %do.body, label %do.end

do.end:                                           ; preds = %do.body
  %add.ptr12 = getelementptr inbounds i8, ptr %pchTarget.addr.030, i32 %conv11
  %inc = add nuw nsw i16 %y.029, 1
  %cmp = icmp slt i16 %inc, %0
  br i1 %cmp, label %for.body, label %for.cond.cleanup
}

; This loop has an else predicate on the vqshl, which is not very realistic but
; prevents us from converting to a vptblock without being able to remove it.
define i32 @else(ptr %s1, ptr %s2, i32 %x, ptr %d, i32 %n) {
; CHECK-LABEL: else:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    ldr r2, [sp, #8]
; CHECK-NEXT:    cmp r2, #4
; CHECK-NEXT:    mov r3, r2
; CHECK-NEXT:    it ge
; CHECK-NEXT:    movge r3, #4
; CHECK-NEXT:    subs r3, r2, r3
; CHECK-NEXT:    add.w r12, r3, #3
; CHECK-NEXT:    movs r3, #1
; CHECK-NEXT:    add.w r12, r3, r12, lsr #2
; CHECK-NEXT:    movs r3, #98
; CHECK-NEXT:    dls lr, r12
; CHECK-NEXT:  .LBB1_1: @ %do.body
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    vctp.32 r2
; CHECK-NEXT:    subs r2, #4
; CHECK-NEXT:    vpstt
; CHECK-NEXT:    vldrwt.u32 q1, [r1], #16
; CHECK-NEXT:    vldrwt.u32 q0, [r0]
; CHECK-NEXT:    vmov q2, q1
; CHECK-NEXT:    vpstet
; CHECK-NEXT:    vqdmlsdht.s32 q2, q1, q0
; CHECK-NEXT:    vqshle.u32 q2, r3
; CHECK-NEXT:    vstrwt.32 q2, [r0], #16
; CHECK-NEXT:    le lr, .LBB1_1
; CHECK-NEXT:  @ %bb.2: @ %do.end
; CHECK-NEXT:    movs r0, #0
; CHECK-NEXT:    pop {r7, pc}
entry:
  br label %do.body

do.body:                                          ; preds = %do.body, %entry
  %n.addr.0 = phi i32 [ %n, %entry ], [ %sub, %do.body ]
  %s2.addr.0 = phi ptr [ %s2, %entry ], [ %add.ptr1, %do.body ]
  %s1.addr.0 = phi ptr [ %s1, %entry ], [ %add.ptr, %do.body ]
  %0 = tail call <4 x i1> @llvm.arm.mve.vctp32(i32 %n.addr.0)
  %1 = tail call <4 x i32> @llvm.masked.load.v4i32.p0(ptr %s1.addr.0, i32 4, <4 x i1> %0, <4 x i32> zeroinitializer)
  %2 = tail call <4 x i32> @llvm.masked.load.v4i32.p0(ptr %s2.addr.0, i32 4, <4 x i1> %0, <4 x i32> zeroinitializer)
  %3 = tail call <4 x i32> @llvm.arm.mve.vqdmlad.predicated.v4i32.v4i1(<4 x i32> %2, <4 x i32> %2, <4 x i32> %1, i32 0, i32 0, i32 1, <4 x i1> %0)
  %4 = xor <4 x i1> %0, <i1 true, i1 true, i1 true, i1 true>
  %5 = tail call <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32> %3, i32 98, i32 1, i32 0, i32 1, <4 x i1> %4)
  tail call void @llvm.masked.store.v4i32.p0(<4 x i32> %5, ptr %s1.addr.0, i32 4, <4 x i1> %0)
  %add.ptr = getelementptr inbounds i8, ptr %s1.addr.0, i32 16
  %add.ptr1 = getelementptr inbounds i8, ptr %s2.addr.0, i32 16
  %sub = add nsw i32 %n.addr.0, -4
  %cmp = icmp sgt i32 %n.addr.0, 4
  br i1 %cmp, label %do.body, label %do.end

do.end:                                           ; preds = %do.body
  ret i32 0
}
