; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686 -mattr=cmov | FileCheck %s --check-prefixes=X86
; RUN: llc < %s -mtriple=x86_64-linux | FileCheck %s --check-prefixes=X64

;
; trunc(nabs(sub(zext(a),zext(b)))) -> nabds(a,b)
;

define i8 @abd_ext_i8(i8 %a, i8 %b) nounwind {
; X86-LABEL: abd_ext_i8:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    subl %eax, %edx
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    cmovbl %edx, %eax
; X86-NEXT:    negb %al
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: abd_ext_i8:
; X64:       # %bb.0:
; X64-NEXT:    movzbl %sil, %eax
; X64-NEXT:    movzbl %dil, %ecx
; X64-NEXT:    movl %ecx, %edx
; X64-NEXT:    subl %eax, %edx
; X64-NEXT:    subl %ecx, %eax
; X64-NEXT:    cmovbl %edx, %eax
; X64-NEXT:    negb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %aext = zext i8 %a to i64
  %bext = zext i8 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i8
  ret i8 %trunc
}

define i8 @abd_ext_i8_i16(i8 %a, i16 %b) nounwind {
; X86-LABEL: abd_ext_i8_i16:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    subl %eax, %edx
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    cmovbl %edx, %eax
; X86-NEXT:    negb %al
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: abd_ext_i8_i16:
; X64:       # %bb.0:
; X64-NEXT:    movzbl %dil, %ecx
; X64-NEXT:    subl %esi, %edi
; X64-NEXT:    movzwl %si, %eax
; X64-NEXT:    subl %ecx, %eax
; X64-NEXT:    cmovbl %edi, %eax
; X64-NEXT:    negb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %aext = zext i8 %a to i64
  %bext = zext i16 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i8
  ret i8 %trunc
}

define i8 @abd_ext_i8_undef(i8 %a, i8 %b) nounwind {
; X86-LABEL: abd_ext_i8_undef:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    subl %eax, %edx
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    cmovbl %edx, %eax
; X86-NEXT:    negb %al
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: abd_ext_i8_undef:
; X64:       # %bb.0:
; X64-NEXT:    movzbl %sil, %eax
; X64-NEXT:    movzbl %dil, %ecx
; X64-NEXT:    movl %ecx, %edx
; X64-NEXT:    subl %eax, %edx
; X64-NEXT:    subl %ecx, %eax
; X64-NEXT:    cmovbl %edx, %eax
; X64-NEXT:    negb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %aext = zext i8 %a to i64
  %bext = zext i8 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 true)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i8
  ret i8 %trunc
}

define i16 @abd_ext_i16(i16 %a, i16 %b) nounwind {
; X86-LABEL: abd_ext_i16:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    subl %eax, %edx
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    cmovael %edx, %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: abd_ext_i16:
; X64:       # %bb.0:
; X64-NEXT:    movzwl %di, %ecx
; X64-NEXT:    subl %esi, %edi
; X64-NEXT:    movzwl %si, %eax
; X64-NEXT:    subl %ecx, %eax
; X64-NEXT:    cmovbl %edi, %eax
; X64-NEXT:    negl %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %aext = zext i16 %a to i64
  %bext = zext i16 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i16
  ret i16 %trunc
}

define i16 @abd_ext_i16_i32(i16 %a, i32 %b) nounwind {
; X86-LABEL: abd_ext_i16_i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    subl %eax, %edx
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    cmovael %edx, %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: abd_ext_i16_i32:
; X64:       # %bb.0:
; X64-NEXT:    movzwl %di, %ecx
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    subl %esi, %eax
; X64-NEXT:    subl %ecx, %esi
; X64-NEXT:    cmovael %esi, %eax
; X64-NEXT:    negl %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %aext = zext i16 %a to i64
  %bext = zext i32 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i16
  ret i16 %trunc
}

define i16 @abd_ext_i16_undef(i16 %a, i16 %b) nounwind {
; X86-LABEL: abd_ext_i16_undef:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    subl %eax, %edx
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    cmovael %edx, %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: abd_ext_i16_undef:
; X64:       # %bb.0:
; X64-NEXT:    movzwl %di, %ecx
; X64-NEXT:    subl %esi, %edi
; X64-NEXT:    movzwl %si, %eax
; X64-NEXT:    subl %ecx, %eax
; X64-NEXT:    cmovbl %edi, %eax
; X64-NEXT:    negl %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %aext = zext i16 %a to i64
  %bext = zext i16 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 true)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i16
  ret i16 %trunc
}

define i32 @abd_ext_i32(i32 %a, i32 %b) nounwind {
; X86-LABEL: abd_ext_i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    subl %eax, %edx
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    cmovael %edx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: abd_ext_i32:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    subl %esi, %eax
; X64-NEXT:    subl %edi, %esi
; X64-NEXT:    cmovbl %esi, %eax
; X64-NEXT:    retq
  %aext = zext i32 %a to i64
  %bext = zext i32 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i32
  ret i32 %trunc
}

define i32 @abd_ext_i32_i16(i32 %a, i16 %b) nounwind {
; X86-LABEL: abd_ext_i32_i16:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    subl %eax, %edx
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    cmovael %edx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: abd_ext_i32_i16:
; X64:       # %bb.0:
; X64-NEXT:    movzwl %si, %eax
; X64-NEXT:    movl %edi, %ecx
; X64-NEXT:    subl %eax, %ecx
; X64-NEXT:    subl %edi, %eax
; X64-NEXT:    cmovael %ecx, %eax
; X64-NEXT:    retq
  %aext = zext i32 %a to i64
  %bext = zext i16 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i32
  ret i32 %trunc
}

define i32 @abd_ext_i32_undef(i32 %a, i32 %b) nounwind {
; X86-LABEL: abd_ext_i32_undef:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    subl %eax, %edx
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    cmovael %edx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: abd_ext_i32_undef:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    subl %esi, %eax
; X64-NEXT:    subl %edi, %esi
; X64-NEXT:    cmovbl %esi, %eax
; X64-NEXT:    retq
  %aext = zext i32 %a to i64
  %bext = zext i32 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 true)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i32
  ret i32 %trunc
}

define i64 @abd_ext_i64(i64 %a, i64 %b) nounwind {
; X86-LABEL: abd_ext_i64:
; X86:       # %bb.0:
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    subl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sbbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl $0, %esi
; X86-NEXT:    sbbl %esi, %esi
; X86-NEXT:    xorl %esi, %ecx
; X86-NEXT:    xorl %esi, %eax
; X86-NEXT:    subl %esi, %eax
; X86-NEXT:    sbbl %esi, %ecx
; X86-NEXT:    negl %eax
; X86-NEXT:    sbbl %ecx, %edx
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
;
; X64-LABEL: abd_ext_i64:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    subq %rsi, %rax
; X64-NEXT:    subq %rdi, %rsi
; X64-NEXT:    cmovbq %rsi, %rax
; X64-NEXT:    retq
  %aext = zext i64 %a to i128
  %bext = zext i64 %b to i128
  %sub = sub i128 %aext, %bext
  %abs = call i128 @llvm.abs.i128(i128 %sub, i1 false)
  %nabs = sub i128 0, %abs
  %trunc = trunc i128 %nabs to i64
  ret i64 %trunc
}

define i64 @abd_ext_i64_undef(i64 %a, i64 %b) nounwind {
; X86-LABEL: abd_ext_i64_undef:
; X86:       # %bb.0:
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    subl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sbbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl $0, %esi
; X86-NEXT:    sbbl %esi, %esi
; X86-NEXT:    xorl %esi, %ecx
; X86-NEXT:    xorl %esi, %eax
; X86-NEXT:    subl %esi, %eax
; X86-NEXT:    sbbl %esi, %ecx
; X86-NEXT:    negl %eax
; X86-NEXT:    sbbl %ecx, %edx
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
;
; X64-LABEL: abd_ext_i64_undef:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    subq %rsi, %rax
; X64-NEXT:    subq %rdi, %rsi
; X64-NEXT:    cmovbq %rsi, %rax
; X64-NEXT:    retq
  %aext = zext i64 %a to i128
  %bext = zext i64 %b to i128
  %sub = sub i128 %aext, %bext
  %abs = call i128 @llvm.abs.i128(i128 %sub, i1 true)
  %nabs = sub i128 0, %abs
  %trunc = trunc i128 %nabs to i64
  ret i64 %trunc
}

define i128 @abd_ext_i128(i128 %a, i128 %b) nounwind {
; X86-LABEL: abd_ext_i128:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    andl $-16, %esp
; X86-NEXT:    subl $16, %esp
; X86-NEXT:    movl 32(%ebp), %esi
; X86-NEXT:    movl 36(%ebp), %eax
; X86-NEXT:    movl 24(%ebp), %ecx
; X86-NEXT:    movl 28(%ebp), %edi
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    subl 40(%ebp), %ecx
; X86-NEXT:    sbbl 44(%ebp), %edi
; X86-NEXT:    sbbl 48(%ebp), %esi
; X86-NEXT:    sbbl 52(%ebp), %eax
; X86-NEXT:    movl $0, %ebx
; X86-NEXT:    sbbl %ebx, %ebx
; X86-NEXT:    xorl %ebx, %eax
; X86-NEXT:    xorl %ebx, %esi
; X86-NEXT:    xorl %ebx, %edi
; X86-NEXT:    xorl %ebx, %ecx
; X86-NEXT:    subl %ebx, %ecx
; X86-NEXT:    sbbl %ebx, %edi
; X86-NEXT:    sbbl %ebx, %esi
; X86-NEXT:    sbbl %ebx, %eax
; X86-NEXT:    negl %ecx
; X86-NEXT:    movl $0, %ebx
; X86-NEXT:    sbbl %edi, %ebx
; X86-NEXT:    movl $0, %edi
; X86-NEXT:    sbbl %esi, %edi
; X86-NEXT:    sbbl %eax, %edx
; X86-NEXT:    movl 8(%ebp), %eax
; X86-NEXT:    movl %ecx, (%eax)
; X86-NEXT:    movl %ebx, 4(%eax)
; X86-NEXT:    movl %edi, 8(%eax)
; X86-NEXT:    movl %edx, 12(%eax)
; X86-NEXT:    leal -12(%ebp), %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; X64-LABEL: abd_ext_i128:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    xorl %edi, %edi
; X64-NEXT:    subq %rdx, %rax
; X64-NEXT:    sbbq %rcx, %rsi
; X64-NEXT:    movl $0, %ecx
; X64-NEXT:    sbbq %rcx, %rcx
; X64-NEXT:    xorq %rcx, %rsi
; X64-NEXT:    xorq %rcx, %rax
; X64-NEXT:    subq %rcx, %rax
; X64-NEXT:    sbbq %rcx, %rsi
; X64-NEXT:    negq %rax
; X64-NEXT:    sbbq %rsi, %rdi
; X64-NEXT:    movq %rdi, %rdx
; X64-NEXT:    retq
  %aext = zext i128 %a to i256
  %bext = zext i128 %b to i256
  %sub = sub i256 %aext, %bext
  %abs = call i256 @llvm.abs.i256(i256 %sub, i1 false)
  %nabs = sub i256 0, %abs
  %trunc = trunc i256 %nabs to i128
  ret i128 %trunc
}

define i128 @abd_ext_i128_undef(i128 %a, i128 %b) nounwind {
; X86-LABEL: abd_ext_i128_undef:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    andl $-16, %esp
; X86-NEXT:    subl $16, %esp
; X86-NEXT:    movl 32(%ebp), %esi
; X86-NEXT:    movl 36(%ebp), %eax
; X86-NEXT:    movl 24(%ebp), %ecx
; X86-NEXT:    movl 28(%ebp), %edi
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    subl 40(%ebp), %ecx
; X86-NEXT:    sbbl 44(%ebp), %edi
; X86-NEXT:    sbbl 48(%ebp), %esi
; X86-NEXT:    sbbl 52(%ebp), %eax
; X86-NEXT:    movl $0, %ebx
; X86-NEXT:    sbbl %ebx, %ebx
; X86-NEXT:    xorl %ebx, %eax
; X86-NEXT:    xorl %ebx, %esi
; X86-NEXT:    xorl %ebx, %edi
; X86-NEXT:    xorl %ebx, %ecx
; X86-NEXT:    subl %ebx, %ecx
; X86-NEXT:    sbbl %ebx, %edi
; X86-NEXT:    sbbl %ebx, %esi
; X86-NEXT:    sbbl %ebx, %eax
; X86-NEXT:    negl %ecx
; X86-NEXT:    movl $0, %ebx
; X86-NEXT:    sbbl %edi, %ebx
; X86-NEXT:    movl $0, %edi
; X86-NEXT:    sbbl %esi, %edi
; X86-NEXT:    sbbl %eax, %edx
; X86-NEXT:    movl 8(%ebp), %eax
; X86-NEXT:    movl %ecx, (%eax)
; X86-NEXT:    movl %ebx, 4(%eax)
; X86-NEXT:    movl %edi, 8(%eax)
; X86-NEXT:    movl %edx, 12(%eax)
; X86-NEXT:    leal -12(%ebp), %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; X64-LABEL: abd_ext_i128_undef:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    xorl %edi, %edi
; X64-NEXT:    subq %rdx, %rax
; X64-NEXT:    sbbq %rcx, %rsi
; X64-NEXT:    movl $0, %ecx
; X64-NEXT:    sbbq %rcx, %rcx
; X64-NEXT:    xorq %rcx, %rsi
; X64-NEXT:    xorq %rcx, %rax
; X64-NEXT:    subq %rcx, %rax
; X64-NEXT:    sbbq %rcx, %rsi
; X64-NEXT:    negq %rax
; X64-NEXT:    sbbq %rsi, %rdi
; X64-NEXT:    movq %rdi, %rdx
; X64-NEXT:    retq
  %aext = zext i128 %a to i256
  %bext = zext i128 %b to i256
  %sub = sub i256 %aext, %bext
  %abs = call i256 @llvm.abs.i256(i256 %sub, i1 true)
  %nabs = sub i256 0, %abs
  %trunc = trunc i256 %nabs to i128
  ret i128 %trunc
}

;
; sub(umin(a,b),umax(a,b)) -> nabds(a,b)
;

define i8 @abd_minmax_i8(i8 %a, i8 %b) nounwind {
; X86-LABEL: abd_minmax_i8:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    subl %eax, %edx
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    cmovbl %edx, %eax
; X86-NEXT:    negb %al
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: abd_minmax_i8:
; X64:       # %bb.0:
; X64-NEXT:    movzbl %sil, %eax
; X64-NEXT:    movzbl %dil, %ecx
; X64-NEXT:    movl %ecx, %edx
; X64-NEXT:    subl %eax, %edx
; X64-NEXT:    subl %ecx, %eax
; X64-NEXT:    cmovbl %edx, %eax
; X64-NEXT:    negb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %min = call i8 @llvm.umin.i8(i8 %a, i8 %b)
  %max = call i8 @llvm.umax.i8(i8 %a, i8 %b)
  %sub = sub i8 %min, %max
  ret i8 %sub
}

define i16 @abd_minmax_i16(i16 %a, i16 %b) nounwind {
; X86-LABEL: abd_minmax_i16:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    subl %eax, %edx
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    cmovael %edx, %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: abd_minmax_i16:
; X64:       # %bb.0:
; X64-NEXT:    movzwl %di, %ecx
; X64-NEXT:    subl %esi, %edi
; X64-NEXT:    movzwl %si, %eax
; X64-NEXT:    subl %ecx, %eax
; X64-NEXT:    cmovbl %edi, %eax
; X64-NEXT:    negl %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %min = call i16 @llvm.umin.i16(i16 %a, i16 %b)
  %max = call i16 @llvm.umax.i16(i16 %a, i16 %b)
  %sub = sub i16 %min, %max
  ret i16 %sub
}

define i32 @abd_minmax_i32(i32 %a, i32 %b) nounwind {
; X86-LABEL: abd_minmax_i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    subl %eax, %edx
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    cmovael %edx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: abd_minmax_i32:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    subl %esi, %eax
; X64-NEXT:    subl %edi, %esi
; X64-NEXT:    cmovbl %esi, %eax
; X64-NEXT:    retq
  %min = call i32 @llvm.umin.i32(i32 %a, i32 %b)
  %max = call i32 @llvm.umax.i32(i32 %a, i32 %b)
  %sub = sub i32 %min, %max
  ret i32 %sub
}

define i64 @abd_minmax_i64(i64 %a, i64 %b) nounwind {
; X86-LABEL: abd_minmax_i64:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    cmpl %esi, %edi
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    sbbl %ecx, %eax
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    cmovbl %ebx, %edx
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    cmovbl %edi, %eax
; X86-NEXT:    cmpl %edi, %esi
; X86-NEXT:    movl %ecx, %ebp
; X86-NEXT:    sbbl %ebx, %ebp
; X86-NEXT:    cmovbl %ebx, %ecx
; X86-NEXT:    cmovbl %edi, %esi
; X86-NEXT:    subl %esi, %eax
; X86-NEXT:    sbbl %ecx, %edx
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; X64-LABEL: abd_minmax_i64:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    subq %rsi, %rax
; X64-NEXT:    subq %rdi, %rsi
; X64-NEXT:    cmovbq %rsi, %rax
; X64-NEXT:    retq
  %min = call i64 @llvm.umin.i64(i64 %a, i64 %b)
  %max = call i64 @llvm.umax.i64(i64 %a, i64 %b)
  %sub = sub i64 %min, %max
  ret i64 %sub
}

define i128 @abd_minmax_i128(i128 %a, i128 %b) nounwind {
; X86-LABEL: abd_minmax_i128:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    andl $-16, %esp
; X86-NEXT:    subl $16, %esp
; X86-NEXT:    movl 40(%ebp), %esi
; X86-NEXT:    movl 24(%ebp), %edi
; X86-NEXT:    movl 28(%ebp), %eax
; X86-NEXT:    cmpl %esi, %edi
; X86-NEXT:    sbbl 44(%ebp), %eax
; X86-NEXT:    movl 48(%ebp), %edx
; X86-NEXT:    movl 32(%ebp), %eax
; X86-NEXT:    sbbl %edx, %eax
; X86-NEXT:    movl 52(%ebp), %ebx
; X86-NEXT:    movl 36(%ebp), %ecx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    sbbl %ebx, %eax
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    cmovbl %ecx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl %edx, %eax
; X86-NEXT:    cmovbl 32(%ebp), %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl 44(%ebp), %eax
; X86-NEXT:    cmovbl 28(%ebp), %eax
; X86-NEXT:    movl %esi, %ecx
; X86-NEXT:    cmovbl %edi, %ecx
; X86-NEXT:    cmpl %edi, %esi
; X86-NEXT:    movl 44(%ebp), %edi
; X86-NEXT:    sbbl 28(%ebp), %edi
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    sbbl 32(%ebp), %edi
; X86-NEXT:    movl %ebx, %edi
; X86-NEXT:    sbbl 36(%ebp), %edi
; X86-NEXT:    cmovbl 36(%ebp), %ebx
; X86-NEXT:    cmovbl 32(%ebp), %edx
; X86-NEXT:    movl 44(%ebp), %edi
; X86-NEXT:    cmovbl 28(%ebp), %edi
; X86-NEXT:    cmovbl 24(%ebp), %esi
; X86-NEXT:    subl %esi, %ecx
; X86-NEXT:    sbbl %edi, %eax
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X86-NEXT:    sbbl %edx, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X86-NEXT:    sbbl %ebx, %esi
; X86-NEXT:    movl 8(%ebp), %edx
; X86-NEXT:    movl %ecx, (%edx)
; X86-NEXT:    movl %eax, 4(%edx)
; X86-NEXT:    movl %edi, 8(%edx)
; X86-NEXT:    movl %esi, 12(%edx)
; X86-NEXT:    movl %edx, %eax
; X86-NEXT:    leal -12(%ebp), %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; X64-LABEL: abd_minmax_i128:
; X64:       # %bb.0:
; X64-NEXT:    cmpq %rdx, %rdi
; X64-NEXT:    movq %rsi, %rax
; X64-NEXT:    sbbq %rcx, %rax
; X64-NEXT:    movq %rcx, %r8
; X64-NEXT:    cmovbq %rsi, %r8
; X64-NEXT:    movq %rdx, %rax
; X64-NEXT:    cmovbq %rdi, %rax
; X64-NEXT:    cmpq %rdi, %rdx
; X64-NEXT:    movq %rcx, %r9
; X64-NEXT:    sbbq %rsi, %r9
; X64-NEXT:    cmovbq %rsi, %rcx
; X64-NEXT:    cmovbq %rdi, %rdx
; X64-NEXT:    subq %rdx, %rax
; X64-NEXT:    sbbq %rcx, %r8
; X64-NEXT:    movq %r8, %rdx
; X64-NEXT:    retq
  %min = call i128 @llvm.umin.i128(i128 %a, i128 %b)
  %max = call i128 @llvm.umax.i128(i128 %a, i128 %b)
  %sub = sub i128 %min, %max
  ret i128 %sub
}

;
; select(icmp(a,b),sub(a,b),sub(b,a)) -> nabds(a,b)
;

define i8 @abd_cmp_i8(i8 %a, i8 %b) nounwind {
; X86-LABEL: abd_cmp_i8:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    subl %eax, %edx
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    cmovbl %edx, %eax
; X86-NEXT:    negb %al
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: abd_cmp_i8:
; X64:       # %bb.0:
; X64-NEXT:    movzbl %sil, %eax
; X64-NEXT:    movzbl %dil, %ecx
; X64-NEXT:    movl %ecx, %edx
; X64-NEXT:    subl %eax, %edx
; X64-NEXT:    subl %ecx, %eax
; X64-NEXT:    cmovbl %edx, %eax
; X64-NEXT:    negb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %cmp = icmp ule i8 %a, %b
  %ab = sub i8 %a, %b
  %ba = sub i8 %b, %a
  %sel = select i1 %cmp, i8 %ab, i8 %ba
  ret i8 %sel
}

define i16 @abd_cmp_i16(i16 %a, i16 %b) nounwind {
; X86-LABEL: abd_cmp_i16:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    subl %eax, %edx
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    cmovael %edx, %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: abd_cmp_i16:
; X64:       # %bb.0:
; X64-NEXT:    movzwl %di, %ecx
; X64-NEXT:    subl %esi, %edi
; X64-NEXT:    movzwl %si, %eax
; X64-NEXT:    subl %ecx, %eax
; X64-NEXT:    cmovbl %edi, %eax
; X64-NEXT:    negl %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %cmp = icmp ult i16 %a, %b
  %ab = sub i16 %a, %b
  %ba = sub i16 %b, %a
  %sel = select i1 %cmp, i16 %ab, i16 %ba
  ret i16 %sel
}

define i32 @abd_cmp_i32(i32 %a, i32 %b) nounwind {
; X86-LABEL: abd_cmp_i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    subl %eax, %edx
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    cmovael %edx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: abd_cmp_i32:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    subl %esi, %eax
; X64-NEXT:    subl %edi, %esi
; X64-NEXT:    cmovbl %esi, %eax
; X64-NEXT:    retq
  %cmp = icmp uge i32 %a, %b
  %ab = sub i32 %a, %b
  %ba = sub i32 %b, %a
  %sel = select i1 %cmp, i32 %ba, i32 %ab
  ret i32 %sel
}

define i64 @abd_cmp_i64(i64 %a, i64 %b) nounwind {
; X86-LABEL: abd_cmp_i64:
; X86:       # %bb.0:
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    subl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sbbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl $0, %esi
; X86-NEXT:    sbbl %esi, %esi
; X86-NEXT:    xorl %esi, %ecx
; X86-NEXT:    xorl %esi, %eax
; X86-NEXT:    subl %esi, %eax
; X86-NEXT:    sbbl %esi, %ecx
; X86-NEXT:    negl %eax
; X86-NEXT:    sbbl %ecx, %edx
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
;
; X64-LABEL: abd_cmp_i64:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    subq %rsi, %rax
; X64-NEXT:    subq %rdi, %rsi
; X64-NEXT:    cmovbq %rsi, %rax
; X64-NEXT:    retq
  %cmp = icmp ult i64 %a, %b
  %ab = sub i64 %a, %b
  %ba = sub i64 %b, %a
  %sel = select i1 %cmp, i64 %ab, i64 %ba
  ret i64 %sel
}

define i128 @abd_cmp_i128(i128 %a, i128 %b) nounwind {
; X86-LABEL: abd_cmp_i128:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    andl $-16, %esp
; X86-NEXT:    subl $16, %esp
; X86-NEXT:    movl 32(%ebp), %esi
; X86-NEXT:    movl 36(%ebp), %eax
; X86-NEXT:    movl 24(%ebp), %ecx
; X86-NEXT:    movl 28(%ebp), %edi
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    subl 40(%ebp), %ecx
; X86-NEXT:    sbbl 44(%ebp), %edi
; X86-NEXT:    sbbl 48(%ebp), %esi
; X86-NEXT:    sbbl 52(%ebp), %eax
; X86-NEXT:    movl $0, %ebx
; X86-NEXT:    sbbl %ebx, %ebx
; X86-NEXT:    xorl %ebx, %eax
; X86-NEXT:    xorl %ebx, %esi
; X86-NEXT:    xorl %ebx, %edi
; X86-NEXT:    xorl %ebx, %ecx
; X86-NEXT:    subl %ebx, %ecx
; X86-NEXT:    sbbl %ebx, %edi
; X86-NEXT:    sbbl %ebx, %esi
; X86-NEXT:    sbbl %ebx, %eax
; X86-NEXT:    negl %ecx
; X86-NEXT:    movl $0, %ebx
; X86-NEXT:    sbbl %edi, %ebx
; X86-NEXT:    movl $0, %edi
; X86-NEXT:    sbbl %esi, %edi
; X86-NEXT:    sbbl %eax, %edx
; X86-NEXT:    movl 8(%ebp), %eax
; X86-NEXT:    movl %ecx, (%eax)
; X86-NEXT:    movl %ebx, 4(%eax)
; X86-NEXT:    movl %edi, 8(%eax)
; X86-NEXT:    movl %edx, 12(%eax)
; X86-NEXT:    leal -12(%ebp), %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; X64-LABEL: abd_cmp_i128:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    xorl %edi, %edi
; X64-NEXT:    subq %rdx, %rax
; X64-NEXT:    sbbq %rcx, %rsi
; X64-NEXT:    movl $0, %ecx
; X64-NEXT:    sbbq %rcx, %rcx
; X64-NEXT:    xorq %rcx, %rsi
; X64-NEXT:    xorq %rcx, %rax
; X64-NEXT:    subq %rcx, %rax
; X64-NEXT:    sbbq %rcx, %rsi
; X64-NEXT:    negq %rax
; X64-NEXT:    sbbq %rsi, %rdi
; X64-NEXT:    movq %rdi, %rdx
; X64-NEXT:    retq
  %cmp = icmp ult i128 %a, %b
  %ab = sub i128 %a, %b
  %ba = sub i128 %b, %a
  %sel = select i1 %cmp, i128 %ab, i128 %ba
  ret i128 %sel
}

declare i8 @llvm.abs.i8(i8, i1)
declare i16 @llvm.abs.i16(i16, i1)
declare i32 @llvm.abs.i32(i32, i1)
declare i64 @llvm.abs.i64(i64, i1)
declare i128 @llvm.abs.i128(i128, i1)

declare i8 @llvm.umax.i8(i8, i8)
declare i16 @llvm.umax.i16(i16, i16)
declare i32 @llvm.umax.i32(i32, i32)
declare i64 @llvm.umax.i64(i64, i64)

declare i8 @llvm.umin.i8(i8, i8)
declare i16 @llvm.umin.i16(i16, i16)
declare i32 @llvm.umin.i32(i32, i32)
declare i64 @llvm.umin.i64(i64, i64)
