## API Report File for "@lumino/coreutils"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

// @public
export interface IPlugin<T, U> {
    activate: (app: T, ...args: any[]) => U | Promise<U>;
    autoStart?: boolean | 'defer';
    deactivate?: ((app: T, ...args: any[]) => void | Promise<void>) | null;
    description?: string;
    id: string;
    optional?: Token<any>[];
    provides?: Token<U> | null;
    requires?: Token<any>[];
}

// @public
export interface JSONArray extends Array<JSONValue> {
}

// @public
export namespace JSONExt {
    const emptyObject: ReadonlyJSONObject;
    const emptyArray: ReadonlyJSONArray;
    export function deepCopy<T extends ReadonlyPartialJSONValue>(value: T): T;
    export function deepEqual(first: ReadonlyPartialJSONValue, second: ReadonlyPartialJSONValue): boolean;
    export function isArray(value: JSONValue): value is JSONArray;
    // (undocumented)
    export function isArray(value: ReadonlyJSONValue): value is ReadonlyJSONArray;
    // (undocumented)
    export function isArray(value: PartialJSONValue): value is PartialJSONArray;
    // (undocumented)
    export function isArray(value: ReadonlyPartialJSONValue): value is ReadonlyPartialJSONArray;
    export function isObject(value: JSONValue): value is JSONObject;
    // (undocumented)
    export function isObject(value: ReadonlyJSONValue): value is ReadonlyJSONObject;
    // (undocumented)
    export function isObject(value: PartialJSONValue): value is PartialJSONObject;
    // (undocumented)
    export function isObject(value: ReadonlyPartialJSONValue): value is ReadonlyPartialJSONObject;
    export function isPrimitive(value: ReadonlyPartialJSONValue): value is JSONPrimitive;
}

// @public
export interface JSONObject {
    // (undocumented)
    [key: string]: JSONValue;
}

// @public
export type JSONPrimitive = boolean | number | string | null;

// @public
export type JSONValue = JSONPrimitive | JSONObject | JSONArray;

// @public
export class MimeData {
    clear(): void;
    clearData(mime: string): void;
    getData(mime: string): any | undefined;
    hasData(mime: string): boolean;
    setData(mime: string, data: unknown): void;
    types(): string[];
}

// @public
export interface PartialJSONArray extends Array<PartialJSONValue> {
}

// @public
export interface PartialJSONObject {
    // (undocumented)
    [key: string]: PartialJSONValue | undefined;
}

// @public
export type PartialJSONValue = JSONPrimitive | PartialJSONObject | PartialJSONArray;

// @public
export class PluginRegistry<T = any> {
    constructor(options?: PluginRegistry.IOptions);
    activatePlugin(id: string): Promise<void>;
    activatePlugins(kind: 'startUp' | 'defer', options?: PluginRegistry.IStartOptions): Promise<void>;
    get application(): T;
    set application(v: T);
    deactivatePlugin(id: string): Promise<string[]>;
    get deferredPlugins(): string[];
    deregisterPlugin(id: string, force?: boolean): void;
    getPluginDescription(id: string): string;
    hasPlugin(id: string): boolean;
    isPluginActivated(id: string): boolean;
    listPlugins(): string[];
    registerPlugin(plugin: IPlugin<T, any>): void;
    registerPlugins(plugins: IPlugin<T, any>[]): void;
    resolveOptionalService<U>(token: Token<U>): Promise<U | null>;
    resolveRequiredService<U>(token: Token<U>): Promise<U>;
}

// @public
export namespace PluginRegistry {
    export interface IOptions {
        validatePlugin?: (plugin: IPlugin<any, any>) => boolean;
    }
    export interface IStartOptions {
        ignorePlugins?: string[];
        startPlugins?: string[];
    }
}

// @public
export class PromiseDelegate<T> {
    constructor();
    readonly promise: Promise<T>;
    reject(reason: unknown): void;
    resolve(value: T | PromiseLike<T>): void;
}

// @public
export namespace Random {
    const // Warning: (ae-forgotten-export) The symbol "fallbackRandomValues" needs to be exported by the entry point index.d.ts
    getRandomValues: typeof fallbackRandomValues;
}

// @public
export interface ReadonlyJSONArray extends ReadonlyArray<ReadonlyJSONValue> {
}

// @public
export interface ReadonlyJSONObject {
    // (undocumented)
    readonly [key: string]: ReadonlyJSONValue;
}

// @public
export type ReadonlyJSONValue = JSONPrimitive | ReadonlyJSONObject | ReadonlyJSONArray;

// @public
export interface ReadonlyPartialJSONArray extends ReadonlyArray<ReadonlyPartialJSONValue> {
}

// @public
export interface ReadonlyPartialJSONObject {
    // (undocumented)
    readonly [key: string]: ReadonlyPartialJSONValue | undefined;
}

// @public
export type ReadonlyPartialJSONValue = JSONPrimitive | ReadonlyPartialJSONObject | ReadonlyPartialJSONArray;

// @public
export class Token<T> {
    constructor(name: string, description?: string);
    readonly description?: string;
    readonly name: string;
}

// @public
export namespace UUID {
    const uuid4: () => string;
}

```
