/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleClob;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.ReplayLoggerFactory;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={Clob.class, OracleClob.class, oracle.jdbc.internal.OracleClob.class})
public abstract class NonTxnReplayableClob
extends NonTxnReplayableBase
implements Replayable {
    private static final String CLOB_FEATURE_LOGGER_NAME = "oracle.jdbc.internal.replay.NonTxnReplayableClob";
    private static Logger CLOB_REPLAY_LOGGER = null;

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="setString", args={long.class, String.class}), @Signature(name="setString", args={long.class, String.class, int.class, int.class}), @Signature(name="truncate", args={long.class})})
    protected void preForClobWrites(Method method, Object object, Object ... objectArray) {
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        CLOB_REPLAY_LOGGER.log(Level.FINER, "On clob {0}, entering preForClobWrites({1})", new Object[]{this, method.getName()});
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(method, 371, "Replay disabled because of active transaction", null);
        } else {
            CLOB_REPLAY_LOGGER.log(Level.SEVERE, "On clob {0}, failover manager not set", this);
        }
        CLOB_REPLAY_LOGGER.log(Level.FINER, "On clob {0}, exiting preForClobWrites()", this);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        if (object instanceof NonTxnReplayableBase) {
            NonTxnReplayableBase nonTxnReplayableBase = (NonTxnReplayableBase)object;
            nonTxnReplayableBase.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(method, object);
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    static {
        if (CLOB_REPLAY_LOGGER == null) {
            CLOB_REPLAY_LOGGER = ReplayLoggerFactory.getLogger(CLOB_FEATURE_LOGGER_NAME);
        }
    }
}

