/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.OutputStream;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.DataDescriptorPacket;
import oracle.net.ns.DataPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class NetOutputStream
extends OutputStream
implements SQLnetDef {
    protected DataPacket daPkt;
    protected DataDescriptorPacket ddPkt;
    protected SessionAtts sAtts;
    private byte[] tmpBuf = new byte[1];

    public NetOutputStream() {
    }

    public NetOutputStream(SessionAtts sessionAtts) {
        this.sAtts = sessionAtts;
        this.daPkt = new DataPacket(sessionAtts);
        this.ddPkt = new DataDescriptorPacket(sessionAtts);
    }

    public NetOutputStream(SessionAtts sessionAtts, int n2) {
        this.sAtts = sessionAtts;
        this.daPkt = new DataPacket(sessionAtts, n2);
        this.ddPkt = new DataDescriptorPacket(sessionAtts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeZeroCopyIO(byte[] byArray, int n2, int n3) throws IOException, NetException, BreakNetException {
        int n4;
        boolean bl = false;
        for (int i2 = n3; i2 > 0; i2 -= n4) {
            if (i2 > 1703910) {
                n4 = 1703910;
            } else {
                n4 = i2;
                bl = true;
            }
            this.ddPkt.send(n4, bl);
            OutputStream outputStream = this.sAtts.ntOutputStream;
            synchronized (outputStream) {
                this.sAtts.ntOutputStream.write(byArray, n2, n4);
            }
            n2 += n4;
        }
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.sAtts.enableJavaNetFastPath && !this.sAtts.anoActive) {
            if (this.daPkt.isBufferFull) {
                this.daPkt.send(32);
            }
            this.daPkt.putDataInBuffer((byte)n2);
        } else {
            this.tmpBuf[0] = (byte)n2;
            this.write(this.tmpBuf);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        for (int i2 = 0; n3 > i2; i2 += this.daPkt.putDataInBuffer(byArray, n2 + i2, n3 - i2)) {
            if (!this.daPkt.isBufferFull) continue;
            n4 = n3 > i2 ? 32 : 0;
            this.daPkt.send(n4);
        }
    }

    public int available() throws IOException {
        return this.daPkt.availableBytesToSend;
    }

    @Override
    public void flush() throws IOException {
        if (this.daPkt.availableBytesToSend > 0) {
            this.daPkt.send(0);
        }
    }

    @Override
    public void close() throws IOException {
        this.daPkt.send(64);
    }

    void poolEnabled(boolean bl) throws IOException, NetException, BreakNetException {
        if (bl) {
            this.daPkt.setFlags(1);
        }
    }

    void reinitialize(SessionAtts sessionAtts) throws NetException {
        this.sAtts = sessionAtts;
    }
}

