﻿using System.Collections.Generic;
using System.Text;
using Mono.Cecil;

namespace Mono.Documentation.Updater
{
    class SlashDocCSharpMemberFormatter : MsxdocSlashDocMemberFormatter
    {
        /// <summary>
        /// C# compiler uses complecated logic to generate docIds for Eii properties. Need to have special logic here.
        /// </summary>
        /// <param name="property">Value to process</param>
        /// <returns>DocId for property member wchich needs to be equal to docId generated by compiler's /doc flag </returns>
       protected override string EiiPropertyProcessing(PropertyReference property)
        {
            string name;

            PropertyDefinition propertyDef = property as PropertyDefinition;
            MethodDefinition method = null;
            if (propertyDef != null)
                method = propertyDef.GetMethod ?? propertyDef.SetMethod;
            if (method != null && !DocUtils.IsExplicitlyImplemented(method))
                name = property.Name;
            else
            {
                DocUtils.GetInfoForExplicitlyImplementedMethod(method, out var iface, out var ifaceMethod);
                AddTypeCount = false;
                name = string.Join("#", new string[]{
                    GetTypeName (iface).Replace (".", "#"),
                    DocUtils.GetMember (property.Name)
                });
                AddTypeCount = true;
            }

            return name;
        }
    }
}