﻿// Copyright (c) Microsoft Open Technologies, Inc. All rights reserved. See License.txt in the project root for license information.

namespace System.Reactive
{
    /// <summary>
    /// Represents a data stream signaling its elements by means of an event.
    /// </summary>
    /// <typeparam name="T">
    /// The type of the event data generated by the event.
    /// This type parameter is covariant. That is, you can use either the type you specified or any type that is more derived. For more information about covariance and contravariance, see Covariance and Contravariance in Generics.
    /// </typeparam>
    public interface IEventSource<
#if !NO_VARIANCE && !SILVERLIGHT4 // SL4 doesn't mark Action<T> as contravariant!
        out
#endif
        T>
    {
        /// <summary>
        /// Event signaling the next element in the data stream.
        /// </summary>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1710:IdentifiersShouldHaveCorrectSuffix", Justification = "By design.")]
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1009:DeclareEventHandlersCorrectly", Justification = "Can't do this for Action<T>.")]
        event Action<T> OnNext;
    }
}
