/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import com.workingdogs.village.Record;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.turbine.om.ObjectKey;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.db.map.TurbineMapBuilder;
import org.apache.turbine.util.db.pool.DBConnection;

public class JobEntryPeer
extends BasePeer {
    private static final TurbineMapBuilder mapBuilder = (TurbineMapBuilder)BasePeer.getMapBuilder();
    private static final String TABLE_NAME = mapBuilder.getTableJobentry();
    public static final String OID = mapBuilder.getJobentry_JobId();
    public static final String SECOND = mapBuilder.getJobentry_Second();
    public static final String MINUTE = mapBuilder.getJobentry_Minute();
    public static final String HOUR = mapBuilder.getJobentry_Hour();
    public static final String WEEKDAY = mapBuilder.getJobentry_Weekday();
    public static final String DAY_OF_MONTH = mapBuilder.getJobentry_DayOfMonth();
    public static final String TASK = mapBuilder.getJobentry_Task();
    public static final String EMAIL = mapBuilder.getJobentry_Email();
    public static final String PROPERTY = mapBuilder.getJobentry_Property();

    public static void doUpdate(Criteria criteria) throws Exception {
        Criteria selectCriteria = new Criteria(2);
        selectCriteria.put(OID, criteria.remove(OID));
        BasePeer.doUpdate(selectCriteria, criteria);
    }

    public static Vector doSelect(Criteria criteria) throws Exception {
        JobEntryPeer.addSelectColumns(criteria);
        Vector rows = BasePeer.doSelect(criteria);
        Vector<JobEntry> results = new Vector<JobEntry>();
        int i = 0;
        while (i < rows.size()) {
            Record rec = (Record)rows.elementAt(i);
            int oid = rec.getValue(1).asInt();
            int sec = rec.getValue(2).asInt();
            int min = rec.getValue(3).asInt();
            int hr = rec.getValue(4).asInt();
            int wd = rec.getValue(5).asInt();
            int d_m = rec.getValue(6).asInt();
            String task = rec.getValue(7).asString();
            String email = rec.getValue(8).asString();
            byte[] objectData = rec.getValue(9).asBytes();
            Hashtable tempHash = (Hashtable)ObjectUtils.deserialize(objectData);
            JobEntry je = new JobEntry(sec, min, hr, wd, d_m, task);
            je.setPrimaryKey(oid);
            je.setEmail(email);
            je.setProperty(tempHash);
            je.setModified(false);
            results.addElement(je);
            ++i;
        }
        return results;
    }

    public static ObjectKey doInsert(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        return BasePeer.doInsert(criteria);
    }

    public static ObjectKey doInsert(Criteria criteria, DBConnection dbCon) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        return BasePeer.doInsert(criteria, dbCon);
    }

    protected static void addSelectColumns(Criteria criteria) throws Exception {
        criteria.addSelectColumn(OID).addSelectColumn(SECOND).addSelectColumn(MINUTE).addSelectColumn(HOUR).addSelectColumn(WEEKDAY).addSelectColumn(DAY_OF_MONTH).addSelectColumn(TASK).addSelectColumn(EMAIL).addSelectColumn(PROPERTY);
    }

    public static JobEntry getJob(int oid) throws Exception {
        JobEntry je = null;
        Criteria c = new Criteria(9);
        c.add(OID, new Integer(oid));
        Vector results = JobEntryPeer.doSelect(c);
        if (results != null) {
            je = (JobEntry)results.elementAt(0);
        }
        return je;
    }
}

