#pragma once

/**
 * Project-wide configuration of how Storm interacts with the underlying system.
 */


/**
 * Allow choosing the I/O implementation on Linux-based systems.
 *
 * Storm has two I/O implementations on POSIX systems: one that is based on only the POSIX standard,
 * and one specific to Linux, based on io_uring. The former is more portable, but has the limitation
 * that it treats access to the local file system as blocking. The io_uring one solves this problem
 * as it is fully asynchronous, but it is Linux specific.
 */
#if defined(LINUX) && !defined(LINUX_NO_IO_URING)
#define LINUX_IO_URING
// Depth of the io_uring queue to use for each OS thread.
#define LINUX_IO_URING_QUEUE 16
#endif
