use core:lang;
use lang:bs;
use core:debug;
use lang:bs:macro;

// Type of params is Value[], returns Named
genAdd: generate(params) {
	if (params.count != 2)
		return null;

	if (params[0] != params[1])
		return null;

	Value t = params[0];
	if (type = t.type) {
		BSTreeFn fn(t, SStr("genAdd"), merge(params, ["a", "b"]), null);

		Scope scope = rootScope.child(type);

		FnBody body(fn, scope);
		fn.body(body);

		Actuals actual;
		actual.add(namedExpr(body, SStr("a"), Actuals()));
		actual.add(namedExpr(body, SStr("b"), Actuals()));

		body.add(namedExpr(body, SStr("+"), actual));

		return fn;
	} else {
		return null;
	}
}

// Int genAdd(Int a, Int b) {
// 	a + b;
// }


// Inside a class?
class GenClass {
	Int v;

	init(Int v) {
		init() {
			v = v;
		}
	}

	// This is quite useless, as it will only work when the parameter is an integer.
	addVal: generate(params) {
		if (params.count != 2)
			return null;

		Type me = named{GenClass};
		if (params[0].asRef(false) != Value(me))
			return null;

		Value t = params[1];
		BSTreeFn fn(t, SStr("addVal"), [thisParam(me), ValParam(t, "b")], null);

		Scope scope(me, BSLookup());

		FnBody body(fn, scope);
		fn.body(body);

		Actuals actual;
		actual.add(namedExpr(body, SStr("v"), Actuals()));
		actual.add(namedExpr(body, SStr("b"), Actuals()));

		body.add(namedExpr(body, SStr("+="), actual));

		return fn;
	}
}


Int testGenClass(Int i) {
	GenClass z(i);
	z.addVal(2);
	z.v;
}
