use core:debug;
use lang:bs:macro;

Dbg? maybe(Int v) {
	Dbg? result;
	if (v == 1) {
		result = Dbg(v);
	} else if (v == 2) {
		DerivedDbg z;
		z.set(2);
		z.b = 2;
		result = z;
	}
	result;
}

Int testMaybe(Int v) {
	Dbg? r = maybe(v);
	Int z = 0;

	if (r as DerivedDbg) {
		z = z + r.b;
	}

	if (r) {
		z = z + r.get;
	}

	if (q = r) {
		z = z + q.get;
	}

	z;
}

Int assignMaybe() {
	Dbg? r = Dbg(20);

	if (r)
		1;
	else
		0;
}

void assignError() {
	Dbg v(20);
	Dbg? r;

	// Should not work.
	v = r;
}

Str maybeToS(Int p) {
	Str? r;

	if (p == 1)
		r = "ok";

	r.toS;
}

Int maybeInheritance() {
	DerivedDbg? foo = DerivedDbg(10);
	Dbg? bar = foo;
	// Check assignment as well.
	bar = foo;

	if (bar) {
		bar.get;
	} else {
		0;
	}
}

Int testMaybeInv(Int v) {
	Dbg? r = maybe(v);

	unless (r)
		return 10;

	// Create a value to see if it works.
	DbgVal s(10);

	r.get;
}

Int testMaybeInv2(Int v) {
	Dbg? r = maybe(v);

	unless (w = r)
		return 10;

	w.get;
}

Int testPlainUnless(Int v) {
	unless (v == 10)
		return v;

	18;
}

// See if we can return Maybe<T> properly.
Int? createMaybe(Int v) {
	Int? result;
	if (v > 0)
		result = v;
	result;
}

Int testMaybeValue(Int v) {
	Int? result = createMaybe(v);

	if (result) {
		result;
	} else {
		8;
	}
}

Int testMaybeValueAny(Int v) {
	Int? result = createMaybe(v);

	if (v > 0)
		result = v;

	if (result.any) {
		1;
	} else {
		0;
	}
}

// See if we can use Maybe<T> as a parameter.
Str maybeToS(Int? val) {
	val.toS();
}

Str testMaybeValueToS(Int v) {
	Int? result = createMaybe(v);
	maybeToS(result);
}

Int testMaybeNullInit() {
	Int? val = null;
	if (val)
		val;
	else
		-1;
}

// Check the behavior of members...
class MaybeClass {
	Int? val;

	init() {
		init { val = 10; }
	}

	Int explicitSelf() {
		Int val = 2;
		// Note: Explicit a.val means that val will not be created inside the if stmt.
		if (this.val)
			return val;
		0;
	}

	Int explicitOther() {
		Int val = 2;
		MaybeClass z = this;
		// Note: Explicit a.val means that val will not be created inside the if stmt.
		if (z.val)
			return val;
		0;
	}
}

Int testExplicitSelf() {
	MaybeClass().explicitSelf();
}

Int testExplicitOther() {
	MaybeClass().explicitOther();
}

// Catch a maybe-type from C++.
Str testReceiveMaybe() {
	lang:bnf:Regex r("a?b");
	StrBuf result;
	if (x = r.match("abc"))
		result << x;
	if (x = r.match("c"))
		result << x;
	result.toS;
}


// See if maybe types are cloned properly at thread boundaries. Both for values and classes.
Int threadFn(CloneDerived? v) on Other {
	if (v)
		v.c;
	else
		-1;
}
Int threadFn(ThreadVal? v) on Other {
	if (v)
		v.v.c;
	else
		-1;
}

Int threadMaybeClass() {
	// Should give 4 + 1 (copy ctor) + 1 (deep copy)
	threadFn(CloneDerived());
}

Int threadMaybeValue() {
	// Should give 4 + 1 (copy ctor) + 1 (deep copy)
	threadFn(ThreadVal());
}
