---
myst:
  html_meta:
    keywords: LaTeX, programmation, erreurs, messages d'erreur de LaTeX,
              fichier non trouvé, \usepackage, \input, \includegraphics
---

# Que signifie l'erreur : "File ‘⟨nom⟩’ not found" ?

- **Message** : ```` File `⟨nom⟩' not found ````

LaTeX a essayé de charger le fichier `⟨nom⟩` mais n'a pas pu le trouver, 
soit parce qu'il n'existe pas, soit parce que le programme TeX sous-jacent
regarde au mauvais emplacement. Si le fichier existe et que LaTeX indique
qu'il n'est pas disponible, il est possible que l'installation TeX utilise
un mécanisme de hachage pour accélérer l'accès au fichier. Dans ce cas, 
vous devez lancer un programme spécial (par exemple, `mkTeXlsr`).

Cette erreur est déclenchée lorsque des commandes telles que `\input` et
`\usepackage` ne peuvent pas trouver le fichier demandé. Vous pouvez indiquer
un autre nom de fichier en réponse à l'erreur. Si le nouveau nom est spécifié
sans extension de nom de fichier, l'ancienne extension est réutilisée 
si elle est connue de LaTeX. Si vous ne voulez pas charger de fichier, il faut
appuyer sur *Entrée* ; pour quitter la compilation, il faut saisir `x` ou
`X`. Dans certains cas, vous aurez une erreur TeX de bas niveau
similaire (```` ! I can't find file `⟨nom⟩' ````) qui est un peu plus difficile
à traiter et décrite dans l'entrée page 917 du *LaTeX Companion*.

:::{todo} Le précédent paragraphe appelle une révision.
:::

Si un fichier graphique demandé avec `\includegraphics` est absent, 
il peut être judicieux de taper `h` pour en apprendre un peu plus 
sur les extensions testées lorsque le fichier a été recherché.


:::{sources}
- [FAQ erreurs - Lettre F](https://latex.developpez.com/faq/erreurs?page=F), 
  sur le site [Developpez.com](https://latex.developpez.com)
- *[LaTeX Companion](https://www.latex-project.org/help/books/#french)*, 
  2e édition, Frank Mittelbach, Michel Goossens, Johannes Braams, 
  David Carlisle, Chris Rowley (Pearson, 2006)
:::