---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, bibliographies,
              plusieurs bibliographies, bibliographies multiples
---

# Comment obtenir plusieurs bibliographies dans un document ?

Plusieurs extensions traitent ce sujet. Certaines d'entre elles utilisent
la structure du document pour générer les bibliographies, ce qui permet
par exemple d'obtenir une bibliographie par chapitre, par section... Ces cas
de liaison à la structure du document sont traités dans la question 
"[](/3_composition/annexes/bibliographie/bibliographies_par_chapitre)".

Si vos bibliographiques n'ont pas de lien avec la structure du document,
voici les autres solutions.

## Avec les commandes de base

Il est possible d'avoir plusieurs environnements `thebibliography` 
dans un document. La méthode "sans BibTeX" fonctionne donc 
sans aucun problème.

Par contre, avec BibTeX, seule une unique commande `bibliography` 
peut être utilisée puisqu'il n'y a qu'un fichier AUX généré 
par la compilation. Il existe cependant des extensions permettant 
de contourner cette limitation, qui vont donc s'efforcer de créer 
différents fichiers AUX.


## Avec l'extension <ctanpkg:multibbl>

L'extension <ctanpkg:multibbl> offre une interface très simple : vous utilisez
une commande `\newbibliography{⟨étiquette⟩}` pour définir une bibliographie 
associée à une `⟨étiquette⟩`. L'extension redéfinit les autres commandes 
de bibliographie de sorte qu'à chaque fois que vous utilisez 
l'une d'entre elles, vous lui donnez l'étiquette de la bibliographie 
dans laquelle vous voulez que les références citées apparaissent. 
La commande `\bibliography` elle-même prend également 
un argument supplémentaire qui indique le titre à utiliser pour la section
ou le chapitre résultant (c'est-à-dire qu'elle corrige 
[`\refname` et `\bibname`](/3_composition/langues/traduire_le_titre_de_table_des_matieres_ou_bibliographie) 
en respectant l'extension <ctanpkg:babel>). Vous pouvez donc écrire :

```{noedit}
\usepackage{multibbl}
\newbibliography{liv}
\bibliographystyle{liv}{alpha}
\newbibliography{art}
\bibliographystyle{art}{plain}
(...)
\cite[p.~23--25]{liv}{milne:test}
(...)
\cite{art}{einstein:1905}
(...)
\bibliography{liv}{livre-bib}{Livres de référence}
\bibliography{art}{art-bib}{Articles de référence}
```

Notez que :

- l'argument optionnel de la commande `\cite` apparaît *avant* 
  le nouvel argument d'étiquette ;
- les commandes `\bibliography` peuvent lister plus d'un fichier BIB. 
  Elles peuvent même lister le même ensemble de fichiers.

Les données de `\bibliography` utiles à BibTeX vont dans des fichiers 
dont les noms sont `⟨étiquette⟩.aux`. Pour obtenir les bibliographies 
bien mises en forme, vous devrez donc lancer, après votre première compilation
avec LaTeX, les commandes suivantes :

```bash
bibtex liv
bibtex art
```


## Avec l'extension <ctanpkg:multibib>

L'extension <ctanpkg:multibib> permet de découper "la" bibliographie 
en plusieurs bibliographies différentes, chacune étant accompagnée 
de sa propre série de commandes de bibliographie. Pour reprendre l'exemple
ci-dessus, cela donnerait :

```{noedit}
\usepackage{multibib}
\newcites{liv,art}%
         {Livres de référence,%
          Articles de référence}
\bibliographystyleliv{alpha}
\bibliographystyleart{plain}
(...)
\citeliv[p.~23--25]{milne:test}
(...)
\citeart{einstein:1905}
(...)
\bibliographyliv{liv-bib}
\bibliographyart{art-bib}
```

Encore une fois, comme pour <ctanpkg:multibbl>, toute commande `\bibliography`
peut recevoir n'importe quelle liste de fichiers BIB. De plus, le traitement
de BibTeX de fichiers utilisant <ctanpkg:multibib> ressemble beaucoup à celui
de fichiers utilisant <ctanpkg:multibbl>. Pour l'exemple présent, il faudrait
utiliser les commandes :

```bash
bibtex liv
bibtex art
```

Cependant, contrairement à <ctanpkg:multibbl>, <ctanpkg:multibib> permet
de générer une bibliographie simple et non modifiée (en plus des bibliographies
par thème).


## Avec les extensions <ctanpkg:bibtopic> et <ctanpkg:placeins>

Les extensions <ctanpkg:bibtopic> et <ctanpkg:placeins> permettent aussi
de découper la bibliographie en différentes sections. À l'endroit approprié
dans votre document, vous placez une séquence d'environnements `btSect` 
(chacun d'entre eux spécifiant une base de données bibliographique à charger)
pour composer les bibliographies séparées. Avec notre exemple, 
cela donnerait :

```{noedit}
\usepackage[above,section]{placeins}
\usepackage{bibtopic}
\bibliographystyle{alpha}
(...)
\cite[p.~23--25]{milne:test}
(...)
\cite{einstein:1905}
(...)
\begin{btSect}{liv-bib}
\section{Livres de référence}
\btPrintCited
\end{btSect}

\begin{btSect}[plain]{art-bib}
\section{Articles de référence}
\btPrintAll
\end{btSect}
```

Cependant, la *grande* différence de cette extension avec <ctanpkg:multibbl>
et <ctanpkg:multibib> est que la sélection de ce qui apparaît 
dans chaque section bibliographique est déterminée dans <ctanpkg:bibtopic> 
par ce qui est dans les fichiers BIB.

Notez ici deux choses :

- la commande `btPrintAll` est l'équivalent de `\nocite{*}` dans la mesure où 
  elle permet de citer toutes les références du fichier BIB. La commande 
  `\btPrintNotCited` donne, pour sa part, le reste du contenu du fichier BIB
  : si aucune entrée de la base de données n'est citée, cela équivaut 
  à `\nocite{*}` ;
- la manière de spécifier un style de bibliographie change : si vous voulez
  un style différent pour une bibliographie, il faut le donner 
  comme argument facultatif à l'environnement `btSect`.

Le traitement BibTeX utilise des fichiers AUX dont les noms 
sont dérivés de celui du document de base. En supposant que 
votre fichier principal s'appelle `fichier.tex`, il faudra ici saisir 
les commandes :

```bash
bibtex fichier1
bibtex fichier2
```


## Avec l'extension <ctanpkg:splitbib>

L'extension <ctanpkg:splitbib> adopte une approche totalement différente. 
Un environnement `category` placé dans le préambule de votre document 
vous permet de définir une catégorie de références pour lesquelles 
vous souhaitez une bibliographie distincte. Dans chaque environnement, 
vous listez les clés mises dans la commande `\cite` que vous voulez voir 
listées dans cette catégorie. La commande `\bibliography` (ou, 
plus précisément, l'environnement `thebibliography` qu'elle utilise) 
va trier les clés comme demandé. Les clés non mentionnées 
dans un environnement `category` apparaissent dans une catégorie "divers"
créée lors de ce tri.

Un exemple de code figure dans la [documentation](texdoc:splitbib) 
de l'extension.


:::{sources}
- [Multiple bibliographies?](faquk:FAQ-multbib)
:::