---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, polices, fontes, petites capitales grasses, 
              gras typewriter
---

# Comment obtenir du gras en fonte à chasse fixe ou en petites capitales ?

LaTeX, tel qu'il est livré, n'offre aucun moyen de gérer les polices à chasse fixe grasses 
ou les petites capitales. Dans les faits, Donald Knuth n'a jamais conçu de telles polices, 
mais il existe d'autres raisons issues de considérations typographiques : 
- la police *Computer Modern* à chasse fixe de poids moyen est déjà assez grasse 
  (par rapport à d'autres polices à largeur fixe) ;
- les petites capitales grasses ne sont pas populaires auprès de nombreux typographes 
  professionnels.

Il existe un ensemble de fichiers MetaFont "supplémentaires" sur CTAN qui fournissent 
ces versions grasses. Avec les distributions TeX modernes, il est possible d'utiliser ces polices 
en les plaçant simplement dans un endroit approprié de l'arborescence de TeX 
(comme indiqué à la question "[](/5_fichiers/emplacements/ou_installer_les_packages)") : 
s'agissant de fichiers spécifiques à (La)TeX, le choix des dossiers lié au fournisseur *public* 
serait cohérent. Une fois que vous aurez, si nécessaire, 
[reconstruit les index des fichiers](/5_fichiers/emplacements/installer_des_fichiers_pour_latex), 
TeX (et autres) construiront automatiquement les fichiers de polices dont ils ont besoin 
lorsque vous y ferez référence pour la première fois. 
L'extension <ctanpkg:bold-extra> construit les structures de données de polices nécessaires 
pour que vous puissiez utiliser les polices dans LaTeX.

Une autre alternative consiste à utiliser les polices 
*[European Computer](/5_fichiers/formats/fontes/que_sont_les_fontes_ec)*, 
qui proposent des variantes en gras des polices en petites capitales.

Si vous devez utiliser des polices de type 1, vous ne pouvez pas utiliser les polices de Knuth, 
car il n'existe pas de versions de type 1 de l'ensemble [mf-extra](ctanpkg:cm-mf-extra-bold)
dédié à des versions grasses de *Computer Modern*. 
Il existe cependant des distributions de type 1 des polices *European Computer*, 
vous pouvez donc passer à celles-ci. Les alternatives sont discutées dans la question 
"[](/5_fichiers/formats/fontes/fontes_t1_8bits)".

Bien sûr, les polices commerciales à largeur fixe (même la police par défaut *Courier*) 
sont presque toujours livrées avec une variante grasse, donc ce n'est pas un problème. 
De plus, [PSNFSS](/5_fichiers/formats/fontes/utiliser_des_fontes_adobe_t1_avec_tex) 
fournira généralement des polices en petites capitales trafiquées 
et n'a aucun scrupule à les fournir sous une forme grasse. 
La police *Courier* est (comme nous le savons tous, à nos dépens) disponible gratuitement ; 
une police monospace bien plus présentable est *LuxiMono*, qui est également disponible gratuitement.


:::{sources}
[How to do bold-tt or bold-sc](faquk:FAQ-bold-extras)
:::