/* This file is generated by venus-protocol.  See vn_protocol_renderer.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_DEVICE_H
#define VN_PROTOCOL_RENDERER_DEVICE_H

#include "vn_protocol_renderer_structs.h"

#pragma GCC diagnostic push
#if !defined(__clang__) && defined(__GNUC__) && __GNUC__ >= 12
#pragma GCC diagnostic ignored "-Wdangling-pointer"
#endif
#pragma GCC diagnostic ignored "-Wpointer-arith"
#pragma GCC diagnostic ignored "-Wunused-parameter"

/*
 * These structs/unions/commands are not included
 *
 *   vkGetDeviceProcAddr
 */

/* struct VkPhysicalDeviceLimits */

static inline void
vn_encode_VkPhysicalDeviceLimits(struct vn_cs_encoder *enc, const VkPhysicalDeviceLimits *val)
{
    vn_encode_uint32_t(enc, &val->maxImageDimension1D);
    vn_encode_uint32_t(enc, &val->maxImageDimension2D);
    vn_encode_uint32_t(enc, &val->maxImageDimension3D);
    vn_encode_uint32_t(enc, &val->maxImageDimensionCube);
    vn_encode_uint32_t(enc, &val->maxImageArrayLayers);
    vn_encode_uint32_t(enc, &val->maxTexelBufferElements);
    vn_encode_uint32_t(enc, &val->maxUniformBufferRange);
    vn_encode_uint32_t(enc, &val->maxStorageBufferRange);
    vn_encode_uint32_t(enc, &val->maxPushConstantsSize);
    vn_encode_uint32_t(enc, &val->maxMemoryAllocationCount);
    vn_encode_uint32_t(enc, &val->maxSamplerAllocationCount);
    vn_encode_VkDeviceSize(enc, &val->bufferImageGranularity);
    vn_encode_VkDeviceSize(enc, &val->sparseAddressSpaceSize);
    vn_encode_uint32_t(enc, &val->maxBoundDescriptorSets);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorSamplers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorSampledImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorStorageImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorInputAttachments);
    vn_encode_uint32_t(enc, &val->maxPerStageResources);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetSamplers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUniformBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetStorageBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetSampledImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetStorageImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetInputAttachments);
    vn_encode_uint32_t(enc, &val->maxVertexInputAttributes);
    vn_encode_uint32_t(enc, &val->maxVertexInputBindings);
    vn_encode_uint32_t(enc, &val->maxVertexInputAttributeOffset);
    vn_encode_uint32_t(enc, &val->maxVertexInputBindingStride);
    vn_encode_uint32_t(enc, &val->maxVertexOutputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationGenerationLevel);
    vn_encode_uint32_t(enc, &val->maxTessellationPatchSize);
    vn_encode_uint32_t(enc, &val->maxTessellationControlPerVertexInputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationControlPerVertexOutputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationControlPerPatchOutputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationControlTotalOutputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationEvaluationInputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationEvaluationOutputComponents);
    vn_encode_uint32_t(enc, &val->maxGeometryShaderInvocations);
    vn_encode_uint32_t(enc, &val->maxGeometryInputComponents);
    vn_encode_uint32_t(enc, &val->maxGeometryOutputComponents);
    vn_encode_uint32_t(enc, &val->maxGeometryOutputVertices);
    vn_encode_uint32_t(enc, &val->maxGeometryTotalOutputComponents);
    vn_encode_uint32_t(enc, &val->maxFragmentInputComponents);
    vn_encode_uint32_t(enc, &val->maxFragmentOutputAttachments);
    vn_encode_uint32_t(enc, &val->maxFragmentDualSrcAttachments);
    vn_encode_uint32_t(enc, &val->maxFragmentCombinedOutputResources);
    vn_encode_uint32_t(enc, &val->maxComputeSharedMemorySize);
    vn_encode_array_size(enc, 3);
    vn_encode_uint32_t_array(enc, val->maxComputeWorkGroupCount, 3);
    vn_encode_uint32_t(enc, &val->maxComputeWorkGroupInvocations);
    vn_encode_array_size(enc, 3);
    vn_encode_uint32_t_array(enc, val->maxComputeWorkGroupSize, 3);
    vn_encode_uint32_t(enc, &val->subPixelPrecisionBits);
    vn_encode_uint32_t(enc, &val->subTexelPrecisionBits);
    vn_encode_uint32_t(enc, &val->mipmapPrecisionBits);
    vn_encode_uint32_t(enc, &val->maxDrawIndexedIndexValue);
    vn_encode_uint32_t(enc, &val->maxDrawIndirectCount);
    vn_encode_float(enc, &val->maxSamplerLodBias);
    vn_encode_float(enc, &val->maxSamplerAnisotropy);
    vn_encode_uint32_t(enc, &val->maxViewports);
    vn_encode_array_size(enc, 2);
    vn_encode_uint32_t_array(enc, val->maxViewportDimensions, 2);
    vn_encode_array_size(enc, 2);
    vn_encode_float_array(enc, val->viewportBoundsRange, 2);
    vn_encode_uint32_t(enc, &val->viewportSubPixelBits);
    vn_encode_size_t(enc, &val->minMemoryMapAlignment);
    vn_encode_VkDeviceSize(enc, &val->minTexelBufferOffsetAlignment);
    vn_encode_VkDeviceSize(enc, &val->minUniformBufferOffsetAlignment);
    vn_encode_VkDeviceSize(enc, &val->minStorageBufferOffsetAlignment);
    vn_encode_int32_t(enc, &val->minTexelOffset);
    vn_encode_uint32_t(enc, &val->maxTexelOffset);
    vn_encode_int32_t(enc, &val->minTexelGatherOffset);
    vn_encode_uint32_t(enc, &val->maxTexelGatherOffset);
    vn_encode_float(enc, &val->minInterpolationOffset);
    vn_encode_float(enc, &val->maxInterpolationOffset);
    vn_encode_uint32_t(enc, &val->subPixelInterpolationOffsetBits);
    vn_encode_uint32_t(enc, &val->maxFramebufferWidth);
    vn_encode_uint32_t(enc, &val->maxFramebufferHeight);
    vn_encode_uint32_t(enc, &val->maxFramebufferLayers);
    vn_encode_VkFlags(enc, &val->framebufferColorSampleCounts);
    vn_encode_VkFlags(enc, &val->framebufferDepthSampleCounts);
    vn_encode_VkFlags(enc, &val->framebufferStencilSampleCounts);
    vn_encode_VkFlags(enc, &val->framebufferNoAttachmentsSampleCounts);
    vn_encode_uint32_t(enc, &val->maxColorAttachments);
    vn_encode_VkFlags(enc, &val->sampledImageColorSampleCounts);
    vn_encode_VkFlags(enc, &val->sampledImageIntegerSampleCounts);
    vn_encode_VkFlags(enc, &val->sampledImageDepthSampleCounts);
    vn_encode_VkFlags(enc, &val->sampledImageStencilSampleCounts);
    vn_encode_VkFlags(enc, &val->storageImageSampleCounts);
    vn_encode_uint32_t(enc, &val->maxSampleMaskWords);
    vn_encode_VkBool32(enc, &val->timestampComputeAndGraphics);
    vn_encode_float(enc, &val->timestampPeriod);
    vn_encode_uint32_t(enc, &val->maxClipDistances);
    vn_encode_uint32_t(enc, &val->maxCullDistances);
    vn_encode_uint32_t(enc, &val->maxCombinedClipAndCullDistances);
    vn_encode_uint32_t(enc, &val->discreteQueuePriorities);
    vn_encode_array_size(enc, 2);
    vn_encode_float_array(enc, val->pointSizeRange, 2);
    vn_encode_array_size(enc, 2);
    vn_encode_float_array(enc, val->lineWidthRange, 2);
    vn_encode_float(enc, &val->pointSizeGranularity);
    vn_encode_float(enc, &val->lineWidthGranularity);
    vn_encode_VkBool32(enc, &val->strictLines);
    vn_encode_VkBool32(enc, &val->standardSampleLocations);
    vn_encode_VkDeviceSize(enc, &val->optimalBufferCopyOffsetAlignment);
    vn_encode_VkDeviceSize(enc, &val->optimalBufferCopyRowPitchAlignment);
    vn_encode_VkDeviceSize(enc, &val->nonCoherentAtomSize);
}

static inline void
vn_decode_VkPhysicalDeviceLimits_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLimits *val)
{
    /* skip val->maxImageDimension1D */
    /* skip val->maxImageDimension2D */
    /* skip val->maxImageDimension3D */
    /* skip val->maxImageDimensionCube */
    /* skip val->maxImageArrayLayers */
    /* skip val->maxTexelBufferElements */
    /* skip val->maxUniformBufferRange */
    /* skip val->maxStorageBufferRange */
    /* skip val->maxPushConstantsSize */
    /* skip val->maxMemoryAllocationCount */
    /* skip val->maxSamplerAllocationCount */
    /* skip val->bufferImageGranularity */
    /* skip val->sparseAddressSpaceSize */
    /* skip val->maxBoundDescriptorSets */
    /* skip val->maxPerStageDescriptorSamplers */
    /* skip val->maxPerStageDescriptorUniformBuffers */
    /* skip val->maxPerStageDescriptorStorageBuffers */
    /* skip val->maxPerStageDescriptorSampledImages */
    /* skip val->maxPerStageDescriptorStorageImages */
    /* skip val->maxPerStageDescriptorInputAttachments */
    /* skip val->maxPerStageResources */
    /* skip val->maxDescriptorSetSamplers */
    /* skip val->maxDescriptorSetUniformBuffers */
    /* skip val->maxDescriptorSetUniformBuffersDynamic */
    /* skip val->maxDescriptorSetStorageBuffers */
    /* skip val->maxDescriptorSetStorageBuffersDynamic */
    /* skip val->maxDescriptorSetSampledImages */
    /* skip val->maxDescriptorSetStorageImages */
    /* skip val->maxDescriptorSetInputAttachments */
    /* skip val->maxVertexInputAttributes */
    /* skip val->maxVertexInputBindings */
    /* skip val->maxVertexInputAttributeOffset */
    /* skip val->maxVertexInputBindingStride */
    /* skip val->maxVertexOutputComponents */
    /* skip val->maxTessellationGenerationLevel */
    /* skip val->maxTessellationPatchSize */
    /* skip val->maxTessellationControlPerVertexInputComponents */
    /* skip val->maxTessellationControlPerVertexOutputComponents */
    /* skip val->maxTessellationControlPerPatchOutputComponents */
    /* skip val->maxTessellationControlTotalOutputComponents */
    /* skip val->maxTessellationEvaluationInputComponents */
    /* skip val->maxTessellationEvaluationOutputComponents */
    /* skip val->maxGeometryShaderInvocations */
    /* skip val->maxGeometryInputComponents */
    /* skip val->maxGeometryOutputComponents */
    /* skip val->maxGeometryOutputVertices */
    /* skip val->maxGeometryTotalOutputComponents */
    /* skip val->maxFragmentInputComponents */
    /* skip val->maxFragmentOutputAttachments */
    /* skip val->maxFragmentDualSrcAttachments */
    /* skip val->maxFragmentCombinedOutputResources */
    /* skip val->maxComputeSharedMemorySize */
    /* skip val->maxComputeWorkGroupCount */
    /* skip val->maxComputeWorkGroupInvocations */
    /* skip val->maxComputeWorkGroupSize */
    /* skip val->subPixelPrecisionBits */
    /* skip val->subTexelPrecisionBits */
    /* skip val->mipmapPrecisionBits */
    /* skip val->maxDrawIndexedIndexValue */
    /* skip val->maxDrawIndirectCount */
    /* skip val->maxSamplerLodBias */
    /* skip val->maxSamplerAnisotropy */
    /* skip val->maxViewports */
    /* skip val->maxViewportDimensions */
    /* skip val->viewportBoundsRange */
    /* skip val->viewportSubPixelBits */
    /* skip val->minMemoryMapAlignment */
    /* skip val->minTexelBufferOffsetAlignment */
    /* skip val->minUniformBufferOffsetAlignment */
    /* skip val->minStorageBufferOffsetAlignment */
    /* skip val->minTexelOffset */
    /* skip val->maxTexelOffset */
    /* skip val->minTexelGatherOffset */
    /* skip val->maxTexelGatherOffset */
    /* skip val->minInterpolationOffset */
    /* skip val->maxInterpolationOffset */
    /* skip val->subPixelInterpolationOffsetBits */
    /* skip val->maxFramebufferWidth */
    /* skip val->maxFramebufferHeight */
    /* skip val->maxFramebufferLayers */
    /* skip val->framebufferColorSampleCounts */
    /* skip val->framebufferDepthSampleCounts */
    /* skip val->framebufferStencilSampleCounts */
    /* skip val->framebufferNoAttachmentsSampleCounts */
    /* skip val->maxColorAttachments */
    /* skip val->sampledImageColorSampleCounts */
    /* skip val->sampledImageIntegerSampleCounts */
    /* skip val->sampledImageDepthSampleCounts */
    /* skip val->sampledImageStencilSampleCounts */
    /* skip val->storageImageSampleCounts */
    /* skip val->maxSampleMaskWords */
    /* skip val->timestampComputeAndGraphics */
    /* skip val->timestampPeriod */
    /* skip val->maxClipDistances */
    /* skip val->maxCullDistances */
    /* skip val->maxCombinedClipAndCullDistances */
    /* skip val->discreteQueuePriorities */
    /* skip val->pointSizeRange */
    /* skip val->lineWidthRange */
    /* skip val->pointSizeGranularity */
    /* skip val->lineWidthGranularity */
    /* skip val->strictLines */
    /* skip val->standardSampleLocations */
    /* skip val->optimalBufferCopyOffsetAlignment */
    /* skip val->optimalBufferCopyRowPitchAlignment */
    /* skip val->nonCoherentAtomSize */
}

/* struct VkPhysicalDeviceSparseProperties */

static inline void
vn_encode_VkPhysicalDeviceSparseProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceSparseProperties *val)
{
    vn_encode_VkBool32(enc, &val->residencyStandard2DBlockShape);
    vn_encode_VkBool32(enc, &val->residencyStandard2DMultisampleBlockShape);
    vn_encode_VkBool32(enc, &val->residencyStandard3DBlockShape);
    vn_encode_VkBool32(enc, &val->residencyAlignedMipSize);
    vn_encode_VkBool32(enc, &val->residencyNonResidentStrict);
}

static inline void
vn_decode_VkPhysicalDeviceSparseProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSparseProperties *val)
{
    /* skip val->residencyStandard2DBlockShape */
    /* skip val->residencyStandard2DMultisampleBlockShape */
    /* skip val->residencyStandard3DBlockShape */
    /* skip val->residencyAlignedMipSize */
    /* skip val->residencyNonResidentStrict */
}

/* struct VkPhysicalDeviceProperties */

static inline void
vn_encode_VkPhysicalDeviceProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceProperties *val)
{
    vn_encode_uint32_t(enc, &val->apiVersion);
    vn_encode_uint32_t(enc, &val->driverVersion);
    vn_encode_uint32_t(enc, &val->vendorID);
    vn_encode_uint32_t(enc, &val->deviceID);
    vn_encode_VkPhysicalDeviceType(enc, &val->deviceType);
    vn_encode_array_size(enc, VK_MAX_PHYSICAL_DEVICE_NAME_SIZE);
    vn_encode_char_array(enc, val->deviceName, VK_MAX_PHYSICAL_DEVICE_NAME_SIZE);
    vn_encode_array_size(enc, VK_UUID_SIZE);
    vn_encode_uint8_t_array(enc, val->pipelineCacheUUID, VK_UUID_SIZE);
    vn_encode_VkPhysicalDeviceLimits(enc, &val->limits);
    vn_encode_VkPhysicalDeviceSparseProperties(enc, &val->sparseProperties);
}

static inline void
vn_decode_VkPhysicalDeviceProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProperties *val)
{
    /* skip val->apiVersion */
    /* skip val->driverVersion */
    /* skip val->vendorID */
    /* skip val->deviceID */
    /* skip val->deviceType */
    /* skip val->deviceName */
    /* skip val->pipelineCacheUUID */
    vn_decode_VkPhysicalDeviceLimits_partial_temp(dec, &val->limits);
    vn_decode_VkPhysicalDeviceSparseProperties_partial_temp(dec, &val->sparseProperties);
}

/* struct VkQueueFamilyProperties */

static inline void
vn_encode_VkQueueFamilyProperties(struct vn_cs_encoder *enc, const VkQueueFamilyProperties *val)
{
    vn_encode_VkFlags(enc, &val->queueFlags);
    vn_encode_uint32_t(enc, &val->queueCount);
    vn_encode_uint32_t(enc, &val->timestampValidBits);
    vn_encode_VkExtent3D(enc, &val->minImageTransferGranularity);
}

static inline void
vn_decode_VkQueueFamilyProperties_partial_temp(struct vn_cs_decoder *dec, VkQueueFamilyProperties *val)
{
    /* skip val->queueFlags */
    /* skip val->queueCount */
    /* skip val->timestampValidBits */
    vn_decode_VkExtent3D_partial_temp(dec, &val->minImageTransferGranularity);
}

/* struct VkMemoryType */

static inline void
vn_encode_VkMemoryType(struct vn_cs_encoder *enc, const VkMemoryType *val)
{
    vn_encode_VkFlags(enc, &val->propertyFlags);
    vn_encode_uint32_t(enc, &val->heapIndex);
}

static inline void
vn_decode_VkMemoryType_partial_temp(struct vn_cs_decoder *dec, VkMemoryType *val)
{
    /* skip val->propertyFlags */
    /* skip val->heapIndex */
}

/* struct VkMemoryHeap */

static inline void
vn_encode_VkMemoryHeap(struct vn_cs_encoder *enc, const VkMemoryHeap *val)
{
    vn_encode_VkDeviceSize(enc, &val->size);
    vn_encode_VkFlags(enc, &val->flags);
}

static inline void
vn_decode_VkMemoryHeap_partial_temp(struct vn_cs_decoder *dec, VkMemoryHeap *val)
{
    /* skip val->size */
    /* skip val->flags */
}

/* struct VkPhysicalDeviceMemoryProperties */

static inline void
vn_encode_VkPhysicalDeviceMemoryProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceMemoryProperties *val)
{
    vn_encode_uint32_t(enc, &val->memoryTypeCount);
    vn_encode_array_size(enc, VK_MAX_MEMORY_TYPES);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_TYPES; i++)
        vn_encode_VkMemoryType(enc, &val->memoryTypes[i]);
    vn_encode_uint32_t(enc, &val->memoryHeapCount);
    vn_encode_array_size(enc, VK_MAX_MEMORY_HEAPS);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; i++)
        vn_encode_VkMemoryHeap(enc, &val->memoryHeaps[i]);
}

static inline void
vn_decode_VkPhysicalDeviceMemoryProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMemoryProperties *val)
{
    /* skip val->memoryTypeCount */
    {
        const uint32_t iter_count = vn_decode_array_size(dec, VK_MAX_MEMORY_TYPES);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkMemoryType_partial_temp(dec, &val->memoryTypes[i]);
    }
    /* skip val->memoryHeapCount */
    {
        const uint32_t iter_count = vn_decode_array_size(dec, VK_MAX_MEMORY_HEAPS);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkMemoryHeap_partial_temp(dec, &val->memoryHeaps[i]);
    }
}

/* struct VkPhysicalDeviceFeatures */

static inline void
vn_encode_VkPhysicalDeviceFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures *val)
{
    vn_encode_VkBool32(enc, &val->robustBufferAccess);
    vn_encode_VkBool32(enc, &val->fullDrawIndexUint32);
    vn_encode_VkBool32(enc, &val->imageCubeArray);
    vn_encode_VkBool32(enc, &val->independentBlend);
    vn_encode_VkBool32(enc, &val->geometryShader);
    vn_encode_VkBool32(enc, &val->tessellationShader);
    vn_encode_VkBool32(enc, &val->sampleRateShading);
    vn_encode_VkBool32(enc, &val->dualSrcBlend);
    vn_encode_VkBool32(enc, &val->logicOp);
    vn_encode_VkBool32(enc, &val->multiDrawIndirect);
    vn_encode_VkBool32(enc, &val->drawIndirectFirstInstance);
    vn_encode_VkBool32(enc, &val->depthClamp);
    vn_encode_VkBool32(enc, &val->depthBiasClamp);
    vn_encode_VkBool32(enc, &val->fillModeNonSolid);
    vn_encode_VkBool32(enc, &val->depthBounds);
    vn_encode_VkBool32(enc, &val->wideLines);
    vn_encode_VkBool32(enc, &val->largePoints);
    vn_encode_VkBool32(enc, &val->alphaToOne);
    vn_encode_VkBool32(enc, &val->multiViewport);
    vn_encode_VkBool32(enc, &val->samplerAnisotropy);
    vn_encode_VkBool32(enc, &val->textureCompressionETC2);
    vn_encode_VkBool32(enc, &val->textureCompressionASTC_LDR);
    vn_encode_VkBool32(enc, &val->textureCompressionBC);
    vn_encode_VkBool32(enc, &val->occlusionQueryPrecise);
    vn_encode_VkBool32(enc, &val->pipelineStatisticsQuery);
    vn_encode_VkBool32(enc, &val->vertexPipelineStoresAndAtomics);
    vn_encode_VkBool32(enc, &val->fragmentStoresAndAtomics);
    vn_encode_VkBool32(enc, &val->shaderTessellationAndGeometryPointSize);
    vn_encode_VkBool32(enc, &val->shaderImageGatherExtended);
    vn_encode_VkBool32(enc, &val->shaderStorageImageExtendedFormats);
    vn_encode_VkBool32(enc, &val->shaderStorageImageMultisample);
    vn_encode_VkBool32(enc, &val->shaderStorageImageReadWithoutFormat);
    vn_encode_VkBool32(enc, &val->shaderStorageImageWriteWithoutFormat);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderClipDistance);
    vn_encode_VkBool32(enc, &val->shaderCullDistance);
    vn_encode_VkBool32(enc, &val->shaderFloat64);
    vn_encode_VkBool32(enc, &val->shaderInt64);
    vn_encode_VkBool32(enc, &val->shaderInt16);
    vn_encode_VkBool32(enc, &val->shaderResourceResidency);
    vn_encode_VkBool32(enc, &val->shaderResourceMinLod);
    vn_encode_VkBool32(enc, &val->sparseBinding);
    vn_encode_VkBool32(enc, &val->sparseResidencyBuffer);
    vn_encode_VkBool32(enc, &val->sparseResidencyImage2D);
    vn_encode_VkBool32(enc, &val->sparseResidencyImage3D);
    vn_encode_VkBool32(enc, &val->sparseResidency2Samples);
    vn_encode_VkBool32(enc, &val->sparseResidency4Samples);
    vn_encode_VkBool32(enc, &val->sparseResidency8Samples);
    vn_encode_VkBool32(enc, &val->sparseResidency16Samples);
    vn_encode_VkBool32(enc, &val->sparseResidencyAliased);
    vn_encode_VkBool32(enc, &val->variableMultisampleRate);
    vn_encode_VkBool32(enc, &val->inheritedQueries);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures *val)
{
    vn_decode_VkBool32(dec, &val->robustBufferAccess);
    vn_decode_VkBool32(dec, &val->fullDrawIndexUint32);
    vn_decode_VkBool32(dec, &val->imageCubeArray);
    vn_decode_VkBool32(dec, &val->independentBlend);
    vn_decode_VkBool32(dec, &val->geometryShader);
    vn_decode_VkBool32(dec, &val->tessellationShader);
    vn_decode_VkBool32(dec, &val->sampleRateShading);
    vn_decode_VkBool32(dec, &val->dualSrcBlend);
    vn_decode_VkBool32(dec, &val->logicOp);
    vn_decode_VkBool32(dec, &val->multiDrawIndirect);
    vn_decode_VkBool32(dec, &val->drawIndirectFirstInstance);
    vn_decode_VkBool32(dec, &val->depthClamp);
    vn_decode_VkBool32(dec, &val->depthBiasClamp);
    vn_decode_VkBool32(dec, &val->fillModeNonSolid);
    vn_decode_VkBool32(dec, &val->depthBounds);
    vn_decode_VkBool32(dec, &val->wideLines);
    vn_decode_VkBool32(dec, &val->largePoints);
    vn_decode_VkBool32(dec, &val->alphaToOne);
    vn_decode_VkBool32(dec, &val->multiViewport);
    vn_decode_VkBool32(dec, &val->samplerAnisotropy);
    vn_decode_VkBool32(dec, &val->textureCompressionETC2);
    vn_decode_VkBool32(dec, &val->textureCompressionASTC_LDR);
    vn_decode_VkBool32(dec, &val->textureCompressionBC);
    vn_decode_VkBool32(dec, &val->occlusionQueryPrecise);
    vn_decode_VkBool32(dec, &val->pipelineStatisticsQuery);
    vn_decode_VkBool32(dec, &val->vertexPipelineStoresAndAtomics);
    vn_decode_VkBool32(dec, &val->fragmentStoresAndAtomics);
    vn_decode_VkBool32(dec, &val->shaderTessellationAndGeometryPointSize);
    vn_decode_VkBool32(dec, &val->shaderImageGatherExtended);
    vn_decode_VkBool32(dec, &val->shaderStorageImageExtendedFormats);
    vn_decode_VkBool32(dec, &val->shaderStorageImageMultisample);
    vn_decode_VkBool32(dec, &val->shaderStorageImageReadWithoutFormat);
    vn_decode_VkBool32(dec, &val->shaderStorageImageWriteWithoutFormat);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderClipDistance);
    vn_decode_VkBool32(dec, &val->shaderCullDistance);
    vn_decode_VkBool32(dec, &val->shaderFloat64);
    vn_decode_VkBool32(dec, &val->shaderInt64);
    vn_decode_VkBool32(dec, &val->shaderInt16);
    vn_decode_VkBool32(dec, &val->shaderResourceResidency);
    vn_decode_VkBool32(dec, &val->shaderResourceMinLod);
    vn_decode_VkBool32(dec, &val->sparseBinding);
    vn_decode_VkBool32(dec, &val->sparseResidencyBuffer);
    vn_decode_VkBool32(dec, &val->sparseResidencyImage2D);
    vn_decode_VkBool32(dec, &val->sparseResidencyImage3D);
    vn_decode_VkBool32(dec, &val->sparseResidency2Samples);
    vn_decode_VkBool32(dec, &val->sparseResidency4Samples);
    vn_decode_VkBool32(dec, &val->sparseResidency8Samples);
    vn_decode_VkBool32(dec, &val->sparseResidency16Samples);
    vn_decode_VkBool32(dec, &val->sparseResidencyAliased);
    vn_decode_VkBool32(dec, &val->variableMultisampleRate);
    vn_decode_VkBool32(dec, &val->inheritedQueries);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures *val)
{
    /* skip val->robustBufferAccess */
    /* skip val->fullDrawIndexUint32 */
    /* skip val->imageCubeArray */
    /* skip val->independentBlend */
    /* skip val->geometryShader */
    /* skip val->tessellationShader */
    /* skip val->sampleRateShading */
    /* skip val->dualSrcBlend */
    /* skip val->logicOp */
    /* skip val->multiDrawIndirect */
    /* skip val->drawIndirectFirstInstance */
    /* skip val->depthClamp */
    /* skip val->depthBiasClamp */
    /* skip val->fillModeNonSolid */
    /* skip val->depthBounds */
    /* skip val->wideLines */
    /* skip val->largePoints */
    /* skip val->alphaToOne */
    /* skip val->multiViewport */
    /* skip val->samplerAnisotropy */
    /* skip val->textureCompressionETC2 */
    /* skip val->textureCompressionASTC_LDR */
    /* skip val->textureCompressionBC */
    /* skip val->occlusionQueryPrecise */
    /* skip val->pipelineStatisticsQuery */
    /* skip val->vertexPipelineStoresAndAtomics */
    /* skip val->fragmentStoresAndAtomics */
    /* skip val->shaderTessellationAndGeometryPointSize */
    /* skip val->shaderImageGatherExtended */
    /* skip val->shaderStorageImageExtendedFormats */
    /* skip val->shaderStorageImageMultisample */
    /* skip val->shaderStorageImageReadWithoutFormat */
    /* skip val->shaderStorageImageWriteWithoutFormat */
    /* skip val->shaderUniformBufferArrayDynamicIndexing */
    /* skip val->shaderSampledImageArrayDynamicIndexing */
    /* skip val->shaderStorageBufferArrayDynamicIndexing */
    /* skip val->shaderStorageImageArrayDynamicIndexing */
    /* skip val->shaderClipDistance */
    /* skip val->shaderCullDistance */
    /* skip val->shaderFloat64 */
    /* skip val->shaderInt64 */
    /* skip val->shaderInt16 */
    /* skip val->shaderResourceResidency */
    /* skip val->shaderResourceMinLod */
    /* skip val->sparseBinding */
    /* skip val->sparseResidencyBuffer */
    /* skip val->sparseResidencyImage2D */
    /* skip val->sparseResidencyImage3D */
    /* skip val->sparseResidency2Samples */
    /* skip val->sparseResidency4Samples */
    /* skip val->sparseResidency8Samples */
    /* skip val->sparseResidency16Samples */
    /* skip val->sparseResidencyAliased */
    /* skip val->variableMultisampleRate */
    /* skip val->inheritedQueries */
}

static inline void
vn_replace_VkPhysicalDeviceFeatures_handle(VkPhysicalDeviceFeatures *val)
{
    /* skip val->robustBufferAccess */
    /* skip val->fullDrawIndexUint32 */
    /* skip val->imageCubeArray */
    /* skip val->independentBlend */
    /* skip val->geometryShader */
    /* skip val->tessellationShader */
    /* skip val->sampleRateShading */
    /* skip val->dualSrcBlend */
    /* skip val->logicOp */
    /* skip val->multiDrawIndirect */
    /* skip val->drawIndirectFirstInstance */
    /* skip val->depthClamp */
    /* skip val->depthBiasClamp */
    /* skip val->fillModeNonSolid */
    /* skip val->depthBounds */
    /* skip val->wideLines */
    /* skip val->largePoints */
    /* skip val->alphaToOne */
    /* skip val->multiViewport */
    /* skip val->samplerAnisotropy */
    /* skip val->textureCompressionETC2 */
    /* skip val->textureCompressionASTC_LDR */
    /* skip val->textureCompressionBC */
    /* skip val->occlusionQueryPrecise */
    /* skip val->pipelineStatisticsQuery */
    /* skip val->vertexPipelineStoresAndAtomics */
    /* skip val->fragmentStoresAndAtomics */
    /* skip val->shaderTessellationAndGeometryPointSize */
    /* skip val->shaderImageGatherExtended */
    /* skip val->shaderStorageImageExtendedFormats */
    /* skip val->shaderStorageImageMultisample */
    /* skip val->shaderStorageImageReadWithoutFormat */
    /* skip val->shaderStorageImageWriteWithoutFormat */
    /* skip val->shaderUniformBufferArrayDynamicIndexing */
    /* skip val->shaderSampledImageArrayDynamicIndexing */
    /* skip val->shaderStorageBufferArrayDynamicIndexing */
    /* skip val->shaderStorageImageArrayDynamicIndexing */
    /* skip val->shaderClipDistance */
    /* skip val->shaderCullDistance */
    /* skip val->shaderFloat64 */
    /* skip val->shaderInt64 */
    /* skip val->shaderInt16 */
    /* skip val->shaderResourceResidency */
    /* skip val->shaderResourceMinLod */
    /* skip val->sparseBinding */
    /* skip val->sparseResidencyBuffer */
    /* skip val->sparseResidencyImage2D */
    /* skip val->sparseResidencyImage3D */
    /* skip val->sparseResidency2Samples */
    /* skip val->sparseResidency4Samples */
    /* skip val->sparseResidency8Samples */
    /* skip val->sparseResidency16Samples */
    /* skip val->sparseResidencyAliased */
    /* skip val->variableMultisampleRate */
    /* skip val->inheritedQueries */
}

/* struct VkFormatProperties */

static inline void
vn_encode_VkFormatProperties(struct vn_cs_encoder *enc, const VkFormatProperties *val)
{
    vn_encode_VkFlags(enc, &val->linearTilingFeatures);
    vn_encode_VkFlags(enc, &val->optimalTilingFeatures);
    vn_encode_VkFlags(enc, &val->bufferFeatures);
}

static inline void
vn_decode_VkFormatProperties_partial_temp(struct vn_cs_decoder *dec, VkFormatProperties *val)
{
    /* skip val->linearTilingFeatures */
    /* skip val->optimalTilingFeatures */
    /* skip val->bufferFeatures */
}

/* struct VkImageFormatProperties */

static inline void
vn_encode_VkImageFormatProperties(struct vn_cs_encoder *enc, const VkImageFormatProperties *val)
{
    vn_encode_VkExtent3D(enc, &val->maxExtent);
    vn_encode_uint32_t(enc, &val->maxMipLevels);
    vn_encode_uint32_t(enc, &val->maxArrayLayers);
    vn_encode_VkFlags(enc, &val->sampleCounts);
    vn_encode_VkDeviceSize(enc, &val->maxResourceSize);
}

static inline void
vn_decode_VkImageFormatProperties_partial_temp(struct vn_cs_decoder *dec, VkImageFormatProperties *val)
{
    vn_decode_VkExtent3D_partial_temp(dec, &val->maxExtent);
    /* skip val->maxMipLevels */
    /* skip val->maxArrayLayers */
    /* skip val->sampleCounts */
    /* skip val->maxResourceSize */
}

/* struct VkDeviceQueueGlobalPriorityCreateInfo chain */

static inline void *
vn_decode_VkDeviceQueueGlobalPriorityCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDeviceQueueGlobalPriorityCreateInfo_self_temp(struct vn_cs_decoder *dec, VkDeviceQueueGlobalPriorityCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkQueueGlobalPriority(dec, &val->globalPriority);
}

static inline void
vn_decode_VkDeviceQueueGlobalPriorityCreateInfo_temp(struct vn_cs_decoder *dec, VkDeviceQueueGlobalPriorityCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceQueueGlobalPriorityCreateInfo_pnext_temp(dec);
    vn_decode_VkDeviceQueueGlobalPriorityCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceQueueGlobalPriorityCreateInfo_handle_self(VkDeviceQueueGlobalPriorityCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->globalPriority */
}

static inline void
vn_replace_VkDeviceQueueGlobalPriorityCreateInfo_handle(VkDeviceQueueGlobalPriorityCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO:
            vn_replace_VkDeviceQueueGlobalPriorityCreateInfo_handle_self((VkDeviceQueueGlobalPriorityCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkDeviceQueueCreateInfo chain */

static inline void *
vn_decode_VkDeviceQueueCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDeviceQueueGlobalPriorityCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceQueueCreateInfo_pnext_temp(dec);
            vn_decode_VkDeviceQueueGlobalPriorityCreateInfo_self_temp(dec, (VkDeviceQueueGlobalPriorityCreateInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkDeviceQueueCreateInfo_self_temp(struct vn_cs_decoder *dec, VkDeviceQueueCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->queueFamilyIndex);
    vn_decode_uint32_t(dec, &val->queueCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->queueCount);
        val->pQueuePriorities = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pQueuePriorities), array_size);
        if (!val->pQueuePriorities) return;
        vn_decode_float_array(dec, (float *)val->pQueuePriorities, array_size);
    } else {
        vn_decode_array_size(dec, val->queueCount);
        val->pQueuePriorities = NULL;
    }
}

static inline void
vn_decode_VkDeviceQueueCreateInfo_temp(struct vn_cs_decoder *dec, VkDeviceQueueCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceQueueCreateInfo_pnext_temp(dec);
    vn_decode_VkDeviceQueueCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceQueueCreateInfo_handle_self(VkDeviceQueueCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->queueFamilyIndex */
    /* skip val->queueCount */
    /* skip val->pQueuePriorities */
}

static inline void
vn_replace_VkDeviceQueueCreateInfo_handle(VkDeviceQueueCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO:
            vn_replace_VkDeviceQueueCreateInfo_handle_self((VkDeviceQueueCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO:
            vn_replace_VkDeviceQueueGlobalPriorityCreateInfo_handle_self((VkDeviceQueueGlobalPriorityCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkDevicePrivateDataCreateInfo chain */

static inline void *
vn_decode_VkDevicePrivateDataCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDevicePrivateDataCreateInfo_self_temp(struct vn_cs_decoder *dec, VkDevicePrivateDataCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->privateDataSlotRequestCount);
}

static inline void
vn_decode_VkDevicePrivateDataCreateInfo_temp(struct vn_cs_decoder *dec, VkDevicePrivateDataCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDevicePrivateDataCreateInfo_pnext_temp(dec);
    vn_decode_VkDevicePrivateDataCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDevicePrivateDataCreateInfo_handle_self(VkDevicePrivateDataCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->privateDataSlotRequestCount */
}

static inline void
vn_replace_VkDevicePrivateDataCreateInfo_handle(VkDevicePrivateDataCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
            vn_replace_VkDevicePrivateDataCreateInfo_handle_self((VkDevicePrivateDataCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevicePrivateDataFeatures chain */

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePrivateDataFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->privateData);
}

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevicePrivateDataFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES });
    vn_encode_VkPhysicalDevicePrivateDataFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePrivateDataFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePrivateDataFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePrivateDataFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrivateDataFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->privateData);
}

static inline void
vn_decode_VkPhysicalDevicePrivateDataFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrivateDataFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePrivateDataFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDevicePrivateDataFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevicePrivateDataFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePrivateDataFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrivateDataFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->privateData */
}

static inline void
vn_decode_VkPhysicalDevicePrivateDataFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrivateDataFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePrivateDataFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePrivateDataFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevicePrivateDataFeatures_handle_self(VkPhysicalDevicePrivateDataFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->privateData */
}

static inline void
vn_replace_VkPhysicalDevicePrivateDataFeatures_handle(VkPhysicalDevicePrivateDataFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            vn_replace_VkPhysicalDevicePrivateDataFeatures_handle_self((VkPhysicalDevicePrivateDataFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVariablePointersFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->variablePointersStorageBuffer);
    vn_encode_VkBool32(enc, &val->variablePointers);
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceVariablePointersFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES });
    vn_encode_VkPhysicalDeviceVariablePointersFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVariablePointersFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVariablePointersFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->variablePointersStorageBuffer);
    vn_decode_VkBool32(dec, &val->variablePointers);
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVariablePointersFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVariablePointersFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVariablePointersFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVariablePointersFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVariablePointersFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVariablePointersFeatures_handle_self(VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
}

static inline void
vn_replace_VkPhysicalDeviceVariablePointersFeatures_handle(VkPhysicalDeviceVariablePointersFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_replace_VkPhysicalDeviceVariablePointersFeatures_handle_self((VkPhysicalDeviceVariablePointersFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceMultiviewFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->multiview);
    vn_encode_VkBool32(enc, &val->multiviewGeometryShader);
    vn_encode_VkBool32(enc, &val->multiviewTessellationShader);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES });
    vn_encode_VkPhysicalDeviceMultiviewFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiviewFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMultiviewFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->multiview);
    vn_decode_VkBool32(dec, &val->multiviewGeometryShader);
    vn_decode_VkBool32(dec, &val->multiviewTessellationShader);
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMultiviewFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceMultiviewFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMultiviewFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMultiviewFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMultiviewFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceMultiviewFeatures_handle_self(VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
}

static inline void
vn_replace_VkPhysicalDeviceMultiviewFeatures_handle(VkPhysicalDeviceMultiviewFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_replace_VkPhysicalDeviceMultiviewFeatures_handle_self((VkPhysicalDeviceMultiviewFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevice16BitStorageFeatures chain */

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->storageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant16);
    vn_encode_VkBool32(enc, &val->storageInputOutput16);
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevice16BitStorageFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES });
    vn_encode_VkPhysicalDevice16BitStorageFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevice16BitStorageFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevice16BitStorageFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->storageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant16);
    vn_decode_VkBool32(dec, &val->storageInputOutput16);
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDevice16BitStorageFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevice16BitStorageFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDevice16BitStorageFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevice16BitStorageFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevice16BitStorageFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevice16BitStorageFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevice16BitStorageFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevice16BitStorageFeatures_handle_self(VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
}

static inline void
vn_replace_VkPhysicalDevice16BitStorageFeatures_handle(VkPhysicalDevice16BitStorageFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice16BitStorageFeatures_handle_self((VkPhysicalDevice16BitStorageFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderSubgroupExtendedTypes);
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES });
    vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderSubgroupExtendedTypes);
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderSubgroupExtendedTypes */
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_handle_self(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderSubgroupExtendedTypes */
}

static inline void
vn_replace_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_handle(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_replace_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_handle_self((VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceSamplerYcbcrConversionFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->samplerYcbcrConversion);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES });
    vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->samplerYcbcrConversion);
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->samplerYcbcrConversion */
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceSamplerYcbcrConversionFeatures_handle_self(VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->samplerYcbcrConversion */
}

static inline void
vn_replace_VkPhysicalDeviceSamplerYcbcrConversionFeatures_handle(VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_replace_VkPhysicalDeviceSamplerYcbcrConversionFeatures_handle_self((VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceProtectedMemoryFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->protectedMemory);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES });
    vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->protectedMemory);
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->protectedMemory */
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceProtectedMemoryFeatures_handle_self(VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->protectedMemory */
}

static inline void
vn_replace_VkPhysicalDeviceProtectedMemoryFeatures_handle(VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_replace_VkPhysicalDeviceProtectedMemoryFeatures_handle_self((VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->advancedBlendCoherentOperations);
}

static inline void
vn_encode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->advancedBlendCoherentOperations);
}

static inline void
vn_decode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->advancedBlendCoherentOperations */
}

static inline void
vn_decode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_handle_self(VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->advancedBlendCoherentOperations */
}

static inline void
vn_replace_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_handle(VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_handle_self((VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceMultiDrawFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->multiDraw);
}

static inline void
vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->multiDraw);
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->multiDraw */
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceMultiDrawFeaturesEXT_handle_self(VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->multiDraw */
}

static inline void
vn_replace_VkPhysicalDeviceMultiDrawFeaturesEXT_handle(VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceMultiDrawFeaturesEXT_handle_self((VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceInlineUniformBlockFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->inlineUniformBlock);
    vn_encode_VkBool32(enc, &val->descriptorBindingInlineUniformBlockUpdateAfterBind);
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES });
    vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->inlineUniformBlock);
    vn_decode_VkBool32(dec, &val->descriptorBindingInlineUniformBlockUpdateAfterBind);
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->inlineUniformBlock */
    /* skip val->descriptorBindingInlineUniformBlockUpdateAfterBind */
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceInlineUniformBlockFeatures_handle_self(VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->inlineUniformBlock */
    /* skip val->descriptorBindingInlineUniformBlockUpdateAfterBind */
}

static inline void
vn_replace_VkPhysicalDeviceInlineUniformBlockFeatures_handle(VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            vn_replace_VkPhysicalDeviceInlineUniformBlockFeatures_handle_self((VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceMaintenance4Features chain */

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->maintenance4);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES });
    vn_encode_VkPhysicalDeviceMaintenance4Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance4Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance4Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->maintenance4);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance4Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance4Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance4Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maintenance4 */
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance4Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance4Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceMaintenance4Features_handle_self(VkPhysicalDeviceMaintenance4Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->maintenance4 */
}

static inline void
vn_replace_VkPhysicalDeviceMaintenance4Features_handle(VkPhysicalDeviceMaintenance4Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            vn_replace_VkPhysicalDeviceMaintenance4Features_handle_self((VkPhysicalDeviceMaintenance4Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceMaintenance5Features chain */

static inline void
vn_encode_VkPhysicalDeviceMaintenance5Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance5Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance5Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->maintenance5);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance5Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance5Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES });
    vn_encode_VkPhysicalDeviceMaintenance5Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance5Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance5Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance5Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance5Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->maintenance5);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance5Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance5Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance5Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance5Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance5Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance5Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance5Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maintenance5 */
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance5Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance5Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance5Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance5Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceMaintenance5Features_handle_self(VkPhysicalDeviceMaintenance5Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->maintenance5 */
}

static inline void
vn_replace_VkPhysicalDeviceMaintenance5Features_handle(VkPhysicalDeviceMaintenance5Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES:
            vn_replace_VkPhysicalDeviceMaintenance5Features_handle_self((VkPhysicalDeviceMaintenance5Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceMaintenance6Features chain */

static inline void
vn_encode_VkPhysicalDeviceMaintenance6Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance6Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance6Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->maintenance6);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance6Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance6Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES });
    vn_encode_VkPhysicalDeviceMaintenance6Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance6Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance6Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance6Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance6Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->maintenance6);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance6Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance6Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance6Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance6Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance6Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance6Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance6Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maintenance6 */
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance6Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance6Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance6Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance6Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceMaintenance6Features_handle_self(VkPhysicalDeviceMaintenance6Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->maintenance6 */
}

static inline void
vn_replace_VkPhysicalDeviceMaintenance6Features_handle(VkPhysicalDeviceMaintenance6Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES:
            vn_replace_VkPhysicalDeviceMaintenance6Features_handle_self((VkPhysicalDeviceMaintenance6Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceMaintenance7FeaturesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceMaintenance7FeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance7FeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance7FeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->maintenance7);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance7FeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance7FeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceMaintenance7FeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance7FeaturesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance7FeaturesKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance7FeaturesKHR_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance7FeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->maintenance7);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance7FeaturesKHR_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance7FeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance7FeaturesKHR_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance7FeaturesKHR_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance7FeaturesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance7FeaturesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance7FeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maintenance7 */
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance7FeaturesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance7FeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance7FeaturesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance7FeaturesKHR_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceMaintenance7FeaturesKHR_handle_self(VkPhysicalDeviceMaintenance7FeaturesKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->maintenance7 */
}

static inline void
vn_replace_VkPhysicalDeviceMaintenance7FeaturesKHR_handle(VkPhysicalDeviceMaintenance7FeaturesKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceMaintenance7FeaturesKHR_handle_self((VkPhysicalDeviceMaintenance7FeaturesKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderDrawParametersFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderDrawParameters);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES });
    vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderDrawParameters);
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderDrawParameters */
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderDrawParametersFeatures_handle_self(VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderDrawParameters */
}

static inline void
vn_replace_VkPhysicalDeviceShaderDrawParametersFeatures_handle(VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_replace_VkPhysicalDeviceShaderDrawParametersFeatures_handle_self((VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderFloat16Int8Features chain */

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderFloat16);
    vn_encode_VkBool32(enc, &val->shaderInt8);
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES });
    vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderFloat16);
    vn_decode_VkBool32(dec, &val->shaderInt8);
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderFloat16Int8Features_handle_self(VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
}

static inline void
vn_replace_VkPhysicalDeviceShaderFloat16Int8Features_handle(VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_replace_VkPhysicalDeviceShaderFloat16Int8Features_handle_self((VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceHostQueryResetFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->hostQueryReset);
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES });
    vn_encode_VkPhysicalDeviceHostQueryResetFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->hostQueryReset);
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostQueryResetFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceHostQueryResetFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->hostQueryReset */
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostQueryResetFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceHostQueryResetFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceHostQueryResetFeatures_handle_self(VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->hostQueryReset */
}

static inline void
vn_replace_VkPhysicalDeviceHostQueryResetFeatures_handle(VkPhysicalDeviceHostQueryResetFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_replace_VkPhysicalDeviceHostQueryResetFeatures_handle_self((VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceGlobalPriorityQueryFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceGlobalPriorityQueryFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceGlobalPriorityQueryFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceGlobalPriorityQueryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->globalPriorityQuery);
}

static inline void
vn_encode_VkPhysicalDeviceGlobalPriorityQueryFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceGlobalPriorityQueryFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES });
    vn_encode_VkPhysicalDeviceGlobalPriorityQueryFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceGlobalPriorityQueryFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceGlobalPriorityQueryFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceGlobalPriorityQueryFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceGlobalPriorityQueryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->globalPriorityQuery);
}

static inline void
vn_decode_VkPhysicalDeviceGlobalPriorityQueryFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceGlobalPriorityQueryFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceGlobalPriorityQueryFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceGlobalPriorityQueryFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceGlobalPriorityQueryFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceGlobalPriorityQueryFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceGlobalPriorityQueryFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->globalPriorityQuery */
}

static inline void
vn_decode_VkPhysicalDeviceGlobalPriorityQueryFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceGlobalPriorityQueryFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceGlobalPriorityQueryFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceGlobalPriorityQueryFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceGlobalPriorityQueryFeatures_handle_self(VkPhysicalDeviceGlobalPriorityQueryFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->globalPriorityQuery */
}

static inline void
vn_replace_VkPhysicalDeviceGlobalPriorityQueryFeatures_handle(VkPhysicalDeviceGlobalPriorityQueryFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES:
            vn_replace_VkPhysicalDeviceGlobalPriorityQueryFeatures_handle_self((VkPhysicalDeviceGlobalPriorityQueryFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceDescriptorIndexingFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_encode_VkBool32(enc, &val->descriptorBindingPartiallyBound);
    vn_encode_VkBool32(enc, &val->descriptorBindingVariableDescriptorCount);
    vn_encode_VkBool32(enc, &val->runtimeDescriptorArray);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES });
    vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_decode_VkBool32(dec, &val->descriptorBindingPartiallyBound);
    vn_decode_VkBool32(dec, &val->descriptorBindingVariableDescriptorCount);
    vn_decode_VkBool32(dec, &val->runtimeDescriptorArray);
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceDescriptorIndexingFeatures_handle_self(VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
}

static inline void
vn_replace_VkPhysicalDeviceDescriptorIndexingFeatures_handle(VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_replace_VkPhysicalDeviceDescriptorIndexingFeatures_handle_self((VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceTimelineSemaphoreFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->timelineSemaphore);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES });
    vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->timelineSemaphore);
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->timelineSemaphore */
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceTimelineSemaphoreFeatures_handle_self(VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->timelineSemaphore */
}

static inline void
vn_replace_VkPhysicalDeviceTimelineSemaphoreFeatures_handle(VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_replace_VkPhysicalDeviceTimelineSemaphoreFeatures_handle_self((VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevice8BitStorageFeatures chain */

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->storageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant8);
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevice8BitStorageFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES });
    vn_encode_VkPhysicalDevice8BitStorageFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevice8BitStorageFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevice8BitStorageFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->storageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant8);
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDevice8BitStorageFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevice8BitStorageFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDevice8BitStorageFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevice8BitStorageFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevice8BitStorageFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevice8BitStorageFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevice8BitStorageFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevice8BitStorageFeatures_handle_self(VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
}

static inline void
vn_replace_VkPhysicalDevice8BitStorageFeatures_handle(VkPhysicalDevice8BitStorageFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice8BitStorageFeatures_handle_self((VkPhysicalDevice8BitStorageFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceConditionalRenderingFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->conditionalRendering);
    vn_encode_VkBool32(enc, &val->inheritedConditionalRendering);
}

static inline void
vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->conditionalRendering);
    vn_decode_VkBool32(dec, &val->inheritedConditionalRendering);
}

static inline void
vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->conditionalRendering */
    /* skip val->inheritedConditionalRendering */
}

static inline void
vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceConditionalRenderingFeaturesEXT_handle_self(VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->conditionalRendering */
    /* skip val->inheritedConditionalRendering */
}

static inline void
vn_replace_VkPhysicalDeviceConditionalRenderingFeaturesEXT_handle(VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceConditionalRenderingFeaturesEXT_handle_self((VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVulkanMemoryModelFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->vulkanMemoryModel);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelDeviceScope);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelAvailabilityVisibilityChains);
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES });
    vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->vulkanMemoryModel);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelDeviceScope);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelAvailabilityVisibilityChains);
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVulkanMemoryModelFeatures_handle_self(VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
}

static inline void
vn_replace_VkPhysicalDeviceVulkanMemoryModelFeatures_handle(VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_replace_VkPhysicalDeviceVulkanMemoryModelFeatures_handle_self((VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderAtomicInt64Features chain */

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderBufferInt64Atomics);
    vn_encode_VkBool32(enc, &val->shaderSharedInt64Atomics);
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES });
    vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderBufferInt64Atomics);
    vn_decode_VkBool32(dec, &val->shaderSharedInt64Atomics);
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderAtomicInt64Features_handle_self(VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
}

static inline void
vn_replace_VkPhysicalDeviceShaderAtomicInt64Features_handle(VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_replace_VkPhysicalDeviceShaderAtomicInt64Features_handle_self((VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderBufferFloat32Atomics);
    vn_encode_VkBool32(enc, &val->shaderBufferFloat32AtomicAdd);
    vn_encode_VkBool32(enc, &val->shaderBufferFloat64Atomics);
    vn_encode_VkBool32(enc, &val->shaderBufferFloat64AtomicAdd);
    vn_encode_VkBool32(enc, &val->shaderSharedFloat32Atomics);
    vn_encode_VkBool32(enc, &val->shaderSharedFloat32AtomicAdd);
    vn_encode_VkBool32(enc, &val->shaderSharedFloat64Atomics);
    vn_encode_VkBool32(enc, &val->shaderSharedFloat64AtomicAdd);
    vn_encode_VkBool32(enc, &val->shaderImageFloat32Atomics);
    vn_encode_VkBool32(enc, &val->shaderImageFloat32AtomicAdd);
    vn_encode_VkBool32(enc, &val->sparseImageFloat32Atomics);
    vn_encode_VkBool32(enc, &val->sparseImageFloat32AtomicAdd);
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderBufferFloat32Atomics);
    vn_decode_VkBool32(dec, &val->shaderBufferFloat32AtomicAdd);
    vn_decode_VkBool32(dec, &val->shaderBufferFloat64Atomics);
    vn_decode_VkBool32(dec, &val->shaderBufferFloat64AtomicAdd);
    vn_decode_VkBool32(dec, &val->shaderSharedFloat32Atomics);
    vn_decode_VkBool32(dec, &val->shaderSharedFloat32AtomicAdd);
    vn_decode_VkBool32(dec, &val->shaderSharedFloat64Atomics);
    vn_decode_VkBool32(dec, &val->shaderSharedFloat64AtomicAdd);
    vn_decode_VkBool32(dec, &val->shaderImageFloat32Atomics);
    vn_decode_VkBool32(dec, &val->shaderImageFloat32AtomicAdd);
    vn_decode_VkBool32(dec, &val->sparseImageFloat32Atomics);
    vn_decode_VkBool32(dec, &val->sparseImageFloat32AtomicAdd);
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderBufferFloat32Atomics */
    /* skip val->shaderBufferFloat32AtomicAdd */
    /* skip val->shaderBufferFloat64Atomics */
    /* skip val->shaderBufferFloat64AtomicAdd */
    /* skip val->shaderSharedFloat32Atomics */
    /* skip val->shaderSharedFloat32AtomicAdd */
    /* skip val->shaderSharedFloat64Atomics */
    /* skip val->shaderSharedFloat64AtomicAdd */
    /* skip val->shaderImageFloat32Atomics */
    /* skip val->shaderImageFloat32AtomicAdd */
    /* skip val->sparseImageFloat32Atomics */
    /* skip val->sparseImageFloat32AtomicAdd */
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_handle_self(VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderBufferFloat32Atomics */
    /* skip val->shaderBufferFloat32AtomicAdd */
    /* skip val->shaderBufferFloat64Atomics */
    /* skip val->shaderBufferFloat64AtomicAdd */
    /* skip val->shaderSharedFloat32Atomics */
    /* skip val->shaderSharedFloat32AtomicAdd */
    /* skip val->shaderSharedFloat64Atomics */
    /* skip val->shaderSharedFloat64AtomicAdd */
    /* skip val->shaderImageFloat32Atomics */
    /* skip val->shaderImageFloat32AtomicAdd */
    /* skip val->sparseImageFloat32Atomics */
    /* skip val->sparseImageFloat32AtomicAdd */
}

static inline void
vn_replace_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_handle(VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_handle_self((VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderBufferFloat16Atomics);
    vn_encode_VkBool32(enc, &val->shaderBufferFloat16AtomicAdd);
    vn_encode_VkBool32(enc, &val->shaderBufferFloat16AtomicMinMax);
    vn_encode_VkBool32(enc, &val->shaderBufferFloat32AtomicMinMax);
    vn_encode_VkBool32(enc, &val->shaderBufferFloat64AtomicMinMax);
    vn_encode_VkBool32(enc, &val->shaderSharedFloat16Atomics);
    vn_encode_VkBool32(enc, &val->shaderSharedFloat16AtomicAdd);
    vn_encode_VkBool32(enc, &val->shaderSharedFloat16AtomicMinMax);
    vn_encode_VkBool32(enc, &val->shaderSharedFloat32AtomicMinMax);
    vn_encode_VkBool32(enc, &val->shaderSharedFloat64AtomicMinMax);
    vn_encode_VkBool32(enc, &val->shaderImageFloat32AtomicMinMax);
    vn_encode_VkBool32(enc, &val->sparseImageFloat32AtomicMinMax);
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderBufferFloat16Atomics);
    vn_decode_VkBool32(dec, &val->shaderBufferFloat16AtomicAdd);
    vn_decode_VkBool32(dec, &val->shaderBufferFloat16AtomicMinMax);
    vn_decode_VkBool32(dec, &val->shaderBufferFloat32AtomicMinMax);
    vn_decode_VkBool32(dec, &val->shaderBufferFloat64AtomicMinMax);
    vn_decode_VkBool32(dec, &val->shaderSharedFloat16Atomics);
    vn_decode_VkBool32(dec, &val->shaderSharedFloat16AtomicAdd);
    vn_decode_VkBool32(dec, &val->shaderSharedFloat16AtomicMinMax);
    vn_decode_VkBool32(dec, &val->shaderSharedFloat32AtomicMinMax);
    vn_decode_VkBool32(dec, &val->shaderSharedFloat64AtomicMinMax);
    vn_decode_VkBool32(dec, &val->shaderImageFloat32AtomicMinMax);
    vn_decode_VkBool32(dec, &val->sparseImageFloat32AtomicMinMax);
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderBufferFloat16Atomics */
    /* skip val->shaderBufferFloat16AtomicAdd */
    /* skip val->shaderBufferFloat16AtomicMinMax */
    /* skip val->shaderBufferFloat32AtomicMinMax */
    /* skip val->shaderBufferFloat64AtomicMinMax */
    /* skip val->shaderSharedFloat16Atomics */
    /* skip val->shaderSharedFloat16AtomicAdd */
    /* skip val->shaderSharedFloat16AtomicMinMax */
    /* skip val->shaderSharedFloat32AtomicMinMax */
    /* skip val->shaderSharedFloat64AtomicMinMax */
    /* skip val->shaderImageFloat32AtomicMinMax */
    /* skip val->sparseImageFloat32AtomicMinMax */
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_handle_self(VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderBufferFloat16Atomics */
    /* skip val->shaderBufferFloat16AtomicAdd */
    /* skip val->shaderBufferFloat16AtomicMinMax */
    /* skip val->shaderBufferFloat32AtomicMinMax */
    /* skip val->shaderBufferFloat64AtomicMinMax */
    /* skip val->shaderSharedFloat16Atomics */
    /* skip val->shaderSharedFloat16AtomicAdd */
    /* skip val->shaderSharedFloat16AtomicMinMax */
    /* skip val->shaderSharedFloat32AtomicMinMax */
    /* skip val->shaderSharedFloat64AtomicMinMax */
    /* skip val->shaderImageFloat32AtomicMinMax */
    /* skip val->sparseImageFloat32AtomicMinMax */
}

static inline void
vn_replace_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_handle(VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_handle_self((VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVertexAttributeDivisorFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexAttributeDivisorFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->vertexAttributeInstanceRateDivisor);
    vn_encode_VkBool32(enc, &val->vertexAttributeInstanceRateZeroDivisor);
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexAttributeDivisorFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES });
    vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->vertexAttributeInstanceRateDivisor);
    vn_decode_VkBool32(dec, &val->vertexAttributeInstanceRateZeroDivisor);
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->vertexAttributeInstanceRateDivisor */
    /* skip val->vertexAttributeInstanceRateZeroDivisor */
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVertexAttributeDivisorFeatures_handle_self(VkPhysicalDeviceVertexAttributeDivisorFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->vertexAttributeInstanceRateDivisor */
    /* skip val->vertexAttributeInstanceRateZeroDivisor */
}

static inline void
vn_replace_VkPhysicalDeviceVertexAttributeDivisorFeatures_handle(VkPhysicalDeviceVertexAttributeDivisorFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES:
            vn_replace_VkPhysicalDeviceVertexAttributeDivisorFeatures_handle_self((VkPhysicalDeviceVertexAttributeDivisorFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceTransformFeedbackFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->transformFeedback);
    vn_encode_VkBool32(enc, &val->geometryStreams);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->transformFeedback);
    vn_decode_VkBool32(dec, &val->geometryStreams);
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->transformFeedback */
    /* skip val->geometryStreams */
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceTransformFeedbackFeaturesEXT_handle_self(VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->transformFeedback */
    /* skip val->geometryStreams */
}

static inline void
vn_replace_VkPhysicalDeviceTransformFeedbackFeaturesEXT_handle(VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceTransformFeedbackFeaturesEXT_handle_self((VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->computeDerivativeGroupQuads);
    vn_encode_VkBool32(enc, &val->computeDerivativeGroupLinear);
}

static inline void
vn_encode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->computeDerivativeGroupQuads);
    vn_decode_VkBool32(dec, &val->computeDerivativeGroupLinear);
}

static inline void
vn_decode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->computeDerivativeGroupQuads */
    /* skip val->computeDerivativeGroupLinear */
}

static inline void
vn_decode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_handle_self(VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->computeDerivativeGroupQuads */
    /* skip val->computeDerivativeGroupLinear */
}

static inline void
vn_replace_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_handle(VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_handle_self((VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->fragmentShaderBarycentric);
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->fragmentShaderBarycentric);
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->fragmentShaderBarycentric */
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_handle_self(VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->fragmentShaderBarycentric */
}

static inline void
vn_replace_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_handle(VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_handle_self((VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceAccelerationStructureFeaturesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceAccelerationStructureFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->accelerationStructure);
    vn_encode_VkBool32(enc, &val->accelerationStructureCaptureReplay);
    vn_encode_VkBool32(enc, &val->accelerationStructureIndirectBuild);
    vn_encode_VkBool32(enc, &val->accelerationStructureHostCommands);
    vn_encode_VkBool32(enc, &val->descriptorBindingAccelerationStructureUpdateAfterBind);
}

static inline void
vn_encode_VkPhysicalDeviceAccelerationStructureFeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceAccelerationStructureFeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceAccelerationStructureFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->accelerationStructure);
    vn_decode_VkBool32(dec, &val->accelerationStructureCaptureReplay);
    vn_decode_VkBool32(dec, &val->accelerationStructureIndirectBuild);
    vn_decode_VkBool32(dec, &val->accelerationStructureHostCommands);
    vn_decode_VkBool32(dec, &val->descriptorBindingAccelerationStructureUpdateAfterBind);
}

static inline void
vn_decode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceAccelerationStructureFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceAccelerationStructureFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->accelerationStructure */
    /* skip val->accelerationStructureCaptureReplay */
    /* skip val->accelerationStructureIndirectBuild */
    /* skip val->accelerationStructureHostCommands */
    /* skip val->descriptorBindingAccelerationStructureUpdateAfterBind */
}

static inline void
vn_decode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceAccelerationStructureFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceAccelerationStructureFeaturesKHR_handle_self(VkPhysicalDeviceAccelerationStructureFeaturesKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->accelerationStructure */
    /* skip val->accelerationStructureCaptureReplay */
    /* skip val->accelerationStructureIndirectBuild */
    /* skip val->accelerationStructureHostCommands */
    /* skip val->descriptorBindingAccelerationStructureUpdateAfterBind */
}

static inline void
vn_replace_VkPhysicalDeviceAccelerationStructureFeaturesKHR_handle(VkPhysicalDeviceAccelerationStructureFeaturesKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceAccelerationStructureFeaturesKHR_handle_self((VkPhysicalDeviceAccelerationStructureFeaturesKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceRayTracingPipelineFeaturesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceRayTracingPipelineFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->rayTracingPipeline);
    vn_encode_VkBool32(enc, &val->rayTracingPipelineShaderGroupHandleCaptureReplay);
    vn_encode_VkBool32(enc, &val->rayTracingPipelineShaderGroupHandleCaptureReplayMixed);
    vn_encode_VkBool32(enc, &val->rayTracingPipelineTraceRaysIndirect);
    vn_encode_VkBool32(enc, &val->rayTraversalPrimitiveCulling);
}

static inline void
vn_encode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceRayTracingPipelineFeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayTracingPipelineFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->rayTracingPipeline);
    vn_decode_VkBool32(dec, &val->rayTracingPipelineShaderGroupHandleCaptureReplay);
    vn_decode_VkBool32(dec, &val->rayTracingPipelineShaderGroupHandleCaptureReplayMixed);
    vn_decode_VkBool32(dec, &val->rayTracingPipelineTraceRaysIndirect);
    vn_decode_VkBool32(dec, &val->rayTraversalPrimitiveCulling);
}

static inline void
vn_decode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayTracingPipelineFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayTracingPipelineFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->rayTracingPipeline */
    /* skip val->rayTracingPipelineShaderGroupHandleCaptureReplay */
    /* skip val->rayTracingPipelineShaderGroupHandleCaptureReplayMixed */
    /* skip val->rayTracingPipelineTraceRaysIndirect */
    /* skip val->rayTraversalPrimitiveCulling */
}

static inline void
vn_decode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayTracingPipelineFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_handle_self(VkPhysicalDeviceRayTracingPipelineFeaturesKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->rayTracingPipeline */
    /* skip val->rayTracingPipelineShaderGroupHandleCaptureReplay */
    /* skip val->rayTracingPipelineShaderGroupHandleCaptureReplayMixed */
    /* skip val->rayTracingPipelineTraceRaysIndirect */
    /* skip val->rayTraversalPrimitiveCulling */
}

static inline void
vn_replace_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_handle(VkPhysicalDeviceRayTracingPipelineFeaturesKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_handle_self((VkPhysicalDeviceRayTracingPipelineFeaturesKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceRayQueryFeaturesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceRayQueryFeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceRayQueryFeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceRayQueryFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->rayQuery);
}

static inline void
vn_encode_VkPhysicalDeviceRayQueryFeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceRayQueryFeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceRayQueryFeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceRayQueryFeaturesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRayQueryFeaturesKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRayQueryFeaturesKHR_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayQueryFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->rayQuery);
}

static inline void
vn_decode_VkPhysicalDeviceRayQueryFeaturesKHR_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayQueryFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRayQueryFeaturesKHR_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceRayQueryFeaturesKHR_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRayQueryFeaturesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRayQueryFeaturesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayQueryFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->rayQuery */
}

static inline void
vn_decode_VkPhysicalDeviceRayQueryFeaturesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayQueryFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRayQueryFeaturesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceRayQueryFeaturesKHR_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceRayQueryFeaturesKHR_handle_self(VkPhysicalDeviceRayQueryFeaturesKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->rayQuery */
}

static inline void
vn_replace_VkPhysicalDeviceRayQueryFeaturesKHR_handle(VkPhysicalDeviceRayQueryFeaturesKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceRayQueryFeaturesKHR_handle_self((VkPhysicalDeviceRayQueryFeaturesKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->rayTracingMaintenance1);
    vn_encode_VkBool32(enc, &val->rayTracingPipelineTraceRaysIndirect2);
}

static inline void
vn_encode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->rayTracingMaintenance1);
    vn_decode_VkBool32(dec, &val->rayTracingPipelineTraceRaysIndirect2);
}

static inline void
vn_decode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->rayTracingMaintenance1 */
    /* skip val->rayTracingPipelineTraceRaysIndirect2 */
}

static inline void
vn_decode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_handle_self(VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->rayTracingMaintenance1 */
    /* skip val->rayTracingPipelineTraceRaysIndirect2 */
}

static inline void
vn_replace_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_handle(VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_handle_self((VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceScalarBlockLayoutFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->scalarBlockLayout);
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES });
    vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->scalarBlockLayout);
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->scalarBlockLayout */
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceScalarBlockLayoutFeatures_handle_self(VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->scalarBlockLayout */
}

static inline void
vn_replace_VkPhysicalDeviceScalarBlockLayoutFeatures_handle(VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceScalarBlockLayoutFeatures_handle_self((VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceUniformBufferStandardLayoutFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->uniformBufferStandardLayout);
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES });
    vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->uniformBufferStandardLayout);
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->uniformBufferStandardLayout */
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_handle_self(VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->uniformBufferStandardLayout */
}

static inline void
vn_replace_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_handle(VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_handle_self((VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceDepthClipEnableFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->depthClipEnable);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->depthClipEnable);
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->depthClipEnable */
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceDepthClipEnableFeaturesEXT_handle_self(VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->depthClipEnable */
}

static inline void
vn_replace_VkPhysicalDeviceDepthClipEnableFeaturesEXT_handle(VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthClipEnableFeaturesEXT_handle_self((VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceBufferDeviceAddressFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->bufferDeviceAddress);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressCaptureReplay);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressMultiDevice);
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES });
    vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->bufferDeviceAddress);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressCaptureReplay);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressMultiDevice);
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceBufferDeviceAddressFeatures_handle_self(VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
}

static inline void
vn_replace_VkPhysicalDeviceBufferDeviceAddressFeatures_handle(VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_replace_VkPhysicalDeviceBufferDeviceAddressFeatures_handle_self((VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceBufferDeviceAddressFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->bufferDeviceAddress);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressCaptureReplay);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressMultiDevice);
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->bufferDeviceAddress);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressCaptureReplay);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressMultiDevice);
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_handle_self(VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
}

static inline void
vn_replace_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_handle(VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_handle_self((VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceImagelessFramebufferFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->imagelessFramebuffer);
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES });
    vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->imagelessFramebuffer);
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->imagelessFramebuffer */
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceImagelessFramebufferFeatures_handle_self(VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->imagelessFramebuffer */
}

static inline void
vn_replace_VkPhysicalDeviceImagelessFramebufferFeatures_handle(VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_replace_VkPhysicalDeviceImagelessFramebufferFeatures_handle_self((VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceTextureCompressionASTCHDRFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->textureCompressionASTC_HDR);
}

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES });
    vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->textureCompressionASTC_HDR);
}

static inline void
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->textureCompressionASTC_HDR */
}

static inline void
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_handle_self(VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->textureCompressionASTC_HDR */
}

static inline void
vn_replace_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_handle(VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            vn_replace_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_handle_self((VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceYcbcrImageArraysFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->ycbcrImageArrays);
}

static inline void
vn_encode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->ycbcrImageArrays);
}

static inline void
vn_decode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->ycbcrImageArrays */
}

static inline void
vn_decode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_handle_self(VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->ycbcrImageArrays */
}

static inline void
vn_replace_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_handle(VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_handle_self((VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderClockFeaturesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderSubgroupClock);
    vn_encode_VkBool32(enc, &val->shaderDeviceClock);
}

static inline void
vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderSubgroupClock);
    vn_decode_VkBool32(dec, &val->shaderDeviceClock);
}

static inline void
vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderSubgroupClock */
    /* skip val->shaderDeviceClock */
}

static inline void
vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderClockFeaturesKHR_handle_self(VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderSubgroupClock */
    /* skip val->shaderDeviceClock */
}

static inline void
vn_replace_VkPhysicalDeviceShaderClockFeaturesKHR_handle(VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderClockFeaturesKHR_handle_self((VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceIndexTypeUint8Features chain */

static inline void
vn_encode_VkPhysicalDeviceIndexTypeUint8Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceIndexTypeUint8Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceIndexTypeUint8Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->indexTypeUint8);
}

static inline void
vn_encode_VkPhysicalDeviceIndexTypeUint8Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceIndexTypeUint8Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES });
    vn_encode_VkPhysicalDeviceIndexTypeUint8Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceIndexTypeUint8Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceIndexTypeUint8Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceIndexTypeUint8Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceIndexTypeUint8Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->indexTypeUint8);
}

static inline void
vn_decode_VkPhysicalDeviceIndexTypeUint8Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceIndexTypeUint8Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceIndexTypeUint8Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceIndexTypeUint8Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceIndexTypeUint8Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceIndexTypeUint8Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceIndexTypeUint8Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->indexTypeUint8 */
}

static inline void
vn_decode_VkPhysicalDeviceIndexTypeUint8Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceIndexTypeUint8Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceIndexTypeUint8Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceIndexTypeUint8Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceIndexTypeUint8Features_handle_self(VkPhysicalDeviceIndexTypeUint8Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->indexTypeUint8 */
}

static inline void
vn_replace_VkPhysicalDeviceIndexTypeUint8Features_handle(VkPhysicalDeviceIndexTypeUint8Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES:
            vn_replace_VkPhysicalDeviceIndexTypeUint8Features_handle_self((VkPhysicalDeviceIndexTypeUint8Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->fragmentShaderSampleInterlock);
    vn_encode_VkBool32(enc, &val->fragmentShaderPixelInterlock);
    vn_encode_VkBool32(enc, &val->fragmentShaderShadingRateInterlock);
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->fragmentShaderSampleInterlock);
    vn_decode_VkBool32(dec, &val->fragmentShaderPixelInterlock);
    vn_decode_VkBool32(dec, &val->fragmentShaderShadingRateInterlock);
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->fragmentShaderSampleInterlock */
    /* skip val->fragmentShaderPixelInterlock */
    /* skip val->fragmentShaderShadingRateInterlock */
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_handle_self(VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->fragmentShaderSampleInterlock */
    /* skip val->fragmentShaderPixelInterlock */
    /* skip val->fragmentShaderShadingRateInterlock */
}

static inline void
vn_replace_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_handle(VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_handle_self((VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->separateDepthStencilLayouts);
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES });
    vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->separateDepthStencilLayouts);
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->separateDepthStencilLayouts */
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_handle_self(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->separateDepthStencilLayouts */
}

static inline void
vn_replace_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_handle(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_replace_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_handle_self((VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->primitiveTopologyListRestart);
    vn_encode_VkBool32(enc, &val->primitiveTopologyPatchListRestart);
}

static inline void
vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT });
    vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->primitiveTopologyListRestart);
    vn_decode_VkBool32(dec, &val->primitiveTopologyPatchListRestart);
}

static inline void
vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->primitiveTopologyListRestart */
    /* skip val->primitiveTopologyPatchListRestart */
}

static inline void
vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_handle_self(VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->primitiveTopologyListRestart */
    /* skip val->primitiveTopologyPatchListRestart */
}

static inline void
vn_replace_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_handle(VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
            vn_replace_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_handle_self((VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderDemoteToHelperInvocation);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES });
    vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderDemoteToHelperInvocation);
}

static inline void
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderDemoteToHelperInvocation */
}

static inline void
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_handle_self(VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderDemoteToHelperInvocation */
}

static inline void
vn_replace_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_handle(VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            vn_replace_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_handle_self((VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->texelBufferAlignment);
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->texelBufferAlignment);
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->texelBufferAlignment */
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_handle_self(VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->texelBufferAlignment */
}

static inline void
vn_replace_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_handle(VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_handle_self((VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceSubgroupSizeControlFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->subgroupSizeControl);
    vn_encode_VkBool32(enc, &val->computeFullSubgroups);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES });
    vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->subgroupSizeControl);
    vn_decode_VkBool32(dec, &val->computeFullSubgroups);
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->subgroupSizeControl */
    /* skip val->computeFullSubgroups */
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceSubgroupSizeControlFeatures_handle_self(VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->subgroupSizeControl */
    /* skip val->computeFullSubgroups */
}

static inline void
vn_replace_VkPhysicalDeviceSubgroupSizeControlFeatures_handle(VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            vn_replace_VkPhysicalDeviceSubgroupSizeControlFeatures_handle_self((VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceLineRasterizationFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceLineRasterizationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->rectangularLines);
    vn_encode_VkBool32(enc, &val->bresenhamLines);
    vn_encode_VkBool32(enc, &val->smoothLines);
    vn_encode_VkBool32(enc, &val->stippledRectangularLines);
    vn_encode_VkBool32(enc, &val->stippledBresenhamLines);
    vn_encode_VkBool32(enc, &val->stippledSmoothLines);
}

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceLineRasterizationFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES });
    vn_encode_VkPhysicalDeviceLineRasterizationFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceLineRasterizationFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceLineRasterizationFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLineRasterizationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->rectangularLines);
    vn_decode_VkBool32(dec, &val->bresenhamLines);
    vn_decode_VkBool32(dec, &val->smoothLines);
    vn_decode_VkBool32(dec, &val->stippledRectangularLines);
    vn_decode_VkBool32(dec, &val->stippledBresenhamLines);
    vn_decode_VkBool32(dec, &val->stippledSmoothLines);
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLineRasterizationFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceLineRasterizationFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceLineRasterizationFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceLineRasterizationFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLineRasterizationFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->rectangularLines */
    /* skip val->bresenhamLines */
    /* skip val->smoothLines */
    /* skip val->stippledRectangularLines */
    /* skip val->stippledBresenhamLines */
    /* skip val->stippledSmoothLines */
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLineRasterizationFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceLineRasterizationFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceLineRasterizationFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceLineRasterizationFeatures_handle_self(VkPhysicalDeviceLineRasterizationFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->rectangularLines */
    /* skip val->bresenhamLines */
    /* skip val->smoothLines */
    /* skip val->stippledRectangularLines */
    /* skip val->stippledBresenhamLines */
    /* skip val->stippledSmoothLines */
}

static inline void
vn_replace_VkPhysicalDeviceLineRasterizationFeatures_handle(VkPhysicalDeviceLineRasterizationFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES:
            vn_replace_VkPhysicalDeviceLineRasterizationFeatures_handle_self((VkPhysicalDeviceLineRasterizationFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevicePipelineCreationCacheControlFeatures chain */

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->pipelineCreationCacheControl);
}

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES });
    vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->pipelineCreationCacheControl);
}

static inline void
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->pipelineCreationCacheControl */
}

static inline void
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevicePipelineCreationCacheControlFeatures_handle_self(VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->pipelineCreationCacheControl */
}

static inline void
vn_replace_VkPhysicalDevicePipelineCreationCacheControlFeatures_handle(VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            vn_replace_VkPhysicalDevicePipelineCreationCacheControlFeatures_handle_self((VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVulkan11Features chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->storageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant16);
    vn_encode_VkBool32(enc, &val->storageInputOutput16);
    vn_encode_VkBool32(enc, &val->multiview);
    vn_encode_VkBool32(enc, &val->multiviewGeometryShader);
    vn_encode_VkBool32(enc, &val->multiviewTessellationShader);
    vn_encode_VkBool32(enc, &val->variablePointersStorageBuffer);
    vn_encode_VkBool32(enc, &val->variablePointers);
    vn_encode_VkBool32(enc, &val->protectedMemory);
    vn_encode_VkBool32(enc, &val->samplerYcbcrConversion);
    vn_encode_VkBool32(enc, &val->shaderDrawParameters);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan11Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan11Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan11Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->storageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant16);
    vn_decode_VkBool32(dec, &val->storageInputOutput16);
    vn_decode_VkBool32(dec, &val->multiview);
    vn_decode_VkBool32(dec, &val->multiviewGeometryShader);
    vn_decode_VkBool32(dec, &val->multiviewTessellationShader);
    vn_decode_VkBool32(dec, &val->variablePointersStorageBuffer);
    vn_decode_VkBool32(dec, &val->variablePointers);
    vn_decode_VkBool32(dec, &val->protectedMemory);
    vn_decode_VkBool32(dec, &val->samplerYcbcrConversion);
    vn_decode_VkBool32(dec, &val->shaderDrawParameters);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan11Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan11Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan11Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
    /* skip val->protectedMemory */
    /* skip val->samplerYcbcrConversion */
    /* skip val->shaderDrawParameters */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan11Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan11Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVulkan11Features_handle_self(VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
    /* skip val->protectedMemory */
    /* skip val->samplerYcbcrConversion */
    /* skip val->shaderDrawParameters */
}

static inline void
vn_replace_VkPhysicalDeviceVulkan11Features_handle(VkPhysicalDeviceVulkan11Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan11Features_handle_self((VkPhysicalDeviceVulkan11Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVulkan12Features chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->samplerMirrorClampToEdge);
    vn_encode_VkBool32(enc, &val->drawIndirectCount);
    vn_encode_VkBool32(enc, &val->storageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant8);
    vn_encode_VkBool32(enc, &val->shaderBufferInt64Atomics);
    vn_encode_VkBool32(enc, &val->shaderSharedInt64Atomics);
    vn_encode_VkBool32(enc, &val->shaderFloat16);
    vn_encode_VkBool32(enc, &val->shaderInt8);
    vn_encode_VkBool32(enc, &val->descriptorIndexing);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_encode_VkBool32(enc, &val->descriptorBindingPartiallyBound);
    vn_encode_VkBool32(enc, &val->descriptorBindingVariableDescriptorCount);
    vn_encode_VkBool32(enc, &val->runtimeDescriptorArray);
    vn_encode_VkBool32(enc, &val->samplerFilterMinmax);
    vn_encode_VkBool32(enc, &val->scalarBlockLayout);
    vn_encode_VkBool32(enc, &val->imagelessFramebuffer);
    vn_encode_VkBool32(enc, &val->uniformBufferStandardLayout);
    vn_encode_VkBool32(enc, &val->shaderSubgroupExtendedTypes);
    vn_encode_VkBool32(enc, &val->separateDepthStencilLayouts);
    vn_encode_VkBool32(enc, &val->hostQueryReset);
    vn_encode_VkBool32(enc, &val->timelineSemaphore);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddress);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressCaptureReplay);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressMultiDevice);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModel);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelDeviceScope);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelAvailabilityVisibilityChains);
    vn_encode_VkBool32(enc, &val->shaderOutputViewportIndex);
    vn_encode_VkBool32(enc, &val->shaderOutputLayer);
    vn_encode_VkBool32(enc, &val->subgroupBroadcastDynamicId);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan12Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan12Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan12Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->samplerMirrorClampToEdge);
    vn_decode_VkBool32(dec, &val->drawIndirectCount);
    vn_decode_VkBool32(dec, &val->storageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant8);
    vn_decode_VkBool32(dec, &val->shaderBufferInt64Atomics);
    vn_decode_VkBool32(dec, &val->shaderSharedInt64Atomics);
    vn_decode_VkBool32(dec, &val->shaderFloat16);
    vn_decode_VkBool32(dec, &val->shaderInt8);
    vn_decode_VkBool32(dec, &val->descriptorIndexing);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_decode_VkBool32(dec, &val->descriptorBindingPartiallyBound);
    vn_decode_VkBool32(dec, &val->descriptorBindingVariableDescriptorCount);
    vn_decode_VkBool32(dec, &val->runtimeDescriptorArray);
    vn_decode_VkBool32(dec, &val->samplerFilterMinmax);
    vn_decode_VkBool32(dec, &val->scalarBlockLayout);
    vn_decode_VkBool32(dec, &val->imagelessFramebuffer);
    vn_decode_VkBool32(dec, &val->uniformBufferStandardLayout);
    vn_decode_VkBool32(dec, &val->shaderSubgroupExtendedTypes);
    vn_decode_VkBool32(dec, &val->separateDepthStencilLayouts);
    vn_decode_VkBool32(dec, &val->hostQueryReset);
    vn_decode_VkBool32(dec, &val->timelineSemaphore);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddress);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressCaptureReplay);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressMultiDevice);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModel);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelDeviceScope);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelAvailabilityVisibilityChains);
    vn_decode_VkBool32(dec, &val->shaderOutputViewportIndex);
    vn_decode_VkBool32(dec, &val->shaderOutputLayer);
    vn_decode_VkBool32(dec, &val->subgroupBroadcastDynamicId);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan12Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan12Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan12Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->samplerMirrorClampToEdge */
    /* skip val->drawIndirectCount */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
    /* skip val->descriptorIndexing */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
    /* skip val->samplerFilterMinmax */
    /* skip val->scalarBlockLayout */
    /* skip val->imagelessFramebuffer */
    /* skip val->uniformBufferStandardLayout */
    /* skip val->shaderSubgroupExtendedTypes */
    /* skip val->separateDepthStencilLayouts */
    /* skip val->hostQueryReset */
    /* skip val->timelineSemaphore */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
    /* skip val->shaderOutputViewportIndex */
    /* skip val->shaderOutputLayer */
    /* skip val->subgroupBroadcastDynamicId */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan12Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan12Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVulkan12Features_handle_self(VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->samplerMirrorClampToEdge */
    /* skip val->drawIndirectCount */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
    /* skip val->descriptorIndexing */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
    /* skip val->samplerFilterMinmax */
    /* skip val->scalarBlockLayout */
    /* skip val->imagelessFramebuffer */
    /* skip val->uniformBufferStandardLayout */
    /* skip val->shaderSubgroupExtendedTypes */
    /* skip val->separateDepthStencilLayouts */
    /* skip val->hostQueryReset */
    /* skip val->timelineSemaphore */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
    /* skip val->shaderOutputViewportIndex */
    /* skip val->shaderOutputLayer */
    /* skip val->subgroupBroadcastDynamicId */
}

static inline void
vn_replace_VkPhysicalDeviceVulkan12Features_handle(VkPhysicalDeviceVulkan12Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan12Features_handle_self((VkPhysicalDeviceVulkan12Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVulkan13Features chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->robustImageAccess);
    vn_encode_VkBool32(enc, &val->inlineUniformBlock);
    vn_encode_VkBool32(enc, &val->descriptorBindingInlineUniformBlockUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->pipelineCreationCacheControl);
    vn_encode_VkBool32(enc, &val->privateData);
    vn_encode_VkBool32(enc, &val->shaderDemoteToHelperInvocation);
    vn_encode_VkBool32(enc, &val->shaderTerminateInvocation);
    vn_encode_VkBool32(enc, &val->subgroupSizeControl);
    vn_encode_VkBool32(enc, &val->computeFullSubgroups);
    vn_encode_VkBool32(enc, &val->synchronization2);
    vn_encode_VkBool32(enc, &val->textureCompressionASTC_HDR);
    vn_encode_VkBool32(enc, &val->shaderZeroInitializeWorkgroupMemory);
    vn_encode_VkBool32(enc, &val->dynamicRendering);
    vn_encode_VkBool32(enc, &val->shaderIntegerDotProduct);
    vn_encode_VkBool32(enc, &val->maintenance4);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan13Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan13Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan13Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->robustImageAccess);
    vn_decode_VkBool32(dec, &val->inlineUniformBlock);
    vn_decode_VkBool32(dec, &val->descriptorBindingInlineUniformBlockUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->pipelineCreationCacheControl);
    vn_decode_VkBool32(dec, &val->privateData);
    vn_decode_VkBool32(dec, &val->shaderDemoteToHelperInvocation);
    vn_decode_VkBool32(dec, &val->shaderTerminateInvocation);
    vn_decode_VkBool32(dec, &val->subgroupSizeControl);
    vn_decode_VkBool32(dec, &val->computeFullSubgroups);
    vn_decode_VkBool32(dec, &val->synchronization2);
    vn_decode_VkBool32(dec, &val->textureCompressionASTC_HDR);
    vn_decode_VkBool32(dec, &val->shaderZeroInitializeWorkgroupMemory);
    vn_decode_VkBool32(dec, &val->dynamicRendering);
    vn_decode_VkBool32(dec, &val->shaderIntegerDotProduct);
    vn_decode_VkBool32(dec, &val->maintenance4);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan13Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan13Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan13Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->robustImageAccess */
    /* skip val->inlineUniformBlock */
    /* skip val->descriptorBindingInlineUniformBlockUpdateAfterBind */
    /* skip val->pipelineCreationCacheControl */
    /* skip val->privateData */
    /* skip val->shaderDemoteToHelperInvocation */
    /* skip val->shaderTerminateInvocation */
    /* skip val->subgroupSizeControl */
    /* skip val->computeFullSubgroups */
    /* skip val->synchronization2 */
    /* skip val->textureCompressionASTC_HDR */
    /* skip val->shaderZeroInitializeWorkgroupMemory */
    /* skip val->dynamicRendering */
    /* skip val->shaderIntegerDotProduct */
    /* skip val->maintenance4 */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan13Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan13Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVulkan13Features_handle_self(VkPhysicalDeviceVulkan13Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->robustImageAccess */
    /* skip val->inlineUniformBlock */
    /* skip val->descriptorBindingInlineUniformBlockUpdateAfterBind */
    /* skip val->pipelineCreationCacheControl */
    /* skip val->privateData */
    /* skip val->shaderDemoteToHelperInvocation */
    /* skip val->shaderTerminateInvocation */
    /* skip val->subgroupSizeControl */
    /* skip val->computeFullSubgroups */
    /* skip val->synchronization2 */
    /* skip val->textureCompressionASTC_HDR */
    /* skip val->shaderZeroInitializeWorkgroupMemory */
    /* skip val->dynamicRendering */
    /* skip val->shaderIntegerDotProduct */
    /* skip val->maintenance4 */
}

static inline void
vn_replace_VkPhysicalDeviceVulkan13Features_handle(VkPhysicalDeviceVulkan13Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan13Features_handle_self((VkPhysicalDeviceVulkan13Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVulkan14Features chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan14Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan14Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan14Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->globalPriorityQuery);
    vn_encode_VkBool32(enc, &val->shaderSubgroupRotate);
    vn_encode_VkBool32(enc, &val->shaderSubgroupRotateClustered);
    vn_encode_VkBool32(enc, &val->shaderFloatControls2);
    vn_encode_VkBool32(enc, &val->shaderExpectAssume);
    vn_encode_VkBool32(enc, &val->rectangularLines);
    vn_encode_VkBool32(enc, &val->bresenhamLines);
    vn_encode_VkBool32(enc, &val->smoothLines);
    vn_encode_VkBool32(enc, &val->stippledRectangularLines);
    vn_encode_VkBool32(enc, &val->stippledBresenhamLines);
    vn_encode_VkBool32(enc, &val->stippledSmoothLines);
    vn_encode_VkBool32(enc, &val->vertexAttributeInstanceRateDivisor);
    vn_encode_VkBool32(enc, &val->vertexAttributeInstanceRateZeroDivisor);
    vn_encode_VkBool32(enc, &val->indexTypeUint8);
    vn_encode_VkBool32(enc, &val->dynamicRenderingLocalRead);
    vn_encode_VkBool32(enc, &val->maintenance5);
    vn_encode_VkBool32(enc, &val->maintenance6);
    vn_encode_VkBool32(enc, &val->pipelineProtectedAccess);
    vn_encode_VkBool32(enc, &val->pipelineRobustness);
    vn_encode_VkBool32(enc, &val->hostImageCopy);
    vn_encode_VkBool32(enc, &val->pushDescriptor);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan14Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan14Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan14Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan14Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan14Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan14Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan14Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->globalPriorityQuery);
    vn_decode_VkBool32(dec, &val->shaderSubgroupRotate);
    vn_decode_VkBool32(dec, &val->shaderSubgroupRotateClustered);
    vn_decode_VkBool32(dec, &val->shaderFloatControls2);
    vn_decode_VkBool32(dec, &val->shaderExpectAssume);
    vn_decode_VkBool32(dec, &val->rectangularLines);
    vn_decode_VkBool32(dec, &val->bresenhamLines);
    vn_decode_VkBool32(dec, &val->smoothLines);
    vn_decode_VkBool32(dec, &val->stippledRectangularLines);
    vn_decode_VkBool32(dec, &val->stippledBresenhamLines);
    vn_decode_VkBool32(dec, &val->stippledSmoothLines);
    vn_decode_VkBool32(dec, &val->vertexAttributeInstanceRateDivisor);
    vn_decode_VkBool32(dec, &val->vertexAttributeInstanceRateZeroDivisor);
    vn_decode_VkBool32(dec, &val->indexTypeUint8);
    vn_decode_VkBool32(dec, &val->dynamicRenderingLocalRead);
    vn_decode_VkBool32(dec, &val->maintenance5);
    vn_decode_VkBool32(dec, &val->maintenance6);
    vn_decode_VkBool32(dec, &val->pipelineProtectedAccess);
    vn_decode_VkBool32(dec, &val->pipelineRobustness);
    vn_decode_VkBool32(dec, &val->hostImageCopy);
    vn_decode_VkBool32(dec, &val->pushDescriptor);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan14Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan14Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan14Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan14Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan14Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan14Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan14Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->globalPriorityQuery */
    /* skip val->shaderSubgroupRotate */
    /* skip val->shaderSubgroupRotateClustered */
    /* skip val->shaderFloatControls2 */
    /* skip val->shaderExpectAssume */
    /* skip val->rectangularLines */
    /* skip val->bresenhamLines */
    /* skip val->smoothLines */
    /* skip val->stippledRectangularLines */
    /* skip val->stippledBresenhamLines */
    /* skip val->stippledSmoothLines */
    /* skip val->vertexAttributeInstanceRateDivisor */
    /* skip val->vertexAttributeInstanceRateZeroDivisor */
    /* skip val->indexTypeUint8 */
    /* skip val->dynamicRenderingLocalRead */
    /* skip val->maintenance5 */
    /* skip val->maintenance6 */
    /* skip val->pipelineProtectedAccess */
    /* skip val->pipelineRobustness */
    /* skip val->hostImageCopy */
    /* skip val->pushDescriptor */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan14Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan14Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan14Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan14Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVulkan14Features_handle_self(VkPhysicalDeviceVulkan14Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->globalPriorityQuery */
    /* skip val->shaderSubgroupRotate */
    /* skip val->shaderSubgroupRotateClustered */
    /* skip val->shaderFloatControls2 */
    /* skip val->shaderExpectAssume */
    /* skip val->rectangularLines */
    /* skip val->bresenhamLines */
    /* skip val->smoothLines */
    /* skip val->stippledRectangularLines */
    /* skip val->stippledBresenhamLines */
    /* skip val->stippledSmoothLines */
    /* skip val->vertexAttributeInstanceRateDivisor */
    /* skip val->vertexAttributeInstanceRateZeroDivisor */
    /* skip val->indexTypeUint8 */
    /* skip val->dynamicRenderingLocalRead */
    /* skip val->maintenance5 */
    /* skip val->maintenance6 */
    /* skip val->pipelineProtectedAccess */
    /* skip val->pipelineRobustness */
    /* skip val->hostImageCopy */
    /* skip val->pushDescriptor */
}

static inline void
vn_replace_VkPhysicalDeviceVulkan14Features_handle(VkPhysicalDeviceVulkan14Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan14Features_handle_self((VkPhysicalDeviceVulkan14Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceCustomBorderColorFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->customBorderColors);
    vn_encode_VkBool32(enc, &val->customBorderColorWithoutFormat);
}

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->customBorderColors);
    vn_decode_VkBool32(dec, &val->customBorderColorWithoutFormat);
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->customBorderColors */
    /* skip val->customBorderColorWithoutFormat */
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceCustomBorderColorFeaturesEXT_handle_self(VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->customBorderColors */
    /* skip val->customBorderColorWithoutFormat */
}

static inline void
vn_replace_VkPhysicalDeviceCustomBorderColorFeaturesEXT_handle(VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceCustomBorderColorFeaturesEXT_handle_self((VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceBorderColorSwizzleFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->borderColorSwizzle);
    vn_encode_VkBool32(enc, &val->borderColorSwizzleFromImage);
}

static inline void
vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->borderColorSwizzle);
    vn_decode_VkBool32(dec, &val->borderColorSwizzleFromImage);
}

static inline void
vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->borderColorSwizzle */
    /* skip val->borderColorSwizzleFromImage */
}

static inline void
vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_handle_self(VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->borderColorSwizzle */
    /* skip val->borderColorSwizzleFromImage */
}

static inline void
vn_replace_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_handle(VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_handle_self((VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceExtendedDynamicStateFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->extendedDynamicState);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->extendedDynamicState);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->extendedDynamicState */
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_handle_self(VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->extendedDynamicState */
}

static inline void
vn_replace_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_handle(VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_handle_self((VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceExtendedDynamicState2FeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->extendedDynamicState2);
    vn_encode_VkBool32(enc, &val->extendedDynamicState2LogicOp);
    vn_encode_VkBool32(enc, &val->extendedDynamicState2PatchControlPoints);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->extendedDynamicState2);
    vn_decode_VkBool32(dec, &val->extendedDynamicState2LogicOp);
    vn_decode_VkBool32(dec, &val->extendedDynamicState2PatchControlPoints);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->extendedDynamicState2 */
    /* skip val->extendedDynamicState2LogicOp */
    /* skip val->extendedDynamicState2PatchControlPoints */
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_handle_self(VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->extendedDynamicState2 */
    /* skip val->extendedDynamicState2LogicOp */
    /* skip val->extendedDynamicState2PatchControlPoints */
}

static inline void
vn_replace_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_handle(VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_handle_self((VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceExtendedDynamicState3FeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->extendedDynamicState3TessellationDomainOrigin);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3DepthClampEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3PolygonMode);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3RasterizationSamples);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3SampleMask);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3AlphaToCoverageEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3AlphaToOneEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3LogicOpEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ColorBlendEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ColorBlendEquation);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ColorWriteMask);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3RasterizationStream);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ConservativeRasterizationMode);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ExtraPrimitiveOverestimationSize);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3DepthClipEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3SampleLocationsEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ColorBlendAdvanced);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ProvokingVertexMode);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3LineRasterizationMode);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3LineStippleEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3DepthClipNegativeOneToOne);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ViewportWScalingEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ViewportSwizzle);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3CoverageToColorEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3CoverageToColorLocation);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3CoverageModulationMode);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3CoverageModulationTableEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3CoverageModulationTable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3CoverageReductionMode);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3RepresentativeFragmentTestEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ShadingRateImageEnable);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->extendedDynamicState3TessellationDomainOrigin);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3DepthClampEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3PolygonMode);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3RasterizationSamples);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3SampleMask);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3AlphaToCoverageEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3AlphaToOneEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3LogicOpEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ColorBlendEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ColorBlendEquation);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ColorWriteMask);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3RasterizationStream);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ConservativeRasterizationMode);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ExtraPrimitiveOverestimationSize);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3DepthClipEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3SampleLocationsEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ColorBlendAdvanced);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ProvokingVertexMode);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3LineRasterizationMode);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3LineStippleEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3DepthClipNegativeOneToOne);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ViewportWScalingEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ViewportSwizzle);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3CoverageToColorEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3CoverageToColorLocation);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3CoverageModulationMode);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3CoverageModulationTableEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3CoverageModulationTable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3CoverageReductionMode);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3RepresentativeFragmentTestEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ShadingRateImageEnable);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->extendedDynamicState3TessellationDomainOrigin */
    /* skip val->extendedDynamicState3DepthClampEnable */
    /* skip val->extendedDynamicState3PolygonMode */
    /* skip val->extendedDynamicState3RasterizationSamples */
    /* skip val->extendedDynamicState3SampleMask */
    /* skip val->extendedDynamicState3AlphaToCoverageEnable */
    /* skip val->extendedDynamicState3AlphaToOneEnable */
    /* skip val->extendedDynamicState3LogicOpEnable */
    /* skip val->extendedDynamicState3ColorBlendEnable */
    /* skip val->extendedDynamicState3ColorBlendEquation */
    /* skip val->extendedDynamicState3ColorWriteMask */
    /* skip val->extendedDynamicState3RasterizationStream */
    /* skip val->extendedDynamicState3ConservativeRasterizationMode */
    /* skip val->extendedDynamicState3ExtraPrimitiveOverestimationSize */
    /* skip val->extendedDynamicState3DepthClipEnable */
    /* skip val->extendedDynamicState3SampleLocationsEnable */
    /* skip val->extendedDynamicState3ColorBlendAdvanced */
    /* skip val->extendedDynamicState3ProvokingVertexMode */
    /* skip val->extendedDynamicState3LineRasterizationMode */
    /* skip val->extendedDynamicState3LineStippleEnable */
    /* skip val->extendedDynamicState3DepthClipNegativeOneToOne */
    /* skip val->extendedDynamicState3ViewportWScalingEnable */
    /* skip val->extendedDynamicState3ViewportSwizzle */
    /* skip val->extendedDynamicState3CoverageToColorEnable */
    /* skip val->extendedDynamicState3CoverageToColorLocation */
    /* skip val->extendedDynamicState3CoverageModulationMode */
    /* skip val->extendedDynamicState3CoverageModulationTableEnable */
    /* skip val->extendedDynamicState3CoverageModulationTable */
    /* skip val->extendedDynamicState3CoverageReductionMode */
    /* skip val->extendedDynamicState3RepresentativeFragmentTestEnable */
    /* skip val->extendedDynamicState3ShadingRateImageEnable */
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_handle_self(VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->extendedDynamicState3TessellationDomainOrigin */
    /* skip val->extendedDynamicState3DepthClampEnable */
    /* skip val->extendedDynamicState3PolygonMode */
    /* skip val->extendedDynamicState3RasterizationSamples */
    /* skip val->extendedDynamicState3SampleMask */
    /* skip val->extendedDynamicState3AlphaToCoverageEnable */
    /* skip val->extendedDynamicState3AlphaToOneEnable */
    /* skip val->extendedDynamicState3LogicOpEnable */
    /* skip val->extendedDynamicState3ColorBlendEnable */
    /* skip val->extendedDynamicState3ColorBlendEquation */
    /* skip val->extendedDynamicState3ColorWriteMask */
    /* skip val->extendedDynamicState3RasterizationStream */
    /* skip val->extendedDynamicState3ConservativeRasterizationMode */
    /* skip val->extendedDynamicState3ExtraPrimitiveOverestimationSize */
    /* skip val->extendedDynamicState3DepthClipEnable */
    /* skip val->extendedDynamicState3SampleLocationsEnable */
    /* skip val->extendedDynamicState3ColorBlendAdvanced */
    /* skip val->extendedDynamicState3ProvokingVertexMode */
    /* skip val->extendedDynamicState3LineRasterizationMode */
    /* skip val->extendedDynamicState3LineStippleEnable */
    /* skip val->extendedDynamicState3DepthClipNegativeOneToOne */
    /* skip val->extendedDynamicState3ViewportWScalingEnable */
    /* skip val->extendedDynamicState3ViewportSwizzle */
    /* skip val->extendedDynamicState3CoverageToColorEnable */
    /* skip val->extendedDynamicState3CoverageToColorLocation */
    /* skip val->extendedDynamicState3CoverageModulationMode */
    /* skip val->extendedDynamicState3CoverageModulationTableEnable */
    /* skip val->extendedDynamicState3CoverageModulationTable */
    /* skip val->extendedDynamicState3CoverageReductionMode */
    /* skip val->extendedDynamicState3RepresentativeFragmentTestEnable */
    /* skip val->extendedDynamicState3ShadingRateImageEnable */
}

static inline void
vn_replace_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_handle(VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_handle_self((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderZeroInitializeWorkgroupMemory);
}

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES });
    vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderZeroInitializeWorkgroupMemory);
}

static inline void
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderZeroInitializeWorkgroupMemory */
}

static inline void
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_handle_self(VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderZeroInitializeWorkgroupMemory */
}

static inline void
vn_replace_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_handle(VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            vn_replace_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_handle_self((VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderSubgroupUniformControlFlow);
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderSubgroupUniformControlFlow);
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderSubgroupUniformControlFlow */
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_handle_self(VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderSubgroupUniformControlFlow */
}

static inline void
vn_replace_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_handle(VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_handle_self((VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceRobustness2FeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->robustBufferAccess2);
    vn_encode_VkBool32(enc, &val->robustImageAccess2);
    vn_encode_VkBool32(enc, &val->nullDescriptor);
}

static inline void
vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->robustBufferAccess2);
    vn_decode_VkBool32(dec, &val->robustImageAccess2);
    vn_decode_VkBool32(dec, &val->nullDescriptor);
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->robustBufferAccess2 */
    /* skip val->robustImageAccess2 */
    /* skip val->nullDescriptor */
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceRobustness2FeaturesEXT_handle_self(VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->robustBufferAccess2 */
    /* skip val->robustImageAccess2 */
    /* skip val->nullDescriptor */
}

static inline void
vn_replace_VkPhysicalDeviceRobustness2FeaturesEXT_handle(VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceRobustness2FeaturesEXT_handle_self((VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceImageRobustnessFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->robustImageAccess);
}

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES });
    vn_encode_VkPhysicalDeviceImageRobustnessFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImageRobustnessFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageRobustnessFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->robustImageAccess);
}

static inline void
vn_decode_VkPhysicalDeviceImageRobustnessFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageRobustnessFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImageRobustnessFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImageRobustnessFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageRobustnessFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->robustImageAccess */
}

static inline void
vn_decode_VkPhysicalDeviceImageRobustnessFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageRobustnessFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImageRobustnessFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceImageRobustnessFeatures_handle_self(VkPhysicalDeviceImageRobustnessFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->robustImageAccess */
}

static inline void
vn_replace_VkPhysicalDeviceImageRobustnessFeatures_handle(VkPhysicalDeviceImageRobustnessFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            vn_replace_VkPhysicalDeviceImageRobustnessFeatures_handle_self((VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->workgroupMemoryExplicitLayout);
    vn_encode_VkBool32(enc, &val->workgroupMemoryExplicitLayoutScalarBlockLayout);
    vn_encode_VkBool32(enc, &val->workgroupMemoryExplicitLayout8BitAccess);
    vn_encode_VkBool32(enc, &val->workgroupMemoryExplicitLayout16BitAccess);
}

static inline void
vn_encode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->workgroupMemoryExplicitLayout);
    vn_decode_VkBool32(dec, &val->workgroupMemoryExplicitLayoutScalarBlockLayout);
    vn_decode_VkBool32(dec, &val->workgroupMemoryExplicitLayout8BitAccess);
    vn_decode_VkBool32(dec, &val->workgroupMemoryExplicitLayout16BitAccess);
}

static inline void
vn_decode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->workgroupMemoryExplicitLayout */
    /* skip val->workgroupMemoryExplicitLayoutScalarBlockLayout */
    /* skip val->workgroupMemoryExplicitLayout8BitAccess */
    /* skip val->workgroupMemoryExplicitLayout16BitAccess */
}

static inline void
vn_decode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_handle_self(VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->workgroupMemoryExplicitLayout */
    /* skip val->workgroupMemoryExplicitLayoutScalarBlockLayout */
    /* skip val->workgroupMemoryExplicitLayout8BitAccess */
    /* skip val->workgroupMemoryExplicitLayout16BitAccess */
}

static inline void
vn_replace_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_handle(VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_handle_self((VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevice4444FormatsFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->formatA4R4G4B4);
    vn_encode_VkBool32(enc, &val->formatA4B4G4R4);
}

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT });
    vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->formatA4R4G4B4);
    vn_decode_VkBool32(dec, &val->formatA4B4G4R4);
}

static inline void
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->formatA4R4G4B4 */
    /* skip val->formatA4B4G4R4 */
}

static inline void
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevice4444FormatsFeaturesEXT_handle_self(VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->formatA4R4G4B4 */
    /* skip val->formatA4B4G4R4 */
}

static inline void
vn_replace_VkPhysicalDevice4444FormatsFeaturesEXT_handle(VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            vn_replace_VkPhysicalDevice4444FormatsFeaturesEXT_handle_self((VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderImageInt64Atomics);
    vn_encode_VkBool32(enc, &val->sparseImageInt64Atomics);
}

static inline void
vn_encode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderImageInt64Atomics);
    vn_decode_VkBool32(dec, &val->sparseImageInt64Atomics);
}

static inline void
vn_decode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderImageInt64Atomics */
    /* skip val->sparseImageInt64Atomics */
}

static inline void
vn_decode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_handle_self(VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderImageInt64Atomics */
    /* skip val->sparseImageInt64Atomics */
}

static inline void
vn_replace_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_handle(VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_handle_self((VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceFragmentShadingRateFeaturesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceFragmentShadingRateFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->pipelineFragmentShadingRate);
    vn_encode_VkBool32(enc, &val->primitiveFragmentShadingRate);
    vn_encode_VkBool32(enc, &val->attachmentFragmentShadingRate);
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceFragmentShadingRateFeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShadingRateFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->pipelineFragmentShadingRate);
    vn_decode_VkBool32(dec, &val->primitiveFragmentShadingRate);
    vn_decode_VkBool32(dec, &val->attachmentFragmentShadingRate);
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShadingRateFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShadingRateFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->pipelineFragmentShadingRate */
    /* skip val->primitiveFragmentShadingRate */
    /* skip val->attachmentFragmentShadingRate */
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShadingRateFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_handle_self(VkPhysicalDeviceFragmentShadingRateFeaturesKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->pipelineFragmentShadingRate */
    /* skip val->primitiveFragmentShadingRate */
    /* skip val->attachmentFragmentShadingRate */
}

static inline void
vn_replace_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_handle(VkPhysicalDeviceFragmentShadingRateFeaturesKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_handle_self((VkPhysicalDeviceFragmentShadingRateFeaturesKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderTerminateInvocationFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderTerminateInvocation);
}

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES });
    vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderTerminateInvocation);
}

static inline void
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderTerminateInvocation */
}

static inline void
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderTerminateInvocationFeatures_handle_self(VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderTerminateInvocation */
}

static inline void
vn_replace_VkPhysicalDeviceShaderTerminateInvocationFeatures_handle(VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            vn_replace_VkPhysicalDeviceShaderTerminateInvocationFeatures_handle_self((VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceImage2DViewOf3DFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->image2DViewOf3D);
    vn_encode_VkBool32(enc, &val->sampler2DViewOf3D);
}

static inline void
vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->image2DViewOf3D);
    vn_decode_VkBool32(dec, &val->sampler2DViewOf3D);
}

static inline void
vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->image2DViewOf3D */
    /* skip val->sampler2DViewOf3D */
}

static inline void
vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_handle_self(VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->image2DViewOf3D */
    /* skip val->sampler2DViewOf3D */
}

static inline void
vn_replace_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_handle(VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_handle_self((VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->imageSlicedViewOf3D);
}

static inline void
vn_encode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->imageSlicedViewOf3D);
}

static inline void
vn_decode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->imageSlicedViewOf3D */
}

static inline void
vn_decode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_handle_self(VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->imageSlicedViewOf3D */
}

static inline void
vn_replace_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_handle(VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_handle_self((VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->attachmentFeedbackLoopDynamicState);
}

static inline void
vn_encode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->attachmentFeedbackLoopDynamicState);
}

static inline void
vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->attachmentFeedbackLoopDynamicState */
}

static inline void
vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_handle_self(VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->attachmentFeedbackLoopDynamicState */
}

static inline void
vn_replace_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_handle(VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_handle_self((VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->legacyVertexAttributes);
}

static inline void
vn_encode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->legacyVertexAttributes);
}

static inline void
vn_decode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->legacyVertexAttributes */
}

static inline void
vn_decode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_handle_self(VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->legacyVertexAttributes */
}

static inline void
vn_replace_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_handle(VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_handle_self((VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->mutableDescriptorType);
}

static inline void
vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->mutableDescriptorType);
}

static inline void
vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->mutableDescriptorType */
}

static inline void
vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_handle_self(VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->mutableDescriptorType */
}

static inline void
vn_replace_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_handle(VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_handle_self((VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceDepthClipControlFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->depthClipControl);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->depthClipControl);
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->depthClipControl */
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceDepthClipControlFeaturesEXT_handle_self(VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->depthClipControl */
}

static inline void
vn_replace_VkPhysicalDeviceDepthClipControlFeaturesEXT_handle(VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthClipControlFeaturesEXT_handle_self((VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceDepthClampControlFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceDepthClampControlFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClampControlFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClampControlFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->depthClampControl);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClampControlFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClampControlFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceDepthClampControlFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDepthClampControlFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDepthClampControlFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDepthClampControlFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClampControlFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->depthClampControl);
}

static inline void
vn_decode_VkPhysicalDeviceDepthClampControlFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClampControlFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDepthClampControlFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceDepthClampControlFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDepthClampControlFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDepthClampControlFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClampControlFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->depthClampControl */
}

static inline void
vn_decode_VkPhysicalDeviceDepthClampControlFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClampControlFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDepthClampControlFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDepthClampControlFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceDepthClampControlFeaturesEXT_handle_self(VkPhysicalDeviceDepthClampControlFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->depthClampControl */
}

static inline void
vn_replace_VkPhysicalDeviceDepthClampControlFeaturesEXT_handle(VkPhysicalDeviceDepthClampControlFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthClampControlFeaturesEXT_handle_self((VkPhysicalDeviceDepthClampControlFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->vertexInputDynamicState);
}

static inline void
vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->vertexInputDynamicState);
}

static inline void
vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->vertexInputDynamicState */
}

static inline void
vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_handle_self(VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->vertexInputDynamicState */
}

static inline void
vn_replace_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_handle(VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_handle_self((VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderRelaxedExtendedInstruction);
}

static inline void
vn_encode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderRelaxedExtendedInstruction);
}

static inline void
vn_decode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderRelaxedExtendedInstruction */
}

static inline void
vn_decode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_handle_self(VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderRelaxedExtendedInstruction */
}

static inline void
vn_replace_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_handle(VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_handle_self((VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceColorWriteEnableFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->colorWriteEnable);
}

static inline void
vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->colorWriteEnable);
}

static inline void
vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->colorWriteEnable */
}

static inline void
vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceColorWriteEnableFeaturesEXT_handle_self(VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->colorWriteEnable */
}

static inline void
vn_replace_VkPhysicalDeviceColorWriteEnableFeaturesEXT_handle(VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceColorWriteEnableFeaturesEXT_handle_self((VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceSynchronization2Features chain */

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSynchronization2Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->synchronization2);
}

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceSynchronization2Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES });
    vn_encode_VkPhysicalDeviceSynchronization2Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSynchronization2Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSynchronization2Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSynchronization2Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSynchronization2Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->synchronization2);
}

static inline void
vn_decode_VkPhysicalDeviceSynchronization2Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSynchronization2Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSynchronization2Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceSynchronization2Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSynchronization2Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSynchronization2Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSynchronization2Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->synchronization2 */
}

static inline void
vn_decode_VkPhysicalDeviceSynchronization2Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSynchronization2Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSynchronization2Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSynchronization2Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceSynchronization2Features_handle_self(VkPhysicalDeviceSynchronization2Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->synchronization2 */
}

static inline void
vn_replace_VkPhysicalDeviceSynchronization2Features_handle(VkPhysicalDeviceSynchronization2Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            vn_replace_VkPhysicalDeviceSynchronization2Features_handle_self((VkPhysicalDeviceSynchronization2Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceHostImageCopyFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceHostImageCopyFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceHostImageCopyFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostImageCopyFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->hostImageCopy);
}

static inline void
vn_encode_VkPhysicalDeviceHostImageCopyFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostImageCopyFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES });
    vn_encode_VkPhysicalDeviceHostImageCopyFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceHostImageCopyFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceHostImageCopyFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceHostImageCopyFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostImageCopyFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->hostImageCopy);
}

static inline void
vn_decode_VkPhysicalDeviceHostImageCopyFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostImageCopyFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceHostImageCopyFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceHostImageCopyFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceHostImageCopyFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceHostImageCopyFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostImageCopyFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->hostImageCopy */
}

static inline void
vn_decode_VkPhysicalDeviceHostImageCopyFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostImageCopyFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceHostImageCopyFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceHostImageCopyFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceHostImageCopyFeatures_handle_self(VkPhysicalDeviceHostImageCopyFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->hostImageCopy */
}

static inline void
vn_replace_VkPhysicalDeviceHostImageCopyFeatures_handle(VkPhysicalDeviceHostImageCopyFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES:
            vn_replace_VkPhysicalDeviceHostImageCopyFeatures_handle_self((VkPhysicalDeviceHostImageCopyFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->primitivesGeneratedQuery);
    vn_encode_VkBool32(enc, &val->primitivesGeneratedQueryWithRasterizerDiscard);
    vn_encode_VkBool32(enc, &val->primitivesGeneratedQueryWithNonZeroStreams);
}

static inline void
vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT });
    vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->primitivesGeneratedQuery);
    vn_decode_VkBool32(dec, &val->primitivesGeneratedQueryWithRasterizerDiscard);
    vn_decode_VkBool32(dec, &val->primitivesGeneratedQueryWithNonZeroStreams);
}

static inline void
vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->primitivesGeneratedQuery */
    /* skip val->primitivesGeneratedQueryWithRasterizerDiscard */
    /* skip val->primitivesGeneratedQueryWithNonZeroStreams */
}

static inline void
vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_handle_self(VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->primitivesGeneratedQuery */
    /* skip val->primitivesGeneratedQueryWithRasterizerDiscard */
    /* skip val->primitivesGeneratedQueryWithNonZeroStreams */
}

static inline void
vn_replace_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_handle(VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
            vn_replace_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_handle_self((VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceLegacyDitheringFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceLegacyDitheringFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->legacyDithering);
}

static inline void
vn_encode_VkPhysicalDeviceLegacyDitheringFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceLegacyDitheringFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLegacyDitheringFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->legacyDithering);
}

static inline void
vn_decode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLegacyDitheringFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLegacyDitheringFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->legacyDithering */
}

static inline void
vn_decode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLegacyDitheringFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceLegacyDitheringFeaturesEXT_handle_self(VkPhysicalDeviceLegacyDitheringFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->legacyDithering */
}

static inline void
vn_replace_VkPhysicalDeviceLegacyDitheringFeaturesEXT_handle(VkPhysicalDeviceLegacyDitheringFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceLegacyDitheringFeaturesEXT_handle_self((VkPhysicalDeviceLegacyDitheringFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->multisampledRenderToSingleSampled);
}

static inline void
vn_encode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->multisampledRenderToSingleSampled);
}

static inline void
vn_decode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->multisampledRenderToSingleSampled */
}

static inline void
vn_decode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_handle_self(VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->multisampledRenderToSingleSampled */
}

static inline void
vn_replace_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_handle(VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_handle_self((VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevicePipelineProtectedAccessFeatures chain */

static inline void
vn_encode_VkPhysicalDevicePipelineProtectedAccessFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePipelineProtectedAccessFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineProtectedAccessFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->pipelineProtectedAccess);
}

static inline void
vn_encode_VkPhysicalDevicePipelineProtectedAccessFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineProtectedAccessFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES });
    vn_encode_VkPhysicalDevicePipelineProtectedAccessFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePipelineProtectedAccessFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePipelineProtectedAccessFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePipelineProtectedAccessFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineProtectedAccessFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->pipelineProtectedAccess);
}

static inline void
vn_decode_VkPhysicalDevicePipelineProtectedAccessFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineProtectedAccessFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePipelineProtectedAccessFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDevicePipelineProtectedAccessFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevicePipelineProtectedAccessFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePipelineProtectedAccessFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineProtectedAccessFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->pipelineProtectedAccess */
}

static inline void
vn_decode_VkPhysicalDevicePipelineProtectedAccessFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineProtectedAccessFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePipelineProtectedAccessFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePipelineProtectedAccessFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevicePipelineProtectedAccessFeatures_handle_self(VkPhysicalDevicePipelineProtectedAccessFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->pipelineProtectedAccess */
}

static inline void
vn_replace_VkPhysicalDevicePipelineProtectedAccessFeatures_handle(VkPhysicalDevicePipelineProtectedAccessFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES:
            vn_replace_VkPhysicalDevicePipelineProtectedAccessFeatures_handle_self((VkPhysicalDevicePipelineProtectedAccessFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->ycbcr2plane444Formats);
}

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->ycbcr2plane444Formats);
}

static inline void
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->ycbcr2plane444Formats */
}

static inline void
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_handle_self(VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->ycbcr2plane444Formats */
}

static inline void
vn_replace_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_handle(VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_handle_self((VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceProvokingVertexFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->provokingVertexLast);
    vn_encode_VkBool32(enc, &val->transformFeedbackPreservesProvokingVertex);
}

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->provokingVertexLast);
    vn_decode_VkBool32(dec, &val->transformFeedbackPreservesProvokingVertex);
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->provokingVertexLast */
    /* skip val->transformFeedbackPreservesProvokingVertex */
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceProvokingVertexFeaturesEXT_handle_self(VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->provokingVertexLast */
    /* skip val->transformFeedbackPreservesProvokingVertex */
}

static inline void
vn_replace_VkPhysicalDeviceProvokingVertexFeaturesEXT_handle(VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceProvokingVertexFeaturesEXT_handle_self((VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderIntegerDotProductFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderIntegerDotProduct);
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES });
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderIntegerDotProduct);
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderIntegerDotProduct */
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderIntegerDotProductFeatures_handle_self(VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderIntegerDotProduct */
}

static inline void
vn_replace_VkPhysicalDeviceShaderIntegerDotProductFeatures_handle(VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            vn_replace_VkPhysicalDeviceShaderIntegerDotProductFeatures_handle_self((VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceDynamicRenderingFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->dynamicRendering);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES });
    vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->dynamicRendering);
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->dynamicRendering */
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceDynamicRenderingFeatures_handle_self(VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->dynamicRendering */
}

static inline void
vn_replace_VkPhysicalDeviceDynamicRenderingFeatures_handle(VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            vn_replace_VkPhysicalDeviceDynamicRenderingFeatures_handle_self((VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceImageViewMinLodFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->minLod);
}

static inline void
vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->minLod);
}

static inline void
vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->minLod */
}

static inline void
vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceImageViewMinLodFeaturesEXT_handle_self(VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->minLod */
}

static inline void
vn_replace_VkPhysicalDeviceImageViewMinLodFeaturesEXT_handle(VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceImageViewMinLodFeaturesEXT_handle_self((VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->rasterizationOrderColorAttachmentAccess);
    vn_encode_VkBool32(enc, &val->rasterizationOrderDepthAttachmentAccess);
    vn_encode_VkBool32(enc, &val->rasterizationOrderStencilAttachmentAccess);
}

static inline void
vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->rasterizationOrderColorAttachmentAccess);
    vn_decode_VkBool32(dec, &val->rasterizationOrderDepthAttachmentAccess);
    vn_decode_VkBool32(dec, &val->rasterizationOrderStencilAttachmentAccess);
}

static inline void
vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->rasterizationOrderColorAttachmentAccess */
    /* skip val->rasterizationOrderDepthAttachmentAccess */
    /* skip val->rasterizationOrderStencilAttachmentAccess */
}

static inline void
vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_handle_self(VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->rasterizationOrderColorAttachmentAccess */
    /* skip val->rasterizationOrderDepthAttachmentAccess */
    /* skip val->rasterizationOrderStencilAttachmentAccess */
}

static inline void
vn_replace_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_handle(VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_handle_self((VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->graphicsPipelineLibrary);
}

static inline void
vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->graphicsPipelineLibrary);
}

static inline void
vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->graphicsPipelineLibrary */
}

static inline void
vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_handle_self(VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->graphicsPipelineLibrary */
}

static inline void
vn_replace_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_handle(VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_handle_self((VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceNestedCommandBufferFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceNestedCommandBufferFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->nestedCommandBuffer);
    vn_encode_VkBool32(enc, &val->nestedCommandBufferRendering);
    vn_encode_VkBool32(enc, &val->nestedCommandBufferSimultaneousUse);
}

static inline void
vn_encode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceNestedCommandBufferFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceNestedCommandBufferFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->nestedCommandBuffer);
    vn_decode_VkBool32(dec, &val->nestedCommandBufferRendering);
    vn_decode_VkBool32(dec, &val->nestedCommandBufferSimultaneousUse);
}

static inline void
vn_decode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceNestedCommandBufferFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceNestedCommandBufferFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->nestedCommandBuffer */
    /* skip val->nestedCommandBufferRendering */
    /* skip val->nestedCommandBufferSimultaneousUse */
}

static inline void
vn_decode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceNestedCommandBufferFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_handle_self(VkPhysicalDeviceNestedCommandBufferFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->nestedCommandBuffer */
    /* skip val->nestedCommandBufferRendering */
    /* skip val->nestedCommandBufferSimultaneousUse */
}

static inline void
vn_replace_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_handle(VkPhysicalDeviceNestedCommandBufferFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_handle_self((VkPhysicalDeviceNestedCommandBufferFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->nonSeamlessCubeMap);
}

static inline void
vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->nonSeamlessCubeMap);
}

static inline void
vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->nonSeamlessCubeMap */
}

static inline void
vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_handle_self(VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->nonSeamlessCubeMap */
}

static inline void
vn_replace_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_handle(VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_handle_self((VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevicePipelineRobustnessFeatures chain */

static inline void
vn_encode_VkPhysicalDevicePipelineRobustnessFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePipelineRobustnessFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineRobustnessFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->pipelineRobustness);
}

static inline void
vn_encode_VkPhysicalDevicePipelineRobustnessFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineRobustnessFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES });
    vn_encode_VkPhysicalDevicePipelineRobustnessFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePipelineRobustnessFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePipelineRobustnessFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePipelineRobustnessFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineRobustnessFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->pipelineRobustness);
}

static inline void
vn_decode_VkPhysicalDevicePipelineRobustnessFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineRobustnessFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePipelineRobustnessFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDevicePipelineRobustnessFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevicePipelineRobustnessFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePipelineRobustnessFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineRobustnessFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->pipelineRobustness */
}

static inline void
vn_decode_VkPhysicalDevicePipelineRobustnessFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineRobustnessFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePipelineRobustnessFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePipelineRobustnessFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevicePipelineRobustnessFeatures_handle_self(VkPhysicalDevicePipelineRobustnessFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->pipelineRobustness */
}

static inline void
vn_replace_VkPhysicalDevicePipelineRobustnessFeatures_handle(VkPhysicalDevicePipelineRobustnessFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES:
            vn_replace_VkPhysicalDevicePipelineRobustnessFeatures_handle_self((VkPhysicalDevicePipelineRobustnessFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->attachmentFeedbackLoopLayout);
}

static inline void
vn_encode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->attachmentFeedbackLoopLayout);
}

static inline void
vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->attachmentFeedbackLoopLayout */
}

static inline void
vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_handle_self(VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->attachmentFeedbackLoopLayout */
}

static inline void
vn_replace_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_handle(VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_handle_self((VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceDepthClampZeroOneFeaturesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClampZeroOneFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->depthClampZeroOne);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClampZeroOneFeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClampZeroOneFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->depthClampZeroOne);
}

static inline void
vn_decode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClampZeroOneFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClampZeroOneFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->depthClampZeroOne */
}

static inline void
vn_decode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClampZeroOneFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_handle_self(VkPhysicalDeviceDepthClampZeroOneFeaturesKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->depthClampZeroOne */
}

static inline void
vn_replace_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_handle(VkPhysicalDeviceDepthClampZeroOneFeaturesKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_handle_self((VkPhysicalDeviceDepthClampZeroOneFeaturesKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->pipelineLibraryGroupHandles);
}

static inline void
vn_encode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT });
    vn_encode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->pipelineLibraryGroupHandles);
}

static inline void
vn_decode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->pipelineLibraryGroupHandles */
}

static inline void
vn_decode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_handle_self(VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->pipelineLibraryGroupHandles */
}

static inline void
vn_replace_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_handle(VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT:
            vn_replace_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_handle_self((VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->dynamicRenderingUnusedAttachments);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->dynamicRenderingUnusedAttachments);
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->dynamicRenderingUnusedAttachments */
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_handle_self(VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->dynamicRenderingUnusedAttachments */
}

static inline void
vn_replace_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_handle(VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_handle_self((VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceDepthBiasControlFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthBiasControlFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->depthBiasControl);
    vn_encode_VkBool32(enc, &val->leastRepresentableValueForceUnormRepresentation);
    vn_encode_VkBool32(enc, &val->floatRepresentation);
    vn_encode_VkBool32(enc, &val->depthBiasExact);
}

static inline void
vn_encode_VkPhysicalDeviceDepthBiasControlFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthBiasControlFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthBiasControlFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->depthBiasControl);
    vn_decode_VkBool32(dec, &val->leastRepresentableValueForceUnormRepresentation);
    vn_decode_VkBool32(dec, &val->floatRepresentation);
    vn_decode_VkBool32(dec, &val->depthBiasExact);
}

static inline void
vn_decode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthBiasControlFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthBiasControlFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->depthBiasControl */
    /* skip val->leastRepresentableValueForceUnormRepresentation */
    /* skip val->floatRepresentation */
    /* skip val->depthBiasExact */
}

static inline void
vn_decode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthBiasControlFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceDepthBiasControlFeaturesEXT_handle_self(VkPhysicalDeviceDepthBiasControlFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->depthBiasControl */
    /* skip val->leastRepresentableValueForceUnormRepresentation */
    /* skip val->floatRepresentation */
    /* skip val->depthBiasExact */
}

static inline void
vn_replace_VkPhysicalDeviceDepthBiasControlFeaturesEXT_handle(VkPhysicalDeviceDepthBiasControlFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthBiasControlFeaturesEXT_handle_self((VkPhysicalDeviceDepthBiasControlFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->rayTracingPositionFetch);
}

static inline void
vn_encode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->rayTracingPositionFetch);
}

static inline void
vn_decode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->rayTracingPositionFetch */
}

static inline void
vn_decode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_handle_self(VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->rayTracingPositionFetch */
}

static inline void
vn_replace_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_handle(VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_handle_self((VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderMaximalReconvergence);
}

static inline void
vn_encode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderMaximalReconvergence);
}

static inline void
vn_decode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderMaximalReconvergence */
}

static inline void
vn_decode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_handle_self(VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderMaximalReconvergence */
}

static inline void
vn_replace_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_handle(VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_handle_self((VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderSubgroupRotateFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupRotateFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupRotateFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupRotateFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderSubgroupRotate);
    vn_encode_VkBool32(enc, &val->shaderSubgroupRotateClustered);
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupRotateFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupRotateFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES });
    vn_encode_VkPhysicalDeviceShaderSubgroupRotateFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderSubgroupRotateFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderSubgroupRotateFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupRotateFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupRotateFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderSubgroupRotate);
    vn_decode_VkBool32(dec, &val->shaderSubgroupRotateClustered);
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupRotateFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupRotateFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderSubgroupRotateFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderSubgroupRotateFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderSubgroupRotateFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupRotateFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupRotateFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderSubgroupRotate */
    /* skip val->shaderSubgroupRotateClustered */
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupRotateFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupRotateFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderSubgroupRotateFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderSubgroupRotateFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderSubgroupRotateFeatures_handle_self(VkPhysicalDeviceShaderSubgroupRotateFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderSubgroupRotate */
    /* skip val->shaderSubgroupRotateClustered */
}

static inline void
vn_replace_VkPhysicalDeviceShaderSubgroupRotateFeatures_handle(VkPhysicalDeviceShaderSubgroupRotateFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES:
            vn_replace_VkPhysicalDeviceShaderSubgroupRotateFeatures_handle_self((VkPhysicalDeviceShaderSubgroupRotateFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderExpectAssumeFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceShaderExpectAssumeFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderExpectAssumeFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderExpectAssumeFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderExpectAssume);
}

static inline void
vn_encode_VkPhysicalDeviceShaderExpectAssumeFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderExpectAssumeFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES });
    vn_encode_VkPhysicalDeviceShaderExpectAssumeFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderExpectAssumeFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderExpectAssumeFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderExpectAssumeFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderExpectAssumeFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderExpectAssume);
}

static inline void
vn_decode_VkPhysicalDeviceShaderExpectAssumeFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderExpectAssumeFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderExpectAssumeFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderExpectAssumeFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderExpectAssumeFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderExpectAssumeFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderExpectAssumeFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderExpectAssume */
}

static inline void
vn_decode_VkPhysicalDeviceShaderExpectAssumeFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderExpectAssumeFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderExpectAssumeFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderExpectAssumeFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderExpectAssumeFeatures_handle_self(VkPhysicalDeviceShaderExpectAssumeFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderExpectAssume */
}

static inline void
vn_replace_VkPhysicalDeviceShaderExpectAssumeFeatures_handle(VkPhysicalDeviceShaderExpectAssumeFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES:
            vn_replace_VkPhysicalDeviceShaderExpectAssumeFeatures_handle_self((VkPhysicalDeviceShaderExpectAssumeFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderFloatControls2Features chain */

static inline void
vn_encode_VkPhysicalDeviceShaderFloatControls2Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloatControls2Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderFloatControls2Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderFloatControls2);
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloatControls2Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderFloatControls2Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES });
    vn_encode_VkPhysicalDeviceShaderFloatControls2Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderFloatControls2Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderFloatControls2Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloatControls2Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloatControls2Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderFloatControls2);
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloatControls2Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloatControls2Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderFloatControls2Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderFloatControls2Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderFloatControls2Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloatControls2Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloatControls2Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderFloatControls2 */
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloatControls2Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloatControls2Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderFloatControls2Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderFloatControls2Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderFloatControls2Features_handle_self(VkPhysicalDeviceShaderFloatControls2Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderFloatControls2 */
}

static inline void
vn_replace_VkPhysicalDeviceShaderFloatControls2Features_handle(VkPhysicalDeviceShaderFloatControls2Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES:
            vn_replace_VkPhysicalDeviceShaderFloatControls2Features_handle_self((VkPhysicalDeviceShaderFloatControls2Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceDynamicRenderingLocalReadFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingLocalReadFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->dynamicRenderingLocalRead);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingLocalReadFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES });
    vn_encode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingLocalReadFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->dynamicRenderingLocalRead);
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingLocalReadFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingLocalReadFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->dynamicRenderingLocalRead */
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingLocalReadFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_handle_self(VkPhysicalDeviceDynamicRenderingLocalReadFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->dynamicRenderingLocalRead */
}

static inline void
vn_replace_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_handle(VkPhysicalDeviceDynamicRenderingLocalReadFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES:
            vn_replace_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_handle_self((VkPhysicalDeviceDynamicRenderingLocalReadFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderQuadControlFeaturesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderQuadControlFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderQuadControl);
}

static inline void
vn_encode_VkPhysicalDeviceShaderQuadControlFeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderQuadControlFeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderQuadControlFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderQuadControl);
}

static inline void
vn_decode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderQuadControlFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderQuadControlFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderQuadControl */
}

static inline void
vn_decode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderQuadControlFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderQuadControlFeaturesKHR_handle_self(VkPhysicalDeviceShaderQuadControlFeaturesKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderQuadControl */
}

static inline void
vn_replace_VkPhysicalDeviceShaderQuadControlFeaturesKHR_handle(VkPhysicalDeviceShaderQuadControlFeaturesKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderQuadControlFeaturesKHR_handle_self((VkPhysicalDeviceShaderQuadControlFeaturesKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderReplicatedComposites);
}

static inline void
vn_encode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderReplicatedComposites);
}

static inline void
vn_decode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderReplicatedComposites */
}

static inline void
vn_decode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_handle_self(VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderReplicatedComposites */
}

static inline void
vn_replace_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_handle(VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_handle_self((VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceFeatures2 chain */

static inline void
vn_encode_VkPhysicalDeviceFeatures2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrivateDataFeatures_self(enc, (const VkPhysicalDevicePrivateDataFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVariablePointersFeatures_self(enc, (const VkPhysicalDeviceVariablePointersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiviewFeatures_self(enc, (const VkPhysicalDeviceMultiviewFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice16BitStorageFeatures_self(enc, (const VkPhysicalDevice16BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(enc, (const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(enc, (const VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self(enc, (const VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_self(enc, (const VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_self(enc, (const VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self(enc, (const VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance4Features_self(enc, (const VkPhysicalDeviceMaintenance4Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance5Features_self(enc, (const VkPhysicalDeviceMaintenance5Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance6Features_self(enc, (const VkPhysicalDeviceMaintenance6Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance7FeaturesKHR_self(enc, (const VkPhysicalDeviceMaintenance7FeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self(enc, (const VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self(enc, (const VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self(enc, (const VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceGlobalPriorityQueryFeatures_self(enc, (const VkPhysicalDeviceGlobalPriorityQueryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self(enc, (const VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(enc, (const VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice8BitStorageFeatures_self(enc, (const VkPhysicalDevice8BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self(enc, (const VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(enc, (const VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self(enc, (const VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_self(enc, (const VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_self(enc, (const VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeatures_self(enc, (const VkPhysicalDeviceVertexAttributeDivisorFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(enc, (const VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_self(enc, (const VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_self(enc, (const VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_self(enc, (const VkPhysicalDeviceAccelerationStructureFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_self(enc, (const VkPhysicalDeviceRayTracingPipelineFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRayQueryFeaturesKHR_self(enc, (const VkPhysicalDeviceRayQueryFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_self(enc, (const VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(enc, (const VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(enc, (const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self(enc, (const VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(enc, (const VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_self(enc, (const VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self(enc, (const VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(enc, (const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_self(enc, (const VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_self(enc, (const VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceIndexTypeUint8Features_self(enc, (const VkPhysicalDeviceIndexTypeUint8Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self(enc, (const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(enc, (const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self(enc, (const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(enc, (const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(enc, (const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(enc, (const VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceLineRasterizationFeatures_self(enc, (const VkPhysicalDeviceLineRasterizationFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(enc, (const VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan11Features_self(enc, (const VkPhysicalDeviceVulkan11Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan12Features_self(enc, (const VkPhysicalDeviceVulkan12Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan13Features_self(enc, (const VkPhysicalDeviceVulkan13Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan14Features_self(enc, (const VkPhysicalDeviceVulkan14Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self(enc, (const VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self(enc, (const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(enc, (const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(enc, (const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self(enc, (const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(enc, (const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_self(enc, (const VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_self(enc, (const VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self(enc, (const VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_self(enc, (const VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self(enc, (const VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_self(enc, (const VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_self(enc, (const VkPhysicalDeviceFragmentShadingRateFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(enc, (const VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self(enc, (const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_self(enc, (const VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_self(enc, (const VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_self(enc, (const VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self(enc, (const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self(enc, (const VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthClampControlFeaturesEXT_self(enc, (const VkPhysicalDeviceDepthClampControlFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self(enc, (const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_self(enc, (const VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self(enc, (const VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSynchronization2Features_self(enc, (const VkPhysicalDeviceSynchronization2Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceHostImageCopyFeatures_self(enc, (const VkPhysicalDeviceHostImageCopyFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self(enc, (const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_self(enc, (const VkPhysicalDeviceLegacyDitheringFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_self(enc, (const VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePipelineProtectedAccessFeatures_self(enc, (const VkPhysicalDevicePipelineProtectedAccessFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(enc, (const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self(enc, (const VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(enc, (const VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self(enc, (const VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self(enc, (const VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self(enc, (const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self(enc, (const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_self(enc, (const VkPhysicalDeviceNestedCommandBufferFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self(enc, (const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePipelineRobustnessFeatures_self(enc, (const VkPhysicalDevicePipelineRobustnessFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_self(enc, (const VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_self(enc, (const VkPhysicalDeviceDepthClampZeroOneFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_self(enc, (const VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self(enc, (const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_self(enc, (const VkPhysicalDeviceDepthBiasControlFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_self(enc, (const VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_self(enc, (const VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderSubgroupRotateFeatures_self(enc, (const VkPhysicalDeviceShaderSubgroupRotateFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderExpectAssumeFeatures_self(enc, (const VkPhysicalDeviceShaderExpectAssumeFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderFloatControls2Features_self(enc, (const VkPhysicalDeviceShaderFloatControls2Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_self(enc, (const VkPhysicalDeviceDynamicRenderingLocalReadFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_self(enc, (const VkPhysicalDeviceShaderQuadControlFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_self(enc, (const VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPhysicalDeviceFeatures(enc, &val->features);
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2 });
    vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFeatures2_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrivateDataFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePrivateDataFeatures_self_temp(dec, (VkPhysicalDevicePrivateDataFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVariablePointersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_temp(dec, (VkPhysicalDeviceVariablePointersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiviewFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMultiviewFeatures_self_temp(dec, (VkPhysicalDeviceMultiviewFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice16BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevice16BitStorageFeatures_self_temp(dec, (VkPhysicalDevice16BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_temp(dec, (VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSamplerYcbcrConversionFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_temp(dec, (VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProtectedMemoryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_temp(dec, (VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_self_temp(dec, (VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiDrawFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_self_temp(dec, (VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceInlineUniformBlockFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self_temp(dec, (VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance4Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance4Features_self_temp(dec, (VkPhysicalDeviceMaintenance4Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance5Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance5Features_self_temp(dec, (VkPhysicalDeviceMaintenance5Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance6Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance6Features_self_temp(dec, (VkPhysicalDeviceMaintenance6Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance7FeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance7FeaturesKHR_self_temp(dec, (VkPhysicalDeviceMaintenance7FeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderDrawParametersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_temp(dec, (VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderFloat16Int8Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_temp(dec, (VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceHostQueryResetFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_temp(dec, (VkPhysicalDeviceHostQueryResetFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceGlobalPriorityQueryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceGlobalPriorityQueryFeatures_self_temp(dec, (VkPhysicalDeviceGlobalPriorityQueryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDescriptorIndexingFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_temp(dec, (VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTimelineSemaphoreFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_temp(dec, (VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice8BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevice8BitStorageFeatures_self_temp(dec, (VkPhysicalDevice8BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceConditionalRenderingFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_temp(dec, (VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkanMemoryModelFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_temp(dec, (VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderAtomicInt64Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_temp(dec, (VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderAtomicFloatFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_self_temp(dec, (VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_self_temp(dec, (VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVertexAttributeDivisorFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeatures_self_temp(dec, (VkPhysicalDeviceVertexAttributeDivisorFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTransformFeedbackFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_temp(dec, (VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_self_temp(dec, (VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_self_temp(dec, (VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceAccelerationStructureFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_self_temp(dec, (VkPhysicalDeviceAccelerationStructureFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRayTracingPipelineFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_self_temp(dec, (VkPhysicalDeviceRayTracingPipelineFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRayQueryFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceRayQueryFeaturesKHR_self_temp(dec, (VkPhysicalDeviceRayQueryFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_self_temp(dec, (VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceScalarBlockLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_temp(dec, (VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceUniformBufferStandardLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_temp(dec, (VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClipEnableFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_temp(dec, (VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBufferDeviceAddressFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_temp(dec, (VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBufferDeviceAddressFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_self_temp(dec, (VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImagelessFramebufferFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_temp(dec, (VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTextureCompressionASTCHDRFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_temp(dec, (VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceYcbcrImageArraysFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_self_temp(dec, (VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderClockFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_self_temp(dec, (VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceIndexTypeUint8Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceIndexTypeUint8Features_self_temp(dec, (VkPhysicalDeviceIndexTypeUint8Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_temp(dec, (VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_temp(dec, (VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_temp(dec, (VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_temp(dec, (VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_temp(dec, (VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSubgroupSizeControlFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_temp(dec, (VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceLineRasterizationFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceLineRasterizationFeatures_self_temp(dec, (VkPhysicalDeviceLineRasterizationFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePipelineCreationCacheControlFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_temp(dec, (VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan11Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan11Features_self_temp(dec, (VkPhysicalDeviceVulkan11Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan12Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan12Features_self_temp(dec, (VkPhysicalDeviceVulkan12Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan13Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan13Features_self_temp(dec, (VkPhysicalDeviceVulkan13Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan14Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan14Features_self_temp(dec, (VkPhysicalDeviceVulkan14Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceCustomBorderColorFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_temp(dec, (VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBorderColorSwizzleFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_temp(dec, (VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExtendedDynamicStateFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_temp(dec, (VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExtendedDynamicState2FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_temp(dec, (VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExtendedDynamicState3FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self_temp(dec, (VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_temp(dec, (VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_self_temp(dec, (VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRobustness2FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_self_temp(dec, (VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImageRobustnessFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self_temp(dec, (VkPhysicalDeviceImageRobustnessFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_self_temp(dec, (VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice4444FormatsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self_temp(dec, (VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_self_temp(dec, (VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFragmentShadingRateFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_self_temp(dec, (VkPhysicalDeviceFragmentShadingRateFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderTerminateInvocationFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_temp(dec, (VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImage2DViewOf3DFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_temp(dec, (VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_self_temp(dec, (VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_self_temp(dec, (VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_self_temp(dec, (VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_temp(dec, (VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClipControlFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_temp(dec, (VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClampControlFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClampControlFeaturesEXT_self_temp(dec, (VkPhysicalDeviceDepthClampControlFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self_temp(dec, (VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_self_temp(dec, (VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceColorWriteEnableFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_temp(dec, (VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSynchronization2Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSynchronization2Features_self_temp(dec, (VkPhysicalDeviceSynchronization2Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceHostImageCopyFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceHostImageCopyFeatures_self_temp(dec, (VkPhysicalDeviceHostImageCopyFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_temp(dec, (VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceLegacyDitheringFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_self_temp(dec, (VkPhysicalDeviceLegacyDitheringFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_self_temp(dec, (VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePipelineProtectedAccessFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePipelineProtectedAccessFeatures_self_temp(dec, (VkPhysicalDevicePipelineProtectedAccessFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_temp(dec, (VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProvokingVertexFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_temp(dec, (VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderIntegerDotProductFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_temp(dec, (VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDynamicRenderingFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self_temp(dec, (VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImageViewMinLodFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_temp(dec, (VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_temp(dec, (VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self_temp(dec, (VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceNestedCommandBufferFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_self_temp(dec, (VkPhysicalDeviceNestedCommandBufferFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_temp(dec, (VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePipelineRobustnessFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePipelineRobustnessFeatures_self_temp(dec, (VkPhysicalDevicePipelineRobustnessFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_self_temp(dec, (VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClampZeroOneFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_self_temp(dec, (VkPhysicalDeviceDepthClampZeroOneFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_self_temp(dec, (VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_temp(dec, (VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthBiasControlFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_self_temp(dec, (VkPhysicalDeviceDepthBiasControlFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_self_temp(dec, (VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_self_temp(dec, (VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderSubgroupRotateFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderSubgroupRotateFeatures_self_temp(dec, (VkPhysicalDeviceShaderSubgroupRotateFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderExpectAssumeFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderExpectAssumeFeatures_self_temp(dec, (VkPhysicalDeviceShaderExpectAssumeFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderFloatControls2Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderFloatControls2Features_self_temp(dec, (VkPhysicalDeviceShaderFloatControls2Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDynamicRenderingLocalReadFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_self_temp(dec, (VkPhysicalDeviceDynamicRenderingLocalReadFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderQuadControlFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_self_temp(dec, (VkPhysicalDeviceShaderQuadControlFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_self_temp(dec, (VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPhysicalDeviceFeatures_temp(dec, &val->features);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceFeatures2_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrivateDataFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePrivateDataFeatures_self_partial_temp(dec, (VkPhysicalDevicePrivateDataFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVariablePointersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_partial_temp(dec, (VkPhysicalDeviceVariablePointersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiviewFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMultiviewFeatures_self_partial_temp(dec, (VkPhysicalDeviceMultiviewFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice16BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevice16BitStorageFeatures_self_partial_temp(dec, (VkPhysicalDevice16BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial_temp(dec, (VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSamplerYcbcrConversionFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial_temp(dec, (VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProtectedMemoryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_partial_temp(dec, (VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiDrawFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceInlineUniformBlockFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial_temp(dec, (VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance4Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance4Features_self_partial_temp(dec, (VkPhysicalDeviceMaintenance4Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance5Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance5Features_self_partial_temp(dec, (VkPhysicalDeviceMaintenance5Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance6Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance6Features_self_partial_temp(dec, (VkPhysicalDeviceMaintenance6Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance7FeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance7FeaturesKHR_self_partial_temp(dec, (VkPhysicalDeviceMaintenance7FeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderDrawParametersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial_temp(dec, (VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderFloat16Int8Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_partial_temp(dec, (VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceHostQueryResetFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_partial_temp(dec, (VkPhysicalDeviceHostQueryResetFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceGlobalPriorityQueryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceGlobalPriorityQueryFeatures_self_partial_temp(dec, (VkPhysicalDeviceGlobalPriorityQueryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDescriptorIndexingFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial_temp(dec, (VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTimelineSemaphoreFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial_temp(dec, (VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice8BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevice8BitStorageFeatures_self_partial_temp(dec, (VkPhysicalDevice8BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceConditionalRenderingFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkanMemoryModelFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial_temp(dec, (VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderAtomicInt64Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_partial_temp(dec, (VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderAtomicFloatFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVertexAttributeDivisorFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeatures_self_partial_temp(dec, (VkPhysicalDeviceVertexAttributeDivisorFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTransformFeedbackFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_self_partial_temp(dec, (VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_self_partial_temp(dec, (VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceAccelerationStructureFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_self_partial_temp(dec, (VkPhysicalDeviceAccelerationStructureFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRayTracingPipelineFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_self_partial_temp(dec, (VkPhysicalDeviceRayTracingPipelineFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRayQueryFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceRayQueryFeaturesKHR_self_partial_temp(dec, (VkPhysicalDeviceRayQueryFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_self_partial_temp(dec, (VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceScalarBlockLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial_temp(dec, (VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceUniformBufferStandardLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial_temp(dec, (VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClipEnableFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBufferDeviceAddressFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial_temp(dec, (VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBufferDeviceAddressFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImagelessFramebufferFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial_temp(dec, (VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTextureCompressionASTCHDRFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial_temp(dec, (VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceYcbcrImageArraysFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderClockFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_self_partial_temp(dec, (VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceIndexTypeUint8Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceIndexTypeUint8Features_self_partial_temp(dec, (VkPhysicalDeviceIndexTypeUint8Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial_temp(dec, (VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_partial_temp(dec, (VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial_temp(dec, (VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSubgroupSizeControlFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial_temp(dec, (VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceLineRasterizationFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceLineRasterizationFeatures_self_partial_temp(dec, (VkPhysicalDeviceLineRasterizationFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePipelineCreationCacheControlFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial_temp(dec, (VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan11Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan11Features_self_partial_temp(dec, (VkPhysicalDeviceVulkan11Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan12Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan12Features_self_partial_temp(dec, (VkPhysicalDeviceVulkan12Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan13Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan13Features_self_partial_temp(dec, (VkPhysicalDeviceVulkan13Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan14Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan14Features_self_partial_temp(dec, (VkPhysicalDeviceVulkan14Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceCustomBorderColorFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBorderColorSwizzleFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExtendedDynamicStateFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExtendedDynamicState2FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExtendedDynamicState3FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial_temp(dec, (VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_self_partial_temp(dec, (VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRobustness2FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImageRobustnessFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self_partial_temp(dec, (VkPhysicalDeviceImageRobustnessFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_self_partial_temp(dec, (VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice4444FormatsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial_temp(dec, (VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFragmentShadingRateFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_self_partial_temp(dec, (VkPhysicalDeviceFragmentShadingRateFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderTerminateInvocationFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial_temp(dec, (VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImage2DViewOf3DFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClipControlFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClampControlFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClampControlFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceDepthClampControlFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_self_partial_temp(dec, (VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceColorWriteEnableFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSynchronization2Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSynchronization2Features_self_partial_temp(dec, (VkPhysicalDeviceSynchronization2Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceHostImageCopyFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceHostImageCopyFeatures_self_partial_temp(dec, (VkPhysicalDeviceHostImageCopyFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_partial_temp(dec, (VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceLegacyDitheringFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceLegacyDitheringFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePipelineProtectedAccessFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePipelineProtectedAccessFeatures_self_partial_temp(dec, (VkPhysicalDevicePipelineProtectedAccessFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProvokingVertexFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderIntegerDotProductFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial_temp(dec, (VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDynamicRenderingFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self_partial_temp(dec, (VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImageViewMinLodFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceNestedCommandBufferFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceNestedCommandBufferFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePipelineRobustnessFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePipelineRobustnessFeatures_self_partial_temp(dec, (VkPhysicalDevicePipelineRobustnessFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClampZeroOneFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_self_partial_temp(dec, (VkPhysicalDeviceDepthClampZeroOneFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_self_partial_temp(dec, (VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthBiasControlFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceDepthBiasControlFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_self_partial_temp(dec, (VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_self_partial_temp(dec, (VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderSubgroupRotateFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderSubgroupRotateFeatures_self_partial_temp(dec, (VkPhysicalDeviceShaderSubgroupRotateFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderExpectAssumeFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderExpectAssumeFeatures_self_partial_temp(dec, (VkPhysicalDeviceShaderExpectAssumeFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderFloatControls2Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderFloatControls2Features_self_partial_temp(dec, (VkPhysicalDeviceShaderFloatControls2Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDynamicRenderingLocalReadFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_self_partial_temp(dec, (VkPhysicalDeviceDynamicRenderingLocalReadFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderQuadControlFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_self_partial_temp(dec, (VkPhysicalDeviceShaderQuadControlFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPhysicalDeviceFeatures_partial_temp(dec, &val->features);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceFeatures2_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceFeatures2_handle_self(VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkPhysicalDeviceFeatures_handle(&val->features);
}

static inline void
vn_replace_VkPhysicalDeviceFeatures2_handle(VkPhysicalDeviceFeatures2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
            vn_replace_VkPhysicalDeviceFeatures2_handle_self((VkPhysicalDeviceFeatures2 *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            vn_replace_VkPhysicalDevicePrivateDataFeatures_handle_self((VkPhysicalDevicePrivateDataFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_replace_VkPhysicalDeviceVariablePointersFeatures_handle_self((VkPhysicalDeviceVariablePointersFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_replace_VkPhysicalDeviceMultiviewFeatures_handle_self((VkPhysicalDeviceMultiviewFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice16BitStorageFeatures_handle_self((VkPhysicalDevice16BitStorageFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_replace_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_handle_self((VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_replace_VkPhysicalDeviceSamplerYcbcrConversionFeatures_handle_self((VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_replace_VkPhysicalDeviceProtectedMemoryFeatures_handle_self((VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_handle_self((VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceMultiDrawFeaturesEXT_handle_self((VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            vn_replace_VkPhysicalDeviceInlineUniformBlockFeatures_handle_self((VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            vn_replace_VkPhysicalDeviceMaintenance4Features_handle_self((VkPhysicalDeviceMaintenance4Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES:
            vn_replace_VkPhysicalDeviceMaintenance5Features_handle_self((VkPhysicalDeviceMaintenance5Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES:
            vn_replace_VkPhysicalDeviceMaintenance6Features_handle_self((VkPhysicalDeviceMaintenance6Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceMaintenance7FeaturesKHR_handle_self((VkPhysicalDeviceMaintenance7FeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_replace_VkPhysicalDeviceShaderDrawParametersFeatures_handle_self((VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_replace_VkPhysicalDeviceShaderFloat16Int8Features_handle_self((VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_replace_VkPhysicalDeviceHostQueryResetFeatures_handle_self((VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES:
            vn_replace_VkPhysicalDeviceGlobalPriorityQueryFeatures_handle_self((VkPhysicalDeviceGlobalPriorityQueryFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_replace_VkPhysicalDeviceDescriptorIndexingFeatures_handle_self((VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_replace_VkPhysicalDeviceTimelineSemaphoreFeatures_handle_self((VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice8BitStorageFeatures_handle_self((VkPhysicalDevice8BitStorageFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceConditionalRenderingFeaturesEXT_handle_self((VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_replace_VkPhysicalDeviceVulkanMemoryModelFeatures_handle_self((VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_replace_VkPhysicalDeviceShaderAtomicInt64Features_handle_self((VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_handle_self((VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_handle_self((VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES:
            vn_replace_VkPhysicalDeviceVertexAttributeDivisorFeatures_handle_self((VkPhysicalDeviceVertexAttributeDivisorFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceTransformFeedbackFeaturesEXT_handle_self((VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_handle_self((VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_handle_self((VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceAccelerationStructureFeaturesKHR_handle_self((VkPhysicalDeviceAccelerationStructureFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_handle_self((VkPhysicalDeviceRayTracingPipelineFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceRayQueryFeaturesKHR_handle_self((VkPhysicalDeviceRayQueryFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_handle_self((VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceScalarBlockLayoutFeatures_handle_self((VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_handle_self((VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthClipEnableFeaturesEXT_handle_self((VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_replace_VkPhysicalDeviceBufferDeviceAddressFeatures_handle_self((VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_handle_self((VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_replace_VkPhysicalDeviceImagelessFramebufferFeatures_handle_self((VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            vn_replace_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_handle_self((VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_handle_self((VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderClockFeaturesKHR_handle_self((VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES:
            vn_replace_VkPhysicalDeviceIndexTypeUint8Features_handle_self((VkPhysicalDeviceIndexTypeUint8Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_handle_self((VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_replace_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_handle_self((VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
            vn_replace_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_handle_self((VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            vn_replace_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_handle_self((VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_handle_self((VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            vn_replace_VkPhysicalDeviceSubgroupSizeControlFeatures_handle_self((VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES:
            vn_replace_VkPhysicalDeviceLineRasterizationFeatures_handle_self((VkPhysicalDeviceLineRasterizationFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            vn_replace_VkPhysicalDevicePipelineCreationCacheControlFeatures_handle_self((VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan11Features_handle_self((VkPhysicalDeviceVulkan11Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan12Features_handle_self((VkPhysicalDeviceVulkan12Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan13Features_handle_self((VkPhysicalDeviceVulkan13Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan14Features_handle_self((VkPhysicalDeviceVulkan14Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceCustomBorderColorFeaturesEXT_handle_self((VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_handle_self((VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_handle_self((VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_handle_self((VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_handle_self((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            vn_replace_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_handle_self((VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_handle_self((VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceRobustness2FeaturesEXT_handle_self((VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            vn_replace_VkPhysicalDeviceImageRobustnessFeatures_handle_self((VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_handle_self((VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            vn_replace_VkPhysicalDevice4444FormatsFeaturesEXT_handle_self((VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_handle_self((VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_handle_self((VkPhysicalDeviceFragmentShadingRateFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            vn_replace_VkPhysicalDeviceShaderTerminateInvocationFeatures_handle_self((VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_handle_self((VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_handle_self((VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_handle_self((VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_handle_self((VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_handle_self((VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthClipControlFeaturesEXT_handle_self((VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthClampControlFeaturesEXT_handle_self((VkPhysicalDeviceDepthClampControlFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_handle_self((VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_handle_self((VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceColorWriteEnableFeaturesEXT_handle_self((VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            vn_replace_VkPhysicalDeviceSynchronization2Features_handle_self((VkPhysicalDeviceSynchronization2Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES:
            vn_replace_VkPhysicalDeviceHostImageCopyFeatures_handle_self((VkPhysicalDeviceHostImageCopyFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
            vn_replace_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_handle_self((VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceLegacyDitheringFeaturesEXT_handle_self((VkPhysicalDeviceLegacyDitheringFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_handle_self((VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES:
            vn_replace_VkPhysicalDevicePipelineProtectedAccessFeatures_handle_self((VkPhysicalDevicePipelineProtectedAccessFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_handle_self((VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceProvokingVertexFeaturesEXT_handle_self((VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            vn_replace_VkPhysicalDeviceShaderIntegerDotProductFeatures_handle_self((VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            vn_replace_VkPhysicalDeviceDynamicRenderingFeatures_handle_self((VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceImageViewMinLodFeaturesEXT_handle_self((VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_handle_self((VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_handle_self((VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_handle_self((VkPhysicalDeviceNestedCommandBufferFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_handle_self((VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES:
            vn_replace_VkPhysicalDevicePipelineRobustnessFeatures_handle_self((VkPhysicalDevicePipelineRobustnessFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_handle_self((VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_handle_self((VkPhysicalDeviceDepthClampZeroOneFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT:
            vn_replace_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_handle_self((VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_handle_self((VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthBiasControlFeaturesEXT_handle_self((VkPhysicalDeviceDepthBiasControlFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_handle_self((VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_handle_self((VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES:
            vn_replace_VkPhysicalDeviceShaderSubgroupRotateFeatures_handle_self((VkPhysicalDeviceShaderSubgroupRotateFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES:
            vn_replace_VkPhysicalDeviceShaderExpectAssumeFeatures_handle_self((VkPhysicalDeviceShaderExpectAssumeFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES:
            vn_replace_VkPhysicalDeviceShaderFloatControls2Features_handle_self((VkPhysicalDeviceShaderFloatControls2Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES:
            vn_replace_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_handle_self((VkPhysicalDeviceDynamicRenderingLocalReadFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderQuadControlFeaturesKHR_handle_self((VkPhysicalDeviceShaderQuadControlFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_handle_self((VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkDeviceGroupDeviceCreateInfo chain */

static inline void *
vn_decode_VkDeviceGroupDeviceCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDeviceGroupDeviceCreateInfo_self_temp(struct vn_cs_decoder *dec, VkDeviceGroupDeviceCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->physicalDeviceCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->physicalDeviceCount);
        val->pPhysicalDevices = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pPhysicalDevices), iter_count);
        if (!val->pPhysicalDevices) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPhysicalDevice_lookup(dec, &((VkPhysicalDevice *)val->pPhysicalDevices)[i]);
    } else {
        vn_decode_array_size(dec, val->physicalDeviceCount);
        val->pPhysicalDevices = NULL;
    }
}

static inline void
vn_decode_VkDeviceGroupDeviceCreateInfo_temp(struct vn_cs_decoder *dec, VkDeviceGroupDeviceCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceGroupDeviceCreateInfo_pnext_temp(dec);
    vn_decode_VkDeviceGroupDeviceCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceGroupDeviceCreateInfo_handle_self(VkDeviceGroupDeviceCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->physicalDeviceCount */
    if (val->pPhysicalDevices) {
       for (uint32_t i = 0; i < val->physicalDeviceCount; i++)
            vn_replace_VkPhysicalDevice_handle(&((VkPhysicalDevice *)val->pPhysicalDevices)[i]);
    }
}

static inline void
vn_replace_VkDeviceGroupDeviceCreateInfo_handle(VkDeviceGroupDeviceCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
            vn_replace_VkDeviceGroupDeviceCreateInfo_handle_self((VkDeviceGroupDeviceCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkDeviceCreateInfo chain */

static inline void *
vn_decode_VkDeviceCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDevicePrivateDataCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkDevicePrivateDataCreateInfo_self_temp(dec, (VkDevicePrivateDataCreateInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrivateDataFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePrivateDataFeatures_self_temp(dec, (VkPhysicalDevicePrivateDataFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFeatures2));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceFeatures2_self_temp(dec, (VkPhysicalDeviceFeatures2 *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVariablePointersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_temp(dec, (VkPhysicalDeviceVariablePointersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiviewFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMultiviewFeatures_self_temp(dec, (VkPhysicalDeviceMultiviewFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDeviceGroupDeviceCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkDeviceGroupDeviceCreateInfo_self_temp(dec, (VkDeviceGroupDeviceCreateInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice16BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevice16BitStorageFeatures_self_temp(dec, (VkPhysicalDevice16BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_temp(dec, (VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSamplerYcbcrConversionFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_temp(dec, (VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProtectedMemoryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_temp(dec, (VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_self_temp(dec, (VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiDrawFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_self_temp(dec, (VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceInlineUniformBlockFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self_temp(dec, (VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance4Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance4Features_self_temp(dec, (VkPhysicalDeviceMaintenance4Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance5Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance5Features_self_temp(dec, (VkPhysicalDeviceMaintenance5Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance6Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance6Features_self_temp(dec, (VkPhysicalDeviceMaintenance6Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance7FeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance7FeaturesKHR_self_temp(dec, (VkPhysicalDeviceMaintenance7FeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderDrawParametersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_temp(dec, (VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderFloat16Int8Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_temp(dec, (VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceHostQueryResetFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_temp(dec, (VkPhysicalDeviceHostQueryResetFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceGlobalPriorityQueryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceGlobalPriorityQueryFeatures_self_temp(dec, (VkPhysicalDeviceGlobalPriorityQueryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDescriptorIndexingFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_temp(dec, (VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTimelineSemaphoreFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_temp(dec, (VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice8BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevice8BitStorageFeatures_self_temp(dec, (VkPhysicalDevice8BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceConditionalRenderingFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_temp(dec, (VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkanMemoryModelFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_temp(dec, (VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderAtomicInt64Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_temp(dec, (VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderAtomicFloatFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_self_temp(dec, (VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_self_temp(dec, (VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVertexAttributeDivisorFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeatures_self_temp(dec, (VkPhysicalDeviceVertexAttributeDivisorFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTransformFeedbackFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_temp(dec, (VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_self_temp(dec, (VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_self_temp(dec, (VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceAccelerationStructureFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceAccelerationStructureFeaturesKHR_self_temp(dec, (VkPhysicalDeviceAccelerationStructureFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRayTracingPipelineFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_self_temp(dec, (VkPhysicalDeviceRayTracingPipelineFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRayQueryFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceRayQueryFeaturesKHR_self_temp(dec, (VkPhysicalDeviceRayQueryFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_self_temp(dec, (VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceScalarBlockLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_temp(dec, (VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceUniformBufferStandardLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_temp(dec, (VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClipEnableFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_temp(dec, (VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBufferDeviceAddressFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_temp(dec, (VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBufferDeviceAddressFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_self_temp(dec, (VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImagelessFramebufferFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_temp(dec, (VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTextureCompressionASTCHDRFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_temp(dec, (VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceYcbcrImageArraysFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_self_temp(dec, (VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderClockFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_self_temp(dec, (VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceIndexTypeUint8Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceIndexTypeUint8Features_self_temp(dec, (VkPhysicalDeviceIndexTypeUint8Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_temp(dec, (VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_temp(dec, (VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_temp(dec, (VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_temp(dec, (VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_temp(dec, (VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSubgroupSizeControlFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_temp(dec, (VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceLineRasterizationFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceLineRasterizationFeatures_self_temp(dec, (VkPhysicalDeviceLineRasterizationFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePipelineCreationCacheControlFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_temp(dec, (VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan11Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan11Features_self_temp(dec, (VkPhysicalDeviceVulkan11Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan12Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan12Features_self_temp(dec, (VkPhysicalDeviceVulkan12Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan13Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan13Features_self_temp(dec, (VkPhysicalDeviceVulkan13Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan14Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan14Features_self_temp(dec, (VkPhysicalDeviceVulkan14Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceCustomBorderColorFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_temp(dec, (VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBorderColorSwizzleFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_temp(dec, (VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExtendedDynamicStateFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_temp(dec, (VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExtendedDynamicState2FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_temp(dec, (VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExtendedDynamicState3FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self_temp(dec, (VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_temp(dec, (VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_self_temp(dec, (VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRobustness2FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_self_temp(dec, (VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImageRobustnessFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self_temp(dec, (VkPhysicalDeviceImageRobustnessFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_self_temp(dec, (VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice4444FormatsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self_temp(dec, (VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_self_temp(dec, (VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFragmentShadingRateFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_self_temp(dec, (VkPhysicalDeviceFragmentShadingRateFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderTerminateInvocationFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_temp(dec, (VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImage2DViewOf3DFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_temp(dec, (VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_self_temp(dec, (VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_self_temp(dec, (VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_self_temp(dec, (VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_temp(dec, (VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClipControlFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_temp(dec, (VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClampControlFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClampControlFeaturesEXT_self_temp(dec, (VkPhysicalDeviceDepthClampControlFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self_temp(dec, (VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_self_temp(dec, (VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceColorWriteEnableFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_temp(dec, (VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSynchronization2Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSynchronization2Features_self_temp(dec, (VkPhysicalDeviceSynchronization2Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceHostImageCopyFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceHostImageCopyFeatures_self_temp(dec, (VkPhysicalDeviceHostImageCopyFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_temp(dec, (VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceLegacyDitheringFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceLegacyDitheringFeaturesEXT_self_temp(dec, (VkPhysicalDeviceLegacyDitheringFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_self_temp(dec, (VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePipelineProtectedAccessFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePipelineProtectedAccessFeatures_self_temp(dec, (VkPhysicalDevicePipelineProtectedAccessFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_temp(dec, (VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProvokingVertexFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_temp(dec, (VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderIntegerDotProductFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_temp(dec, (VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDynamicRenderingFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self_temp(dec, (VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImageViewMinLodFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_temp(dec, (VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_temp(dec, (VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self_temp(dec, (VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceNestedCommandBufferFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_self_temp(dec, (VkPhysicalDeviceNestedCommandBufferFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_temp(dec, (VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePipelineRobustnessFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePipelineRobustnessFeatures_self_temp(dec, (VkPhysicalDevicePipelineRobustnessFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_self_temp(dec, (VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClampZeroOneFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_self_temp(dec, (VkPhysicalDeviceDepthClampZeroOneFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_self_temp(dec, (VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_temp(dec, (VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthBiasControlFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDepthBiasControlFeaturesEXT_self_temp(dec, (VkPhysicalDeviceDepthBiasControlFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_self_temp(dec, (VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_self_temp(dec, (VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderSubgroupRotateFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderSubgroupRotateFeatures_self_temp(dec, (VkPhysicalDeviceShaderSubgroupRotateFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderExpectAssumeFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderExpectAssumeFeatures_self_temp(dec, (VkPhysicalDeviceShaderExpectAssumeFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderFloatControls2Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderFloatControls2Features_self_temp(dec, (VkPhysicalDeviceShaderFloatControls2Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDynamicRenderingLocalReadFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_self_temp(dec, (VkPhysicalDeviceDynamicRenderingLocalReadFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderQuadControlFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderQuadControlFeaturesKHR_self_temp(dec, (VkPhysicalDeviceShaderQuadControlFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_self_temp(dec, (VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkDeviceCreateInfo_self_temp(struct vn_cs_decoder *dec, VkDeviceCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->queueCreateInfoCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->queueCreateInfoCount);
        val->pQueueCreateInfos = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pQueueCreateInfos), iter_count);
        if (!val->pQueueCreateInfos) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkDeviceQueueCreateInfo_temp(dec, &((VkDeviceQueueCreateInfo *)val->pQueueCreateInfos)[i]);
    } else {
        vn_decode_array_size(dec, val->queueCreateInfoCount);
        val->pQueueCreateInfos = NULL;
    }
    vn_decode_uint32_t(dec, &val->enabledLayerCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->enabledLayerCount);
        val->ppEnabledLayerNames = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->ppEnabledLayerNames), iter_count);
        if (!val->ppEnabledLayerNames) return;
        for (uint32_t i = 0; i < iter_count; i++) {
            const size_t string_size = vn_decode_array_size_unchecked(dec);
            ((char **)val->ppEnabledLayerNames)[i] = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->ppEnabledLayerNames[i]), string_size);
            if (!val->ppEnabledLayerNames[i]) return;
            vn_decode_char_array(dec, ((char **)val->ppEnabledLayerNames)[i], string_size);
        }
    } else {
        vn_decode_array_size(dec, val->enabledLayerCount);
        val->ppEnabledLayerNames = NULL;
    }
    vn_decode_uint32_t(dec, &val->enabledExtensionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->enabledExtensionCount);
        val->ppEnabledExtensionNames = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->ppEnabledExtensionNames), iter_count);
        if (!val->ppEnabledExtensionNames) return;
        for (uint32_t i = 0; i < iter_count; i++) {
            const size_t string_size = vn_decode_array_size_unchecked(dec);
            ((char **)val->ppEnabledExtensionNames)[i] = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->ppEnabledExtensionNames[i]), string_size);
            if (!val->ppEnabledExtensionNames[i]) return;
            vn_decode_char_array(dec, ((char **)val->ppEnabledExtensionNames)[i], string_size);
        }
    } else {
        vn_decode_array_size(dec, val->enabledExtensionCount);
        val->ppEnabledExtensionNames = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pEnabledFeatures = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pEnabledFeatures));
        if (!val->pEnabledFeatures) return;
        vn_decode_VkPhysicalDeviceFeatures_temp(dec, (VkPhysicalDeviceFeatures *)val->pEnabledFeatures);
    } else {
        val->pEnabledFeatures = NULL;
    }
}

static inline void
vn_decode_VkDeviceCreateInfo_temp(struct vn_cs_decoder *dec, VkDeviceCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
    vn_decode_VkDeviceCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceCreateInfo_handle_self(VkDeviceCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->queueCreateInfoCount */
    if (val->pQueueCreateInfos) {
       for (uint32_t i = 0; i < val->queueCreateInfoCount; i++)
            vn_replace_VkDeviceQueueCreateInfo_handle(&((VkDeviceQueueCreateInfo *)val->pQueueCreateInfos)[i]);
    }
    /* skip val->enabledLayerCount */
    /* skip val->ppEnabledLayerNames */
    /* skip val->enabledExtensionCount */
    /* skip val->ppEnabledExtensionNames */
    if (val->pEnabledFeatures)
        vn_replace_VkPhysicalDeviceFeatures_handle((VkPhysicalDeviceFeatures *)val->pEnabledFeatures);
}

static inline void
vn_replace_VkDeviceCreateInfo_handle(VkDeviceCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO:
            vn_replace_VkDeviceCreateInfo_handle_self((VkDeviceCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
            vn_replace_VkDevicePrivateDataCreateInfo_handle_self((VkDevicePrivateDataCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            vn_replace_VkPhysicalDevicePrivateDataFeatures_handle_self((VkPhysicalDevicePrivateDataFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
            vn_replace_VkPhysicalDeviceFeatures2_handle_self((VkPhysicalDeviceFeatures2 *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_replace_VkPhysicalDeviceVariablePointersFeatures_handle_self((VkPhysicalDeviceVariablePointersFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_replace_VkPhysicalDeviceMultiviewFeatures_handle_self((VkPhysicalDeviceMultiviewFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
            vn_replace_VkDeviceGroupDeviceCreateInfo_handle_self((VkDeviceGroupDeviceCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice16BitStorageFeatures_handle_self((VkPhysicalDevice16BitStorageFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_replace_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_handle_self((VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_replace_VkPhysicalDeviceSamplerYcbcrConversionFeatures_handle_self((VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_replace_VkPhysicalDeviceProtectedMemoryFeatures_handle_self((VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT_handle_self((VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceMultiDrawFeaturesEXT_handle_self((VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            vn_replace_VkPhysicalDeviceInlineUniformBlockFeatures_handle_self((VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            vn_replace_VkPhysicalDeviceMaintenance4Features_handle_self((VkPhysicalDeviceMaintenance4Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES:
            vn_replace_VkPhysicalDeviceMaintenance5Features_handle_self((VkPhysicalDeviceMaintenance5Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES:
            vn_replace_VkPhysicalDeviceMaintenance6Features_handle_self((VkPhysicalDeviceMaintenance6Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceMaintenance7FeaturesKHR_handle_self((VkPhysicalDeviceMaintenance7FeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_replace_VkPhysicalDeviceShaderDrawParametersFeatures_handle_self((VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_replace_VkPhysicalDeviceShaderFloat16Int8Features_handle_self((VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_replace_VkPhysicalDeviceHostQueryResetFeatures_handle_self((VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES:
            vn_replace_VkPhysicalDeviceGlobalPriorityQueryFeatures_handle_self((VkPhysicalDeviceGlobalPriorityQueryFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_replace_VkPhysicalDeviceDescriptorIndexingFeatures_handle_self((VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_replace_VkPhysicalDeviceTimelineSemaphoreFeatures_handle_self((VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice8BitStorageFeatures_handle_self((VkPhysicalDevice8BitStorageFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceConditionalRenderingFeaturesEXT_handle_self((VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_replace_VkPhysicalDeviceVulkanMemoryModelFeatures_handle_self((VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_replace_VkPhysicalDeviceShaderAtomicInt64Features_handle_self((VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT_handle_self((VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT_handle_self((VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES:
            vn_replace_VkPhysicalDeviceVertexAttributeDivisorFeatures_handle_self((VkPhysicalDeviceVertexAttributeDivisorFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceTransformFeedbackFeaturesEXT_handle_self((VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR_handle_self((VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR_handle_self((VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceAccelerationStructureFeaturesKHR_handle_self((VkPhysicalDeviceAccelerationStructureFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceRayTracingPipelineFeaturesKHR_handle_self((VkPhysicalDeviceRayTracingPipelineFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceRayQueryFeaturesKHR_handle_self((VkPhysicalDeviceRayQueryFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR_handle_self((VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceScalarBlockLayoutFeatures_handle_self((VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_handle_self((VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthClipEnableFeaturesEXT_handle_self((VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_replace_VkPhysicalDeviceBufferDeviceAddressFeatures_handle_self((VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT_handle_self((VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_replace_VkPhysicalDeviceImagelessFramebufferFeatures_handle_self((VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            vn_replace_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_handle_self((VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT_handle_self((VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderClockFeaturesKHR_handle_self((VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES:
            vn_replace_VkPhysicalDeviceIndexTypeUint8Features_handle_self((VkPhysicalDeviceIndexTypeUint8Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_handle_self((VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_replace_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_handle_self((VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
            vn_replace_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_handle_self((VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            vn_replace_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_handle_self((VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_handle_self((VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            vn_replace_VkPhysicalDeviceSubgroupSizeControlFeatures_handle_self((VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES:
            vn_replace_VkPhysicalDeviceLineRasterizationFeatures_handle_self((VkPhysicalDeviceLineRasterizationFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            vn_replace_VkPhysicalDevicePipelineCreationCacheControlFeatures_handle_self((VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan11Features_handle_self((VkPhysicalDeviceVulkan11Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan12Features_handle_self((VkPhysicalDeviceVulkan12Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan13Features_handle_self((VkPhysicalDeviceVulkan13Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan14Features_handle_self((VkPhysicalDeviceVulkan14Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceCustomBorderColorFeaturesEXT_handle_self((VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_handle_self((VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_handle_self((VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_handle_self((VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_handle_self((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            vn_replace_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_handle_self((VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR_handle_self((VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceRobustness2FeaturesEXT_handle_self((VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            vn_replace_VkPhysicalDeviceImageRobustnessFeatures_handle_self((VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR_handle_self((VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            vn_replace_VkPhysicalDevice4444FormatsFeaturesEXT_handle_self((VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT_handle_self((VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceFragmentShadingRateFeaturesKHR_handle_self((VkPhysicalDeviceFragmentShadingRateFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            vn_replace_VkPhysicalDeviceShaderTerminateInvocationFeatures_handle_self((VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_handle_self((VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT_handle_self((VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT_handle_self((VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT_handle_self((VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_handle_self((VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthClipControlFeaturesEXT_handle_self((VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthClampControlFeaturesEXT_handle_self((VkPhysicalDeviceDepthClampControlFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_handle_self((VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR_handle_self((VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceColorWriteEnableFeaturesEXT_handle_self((VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            vn_replace_VkPhysicalDeviceSynchronization2Features_handle_self((VkPhysicalDeviceSynchronization2Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES:
            vn_replace_VkPhysicalDeviceHostImageCopyFeatures_handle_self((VkPhysicalDeviceHostImageCopyFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
            vn_replace_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_handle_self((VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceLegacyDitheringFeaturesEXT_handle_self((VkPhysicalDeviceLegacyDitheringFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT_handle_self((VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES:
            vn_replace_VkPhysicalDevicePipelineProtectedAccessFeatures_handle_self((VkPhysicalDevicePipelineProtectedAccessFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_handle_self((VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceProvokingVertexFeaturesEXT_handle_self((VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            vn_replace_VkPhysicalDeviceShaderIntegerDotProductFeatures_handle_self((VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            vn_replace_VkPhysicalDeviceDynamicRenderingFeatures_handle_self((VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceImageViewMinLodFeaturesEXT_handle_self((VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_handle_self((VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_handle_self((VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceNestedCommandBufferFeaturesEXT_handle_self((VkPhysicalDeviceNestedCommandBufferFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_handle_self((VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES:
            vn_replace_VkPhysicalDevicePipelineRobustnessFeatures_handle_self((VkPhysicalDevicePipelineRobustnessFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT_handle_self((VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR_handle_self((VkPhysicalDeviceDepthClampZeroOneFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT:
            vn_replace_VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT_handle_self((VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_handle_self((VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthBiasControlFeaturesEXT_handle_self((VkPhysicalDeviceDepthBiasControlFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR_handle_self((VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR_handle_self((VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES:
            vn_replace_VkPhysicalDeviceShaderSubgroupRotateFeatures_handle_self((VkPhysicalDeviceShaderSubgroupRotateFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES:
            vn_replace_VkPhysicalDeviceShaderExpectAssumeFeatures_handle_self((VkPhysicalDeviceShaderExpectAssumeFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES:
            vn_replace_VkPhysicalDeviceShaderFloatControls2Features_handle_self((VkPhysicalDeviceShaderFloatControls2Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES:
            vn_replace_VkPhysicalDeviceDynamicRenderingLocalReadFeatures_handle_self((VkPhysicalDeviceDynamicRenderingLocalReadFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderQuadControlFeaturesKHR_handle_self((VkPhysicalDeviceShaderQuadControlFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT_handle_self((VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceMultiDrawPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiDrawPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxMultiDrawCount);
}

static inline void
vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiDrawPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiDrawPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxMultiDrawCount */
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiDrawPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDevicePushDescriptorProperties chain */

static inline void
vn_encode_VkPhysicalDevicePushDescriptorProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePushDescriptorProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePushDescriptorProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxPushDescriptors);
}

static inline void
vn_encode_VkPhysicalDevicePushDescriptorProperties(struct vn_cs_encoder *enc, const VkPhysicalDevicePushDescriptorProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES });
    vn_encode_VkPhysicalDevicePushDescriptorProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePushDescriptorProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePushDescriptorProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePushDescriptorProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePushDescriptorProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxPushDescriptors */
}

static inline void
vn_decode_VkPhysicalDevicePushDescriptorProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePushDescriptorProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePushDescriptorProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePushDescriptorProperties_self_partial_temp(dec, val);
}

/* struct VkConformanceVersion */

static inline void
vn_encode_VkConformanceVersion(struct vn_cs_encoder *enc, const VkConformanceVersion *val)
{
    vn_encode_uint8_t(enc, &val->major);
    vn_encode_uint8_t(enc, &val->minor);
    vn_encode_uint8_t(enc, &val->subminor);
    vn_encode_uint8_t(enc, &val->patch);
}

static inline void
vn_decode_VkConformanceVersion_partial_temp(struct vn_cs_decoder *dec, VkConformanceVersion *val)
{
    /* skip val->major */
    /* skip val->minor */
    /* skip val->subminor */
    /* skip val->patch */
}

/* struct VkPhysicalDeviceDriverProperties chain */

static inline void
vn_encode_VkPhysicalDeviceDriverProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDriverProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDriverProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDriverId(enc, &val->driverID);
    vn_encode_array_size(enc, VK_MAX_DRIVER_NAME_SIZE);
    vn_encode_char_array(enc, val->driverName, VK_MAX_DRIVER_NAME_SIZE);
    vn_encode_array_size(enc, VK_MAX_DRIVER_INFO_SIZE);
    vn_encode_char_array(enc, val->driverInfo, VK_MAX_DRIVER_INFO_SIZE);
    vn_encode_VkConformanceVersion(enc, &val->conformanceVersion);
}

static inline void
vn_encode_VkPhysicalDeviceDriverProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceDriverProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES });
    vn_encode_VkPhysicalDeviceDriverProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDriverProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDriverProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDriverProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDriverProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->driverID */
    /* skip val->driverName */
    /* skip val->driverInfo */
    vn_decode_VkConformanceVersion_partial_temp(dec, &val->conformanceVersion);
}

static inline void
vn_decode_VkPhysicalDeviceDriverProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDriverProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDriverProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDriverProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceIDProperties chain */

static inline void
vn_encode_VkPhysicalDeviceIDProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceIDProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceIDProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_array_size(enc, VK_UUID_SIZE);
    vn_encode_uint8_t_array(enc, val->deviceUUID, VK_UUID_SIZE);
    vn_encode_array_size(enc, VK_UUID_SIZE);
    vn_encode_uint8_t_array(enc, val->driverUUID, VK_UUID_SIZE);
    vn_encode_array_size(enc, VK_LUID_SIZE);
    vn_encode_uint8_t_array(enc, val->deviceLUID, VK_LUID_SIZE);
    vn_encode_uint32_t(enc, &val->deviceNodeMask);
    vn_encode_VkBool32(enc, &val->deviceLUIDValid);
}

static inline void
vn_encode_VkPhysicalDeviceIDProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceIDProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES });
    vn_encode_VkPhysicalDeviceIDProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceIDProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceIDProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceIDProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceIDProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->deviceUUID */
    /* skip val->driverUUID */
    /* skip val->deviceLUID */
    /* skip val->deviceNodeMask */
    /* skip val->deviceLUIDValid */
}

static inline void
vn_decode_VkPhysicalDeviceIDProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceIDProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceIDProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceIDProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceMultiviewProperties chain */

static inline void
vn_encode_VkPhysicalDeviceMultiviewProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxMultiviewViewCount);
    vn_encode_uint32_t(enc, &val->maxMultiviewInstanceIndex);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES });
    vn_encode_VkPhysicalDeviceMultiviewProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiviewProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMultiviewProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxMultiviewViewCount */
    /* skip val->maxMultiviewInstanceIndex */
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMultiviewProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMultiviewProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceSubgroupProperties chain */

static inline void
vn_encode_VkPhysicalDeviceSubgroupProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->subgroupSize);
    vn_encode_VkFlags(enc, &val->supportedStages);
    vn_encode_VkFlags(enc, &val->supportedOperations);
    vn_encode_VkBool32(enc, &val->quadOperationsInAllStages);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES });
    vn_encode_VkPhysicalDeviceSubgroupProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSubgroupProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSubgroupProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->subgroupSize */
    /* skip val->supportedStages */
    /* skip val->supportedOperations */
    /* skip val->quadOperationsInAllStages */
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSubgroupProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSubgroupProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDevicePointClippingProperties chain */

static inline void
vn_encode_VkPhysicalDevicePointClippingProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePointClippingProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePointClippingProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPointClippingBehavior(enc, &val->pointClippingBehavior);
}

static inline void
vn_encode_VkPhysicalDevicePointClippingProperties(struct vn_cs_encoder *enc, const VkPhysicalDevicePointClippingProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES });
    vn_encode_VkPhysicalDevicePointClippingProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePointClippingProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePointClippingProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePointClippingProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePointClippingProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->pointClippingBehavior */
}

static inline void
vn_decode_VkPhysicalDevicePointClippingProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePointClippingProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePointClippingProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePointClippingProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceProtectedMemoryProperties chain */

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->protectedNoFault);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES });
    vn_encode_VkPhysicalDeviceProtectedMemoryProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProtectedMemoryProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProtectedMemoryProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->protectedNoFault */
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceProtectedMemoryProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceProtectedMemoryProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceSamplerFilterMinmaxProperties chain */

static inline void
vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->filterMinmaxSingleComponentFormats);
    vn_encode_VkBool32(enc, &val->filterMinmaxImageComponentMapping);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES });
    vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->filterMinmaxSingleComponentFormats */
    /* skip val->filterMinmaxImageComponentMapping */
}

static inline void
vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceSampleLocationsPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceSampleLocationsPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSampleLocationsPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSampleLocationsPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->sampleLocationSampleCounts);
    vn_encode_VkExtent2D(enc, &val->maxSampleLocationGridSize);
    vn_encode_array_size(enc, 2);
    vn_encode_float_array(enc, val->sampleLocationCoordinateRange, 2);
    vn_encode_uint32_t(enc, &val->sampleLocationSubPixelBits);
    vn_encode_VkBool32(enc, &val->variableSampleLocations);
}

static inline void
vn_encode_VkPhysicalDeviceSampleLocationsPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceSampleLocationsPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceSampleLocationsPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSampleLocationsPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSampleLocationsPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSampleLocationsPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSampleLocationsPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->sampleLocationSampleCounts */
    vn_decode_VkExtent2D_partial_temp(dec, &val->maxSampleLocationGridSize);
    /* skip val->sampleLocationCoordinateRange */
    /* skip val->sampleLocationSubPixelBits */
    /* skip val->variableSampleLocations */
}

static inline void
vn_decode_VkPhysicalDeviceSampleLocationsPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSampleLocationsPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSampleLocationsPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSampleLocationsPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->advancedBlendMaxColorAttachments);
    vn_encode_VkBool32(enc, &val->advancedBlendIndependentBlend);
    vn_encode_VkBool32(enc, &val->advancedBlendNonPremultipliedSrcColor);
    vn_encode_VkBool32(enc, &val->advancedBlendNonPremultipliedDstColor);
    vn_encode_VkBool32(enc, &val->advancedBlendCorrelatedOverlap);
    vn_encode_VkBool32(enc, &val->advancedBlendAllOperations);
}

static inline void
vn_encode_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->advancedBlendMaxColorAttachments */
    /* skip val->advancedBlendIndependentBlend */
    /* skip val->advancedBlendNonPremultipliedSrcColor */
    /* skip val->advancedBlendNonPremultipliedDstColor */
    /* skip val->advancedBlendCorrelatedOverlap */
    /* skip val->advancedBlendAllOperations */
}

static inline void
vn_decode_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceInlineUniformBlockProperties chain */

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxInlineUniformBlockSize);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorInlineUniformBlocks);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetInlineUniformBlocks);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks);
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES });
    vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxInlineUniformBlockSize */
    /* skip val->maxPerStageDescriptorInlineUniformBlocks */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxDescriptorSetInlineUniformBlocks */
    /* skip val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks */
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceMaintenance3Properties chain */

static inline void
vn_encode_VkPhysicalDeviceMaintenance3Properties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance3Properties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance3Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxPerSetDescriptors);
    vn_encode_VkDeviceSize(enc, &val->maxMemoryAllocationSize);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance3Properties(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance3Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES });
    vn_encode_VkPhysicalDeviceMaintenance3Properties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance3Properties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance3Properties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance3Properties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance3Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxPerSetDescriptors */
    /* skip val->maxMemoryAllocationSize */
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance3Properties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance3Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance3Properties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance3Properties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceMaintenance4Properties chain */

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Properties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Properties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDeviceSize(enc, &val->maxBufferSize);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Properties(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES });
    vn_encode_VkPhysicalDeviceMaintenance4Properties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance4Properties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance4Properties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Properties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxBufferSize */
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Properties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance4Properties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance4Properties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceMaintenance5Properties chain */

static inline void
vn_encode_VkPhysicalDeviceMaintenance5Properties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance5Properties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance5Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->earlyFragmentMultisampleCoverageAfterSampleCounting);
    vn_encode_VkBool32(enc, &val->earlyFragmentSampleMaskTestBeforeSampleCounting);
    vn_encode_VkBool32(enc, &val->depthStencilSwizzleOneSupport);
    vn_encode_VkBool32(enc, &val->polygonModePointSize);
    vn_encode_VkBool32(enc, &val->nonStrictSinglePixelWideLinesUseParallelogram);
    vn_encode_VkBool32(enc, &val->nonStrictWideLinesUseParallelogram);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance5Properties(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance5Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES });
    vn_encode_VkPhysicalDeviceMaintenance5Properties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance5Properties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance5Properties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance5Properties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance5Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->earlyFragmentMultisampleCoverageAfterSampleCounting */
    /* skip val->earlyFragmentSampleMaskTestBeforeSampleCounting */
    /* skip val->depthStencilSwizzleOneSupport */
    /* skip val->polygonModePointSize */
    /* skip val->nonStrictSinglePixelWideLinesUseParallelogram */
    /* skip val->nonStrictWideLinesUseParallelogram */
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance5Properties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance5Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance5Properties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance5Properties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceMaintenance6Properties chain */

static inline void
vn_encode_VkPhysicalDeviceMaintenance6Properties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance6Properties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance6Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->blockTexelViewCompatibleMultipleLayers);
    vn_encode_uint32_t(enc, &val->maxCombinedImageSamplerDescriptorCount);
    vn_encode_VkBool32(enc, &val->fragmentShadingRateClampCombinerInputs);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance6Properties(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance6Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES });
    vn_encode_VkPhysicalDeviceMaintenance6Properties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance6Properties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance6Properties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance6Properties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance6Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->blockTexelViewCompatibleMultipleLayers */
    /* skip val->maxCombinedImageSamplerDescriptorCount */
    /* skip val->fragmentShadingRateClampCombinerInputs */
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance6Properties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance6Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance6Properties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance6Properties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceMaintenance7PropertiesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceMaintenance7PropertiesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance7PropertiesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance7PropertiesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->robustFragmentShadingRateAttachmentAccess);
    vn_encode_VkBool32(enc, &val->separateDepthStencilAttachmentAccess);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetTotalUniformBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetTotalStorageBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetTotalBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindTotalUniformBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindTotalStorageBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindTotalBuffersDynamic);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance7PropertiesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance7PropertiesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_PROPERTIES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_PROPERTIES_KHR });
    vn_encode_VkPhysicalDeviceMaintenance7PropertiesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance7PropertiesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance7PropertiesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance7PropertiesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance7PropertiesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->robustFragmentShadingRateAttachmentAccess */
    /* skip val->separateDepthStencilAttachmentAccess */
    /* skip val->maxDescriptorSetTotalUniformBuffersDynamic */
    /* skip val->maxDescriptorSetTotalStorageBuffersDynamic */
    /* skip val->maxDescriptorSetTotalBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindTotalUniformBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindTotalStorageBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindTotalBuffersDynamic */
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance7PropertiesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance7PropertiesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_PROPERTIES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance7PropertiesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance7PropertiesKHR_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceFloatControlsProperties chain */

static inline void
vn_encode_VkPhysicalDeviceFloatControlsProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFloatControlsProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceFloatControlsProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkShaderFloatControlsIndependence(enc, &val->denormBehaviorIndependence);
    vn_encode_VkShaderFloatControlsIndependence(enc, &val->roundingModeIndependence);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat16);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat32);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat64);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat16);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat32);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat64);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat16);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat32);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat64);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat16);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat32);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat64);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat16);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat32);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat64);
}

static inline void
vn_encode_VkPhysicalDeviceFloatControlsProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceFloatControlsProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES });
    vn_encode_VkPhysicalDeviceFloatControlsProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFloatControlsProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFloatControlsProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceFloatControlsProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFloatControlsProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->denormBehaviorIndependence */
    /* skip val->roundingModeIndependence */
    /* skip val->shaderSignedZeroInfNanPreserveFloat16 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat32 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat64 */
    /* skip val->shaderDenormPreserveFloat16 */
    /* skip val->shaderDenormPreserveFloat32 */
    /* skip val->shaderDenormPreserveFloat64 */
    /* skip val->shaderDenormFlushToZeroFloat16 */
    /* skip val->shaderDenormFlushToZeroFloat32 */
    /* skip val->shaderDenormFlushToZeroFloat64 */
    /* skip val->shaderRoundingModeRTEFloat16 */
    /* skip val->shaderRoundingModeRTEFloat32 */
    /* skip val->shaderRoundingModeRTEFloat64 */
    /* skip val->shaderRoundingModeRTZFloat16 */
    /* skip val->shaderRoundingModeRTZFloat32 */
    /* skip val->shaderRoundingModeRTZFloat64 */
}

static inline void
vn_decode_VkPhysicalDeviceFloatControlsProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFloatControlsProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFloatControlsProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceFloatControlsProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceConservativeRasterizationPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_float(enc, &val->primitiveOverestimationSize);
    vn_encode_float(enc, &val->maxExtraPrimitiveOverestimationSize);
    vn_encode_float(enc, &val->extraPrimitiveOverestimationSizeGranularity);
    vn_encode_VkBool32(enc, &val->primitiveUnderestimation);
    vn_encode_VkBool32(enc, &val->conservativePointAndLineRasterization);
    vn_encode_VkBool32(enc, &val->degenerateTrianglesRasterized);
    vn_encode_VkBool32(enc, &val->degenerateLinesRasterized);
    vn_encode_VkBool32(enc, &val->fullyCoveredFragmentShaderInputVariable);
    vn_encode_VkBool32(enc, &val->conservativeRasterizationPostDepthCoverage);
}

static inline void
vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceConservativeRasterizationPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceConservativeRasterizationPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->primitiveOverestimationSize */
    /* skip val->maxExtraPrimitiveOverestimationSize */
    /* skip val->extraPrimitiveOverestimationSizeGranularity */
    /* skip val->primitiveUnderestimation */
    /* skip val->conservativePointAndLineRasterization */
    /* skip val->degenerateTrianglesRasterized */
    /* skip val->degenerateLinesRasterized */
    /* skip val->fullyCoveredFragmentShaderInputVariable */
    /* skip val->conservativeRasterizationPostDepthCoverage */
}

static inline void
vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceConservativeRasterizationPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceDescriptorIndexingProperties chain */

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxUpdateAfterBindDescriptorsInAllPools);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->robustBufferAccessUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->quadDivergentImplicitLod);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindSamplers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindSampledImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindStorageImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindInputAttachments);
    vn_encode_uint32_t(enc, &val->maxPerStageUpdateAfterBindResources);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindSamplers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindSampledImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindInputAttachments);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES });
    vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxUpdateAfterBindDescriptorsInAllPools */
    /* skip val->shaderUniformBufferArrayNonUniformIndexingNative */
    /* skip val->shaderSampledImageArrayNonUniformIndexingNative */
    /* skip val->shaderStorageBufferArrayNonUniformIndexingNative */
    /* skip val->shaderStorageImageArrayNonUniformIndexingNative */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexingNative */
    /* skip val->robustBufferAccessUpdateAfterBind */
    /* skip val->quadDivergentImplicitLod */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSamplers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindUniformBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSampledImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInputAttachments */
    /* skip val->maxPerStageUpdateAfterBindResources */
    /* skip val->maxDescriptorSetUpdateAfterBindSamplers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindSampledImages */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageImages */
    /* skip val->maxDescriptorSetUpdateAfterBindInputAttachments */
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceTimelineSemaphoreProperties chain */

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint64_t(enc, &val->maxTimelineSemaphoreValueDifference);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES });
    vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxTimelineSemaphoreValueDifference */
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxVertexAttribDivisor);
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxVertexAttribDivisor */
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceVertexAttributeDivisorProperties chain */

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexAttributeDivisorProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxVertexAttribDivisor);
    vn_encode_VkBool32(enc, &val->supportsNonZeroFirstInstance);
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexAttributeDivisorProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES });
    vn_encode_VkPhysicalDeviceVertexAttributeDivisorProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVertexAttributeDivisorProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVertexAttributeDivisorProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxVertexAttribDivisor */
    /* skip val->supportsNonZeroFirstInstance */
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVertexAttributeDivisorProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVertexAttributeDivisorProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDevicePCIBusInfoPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePCIBusInfoPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->pciDomain);
    vn_encode_uint32_t(enc, &val->pciBus);
    vn_encode_uint32_t(enc, &val->pciDevice);
    vn_encode_uint32_t(enc, &val->pciFunction);
}

static inline void
vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDevicePCIBusInfoPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT });
    vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePCIBusInfoPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->pciDomain */
    /* skip val->pciBus */
    /* skip val->pciDevice */
    /* skip val->pciFunction */
}

static inline void
vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePCIBusInfoPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceDepthStencilResolveProperties chain */

static inline void
vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->supportedDepthResolveModes);
    vn_encode_VkFlags(enc, &val->supportedStencilResolveModes);
    vn_encode_VkBool32(enc, &val->independentResolveNone);
    vn_encode_VkBool32(enc, &val->independentResolve);
}

static inline void
vn_encode_VkPhysicalDeviceDepthStencilResolveProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES });
    vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->supportedDepthResolveModes */
    /* skip val->supportedStencilResolveModes */
    /* skip val->independentResolveNone */
    /* skip val->independentResolve */
}

static inline void
vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceTransformFeedbackPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxTransformFeedbackStreams);
    vn_encode_uint32_t(enc, &val->maxTransformFeedbackBuffers);
    vn_encode_VkDeviceSize(enc, &val->maxTransformFeedbackBufferSize);
    vn_encode_uint32_t(enc, &val->maxTransformFeedbackStreamDataSize);
    vn_encode_uint32_t(enc, &val->maxTransformFeedbackBufferDataSize);
    vn_encode_uint32_t(enc, &val->maxTransformFeedbackBufferDataStride);
    vn_encode_VkBool32(enc, &val->transformFeedbackQueries);
    vn_encode_VkBool32(enc, &val->transformFeedbackStreamsLinesTriangles);
    vn_encode_VkBool32(enc, &val->transformFeedbackRasterizationStreamSelect);
    vn_encode_VkBool32(enc, &val->transformFeedbackDraw);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxTransformFeedbackStreams */
    /* skip val->maxTransformFeedbackBuffers */
    /* skip val->maxTransformFeedbackBufferSize */
    /* skip val->maxTransformFeedbackStreamDataSize */
    /* skip val->maxTransformFeedbackBufferDataSize */
    /* skip val->maxTransformFeedbackBufferDataStride */
    /* skip val->transformFeedbackQueries */
    /* skip val->transformFeedbackStreamsLinesTriangles */
    /* skip val->transformFeedbackRasterizationStreamSelect */
    /* skip val->transformFeedbackDraw */
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->meshAndTaskShaderDerivatives);
}

static inline void
vn_encode_VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_PROPERTIES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_PROPERTIES_KHR });
    vn_encode_VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->meshAndTaskShaderDerivatives */
}

static inline void
vn_decode_VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_PROPERTIES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceAccelerationStructurePropertiesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceAccelerationStructurePropertiesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceAccelerationStructurePropertiesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceAccelerationStructurePropertiesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint64_t(enc, &val->maxGeometryCount);
    vn_encode_uint64_t(enc, &val->maxInstanceCount);
    vn_encode_uint64_t(enc, &val->maxPrimitiveCount);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorAccelerationStructures);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindAccelerationStructures);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetAccelerationStructures);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindAccelerationStructures);
    vn_encode_uint32_t(enc, &val->minAccelerationStructureScratchOffsetAlignment);
}

static inline void
vn_encode_VkPhysicalDeviceAccelerationStructurePropertiesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceAccelerationStructurePropertiesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR });
    vn_encode_VkPhysicalDeviceAccelerationStructurePropertiesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceAccelerationStructurePropertiesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceAccelerationStructurePropertiesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceAccelerationStructurePropertiesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceAccelerationStructurePropertiesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxGeometryCount */
    /* skip val->maxInstanceCount */
    /* skip val->maxPrimitiveCount */
    /* skip val->maxPerStageDescriptorAccelerationStructures */
    /* skip val->maxPerStageDescriptorUpdateAfterBindAccelerationStructures */
    /* skip val->maxDescriptorSetAccelerationStructures */
    /* skip val->maxDescriptorSetUpdateAfterBindAccelerationStructures */
    /* skip val->minAccelerationStructureScratchOffsetAlignment */
}

static inline void
vn_decode_VkPhysicalDeviceAccelerationStructurePropertiesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceAccelerationStructurePropertiesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceAccelerationStructurePropertiesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceAccelerationStructurePropertiesKHR_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceRayTracingPipelinePropertiesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceRayTracingPipelinePropertiesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceRayTracingPipelinePropertiesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceRayTracingPipelinePropertiesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->shaderGroupHandleSize);
    vn_encode_uint32_t(enc, &val->maxRayRecursionDepth);
    vn_encode_uint32_t(enc, &val->maxShaderGroupStride);
    vn_encode_uint32_t(enc, &val->shaderGroupBaseAlignment);
    vn_encode_uint32_t(enc, &val->shaderGroupHandleCaptureReplaySize);
    vn_encode_uint32_t(enc, &val->maxRayDispatchInvocationCount);
    vn_encode_uint32_t(enc, &val->shaderGroupHandleAlignment);
    vn_encode_uint32_t(enc, &val->maxRayHitAttributeSize);
}

static inline void
vn_encode_VkPhysicalDeviceRayTracingPipelinePropertiesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceRayTracingPipelinePropertiesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR });
    vn_encode_VkPhysicalDeviceRayTracingPipelinePropertiesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceRayTracingPipelinePropertiesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRayTracingPipelinePropertiesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRayTracingPipelinePropertiesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayTracingPipelinePropertiesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderGroupHandleSize */
    /* skip val->maxRayRecursionDepth */
    /* skip val->maxShaderGroupStride */
    /* skip val->shaderGroupBaseAlignment */
    /* skip val->shaderGroupHandleCaptureReplaySize */
    /* skip val->maxRayDispatchInvocationCount */
    /* skip val->shaderGroupHandleAlignment */
    /* skip val->maxRayHitAttributeSize */
}

static inline void
vn_decode_VkPhysicalDeviceRayTracingPipelinePropertiesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRayTracingPipelinePropertiesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRayTracingPipelinePropertiesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceRayTracingPipelinePropertiesKHR_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceTexelBufferAlignmentProperties chain */

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDeviceSize(enc, &val->storageTexelBufferOffsetAlignmentBytes);
    vn_encode_VkBool32(enc, &val->storageTexelBufferOffsetSingleTexelAlignment);
    vn_encode_VkDeviceSize(enc, &val->uniformTexelBufferOffsetAlignmentBytes);
    vn_encode_VkBool32(enc, &val->uniformTexelBufferOffsetSingleTexelAlignment);
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES });
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageTexelBufferOffsetAlignmentBytes */
    /* skip val->storageTexelBufferOffsetSingleTexelAlignment */
    /* skip val->uniformTexelBufferOffsetAlignmentBytes */
    /* skip val->uniformTexelBufferOffsetSingleTexelAlignment */
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceSubgroupSizeControlProperties chain */

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->minSubgroupSize);
    vn_encode_uint32_t(enc, &val->maxSubgroupSize);
    vn_encode_uint32_t(enc, &val->maxComputeWorkgroupSubgroups);
    vn_encode_VkFlags(enc, &val->requiredSubgroupSizeStages);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES });
    vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->minSubgroupSize */
    /* skip val->maxSubgroupSize */
    /* skip val->maxComputeWorkgroupSubgroups */
    /* skip val->requiredSubgroupSizeStages */
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceLineRasterizationProperties chain */

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceLineRasterizationProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->lineSubPixelPrecisionBits);
}

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceLineRasterizationProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES });
    vn_encode_VkPhysicalDeviceLineRasterizationProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceLineRasterizationProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceLineRasterizationProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLineRasterizationProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->lineSubPixelPrecisionBits */
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLineRasterizationProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceLineRasterizationProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceLineRasterizationProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceVulkan11Properties chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan11Properties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Properties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_array_size(enc, VK_UUID_SIZE);
    vn_encode_uint8_t_array(enc, val->deviceUUID, VK_UUID_SIZE);
    vn_encode_array_size(enc, VK_UUID_SIZE);
    vn_encode_uint8_t_array(enc, val->driverUUID, VK_UUID_SIZE);
    vn_encode_array_size(enc, VK_LUID_SIZE);
    vn_encode_uint8_t_array(enc, val->deviceLUID, VK_LUID_SIZE);
    vn_encode_uint32_t(enc, &val->deviceNodeMask);
    vn_encode_VkBool32(enc, &val->deviceLUIDValid);
    vn_encode_uint32_t(enc, &val->subgroupSize);
    vn_encode_VkFlags(enc, &val->subgroupSupportedStages);
    vn_encode_VkFlags(enc, &val->subgroupSupportedOperations);
    vn_encode_VkBool32(enc, &val->subgroupQuadOperationsInAllStages);
    vn_encode_VkPointClippingBehavior(enc, &val->pointClippingBehavior);
    vn_encode_uint32_t(enc, &val->maxMultiviewViewCount);
    vn_encode_uint32_t(enc, &val->maxMultiviewInstanceIndex);
    vn_encode_VkBool32(enc, &val->protectedNoFault);
    vn_encode_uint32_t(enc, &val->maxPerSetDescriptors);
    vn_encode_VkDeviceSize(enc, &val->maxMemoryAllocationSize);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Properties(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES });
    vn_encode_VkPhysicalDeviceVulkan11Properties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan11Properties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan11Properties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Properties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->deviceUUID */
    /* skip val->driverUUID */
    /* skip val->deviceLUID */
    /* skip val->deviceNodeMask */
    /* skip val->deviceLUIDValid */
    /* skip val->subgroupSize */
    /* skip val->subgroupSupportedStages */
    /* skip val->subgroupSupportedOperations */
    /* skip val->subgroupQuadOperationsInAllStages */
    /* skip val->pointClippingBehavior */
    /* skip val->maxMultiviewViewCount */
    /* skip val->maxMultiviewInstanceIndex */
    /* skip val->protectedNoFault */
    /* skip val->maxPerSetDescriptors */
    /* skip val->maxMemoryAllocationSize */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Properties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan11Properties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan11Properties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceVulkan12Properties chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan12Properties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Properties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDriverId(enc, &val->driverID);
    vn_encode_array_size(enc, VK_MAX_DRIVER_NAME_SIZE);
    vn_encode_char_array(enc, val->driverName, VK_MAX_DRIVER_NAME_SIZE);
    vn_encode_array_size(enc, VK_MAX_DRIVER_INFO_SIZE);
    vn_encode_char_array(enc, val->driverInfo, VK_MAX_DRIVER_INFO_SIZE);
    vn_encode_VkConformanceVersion(enc, &val->conformanceVersion);
    vn_encode_VkShaderFloatControlsIndependence(enc, &val->denormBehaviorIndependence);
    vn_encode_VkShaderFloatControlsIndependence(enc, &val->roundingModeIndependence);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat16);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat32);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat64);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat16);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat32);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat64);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat16);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat32);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat64);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat16);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat32);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat64);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat16);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat32);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat64);
    vn_encode_uint32_t(enc, &val->maxUpdateAfterBindDescriptorsInAllPools);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->robustBufferAccessUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->quadDivergentImplicitLod);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindSamplers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindSampledImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindStorageImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindInputAttachments);
    vn_encode_uint32_t(enc, &val->maxPerStageUpdateAfterBindResources);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindSamplers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindSampledImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindInputAttachments);
    vn_encode_VkFlags(enc, &val->supportedDepthResolveModes);
    vn_encode_VkFlags(enc, &val->supportedStencilResolveModes);
    vn_encode_VkBool32(enc, &val->independentResolveNone);
    vn_encode_VkBool32(enc, &val->independentResolve);
    vn_encode_VkBool32(enc, &val->filterMinmaxSingleComponentFormats);
    vn_encode_VkBool32(enc, &val->filterMinmaxImageComponentMapping);
    vn_encode_uint64_t(enc, &val->maxTimelineSemaphoreValueDifference);
    vn_encode_VkFlags(enc, &val->framebufferIntegerColorSampleCounts);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Properties(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES });
    vn_encode_VkPhysicalDeviceVulkan12Properties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan12Properties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan12Properties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Properties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->driverID */
    /* skip val->driverName */
    /* skip val->driverInfo */
    vn_decode_VkConformanceVersion_partial_temp(dec, &val->conformanceVersion);
    /* skip val->denormBehaviorIndependence */
    /* skip val->roundingModeIndependence */
    /* skip val->shaderSignedZeroInfNanPreserveFloat16 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat32 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat64 */
    /* skip val->shaderDenormPreserveFloat16 */
    /* skip val->shaderDenormPreserveFloat32 */
    /* skip val->shaderDenormPreserveFloat64 */
    /* skip val->shaderDenormFlushToZeroFloat16 */
    /* skip val->shaderDenormFlushToZeroFloat32 */
    /* skip val->shaderDenormFlushToZeroFloat64 */
    /* skip val->shaderRoundingModeRTEFloat16 */
    /* skip val->shaderRoundingModeRTEFloat32 */
    /* skip val->shaderRoundingModeRTEFloat64 */
    /* skip val->shaderRoundingModeRTZFloat16 */
    /* skip val->shaderRoundingModeRTZFloat32 */
    /* skip val->shaderRoundingModeRTZFloat64 */
    /* skip val->maxUpdateAfterBindDescriptorsInAllPools */
    /* skip val->shaderUniformBufferArrayNonUniformIndexingNative */
    /* skip val->shaderSampledImageArrayNonUniformIndexingNative */
    /* skip val->shaderStorageBufferArrayNonUniformIndexingNative */
    /* skip val->shaderStorageImageArrayNonUniformIndexingNative */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexingNative */
    /* skip val->robustBufferAccessUpdateAfterBind */
    /* skip val->quadDivergentImplicitLod */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSamplers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindUniformBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSampledImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInputAttachments */
    /* skip val->maxPerStageUpdateAfterBindResources */
    /* skip val->maxDescriptorSetUpdateAfterBindSamplers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindSampledImages */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageImages */
    /* skip val->maxDescriptorSetUpdateAfterBindInputAttachments */
    /* skip val->supportedDepthResolveModes */
    /* skip val->supportedStencilResolveModes */
    /* skip val->independentResolveNone */
    /* skip val->independentResolve */
    /* skip val->filterMinmaxSingleComponentFormats */
    /* skip val->filterMinmaxImageComponentMapping */
    /* skip val->maxTimelineSemaphoreValueDifference */
    /* skip val->framebufferIntegerColorSampleCounts */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Properties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan12Properties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan12Properties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceVulkan13Properties chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan13Properties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Properties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->minSubgroupSize);
    vn_encode_uint32_t(enc, &val->maxSubgroupSize);
    vn_encode_uint32_t(enc, &val->maxComputeWorkgroupSubgroups);
    vn_encode_VkFlags(enc, &val->requiredSubgroupSizeStages);
    vn_encode_uint32_t(enc, &val->maxInlineUniformBlockSize);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorInlineUniformBlocks);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetInlineUniformBlocks);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks);
    vn_encode_uint32_t(enc, &val->maxInlineUniformTotalSize);
    vn_encode_VkBool32(enc, &val->integerDotProduct8BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct8BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct8BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct4x8BitPackedUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct4x8BitPackedSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct4x8BitPackedMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct16BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct16BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct16BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct32BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct32BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct32BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct64BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct64BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct64BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating8BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating16BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating32BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating64BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated);
    vn_encode_VkDeviceSize(enc, &val->storageTexelBufferOffsetAlignmentBytes);
    vn_encode_VkBool32(enc, &val->storageTexelBufferOffsetSingleTexelAlignment);
    vn_encode_VkDeviceSize(enc, &val->uniformTexelBufferOffsetAlignmentBytes);
    vn_encode_VkBool32(enc, &val->uniformTexelBufferOffsetSingleTexelAlignment);
    vn_encode_VkDeviceSize(enc, &val->maxBufferSize);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Properties(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES });
    vn_encode_VkPhysicalDeviceVulkan13Properties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan13Properties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan13Properties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Properties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->minSubgroupSize */
    /* skip val->maxSubgroupSize */
    /* skip val->maxComputeWorkgroupSubgroups */
    /* skip val->requiredSubgroupSizeStages */
    /* skip val->maxInlineUniformBlockSize */
    /* skip val->maxPerStageDescriptorInlineUniformBlocks */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxDescriptorSetInlineUniformBlocks */
    /* skip val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxInlineUniformTotalSize */
    /* skip val->integerDotProduct8BitUnsignedAccelerated */
    /* skip val->integerDotProduct8BitSignedAccelerated */
    /* skip val->integerDotProduct8BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProduct16BitUnsignedAccelerated */
    /* skip val->integerDotProduct16BitSignedAccelerated */
    /* skip val->integerDotProduct16BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct32BitUnsignedAccelerated */
    /* skip val->integerDotProduct32BitSignedAccelerated */
    /* skip val->integerDotProduct32BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct64BitUnsignedAccelerated */
    /* skip val->integerDotProduct64BitSignedAccelerated */
    /* skip val->integerDotProduct64BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated */
    /* skip val->storageTexelBufferOffsetAlignmentBytes */
    /* skip val->storageTexelBufferOffsetSingleTexelAlignment */
    /* skip val->uniformTexelBufferOffsetAlignmentBytes */
    /* skip val->uniformTexelBufferOffsetSingleTexelAlignment */
    /* skip val->maxBufferSize */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Properties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan13Properties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan13Properties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceVulkan14Properties chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan14Properties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan14Properties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan14Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->lineSubPixelPrecisionBits);
    vn_encode_uint32_t(enc, &val->maxVertexAttribDivisor);
    vn_encode_VkBool32(enc, &val->supportsNonZeroFirstInstance);
    vn_encode_uint32_t(enc, &val->maxPushDescriptors);
    vn_encode_VkBool32(enc, &val->dynamicRenderingLocalReadDepthStencilAttachments);
    vn_encode_VkBool32(enc, &val->dynamicRenderingLocalReadMultisampledAttachments);
    vn_encode_VkBool32(enc, &val->earlyFragmentMultisampleCoverageAfterSampleCounting);
    vn_encode_VkBool32(enc, &val->earlyFragmentSampleMaskTestBeforeSampleCounting);
    vn_encode_VkBool32(enc, &val->depthStencilSwizzleOneSupport);
    vn_encode_VkBool32(enc, &val->polygonModePointSize);
    vn_encode_VkBool32(enc, &val->nonStrictSinglePixelWideLinesUseParallelogram);
    vn_encode_VkBool32(enc, &val->nonStrictWideLinesUseParallelogram);
    vn_encode_VkBool32(enc, &val->blockTexelViewCompatibleMultipleLayers);
    vn_encode_uint32_t(enc, &val->maxCombinedImageSamplerDescriptorCount);
    vn_encode_VkBool32(enc, &val->fragmentShadingRateClampCombinerInputs);
    vn_encode_VkPipelineRobustnessBufferBehavior(enc, &val->defaultRobustnessStorageBuffers);
    vn_encode_VkPipelineRobustnessBufferBehavior(enc, &val->defaultRobustnessUniformBuffers);
    vn_encode_VkPipelineRobustnessBufferBehavior(enc, &val->defaultRobustnessVertexInputs);
    vn_encode_VkPipelineRobustnessImageBehavior(enc, &val->defaultRobustnessImages);
    vn_encode_uint32_t(enc, &val->copySrcLayoutCount);
    if (val->pCopySrcLayouts) {
        vn_encode_array_size(enc, val->copySrcLayoutCount);
        vn_encode_VkImageLayout_array(enc, val->pCopySrcLayouts, val->copySrcLayoutCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->copyDstLayoutCount);
    if (val->pCopyDstLayouts) {
        vn_encode_array_size(enc, val->copyDstLayoutCount);
        vn_encode_VkImageLayout_array(enc, val->pCopyDstLayouts, val->copyDstLayoutCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_array_size(enc, VK_UUID_SIZE);
    vn_encode_uint8_t_array(enc, val->optimalTilingLayoutUUID, VK_UUID_SIZE);
    vn_encode_VkBool32(enc, &val->identicalMemoryTypeRequirements);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan14Properties(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan14Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES });
    vn_encode_VkPhysicalDeviceVulkan14Properties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan14Properties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan14Properties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan14Properties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan14Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->lineSubPixelPrecisionBits */
    /* skip val->maxVertexAttribDivisor */
    /* skip val->supportsNonZeroFirstInstance */
    /* skip val->maxPushDescriptors */
    /* skip val->dynamicRenderingLocalReadDepthStencilAttachments */
    /* skip val->dynamicRenderingLocalReadMultisampledAttachments */
    /* skip val->earlyFragmentMultisampleCoverageAfterSampleCounting */
    /* skip val->earlyFragmentSampleMaskTestBeforeSampleCounting */
    /* skip val->depthStencilSwizzleOneSupport */
    /* skip val->polygonModePointSize */
    /* skip val->nonStrictSinglePixelWideLinesUseParallelogram */
    /* skip val->nonStrictWideLinesUseParallelogram */
    /* skip val->blockTexelViewCompatibleMultipleLayers */
    /* skip val->maxCombinedImageSamplerDescriptorCount */
    /* skip val->fragmentShadingRateClampCombinerInputs */
    /* skip val->defaultRobustnessStorageBuffers */
    /* skip val->defaultRobustnessUniformBuffers */
    /* skip val->defaultRobustnessVertexInputs */
    /* skip val->defaultRobustnessImages */
    vn_decode_uint32_t(dec, &val->copySrcLayoutCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->copySrcLayoutCount);
        val->pCopySrcLayouts = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pCopySrcLayouts), array_size);
        if (!val->pCopySrcLayouts) return;
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pCopySrcLayouts = NULL;
    }
    vn_decode_uint32_t(dec, &val->copyDstLayoutCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->copyDstLayoutCount);
        val->pCopyDstLayouts = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pCopyDstLayouts), array_size);
        if (!val->pCopyDstLayouts) return;
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pCopyDstLayouts = NULL;
    }
    /* skip val->optimalTilingLayoutUUID */
    /* skip val->identicalMemoryTypeRequirements */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan14Properties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan14Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan14Properties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan14Properties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceCustomBorderColorPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceCustomBorderColorPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxCustomBorderColorSamplers);
}

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceCustomBorderColorPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceCustomBorderColorPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxCustomBorderColorSamplers */
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceCustomBorderColorPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceExtendedDynamicState3PropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->dynamicPrimitiveTopologyUnrestricted);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->dynamicPrimitiveTopologyUnrestricted */
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceRobustness2PropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceRobustness2PropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDeviceSize(enc, &val->robustStorageBufferAccessSizeAlignment);
    vn_encode_VkDeviceSize(enc, &val->robustUniformBufferAccessSizeAlignment);
}

static inline void
vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceRobustness2PropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRobustness2PropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->robustStorageBufferAccessSizeAlignment */
    /* skip val->robustUniformBufferAccessSizeAlignment */
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRobustness2PropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceFragmentShadingRatePropertiesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShadingRatePropertiesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceFragmentShadingRatePropertiesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkExtent2D(enc, &val->minFragmentShadingRateAttachmentTexelSize);
    vn_encode_VkExtent2D(enc, &val->maxFragmentShadingRateAttachmentTexelSize);
    vn_encode_uint32_t(enc, &val->maxFragmentShadingRateAttachmentTexelSizeAspectRatio);
    vn_encode_VkBool32(enc, &val->primitiveFragmentShadingRateWithMultipleViewports);
    vn_encode_VkBool32(enc, &val->layeredShadingRateAttachments);
    vn_encode_VkBool32(enc, &val->fragmentShadingRateNonTrivialCombinerOps);
    vn_encode_VkExtent2D(enc, &val->maxFragmentSize);
    vn_encode_uint32_t(enc, &val->maxFragmentSizeAspectRatio);
    vn_encode_uint32_t(enc, &val->maxFragmentShadingRateCoverageSamples);
    vn_encode_VkSampleCountFlagBits(enc, &val->maxFragmentShadingRateRasterizationSamples);
    vn_encode_VkBool32(enc, &val->fragmentShadingRateWithShaderDepthStencilWrites);
    vn_encode_VkBool32(enc, &val->fragmentShadingRateWithSampleMask);
    vn_encode_VkBool32(enc, &val->fragmentShadingRateWithShaderSampleMask);
    vn_encode_VkBool32(enc, &val->fragmentShadingRateWithConservativeRasterization);
    vn_encode_VkBool32(enc, &val->fragmentShadingRateWithFragmentShaderInterlock);
    vn_encode_VkBool32(enc, &val->fragmentShadingRateWithCustomSampleLocations);
    vn_encode_VkBool32(enc, &val->fragmentShadingRateStrictMultiplyCombiner);
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShadingRatePropertiesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceFragmentShadingRatePropertiesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR });
    vn_encode_VkPhysicalDeviceFragmentShadingRatePropertiesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFragmentShadingRatePropertiesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFragmentShadingRatePropertiesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShadingRatePropertiesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShadingRatePropertiesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkExtent2D_partial_temp(dec, &val->minFragmentShadingRateAttachmentTexelSize);
    vn_decode_VkExtent2D_partial_temp(dec, &val->maxFragmentShadingRateAttachmentTexelSize);
    /* skip val->maxFragmentShadingRateAttachmentTexelSizeAspectRatio */
    /* skip val->primitiveFragmentShadingRateWithMultipleViewports */
    /* skip val->layeredShadingRateAttachments */
    /* skip val->fragmentShadingRateNonTrivialCombinerOps */
    vn_decode_VkExtent2D_partial_temp(dec, &val->maxFragmentSize);
    /* skip val->maxFragmentSizeAspectRatio */
    /* skip val->maxFragmentShadingRateCoverageSamples */
    /* skip val->maxFragmentShadingRateRasterizationSamples */
    /* skip val->fragmentShadingRateWithShaderDepthStencilWrites */
    /* skip val->fragmentShadingRateWithSampleMask */
    /* skip val->fragmentShadingRateWithShaderSampleMask */
    /* skip val->fragmentShadingRateWithConservativeRasterization */
    /* skip val->fragmentShadingRateWithFragmentShaderInterlock */
    /* skip val->fragmentShadingRateWithCustomSampleLocations */
    /* skip val->fragmentShadingRateStrictMultiplyCombiner */
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShadingRatePropertiesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShadingRatePropertiesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFragmentShadingRatePropertiesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceFragmentShadingRatePropertiesKHR_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->nativeUnalignedPerformance);
}

static inline void
vn_encode_VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->nativeUnalignedPerformance */
}

static inline void
vn_decode_VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceHostImageCopyProperties chain */

static inline void
vn_encode_VkPhysicalDeviceHostImageCopyProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceHostImageCopyProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostImageCopyProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->copySrcLayoutCount);
    if (val->pCopySrcLayouts) {
        vn_encode_array_size(enc, val->copySrcLayoutCount);
        vn_encode_VkImageLayout_array(enc, val->pCopySrcLayouts, val->copySrcLayoutCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->copyDstLayoutCount);
    if (val->pCopyDstLayouts) {
        vn_encode_array_size(enc, val->copyDstLayoutCount);
        vn_encode_VkImageLayout_array(enc, val->pCopyDstLayouts, val->copyDstLayoutCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_array_size(enc, VK_UUID_SIZE);
    vn_encode_uint8_t_array(enc, val->optimalTilingLayoutUUID, VK_UUID_SIZE);
    vn_encode_VkBool32(enc, &val->identicalMemoryTypeRequirements);
}

static inline void
vn_encode_VkPhysicalDeviceHostImageCopyProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostImageCopyProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES });
    vn_encode_VkPhysicalDeviceHostImageCopyProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceHostImageCopyProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceHostImageCopyProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceHostImageCopyProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostImageCopyProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->copySrcLayoutCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->copySrcLayoutCount);
        val->pCopySrcLayouts = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pCopySrcLayouts), array_size);
        if (!val->pCopySrcLayouts) return;
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pCopySrcLayouts = NULL;
    }
    vn_decode_uint32_t(dec, &val->copyDstLayoutCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->copyDstLayoutCount);
        val->pCopyDstLayouts = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pCopyDstLayouts), array_size);
        if (!val->pCopyDstLayouts) return;
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pCopyDstLayouts = NULL;
    }
    /* skip val->optimalTilingLayoutUUID */
    /* skip val->identicalMemoryTypeRequirements */
}

static inline void
vn_decode_VkPhysicalDeviceHostImageCopyProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostImageCopyProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceHostImageCopyProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceHostImageCopyProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceProvokingVertexPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceProvokingVertexPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->provokingVertexModePerPipeline);
    vn_encode_VkBool32(enc, &val->transformFeedbackPreservesTriangleFanProvokingVertex);
}

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceProvokingVertexPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProvokingVertexPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProvokingVertexPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->provokingVertexModePerPipeline */
    /* skip val->transformFeedbackPreservesTriangleFanProvokingVertex */
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProvokingVertexPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceProvokingVertexPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceProvokingVertexPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceShaderIntegerDotProductProperties chain */

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->integerDotProduct8BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct8BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct8BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct4x8BitPackedUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct4x8BitPackedSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct4x8BitPackedMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct16BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct16BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct16BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct32BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct32BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct32BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct64BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct64BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct64BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating8BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating16BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating32BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating64BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated);
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES });
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->integerDotProduct8BitUnsignedAccelerated */
    /* skip val->integerDotProduct8BitSignedAccelerated */
    /* skip val->integerDotProduct8BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProduct16BitUnsignedAccelerated */
    /* skip val->integerDotProduct16BitSignedAccelerated */
    /* skip val->integerDotProduct16BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct32BitUnsignedAccelerated */
    /* skip val->integerDotProduct32BitSignedAccelerated */
    /* skip val->integerDotProduct32BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct64BitUnsignedAccelerated */
    /* skip val->integerDotProduct64BitSignedAccelerated */
    /* skip val->integerDotProduct64BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated */
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->triStripVertexOrderIndependentOfProvokingVertex);
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_PROPERTIES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_PROPERTIES_KHR });
    vn_encode_VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->triStripVertexOrderIndependentOfProvokingVertex */
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_PROPERTIES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->graphicsPipelineLibraryFastLinking);
    vn_encode_VkBool32(enc, &val->graphicsPipelineLibraryIndependentInterpolationDecoration);
}

static inline void
vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->graphicsPipelineLibraryFastLinking */
    /* skip val->graphicsPipelineLibraryIndependentInterpolationDecoration */
}

static inline void
vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceNestedCommandBufferPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceNestedCommandBufferPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceNestedCommandBufferPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceNestedCommandBufferPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxCommandBufferNestingLevel);
}

static inline void
vn_encode_VkPhysicalDeviceNestedCommandBufferPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceNestedCommandBufferPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceNestedCommandBufferPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceNestedCommandBufferPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceNestedCommandBufferPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceNestedCommandBufferPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceNestedCommandBufferPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxCommandBufferNestingLevel */
}

static inline void
vn_decode_VkPhysicalDeviceNestedCommandBufferPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceNestedCommandBufferPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceNestedCommandBufferPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceNestedCommandBufferPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDevicePipelineRobustnessProperties chain */

static inline void
vn_encode_VkPhysicalDevicePipelineRobustnessProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePipelineRobustnessProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineRobustnessProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPipelineRobustnessBufferBehavior(enc, &val->defaultRobustnessStorageBuffers);
    vn_encode_VkPipelineRobustnessBufferBehavior(enc, &val->defaultRobustnessUniformBuffers);
    vn_encode_VkPipelineRobustnessBufferBehavior(enc, &val->defaultRobustnessVertexInputs);
    vn_encode_VkPipelineRobustnessImageBehavior(enc, &val->defaultRobustnessImages);
}

static inline void
vn_encode_VkPhysicalDevicePipelineRobustnessProperties(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineRobustnessProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES });
    vn_encode_VkPhysicalDevicePipelineRobustnessProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePipelineRobustnessProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePipelineRobustnessProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePipelineRobustnessProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineRobustnessProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->defaultRobustnessStorageBuffers */
    /* skip val->defaultRobustnessUniformBuffers */
    /* skip val->defaultRobustnessVertexInputs */
    /* skip val->defaultRobustnessImages */
}

static inline void
vn_decode_VkPhysicalDevicePipelineRobustnessProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineRobustnessProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePipelineRobustnessProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePipelineRobustnessProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceProperties2 chain */

static inline void
vn_encode_VkPhysicalDeviceProperties2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT_self(enc, (const VkPhysicalDeviceMultiDrawPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePushDescriptorProperties_self(enc, (const VkPhysicalDevicePushDescriptorProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDriverProperties_self(enc, (const VkPhysicalDeviceDriverProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceIDProperties_self(enc, (const VkPhysicalDeviceIDProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiviewProperties_self(enc, (const VkPhysicalDeviceMultiviewProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSubgroupProperties_self(enc, (const VkPhysicalDeviceSubgroupProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePointClippingProperties_self(enc, (const VkPhysicalDevicePointClippingProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProtectedMemoryProperties_self(enc, (const VkPhysicalDeviceProtectedMemoryProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(enc, (const VkPhysicalDeviceSamplerFilterMinmaxProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSampleLocationsPropertiesEXT_self(enc, (const VkPhysicalDeviceSampleLocationsPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT_self(enc, (const VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_self(enc, (const VkPhysicalDeviceInlineUniformBlockProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance3Properties_self(enc, (const VkPhysicalDeviceMaintenance3Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance4Properties_self(enc, (const VkPhysicalDeviceMaintenance4Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance5Properties_self(enc, (const VkPhysicalDeviceMaintenance5Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance6Properties_self(enc, (const VkPhysicalDeviceMaintenance6Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_PROPERTIES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance7PropertiesKHR_self(enc, (const VkPhysicalDeviceMaintenance7PropertiesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceFloatControlsProperties_self(enc, (const VkPhysicalDeviceFloatControlsProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self(enc, (const VkPhysicalDeviceConservativeRasterizationPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_self(enc, (const VkPhysicalDeviceDescriptorIndexingProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_self(enc, (const VkPhysicalDeviceTimelineSemaphoreProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self(enc, (const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVertexAttributeDivisorProperties_self(enc, (const VkPhysicalDeviceVertexAttributeDivisorProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self(enc, (const VkPhysicalDevicePCIBusInfoPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_self(enc, (const VkPhysicalDeviceDepthStencilResolveProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(enc, (const VkPhysicalDeviceTransformFeedbackPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_PROPERTIES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR_self(enc, (const VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceAccelerationStructurePropertiesKHR_self(enc, (const VkPhysicalDeviceAccelerationStructurePropertiesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRayTracingPipelinePropertiesKHR_self(enc, (const VkPhysicalDeviceRayTracingPipelinePropertiesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_self(enc, (const VkPhysicalDeviceTexelBufferAlignmentProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_self(enc, (const VkPhysicalDeviceSubgroupSizeControlProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceLineRasterizationProperties_self(enc, (const VkPhysicalDeviceLineRasterizationProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan11Properties_self(enc, (const VkPhysicalDeviceVulkan11Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan12Properties_self(enc, (const VkPhysicalDeviceVulkan12Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan13Properties_self(enc, (const VkPhysicalDeviceVulkan13Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan14Properties_self(enc, (const VkPhysicalDeviceVulkan14Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self(enc, (const VkPhysicalDeviceCustomBorderColorPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self(enc, (const VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT_self(enc, (const VkPhysicalDeviceRobustness2PropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceFragmentShadingRatePropertiesKHR_self(enc, (const VkPhysicalDeviceFragmentShadingRatePropertiesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT_self(enc, (const VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceHostImageCopyProperties_self(enc, (const VkPhysicalDeviceHostImageCopyProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT_self(enc, (const VkPhysicalDeviceProvokingVertexPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_self(enc, (const VkPhysicalDeviceShaderIntegerDotProductProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_PROPERTIES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR_self(enc, (const VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_self(enc, (const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceNestedCommandBufferPropertiesEXT_self(enc, (const VkPhysicalDeviceNestedCommandBufferPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePipelineRobustnessProperties_self(enc, (const VkPhysicalDevicePipelineRobustnessProperties *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProperties2_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPhysicalDeviceProperties(enc, &val->properties);
}

static inline void
vn_encode_VkPhysicalDeviceProperties2(struct vn_cs_encoder *enc, const VkPhysicalDeviceProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2 });
    vn_encode_VkPhysicalDeviceProperties2_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProperties2_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiDrawPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceMultiDrawPropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePushDescriptorProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePushDescriptorProperties_self_partial_temp(dec, (VkPhysicalDevicePushDescriptorProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDriverProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDriverProperties_self_partial_temp(dec, (VkPhysicalDeviceDriverProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceIDProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceIDProperties_self_partial_temp(dec, (VkPhysicalDeviceIDProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiviewProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMultiviewProperties_self_partial_temp(dec, (VkPhysicalDeviceMultiviewProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSubgroupProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSubgroupProperties_self_partial_temp(dec, (VkPhysicalDeviceSubgroupProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePointClippingProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePointClippingProperties_self_partial_temp(dec, (VkPhysicalDevicePointClippingProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProtectedMemoryProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceProtectedMemoryProperties_self_partial_temp(dec, (VkPhysicalDeviceProtectedMemoryProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSamplerFilterMinmaxProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial_temp(dec, (VkPhysicalDeviceSamplerFilterMinmaxProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSampleLocationsPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSampleLocationsPropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceSampleLocationsPropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceInlineUniformBlockProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_self_partial_temp(dec, (VkPhysicalDeviceInlineUniformBlockProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance3Properties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance3Properties_self_partial_temp(dec, (VkPhysicalDeviceMaintenance3Properties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance4Properties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance4Properties_self_partial_temp(dec, (VkPhysicalDeviceMaintenance4Properties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance5Properties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance5Properties_self_partial_temp(dec, (VkPhysicalDeviceMaintenance5Properties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance6Properties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance6Properties_self_partial_temp(dec, (VkPhysicalDeviceMaintenance6Properties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_PROPERTIES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance7PropertiesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance7PropertiesKHR_self_partial_temp(dec, (VkPhysicalDeviceMaintenance7PropertiesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFloatControlsProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceFloatControlsProperties_self_partial_temp(dec, (VkPhysicalDeviceFloatControlsProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceConservativeRasterizationPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceConservativeRasterizationPropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDescriptorIndexingProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_self_partial_temp(dec, (VkPhysicalDeviceDescriptorIndexingProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTimelineSemaphoreProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial_temp(dec, (VkPhysicalDeviceTimelineSemaphoreProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVertexAttributeDivisorProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVertexAttributeDivisorProperties_self_partial_temp(dec, (VkPhysicalDeviceVertexAttributeDivisorProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePCIBusInfoPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self_partial_temp(dec, (VkPhysicalDevicePCIBusInfoPropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthStencilResolveProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_self_partial_temp(dec, (VkPhysicalDeviceDepthStencilResolveProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTransformFeedbackPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceTransformFeedbackPropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_PROPERTIES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR_self_partial_temp(dec, (VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceAccelerationStructurePropertiesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceAccelerationStructurePropertiesKHR_self_partial_temp(dec, (VkPhysicalDeviceAccelerationStructurePropertiesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRayTracingPipelinePropertiesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceRayTracingPipelinePropertiesKHR_self_partial_temp(dec, (VkPhysicalDeviceRayTracingPipelinePropertiesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTexelBufferAlignmentProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial_temp(dec, (VkPhysicalDeviceTexelBufferAlignmentProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSubgroupSizeControlProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial_temp(dec, (VkPhysicalDeviceSubgroupSizeControlProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceLineRasterizationProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceLineRasterizationProperties_self_partial_temp(dec, (VkPhysicalDeviceLineRasterizationProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan11Properties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan11Properties_self_partial_temp(dec, (VkPhysicalDeviceVulkan11Properties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan12Properties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan12Properties_self_partial_temp(dec, (VkPhysicalDeviceVulkan12Properties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan13Properties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan13Properties_self_partial_temp(dec, (VkPhysicalDeviceVulkan13Properties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan14Properties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan14Properties_self_partial_temp(dec, (VkPhysicalDeviceVulkan14Properties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceCustomBorderColorPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceCustomBorderColorPropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExtendedDynamicState3PropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRobustness2PropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceRobustness2PropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFragmentShadingRatePropertiesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceFragmentShadingRatePropertiesKHR_self_par