389 Directory Server
====================

[![Test](https://github.com/389ds/389-ds-base/actions/workflows/pytest.yml/badge.svg)](https://github.com/389ds/389-ds-base/actions/workflows/pytest.yml)
[![npm-audit-ci](https://github.com/389ds/389-ds-base/actions/workflows/npm.yml/badge.svg)](https://github.com/389ds/389-ds-base/actions/workflows/npm.yml)

389 Directory Server is a highly usable, fully featured, reliable
and secure LDAP server implementation. It handles many of the
largest LDAP deployments in the world.

All our code has been extensively tested with sanitisation tools.
As well as a rich feature set of fail-over and backup technologies
gives administrators confidence their accounts are safe.

License
-------

The 389 Directory Server is subject to the terms detailed in the
license agreement file called LICENSE.

Late-breaking news and information on the 389 Directory Server is
available on our [wiki page](https://www.port389.org/)

Building
--------

    autoreconf -fiv
    ./configure --enable-debug --with-openldap --enable-cmocka --enable-asan
    make
    make lib389
    sudo make install
    sudo make lib389-install

Note: **--enable-asan** is optional, and it should only be used for debugging/development purposes.

See also full [building guide](https://www.port389.org/docs/389ds/development/building.html).

Testing
-------

    make check
    sudo py.test -s 389-ds-base/dirsrvtests/tests/suites/basic/

To debug the make check item's, you'll need libtool to help:

    libtool --mode=execute gdb /home/william/build/ds/test_slapd

More information
----------------

Please see our [contributing guide](https://www.port389.org/docs/389ds/contributing.html).

