// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

// This file is used by Code Analysis to maintain SuppressMessage
// attributes that are applied to this project.
// Project-level suppressions either have no target or are given
// a specific target and scoped to a namespace, type, member, etc.

using System.Diagnostics.CodeAnalysis;

[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/Home/issues/7674", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.ProjectRetargetingHandler.Microsoft#VisualStudio#Shell#Interop#IVsTrackProjectRetargetingEvents#OnRetargetingAfterChange(System.String,Microsoft.VisualStudio.Shell.Interop.IVsHierarchy,System.String,System.String)~System.Int32")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/Home/issues/7674", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.ProjectRetargetingHandler.Microsoft#VisualStudio#Shell#Interop#IVsTrackBatchRetargetingEvents#OnBatchRetargetingEnd~System.Int32")]
[assembly: SuppressMessage("Usage", "VSTHRD011:Use AsyncLazy<T>", Justification = "https://github.com/NuGet/Home/issues/7675", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSSolutionManager.InitializeAsync~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/Home/issues/7674", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.RuntimeHelpers.QueueUnloadAndForget(System.AppDomain)")]
[assembly: SuppressMessage("Usage", "VSTHRD003:Avoid awaiting foreign Tasks", Justification = "All these methods are free threaded.", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageMetadataProvider.GetLocalPackageMetadataAsync(NuGet.Packaging.Core.PackageIdentity,System.Boolean,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.IPackageSearchMetadata}")]
[assembly: SuppressMessage("Build", "CA2213:'ProjectRetargetingHandler' contains field '_errorListProvider' that is of IDisposable type 'ErrorListProvider', but it is never disposed. Change the Dispose method on 'ProjectRetargetingHandler' to call Close or Dispose on this field.", Justification = "'_errorListProvider' field is disposed in the Dispose method after switching to the main thread in JTF context.", Scope = "member", Target = "~F:NuGet.PackageManagement.VisualStudio.ProjectRetargetingHandler._errorListProvider")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetProjectTelemetryEventAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "Telemetry exceptions should not crash entire devenv.exe process", Scope = "member", Target = "~M:NuGet.PackageManagement.Telemetry.VSTelemetryServiceUtility.GetProjectTelemetryEventAsync(NuGet.ProjectManagement.NuGetProject)~System.Threading.Tasks.Task{NuGet.PackageManagement.Telemetry.ProjectTelemetryEvent}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'IsSourceControlBound' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.DefaultTFSSourceControlManager.IsSourceControlBound(System.String)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'TryAddCredentialProviders' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.DefaultVSCredentialServiceProvider.TryAddCredentialProviders(System.Collections.Generic.List{NuGet.Credentials.ICredentialProvider},System.String,System.Func{System.Collections.Generic.IEnumerable{NuGet.Credentials.ICredentialProvider}})")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'TryAddCredentialProvidersAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.DefaultVSCredentialServiceProvider.TryAddCredentialProvidersAsync(System.Collections.Generic.List{NuGet.Credentials.ICredentialProvider},System.String,System.Func{System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.Credentials.ICredentialProvider}}})~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1054:Uri parameters should not be strings", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.DeprecatedFrameworkModel.#ctor(NuGet.Frameworks.NuGetFramework,System.String,System.Collections.Generic.IReadOnlyList{System.String})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<NuGetProject> DotnetDeprecatedPrompt.GetAffectedProjects(IEnumerable<ResolvedAction> actions)', validate parameter 'actions' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.DotnetDeprecatedPrompt.GetAffectedProjects(System.Collections.Generic.IEnumerable{NuGet.PackageManagement.ResolvedAction})~System.Collections.Generic.IEnumerable{NuGet.ProjectManagement.NuGetProject}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<NuGetProject> EnvDTEProjectUtility.GetNuGetProjectAsync(Project project, ISolutionManager solutionManager)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.EnvDTEProjectUtility.GetNuGetProjectAsync(EnvDTE.Project,NuGet.PackageManagement.ISolutionManager)~System.Threading.Tasks.Task{NuGet.ProjectManagement.NuGetProject}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<ProjectItems> EnvDTEProjectUtility.GetProjectItemsAsync(Project envDTEProject, string folderPath, bool createIfNotExists)', validate parameter 'envDTEProject' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.EnvDTEProjectUtility.GetProjectItemsAsync(EnvDTE.Project,System.String,System.Boolean)~System.Threading.Tasks.Task{EnvDTE.ProjectItems}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<bool> EnvDTEProjectUtility.HasBuildIntegratedConfig(Project project)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.EnvDTEProjectUtility.HasBuildIntegratedConfig(EnvDTE.Project)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool EnvDTEProjectUtility.IsExplicitlyUnsupported(Project envDTEProject)', validate parameter 'envDTEProject' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.EnvDTEProjectUtility.IsExplicitlyUnsupported(EnvDTE.Project)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool EnvDTEProjectUtility.IsParentProjectExplicitlyUnsupported(Project envDTEProject)', validate parameter 'envDTEProject' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.EnvDTEProjectUtility.IsParentProjectExplicitlyUnsupported(EnvDTE.Project)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1308:In method 'GetHashCode', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.EnvDTEProjectUtility.PathComparer.GetHashCode(System.String)~System.Int32")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IEnumerable<Project>> EnvDTESolutionUtility.GetAllEnvDTEProjectsAsync(DTE dte)', validate parameter 'dte' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.EnvDTESolutionUtility.GetAllEnvDTEProjectsAsync(EnvDTE.DTE)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{EnvDTE.Project}}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetFrameworkAssemblies' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.FrameworkAssemblyResolver.GetFrameworkAssemblies(System.String)~System.Collections.Generic.List{NuGet.PackageManagement.VisualStudio.FrameworkAssembly}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'RemoveReferenceAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.FSharpProjectSystem.RemoveReferenceAsync(System.String)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'LegacyPackageReferenceProject.LegacyPackageReferenceProject(IVsProjectAdapter vsProjectAdapter, string projectId, INuGetProjectServices projectServices, IVsProjectThreadingService threadingService)', validate parameter 'vsProjectAdapter' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProject.#ctor(NuGet.VisualStudio.IVsProjectAdapter,System.String,NuGet.ProjectManagement.INuGetProjectServices,NuGet.PackageManagement.VisualStudio.IVsProjectThreadingService)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task LegacyPackageReferenceProject.AddFileToProjectAsync(string filePath)', validate parameter 'filePath' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProject.AddFileToProjectAsync(System.String)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1822:Member GetConfigFilePaths does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProject.GetConfigFilePaths(NuGet.Configuration.ISettings)~System.Collections.Generic.IList{System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<bool> LegacyPackageReferenceProject.InstallPackageAsync(string packageId, VersionRange range, INuGetProjectContext _, BuildIntegratedInstallationContext __, CancellationToken token)', validate parameter '__' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProject.InstallPackageAsync(System.String,NuGet.Versioning.VersionRange,NuGet.ProjectManagement.INuGetProjectContext,NuGet.ProjectManagement.BuildIntegratedInstallationContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<bool> LegacyPackageReferenceProject.UninstallPackageAsync(PackageIdentity packageIdentity, INuGetProjectContext _, CancellationToken token)', validate parameter 'packageIdentity' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProject.UninstallPackageAsync(NuGet.Packaging.Core.PackageIdentity,NuGet.ProjectManagement.INuGetProjectContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'NuGetProject LegacyPackageReferenceProjectProvider.TryCreateNuGetProject(IVsProjectAdapter vsProjectAdapter, ProjectProviderContext context, bool forceProjectType)', validate parameter 'vsProjectAdapter' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProjectProvider.TryCreateNuGetProject(NuGet.VisualStudio.IVsProjectAdapter,NuGet.PackageManagement.VisualStudio.ProjectProviderContext,System.Boolean)~NuGet.ProjectManagement.NuGetProject")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetAssemblyReferences' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MicrosoftBuildEvaluationProjectUtility.GetAssemblyReferences(Microsoft.Build.Evaluation.Project)~System.Collections.Generic.IEnumerable{System.Tuple{Microsoft.Build.Evaluation.ProjectItem,System.Reflection.AssemblyName}}")]
[assembly: SuppressMessage("Build", "CA1303:Method 'MultiSourcePackageFeed.MultiSourcePackageFeed(IEnumerable<SourceRepository> sourceRepositories, INuGetUILogger logger, INuGetTelemetryService telemetryService)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message, string paramName)'. Retrieve the following string(s) from a resource table instead: \"Collection of source repositories cannot be empty\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageFeed.#ctor(System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},NuGet.PackageManagement.VisualStudio.INuGetUILogger,NuGet.Common.INuGetTelemetryService)")]
[assembly: SuppressMessage("Build", "CA1822:Member AggregateSearchResultsAsync does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageFeed.AggregateSearchResultsAsync(System.String,System.Collections.Generic.IEnumerable{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}},NuGet.PackageManagement.VisualStudio.MultiSourcePackageFeed.TelemetryState)~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Build", "CA1303:Method 'Task<SearchResult<IPackageSearchMetadata>> MultiSourcePackageFeed.ContinueSearchAsync(ContinuationToken continuationToken, CancellationToken cancellationToken)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Invalid token\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageFeed.ContinueSearchAsync(NuGet.PackageManagement.VisualStudio.ContinuationToken,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Build", "CA1303:Method 'Task<SearchResult<IPackageSearchMetadata>> MultiSourcePackageFeed.RefreshSearchAsync(RefreshToken refreshToken, CancellationToken cancellationToken)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Invalid token\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageFeed.RefreshSearchAsync(NuGet.PackageManagement.VisualStudio.RefreshToken,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<SearchResult<IPackageSearchMetadata>> MultiSourcePackageFeed.SearchAsync(string searchText, SearchFilter filter, CancellationToken cancellationToken)', validate parameter 'filter' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageFeed.SearchAsync(System.String,NuGet.Protocol.Core.Types.SearchFilter,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IPackageSearchMetadata> MultiSourcePackageMetadataProvider.GetLatestPackageMetadataAsync(PackageIdentity identity, NuGetProject project, bool includePrerelease, CancellationToken cancellationToken)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageMetadataProvider.GetLatestPackageMetadataAsync(NuGet.Packaging.Core.PackageIdentity,NuGet.ProjectManagement.NuGetProject,System.Boolean,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.IPackageSearchMetadata}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IPackageSearchMetadata> MultiSourcePackageMetadataProvider.GetLocalPackageMetadataAsync(PackageIdentity identity, bool includePrerelease, CancellationToken cancellationToken)', validate parameter 'identity' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageMetadataProvider.GetLocalPackageMetadataAsync(NuGet.Packaging.Core.PackageIdentity,System.Boolean,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.IPackageSearchMetadata}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IPackageSearchMetadata> MultiSourcePackageMetadataProvider.GetPackageMetadataAsync(PackageIdentity identity, bool includePrerelease, CancellationToken cancellationToken)', validate parameter 'identity' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageMetadataProvider.GetPackageMetadataAsync(NuGet.Packaging.Core.PackageIdentity,System.Boolean,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.IPackageSearchMetadata}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<bool> CpsPackageReferenceProject.InstallPackageAsync(string packageId, VersionRange range, INuGetProjectContext nuGetProjectContext, BuildIntegratedInstallationContext installationContext, CancellationToken token)', validate parameter 'range' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.CpsPackageReferenceProject.InstallPackageAsync(System.String,NuGet.Versioning.VersionRange,NuGet.ProjectManagement.INuGetProjectContext,NuGet.ProjectManagement.BuildIntegratedInstallationContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'NuGetLockService.NuGetLockService(JoinableTaskContext joinableTaskContext)', validate parameter 'joinableTaskContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.NuGetLockService.#ctor(Microsoft.VisualStudio.Threading.JoinableTaskContext)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'CreateNuGetProjectAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.NuGetProjectFactory.CreateNuGetProjectAsync``1(NuGet.VisualStudio.IVsProjectAdapter,NuGet.PackageManagement.VisualStudio.ProjectProviderContext)~System.Threading.Tasks.Task{``0}")]
[assembly: SuppressMessage("Design", "CA1031:Do not catch general exception types", Justification = "Not all failures are within our control, and failures to initialize one project system type should not crash the initialization.", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.NuGetProjectFactory.TryCreateNuGetProjectAsync(NuGet.VisualStudio.IVsProjectAdapter,NuGet.PackageManagement.VisualStudio.ProjectProviderContext)~System.Threading.Tasks.Task{NuGet.ProjectManagement.NuGetProject}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task ProjectRetargetingUtility.MarkPackagesForReinstallation(NuGetProject project, IList<PackageIdentity> packagesToBeReinstalled)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.ProjectRetargetingUtility.MarkPackagesForReinstallation(NuGet.ProjectManagement.NuGetProject,System.Collections.Generic.IList{NuGet.Packaging.Core.PackageIdentity})~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'MarkPackagesForReinstallation' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.ProjectRetargetingUtility.MarkPackagesForReinstallation(NuGet.ProjectManagement.NuGetProject,System.Collections.Generic.IList{NuGet.Packaging.Core.PackageIdentity})~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'ShouldPackageBeReinstalled' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.ProjectRetargetingUtility.ShouldPackageBeReinstalled(NuGet.Frameworks.NuGetFramework,NuGet.Frameworks.NuGetFramework,NuGet.Packaging.Core.PackageIdentity,NuGet.PackageManagement.NuGetPackageManager)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void RefreshFileUtility.CreateRefreshFile(string root, string assemblyPath, IMSBuildProjectSystem msbuildNuGetProjectSystem)', validate parameter 'msbuildNuGetProjectSystem' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.RefreshFileUtility.CreateRefreshFile(System.String,System.String,NuGet.ProjectManagement.IMSBuildProjectSystem)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'SafeResolveRefreshPath' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.RefreshFileUtility.SafeResolveRefreshPath(System.String,System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetBooleanSetting' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.RegistrySettingUtility.GetBooleanSetting(System.String)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'SetBooleanSetting' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.RegistrySettingUtility.SetBooleanSetting(System.String,System.Boolean)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IEnumerable<AssemblyBinding>> RuntimeHelpers.AddBindingRedirectsAsync(ISolutionManager solutionManager, IVsProjectAdapter vsProjectAdapter, AppDomain domain, IDictionary<string, HashSet<string>> projectAssembliesCache, IVsFrameworkMultiTargeting frameworkMultiTargeting, INuGetProjectContext nuGetProjectContext)', validate parameter 'projectAssembliesCache' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.RuntimeHelpers.AddBindingRedirectsAsync(NuGet.PackageManagement.ISolutionManager,NuGet.VisualStudio.IVsProjectAdapter,System.AppDomain,System.Collections.Generic.IDictionary{System.String,System.Collections.Generic.HashSet{System.String}},Microsoft.VisualStudio.Shell.Interop.IVsFrameworkMultiTargeting,NuGet.ProjectManagement.INuGetProjectContext)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.VisualStudio.AssemblyBinding}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task RuntimeHelpers.AddBindingRedirectsAsync(VSSolutionManager vsSolutionManager, IVsProjectAdapter vsProjectAdapter, IVsFrameworkMultiTargeting frameworkMultiTargeting, INuGetProjectContext nuGetProjectContext)', validate parameter 'vsSolutionManager' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.RuntimeHelpers.AddBindingRedirectsAsync(NuGet.PackageManagement.VisualStudio.VSSolutionManager,NuGet.VisualStudio.IVsProjectAdapter,Microsoft.VisualStudio.Shell.Interop.IVsFrameworkMultiTargeting,NuGet.ProjectManagement.INuGetProjectContext)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'QueueUnloadAndForget' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.RuntimeHelpers.QueueUnloadAndForget(System.AppDomain)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'SearchResult<T> SearchResult.FromItems<T>(IReadOnlyList<T> items)', validate parameter 'items' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.SearchResult.FromItems``1(System.Collections.Generic.IReadOnlyList{``0})~NuGet.PackageManagement.VisualStudio.SearchResult{``0}")]
[assembly: SuppressMessage("Build", "CA1303:Method 'void SettingsHelper.AddSource(string name, string source)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"sourceRepositoryProvider\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.SettingsHelper.AddSource(System.String,System.String)")]
[assembly: SuppressMessage("Build", "CA1303:Method 'void SettingsHelper.RemoveSource(string name)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"sourceRepositoryProvider\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.SettingsHelper.RemoveSource(System.String)")]
[assembly: SuppressMessage("Build", "CA1303:Method 'Task<SearchResult<IPackageSearchMetadata>> SourceRepositoryExtensions.SearchAsync(SourceRepository sourceRepository, ContinuationToken continuationToken, int pageSize, CancellationToken cancellationToken)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Invalid token\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.SourceRepositoryExtensions.SearchAsync(NuGet.Protocol.Core.Types.SourceRepository,NuGet.PackageManagement.VisualStudio.ContinuationToken,System.Int32,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'SaveProjectAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsCoreProjectSystem.SaveProjectAsync(System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetProjectReferencesAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsCoreProjectSystemReferenceReader.GetProjectReferencesAsync(NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.ProjectModel.ProjectRestoreReference}}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'IsReferenceResolved' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsCoreProjectSystemReferenceReader.IsReferenceResolved(VSLangProj80.Reference3,NuGet.Common.ILogger)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'TryImportCredentialProviders' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsCredentialProviderImporter.TryImportCredentialProviders(System.Collections.Generic.List{NuGet.Credentials.ICredentialProvider},System.Collections.Generic.IEnumerable{System.Lazy{NuGet.VisualStudio.IVsCredentialProvider}})")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'AddReferenceAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem.AddReferenceAsync(System.String)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1801:Parameter desiredKind of method GetChildItems is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem.GetChildItems(System.String,System.String,System.String)~System.Collections.Generic.IEnumerable{System.String}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'ReferenceExistsAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem.ReferenceExistsAsync(System.String)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'RemoveReferenceAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem.RemoveReferenceAsync(System.String)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'SaveProjectAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem.SaveProjectAsync(System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'UpdateImportStamp' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem.UpdateImportStamp(NuGet.VisualStudio.IVsProjectAdapter)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void VsMSBuildProjectSystem.UpdateImportStamp(IVsProjectAdapter vsProjectAdapter)', validate parameter 'vsProjectAdapter' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem.UpdateImportStamp(NuGet.VisualStudio.IVsProjectAdapter)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<string> VSRestoreSettingsUtilities.GetEntriesWithAdditional(string[] values, string[] additional)', validate parameter 'additional' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSRestoreSettingsUtilities.GetEntriesWithAdditional(System.String[],System.String[])~System.Collections.Generic.IEnumerable{System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IList<string> VSRestoreSettingsUtilities.GetFallbackFolders(ISettings settings, PackageSpec project)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSRestoreSettingsUtilities.GetFallbackFolders(NuGet.Configuration.ISettings,NuGet.ProjectModel.PackageSpec)~System.Collections.Generic.IList{System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string VSRestoreSettingsUtilities.GetPackagesPath(ISettings settings, PackageSpec project)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSRestoreSettingsUtilities.GetPackagesPath(NuGet.Configuration.ISettings,NuGet.ProjectModel.PackageSpec)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IList<PackageSource> VSRestoreSettingsUtilities.GetSources(ISettings settings, PackageSpec project)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSRestoreSettingsUtilities.GetSources(NuGet.Configuration.ISettings,NuGet.ProjectModel.PackageSpec)~System.Collections.Generic.IList{NuGet.Configuration.PackageSource}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'EnsureInitializeAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSSolutionManager.EnsureInitializeAsync~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'EnsureNuGetAndVsProjectAdapterCacheAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSSolutionManager.EnsureNuGetAndVsProjectAdapterCacheAsync~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'FireNuGetCacheUpdatedEventAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSSolutionManager.FireNuGetCacheUpdatedEventAsync(NuGet.PackageManagement.NuGetEventArgs{System.String})~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'RemoveDTEReference' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.WebSiteProjectSystem.RemoveDTEReference(System.String)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'RemoveReferenceAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.WebSiteProjectSystem.RemoveReferenceAsync(System.String)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property DeprecatedFrameworkModel.MigrationUrl from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.PackageManagement.VisualStudio.DeprecatedFrameworkModel.MigrationUrl")]
[assembly: SuppressMessage("Build", "CA2227:Change 'SourceSearchException' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.PackageManagement.VisualStudio.SearchResult`1.SourceSearchException")]
[assembly: SuppressMessage("Build", "CA2227:Change 'SourceSearchStatus' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.PackageManagement.VisualStudio.SearchResult`1.SourceSearchStatus")]
[assembly: SuppressMessage("Globalization", "CA1308:Normalize strings to uppercase", Justification = "We require lowercase package names in telemetry so that the hashes are consistent", Scope = "member", Target = "~M:NuGet.PackageManagement.Telemetry.VSTelemetryServiceUtility.NormalizePackageId(System.String)~System.String")]
[assembly: SuppressMessage("Design", "CA1031:Do not catch general exception types", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageMetadataProvider.GetMetadataTaskSafeAsync``1(System.Func{System.Threading.Tasks.Task{``0}})~System.Threading.Tasks.Task{``0}")]
[assembly: SuppressMessage("Design", "CA1031:Do not catch general exception types", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.CpsProjectSystemReferenceReader.GetProjectReferencesAsync(NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.ProjectModel.ProjectRestoreReference}}")]
[assembly: SuppressMessage("Design", "CA1031:Do not catch general exception types", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.NativeProjectSystemReferencesReader.GetProjectReferencesAsync(NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.ProjectModel.ProjectRestoreReference}}")]
[assembly: SuppressMessage("Design", "CA1031:Do not catch general exception types", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsCoreProjectSystemReferenceReader.IsProjectReference(VSLangProj80.Reference3,NuGet.Common.ILogger)~System.Boolean")]
[assembly: SuppressMessage("Design", "CA1031:Do not catch general exception types", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.WixProjectSystem.GetPropertyValue(System.String)~System.Object")]
[assembly: SuppressMessage("Design", "CA1031:Do not catch general exception types", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.NuGetPackageFileService.GetEmbeddedFileAsync(System.Uri,System.Threading.CancellationToken)~System.Threading.Tasks.ValueTask{System.IO.Stream}")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.CpsPackageReferenceProject.GetConfigFilePaths(NuGet.Configuration.ISettings)~System.Collections.Generic.IList{System.String}")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.CpsPackageReferenceProject.IgnoreUnsupportProjectReference(NuGet.ProjectModel.PackageSpec)")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.CpsPackageReferenceProject.SetPackagePropertyValueAsync(Microsoft.VisualStudio.ProjectSystem.Properties.IProjectProperties,System.String,System.String)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProject.ToCentralPackageVersion(System.String,System.String)~NuGet.LibraryModel.CentralPackageVersion")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.NuGetPackageFileService.GetEmbeddedFileAsync(System.Uri,System.Threading.CancellationToken)~System.Threading.Tasks.ValueTask{System.IO.Stream}")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.NuGetProjectManagerService.CatchAndRethrowExceptionAsync(System.Func{System.Threading.Tasks.Task})~System.Threading.Tasks.ValueTask")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.NuGetProjectManagerService.CatchAndRethrowExceptionAsync``1(System.Func{System.Threading.Tasks.Task{``0}})~System.Threading.Tasks.ValueTask{``0}")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.PackageReferenceProject`2.GetPackageReferences(System.Collections.Generic.IEnumerable{NuGet.LibraryModel.LibraryDependency},NuGet.Frameworks.NuGetFramework,System.Collections.Generic.Dictionary{System.String,NuGet.PackageManagement.VisualStudio.Utility.ProjectInstalledPackage},System.Collections.Generic.IList{NuGet.ProjectModel.LockFileTarget})~System.Collections.Generic.IEnumerable{NuGet.Packaging.PackageReference}")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.PackageReferenceProject`2.GetTransitivePackageReferences(NuGet.Frameworks.NuGetFramework,System.Collections.Generic.Dictionary{System.String,NuGet.PackageManagement.VisualStudio.Utility.ProjectInstalledPackage},System.Collections.Generic.Dictionary{System.String,NuGet.PackageManagement.VisualStudio.Utility.ProjectInstalledPackage},System.Collections.Generic.IList{NuGet.ProjectModel.LockFileTarget})~System.Collections.Generic.IReadOnlyList{NuGet.Packaging.PackageReference}")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.PackageVulnerabilityService.ConvertToPackageVulnerabilityMetadataContextInfo(System.Collections.Generic.IEnumerable{NuGet.Protocol.Model.PackageVulnerabilityInfo})~System.Collections.Generic.List{NuGet.VisualStudio.Internal.Contracts.PackageVulnerabilityMetadataContextInfo}")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsCoreProjectSystemReferenceReader.IsProjectReference(VSLangProj80.Reference3,NuGet.Common.ILogger)~System.Boolean")]
[assembly: SuppressMessage("Performance", "CA1822:Mark members as static", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsCoreProjectSystemReferenceReader.IsReferenceResolved(VSLangProj80.Reference3,NuGet.Common.ILogger)~System.Boolean")]
[assembly: SuppressMessage("Globalization", "CA1305:Specify IFormatProvider", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.CpsPackageReferenceProject.UninstallPackageAsync(System.String,NuGet.ProjectManagement.BuildIntegratedInstallationContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Globalization", "CA1305:Specify IFormatProvider", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProject.UninstallPackageAsync(System.String,NuGet.ProjectManagement.BuildIntegratedInstallationContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Reliability", "CA2016:Forward the 'CancellationToken' parameter to methods", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.CpsProjectSystemReferenceReader.GetProjectReferencesAsync(NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.ProjectModel.ProjectRestoreReference}}")]
[assembly: SuppressMessage("Reliability", "CA2016:Forward the 'CancellationToken' parameter to methods", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageFeed.WaitForCompletionOrBailOutAsync(System.String,System.Collections.Generic.IDictionary{System.String,System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}},NuGet.PackageManagement.VisualStudio.MultiSourcePackageFeed.TelemetryState,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Reliability", "CA2016:Forward the 'CancellationToken' parameter to methods", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.NativeProjectSystemReferencesReader.GetProjectReferencesAsync(NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.ProjectModel.ProjectRestoreReference}}")]
[assembly: SuppressMessage("Reliability", "CA2016:Forward the 'CancellationToken' parameter to methods", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.SharedServiceState.GetRepositoriesAsync(System.Collections.Generic.IReadOnlyCollection{NuGet.VisualStudio.Internal.Contracts.PackageSourceContextInfo},System.Threading.CancellationToken)~System.Threading.Tasks.ValueTask{System.Collections.Generic.IReadOnlyCollection{NuGet.Protocol.Core.Types.SourceRepository}}")]
[assembly: SuppressMessage("Reliability", "CA2016:Forward the 'CancellationToken' parameter to methods", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsCoreProjectSystem.SaveProjectAsync(System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Reliability", "CA2016:Forward the 'CancellationToken' parameter to methods", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsCoreProjectSystemReferenceReader.GetProjectReferencesAsync(NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.ProjectModel.ProjectRestoreReference}}")]
[assembly: SuppressMessage("Reliability", "CA2016:Forward the 'CancellationToken' parameter to methods", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsManagedLanguagesProjectSystemServices.AddOrUpdatePackageReferenceAsync(NuGet.LibraryModel.LibraryDependency,System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Reliability", "CA2016:Forward the 'CancellationToken' parameter to methods", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsManagedLanguagesProjectSystemServices.GetPackageReferencesAsync(NuGet.Frameworks.NuGetFramework,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.LibraryModel.LibraryDependency}}")]
[assembly: SuppressMessage("Reliability", "CA2016:Forward the 'CancellationToken' parameter to methods", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsManagedLanguagesProjectSystemServices.GetProjectReferencesAsync(NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.ProjectModel.ProjectRestoreReference}}")]
[assembly: SuppressMessage("Reliability", "CA2016:Forward the 'CancellationToken' parameter to methods", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem.SaveProjectAsync(System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
