﻿using Xunit;

namespace Humanizer.Tests.Localisation.uzCyrl
{
    [UseCulture("uz-Cyrl-UZ")]
    public class NumberToWordsTests
    {

        [Theory]
        [InlineData(0, "нол")]
        [InlineData(1, "бир")]
        [InlineData(10, "ўн")]
        [InlineData(11, "ўн бир")]
        [InlineData(12, "ўн икки")]
        [InlineData(13, "ўн уч")]
        [InlineData(14, "ўн тўрт")]
        [InlineData(15, "ўн беш")]
        [InlineData(16, "ўн олти")]
        [InlineData(17, "ўн етти")]
        [InlineData(18, "ўн саккиз")]
        [InlineData(19, "ўн тўққиз")]
        [InlineData(20, "йигирма")]
        [InlineData(30, "ўттиз")]
        [InlineData(40, "қирқ")]
        [InlineData(50, "эллик")]
        [InlineData(60, "олтмиш")]
        [InlineData(70, "етмиш")]
        [InlineData(80, "саксон")]
        [InlineData(90, "тўқсон")]
        [InlineData(100, "юз")]
        [InlineData(200, "икки юз")]
        [InlineData(300, "уч юз")]
        [InlineData(400, "тўрт юз")]
        [InlineData(500, "беш юз")]
        [InlineData(600, "олти юз")]
        [InlineData(700, "етти юз")]
        [InlineData(800, "саккиз юз")]
        [InlineData(900, "тўққиз юз")]
        [InlineData(1000, "бир минг")]
        [InlineData(2000, "икки минг")]
        [InlineData(3000, "уч минг")]
        [InlineData(10000, "ўн минг")]
        [InlineData(100000, "юз минг")]
        [InlineData(100100, "юз минг бир юз")]
        [InlineData(200100, "икки юз минг бир юз")]
        [InlineData(1000000, "бир миллион")]
        [InlineData(1001000, "бир миллион бир минг")]
        [InlineData(1000100, "бир миллион бир юз")]
        [InlineData(2000000, "икки миллион")]
        [InlineData(10000000, "ўн миллион")]
        [InlineData(100000000, "юз миллион")]
        [InlineData(100001000, "юз миллион бир минг")]
        [InlineData(1000000000, "бир миллиард")]
        [InlineData(2000000000, "икки миллиард")]
        [InlineData(122, "бир юз йигирма икки")]
        [InlineData(3501, "уч минг беш юз бир")]
        [InlineData(111, "бир юз ўн бир")]
        [InlineData(1112, "бир минг бир юз ўн икки")]
        [InlineData(11213, "ўн бир минг икки юз ўн уч")]
        [InlineData(121314, "бир юз йигирма бир минг уч юз ўн тўрт")]
        [InlineData(2132415, "икки миллион бир юз ўттиз икки минг тўрт юз ўн беш")]
        [InlineData(12345516, "ўн икки миллион уч юз қирқ беш минг беш юз ўн олти")]
        [InlineData(751633617, "етти юз эллик бир миллион олти юз ўттиз уч минг олти юз ўн етти")]
        [InlineData(1111111118, "бир миллиард бир юз ўн бир миллион бир юз ўн бир минг бир юз ўн саккиз")]
        [InlineData(-751633617, "минус етти юз эллик бир миллион олти юз ўттиз уч минг олти юз ўн етти")]
        public void ToWords(int number, string expected)
        {
            Assert.Equal(expected, number.ToWords());
        }

        [Theory]
        [InlineData(0, "нолинчи")]
        [InlineData(1, "биринчи")]
        [InlineData(10, "ўнинчи")]
        [InlineData(11, "ўн биринчи")]
        [InlineData(12, "ўн иккинчи")]
        [InlineData(13, "ўн учинчи")]
        [InlineData(14, "ўн тўртинчи")]
        [InlineData(15, "ўн бешинчи")]
        [InlineData(16, "ўн олтинчи")]
        [InlineData(17, "ўн еттинчи")]
        [InlineData(18, "ўн саккизинчи")]
        [InlineData(19, "ўн тўққизинчи")]
        [InlineData(20, "йигирманчи")]
        [InlineData(30, "ўттизинчи")]
        [InlineData(40, "қирқинчи")]
        [InlineData(50, "элликинчи")]
        [InlineData(60, "олтмишинчи")]
        [InlineData(70, "етмишинчи")]
        [InlineData(80, "саксонинчи")]
        [InlineData(90, "тўқсонинчи")]
        [InlineData(100, "юзинчи")]
        [InlineData(200, "икки юзинчи")]
        [InlineData(1000, "бир мингинчи")]
        [InlineData(2000000, "икки миллионинчи")]
        [InlineData(1000000000, "бир миллиардинчи")]
        [InlineData(122, "бир юз йигирма иккинчи")]
        [InlineData(3501, "уч минг беш юз биринчи")]
        [InlineData(111, "бир юз ўн биринчи")]
        [InlineData(751633617, "етти юз эллик бир миллион олти юз ўттиз уч минг олти юз ўн еттинчи")]
        [InlineData(1111111118, "бир миллиард бир юз ўн бир миллион бир юз ўн бир минг бир юз ўн саккизинчи")]
        [InlineData(-751633617, "минус етти юз эллик бир миллион олти юз ўттиз уч минг олти юз ўн еттинчи")]
        public void ToOrdinalWords(int number, string words)
        {
            Assert.Equal(words, number.ToOrdinalWords());
        }
    }
}
