// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

//	The aggregation settings that you can use to customize the output format of
//
// your flow data.
type AggregationConfig struct {

	//  Specifies whether Amazon AppFlow aggregates the flow records into a single
	// file, or leave them unaggregated.
	AggregationType AggregationType

	// The desired file size, in MB, for each output file that Amazon AppFlow writes
	// to the flow destination. For each file, Amazon AppFlow attempts to achieve the
	// size that you specify. The actual file sizes might differ from this target based
	// on the number and size of the records that each file contains.
	TargetFileSize *int64

	noSmithyDocumentSerde
}

// The connector-specific credentials required when using Amplitude.
type AmplitudeConnectorProfileCredentials struct {

	//  A unique alphanumeric identifier used to authenticate a user, developer, or
	// calling program to your API.
	//
	// This member is required.
	ApiKey *string

	//  The Secret Access Key portion of the credentials.
	//
	// This member is required.
	SecretKey *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Amplitude.
type AmplitudeConnectorProfileProperties struct {
	noSmithyDocumentSerde
}

// The connector metadata specific to Amplitude.
type AmplitudeMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when Amplitude is being used as a source.
type AmplitudeSourceProperties struct {

	//  The object specified in the Amplitude flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// The API key credentials required for API key authentication.
type ApiKeyCredentials struct {

	// The API key required for API key authentication.
	//
	// This member is required.
	ApiKey *string

	// The API secret key required for API key authentication.
	ApiSecretKey *string

	noSmithyDocumentSerde
}

// Contains information about the authentication config that the connector
// supports.
type AuthenticationConfig struct {

	// Contains information required for custom authentication.
	CustomAuthConfigs []CustomAuthConfig

	// Indicates whether API key authentication is supported by the connector
	IsApiKeyAuthSupported bool

	// Indicates whether basic authentication is supported by the connector.
	IsBasicAuthSupported bool

	// Indicates whether custom authentication is supported by the connector
	IsCustomAuthSupported bool

	// Indicates whether OAuth 2.0 authentication is supported by the connector.
	IsOAuth2Supported bool

	// Contains the default values required for OAuth 2.0 authentication.
	OAuth2Defaults *OAuth2Defaults

	noSmithyDocumentSerde
}

// Information about required authentication parameters.
type AuthParameter struct {

	// Contains default values for this authentication parameter that are supplied by
	// the connector.
	ConnectorSuppliedValues []string

	// A description about the authentication parameter.
	Description *string

	// Indicates whether this authentication parameter is required.
	IsRequired bool

	// Indicates whether this authentication parameter is a sensitive field.
	IsSensitiveField bool

	// The authentication key required to authenticate with the connector.
	Key *string

	// Label used for authentication parameter.
	Label *string

	noSmithyDocumentSerde
}

// The basic auth credentials required for basic authentication.
type BasicAuthCredentials struct {

	//  The password to use to connect to a resource.
	//
	// This member is required.
	Password *string

	//  The username to use to connect to a resource.
	//
	// This member is required.
	Username *string

	noSmithyDocumentSerde
}

// The configuration settings related to a given connector.
type ConnectorConfiguration struct {

	// The authentication config required for the connector.
	AuthenticationConfig *AuthenticationConfig

	//  Specifies whether the connector can be used as a destination.
	CanUseAsDestination bool

	//  Specifies whether the connector can be used as a source.
	CanUseAsSource bool

	// The Amazon Resource Name (ARN) for the registered connector.
	ConnectorArn *string

	// A description about the connector.
	ConnectorDescription *string

	// The label used for registering the connector.
	ConnectorLabel *string

	//  Specifies connector-specific metadata such as oAuthScopes , supportedRegions ,
	// privateLinkServiceUrl , and so on.
	ConnectorMetadata *ConnectorMetadata

	// The connection modes that the connector supports.
	ConnectorModes []string

	// The connector name.
	ConnectorName *string

	// The owner who developed the connector.
	ConnectorOwner *string

	// The configuration required for registering the connector.
	ConnectorProvisioningConfig *ConnectorProvisioningConfig

	// The provisioning type used to register the connector.
	ConnectorProvisioningType ConnectorProvisioningType

	// The required connector runtime settings.
	ConnectorRuntimeSettings []ConnectorRuntimeSetting

	// The connector type.
	ConnectorType ConnectorType

	// The connector version.
	ConnectorVersion *string

	//  Specifies if PrivateLink is enabled for that connector.
	IsPrivateLinkEnabled bool

	//  Specifies if a PrivateLink endpoint URL is required.
	IsPrivateLinkEndpointUrlRequired bool

	// Logo URL of the connector.
	LogoURL *string

	// The date on which the connector was registered.
	RegisteredAt *time.Time

	// Information about who registered the connector.
	RegisteredBy *string

	// A list of API versions that are supported by the connector.
	SupportedApiVersions []string

	// The APIs of the connector application that Amazon AppFlow can use to transfer
	// your data.
	SupportedDataTransferApis []DataTransferApi

	// The data transfer types that the connector supports.
	//
	// RECORD Structured records.
	//
	// FILE Files or binary data.
	SupportedDataTransferTypes []SupportedDataTransferType

	//  Lists the connectors that are available for use as destinations.
	SupportedDestinationConnectors []ConnectorType

	// A list of operators supported by the connector.
	SupportedOperators []Operators

	//  Specifies the supported flow frequency for that connector.
	SupportedSchedulingFrequencies []ScheduleFrequencyType

	//  Specifies the supported trigger types for the flow.
	SupportedTriggerTypes []TriggerType

	// A list of write operations supported by the connector.
	SupportedWriteOperations []WriteOperationType

	noSmithyDocumentSerde
}

// Information about the registered connector.
type ConnectorDetail struct {

	// The application type of the connector.
	ApplicationType *string

	// A description about the registered connector.
	ConnectorDescription *string

	// A label used for the connector.
	ConnectorLabel *string

	// The connection mode that the connector supports.
	ConnectorModes []string

	// The name of the connector.
	ConnectorName *string

	// The owner of the connector.
	ConnectorOwner *string

	// The provisioning type that the connector uses.
	ConnectorProvisioningType ConnectorProvisioningType

	// The connector type.
	ConnectorType ConnectorType

	// The connector version.
	ConnectorVersion *string

	// The time at which the connector was registered.
	RegisteredAt *time.Time

	// The user who registered the connector.
	RegisteredBy *string

	// The data transfer types that the connector supports.
	//
	// RECORD Structured records.
	//
	// FILE Files or binary data.
	SupportedDataTransferTypes []SupportedDataTransferType

	noSmithyDocumentSerde
}

//	The high-level entity that can be queried in Amazon AppFlow. For example, a
//
// Salesforce entity might be an Account or Opportunity, whereas a ServiceNow
// entity might be an Incident.
type ConnectorEntity struct {

	//  The name of the connector entity.
	//
	// This member is required.
	Name *string

	//  Specifies whether the connector entity is a parent or a category and has more
	// entities nested underneath it. If another call is made with entitiesPath =
	// "the_current_entity_name_with_hasNestedEntities_true" , then it returns the
	// nested entities underneath it. This provides a way to retrieve all supported
	// entities in a recursive fashion.
	HasNestedEntities bool

	//  The label applied to the connector entity.
	Label *string

	noSmithyDocumentSerde
}

//	Describes the data model of a connector field. For example, for an account
//
// entity, the fields would be account name, account ID, and so on.
type ConnectorEntityField struct {

	//  The unique identifier of the connector field.
	//
	// This member is required.
	Identifier *string

	// A map that has specific properties related to the ConnectorEntityField.
	CustomProperties map[string]string

	// Default value that can be assigned to this field.
	DefaultValue *string

	//  A description of the connector entity field.
	Description *string

	//  The properties applied to a field when the connector is being used as a
	// destination.
	DestinationProperties *DestinationFieldProperties

	// Booelan value that indicates whether this field is deprecated or not.
	IsDeprecated bool

	// Booelan value that indicates whether this field can be used as a primary key.
	IsPrimaryKey bool

	//  The label applied to a connector entity field.
	Label *string

	// The parent identifier of the connector field.
	ParentIdentifier *string

	//  The properties that can be applied to a field when the connector is being used
	// as a source.
	SourceProperties *SourceFieldProperties

	//  Contains details regarding the supported FieldType , including the
	// corresponding filterOperators and supportedValues .
	SupportedFieldTypeDetails *SupportedFieldTypeDetails

	noSmithyDocumentSerde
}

//	A structure to specify connector-specific metadata such as oAuthScopes ,
//
// supportedRegions , privateLinkServiceUrl , and so on.
type ConnectorMetadata struct {

	//  The connector metadata specific to Amplitude.
	Amplitude *AmplitudeMetadata

	//  The connector metadata specific to Amazon Connect Customer Profiles.
	CustomerProfiles *CustomerProfilesMetadata

	//  The connector metadata specific to Datadog.
	Datadog *DatadogMetadata

	//  The connector metadata specific to Dynatrace.
	Dynatrace *DynatraceMetadata

	//  The connector metadata specific to Amazon EventBridge.
	EventBridge *EventBridgeMetadata

	//  The connector metadata specific to Google Analytics.
	GoogleAnalytics *GoogleAnalyticsMetadata

	//  The connector metadata specific to Amazon Honeycode.
	Honeycode *HoneycodeMetadata

	//  The connector metadata specific to Infor Nexus.
	InforNexus *InforNexusMetadata

	//  The connector metadata specific to Marketo.
	Marketo *MarketoMetadata

	// The connector metadata specific to Salesforce Pardot.
	Pardot *PardotMetadata

	//  The connector metadata specific to Amazon Redshift.
	Redshift *RedshiftMetadata

	//  The connector metadata specific to Amazon S3.
	S3 *S3Metadata

	//  The connector metadata specific to SAPOData.
	SAPOData *SAPODataMetadata

	//  The connector metadata specific to Salesforce.
	Salesforce *SalesforceMetadata

	//  The connector metadata specific to ServiceNow.
	ServiceNow *ServiceNowMetadata

	//  The connector metadata specific to Singular.
	Singular *SingularMetadata

	//  The connector metadata specific to Slack.
	Slack *SlackMetadata

	//  The connector metadata specific to Snowflake.
	Snowflake *SnowflakeMetadata

	//  The connector metadata specific to Trend Micro.
	Trendmicro *TrendmicroMetadata

	//  The connector metadata specific to Upsolver.
	Upsolver *UpsolverMetadata

	//  The connector metadata specific to Veeva.
	Veeva *VeevaMetadata

	//  The connector metadata specific to Zendesk.
	Zendesk *ZendeskMetadata

	noSmithyDocumentSerde
}

//	Used by select connectors for which the OAuth workflow is supported, such as
//
// Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
type ConnectorOAuthRequest struct {

	//  The code provided by the connector when it has been authenticated via the
	// connected app.
	AuthCode *string

	//  The URL to which the authentication server redirects the browser after
	// authorization has been granted.
	RedirectUri *string

	noSmithyDocumentSerde
}

// The operation to be performed on the provided source fields.
type ConnectorOperator struct {

	//  The operation to be performed on the provided Amplitude source fields.
	Amplitude AmplitudeConnectorOperator

	// Operators supported by the custom connector.
	CustomConnector Operator

	//  The operation to be performed on the provided Datadog source fields.
	Datadog DatadogConnectorOperator

	//  The operation to be performed on the provided Dynatrace source fields.
	Dynatrace DynatraceConnectorOperator

	//  The operation to be performed on the provided Google Analytics source fields.
	GoogleAnalytics GoogleAnalyticsConnectorOperator

	//  The operation to be performed on the provided Infor Nexus source fields.
	InforNexus InforNexusConnectorOperator

	//  The operation to be performed on the provided Marketo source fields.
	Marketo MarketoConnectorOperator

	// The operation to be performed on the provided Salesforce Pardot source fields.
	Pardot PardotConnectorOperator

	//  The operation to be performed on the provided Amazon S3 source fields.
	S3 S3ConnectorOperator

	//  The operation to be performed on the provided SAPOData source fields.
	SAPOData SAPODataConnectorOperator

	//  The operation to be performed on the provided Salesforce source fields.
	Salesforce SalesforceConnectorOperator

	//  The operation to be performed on the provided ServiceNow source fields.
	ServiceNow ServiceNowConnectorOperator

	//  The operation to be performed on the provided Singular source fields.
	Singular SingularConnectorOperator

	//  The operation to be performed on the provided Slack source fields.
	Slack SlackConnectorOperator

	//  The operation to be performed on the provided Trend Micro source fields.
	Trendmicro TrendmicroConnectorOperator

	//  The operation to be performed on the provided Veeva source fields.
	Veeva VeevaConnectorOperator

	//  The operation to be performed on the provided Zendesk source fields.
	Zendesk ZendeskConnectorOperator

	noSmithyDocumentSerde
}

//	Describes an instance of a connector. This includes the provided name,
//
// credentials ARN, connection-mode, and so on. To keep the API intuitive and
// extensible, the fields that are common to all types of connector profiles are
// explicitly specified at the top level. The rest of the connector-specific
// properties are available via the connectorProfileProperties field.
type ConnectorProfile struct {

	//  Indicates the connection mode and if it is public or private.
	ConnectionMode ConnectionMode

	// The label for the connector profile being created.
	ConnectorLabel *string

	//  The Amazon Resource Name (ARN) of the connector profile.
	ConnectorProfileArn *string

	//  The name of the connector profile. The name is unique for each ConnectorProfile
	// in the Amazon Web Services account.
	ConnectorProfileName *string

	//  The connector-specific properties of the profile configuration.
	ConnectorProfileProperties *ConnectorProfileProperties

	//  The type of connector, such as Salesforce, Amplitude, and so on.
	ConnectorType ConnectorType

	//  Specifies when the connector profile was created.
	CreatedAt *time.Time

	//  The Amazon Resource Name (ARN) of the connector profile credentials.
	CredentialsArn *string

	//  Specifies when the connector profile was last updated.
	LastUpdatedAt *time.Time

	//  Specifies the private connection provisioning state.
	PrivateConnectionProvisioningState *PrivateConnectionProvisioningState

	noSmithyDocumentSerde
}

//	Defines the connector-specific configuration and credentials for the connector
//
// profile.
type ConnectorProfileConfig struct {

	//  The connector-specific properties of the profile configuration.
	//
	// This member is required.
	ConnectorProfileProperties *ConnectorProfileProperties

	//  The connector-specific credentials required by each connector.
	ConnectorProfileCredentials *ConnectorProfileCredentials

	noSmithyDocumentSerde
}

// The connector-specific credentials required by a connector.
type ConnectorProfileCredentials struct {

	//  The connector-specific credentials required when using Amplitude.
	Amplitude *AmplitudeConnectorProfileCredentials

	// The connector-specific profile credentials that are required when using the
	// custom connector.
	CustomConnector *CustomConnectorProfileCredentials

	//  The connector-specific credentials required when using Datadog.
	Datadog *DatadogConnectorProfileCredentials

	//  The connector-specific credentials required when using Dynatrace.
	Dynatrace *DynatraceConnectorProfileCredentials

	//  The connector-specific credentials required when using Google Analytics.
	GoogleAnalytics *GoogleAnalyticsConnectorProfileCredentials

	//  The connector-specific credentials required when using Amazon Honeycode.
	Honeycode *HoneycodeConnectorProfileCredentials

	//  The connector-specific credentials required when using Infor Nexus.
	InforNexus *InforNexusConnectorProfileCredentials

	//  The connector-specific credentials required when using Marketo.
	Marketo *MarketoConnectorProfileCredentials

	// The connector-specific credentials required when using Salesforce Pardot.
	Pardot *PardotConnectorProfileCredentials

	//  The connector-specific credentials required when using Amazon Redshift.
	Redshift *RedshiftConnectorProfileCredentials

	//  The connector-specific profile credentials required when using SAPOData.
	SAPOData *SAPODataConnectorProfileCredentials

	//  The connector-specific credentials required when using Salesforce.
	Salesforce *SalesforceConnectorProfileCredentials

	//  The connector-specific credentials required when using ServiceNow.
	ServiceNow *ServiceNowConnectorProfileCredentials

	//  The connector-specific credentials required when using Singular.
	Singular *SingularConnectorProfileCredentials

	//  The connector-specific credentials required when using Slack.
	Slack *SlackConnectorProfileCredentials

	//  The connector-specific credentials required when using Snowflake.
	Snowflake *SnowflakeConnectorProfileCredentials

	//  The connector-specific credentials required when using Trend Micro.
	Trendmicro *TrendmicroConnectorProfileCredentials

	//  The connector-specific credentials required when using Veeva.
	Veeva *VeevaConnectorProfileCredentials

	//  The connector-specific credentials required when using Zendesk.
	Zendesk *ZendeskConnectorProfileCredentials

	noSmithyDocumentSerde
}

// The connector-specific profile properties required by each connector.
type ConnectorProfileProperties struct {

	//  The connector-specific properties required by Amplitude.
	Amplitude *AmplitudeConnectorProfileProperties

	// The properties required by the custom connector.
	CustomConnector *CustomConnectorProfileProperties

	//  The connector-specific properties required by Datadog.
	Datadog *DatadogConnectorProfileProperties

	//  The connector-specific properties required by Dynatrace.
	Dynatrace *DynatraceConnectorProfileProperties

	//  The connector-specific properties required Google Analytics.
	GoogleAnalytics *GoogleAnalyticsConnectorProfileProperties

	//  The connector-specific properties required by Amazon Honeycode.
	Honeycode *HoneycodeConnectorProfileProperties

	//  The connector-specific properties required by Infor Nexus.
	InforNexus *InforNexusConnectorProfileProperties

	//  The connector-specific properties required by Marketo.
	Marketo *MarketoConnectorProfileProperties

	// The connector-specific properties required by Salesforce Pardot.
	Pardot *PardotConnectorProfileProperties

	//  The connector-specific properties required by Amazon Redshift.
	Redshift *RedshiftConnectorProfileProperties

	//  The connector-specific profile properties required when using SAPOData.
	SAPOData *SAPODataConnectorProfileProperties

	//  The connector-specific properties required by Salesforce.
	Salesforce *SalesforceConnectorProfileProperties

	//  The connector-specific properties required by serviceNow.
	ServiceNow *ServiceNowConnectorProfileProperties

	//  The connector-specific properties required by Singular.
	Singular *SingularConnectorProfileProperties

	//  The connector-specific properties required by Slack.
	Slack *SlackConnectorProfileProperties

	//  The connector-specific properties required by Snowflake.
	Snowflake *SnowflakeConnectorProfileProperties

	//  The connector-specific properties required by Trend Micro.
	Trendmicro *TrendmicroConnectorProfileProperties

	//  The connector-specific properties required by Veeva.
	Veeva *VeevaConnectorProfileProperties

	//  The connector-specific properties required by Zendesk.
	Zendesk *ZendeskConnectorProfileProperties

	noSmithyDocumentSerde
}

// Contains information about the configuration of the connector being registered.
type ConnectorProvisioningConfig struct {

	// Contains information about the configuration of the lambda which is being
	// registered as the connector.
	Lambda *LambdaConnectorProvisioningConfig

	noSmithyDocumentSerde
}

// Contains information about the connector runtime settings that are required for
// flow execution.
type ConnectorRuntimeSetting struct {

	// Contains default values for the connector runtime setting that are supplied by
	// the connector.
	ConnectorSuppliedValueOptions []string

	// Data type of the connector runtime setting.
	DataType *string

	// A description about the connector runtime setting.
	Description *string

	// Indicates whether this connector runtime setting is required.
	IsRequired bool

	// Contains value information about the connector runtime setting.
	Key *string

	// A label used for connector runtime setting.
	Label *string

	// Indicates the scope of the connector runtime setting.
	Scope *string

	noSmithyDocumentSerde
}

// Configuration information required for custom authentication.
type CustomAuthConfig struct {

	// Information about authentication parameters required for authentication.
	AuthParameters []AuthParameter

	// The authentication type that the custom connector uses.
	CustomAuthenticationType *string

	noSmithyDocumentSerde
}

// The custom credentials required for custom authentication.
type CustomAuthCredentials struct {

	// The custom authentication type that the connector uses.
	//
	// This member is required.
	CustomAuthenticationType *string

	// A map that holds custom authentication credentials.
	CredentialsMap map[string]string

	noSmithyDocumentSerde
}

// The properties that are applied when the custom connector is being used as a
// destination.
type CustomConnectorDestinationProperties struct {

	// The entity specified in the custom connector as a destination in the flow.
	//
	// This member is required.
	EntityName *string

	// The custom properties that are specific to the connector when it's used as a
	// destination in the flow.
	CustomProperties map[string]string

	// The settings that determine how Amazon AppFlow handles an error when placing
	// data in the custom connector as destination.
	ErrorHandlingConfig *ErrorHandlingConfig

	// The name of the field that Amazon AppFlow uses as an ID when performing a write
	// operation such as update, delete, or upsert.
	IdFieldNames []string

	// Specifies the type of write operation to be performed in the custom connector
	// when it's used as destination.
	WriteOperationType WriteOperationType

	noSmithyDocumentSerde
}

// The connector-specific profile credentials that are required when using the
// custom connector.
type CustomConnectorProfileCredentials struct {

	// The authentication type that the custom connector uses for authenticating while
	// creating a connector profile.
	//
	// This member is required.
	AuthenticationType AuthenticationType

	// The API keys required for the authentication of the user.
	ApiKey *ApiKeyCredentials

	// The basic credentials that are required for the authentication of the user.
	Basic *BasicAuthCredentials

	// If the connector uses the custom authentication mechanism, this holds the
	// required credentials.
	Custom *CustomAuthCredentials

	// The OAuth 2.0 credentials required for the authentication of the user.
	Oauth2 *OAuth2Credentials

	noSmithyDocumentSerde
}

// The profile properties required by the custom connector.
type CustomConnectorProfileProperties struct {

	// The OAuth 2.0 properties required for OAuth 2.0 authentication.
	OAuth2Properties *OAuth2Properties

	// A map of properties that are required to create a profile for the custom
	// connector.
	ProfileProperties map[string]string

	noSmithyDocumentSerde
}

// The properties that are applied when the custom connector is being used as a
// source.
type CustomConnectorSourceProperties struct {

	// The entity specified in the custom connector as a source in the flow.
	//
	// This member is required.
	EntityName *string

	// Custom properties that are required to use the custom connector as a source.
	CustomProperties map[string]string

	// The API of the connector application that Amazon AppFlow uses to transfer your
	// data.
	DataTransferApi *DataTransferApi

	noSmithyDocumentSerde
}

//	The properties that are applied when Amazon Connect Customer Profiles is used
//
// as a destination.
type CustomerProfilesDestinationProperties struct {

	//  The unique name of the Amazon Connect Customer Profiles domain.
	//
	// This member is required.
	DomainName *string

	//  The object specified in the Amazon Connect Customer Profiles flow destination.
	ObjectTypeName *string

	noSmithyDocumentSerde
}

// The connector metadata specific to Amazon Connect Customer Profiles.
type CustomerProfilesMetadata struct {
	noSmithyDocumentSerde
}

// The connector-specific credentials required by Datadog.
type DatadogConnectorProfileCredentials struct {

	//  A unique alphanumeric identifier used to authenticate a user, developer, or
	// calling program to your API.
	//
	// This member is required.
	ApiKey *string

	//  Application keys, in conjunction with your API key, give you full access to
	// Datadog’s programmatic API. Application keys are associated with the user
	// account that created them. The application key is used to log all requests made
	// to the API.
	//
	// This member is required.
	ApplicationKey *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required by Datadog.
type DatadogConnectorProfileProperties struct {

	//  The location of the Datadog resource.
	//
	// This member is required.
	InstanceUrl *string

	noSmithyDocumentSerde
}

// The connector metadata specific to Datadog.
type DatadogMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when Datadog is being used as a source.
type DatadogSourceProperties struct {

	//  The object specified in the Datadog flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// The API of the connector application that Amazon AppFlow uses to transfer your
// data.
type DataTransferApi struct {

	// The name of the connector application API.
	Name *string

	// You can specify one of the following types:
	//
	// AUTOMATIC The default. Optimizes a flow for datasets that fluctuate in size
	// from small to large. For each flow run, Amazon AppFlow chooses to use the SYNC
	// or ASYNC API type based on the amount of data that the run transfers.
	//
	// SYNC A synchronous API. This type of API optimizes a flow for small to
	// medium-sized datasets.
	//
	// ASYNC An asynchronous API. This type of API optimizes a flow for large datasets.
	Type DataTransferApiType

	noSmithyDocumentSerde
}

// This stores the information that is required to query a particular connector.
type DestinationConnectorProperties struct {

	// The properties that are required to query the custom Connector.
	CustomConnector *CustomConnectorDestinationProperties

	//  The properties required to query Amazon Connect Customer Profiles.
	CustomerProfiles *CustomerProfilesDestinationProperties

	//  The properties required to query Amazon EventBridge.
	EventBridge *EventBridgeDestinationProperties

	//  The properties required to query Amazon Honeycode.
	Honeycode *HoneycodeDestinationProperties

	//  The properties required to query Amazon Lookout for Metrics.
	LookoutMetrics *LookoutMetricsDestinationProperties

	// The properties required to query Marketo.
	Marketo *MarketoDestinationProperties

	//  The properties required to query Amazon Redshift.
	Redshift *RedshiftDestinationProperties

	//  The properties required to query Amazon S3.
	S3 *S3DestinationProperties

	// The properties required to query SAPOData.
	SAPOData *SAPODataDestinationProperties

	//  The properties required to query Salesforce.
	Salesforce *SalesforceDestinationProperties

	//  The properties required to query Snowflake.
	Snowflake *SnowflakeDestinationProperties

	//  The properties required to query Upsolver.
	Upsolver *UpsolverDestinationProperties

	// The properties required to query Zendesk.
	Zendesk *ZendeskDestinationProperties

	noSmithyDocumentSerde
}

//	The properties that can be applied to a field when connector is being used as
//
// a destination.
type DestinationFieldProperties struct {

	//  Specifies if the destination field can be created by the current user.
	IsCreatable bool

	// Specifies whether the field can use the default value during a Create operation.
	IsDefaultedOnCreate bool

	//  Specifies if the destination field can have a null value.
	IsNullable bool

	//  Specifies whether the field can be updated during an UPDATE or UPSERT write
	// operation.
	IsUpdatable bool

	//  Specifies if the flow run can either insert new rows in the destination field
	// if they do not already exist, or update them if they do.
	IsUpsertable bool

	//  A list of supported write operations. For each write operation listed, this
	// field can be used in idFieldNames when that write operation is present as a
	// destination option.
	SupportedWriteOperations []WriteOperationType

	noSmithyDocumentSerde
}

//	Contains information about the configuration of destination connectors present
//
// in the flow.
type DestinationFlowConfig struct {

	//  The type of connector, such as Salesforce, Amplitude, and so on.
	//
	// This member is required.
	ConnectorType ConnectorType

	//  This stores the information that is required to query a particular connector.
	//
	// This member is required.
	DestinationConnectorProperties *DestinationConnectorProperties

	// The API version that the destination connector uses.
	ApiVersion *string

	//  The name of the connector profile. This name must be unique for each connector
	// profile in the Amazon Web Services account.
	ConnectorProfileName *string

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required by Dynatrace.
type DynatraceConnectorProfileCredentials struct {

	//  The API tokens used by Dynatrace API to authenticate various API calls.
	//
	// This member is required.
	ApiToken *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required by Dynatrace.
type DynatraceConnectorProfileProperties struct {

	//  The location of the Dynatrace resource.
	//
	// This member is required.
	InstanceUrl *string

	noSmithyDocumentSerde
}

// The connector metadata specific to Dynatrace.
type DynatraceMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when Dynatrace is being used as a source.
type DynatraceSourceProperties struct {

	//  The object specified in the Dynatrace flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

//	The settings that determine how Amazon AppFlow handles an error when placing
//
// data in the destination. For example, this setting would determine if the flow
// should fail after one insertion error, or continue and attempt to insert every
// record regardless of the initial failure. ErrorHandlingConfig is a part of the
// destination connector details.
type ErrorHandlingConfig struct {

	//  Specifies the name of the Amazon S3 bucket.
	BucketName *string

	//  Specifies the Amazon S3 bucket prefix.
	BucketPrefix *string

	//  Specifies if the flow should fail after the first instance of a failure when
	// attempting to place data in the destination.
	FailOnFirstDestinationError bool

	noSmithyDocumentSerde
}

//	Provides details in the event of a failed flow, including the failure count
//
// and the related error messages.
type ErrorInfo struct {

	//  Specifies the error message that appears if a flow fails.
	ExecutionMessage *string

	//  Specifies the failure count for the attempted flow.
	PutFailuresCount *int64

	noSmithyDocumentSerde
}

//	The properties that are applied when Amazon EventBridge is being used as a
//
// destination.
type EventBridgeDestinationProperties struct {

	//  The object specified in the Amazon EventBridge flow destination.
	//
	// This member is required.
	Object *string

	//  The settings that determine how Amazon AppFlow handles an error when placing
	// data in the destination. For example, this setting would determine if the flow
	// should fail after one insertion error, or continue and attempt to insert every
	// record regardless of the initial failure. ErrorHandlingConfig is a part of the
	// destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig

	noSmithyDocumentSerde
}

// The connector metadata specific to Amazon EventBridge.
type EventBridgeMetadata struct {
	noSmithyDocumentSerde
}

//	Describes the details of the flow run, including the timestamp, status, and
//
// message.
type ExecutionDetails struct {

	//  Describes the details of the most recent flow run.
	MostRecentExecutionMessage *string

	//  Specifies the status of the most recent flow run.
	MostRecentExecutionStatus ExecutionStatus

	//  Specifies the time of the most recent flow run.
	MostRecentExecutionTime *time.Time

	noSmithyDocumentSerde
}

// Specifies information about the past flow run instances for a given flow.
type ExecutionRecord struct {

	//  The timestamp that indicates the last new or updated record to be transferred
	// in the flow run.
	DataPullEndTime *time.Time

	//  The timestamp that determines the first new or updated record to be
	// transferred in the flow run.
	DataPullStartTime *time.Time

	//  Specifies the identifier of the given flow run.
	ExecutionId *string

	//  Describes the result of the given flow run.
	ExecutionResult *ExecutionResult

	//  Specifies the flow run status and whether it is in progress, has completed
	// successfully, or has failed.
	ExecutionStatus ExecutionStatus

	//  Specifies the time of the most recent update.
	LastUpdatedAt *time.Time

	// Describes the metadata catalog, metadata table, and data partitions that Amazon
	// AppFlow used for the associated flow run.
	MetadataCatalogDetails []MetadataCatalogDetail

	//  Specifies the start time of the flow run.
	StartedAt *time.Time

	noSmithyDocumentSerde
}

// Specifies the end result of the flow run.
type ExecutionResult struct {

	//  The total number of bytes processed by the flow run.
	BytesProcessed *int64

	//  The total number of bytes written as a result of the flow run.
	BytesWritten *int64

	//  Provides any error message information related to the flow run.
	ErrorInfo *ErrorInfo

	// The maximum number of records that Amazon AppFlow receives in each page of the
	// response from your SAP application.
	MaxPageSize *int64

	// The number of processes that Amazon AppFlow ran at the same time when it
	// retrieved your data.
	NumParallelProcesses *int64

	//  The number of records processed in the flow run.
	RecordsProcessed *int64

	noSmithyDocumentSerde
}

//	Contains details regarding the supported field type and the operators that can
//
// be applied for filtering.
type FieldTypeDetails struct {

	//  The type of field, such as string, integer, date, and so on.
	//
	// This member is required.
	FieldType *string

	//  The list of operators supported by a field.
	//
	// This member is required.
	FilterOperators []Operator

	// This is the allowable length range for this field's value.
	FieldLengthRange *Range

	// The range of values this field can hold.
	FieldValueRange *Range

	// The date format that the field supports.
	SupportedDateFormat *string

	//  The list of values that a field can contain. For example, a Boolean fieldType
	// can have two values: "true" and "false".
	SupportedValues []string

	// The regular expression pattern for the field name.
	ValueRegexPattern *string

	noSmithyDocumentSerde
}

//	The properties of the flow, such as its source, destination, trigger type, and
//
// so on.
type FlowDefinition struct {

	//  Specifies when the flow was created.
	CreatedAt *time.Time

	//  The ARN of the user who created the flow.
	CreatedBy *string

	//  A user-entered description of the flow.
	Description *string

	// The label of the destination connector in the flow.
	DestinationConnectorLabel *string

	//  Specifies the destination connector type, such as Salesforce, Amazon S3,
	// Amplitude, and so on.
	DestinationConnectorType ConnectorType

	//  The flow's Amazon Resource Name (ARN).
	FlowArn *string

	//  The specified name of the flow. Spaces are not allowed. Use underscores (_) or
	// hyphens (-) only.
	FlowName *string

	//  Indicates the current status of the flow.
	FlowStatus FlowStatus

	//  Describes the details of the most recent flow run.
	LastRunExecutionDetails *ExecutionDetails

	//  Specifies when the flow was last updated.
	LastUpdatedAt *time.Time

	//  Specifies the account user name that most recently updated the flow.
	LastUpdatedBy *string

	// The label of the source connector in the flow.
	SourceConnectorLabel *string

	//  Specifies the source connector type, such as Salesforce, Amazon S3, Amplitude,
	// and so on.
	SourceConnectorType ConnectorType

	//  The tags used to organize, track, or control access for your flow.
	Tags map[string]string

	//  Specifies the type of flow trigger. This can be OnDemand , Scheduled , or Event
	// .
	TriggerType TriggerType

	noSmithyDocumentSerde
}

// Specifies the configuration that Amazon AppFlow uses when it catalogs your data
// with the Glue Data Catalog. When Amazon AppFlow catalogs your data, it stores
// metadata in Data Catalog tables. This metadata represents the data that's
// transferred by the flow that you configure with these settings.
//
// You can configure a flow with these settings only when the flow destination is
// Amazon S3.
type GlueDataCatalogConfig struct {

	// The name of the Data Catalog database that stores the metadata tables that
	// Amazon AppFlow creates in your Amazon Web Services account. These tables contain
	// metadata for the data that's transferred by the flow that you configure with
	// this parameter.
	//
	// When you configure a new flow with this parameter, you must specify an existing
	// database.
	//
	// This member is required.
	DatabaseName *string

	// The Amazon Resource Name (ARN) of an IAM role that grants Amazon AppFlow the
	// permissions it needs to create Data Catalog tables, databases, and partitions.
	//
	// For an example IAM policy that has the required permissions, see [Identity-based policy examples for Amazon AppFlow].
	//
	// [Identity-based policy examples for Amazon AppFlow]: https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_id-based-policy-examples.html
	//
	// This member is required.
	RoleArn *string

	// A naming prefix for each Data Catalog table that Amazon AppFlow creates for the
	// flow that you configure with this setting. Amazon AppFlow adds the prefix to the
	// beginning of the each table name.
	//
	// This member is required.
	TablePrefix *string

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required by Google Analytics.
type GoogleAnalyticsConnectorProfileCredentials struct {

	//  The identifier for the desired client.
	//
	// This member is required.
	ClientId *string

	//  The client secret used by the OAuth client to authenticate to the
	// authorization server.
	//
	// This member is required.
	ClientSecret *string

	//  The credentials used to access protected Google Analytics resources.
	AccessToken *string

	//  The OAuth requirement needed to request security tokens from the connector
	// endpoint.
	OAuthRequest *ConnectorOAuthRequest

	//  The credentials used to acquire new access tokens. This is required only for
	// OAuth2 access tokens, and is not required for OAuth1 access tokens.
	RefreshToken *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required by Google Analytics.
type GoogleAnalyticsConnectorProfileProperties struct {
	noSmithyDocumentSerde
}

// The connector metadata specific to Google Analytics.
type GoogleAnalyticsMetadata struct {

	//  The desired authorization scope for the Google Analytics account.
	OAuthScopes []string

	noSmithyDocumentSerde
}

//	The properties that are applied when Google Analytics is being used as a
//
// source.
type GoogleAnalyticsSourceProperties struct {

	//  The object specified in the Google Analytics flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// The connector-specific credentials required when using Amazon Honeycode.
type HoneycodeConnectorProfileCredentials struct {

	//  The credentials used to access protected Amazon Honeycode resources.
	AccessToken *string

	//  Used by select connectors for which the OAuth workflow is supported, such as
	// Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
	OAuthRequest *ConnectorOAuthRequest

	//  The credentials used to acquire new access tokens.
	RefreshToken *string

	noSmithyDocumentSerde
}

// The connector-specific properties required when using Amazon Honeycode.
type HoneycodeConnectorProfileProperties struct {
	noSmithyDocumentSerde
}

//	The properties that are applied when Amazon Honeycode is used as a
//
// destination.
type HoneycodeDestinationProperties struct {

	//  The object specified in the Amazon Honeycode flow destination.
	//
	// This member is required.
	Object *string

	//  The settings that determine how Amazon AppFlow handles an error when placing
	// data in the destination. For example, this setting would determine if the flow
	// should fail after one insertion error, or continue and attempt to insert every
	// record regardless of the initial failure. ErrorHandlingConfig is a part of the
	// destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig

	noSmithyDocumentSerde
}

// The connector metadata specific to Amazon Honeycode.
type HoneycodeMetadata struct {

	//  The desired authorization scope for the Amazon Honeycode account.
	OAuthScopes []string

	noSmithyDocumentSerde
}

//	Specifies the configuration used when importing incremental records from the
//
// source.
type IncrementalPullConfig struct {

	//  A field that specifies the date time or timestamp field as the criteria to use
	// when importing incremental records from the source.
	DatetimeTypeFieldName *string

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required by Infor Nexus.
type InforNexusConnectorProfileCredentials struct {

	//  The Access Key portion of the credentials.
	//
	// This member is required.
	AccessKeyId *string

	//  The encryption keys used to encrypt data.
	//
	// This member is required.
	Datakey *string

	//  The secret key used to sign requests.
	//
	// This member is required.
	SecretAccessKey *string

	//  The identifier for the user.
	//
	// This member is required.
	UserId *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required by Infor Nexus.
type InforNexusConnectorProfileProperties struct {

	//  The location of the Infor Nexus resource.
	//
	// This member is required.
	InstanceUrl *string

	noSmithyDocumentSerde
}

// The connector metadata specific to Infor Nexus.
type InforNexusMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when Infor Nexus is being used as a source.
type InforNexusSourceProperties struct {

	//  The object specified in the Infor Nexus flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// Contains information about the configuration of the lambda which is being
// registered as the connector.
type LambdaConnectorProvisioningConfig struct {

	// Lambda ARN of the connector being registered.
	//
	// This member is required.
	LambdaArn *string

	noSmithyDocumentSerde
}

//	The properties that are applied when Amazon Lookout for Metrics is used as a
//
// destination.
type LookoutMetricsDestinationProperties struct {
	noSmithyDocumentSerde
}

// The connector-specific profile credentials required by Marketo.
type MarketoConnectorProfileCredentials struct {

	//  The identifier for the desired client.
	//
	// This member is required.
	ClientId *string

	//  The client secret used by the OAuth client to authenticate to the
	// authorization server.
	//
	// This member is required.
	ClientSecret *string

	//  The credentials used to access protected Marketo resources.
	AccessToken *string

	//  The OAuth requirement needed to request security tokens from the connector
	// endpoint.
	OAuthRequest *ConnectorOAuthRequest

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Marketo.
type MarketoConnectorProfileProperties struct {

	//  The location of the Marketo resource.
	//
	// This member is required.
	InstanceUrl *string

	noSmithyDocumentSerde
}

// The properties that Amazon AppFlow applies when you use Marketo as a flow
// destination.
type MarketoDestinationProperties struct {

	// The object specified in the Marketo flow destination.
	//
	// This member is required.
	Object *string

	//  The settings that determine how Amazon AppFlow handles an error when placing
	// data in the destination. For example, this setting would determine if the flow
	// should fail after one insertion error, or continue and attempt to insert every
	// record regardless of the initial failure. ErrorHandlingConfig is a part of the
	// destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig

	noSmithyDocumentSerde
}

// The connector metadata specific to Marketo.
type MarketoMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when Marketo is being used as a source.
type MarketoSourceProperties struct {

	//  The object specified in the Marketo flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// Specifies the configuration that Amazon AppFlow uses when it catalogs your
// data. When Amazon AppFlow catalogs your data, it stores metadata in a data
// catalog.
type MetadataCatalogConfig struct {

	// Specifies the configuration that Amazon AppFlow uses when it catalogs your data
	// with the Glue Data Catalog.
	GlueDataCatalog *GlueDataCatalogConfig

	noSmithyDocumentSerde
}

// Describes the metadata catalog, metadata table, and data partitions that Amazon
// AppFlow used for the associated flow run.
type MetadataCatalogDetail struct {

	// The type of metadata catalog that Amazon AppFlow used for the associated flow
	// run. This parameter returns the following value:
	//
	// GLUE The metadata catalog is provided by the Glue Data Catalog. Glue includes
	// the Glue Data Catalog as a component.
	CatalogType CatalogType

	// Describes the status of the attempt from Amazon AppFlow to register the data
	// partitions with the metadata catalog. The data partitions organize the flow
	// output into a hierarchical path, such as a folder path in an S3 bucket. Amazon
	// AppFlow creates the partitions (if they don't already exist) based on your flow
	// configuration.
	PartitionRegistrationOutput *RegistrationOutput

	// The name of the table that stores the metadata for the associated flow run. The
	// table stores metadata that represents the data that the flow transferred. Amazon
	// AppFlow stores the table in the metadata catalog.
	TableName *string

	// Describes the status of the attempt from Amazon AppFlow to register the
	// metadata table with the metadata catalog. Amazon AppFlow creates or updates this
	// table for the associated flow run.
	TableRegistrationOutput *RegistrationOutput

	noSmithyDocumentSerde
}

// The OAuth 2.0 credentials required for OAuth 2.0 authentication.
type OAuth2Credentials struct {

	// The access token used to access the connector on your behalf.
	AccessToken *string

	// The identifier for the desired client.
	ClientId *string

	// The client secret used by the OAuth client to authenticate to the authorization
	// server.
	ClientSecret *string

	//  Used by select connectors for which the OAuth workflow is supported, such as
	// Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
	OAuthRequest *ConnectorOAuthRequest

	// The refresh token used to refresh an expired access token.
	RefreshToken *string

	noSmithyDocumentSerde
}

// Custom parameter required for OAuth 2.0 authentication.
type OAuth2CustomParameter struct {

	// Contains default values for this authentication parameter that are supplied by
	// the connector.
	ConnectorSuppliedValues []string

	// A description about the custom parameter used for OAuth 2.0 authentication.
	Description *string

	// Indicates whether the custom parameter for OAuth 2.0 authentication is required.
	IsRequired bool

	// Indicates whether this authentication custom parameter is a sensitive field.
	IsSensitiveField bool

	// The key of the custom parameter required for OAuth 2.0 authentication.
	Key *string

	// The label of the custom parameter used for OAuth 2.0 authentication.
	Label *string

	// Indicates whether custom parameter is used with TokenUrl or AuthUrl.
	Type OAuth2CustomPropType

	noSmithyDocumentSerde
}

// Contains the default values required for OAuth 2.0 authentication.
type OAuth2Defaults struct {

	// Auth code URLs that can be used for OAuth 2.0 authentication.
	AuthCodeUrls []string

	// List of custom parameters required for OAuth 2.0 authentication.
	Oauth2CustomProperties []OAuth2CustomParameter

	// OAuth 2.0 grant types supported by the connector.
	Oauth2GrantTypesSupported []OAuth2GrantType

	// OAuth 2.0 scopes that the connector supports.
	OauthScopes []string

	// Token URLs that can be used for OAuth 2.0 authentication.
	TokenUrls []string

	noSmithyDocumentSerde
}

// The OAuth 2.0 properties required for OAuth 2.0 authentication.
type OAuth2Properties struct {

	// The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication.
	//
	// This member is required.
	OAuth2GrantType OAuth2GrantType

	// The token URL required for OAuth 2.0 authentication.
	//
	// This member is required.
	TokenUrl *string

	// Associates your token URL with a map of properties that you define. Use this
	// parameter to provide any additional details that the connector requires to
	// authenticate your request.
	TokenUrlCustomProperties map[string]string

	noSmithyDocumentSerde
}

// The OAuth credentials required for OAuth type authentication.
type OAuthCredentials struct {

	//  The identifier for the desired client.
	//
	// This member is required.
	ClientId *string

	//  The client secret used by the OAuth client to authenticate to the
	// authorization server.
	//
	// This member is required.
	ClientSecret *string

	//  The access token used to access protected SAPOData resources.
	AccessToken *string

	//  The OAuth requirement needed to request security tokens from the connector
	// endpoint.
	OAuthRequest *ConnectorOAuthRequest

	//  The refresh token used to refresh expired access token.
	RefreshToken *string

	noSmithyDocumentSerde
}

// The OAuth properties required for OAuth type authentication.
type OAuthProperties struct {

	//  The authorization code url required to redirect to SAP Login Page to fetch
	// authorization code for OAuth type authentication.
	//
	// This member is required.
	AuthCodeUrl *string

	//  The OAuth scopes required for OAuth type authentication.
	//
	// This member is required.
	OAuthScopes []string

	//  The token url required to fetch access/refresh tokens using authorization code
	// and also to refresh expired access token using refresh token.
	//
	// This member is required.
	TokenUrl *string

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using Salesforce
// Pardot.
type PardotConnectorProfileCredentials struct {

	// The credentials used to access protected Salesforce Pardot resources.
	AccessToken *string

	// The secret manager ARN, which contains the client ID and client secret of the
	// connected app.
	ClientCredentialsArn *string

	//  Used by select connectors for which the OAuth workflow is supported, such as
	// Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
	OAuthRequest *ConnectorOAuthRequest

	// The credentials used to acquire new access tokens.
	RefreshToken *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Salesforce Pardot.
type PardotConnectorProfileProperties struct {

	// The business unit id of Salesforce Pardot instance.
	BusinessUnitId *string

	// The location of the Salesforce Pardot resource.
	InstanceUrl *string

	// Indicates whether the connector profile applies to a sandbox or production
	// environment.
	IsSandboxEnvironment bool

	noSmithyDocumentSerde
}

// The connector metadata specific to Salesforce Pardot.
type PardotMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when Salesforce Pardot is being used as a
// source.
type PardotSourceProperties struct {

	// The object specified in the Salesforce Pardot flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// Specifies elements that Amazon AppFlow includes in the file and folder names in
// the flow destination.
type PrefixConfig struct {

	// Specifies whether the destination file path includes either or both of the
	// following elements:
	//
	// EXECUTION_ID The ID that Amazon AppFlow assigns to the flow run.
	//
	// SCHEMA_VERSION The version number of your data schema. Amazon AppFlow assigns
	// this version number. The version number increases by one when you change any of
	// the following settings in your flow configuration:
	//
	//   - Source-to-destination field mappings
	//
	//   - Field data types
	//
	//   - Partition keys
	PathPrefixHierarchy []PathPrefix

	// Determines the level of granularity for the date and time that's included in
	// the prefix.
	PrefixFormat PrefixFormat

	// Determines the format of the prefix, and whether it applies to the file name,
	// file path, or both.
	PrefixType PrefixType

	noSmithyDocumentSerde
}

// Specifies the private connection provisioning state.
type PrivateConnectionProvisioningState struct {

	//  Specifies the private connection provisioning failure cause.
	FailureCause PrivateConnectionProvisioningFailureCause

	//  Specifies the private connection provisioning failure reason.
	FailureMessage *string

	//  Specifies the private connection provisioning status.
	Status PrivateConnectionProvisioningStatus

	noSmithyDocumentSerde
}

// The range of values that the property supports.
type Range struct {

	// Maximum value supported by the field.
	Maximum float64

	// Minimum value supported by the field.
	Minimum float64

	noSmithyDocumentSerde
}

//	The connector-specific profile credentials required when using Amazon
//
// Redshift.
type RedshiftConnectorProfileCredentials struct {

	//  The password that corresponds to the user name.
	Password *string

	//  The name of the user.
	Username *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties when using Amazon Redshift.
type RedshiftConnectorProfileProperties struct {

	//  A name for the associated Amazon S3 bucket.
	//
	// This member is required.
	BucketName *string

	//  The Amazon Resource Name (ARN) of IAM role that grants Amazon Redshift
	// read-only access to Amazon S3. For more information, and for the polices that
	// you attach to this role, see [Allow Amazon Redshift to access your Amazon AppFlow data in Amazon S3].
	//
	// [Allow Amazon Redshift to access your Amazon AppFlow data in Amazon S3]: https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#redshift-access-s3
	//
	// This member is required.
	RoleArn *string

	//  The object key for the destination bucket in which Amazon AppFlow places the
	// files.
	BucketPrefix *string

	// The unique ID that's assigned to an Amazon Redshift cluster.
	ClusterIdentifier *string

	// The Amazon Resource Name (ARN) of an IAM role that permits Amazon AppFlow to
	// access your Amazon Redshift database through the Data API. For more information,
	// and for the polices that you attach to this role, see [Allow Amazon AppFlow to access Amazon Redshift databases with the Data API].
	//
	// [Allow Amazon AppFlow to access Amazon Redshift databases with the Data API]: https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#access-redshift
	DataApiRoleArn *string

	// The name of an Amazon Redshift database.
	DatabaseName *string

	//  The JDBC URL of the Amazon Redshift cluster.
	DatabaseUrl *string

	// Indicates whether the connector profile defines a connection to an Amazon
	// Redshift Serverless data warehouse.
	IsRedshiftServerless bool

	// The name of an Amazon Redshift workgroup.
	WorkgroupName *string

	noSmithyDocumentSerde
}

//	The properties that are applied when Amazon Redshift is being used as a
//
// destination.
type RedshiftDestinationProperties struct {

	//  The intermediate bucket that Amazon AppFlow uses when moving data into Amazon
	// Redshift.
	//
	// This member is required.
	IntermediateBucketName *string

	//  The object specified in the Amazon Redshift flow destination.
	//
	// This member is required.
	Object *string

	//  The object key for the bucket in which Amazon AppFlow places the destination
	// files.
	BucketPrefix *string

	//  The settings that determine how Amazon AppFlow handles an error when placing
	// data in the Amazon Redshift destination. For example, this setting would
	// determine if the flow should fail after one insertion error, or continue and
	// attempt to insert every record regardless of the initial failure.
	// ErrorHandlingConfig is a part of the destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig

	noSmithyDocumentSerde
}

// The connector metadata specific to Amazon Redshift.
type RedshiftMetadata struct {
	noSmithyDocumentSerde
}

// Describes the status of an attempt from Amazon AppFlow to register a resource.
//
// When you run a flow that you've configured to use a metadata catalog, Amazon
// AppFlow registers a metadata table and data partitions with that catalog. This
// operation provides the status of that registration attempt. The operation also
// indicates how many related resources Amazon AppFlow created or updated.
type RegistrationOutput struct {

	// Explains the status of the registration attempt from Amazon AppFlow. If the
	// attempt fails, the message explains why.
	Message *string

	// Indicates the number of resources that Amazon AppFlow created or updated.
	// Possible resources include metadata tables and data partitions.
	Result *string

	// Indicates the status of the registration attempt from Amazon AppFlow.
	Status ExecutionStatus

	noSmithyDocumentSerde
}

// The properties that are applied when Amazon S3 is used as a destination.
type S3DestinationProperties struct {

	//  The Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
	//
	// This member is required.
	BucketName *string

	//  The object key for the destination bucket in which Amazon AppFlow places the
	// files.
	BucketPrefix *string

	//  The configuration that determines how Amazon AppFlow should format the flow
	// output data when Amazon S3 is used as the destination.
	S3OutputFormatConfig *S3OutputFormatConfig

	noSmithyDocumentSerde
}

//	When you use Amazon S3 as the source, the configuration format that you
//
// provide the flow input data.
type S3InputFormatConfig struct {

	//  The file type that Amazon AppFlow gets from your Amazon S3 bucket.
	S3InputFileType S3InputFileType

	noSmithyDocumentSerde
}

// The connector metadata specific to Amazon S3.
type S3Metadata struct {
	noSmithyDocumentSerde
}

//	The configuration that determines how Amazon AppFlow should format the flow
//
// output data when Amazon S3 is used as the destination.
type S3OutputFormatConfig struct {

	//  The aggregation settings that you can use to customize the output format of
	// your flow data.
	AggregationConfig *AggregationConfig

	//  Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
	FileType FileType

	//  Determines the prefix that Amazon AppFlow applies to the folder name in the
	// Amazon S3 bucket. You can name folders according to the flow frequency and date.
	PrefixConfig *PrefixConfig

	// If your file output format is Parquet, use this parameter to set whether Amazon
	// AppFlow preserves the data types in your source data when it writes the output
	// to Amazon S3.
	//
	//   - true : Amazon AppFlow preserves the data types when it writes to Amazon S3.
	//   For example, an integer or 1 in your source data is still an integer in your
	//   output.
	//
	//   - false : Amazon AppFlow converts all of the source data into strings when it
	//   writes to Amazon S3. For example, an integer of 1 in your source data becomes
	//   the string "1" in the output.
	PreserveSourceDataTyping *bool

	noSmithyDocumentSerde
}

//	The properties that are applied when Amazon S3 is being used as the flow
//
// source.
type S3SourceProperties struct {

	//  The Amazon S3 bucket name where the source files are stored.
	//
	// This member is required.
	BucketName *string

	//  The object key for the Amazon S3 bucket in which the source files are stored.
	BucketPrefix *string

	//  When you use Amazon S3 as the source, the configuration format that you
	// provide the flow input data.
	S3InputFormatConfig *S3InputFormatConfig

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using Salesforce.
type SalesforceConnectorProfileCredentials struct {

	//  The credentials used to access protected Salesforce resources.
	AccessToken *string

	//  The secret manager ARN, which contains the client ID and client secret of the
	// connected app.
	ClientCredentialsArn *string

	// A JSON web token (JWT) that authorizes Amazon AppFlow to access your Salesforce
	// records.
	JwtToken *string

	// Specifies the OAuth 2.0 grant type that Amazon AppFlow uses when it requests an
	// access token from Salesforce. Amazon AppFlow requires an access token each time
	// it attempts to access your Salesforce records.
	//
	// You can specify one of the following values:
	//
	// AUTHORIZATION_CODE Amazon AppFlow passes an authorization code when it requests
	// the access token from Salesforce. Amazon AppFlow receives the authorization code
	// from Salesforce after you log in to your Salesforce account and authorize Amazon
	// AppFlow to access your records.
	//
	// CLIENT_CREDENTIALS Amazon AppFlow passes client credentials (a client ID and
	// client secret) when it requests the access token from Salesforce. You provide
	// these credentials to Amazon AppFlow when you define the connection to your
	// Salesforce account.
	//
	// JWT_BEARER Amazon AppFlow passes a JSON web token (JWT) when it requests the
	// access token from Salesforce. You provide the JWT to Amazon AppFlow when you
	// define the connection to your Salesforce account. When you use this grant type,
	// you don't need to log in to your Salesforce account to authorize Amazon AppFlow
	// to access your records.
	OAuth2GrantType OAuth2GrantType

	//  The OAuth requirement needed to request security tokens from the connector
	// endpoint.
	OAuthRequest *ConnectorOAuthRequest

	//  The credentials used to acquire new access tokens.
	RefreshToken *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Salesforce.
type SalesforceConnectorProfileProperties struct {

	//  The location of the Salesforce resource.
	InstanceUrl *string

	//  Indicates whether the connector profile applies to a sandbox or production
	// environment.
	IsSandboxEnvironment bool

	// If the connection mode for the connector profile is private, this parameter
	// sets whether Amazon AppFlow uses the private network to send metadata and
	// authorization calls to Salesforce. Amazon AppFlow sends private calls through
	// Amazon Web Services PrivateLink. These calls travel through Amazon Web Services
	// infrastructure without being exposed to the public internet.
	//
	// Set either of the following values:
	//
	// true Amazon AppFlow sends all calls to Salesforce over the private network.
	//
	// These private calls are:
	//
	//   - Calls to get metadata about your Salesforce records. This metadata
	//   describes your Salesforce objects and their fields.
	//
	//   - Calls to get or refresh access tokens that allow Amazon AppFlow to access
	//   your Salesforce records.
	//
	//   - Calls to transfer your Salesforce records as part of a flow run.
	//
	// false The default value. Amazon AppFlow sends some calls to Salesforce
	// privately and other calls over the public internet.
	//
	// The public calls are:
	//
	//   - Calls to get metadata about your Salesforce records.
	//
	//   - Calls to get or refresh access tokens.
	//
	// The private calls are:
	//
	//   - Calls to transfer your Salesforce records as part of a flow run.
	UsePrivateLinkForMetadataAndAuthorization bool

	noSmithyDocumentSerde
}

//	The properties that are applied when Salesforce is being used as a
//
// destination.
type SalesforceDestinationProperties struct {

	//  The object specified in the Salesforce flow destination.
	//
	// This member is required.
	Object *string

	// Specifies which Salesforce API is used by Amazon AppFlow when your flow
	// transfers data to Salesforce.
	//
	// AUTOMATIC The default. Amazon AppFlow selects which API to use based on the
	// number of records that your flow transfers to Salesforce. If your flow transfers
	// fewer than 1,000 records, Amazon AppFlow uses Salesforce REST API. If your flow
	// transfers 1,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.
	//
	// Each of these Salesforce APIs structures data differently. If Amazon AppFlow
	// selects the API automatically, be aware that, for recurring flows, the data
	// output might vary from one flow run to the next. For example, if a flow runs
	// daily, it might use REST API on one day to transfer 900 records, and it might
	// use Bulk API 2.0 on the next day to transfer 1,100 records. For each of these
	// flow runs, the respective Salesforce API formats the data differently. Some of
	// the differences include how dates are formatted and null values are represented.
	// Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.
	//
	// By choosing this option, you optimize flow performance for both small and large
	// data transfers, but the tradeoff is inconsistent formatting in the output.
	//
	// BULKV2 Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs
	// asynchronous data transfers, and it's optimal for large sets of data. By
	// choosing this option, you ensure that your flow writes consistent output, but
	// you optimize performance only for large data transfers.
	//
	// Note that Bulk API 2.0 does not transfer Salesforce compound fields.
	//
	// REST_SYNC Amazon AppFlow uses only Salesforce REST API. By choosing this
	// option, you ensure that your flow writes consistent output, but you decrease
	// performance for large data transfers that are better suited for Bulk API 2.0. In
	// some cases, if your flow attempts to transfer a vary large set of data, it might
	// fail with a timed out error.
	DataTransferApi SalesforceDataTransferApi

	//  The settings that determine how Amazon AppFlow handles an error when placing
	// data in the Salesforce destination. For example, this setting would determine if
	// the flow should fail after one insertion error, or continue and attempt to
	// insert every record regardless of the initial failure. ErrorHandlingConfig is a
	// part of the destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig

	//  The name of the field that Amazon AppFlow uses as an ID when performing a
	// write operation such as update or delete.
	IdFieldNames []string

	//  This specifies the type of write operation to be performed in Salesforce. When
	// the value is UPSERT , then idFieldNames is required.
	WriteOperationType WriteOperationType

	noSmithyDocumentSerde
}

// The connector metadata specific to Salesforce.
type SalesforceMetadata struct {

	// The Salesforce APIs that you can have Amazon AppFlow use when your flows
	// transfers data to or from Salesforce.
	DataTransferApis []SalesforceDataTransferApi

	//  The desired authorization scope for the Salesforce account.
	OAuthScopes []string

	// The OAuth 2.0 grant types that Amazon AppFlow can use when it requests an
	// access token from Salesforce. Amazon AppFlow requires an access token each time
	// it attempts to access your Salesforce records.
	//
	// AUTHORIZATION_CODE Amazon AppFlow passes an authorization code when it requests
	// the access token from Salesforce. Amazon AppFlow receives the authorization code
	// from Salesforce after you log in to your Salesforce account and authorize Amazon
	// AppFlow to access your records.
	//
	// CLIENT_CREDENTIALS Amazon AppFlow passes client credentials (a client ID and
	// client secret) when it requests the access token from Salesforce. You provide
	// these credentials to Amazon AppFlow when you define the connection to your
	// Salesforce account.
	//
	// JWT_BEARER Amazon AppFlow passes a JSON web token (JWT) when it requests the
	// access token from Salesforce. You provide the JWT to Amazon AppFlow when you
	// define the connection to your Salesforce account. When you use this grant type,
	// you don't need to log in to your Salesforce account to authorize Amazon AppFlow
	// to access your records.
	Oauth2GrantTypesSupported []OAuth2GrantType

	noSmithyDocumentSerde
}

// The properties that are applied when Salesforce is being used as a source.
type SalesforceSourceProperties struct {

	//  The object specified in the Salesforce flow source.
	//
	// This member is required.
	Object *string

	// Specifies which Salesforce API is used by Amazon AppFlow when your flow
	// transfers data from Salesforce.
	//
	// AUTOMATIC The default. Amazon AppFlow selects which API to use based on the
	// number of records that your flow transfers from Salesforce. If your flow
	// transfers fewer than 1,000,000 records, Amazon AppFlow uses Salesforce REST API.
	// If your flow transfers 1,000,000 records or more, Amazon AppFlow uses Salesforce
	// Bulk API 2.0.
	//
	// Each of these Salesforce APIs structures data differently. If Amazon AppFlow
	// selects the API automatically, be aware that, for recurring flows, the data
	// output might vary from one flow run to the next. For example, if a flow runs
	// daily, it might use REST API on one day to transfer 900,000 records, and it
	// might use Bulk API 2.0 on the next day to transfer 1,100,000 records. For each
	// of these flow runs, the respective Salesforce API formats the data differently.
	// Some of the differences include how dates are formatted and null values are
	// represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.
	//
	// By choosing this option, you optimize flow performance for both small and large
	// data transfers, but the tradeoff is inconsistent formatting in the output.
	//
	// BULKV2 Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs
	// asynchronous data transfers, and it's optimal for large sets of data. By
	// choosing this option, you ensure that your flow writes consistent output, but
	// you optimize performance only for large data transfers.
	//
	// Note that Bulk API 2.0 does not transfer Salesforce compound fields.
	//
	// REST_SYNC Amazon AppFlow uses only Salesforce REST API. By choosing this
	// option, you ensure that your flow writes consistent output, but you decrease
	// performance for large data transfers that are better suited for Bulk API 2.0. In
	// some cases, if your flow attempts to transfer a vary large set of data, it might
	// fail wituh a timed out error.
	DataTransferApi SalesforceDataTransferApi

	//  The flag that enables dynamic fetching of new (recently added) fields in the
	// Salesforce objects while running a flow.
	EnableDynamicFieldUpdate bool

	//  Indicates whether Amazon AppFlow includes deleted files in the flow run.
	IncludeDeletedRecords bool

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using SAPOData.
type SAPODataConnectorProfileCredentials struct {

	//  The SAPOData basic authentication credentials.
	BasicAuthCredentials *BasicAuthCredentials

	//  The SAPOData OAuth type authentication credentials.
	OAuthCredentials *OAuthCredentials

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using SAPOData.
type SAPODataConnectorProfileProperties struct {

	//  The location of the SAPOData resource.
	//
	// This member is required.
	ApplicationHostUrl *string

	//  The application path to catalog service.
	//
	// This member is required.
	ApplicationServicePath *string

	//  The client number for the client creating the connection.
	//
	// This member is required.
	ClientNumber *string

	//  The port number of the SAPOData instance.
	//
	// This member is required.
	PortNumber *int32

	// If you set this parameter to true , Amazon AppFlow bypasses the single sign-on
	// (SSO) settings in your SAP account when it accesses your SAP OData instance.
	//
	// Whether you need this option depends on the types of credentials that you
	// applied to your SAP OData connection profile. If your profile uses basic
	// authentication credentials, SAP SSO can prevent Amazon AppFlow from connecting
	// to your account with your username and password. In this case, bypassing SSO
	// makes it possible for Amazon AppFlow to connect successfully. However, if your
	// profile uses OAuth credentials, this parameter has no affect.
	DisableSSO bool

	//  The logon language of SAPOData instance.
	LogonLanguage *string

	//  The SAPOData OAuth properties required for OAuth type authentication.
	OAuthProperties *OAuthProperties

	//  The SAPOData Private Link service name to be used for private data transfers.
	PrivateLinkServiceName *string

	noSmithyDocumentSerde
}

// The properties that are applied when using SAPOData as a flow destination
type SAPODataDestinationProperties struct {

	// The object path specified in the SAPOData flow destination.
	//
	// This member is required.
	ObjectPath *string

	//  The settings that determine how Amazon AppFlow handles an error when placing
	// data in the destination. For example, this setting would determine if the flow
	// should fail after one insertion error, or continue and attempt to insert every
	// record regardless of the initial failure. ErrorHandlingConfig is a part of the
	// destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig

	//  A list of field names that can be used as an ID field when performing a write
	// operation.
	IdFieldNames []string

	// Determines how Amazon AppFlow handles the success response that it gets from
	// the connector after placing data.
	//
	// For example, this setting would determine where to write the response from a
	// destination connector upon a successful insert operation.
	SuccessResponseHandlingConfig *SuccessResponseHandlingConfig

	//  The possible write operations in the destination connector. When this value is
	// not provided, this defaults to the INSERT operation.
	WriteOperationType WriteOperationType

	noSmithyDocumentSerde
}

// The connector metadata specific to SAPOData.
type SAPODataMetadata struct {
	noSmithyDocumentSerde
}

// Sets the page size for each concurrent process that transfers OData records
// from your SAP instance. A concurrent process is query that retrieves a batch of
// records as part of a flow run. Amazon AppFlow can run multiple concurrent
// processes in parallel to transfer data faster.
type SAPODataPaginationConfig struct {

	// The maximum number of records that Amazon AppFlow receives in each page of the
	// response from your SAP application. For transfers of OData records, the maximum
	// page size is 3,000. For transfers of data that comes from an ODP provider, the
	// maximum page size is 10,000.
	//
	// This member is required.
	MaxPageSize *int32

	noSmithyDocumentSerde
}

// Sets the number of concurrent processes that transfer OData records from your
// SAP instance. A concurrent process is query that retrieves a batch of records as
// part of a flow run. Amazon AppFlow can run multiple concurrent processes in
// parallel to transfer data faster.
type SAPODataParallelismConfig struct {

	// The maximum number of processes that Amazon AppFlow runs at the same time when
	// it retrieves your data from your SAP application.
	//
	// This member is required.
	MaxParallelism *int32

	noSmithyDocumentSerde
}

// The properties that are applied when using SAPOData as a flow source.
type SAPODataSourceProperties struct {

	//  The object path specified in the SAPOData flow source.
	ObjectPath *string

	// Sets the page size for each concurrent process that transfers OData records
	// from your SAP instance.
	PaginationConfig *SAPODataPaginationConfig

	// Sets the number of concurrent processes that transfers OData records from your
	// SAP instance.
	ParallelismConfig *SAPODataParallelismConfig

	noSmithyDocumentSerde
}

//	Specifies the configuration details of a schedule-triggered flow as defined by
//
// the user. Currently, these settings only apply to the Scheduled trigger type.
type ScheduledTriggerProperties struct {

	//  The scheduling expression that determines the rate at which the schedule will
	// run, for example rate(5minutes) .
	//
	// This member is required.
	ScheduleExpression *string

	//  Specifies whether a scheduled flow has an incremental data transfer or a
	// complete data transfer for each flow run.
	DataPullMode DataPullMode

	//  Specifies the date range for the records to import from the connector in the
	// first flow run.
	FirstExecutionFrom *time.Time

	// Defines how many times a scheduled flow fails consecutively before Amazon
	// AppFlow deactivates it.
	FlowErrorDeactivationThreshold *int32

	// The time at which the scheduled flow ends. The time is formatted as a timestamp
	// that follows the ISO 8601 standard, such as 2022-04-27T13:00:00-07:00 .
	ScheduleEndTime *time.Time

	//  Specifies the optional offset that is added to the time interval for a
	// schedule-triggered flow.
	ScheduleOffset *int64

	// The time at which the scheduled flow starts. The time is formatted as a
	// timestamp that follows the ISO 8601 standard, such as 2022-04-26T13:00:00-07:00 .
	ScheduleStartTime *time.Time

	// Specifies the time zone used when referring to the dates and times of a
	// scheduled flow, such as America/New_York . This time zone is only a descriptive
	// label. It doesn't affect how Amazon AppFlow interprets the timestamps that you
	// specify to schedule the flow.
	//
	// If you want to schedule a flow by using times in a particular time zone,
	// indicate the time zone as a UTC offset in your timestamps. For example, the UTC
	// offsets for the America/New_York timezone are -04:00 EDT and -05:00 EST .
	Timezone *string

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using ServiceNow.
type ServiceNowConnectorProfileCredentials struct {

	//  The OAuth 2.0 credentials required to authenticate the user.
	OAuth2Credentials *OAuth2Credentials

	//  The password that corresponds to the user name.
	Password *string

	//  The name of the user.
	Username *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using ServiceNow.
type ServiceNowConnectorProfileProperties struct {

	//  The location of the ServiceNow resource.
	//
	// This member is required.
	InstanceUrl *string

	noSmithyDocumentSerde
}

// The connector metadata specific to ServiceNow.
type ServiceNowMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when ServiceNow is being used as a source.
type ServiceNowSourceProperties struct {

	//  The object specified in the ServiceNow flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using Singular.
type SingularConnectorProfileCredentials struct {

	//  A unique alphanumeric identifier used to authenticate a user, developer, or
	// calling program to your API.
	//
	// This member is required.
	ApiKey *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Singular.
type SingularConnectorProfileProperties struct {
	noSmithyDocumentSerde
}

// The connector metadata specific to Singular.
type SingularMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when Singular is being used as a source.
type SingularSourceProperties struct {

	//  The object specified in the Singular flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using Slack.
type SlackConnectorProfileCredentials struct {

	//  The identifier for the client.
	//
	// This member is required.
	ClientId *string

	//  The client secret used by the OAuth client to authenticate to the
	// authorization server.
	//
	// This member is required.
	ClientSecret *string

	//  The credentials used to access protected Slack resources.
	AccessToken *string

	//  The OAuth requirement needed to request security tokens from the connector
	// endpoint.
	OAuthRequest *ConnectorOAuthRequest

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Slack.
type SlackConnectorProfileProperties struct {

	//  The location of the Slack resource.
	//
	// This member is required.
	InstanceUrl *string

	noSmithyDocumentSerde
}

// The connector metadata specific to Slack.
type SlackMetadata struct {

	//  The desired authorization scope for the Slack account.
	OAuthScopes []string

	noSmithyDocumentSerde
}

// The properties that are applied when Slack is being used as a source.
type SlackSourceProperties struct {

	//  The object specified in the Slack flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using Snowflake.
type SnowflakeConnectorProfileCredentials struct {

	//  The password that corresponds to the user name.
	//
	// This member is required.
	Password *string

	//  The name of the user.
	//
	// This member is required.
	Username *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Snowflake.
type SnowflakeConnectorProfileProperties struct {

	//  The name of the Amazon S3 bucket associated with Snowflake.
	//
	// This member is required.
	BucketName *string

	//  The name of the Amazon S3 stage that was created while setting up an Amazon S3
	// stage in the Snowflake account. This is written in the following format: <
	// Database>< Schema>.
	//
	// This member is required.
	Stage *string

	//  The name of the Snowflake warehouse.
	//
	// This member is required.
	Warehouse *string

	//  The name of the account.
	AccountName *string

	//  The bucket path that refers to the Amazon S3 bucket associated with Snowflake.
	BucketPrefix *string

	//  The Snowflake Private Link service name to be used for private data transfers.
	PrivateLinkServiceName *string

	//  The Amazon Web Services Region of the Snowflake account.
	Region *string

	noSmithyDocumentSerde
}

// The properties that are applied when Snowflake is being used as a destination.
type SnowflakeDestinationProperties struct {

	//  The intermediate bucket that Amazon AppFlow uses when moving data into
	// Snowflake.
	//
	// This member is required.
	IntermediateBucketName *string

	//  The object specified in the Snowflake flow destination.
	//
	// This member is required.
	Object *string

	//  The object key for the destination bucket in which Amazon AppFlow places the
	// files.
	BucketPrefix *string

	//  The settings that determine how Amazon AppFlow handles an error when placing
	// data in the Snowflake destination. For example, this setting would determine if
	// the flow should fail after one insertion error, or continue and attempt to
	// insert every record regardless of the initial failure. ErrorHandlingConfig is a
	// part of the destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig

	noSmithyDocumentSerde
}

// The connector metadata specific to Snowflake.
type SnowflakeMetadata struct {

	//  Specifies the supported Amazon Web Services Regions when using Snowflake.
	SupportedRegions []string

	noSmithyDocumentSerde
}

// Specifies the information that is required to query a particular connector.
type SourceConnectorProperties struct {

	//  Specifies the information that is required for querying Amplitude.
	Amplitude *AmplitudeSourceProperties

	// The properties that are applied when the custom connector is being used as a
	// source.
	CustomConnector *CustomConnectorSourceProperties

	//  Specifies the information that is required for querying Datadog.
	Datadog *DatadogSourceProperties

	//  Specifies the information that is required for querying Dynatrace.
	Dynatrace *DynatraceSourceProperties

	//  Specifies the information that is required for querying Google Analytics.
	GoogleAnalytics *GoogleAnalyticsSourceProperties

	//  Specifies the information that is required for querying Infor Nexus.
	InforNexus *InforNexusSourceProperties

	//  Specifies the information that is required for querying Marketo.
	Marketo *MarketoSourceProperties

	// Specifies the information that is required for querying Salesforce Pardot.
	Pardot *PardotSourceProperties

	//  Specifies the information that is required for querying Amazon S3.
	S3 *S3SourceProperties

	//  The properties that are applied when using SAPOData as a flow source.
	SAPOData *SAPODataSourceProperties

	//  Specifies the information that is required for querying Salesforce.
	Salesforce *SalesforceSourceProperties

	//  Specifies the information that is required for querying ServiceNow.
	ServiceNow *ServiceNowSourceProperties

	//  Specifies the information that is required for querying Singular.
	Singular *SingularSourceProperties

	//  Specifies the information that is required for querying Slack.
	Slack *SlackSourceProperties

	//  Specifies the information that is required for querying Trend Micro.
	Trendmicro *TrendmicroSourceProperties

	//  Specifies the information that is required for querying Veeva.
	Veeva *VeevaSourceProperties

	//  Specifies the information that is required for querying Zendesk.
	Zendesk *ZendeskSourceProperties

	noSmithyDocumentSerde
}

//	The properties that can be applied to a field when the connector is being used
//
// as a source.
type SourceFieldProperties struct {

	//  Indicates if the field can be queried.
	IsQueryable bool

	//  Indicates whether the field can be returned in a search result.
	IsRetrievable bool

	// Indicates if this timestamp field can be used for incremental queries.
	IsTimestampFieldForIncrementalQueries bool

	noSmithyDocumentSerde
}

//	Contains information about the configuration of the source connector used in
//
// the flow.
type SourceFlowConfig struct {

	//  The type of connector, such as Salesforce, Amplitude, and so on.
	//
	// This member is required.
	ConnectorType ConnectorType

	//  Specifies the information that is required to query a particular source
	// connector.
	//
	// This member is required.
	SourceConnectorProperties *SourceConnectorProperties

	// The API version of the connector when it's used as a source in the flow.
	ApiVersion *string

	//  The name of the connector profile. This name must be unique for each connector
	// profile in the Amazon Web Services account.
	ConnectorProfileName *string

	//  Defines the configuration for a scheduled incremental data pull. If a valid
	// configuration is provided, the fields specified in the configuration are used
	// when querying for the incremental data pull.
	IncrementalPullConfig *IncrementalPullConfig

	noSmithyDocumentSerde
}

// Determines how Amazon AppFlow handles the success response that it gets from
// the connector after placing data.
//
// For example, this setting would determine where to write the response from the
// destination connector upon a successful insert operation.
type SuccessResponseHandlingConfig struct {

	// The name of the Amazon S3 bucket.
	BucketName *string

	// The Amazon S3 bucket prefix.
	BucketPrefix *string

	noSmithyDocumentSerde
}

//	Contains details regarding all the supported FieldTypes and their
//
// corresponding filterOperators and supportedValues .
type SupportedFieldTypeDetails struct {

	//  The initial supported version for fieldType . If this is later changed to a
	// different version, v2 will be introduced.
	//
	// This member is required.
	V1 *FieldTypeDetails

	noSmithyDocumentSerde
}

//	A class for modeling different type of tasks. Task implementation varies based
//
// on the TaskType .
type Task struct {

	//  The source fields to which a particular task is applied.
	//
	// This member is required.
	SourceFields []string

	//  Specifies the particular task implementation that Amazon AppFlow performs.
	//
	// This member is required.
	TaskType TaskType

	//  The operation to be performed on the provided source fields.
	ConnectorOperator *ConnectorOperator

	//  A field in a destination connector, or a field value against which Amazon
	// AppFlow validates a source field.
	DestinationField *string

	//  A map used to store task-related information. The execution service looks for
	// particular information based on the TaskType .
	TaskProperties map[string]string

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using Trend Micro.
type TrendmicroConnectorProfileCredentials struct {

	//  The Secret Access Key portion of the credentials.
	//
	// This member is required.
	ApiSecretKey *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Trend Micro.
type TrendmicroConnectorProfileProperties struct {
	noSmithyDocumentSerde
}

// The connector metadata specific to Trend Micro.
type TrendmicroMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when using Trend Micro as a flow source.
type TrendmicroSourceProperties struct {

	//  The object specified in the Trend Micro flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

//	The trigger settings that determine how and when Amazon AppFlow runs the
//
// specified flow.
type TriggerConfig struct {

	//  Specifies the type of flow trigger. This can be OnDemand , Scheduled , or Event
	// .
	//
	// This member is required.
	TriggerType TriggerType

	//  Specifies the configuration details of a schedule-triggered flow as defined by
	// the user. Currently, these settings only apply to the Scheduled trigger type.
	TriggerProperties *TriggerProperties

	noSmithyDocumentSerde
}

//	Specifies the configuration details that control the trigger for a flow.
//
// Currently, these settings only apply to the Scheduled trigger type.
type TriggerProperties struct {

	//  Specifies the configuration details of a schedule-triggered flow as defined by
	// the user.
	Scheduled *ScheduledTriggerProperties

	noSmithyDocumentSerde
}

// The properties that are applied when Upsolver is used as a destination.
type UpsolverDestinationProperties struct {

	//  The Upsolver Amazon S3 bucket name in which Amazon AppFlow places the
	// transferred data.
	//
	// This member is required.
	BucketName *string

	//  The configuration that determines how data is formatted when Upsolver is used
	// as the flow destination.
	//
	// This member is required.
	S3OutputFormatConfig *UpsolverS3OutputFormatConfig

	//  The object key for the destination Upsolver Amazon S3 bucket in which Amazon
	// AppFlow places the files.
	BucketPrefix *string

	noSmithyDocumentSerde
}

// The connector metadata specific to Upsolver.
type UpsolverMetadata struct {
	noSmithyDocumentSerde
}

//	The configuration that determines how Amazon AppFlow formats the flow output
//
// data when Upsolver is used as the destination.
type UpsolverS3OutputFormatConfig struct {

	// Specifies elements that Amazon AppFlow includes in the file and folder names in
	// the flow destination.
	//
	// This member is required.
	PrefixConfig *PrefixConfig

	//  The aggregation settings that you can use to customize the output format of
	// your flow data.
	AggregationConfig *AggregationConfig

	//  Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3
	// bucket.
	FileType FileType

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using Veeva.
type VeevaConnectorProfileCredentials struct {

	//  The password that corresponds to the user name.
	//
	// This member is required.
	Password *string

	//  The name of the user.
	//
	// This member is required.
	Username *string

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Veeva.
type VeevaConnectorProfileProperties struct {

	//  The location of the Veeva resource.
	//
	// This member is required.
	InstanceUrl *string

	noSmithyDocumentSerde
}

// The connector metadata specific to Veeva.
type VeevaMetadata struct {
	noSmithyDocumentSerde
}

// The properties that are applied when using Veeva as a flow source.
type VeevaSourceProperties struct {

	//  The object specified in the Veeva flow source.
	//
	// This member is required.
	Object *string

	// The document type specified in the Veeva document extract flow.
	DocumentType *string

	// Boolean value to include All Versions of files in Veeva document extract flow.
	IncludeAllVersions bool

	// Boolean value to include file renditions in Veeva document extract flow.
	IncludeRenditions bool

	// Boolean value to include source files in Veeva document extract flow.
	IncludeSourceFiles bool

	noSmithyDocumentSerde
}

// The connector-specific profile credentials required when using Zendesk.
type ZendeskConnectorProfileCredentials struct {

	//  The identifier for the desired client.
	//
	// This member is required.
	ClientId *string

	//  The client secret used by the OAuth client to authenticate to the
	// authorization server.
	//
	// This member is required.
	ClientSecret *string

	//  The credentials used to access protected Zendesk resources.
	AccessToken *string

	//  The OAuth requirement needed to request security tokens from the connector
	// endpoint.
	OAuthRequest *ConnectorOAuthRequest

	noSmithyDocumentSerde
}

// The connector-specific profile properties required when using Zendesk.
type ZendeskConnectorProfileProperties struct {

	//  The location of the Zendesk resource.
	//
	// This member is required.
	InstanceUrl *string

	noSmithyDocumentSerde
}

// The properties that are applied when Zendesk is used as a destination.
type ZendeskDestinationProperties struct {

	// The object specified in the Zendesk flow destination.
	//
	// This member is required.
	Object *string

	//  The settings that determine how Amazon AppFlow handles an error when placing
	// data in the destination. For example, this setting would determine if the flow
	// should fail after one insertion error, or continue and attempt to insert every
	// record regardless of the initial failure. ErrorHandlingConfig is a part of the
	// destination connector details.
	ErrorHandlingConfig *ErrorHandlingConfig

	//  A list of field names that can be used as an ID field when performing a write
	// operation.
	IdFieldNames []string

	//  The possible write operations in the destination connector. When this value is
	// not provided, this defaults to the INSERT operation.
	WriteOperationType WriteOperationType

	noSmithyDocumentSerde
}

// The connector metadata specific to Zendesk.
type ZendeskMetadata struct {

	//  The desired authorization scope for the Zendesk account.
	OAuthScopes []string

	noSmithyDocumentSerde
}

// The properties that are applied when using Zendesk as a flow source.
type ZendeskSourceProperties struct {

	//  The object specified in the Zendesk flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
