package labservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ImagesClient is the client for the Images methods of the Labservices service.
type ImagesClient struct {
	BaseClient
}

// NewImagesClient creates an instance of the ImagesClient client.
func NewImagesClient(subscriptionID string) ImagesClient {
	return NewImagesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewImagesClientWithBaseURI creates an instance of the ImagesClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewImagesClientWithBaseURI(baseURI string, subscriptionID string) ImagesClient {
	return ImagesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate updates an image resource via PUT. Creating new resources via PUT will not function.
// Parameters:
// body - the request body.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// labPlanName - the name of the lab plan that uniquely identifies it within containing resource group. Used in
// resource URIs and in UI.
// imageName - the image name.
func (client ImagesClient) CreateOrUpdate(ctx context.Context, body Image, resourceGroupName string, labPlanName string, imageName string) (result Image, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ImagesClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: body,
			Constraints: []validation.Constraint{{Target: "body.ImageProperties", Name: validation.Null, Rule: true, Chain: nil}}},
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: labPlanName,
			Constraints: []validation.Constraint{{Target: "labPlanName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "labPlanName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: imageName,
			Constraints: []validation.Constraint{{Target: "imageName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "imageName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "imageName", Name: validation.Pattern, Rule: `^[-\w\\._\\(\\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.ImagesClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, body, resourceGroupName, labPlanName, imageName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.ImagesClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "labservices.ImagesClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.ImagesClient", "CreateOrUpdate", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client ImagesClient) CreateOrUpdatePreparer(ctx context.Context, body Image, resourceGroupName string, labPlanName string, imageName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"imageName":         autorest.Encode("path", imageName),
		"labPlanName":       autorest.Encode("path", labPlanName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	body.SystemData = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labPlans/{labPlanName}/images/{imageName}", pathParameters),
		autorest.WithJSON(body),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client ImagesClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client ImagesClient) CreateOrUpdateResponder(resp *http.Response) (result Image, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get gets an image resource.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// labPlanName - the name of the lab plan that uniquely identifies it within containing resource group. Used in
// resource URIs and in UI.
// imageName - the image name.
func (client ImagesClient) Get(ctx context.Context, resourceGroupName string, labPlanName string, imageName string) (result Image, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ImagesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: labPlanName,
			Constraints: []validation.Constraint{{Target: "labPlanName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "labPlanName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: imageName,
			Constraints: []validation.Constraint{{Target: "imageName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "imageName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "imageName", Name: validation.Pattern, Rule: `^[-\w\\._\\(\\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.ImagesClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, labPlanName, imageName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.ImagesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "labservices.ImagesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.ImagesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client ImagesClient) GetPreparer(ctx context.Context, resourceGroupName string, labPlanName string, imageName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"imageName":         autorest.Encode("path", imageName),
		"labPlanName":       autorest.Encode("path", labPlanName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labPlans/{labPlanName}/images/{imageName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ImagesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ImagesClient) GetResponder(resp *http.Response) (result Image, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByLabPlan gets all images from galleries attached to a lab plan.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// labPlanName - the name of the lab plan that uniquely identifies it within containing resource group. Used in
// resource URIs and in UI.
// filter - the filter to apply to the operation.
func (client ImagesClient) ListByLabPlan(ctx context.Context, resourceGroupName string, labPlanName string, filter string) (result PagedImagesPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ImagesClient.ListByLabPlan")
		defer func() {
			sc := -1
			if result.pi.Response.Response != nil {
				sc = result.pi.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: labPlanName,
			Constraints: []validation.Constraint{{Target: "labPlanName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "labPlanName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.ImagesClient", "ListByLabPlan", err.Error())
	}

	result.fn = client.listByLabPlanNextResults
	req, err := client.ListByLabPlanPreparer(ctx, resourceGroupName, labPlanName, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.ImagesClient", "ListByLabPlan", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByLabPlanSender(req)
	if err != nil {
		result.pi.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "labservices.ImagesClient", "ListByLabPlan", resp, "Failure sending request")
		return
	}

	result.pi, err = client.ListByLabPlanResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.ImagesClient", "ListByLabPlan", resp, "Failure responding to request")
		return
	}
	if result.pi.hasNextLink() && result.pi.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByLabPlanPreparer prepares the ListByLabPlan request.
func (client ImagesClient) ListByLabPlanPreparer(ctx context.Context, resourceGroupName string, labPlanName string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"labPlanName":       autorest.Encode("path", labPlanName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labPlans/{labPlanName}/images", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByLabPlanSender sends the ListByLabPlan request. The method will close the
// http.Response Body if it receives an error.
func (client ImagesClient) ListByLabPlanSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByLabPlanResponder handles the response to the ListByLabPlan request. The method always
// closes the http.Response Body.
func (client ImagesClient) ListByLabPlanResponder(resp *http.Response) (result PagedImages, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByLabPlanNextResults retrieves the next set of results, if any.
func (client ImagesClient) listByLabPlanNextResults(ctx context.Context, lastResults PagedImages) (result PagedImages, err error) {
	req, err := lastResults.pagedImagesPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "labservices.ImagesClient", "listByLabPlanNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByLabPlanSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "labservices.ImagesClient", "listByLabPlanNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByLabPlanResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.ImagesClient", "listByLabPlanNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByLabPlanComplete enumerates all values, automatically crossing page boundaries as required.
func (client ImagesClient) ListByLabPlanComplete(ctx context.Context, resourceGroupName string, labPlanName string, filter string) (result PagedImagesIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ImagesClient.ListByLabPlan")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByLabPlan(ctx, resourceGroupName, labPlanName, filter)
	return
}

// Update updates an image resource.
// Parameters:
// body - the request body.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// labPlanName - the name of the lab plan that uniquely identifies it within containing resource group. Used in
// resource URIs and in UI.
// imageName - the image name.
func (client ImagesClient) Update(ctx context.Context, body ImageUpdate, resourceGroupName string, labPlanName string, imageName string) (result Image, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ImagesClient.Update")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: labPlanName,
			Constraints: []validation.Constraint{{Target: "labPlanName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "labPlanName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: imageName,
			Constraints: []validation.Constraint{{Target: "imageName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "imageName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "imageName", Name: validation.Pattern, Rule: `^[-\w\\._\\(\\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.ImagesClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, body, resourceGroupName, labPlanName, imageName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.ImagesClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "labservices.ImagesClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.ImagesClient", "Update", resp, "Failure responding to request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client ImagesClient) UpdatePreparer(ctx context.Context, body ImageUpdate, resourceGroupName string, labPlanName string, imageName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"imageName":         autorest.Encode("path", imageName),
		"labPlanName":       autorest.Encode("path", labPlanName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labPlans/{labPlanName}/images/{imageName}", pathParameters),
		autorest.WithJSON(body),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client ImagesClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client ImagesClient) UpdateResponder(resp *http.Response) (result Image, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
