# gozerbot/ignore.py
#
#

""" ignore module. """

__copyright__ = 'this file is in the public domain'

# ==============
# IMPORT SECTION

# gozerbot imports
from persist.persist import Persist
from datadir import datadir
from periodical import interval

# basic imports
import time, os, thread

# END IMPORT
# ==========

# ============
# LOCK SECTION

# no locks

# END LOCK
# ========

def addignore(userhost, ttime):

    """
        add ignore based on userhost .. record time when ignore is set.

        :param userhost: userhost to ignore
        :type userhost: string
        :param ttime: duration of the ignore
        :type ttime: integer

        .. literalinclude:: ../../gozerbot/ignore.py
            :pyobject: addignore

    """

    global ignore

    ignore[userhost] = int(ttime)
    timeset[userhost] = time.time()
    
def delignore(userhost):

    """
        remove ignore.

        :param userhost: userhost to remove ignore from
        :type userhost: string
        :rtype: boolean .. whether delete was succesfull

        .. literalinclude:: ../../gozerbot/ignore.py
            :pyobject: delignore

    """

    global ignore

    try:
        del ignore[userhost]
        del timeset[userhost]
        return True
    except KeyError:
        return False

def shouldignore(userhost):

    """
        check if we should ignore.

        :param userhost: userhost to check whether we should ignore it
        :type userhost: string
        :rtype: boolean

        .. literalinclude:: ../../gozerbot/ignore.py
            :pyobject: shouldignore

    """

    try:
        ignoretime = ignore[userhost]
        ignoreset = timeset[userhost]
    except KeyError:
        return False

    if time.time() - ignoretime < ignoreset:
        return True

    return False


@interval(60)
def ignorecheck():

    """
        periodic function to remove users that no longer need to be ignored.

        .. literalinclude:: ../../gozerbot/ignore.py
            :pyobject: ignorecheck

    """

    for userhost in ignore.keys():
        if not shouldignore(userhost):
            delignore(userhost)


# ============
# INIT SECTION

ignore = {}
timeset = {}

# first call to trigger interval
ignorecheck()

# END INIT
# =======