// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKDATABOXMM_MARKERS_H
#define _GTKDATABOXMM_MARKERS_H

#include <gtkdataboxmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (c) 2012  iCub Facility, Istituto Italiano di Tecnologia
 *   @author Daniele E. Domenichelli <daniele.domenichelli@iit.it>
 *
 * This file is part of gtkdataboxmm.
 *
 * gtkdataboxmm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2.1 of the License,
 * or (at your option) any later version.
 *
 * gtkdataboxmm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <gtkdataboxmm/xyc_graph.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkDataboxMarkers GtkDataboxMarkers;
typedef struct _GtkDataboxMarkersClass GtkDataboxMarkersClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace GDatabox
{ class Markers_Class; } // namespace GDatabox
namespace GDatabox
{
   /**
    * MarkersPosition:
    * @DATABOX_MARKERS_C: centered on data
    * @DATABOX_MARKERS_N: marker is positioned north of data
    * @DATABOX_MARKERS_E: marker is positioned east of data
    * @DATABOX_MARKERS_S: marker is positioned south of data
    * @DATABOX_MARKERS_W: marker is positioned west of data
    *
    * Position of a marker relative to its respective X/Y value.
    */
   typedef enum
   {
      DATABOX_MARKERS_C = 0,
      DATABOX_MARKERS_N,
      DATABOX_MARKERS_E,
      DATABOX_MARKERS_S,
      DATABOX_MARKERS_W
   }
   MarkersPosition;

   /**
    * MarkersTextPosition:
    * @DATABOX_MARKERS_TEXT_CENTER:   text centered   on marker
    * @DATABOX_MARKERS_TEXT_N:    text north      of marker
    * @DATABOX_MARKERS_TEXT_NE:   text north-east of marker
    * @DATABOX_MARKERS_TEXT_E:    text east       of marker
    * @DATABOX_MARKERS_TEXT_SE:   text south-east of marker
    * @DATABOX_MARKERS_TEXT_S:    text south      of marker
    * @DATABOX_MARKERS_TEXT_SW:   text south-west of marker
    * @DATABOX_MARKERS_TEXT_W:    text west       of marker
    * @DATABOX_MARKERS_TEXT_NW:       text north-west of marker
    *
    * Position of a label relative to its repective marker.
    */
   typedef enum
   {
      DATABOX_MARKERS_TEXT_CENTER = 0,/* text centered   on marker */
      DATABOX_MARKERS_TEXT_N,     /* text north      of marker */
      DATABOX_MARKERS_TEXT_NE,    /* text north-east of marker */
      DATABOX_MARKERS_TEXT_E,     /* text east       of marker */
      DATABOX_MARKERS_TEXT_SE,    /* text south-east of marker */
      DATABOX_MARKERS_TEXT_S,     /* text south      of marker */
      DATABOX_MARKERS_TEXT_SW,    /* text south-west of marker */
      DATABOX_MARKERS_TEXT_W,     /* text west       of marker */
      DATABOX_MARKERS_TEXT_NW     /* text north-west of marker */
   }
   MarkersTextPosition;

   /**
    * MarkersType:
    * @DATABOX_MARKERS_NONE:    No Marker (just text)
    * @DATABOX_MARKERS_TRIANGLE:    Marker is a triangle
    * @DATABOX_MARKERS_SOLID_LINE:  Marker is a solid line
    * @DATABOX_MARKERS_DASHED_LINE: Marker is a dashed line
    *
    * Type of the marker
    */
   typedef enum
   {
      DATABOX_MARKERS_NONE = 0, /* No Marker (just text) */
      DATABOX_MARKERS_TRIANGLE, /* Marker is a triangle */
      DATABOX_MARKERS_SOLID_LINE,   /* Marker is a solid line */
      DATABOX_MARKERS_DASHED_LINE   /* Marker is a dashed line */
   }
   MarkersType;

//   _WRAP_ENUM(MarkersPosition, GtkDataboxMarkersPosition)
//   _WRAP_ENUM(MarkersTextPosition, GtkDataboxMarkersTextPosition)
//   _WRAP_ENUM(MarkersType, GtkDataboxMarkersType)


class Markers : public XYCGraph
{
    
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Markers CppObjectType;
  typedef Markers_Class CppClassType;
  typedef GtkDataboxMarkers BaseObjectType;
  typedef GtkDataboxMarkersClass BaseClassType;

private:  friend class Markers_Class;
  static CppClassType markers_class_;

private:
  // noncopyable
  Markers(const Markers&);
  Markers& operator=(const Markers&);

protected:
  explicit Markers(const Glib::ConstructParams& construct_params);
  explicit Markers(GtkDataboxMarkers* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Markers();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkDataboxMarkers*       gobj()       { return reinterpret_cast<GtkDataboxMarkers*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkDataboxMarkers* gobj() const { return reinterpret_cast<GtkDataboxMarkers*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkDataboxMarkers* gobj_copy();

private:


protected:
    Markers(unsigned int len, float *X, float *Y, const Gdk::Color &color, unsigned int size = 1);
    

public:
    static Glib::RefPtr<Markers> create(unsigned int length, float * X, float * Y, const Gdk::Color &color, unsigned int size = 1);

// void gtk_databox_markers_set_position (GtkDataboxMarkers * markers, unsigned int index, GtkDataboxMarkersPosition position);
    
  /** Sets a position for one of the markers.
   * @param index Index within the array of X/Y values.
   * @param position Position of the marker (e.g. circle or triangle relative to their X/Y value.
   */
  void set_position(guint index, MarkersPosition position);
//    _WRAP_METHOD(void set_position(unsigned int index, MarkersPosition position), gtk_databox_markers_set_position)
// void gtk_databox_markers_set_label (GtkDataboxMarkers * markers, unsigned int index, MarkersTextPosition label_position, gchar * text, gboolean boxed);
//    _WRAP_METHOD(void set_label(unsigned int index, MarkersTextPosition label_position, string text, bool boxed), gtk_databox_markers_set_label)


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace GDatabox


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates GDatabox::Markers
   */
  Glib::RefPtr<GDatabox::Markers> wrap(GtkDataboxMarkers* object, bool take_copy = false);
}


#endif /* _GTKDATABOXMM_MARKERS_H */

