---
title       : Barcode visualizations using R
subtitle    : Coloring ATCG-sequences in knitr/slidify reports
author      : Markus Skyttner
job         : 
framework   : io2012     # {io2012, html5slides, shower, dzslides, ...}
highlighter : highlight.js  # {highlight.js, prettify, highlight}
hitheme     : tomorrow      # 
widgets     : []            # {mathjax, quiz, bootstrap}
mode        : selfcontained # {standalone, draft}
---


## Reference samples  
Samples kept at the Swedish Museum for Natural History of the [European Roller](http://naturarv.se/?param=dnakey&catalogNumber=20106015) using Cat. id. NRM 20106015 - depicted in the figure to the left - and the [Eurasian Woodcock] (http://naturarv.se/?param=dnakey&catalogNumber=20046331) using Cat. id. NRM  20046331 - the figure to the right - from which some DNA data has been sequenced.   


European Roller | Eurasian Woodcock  
------------- | -------------  
![alt text][id1] | ![alt text][id2]  
**This European Roller flew astray, it is from Ramsberg, north of Lindesberg.** | **This Eurasian Woodcock originates from the Fiby lake outside Uppsala.**

[id1]: blue-bird-small.png "Reference sample of European Roller"
[id2]: brown-bird-small.png "Reference sample of European Woodcock"

----


## The data behind a DNA barcode visualization




DNA sequence data from a European Roller can be expressed like this in text format:
```
CTAATTTTTGGGGCCTGAGCGGGCATGGTTGGAACCGCCCTCAGCCTGCTCATTCGCGCAGAA
CTCGGTCAACCAGGAACCCTACTAGGAGACGACCAGATCTACAACGTAATCGTCACTGCCCAT
GCCTTCGTAATAATCTTCTTTATAGTCATACCAATCATAATCGGGGGCTTTGGAAACTGACTA
GTCCCCCTTATAATCGGCGCCCCAGACATAGCGTTCCCCCGTATAAATAACATAAGCTTCTGA
CTACTCCCCCCATCCTTCCTTCTCCTACTAGCCTCCTCCACCGTAGAAGCTGGTGCTGGTACA
GGGTGAACAGTCTACCCCCCTCTAGCTGGTAATCTGGCCCACGCCGGAGCTTCTGTAGACCTA
GCCATCTTCTCCCTACACCTCGCTGGAGTCTCATCAATCCTAGGTGCAATCAACTTCATCACT
ACTGCCATTAACATAAAGCCCCCGGCCCTATCTCAATACCAAACCCCCCTATTCGTATGATCC
GTACTAATCACAGCCGTCCTACTATTACTTTCACTGCCCGTCCTCGCTGCCGGCATTACAATG
CTCCTCACAGACCGAAACCTAAACACCACATTCTTTGACCCAGCCGGAGGAGGAGACCCAGTC
CTATACCAACACCTATTC
```
  
The problem with this presentation format is that humans are very slow at processing this type of data - we use sequential processing which heavily taxes our working memory, when we could use **pre-attentive processing** to speed up our understanding of this abstract data.

----


## Traditional barcode visualization
Traditionally, DNA sequenced data is therefore displayed in a colorful format using thin bars of four different colors representing the A, C, T and G symbols in the DNA sequence data. That way, an illusive similarity with product barcodes is constructed. 

Such a classic traditional barcode depiction looks like this for these two sample sequences:

![plot of chunk unnamed-chunk-2](assets/fig/unnamed-chunk-21.png) ![plot of chunk unnamed-chunk-2](assets/fig/unnamed-chunk-22.png) 


This presentation format can compress a lot of data into one line, provided there are enough pixels available. However, it sacrifices clear display of individual symbols, because bars are so thin that they can barely be distinguished. And what happens when the sequence length is greater than available pixel width?

Can you think of alternative ways to display the same data that fixes some of the problems above?

----

<pre style="font-family: monospace;">
<span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><br/><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><br/><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><br/><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><br/><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><br/><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><br/><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><br/><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><br/><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><br/><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><br/><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span>
</pre>

<span title="a" style="color:#fb9a99;">█</span> (red) = A  
<span title="c" style="color:#a6cee3;">█</span> (blue) = C  
<span title="t" style="color:#b2df8a;">█</span> (green) = T  
<span title="g" style="color:#fdbf6f;">█</span> (yellow) = G  
<span title="unknown" style="color:#252525;">█</span> (unknown) = N  

----


## Looking at 3rd position symbols only
This is a classic barcode illustration over symbols in the 3rd position only. It so happens that a lot of differences between sequences happen in this 3rd position. 

The illustration below emphasizes the big picture overview but it makes it hard to spot exactly where indvidual differences occur: 

![plot of chunk unnamed-chunk-3](assets/fig/unnamed-chunk-31.png) ![plot of chunk unnamed-chunk-3](assets/fig/unnamed-chunk-32.png) 


----

### European Roller:  

<pre style="font-family: monospace;">
<span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><br/><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><br/><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><br/><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span>
</pre>

### Eurasian woodcock:

<pre style="font-family: monospace;">
<span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><br/><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><br/><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><br/><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span>
</pre>

<span title="A" style="color:#e31a1c;">█</span> (red) = A  
<span title="C" style="color:#1f78b4;">█</span> (blue) = C  
<span title="T" style="color:#33a02c;">█</span> (green) = T  
<span title="G" style="color:#ff7f00;">█</span> (yellow) = G  

As you can see, when we use a multi-line display it is hard to spot the differences because positions are still not easily aligned so comparisons become slow and cognitively difficult to make. How can we support that task in a better way?  

----

## Using a pairwise multi-line row-wrapped display
Light gray markings are used to accentuate pairwise differences pre-attentively:  
<pre style="font-family: monospace;">
<span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><br/><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><br/><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><br/><br/><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><br/><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><br/><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><br/><br/><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><br/><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><br/><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><br/><br/><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><br/><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><br/><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span>
</pre>

With this technique no heavy cognitive hit is required to spot where the differences occur.

----

## Non-position-3-symbols  
Shown in the traditional way:  

![plot of chunk unnamed-chunk-4](assets/fig/unnamed-chunk-41.png) ![plot of chunk unnamed-chunk-4](assets/fig/unnamed-chunk-42.png) 


In this display we see that the barcodes are quite similar. 

Maybe we even wonder if there are any differences at all there? But we cannot say, or can we?

As a side remark on colors: Colors used for the traditional barcode display are not well chosen. It is better to use perceptually friendly colors - and to avoid "RGB corners". Look at Color Brewer [http://www.colorbrewer2.org] for guidance!

----

## Non-position-3 data  
Displayed as separate color-coded row-wrapped multi-line paragraphs
<pre style="font-family: monospace;">
<span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><br/><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><br/><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><br/><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><br/><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><br/><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><br/><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span>
</pre>
<pre style="font-family: monospace;">
<span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><br/><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><br/><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><br/><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><br/><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><br/><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><br/><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span>
</pre>

Still quite impossible to see whether there are any differences, right?

----

<pre style="font-family: monospace;">
<span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><br/><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><br/><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="T" style="color:#33a02c;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><br/><br/><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><br/><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><br/><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><br/><br/><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><br/><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><br/><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="T" style="color:#33a02c;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="T" style="color:#33a02c;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="T" style="color:#33a02c;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><br/><br/><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="T" style="color:#33a02c;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><br/><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><br/><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="T" style="color:#33a02c;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><br/><br/><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><br/><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><br/><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="T" style="color:#33a02c;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="t" style="color:#b2df8a;">█</span>
</pre>

Now we can see where the differences are!

----

## Pos3data - to mute similarities or differences?
<pre style="font-family: monospace;">
<span title="a" style="color:#fb9a99;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="T" style="color:#33a02c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="T" style="color:#33a02c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><br/><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><br/><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="T" style="color:#33a02c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="g" style="color:#fdbf6f;">█</span><span title="T" style="color:#33a02c;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="T" style="color:#33a02c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="T" style="color:#33a02c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="T" style="color:#33a02c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="T" style="color:#33a02c;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="T" style="color:#33a02c;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="T" style="color:#33a02c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="T" style="color:#33a02c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="T" style="color:#33a02c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><br/><br/><span title="c" style="color:#a6cee3;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="T" style="color:#33a02c;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="T" style="color:#33a02c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><br/><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><br/><span title="c" style="color:#a6cee3;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><br/><br/><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="T" style="color:#33a02c;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="T" style="color:#33a02c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="g" style="color:#fdbf6f;">█</span><br/><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><br/><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="T" style="color:#33a02c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="T" style="color:#33a02c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="G" style="color:#ff7f00;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="T" style="color:#33a02c;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="g" style="color:#fdbf6f;">█</span><br/><br/><span title="C" style="color:#1f78b4;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="c" style="color:#a6cee3;">█</span><br/><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="no match" style="color:#ffffff;">█</span><span title="match" style="color:#636363;">█</span><span title="match" style="color:#636363;">█</span><span title="no match" style="color:#ffffff;">█</span><br/><span title="A" style="color:#e31a1c;">█</span><span title="A" style="color:#e31a1c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="T" style="color:#33a02c;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="t" style="color:#b2df8a;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="c" style="color:#a6cee3;">█</span><span title="a" style="color:#fb9a99;">█</span><span title="T" style="color:#33a02c;">█</span><span title="C" style="color:#1f78b4;">█</span><span title="c" style="color:#a6cee3;">█</span>
</pre>

However, as you can see in this example, this technique using muting can be a little bit confusing when the foreground and the background are more or less equally represented - muting works less well in that case and color pairs can be harder to distinguish.

----

## Numerical similarity measures


The Levenshtein-distance (the "edit distance" measuring least number of edit operations necessary to go from one string to another) is 99. 
For symbols in the third position only, the same measure is 89.
The measure for remaining symbols (ie in non-3rd-positions) is 7.

### Similarity measure

The Levenshtein similarity measure can be calculated and is defined on the interval [0,1] where 0 indicates the highest level of dissimilarity and consequently **1 denotes highest possible similarity** between two strings of symbols.

For symbols in the 3rd position, we get the measure 0.588. 
For symbols in other positions, we get a significantly higher similarity mesaure: 0.9838

