#include <vector>
#import <Cocoa/Cocoa.h>

#define kCCIDPath @"/usr/libexec/SmartCardServices/drivers/ifd-ccid.bundle/Contents/info.plist"
#define kCCIDBackupPath @"/usr/libexec/SmartCardServices/drivers/ifd-ccid.bundle/Contents/info_backup.plist"

int main(int argc, char *argv[])
{
	NSAutoreleasePool*		nspool = [[NSAutoreleasePool alloc] init];
	
	@try
	{
		// make a backup copy of the ifd-ccid.bundle file
		[[NSFileManager defaultManager] copyItemAtPath:kCCIDPath toPath:kCCIDBackupPath error:nil];
		
		UInt32								index=0;
		std::vector<UInt32>		indexList;
		BOOL									infoDictChanged=NO;
		NSMutableDictionary*	infoDict=[NSMutableDictionary dictionaryWithContentsOfFile:kCCIDPath];
		for (NSString* key in [infoDict objectForKey:@"ifdVendorID"])
		{
			if ([key isEqualToString:@"0x0C4B"]) indexList.push_back(index);
			index++;
		}
		
		for (UInt32 i=indexList.size()-1;i<=0;i--)
		{
			#if DEBUG
			NSLog(@"Removing vendor '%@' at index %d",[[infoDict objectForKey:@"ifdVendorID"] objectAtIndex:indexList[i]],indexList[i]);
			#endif
			
			[[infoDict objectForKey:@"ifdVendorID"] removeObjectAtIndex:indexList[i]];
			
			#if DEBUG
			NSLog(@"Removing product ID '%@' at index %d",[[infoDict objectForKey:@"ifdProductID"] objectAtIndex:indexList[i]],indexList[i]);
			#endif
			
			[[infoDict objectForKey:@"ifdProductID"] removeObjectAtIndex:indexList[i]];

			#if DEBUG
			NSLog(@"Removing friendly name '%@' at index %d",[[infoDict objectForKey:@"ifdFriendlyName"] objectAtIndex:indexList[i]],indexList[i]);
			#endif
			
			[[infoDict objectForKey:@"ifdFriendlyName"] removeObjectAtIndex:indexList[i]];
			
			infoDictChanged=YES;
		}
		
		if (infoDictChanged && ![infoDict writeToFile:kCCIDPath atomically:false]) NSLog(@"Error while writing file %@",kCCIDPath);
	}
	@catch(id anything)
	{
	}
	
	[nspool release];
}
