#ifndef LISTWIDGETITEM_HEADER
#define LISTWIDGETITEM_HEADER

/***************************************************************************
 *   Copyright (C) 2009 by Kai Dombrowe <just89@gmx.de>                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#include <QGraphicsWidget>
#include <KIcon>

class QGraphicsSceneHoverEvent;
class QGraphicsSceneMouseEvent;
class QPainter;
class QStyleOptionGraphicsItem;
class QWidget;
namespace Plasma {
    class FrameSvg;
};
class ListWidgetItem : public QGraphicsWidget
{
    Q_OBJECT


enum State {
    Normal = 0,
    Hover = 1,
    Run = 2,
    Edit = 3,
    Remove = 4
};

    public:
        ListWidgetItem(QGraphicsWidget *parent = 0);
        ~ListWidgetItem();

        QString title() const;
        int rating() const;
        QString icon() const;
        bool X() const;
        QString command() const;
        bool isSelected() const;
        

    public slots:
        void setTitle(const QString &newTitle);
        void setRating(const int &newRating);
        void setIcon(const QString &newIcon);
        void setX(const bool &newX);
        void setCommand(const QString& newCommand);
        void setSelected(const bool &select);


    protected slots:
        void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0 );
        void hoverEnterEvent(QGraphicsSceneHoverEvent *event);
        void hoverLeaveEvent(QGraphicsSceneHoverEvent *event);
        void hoverMoveEvent(QGraphicsSceneHoverEvent *event);
        void mousePressEvent(QGraphicsSceneMouseEvent *event);
        void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);
        void mouseMoveEvent(QGraphicsSceneMouseEvent *event);
        
        
    private:
        Plasma::FrameSvg *m_backgroundSvg;
        Plasma::FrameSvg *m_hoverSvg;
        Plasma::FrameSvg *m_selectionSvg;
        QString m_title;
        int m_rating;
        QString m_icon;
        bool m_x;
        QString m_command;
        ListWidgetItem::State m_state;
        bool m_isSelected;
        QRectF m_runRect;
        QPixmap m_runPixmap;
        QRectF m_editRect;
        QPixmap m_editPixmap;
        QRectF m_removeRect;
        QPixmap m_removePixmap;
        int m_hoverRating;
        QRectF m_ratingRect;
        bool m_dragStarted;
        QPointF m_lastPos;
        
    
    private slots:
        void calcSize();
        
        
    signals:
        void run();
        void edit();
        void remove();
        void selected();
        
        
};


#endif
