package burnpal

import (
	"image/color"
)

// Palette is a slice of NRGBA colors
type Palette []color.NRGBA

// Pal is the default palette from the open source drawing program
// named "Burn". https://burn.sf.net/
var Pal = Palette{
	{0x0, 0x0, 0x0, 0xFF},    // 0
	{0x50, 0x50, 0x50, 0xFF}, // 1
	{0x88, 0x88, 0x88, 0xFF}, // 2
	{0x0, 0x0, 0x0, 0xFF},    // 3
	{0x8, 0x8, 0x8, 0xFF},    // 4
	{0x10, 0x10, 0x10, 0xFF}, // 5
	{0x18, 0x18, 0x18, 0xFF}, // 6
	{0x24, 0x24, 0x24, 0xFF}, // 7
	{0x2C, 0x2C, 0x2C, 0xFF}, // 8
	{0x34, 0x34, 0x34, 0xFF}, // 9
	{0x3C, 0x3C, 0x3C, 0xFF}, // 10
	{0x48, 0x48, 0x48, 0xFF}, // 11
	{0x50, 0x50, 0x50, 0xFF}, // 12
	{0x58, 0x58, 0x58, 0xFF}, // 13
	{0x60, 0x60, 0x60, 0xFF}, // 14
	{0x6C, 0x6C, 0x6C, 0xFF}, // 15
	{0x74, 0x74, 0x74, 0xFF}, // 16
	{0x7C, 0x7C, 0x7C, 0xFF}, // 17
	{0x84, 0x84, 0x84, 0xFF}, // 18
	{0x90, 0x90, 0x90, 0xFF}, // 19
	{0x98, 0x98, 0x98, 0xFF}, // 20
	{0xA0, 0xA0, 0xA0, 0xFF}, // 21
	{0xA8, 0xA8, 0xA8, 0xFF}, // 22
	{0xB4, 0xB4, 0xB4, 0xFF}, // 23
	{0xBC, 0xBC, 0xBC, 0xFF}, // 24
	{0xC4, 0xC4, 0xC4, 0xFF}, // 25
	{0xCC, 0xCC, 0xCC, 0xFF}, // 26
	{0xD8, 0xD8, 0xD8, 0xFF}, // 27
	{0xE0, 0xE0, 0xE0, 0xFF}, // 28
	{0xE8, 0xE8, 0xE8, 0xFF}, // 29
	{0xF0, 0xF0, 0xF0, 0xFF}, // 30
	{0xFC, 0xFC, 0xFC, 0xFF}, // 31
	{0xFC, 0xFC, 0xFC, 0xFF}, // 32
	{0xFC, 0xF0, 0xF0, 0xFF}, // 33
	{0xFC, 0xE8, 0xE8, 0xFF}, // 34
	{0xFC, 0xE0, 0xE0, 0xFF}, // 35
	{0xFC, 0xD8, 0xD8, 0xFF}, // 36
	{0xFC, 0xD0, 0xD0, 0xFF}, // 37
	{0xFC, 0xC8, 0xC8, 0xFF}, // 38
	{0xFC, 0xC0, 0xC0, 0xFF}, // 39
	{0xFC, 0xB8, 0xB8, 0xFF}, // 40
	{0xFC, 0xB0, 0xB0, 0xFF}, // 41
	{0xFC, 0xA8, 0xA8, 0xFF}, // 42
	{0xFC, 0xA0, 0xA0, 0xFF}, // 43
	{0xFC, 0x98, 0x98, 0xFF}, // 44
	{0xFC, 0x90, 0x90, 0xFF}, // 45
	{0xFC, 0x88, 0x88, 0xFF}, // 46
	{0xFC, 0x80, 0x80, 0xFF}, // 47
	{0xFC, 0x78, 0x78, 0xFF}, // 48
	{0xFC, 0x70, 0x70, 0xFF}, // 49
	{0xFC, 0x68, 0x68, 0xFF}, // 50
	{0xFC, 0x60, 0x60, 0xFF}, // 51
	{0xFC, 0x58, 0x58, 0xFF}, // 52
	{0xFC, 0x50, 0x50, 0xFF}, // 53
	{0xFC, 0x48, 0x48, 0xFF}, // 54
	{0xFC, 0x40, 0x40, 0xFF}, // 55
	{0xFC, 0x38, 0x38, 0xFF}, // 56
	{0xFC, 0x30, 0x30, 0xFF}, // 57
	{0xFC, 0x28, 0x28, 0xFF}, // 58
	{0xFC, 0x20, 0x20, 0xFF}, // 59
	{0xFC, 0x18, 0x18, 0xFF}, // 60
	{0xFC, 0x10, 0x10, 0xFF}, // 61
	{0xFC, 0x8, 0x8, 0xFF},   // 62
	{0xFC, 0x0, 0x0, 0xFF},   // 63
	{0xFC, 0x0, 0x0, 0xFF},   // 64
	{0xFC, 0x8, 0x0, 0xFF},   // 65
	{0xFC, 0x10, 0x0, 0xFF},  // 66
	{0xFC, 0x18, 0x0, 0xFF},  // 67
	{0xFC, 0x20, 0x0, 0xFF},  // 68
	{0xFC, 0x28, 0x0, 0xFF},  // 69
	{0xFC, 0x30, 0x0, 0xFF},  // 70
	{0xFC, 0x38, 0x0, 0xFF},  // 71
	{0xFC, 0x40, 0x0, 0xFF},  // 72
	{0xFC, 0x48, 0x0, 0xFF},  // 73
	{0xFC, 0x50, 0x0, 0xFF},  // 74
	{0xFC, 0x58, 0x0, 0xFF},  // 75
	{0xFC, 0x60, 0x0, 0xFF},  // 76
	{0xFC, 0x68, 0x0, 0xFF},  // 77
	{0xFC, 0x70, 0x0, 0xFF},  // 78
	{0xFC, 0x78, 0x0, 0xFF},  // 79
	{0xFC, 0x80, 0x0, 0xFF},  // 80
	{0xFC, 0x88, 0x0, 0xFF},  // 81
	{0xFC, 0x90, 0x0, 0xFF},  // 82
	{0xFC, 0x98, 0x0, 0xFF},  // 83
	{0xFC, 0xA0, 0x0, 0xFF},  // 84
	{0xFC, 0xA8, 0x0, 0xFF},  // 85
	{0xFC, 0xB0, 0x0, 0xFF},  // 86
	{0xFC, 0xB8, 0x0, 0xFF},  // 87
	{0xFC, 0xC0, 0x0, 0xFF},  // 88
	{0xFC, 0xC8, 0x0, 0xFF},  // 89
	{0xFC, 0xD0, 0x0, 0xFF},  // 90
	{0xFC, 0xD8, 0x0, 0xFF},  // 91
	{0xFC, 0xE0, 0x0, 0xFF},  // 92
	{0xFC, 0xE8, 0x0, 0xFF},  // 93
	{0xFC, 0xF0, 0x0, 0xFF},  // 94
	{0xFC, 0xFC, 0x0, 0xFF},  // 95
	{0xFC, 0xFC, 0x0, 0xFF},  // 96
	{0xF0, 0xF8, 0x4, 0xFF},  // 97
	{0xE8, 0xF4, 0x8, 0xFF},  // 98
	{0xE0, 0xF0, 0xC, 0xFF},  // 99
	{0xD8, 0xEC, 0x10, 0xFF}, // 100
	{0xD0, 0xE8, 0x14, 0xFF}, // 101
	{0xC8, 0xE4, 0x18, 0xFF}, // 102
	{0xC0, 0xE0, 0x1C, 0xFF}, // 103
	{0xB8, 0xDC, 0x20, 0xFF}, // 104
	{0xB0, 0xD8, 0x24, 0xFF}, // 105
	{0xA8, 0xD4, 0x28, 0xFF}, // 106
	{0xA0, 0xD0, 0x2C, 0xFF}, // 107
	{0x98, 0xCC, 0x30, 0xFF}, // 108
	{0x90, 0xC8, 0x34, 0xFF}, // 109
	{0x88, 0xC4, 0x38, 0xFF}, // 110
	{0x80, 0xC0, 0x3C, 0xFF}, // 111
	{0x78, 0xBC, 0x40, 0xFF}, // 112
	{0x70, 0xB8, 0x44, 0xFF}, // 113
	{0x68, 0xB4, 0x48, 0xFF}, // 114
	{0x60, 0xB0, 0x4C, 0xFF}, // 115
	{0x58, 0xAC, 0x50, 0xFF}, // 116
	{0x50, 0xA8, 0x54, 0xFF}, // 117
	{0x48, 0xA4, 0x58, 0xFF}, // 118
	{0x40, 0xA0, 0x5C, 0xFF}, // 119
	{0x38, 0x9C, 0x60, 0xFF}, // 120
	{0x30, 0x98, 0x64, 0xFF}, // 121
	{0x28, 0x94, 0x68, 0xFF}, // 122
	{0x20, 0x90, 0x6C, 0xFF}, // 123
	{0x18, 0x8C, 0x70, 0xFF}, // 124
	{0x10, 0x88, 0x74, 0xFF}, // 125
	{0x8, 0x84, 0x78, 0xFF},  // 126
	{0x0, 0x80, 0x80, 0xFF},  // 127
	{0x0, 0x80, 0x80, 0xFF},  // 128
	{0x0, 0x7C, 0x84, 0xFF},  // 129
	{0x4, 0x7C, 0x88, 0xFF},  // 130
	{0x4, 0x78, 0x8C, 0xFF},  // 131
	{0x8, 0x78, 0x90, 0xFF},  // 132
	{0xC, 0x78, 0x94, 0xFF},  // 133
	{0xC, 0x74, 0x98, 0xFF},  // 134
	{0x10, 0x74, 0x9C, 0xFF}, // 135
	{0x14, 0x70, 0xA0, 0xFF}, // 136
	{0x14, 0x70, 0xA4, 0xFF}, // 137
	{0x18, 0x70, 0xA8, 0xFF}, // 138
	{0x1C, 0x6C, 0xAC, 0xFF}, // 139
	{0x1C, 0x6C, 0xB0, 0xFF}, // 140
	{0x20, 0x68, 0xB4, 0xFF}, // 141
	{0x24, 0x68, 0xB8, 0xFF}, // 142
	{0x24, 0x68, 0xBC, 0xFF}, // 143
	{0x28, 0x64, 0xC0, 0xFF}, // 144
	{0x28, 0x64, 0xC4, 0xFF}, // 145
	{0x2C, 0x64, 0xC8, 0xFF}, // 146
	{0x30, 0x60, 0xCC, 0xFF}, // 147
	{0x30, 0x60, 0xD0, 0xFF}, // 148
	{0x34, 0x5C, 0xD4, 0xFF}, // 149
	{0x38, 0x5C, 0xD8, 0xFF}, // 150
	{0x38, 0x5C, 0xDC, 0xFF}, // 151
	{0x3C, 0x58, 0xE0, 0xFF}, // 152
	{0x40, 0x58, 0xE4, 0xFF}, // 153
	{0x40, 0x54, 0xE8, 0xFF}, // 154
	{0x44, 0x54, 0xEC, 0xFF}, // 155
	{0x48, 0x54, 0xF0, 0xFF}, // 156
	{0x48, 0x50, 0xF4, 0xFF}, // 157
	{0x4C, 0x50, 0xF8, 0xFF}, // 158
	{0x50, 0x50, 0xFC, 0xFF}, // 159
	{0x50, 0x50, 0xFC, 0xFF}, // 160
	{0x54, 0x54, 0xF8, 0xFF}, // 161
	{0x58, 0x58, 0xF8, 0xFF}, // 162
	{0x60, 0x60, 0xF4, 0xFF}, // 163
	{0x64, 0x64, 0xF4, 0xFF}, // 164
	{0x68, 0x68, 0xF0, 0xFF}, // 165
	{0x70, 0x70, 0xF0, 0xFF}, // 166
	{0x74, 0x74, 0xF0, 0xFF}, // 167
	{0x7C, 0x7C, 0xEC, 0xFF}, // 168
	{0x80, 0x80, 0xEC, 0xFF}, // 169
	{0x84, 0x84, 0xE8, 0xFF}, // 170
	{0x8C, 0x8C, 0xE8, 0xFF}, // 171
	{0x90, 0x90, 0xE4, 0xFF}, // 172
	{0x98, 0x98, 0xE4, 0xFF}, // 173
	{0x9C, 0x9C, 0xE4, 0xFF}, // 174
	{0xA0, 0xA0, 0xE0, 0xFF}, // 175
	{0xA8, 0xA8, 0xE0, 0xFF}, // 176
	{0xAC, 0xAC, 0xDC, 0xFF}, // 177
	{0xB0, 0xB0, 0xDC, 0xFF}, // 178
	{0xB8, 0xB8, 0xDC, 0xFF}, // 179
	{0xBC, 0xBC, 0xD8, 0xFF}, // 180
	{0xC4, 0xC4, 0xD8, 0xFF}, // 181
	{0xC8, 0xC8, 0xD4, 0xFF}, // 182
	{0xCC, 0xCC, 0xD4, 0xFF}, // 183
	{0xD4, 0xD4, 0xD0, 0xFF}, // 184
	{0xD8, 0xD8, 0xD0, 0xFF}, // 185
	{0xE0, 0xE0, 0xD0, 0xFF}, // 186
	{0xE4, 0xE4, 0xCC, 0xFF}, // 187
	{0xE8, 0xE8, 0xCC, 0xFF}, // 188
	{0xF0, 0xF0, 0xC8, 0xFF}, // 189
	{0xF4, 0xF4, 0xC8, 0xFF}, // 190
	{0xFC, 0xFC, 0xC8, 0xFF}, // 191
	{0xFC, 0xFC, 0xC8, 0xFF}, // 192
	{0xF8, 0xF0, 0xC0, 0xFF}, // 193
	{0xF4, 0xE8, 0xB8, 0xFF}, // 194
	{0xF0, 0xE0, 0xB4, 0xFF}, // 195
	{0xEC, 0xD8, 0xAC, 0xFF}, // 196
	{0xE8, 0xD0, 0xA4, 0xFF}, // 197
	{0xE4, 0xC8, 0xA0, 0xFF}, // 198
	{0xE0, 0xC0, 0x98, 0xFF}, // 199
	{0xDC, 0xB8, 0x94, 0xFF}, // 200
	{0xD8, 0xB0, 0x8C, 0xFF}, // 201
	{0xD4, 0xA8, 0x84, 0xFF}, // 202
	{0xD0, 0xA0, 0x80, 0xFF}, // 203
	{0xCC, 0x98, 0x78, 0xFF}, // 204
	{0xC8, 0x90, 0x74, 0xFF}, // 205
	{0xC4, 0x88, 0x6C, 0xFF}, // 206
	{0xC0, 0x80, 0x64, 0xFF}, // 207
	{0xBC, 0x78, 0x60, 0xFF}, // 208
	{0xB8, 0x70, 0x58, 0xFF}, // 209
	{0xB4, 0x68, 0x50, 0xFF}, // 210
	{0xB0, 0x60, 0x4C, 0xFF}, // 211
	{0xAC, 0x58, 0x44, 0xFF}, // 212
	{0xA8, 0x50, 0x40, 0xFF}, // 213
	{0xA4, 0x48, 0x38, 0xFF}, // 214
	{0xA0, 0x40, 0x30, 0xFF}, // 215
	{0x9C, 0x38, 0x2C, 0xFF}, // 216
	{0x98, 0x30, 0x24, 0xFF}, // 217
	{0x94, 0x28, 0x20, 0xFF}, // 218
	{0x90, 0x20, 0x18, 0xFF}, // 219
	{0x8C, 0x18, 0x10, 0xFF}, // 220
	{0x88, 0x10, 0xC, 0xFF},  // 221
	{0x84, 0x8, 0x4, 0xFF},   // 222
	{0x80, 0x0, 0x0, 0xFF},   // 223
	{0x80, 0x0, 0x0, 0xFF},   // 224
	{0x84, 0xC, 0x10, 0xFF},  // 225
	{0x88, 0x18, 0x20, 0xFF}, // 226
	{0x90, 0x28, 0x30, 0xFF}, // 227
	{0x94, 0x34, 0x40, 0xFF}, // 228
	{0x98, 0x44, 0x54, 0xFF}, // 229
	{0xA0, 0x50, 0x64, 0xFF}, // 230
	{0xA4, 0x60, 0x74, 0xFF}, // 231
	{0xA8, 0x6C, 0x84, 0xFF}, // 232
	{0xB0, 0x7C, 0x94, 0xFF}, // 233
	{0xB4, 0x88, 0xA8, 0xFF}, // 234
	{0xB8, 0x98, 0xB8, 0xFF}, // 235
	{0xC0, 0xA4, 0xC8, 0xFF}, // 236
	{0xC4, 0xB4, 0xD8, 0xFF}, // 237
	{0xC8, 0xC0, 0xE8, 0xFF}, // 238
	{0xD0, 0xD0, 0xFC, 0xFF}, // 239
	{0xD0, 0xD0, 0xFC, 0xFF}, // 240
	{0xC0, 0xC0, 0xE8, 0xFF}, // 241
	{0xB4, 0xB4, 0xD8, 0xFF}, // 242
	{0xA4, 0xA4, 0xC8, 0xFF}, // 243
	{0x98, 0x98, 0xB8, 0xFF}, // 244
	{0x88, 0x88, 0xA4, 0xFF}, // 245
	{0x7C, 0x7C, 0x94, 0xFF}, // 246
	{0x6C, 0x6C, 0x84, 0xFF}, // 247
	{0x60, 0x60, 0x74, 0xFF}, // 248
	{0x50, 0x50, 0x64, 0xFF}, // 249
	{0x44, 0x44, 0x50, 0xFF}, // 250
	{0x34, 0x34, 0x40, 0xFF}, // 251
	{0x28, 0x28, 0x30, 0xFF}, // 252
	{0x18, 0x18, 0x20, 0xFF}, // 253
	{0xC, 0xC, 0x10, 0xFF},   // 254
	{0x0, 0x0, 0x0, 0xFF},    // 255
}
