'''OpenGL extension ARB.seamless_cube_map

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.seamless_cube_map to provide a more 
Python-friendly API

Overview (from the spec)
	
	When sampling from cube map textures, a three-dimensional texture
	coordinate is used to select one of the cube map faces and generate
	a two dimensional texture coordinate ( s t ), at which a texel is
	sampled from the determined face of the cube map texture. Each face
	of the texture is treated as an independent two-dimensional texture,
	and the generated ( s t ) coordinate is subjected to the same
	clamping and wrapping rules as for any other two dimensional texture
	fetch.
	
	Although it is unlikely that the generated ( s t ) coordinate lies
	significantly outside the determined cube map face, it is often the
	case that the locations of the individual elements required during a
	linear sampling do not lie within the determined face, and their
	coordinates will therefore be modified by the selected clamping and
	wrapping rules. This often has the effect of producing seams or
	other discontinuities in the sampled texture.
	
	This extension allows implementations to take samples from adjacent
	cube map faces, providing the ability to create seamless cube maps.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/seamless_cube_map.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.ARB.seamless_cube_map import *
### END AUTOGENERATED SECTION