'''OpenGL extension QCOM.render_sRGB_R8_RG8

This module customises the behaviour of the 
OpenGL.raw.GLES2.QCOM.render_sRGB_R8_RG8 to provide a more 
Python-friendly API

Overview (from the spec)
	
	OpenGL ES 3.2 supports an sRGB formats SR8 and SRG8 which are not color-renderable.
	
	This extension enables the sRGB formats SR8 and SRG8 to be color-renderable using
	framebuffer objects.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/QCOM/render_sRGB_R8_RG8.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.QCOM.render_sRGB_R8_RG8 import *
from OpenGL.raw.GLES2.QCOM.render_sRGB_R8_RG8 import _EXTENSION_NAME

def glInitRenderSrgbR8Rg8QCOM():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION