# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobErrorDetails(Model):
    """The job error information containing the list of job errors.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar error_details: The error details.
    :vartype error_details: list[~azure.mgmt.edgegateway.models.JobErrorItem]
    :ivar code: The code intended for programmatic access.
    :vartype code: str
    :ivar message: The message that describes the error in detail.
    :vartype message: str
    """

    _validation = {
        'error_details': {'readonly': True},
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'error_details': {'key': 'errorDetails', 'type': '[JobErrorItem]'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(JobErrorDetails, self).__init__(**kwargs)
        self.error_details = None
        self.code = None
        self.message = None
