# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AccessIdName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ACCESS = "access"
    GIT_ACCESS = "gitAccess"

class AlwaysLog(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies for what type of messages sampling settings should not apply.
    """

    #: Always log all erroneous request regardless of sampling settings.
    ALL_ERRORS = "allErrors"

class ApiManagementSkuCapacityScaleType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The scale type applicable to the sku.
    """

    AUTOMATIC = "Automatic"
    MANUAL = "Manual"
    NONE = "None"

class ApiManagementSkuRestrictionsReasonCode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The reason for restriction.
    """

    QUOTA_ID = "QuotaId"
    NOT_AVAILABLE_FOR_SUBSCRIPTION = "NotAvailableForSubscription"

class ApiManagementSkuRestrictionsType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of restrictions.
    """

    LOCATION = "Location"
    ZONE = "Zone"

class ApimIdentityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes
    both an implicitly created identity and a set of user assigned identities. The type 'None' will
    remove any identities from the service.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"

class ApiType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of API.
    """

    HTTP = "http"
    SOAP = "soap"

class ApiVersionSetContractDetailsVersioningScheme(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An value that determines where the API Version identifier will be located in a HTTP request.
    """

    SEGMENT = "Segment"
    QUERY = "Query"
    HEADER = "Header"

class AppType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    #: User create request was sent by legacy developer portal.
    PORTAL = "portal"
    #: User create request was sent by new developer portal.
    DEVELOPER_PORTAL = "developerPortal"

class AsyncOperationStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Status of an async operation.
    """

    STARTED = "Started"
    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"

class AuthorizationMethod(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    HEAD = "HEAD"
    OPTIONS = "OPTIONS"
    TRACE = "TRACE"
    GET = "GET"
    POST = "POST"
    PUT = "PUT"
    PATCH = "PATCH"
    DELETE = "DELETE"

class BackendProtocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Backend communication protocol.
    """

    #: The Backend is a RESTful service.
    HTTP = "http"
    #: The Backend is a SOAP service.
    SOAP = "soap"

class BearerTokenSendingMethod(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    AUTHORIZATION_HEADER = "authorizationHeader"
    QUERY = "query"

class BearerTokenSendingMethods(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Form of an authorization grant, which the client uses to request the access token.
    """

    #: Access token will be transmitted in the Authorization header using Bearer schema.
    AUTHORIZATION_HEADER = "authorizationHeader"
    #: Access token will be transmitted as query parameters.
    QUERY = "query"

class CertificateConfigurationStoreName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The System.Security.Cryptography.x509certificates.StoreName certificate store location. Only
    Root and CertificateAuthority are valid locations.
    """

    CERTIFICATE_AUTHORITY = "CertificateAuthority"
    ROOT = "Root"

class ClientAuthenticationMethod(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    #: Basic Client Authentication method.
    BASIC = "Basic"
    #: Body based Authentication method.
    BODY = "Body"

class ConfigurationIdName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    CONFIGURATION = "configuration"

class Confirmation(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Determines the type of confirmation e-mail that will be sent to the newly created user.
    """

    #: Send an e-mail to the user confirming they have successfully signed up.
    SIGNUP = "signup"
    #: Send an e-mail inviting the user to sign-up and complete registration.
    INVITE = "invite"

class ConnectivityStatusType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource Connectivity Status Type identifier.
    """

    INITIALIZING = "initializing"
    SUCCESS = "success"
    FAILURE = "failure"

class ContentFormat(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Format of the Content in which the API is getting imported.
    """

    #: The contents are inline and Content type is a WADL document.
    WADL_XML = "wadl-xml"
    #: The WADL document is hosted on a publicly accessible internet address.
    WADL_LINK_JSON = "wadl-link-json"
    #: The contents are inline and Content Type is a OpenAPI 2.0 JSON Document.
    SWAGGER_JSON = "swagger-json"
    #: The OpenAPI 2.0 JSON document is hosted on a publicly accessible internet address.
    SWAGGER_LINK_JSON = "swagger-link-json"
    #: The contents are inline and the document is a WSDL/Soap document.
    WSDL = "wsdl"
    #: The WSDL document is hosted on a publicly accessible internet address.
    WSDL_LINK = "wsdl-link"
    #: The contents are inline and Content Type is a OpenAPI 3.0 YAML Document.
    OPENAPI = "openapi"
    #: The contents are inline and Content Type is a OpenAPI 3.0 JSON Document.
    OPENAPI_JSON = "openapi+json"
    #: The OpenAPI 3.0 YAML document is hosted on a publicly accessible internet address.
    OPENAPI_LINK = "openapi-link"
    #: The OpenAPI 3.0 JSON document is hosted on a publicly accessible internet address.
    OPENAPI_JSON_LINK = "openapi+json-link"

class DataMaskingMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Data masking mode.
    """

    #: Mask the value of an entity.
    MASK = "Mask"
    #: Hide the presence of an entity.
    HIDE = "Hide"

class ExportApi(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    TRUE = "true"

class ExportFormat(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    #: Export the Api Definition in OpenAPI 2.0 Specification as JSON document to the Storage Blob.
    SWAGGER = "swagger-link"
    #: Export the Api Definition in WSDL Schema to Storage Blob. This is only supported for APIs of
    #: Type ``soap``.
    WSDL = "wsdl-link"
    #: Export the Api Definition in WADL Schema to Storage Blob.
    WADL = "wadl-link"
    #: Export the Api Definition in OpenAPI 3.0 Specification as YAML document to Storage Blob.
    OPENAPI = "openapi-link"
    #: Export the Api Definition in OpenAPI 3.0 Specification as JSON document to Storage Blob.
    OPENAPI_JSON = "openapi+json-link"

class ExportResultFormat(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Format in which the Api Details are exported to the Storage Blob with Sas Key valid for 5
    minutes.
    """

    #: The Api Definition is exported in OpenApi Specification 2.0 format to the Storage Blob.
    SWAGGER = "swagger-link-json"
    #: The Api Definition is exported in WSDL Schema to Storage Blob. This is only supported for APIs
    #: of Type ``soap``.
    WSDL = "wsdl-link+xml"
    #: Export the Api Definition in WADL Schema to Storage Blob.
    WADL = "wadl-link-json"
    #: Export the Api Definition in OpenApi Specification 3.0 to Storage Blob.
    OPEN_API = "openapi-link"

class GrantType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    #: Authorization Code Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.1.
    AUTHORIZATION_CODE = "authorizationCode"
    #: Implicit Code Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.2.
    IMPLICIT = "implicit"
    #: Resource Owner Password Grant flow as described
    #: https://tools.ietf.org/html/rfc6749#section-4.3.
    RESOURCE_OWNER_PASSWORD = "resourceOwnerPassword"
    #: Client Credentials Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.4.
    CLIENT_CREDENTIALS = "clientCredentials"

class GroupType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Group type.
    """

    CUSTOM = "custom"
    SYSTEM = "system"
    EXTERNAL = "external"

class HostnameType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Hostname type.
    """

    PROXY = "Proxy"
    PORTAL = "Portal"
    MANAGEMENT = "Management"
    SCM = "Scm"
    DEVELOPER_PORTAL = "DeveloperPortal"

class HttpCorrelationProtocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Sets correlation protocol to use for Application Insights diagnostics.
    """

    #: Do not read and inject correlation headers.
    NONE = "None"
    #: Inject Request-Id and Request-Context headers with request correlation data. See
    #: https://github.com/dotnet/corefx/blob/master/src/System.Diagnostics.DiagnosticSource/src/HttpCorrelationProtocol.md.
    LEGACY = "Legacy"
    #: Inject Trace Context headers. See https://w3c.github.io/trace-context.
    W3_C = "W3C"

class IdentityProviderType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    #: Facebook as Identity provider.
    FACEBOOK = "facebook"
    #: Google as Identity provider.
    GOOGLE = "google"
    #: Microsoft Live as Identity provider.
    MICROSOFT = "microsoft"
    #: Twitter as Identity provider.
    TWITTER = "twitter"
    #: Azure Active Directory as Identity provider.
    AAD = "aad"
    #: Azure Active Directory B2C as Identity provider.
    AAD_B2_C = "aadB2C"

class KeyType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The Key to be used to generate token for user.
    """

    PRIMARY = "primary"
    SECONDARY = "secondary"

class LoggerType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Logger type.
    """

    #: Azure Event Hub as log destination.
    AZURE_EVENT_HUB = "azureEventHub"
    #: Azure Application Insights as log destination.
    APPLICATION_INSIGHTS = "applicationInsights"
    #: Azure Monitor.
    AZURE_MONITOR = "azureMonitor"

class NameAvailabilityReason(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Invalid indicates the name provided does not match the resource provider’s naming requirements
    (incorrect length, unsupported characters, etc.)  AlreadyExists indicates that the name is
    already in use and is therefore unavailable.
    """

    VALID = "Valid"
    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"

class NotificationName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    #: The following email recipients and users will receive email notifications about subscription
    #: requests for API products requiring approval.
    REQUEST_PUBLISHER_NOTIFICATION_MESSAGE = "RequestPublisherNotificationMessage"
    #: The following email recipients and users will receive email notifications about new API product
    #: subscriptions.
    PURCHASE_PUBLISHER_NOTIFICATION_MESSAGE = "PurchasePublisherNotificationMessage"
    #: The following email recipients and users will receive email notifications when new applications
    #: are submitted to the application gallery.
    NEW_APPLICATION_NOTIFICATION_MESSAGE = "NewApplicationNotificationMessage"
    #: The following recipients will receive blind carbon copies of all emails sent to developers.
    BCC = "BCC"
    #: The following email recipients and users will receive email notifications when a new issue or
    #: comment is submitted on the developer portal.
    NEW_ISSUE_PUBLISHER_NOTIFICATION_MESSAGE = "NewIssuePublisherNotificationMessage"
    #: The following email recipients and users will receive email notifications when developer closes
    #: his account.
    ACCOUNT_CLOSED_PUBLISHER = "AccountClosedPublisher"
    #: The following email recipients and users will receive email notifications when subscription
    #: usage gets close to usage quota.
    QUOTA_LIMIT_APPROACHING_PUBLISHER_NOTIFICATION_MESSAGE = "QuotaLimitApproachingPublisherNotificationMessage"

class OperationNameFormat(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The format of the Operation Name for Application Insights telemetries. Default is Name.
    """

    #: API_NAME;rev=API_REVISION - OPERATION_NAME.
    NAME = "Name"
    #: HTTP_VERB URL.
    URL = "Url"

class PolicyContentFormat(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Format of the policyContent.
    """

    #: The contents are inline and Content type is an XML document.
    XML = "xml"
    #: The policy XML document is hosted on a http endpoint accessible from the API Management
    #: service.
    XML_LINK = "xml-link"
    #: The contents are inline and Content type is a non XML encoded policy document.
    RAWXML = "rawxml"
    #: The policy document is not Xml encoded and is hosted on a http endpoint accessible from the API
    #: Management service.
    RAWXML_LINK = "rawxml-link"

class PolicyExportFormat(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    #: The contents are inline and Content type is an XML document.
    XML = "xml"
    #: The contents are inline and Content type is a non XML encoded policy document.
    RAWXML = "rawxml"

class PolicyIdName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    POLICY = "policy"

class PolicyScopeContract(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    TENANT = "Tenant"
    PRODUCT = "Product"
    API = "Api"
    OPERATION = "Operation"
    ALL = "All"

class PortalRevisionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Portal revision publishing status
    """

    #: Portal revision publishing is pending.
    PENDING = "pending"
    #: Portal revision is publishing.
    PUBLISHING = "publishing"
    #: Portal revision publishing completed.
    COMPLETED = "completed"
    #: Portal revision publishing failed.
    FAILED = "failed"

class ProductState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """whether product is published or not. Published products are discoverable by users of developer
    portal. Non published products are visible only to administrators. Default state of Product is
    notPublished.
    """

    NOT_PUBLISHED = "notPublished"
    PUBLISHED = "published"

class Protocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    HTTP = "http"
    HTTPS = "https"

class ResourceSkuCapacityScaleType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The scale type applicable to the sku.
    """

    #: Supported scale type automatic.
    AUTOMATIC = "automatic"
    #: Supported scale type manual.
    MANUAL = "manual"
    #: Scaling not supported.
    NONE = "none"

class SamplingType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Sampling type.
    """

    #: Fixed-rate sampling.
    FIXED = "fixed"

class SettingsTypeName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    PUBLIC = "public"

class SkuType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Name of the Sku.
    """

    #: Developer SKU of Api Management.
    DEVELOPER = "Developer"
    #: Standard SKU of Api Management.
    STANDARD = "Standard"
    #: Premium SKU of Api Management.
    PREMIUM = "Premium"
    #: Basic SKU of Api Management.
    BASIC = "Basic"
    #: Consumption SKU of Api Management.
    CONSUMPTION = "Consumption"
    #: Isolated SKU of Api Management.
    ISOLATED = "Isolated"

class SoapApiType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of Api to create.
    
    
    * ``http`` creates a SOAP to REST API
    * ``soap`` creates a SOAP pass-through API .
    """

    #: Imports a SOAP API having a RESTful front end.
    SOAP_TO_REST = "http"
    #: Imports the Soap API having a SOAP front end.
    SOAP_PASS_THROUGH = "soap"

class State(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Status of the issue.
    """

    #: The issue is proposed.
    PROPOSED = "proposed"
    #: The issue is opened.
    OPEN = "open"
    #: The issue was removed.
    REMOVED = "removed"
    #: The issue is now resolved.
    RESOLVED = "resolved"
    #: The issue was closed.
    CLOSED = "closed"

class SubscriptionState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Subscription state. Possible states are * active – the subscription is active, * suspended –
    the subscription is blocked, and the subscriber cannot call any APIs of the product, *
    submitted – the subscription request has been made by the developer, but has not yet been
    approved or rejected, * rejected – the subscription request has been denied by an
    administrator, * cancelled – the subscription has been cancelled by the developer or
    administrator, * expired – the subscription reached its expiration date and was deactivated.
    """

    SUSPENDED = "suspended"
    ACTIVE = "active"
    EXPIRED = "expired"
    SUBMITTED = "submitted"
    REJECTED = "rejected"
    CANCELLED = "cancelled"

class TemplateName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    APPLICATION_APPROVED_NOTIFICATION_MESSAGE = "applicationApprovedNotificationMessage"
    ACCOUNT_CLOSED_DEVELOPER = "accountClosedDeveloper"
    QUOTA_LIMIT_APPROACHING_DEVELOPER_NOTIFICATION_MESSAGE = "quotaLimitApproachingDeveloperNotificationMessage"
    NEW_DEVELOPER_NOTIFICATION_MESSAGE = "newDeveloperNotificationMessage"
    EMAIL_CHANGE_IDENTITY_DEFAULT = "emailChangeIdentityDefault"
    INVITE_USER_NOTIFICATION_MESSAGE = "inviteUserNotificationMessage"
    NEW_COMMENT_NOTIFICATION_MESSAGE = "newCommentNotificationMessage"
    CONFIRM_SIGN_UP_IDENTITY_DEFAULT = "confirmSignUpIdentityDefault"
    NEW_ISSUE_NOTIFICATION_MESSAGE = "newIssueNotificationMessage"
    PURCHASE_DEVELOPER_NOTIFICATION_MESSAGE = "purchaseDeveloperNotificationMessage"
    PASSWORD_RESET_IDENTITY_DEFAULT = "passwordResetIdentityDefault"
    PASSWORD_RESET_BY_ADMIN_NOTIFICATION_MESSAGE = "passwordResetByAdminNotificationMessage"
    REJECT_DEVELOPER_NOTIFICATION_MESSAGE = "rejectDeveloperNotificationMessage"
    REQUEST_DEVELOPER_NOTIFICATION_MESSAGE = "requestDeveloperNotificationMessage"

class UserState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Account state. Specifies whether the user is active or not. Blocked users are unable to sign
    into the developer portal or call any APIs of subscribed products. Default state is Active.
    """

    #: User state is active.
    ACTIVE = "active"
    #: User is blocked. Blocked users cannot authenticate at developer portal or call API.
    BLOCKED = "blocked"
    #: User account is pending. Requires identity confirmation before it can be made active.
    PENDING = "pending"
    #: User account is closed. All identities and related entities are removed.
    DELETED = "deleted"

class Verbosity(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The verbosity level applied to traces emitted by trace policies.
    """

    #: All the traces emitted by trace policies will be sent to the logger attached to this diagnostic
    #: instance.
    VERBOSE = "verbose"
    #: Traces with 'severity' set to 'information' and 'error' will be sent to the logger attached to
    #: this diagnostic instance.
    INFORMATION = "information"
    #: Only traces with 'severity' set to 'error' will be sent to the logger attached to this
    #: diagnostic instance.
    ERROR = "error"

class VersioningScheme(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An value that determines where the API Version identifier will be located in a HTTP request.
    """

    #: The API Version is passed in a path segment.
    SEGMENT = "Segment"
    #: The API Version is passed in a query parameter.
    QUERY = "Query"
    #: The API Version is passed in a HTTP header.
    HEADER = "Header"

class VirtualNetworkType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of VPN in which API Management service needs to be configured in. None (Default Value)
    means the API Management service is not part of any Virtual Network, External means the API
    Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint,
    and Internal means that API Management deployment is setup inside a Virtual Network having an
    Intranet Facing Endpoint only.
    """

    #: The service is not part of any Virtual Network.
    NONE = "None"
    #: The service is part of Virtual Network and it is accessible from Internet.
    EXTERNAL = "External"
    #: The service is part of Virtual Network and it is only accessible from within the virtual
    #: network.
    INTERNAL = "Internal"
