# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ACLAction(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Default action when no other rule matches
    """

    ALLOW = "Allow"
    DENY = "Deny"

class CreatedByType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class KeyType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The keyType to regenerate. Must be either 'primary' or 'secondary'(case-insensitive).
    """

    PRIMARY = "Primary"
    SECONDARY = "Secondary"
    SALT = "Salt"

class ManagedIdentityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Represent the identity type: systemAssigned, userAssigned, None
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"

class PrivateLinkServiceConnectionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates whether the connection has been Approved/Rejected/Removed by the owner of the
    service.
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning state of the resource.
    """

    UNKNOWN = "Unknown"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    RUNNING = "Running"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    MOVING = "Moving"

class ScaleType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The scale type applicable to the sku.
    """

    NONE = "None"
    MANUAL = "Manual"
    AUTOMATIC = "Automatic"

class SharedPrivateLinkResourceStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Status of the shared private link resource
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"
    TIMEOUT = "Timeout"

class UpstreamAuthType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Gets or sets the type of auth. None or ManagedIdentity is supported now.
    """

    NONE = "None"
    MANAGED_IDENTITY = "ManagedIdentity"

class WebPubSubRequestType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Allowed request types. The value can be one or more of: ClientConnection, ServerConnection,
    RESTAPI.
    """

    CLIENT_CONNECTION = "ClientConnection"
    SERVER_CONNECTION = "ServerConnection"
    RESTAPI = "RESTAPI"
    TRACE = "Trace"

class WebPubSubSkuTier(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Optional tier of this particular SKU. 'Standard' or 'Free'.
    
    ``Basic`` is deprecated, use ``Standard`` instead.
    """

    FREE = "Free"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"
