# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient

from .. import models as _models
from .._serialization import Deserializer, Serializer
from ._configuration import IoTFirmwareDefenseMgmtClientConfiguration
from .operations import (
    BinaryHardeningOperations,
    CryptoCertificatesOperations,
    CryptoKeysOperations,
    CvesOperations,
    FirmwaresOperations,
    Operations,
    PasswordHashesOperations,
    SbomComponentsOperations,
    SummariesOperations,
    WorkspacesOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential


class IoTFirmwareDefenseMgmtClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Firmware & IoT Security REST API.

    :ivar binary_hardening: BinaryHardeningOperations operations
    :vartype binary_hardening:
     azure.mgmt.iotfirmwaredefense.aio.operations.BinaryHardeningOperations
    :ivar crypto_certificates: CryptoCertificatesOperations operations
    :vartype crypto_certificates:
     azure.mgmt.iotfirmwaredefense.aio.operations.CryptoCertificatesOperations
    :ivar crypto_keys: CryptoKeysOperations operations
    :vartype crypto_keys: azure.mgmt.iotfirmwaredefense.aio.operations.CryptoKeysOperations
    :ivar cves: CvesOperations operations
    :vartype cves: azure.mgmt.iotfirmwaredefense.aio.operations.CvesOperations
    :ivar firmwares: FirmwaresOperations operations
    :vartype firmwares: azure.mgmt.iotfirmwaredefense.aio.operations.FirmwaresOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.iotfirmwaredefense.aio.operations.Operations
    :ivar password_hashes: PasswordHashesOperations operations
    :vartype password_hashes: azure.mgmt.iotfirmwaredefense.aio.operations.PasswordHashesOperations
    :ivar sbom_components: SbomComponentsOperations operations
    :vartype sbom_components: azure.mgmt.iotfirmwaredefense.aio.operations.SbomComponentsOperations
    :ivar summaries: SummariesOperations operations
    :vartype summaries: azure.mgmt.iotfirmwaredefense.aio.operations.SummariesOperations
    :ivar workspaces: WorkspacesOperations operations
    :vartype workspaces: azure.mgmt.iotfirmwaredefense.aio.operations.WorkspacesOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription. The value must be an UUID. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2024-01-10". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = IoTFirmwareDefenseMgmtClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.binary_hardening = BinaryHardeningOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.crypto_certificates = CryptoCertificatesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.crypto_keys = CryptoKeysOperations(self._client, self._config, self._serialize, self._deserialize)
        self.cves = CvesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.firmwares = FirmwaresOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.password_hashes = PasswordHashesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.sbom_components = SbomComponentsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.summaries = SummariesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.workspaces = WorkspacesOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "IoTFirmwareDefenseMgmtClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
