# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.hardwaresecuritymodules import HardwareSecurityModulesMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestHardwareSecurityModulesMgmtCloudHsmClustersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(HardwareSecurityModulesMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_or_update(self, resource_group):
        response = self.client.cloud_hsm_clusters.begin_create_or_update(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
            location="str",
            api_version="2024-06-30-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_update(self, resource_group):
        response = self.client.cloud_hsm_clusters.begin_update(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
            api_version="2024-06-30-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.cloud_hsm_clusters.get(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
            api_version="2024-06-30-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.cloud_hsm_clusters.begin_delete(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
            api_version="2024-06-30-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_resource_group(self, resource_group):
        response = self.client.cloud_hsm_clusters.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-06-30-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_subscription(self, resource_group):
        response = self.client.cloud_hsm_clusters.list_by_subscription(
            api_version="2024-06-30-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_validate_backup_properties(self, resource_group):
        response = self.client.cloud_hsm_clusters.begin_validate_backup_properties(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
            api_version="2024-06-30-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_backup(self, resource_group):
        response = self.client.cloud_hsm_clusters.begin_backup(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
            api_version="2024-06-30-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_validate_restore_properties(self, resource_group):
        response = self.client.cloud_hsm_clusters.begin_validate_restore_properties(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
            api_version="2024-06-30-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_restore(self, resource_group):
        response = self.client.cloud_hsm_clusters.begin_restore(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
            restore_request_properties={"azureStorageBlobContainerUri": "str", "backupId": "str", "token": "str"},
            api_version="2024-06-30-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
