/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.model;

public final class Multiplicity {
    public final int min;
    public final Integer max;
    public static final Multiplicity ZERO = new Multiplicity(0, 0);
    public static final Multiplicity ONE = new Multiplicity(1, 1);
    public static final Multiplicity OPTIONAL = new Multiplicity(0, 1);
    public static final Multiplicity STAR = new Multiplicity(0, null);
    public static final Multiplicity PLUS = new Multiplicity(1, null);

    public static Multiplicity create(int min, Integer max) {
        if (min == 0 && max == null) {
            return STAR;
        }
        if (min == 1 && max == null) {
            return PLUS;
        }
        if (max != null) {
            if (min == 0 && max == 0) {
                return ZERO;
            }
            if (min == 0 && max == 1) {
                return OPTIONAL;
            }
            if (min == 1 && max == 1) {
                return ONE;
            }
        }
        return new Multiplicity(min, max);
    }

    private Multiplicity(int min, Integer max) {
        this.min = min;
        this.max = max;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Multiplicity)) {
            return false;
        }
        Multiplicity that = (Multiplicity)o;
        if (this.min != that.min) {
            return false;
        }
        return !(this.max != null ? !this.max.equals(that.max) : that.max != null);
    }

    public int hashCode() {
        int result = this.min;
        result = 29 * result + (this.max != null ? this.max.hashCode() : 0);
        return result;
    }

    public boolean isUnique() {
        if (this.max == null) {
            return false;
        }
        return this.min == 1 && this.max == 1;
    }

    public boolean isOptional() {
        if (this.max == null) {
            return false;
        }
        return this.min == 0 && this.max == 1;
    }

    public boolean isAtMostOnce() {
        if (this.max == null) {
            return false;
        }
        return this.max <= 1;
    }

    public boolean isZero() {
        if (this.max == null) {
            return false;
        }
        return this.max == 0;
    }

    public boolean includes(Multiplicity rhs) {
        if (rhs.min < this.min) {
            return false;
        }
        if (this.max == null) {
            return true;
        }
        if (rhs.max == null) {
            return false;
        }
        return rhs.max <= this.max;
    }

    public String getMaxString() {
        if (this.max == null) {
            return "unbounded";
        }
        return this.max.toString();
    }

    public String toString() {
        return "(" + this.min + ',' + this.getMaxString() + ')';
    }

    public static Multiplicity choice(Multiplicity lhs, Multiplicity rhs) {
        return Multiplicity.create(Math.min(lhs.min, rhs.min), lhs.max == null || rhs.max == null ? null : Integer.valueOf(Math.max(lhs.max, rhs.max)));
    }

    public static Multiplicity group(Multiplicity lhs, Multiplicity rhs) {
        return Multiplicity.create(lhs.min + rhs.min, lhs.max == null || rhs.max == null ? null : Integer.valueOf(lhs.max + rhs.max));
    }

    public static Multiplicity multiply(Multiplicity lhs, Multiplicity rhs) {
        int min = lhs.min * rhs.min;
        Object max = Multiplicity.isZero(lhs.max) || Multiplicity.isZero(rhs.max) ? Integer.valueOf(0) : (lhs.max == null || rhs.max == null ? null : Integer.valueOf(lhs.max * rhs.max));
        return Multiplicity.create(min, (Integer)max);
    }

    private static boolean isZero(Integer i) {
        return i != null && i == 0;
    }

    public static Multiplicity oneOrMore(Multiplicity c) {
        if (c.max == null) {
            return c;
        }
        if (c.max == 0) {
            return c;
        }
        return Multiplicity.create(c.min, null);
    }

    public Multiplicity makeOptional() {
        if (this.min == 0) {
            return this;
        }
        return Multiplicity.create(0, this.max);
    }

    public Multiplicity makeRepeated() {
        if (this.max == null || this.max == 0) {
            return this;
        }
        return Multiplicity.create(this.min, null);
    }
}

