/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.LayoutStyle;
import javax.swing.text.JTextComponent;
import jsyntaxpane.actions.ActionUtils;

public class GotoLineDialog
extends JDialog {
    private JTextComponent text;
    private JButton jBtnOk;
    private JComboBox jCmbLineNumbers;

    public GotoLineDialog(JTextComponent text) {
        super(ActionUtils.getFrameFor(text), false);
        this.initComponents();
        this.text = text;
        this.setLocationRelativeTo(text.getRootPane());
    }

    private void initComponents() {
        this.jCmbLineNumbers = new JComboBox();
        this.jBtnOk = new JButton();
        this.setTitle("Goto Line");
        this.setModal(true);
        this.setName("");
        this.setResizable(false);
        this.jCmbLineNumbers.setEditable(true);
        this.jCmbLineNumbers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GotoLineDialog.this.jCmbLineNumbersActionPerformed(evt);
            }
        });
        this.jBtnOk.setText("Go");
        this.jBtnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GotoLineDialog.this.jBtnOkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jCmbLineNumbers, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBtnOk, -1, 47, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCmbLineNumbers, -2, -1, -2).addComponent(this.jBtnOk)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jBtnOkActionPerformed(ActionEvent evt) {
        this.setTextPos();
    }

    private void setTextPos() {
        Object line = this.jCmbLineNumbers.getSelectedItem();
        if (line != null) {
            try {
                int lineNr = Integer.parseInt(line.toString());
                int pos = ActionUtils.getDocumentPosition(this.text, lineNr, 0);
                ActionUtils.insertIntoCombo(this.jCmbLineNumbers, line);
                this.text.setCaretPosition(pos);
                this.setVisible(false);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "Invalid Number: " + line, "Number Error", 0);
            }
        }
    }

    private void jCmbLineNumbersActionPerformed(ActionEvent evt) {
        this.setTextPos();
    }
}

