FRR accords
===========


This directory contains some text documents with "accords" agreed upon by the
FRR community.  The idea here is that by passing text documents through the
PR/review process, consensus for work items, design decisions, etc. can be
established and documented.  They can also be changed later by followup PRs if
consensus shifts.  This is intended to reduce friction, and provide more
transparency for newcomers & less frequent contributors.

Examples of things that could go here:

- agreement on how to fix some deeper-seated existing shortcoming in FRR that
  might take some time to fix, to get consensus before putting time into it.

- larger design (especially system/package integration) decisions that are not
  immediately tangible to the code.

- scoping decisions, particularly negative (i.e. we decided at some point that
  FRR is not the right place for something) - these are otherwise lost in some
  ancient closed PR, and some new contributor might be unaware and waste time.

Files in this directory are not formatted in any specific way and not rendered
into documentation.  They're intended to be read with your code editor of
choice.

To avoid misunderstandings, there is one "rule" about wording:  the consensus
actual is worded with "will", "going to", "is" - this reflects the idea that
when the PR is merged, it *is* community consensus.  Words like "should",
"would" or "might" should be limited to context and reference that is provided
as rationale for the consensus.
